package com.agilex.healthcare.mobilehealthplatform.auth.provider;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class StaffLoginController{
	
	@RequestMapping(value = "/login", method = RequestMethod.GET)
	public ModelAndView displayLoginPage(@RequestParam(value = "error", required = false) boolean error,
			HttpServletRequest req, ModelMap model) {

		constructErrorMessageIfErrorExists(model, error);
		constructLoginPageContents(model);

		return new ModelAndView("userLogin", model);
	}

	@RequestMapping(value = "/denied", method = RequestMethod.GET)
	public ModelAndView getLoginPage(HttpServletRequest req, ModelMap model) {

		model.put("error", "You have entered an invalid access code or verify code!");
		constructLoginPageContents(model);

		return new ModelAndView("userLogin", model);
	}

	private void constructErrorMessageIfErrorExists(ModelMap model, boolean error) {
		if (error == true) {
			model.put("error", "You have entered an invalid access code or verify code!");
		} else {
			model.put("error", "");
		}
	}

	private void constructLoginPageContents(ModelMap model) {
		model.put("haMode", "provider");
		model.put("vistaLocation", "");
	}
}
