package com.agilex.healthcare.mobilehealthplatform.auth.provider;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.authentication.AuthenticationDetailsSource;

import com.agilex.healthcare.mobilehealthplatform.provider.auth.StaffFacilityInfo;



public class StaffAuthenticationDetailsSource implements AuthenticationDetailsSource<HttpServletRequest, StaffFacilityInfo> {
	public StaffFacilityInfo buildDetails(HttpServletRequest context) {
		String facilityName = (String) context.getParameter("facilityName");
		String facilityCode = (String) context.getParameter("facilityCode");
		
		StaffFacilityInfo result = new StaffFacilityInfo();
		result.setFacilityCode(facilityCode);
		result.setFacilityName(facilityName);
		
		return result;
	}
}
