package com.agilex.healthcare.mobilehealthplatform.security.infrastructure;

import java.util.Map;

/**
 * Represents a resource location.  Minimal interface required to support this lib.
 */
public class Resource {
    private final String location;

    public Resource() {
        location = "";
    }

    public Resource(String location) {
        assert location != null;

        this.location = location;
    }

    public boolean denied() {
        return "".equals(location) || location.contains("/denied");
    }

    //Except something like: http://localhost:8080/AuthorizationServices/oauth/mhplaunchpad:;jsessionid=jMVTT1wBsJ52Nxp0prRnN1PP4FfGJwKNtL8Rt9nMJLctsrR3Gqkh!-2081395744?code=lv04tG&state=mystateid
    //for location.
    public Value getCode() {
        String codeParam = null;

        if (!"".equals(location) || location.contains("code=")) {
            String paramList = location.substring(location.indexOf("?") + 1);
            codeParam = getCodeValue(paramList);
        }

        return createCode(codeParam);
    }

    private String getCodeValue(String paramList) {
        String[] params = paramList.split("&");

        for (String param : params)
            if (param.contains("code="))
                return param.substring(param.indexOf("=") + 1);

        return null;
    }

    private Value createCode(String value) {
        if (value == null)
            return new Value();

        return new Value(value);
    }

    //Information hiding methods below. Don't expose private location.

    public HttpClientResponse get(HttpClient httpClient) {
        return httpClient.get(location);
    }

    public HttpClientResponse post(HttpClient httpClient, Map<String, String> params) {
        return httpClient.post(params, location);
    }

    public void delete(HttpClient httpClient, Value token) {
        httpClient.delete(location, token.toString());
    }
}

