package com.agilex.healthcare.mobilehealthplatform.security.infrastructure;

import org.apache.http.*;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.*;
import org.apache.http.impl.client.*;
import org.apache.http.message.BasicNameValuePair;

import java.io.IOException;
import java.util.*;

/**
 * Used to make all http(s) calls. Wraps apache's http client.
 */
public class HttpClient {
    private final String baseUri;
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().disableRedirectHandling().build();

    public HttpClient(String baseUri) {
        this.baseUri = baseUri;
    }

    public void delete(String uri, String token) {
        HttpDelete httpDelete = new HttpDelete(getResourceUri(uri));
        httpDelete.addHeader("Authorization", "Bearer " + token);

        executeRequest(httpDelete);
    }

    public HttpClientResponse get(String uri) {
        HttpGet httpGet = new HttpGet(getResourceUri(uri));

        return executeRequest(httpGet);
    }

    public HttpClientResponse post(Map<String, String> formParameters, String uri) {
        HttpPost httpPost = new HttpPost(getResourceUri(uri));

        setFormParameters(formParameters, httpPost);

        return executeRequest(httpPost);
    }

    private String getResourceUri(String uri) {
        if (uri.startsWith(baseUri))
            return uri;
        else
            return baseUri + uri;
    }

    private void setFormParameters(Map<String, String> formParameters, HttpPost httppost) {
        List<NameValuePair> formParams = new ArrayList<NameValuePair>();

        for (Map.Entry<String, String> entry : formParameters.entrySet()) {
            formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }

        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
        httppost.setEntity(entity);
    }

    private HttpClientResponse executeRequest(HttpRequestBase request) {
        CloseableHttpResponse response;

        try {
            response = httpClient.execute(request);
        } catch (Exception e) {
            throw new RuntimeException("Unable to execute request of type: " + request.getClass(), e);
        }

        return new HttpClientResponse(response);
    }

    public void close() {
        try {
            httpClient.close();
        } catch (IOException e) {
            throw new RuntimeException("Unable to client http client.", e);
        }
    }
}
