package com.agilex.healthcare.mobilehealthplatform.security;

import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.HttpClient;
import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.Value;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * Add a Description.  Should include class purpose (why not what) and assumptions.
 */
public class VeteranClientTests {

    private static final String HOST_URI = "http://localhost:8080";
    private static final String REDIRECT_URI = "http://localhost:8080/launchpad/";
    private static final String VETERAN_AUTHORIZE_BASE_URI = "/ssoeproxy/veteran";
    private static final String VETERAN_SECURITY_BASE_URI = "/ssoeproxy";

    @Test
    public void getAccessTokenForVeteran() {
        HttpClient httpClient = new HttpClient(HOST_URI);

        ClientIdentification clientIdentification = new ClientIdentification("LAUNCHPAD", "launchPad", REDIRECT_URI);
        Client client = Client.createClient(httpClient, clientIdentification, VETERAN_AUTHORIZE_BASE_URI);
        User veteran = new User(httpClient, "zztest.patient01", "pass", VETERAN_SECURITY_BASE_URI);

        Value code = client.authorize(veteran);
        Value token = client.getAccessToken(code);

        //Use Token in Authorization header on calls to your REST resources
        //Key: Authorization , Value: Bearer e89e3ddd-7c9d-48aa-9ed3-27420b964894

        //System.out.println("Token: " + token.toString());

        assertTrue(token.toString().length() > 0);

        client.logoutAndCloseConnection(veteran, token);

    }

    @Test
    public void getAccessTokenForInvalidVeteran() {
        HttpClient httpClient = new HttpClient(HOST_URI);

        ClientIdentification clientIdentification = new ClientIdentification("LAUNCHPAD", "launchPad", REDIRECT_URI);
        Client client = Client.createClient(httpClient, clientIdentification, VETERAN_AUTHORIZE_BASE_URI);
        User veteran = new User(httpClient, "invalid_patient", "pass", VETERAN_SECURITY_BASE_URI);

        try {
            Value code = client.authorize(veteran);
        } catch (RuntimeException r) {
            assertEquals("Unable to log in user.  Make sure user credentials are correct.", r.getMessage());
        }
    }

}
