package com.agilex.healthcare.mobilehealthplatform.security;

import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.*;

/**
 * Represents something like a browser which is mediator between the client and the authentication service.
 *
 * Attempts to get a grant token from the authorization service.  If it fails then it tries to log in the user.
 * If the login is success it retries the grant request.
 */
public class UserAgent {

    private final HttpClient httpClient;

    public UserAgent(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Value authorize(Resource grantResource, User user) {
        HttpClientResponse initialResponse = grantResource.get(httpClient);
        Value code = initialResponse.getCode();

        if (code.isSet())
            return code;

        HttpClientResponse grantResponse = login(user);
        code = grantResponse.getCode();

        if (!code.isSet())
            throw new RuntimeException("Code not retrieve grant code.");

        return code;
    }

    private HttpClientResponse login(User user) {
        Resource loginRedirectResource = user.login();

        if (loginRedirectResource.denied())
            throw new RuntimeException("Unable to log in user.  Make sure user credentials are correct.");

        //2nd attempt to get grant code.  Should succeed if user log in was successful.
        return loginRedirectResource.get(httpClient);
    }
}

