package com.agilex.healthcare.mobilehealthplatform.security;

import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.*;
import java.util.*;

/**
 * Represents an authentication services.  This usually a 3rd party like DSLogin or Facebook.
 *
 * We are using the mock veteran and staff authentication services here.
 */
public class User {
    private static final String VETERAN_LOGIN_URI = "/j_spring_security_check";
    private static final String STAFF_LOGIN_URI = "/security_check";
    private static final String VETERAN_LOGOUT_URI = "/logout";
    private static final String STAFF_LOGOUT_URI = "/logout";

    private final HttpClient httpClient;
    private final String userId;
    private final String password;
    private final String facilityCode;
    private final String facilityName;

    private final String baseUri;

    public User(HttpClient httpClient, String userId, String password, String baseUri) {
        this(httpClient, userId, password, "", "", baseUri);
    }

    public User(HttpClient httpClient, String userId, String password, String facilityCode, String facilityName, String baseUri) {
        this.httpClient = httpClient;
        this.userId = userId;
        this.password = password;
        this.facilityCode = facilityCode;
        this.facilityName = facilityName;
        this.baseUri = baseUri;
    }

    /**
     * May generate a resource with a blank uri or one with denied in the uri.  In either case, login failed.
     */
    public Resource login() {
        HttpClientResponse response = httpClient.post(getLoginParameters(), baseUri + getLoginUri());
        return response.getResource();
    }

    private Map<String, String> getLoginParameters() {
        Map<String, String> formParams = new HashMap<String, String>();

        formParams.put("j_username", userId);
        formParams.put("j_password", password);

        if (!"".equals(facilityCode))
            formParams.put("facilityCode", facilityCode);

        if (!"".equals(facilityName))
            formParams.put("facilityName", facilityName);

        formParams.put("type", "submit");

        return formParams;
    }

    private String getLoginUri() {
        if ("".equals(facilityCode))
            return VETERAN_LOGIN_URI;
        else
            return STAFF_LOGIN_URI;
    }

    public void logout() {
        httpClient.get(getLogoutUri());
    }

    private String getLogoutUri() {
        if ("".equals(facilityCode))
            return VETERAN_LOGOUT_URI;
        else
            return STAFF_LOGOUT_URI;
    }
}
