package com.agilex.healthcare.mobilehealthplatform.security;
import static org.junit.Assert.assertEquals;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.mock.auth.provider.OverrideMockStaffAppAuthenticator;

@ContextConfiguration(locations = { "classpath:integrationApplicationContext-StaffDev.xml", "classpath:applicationContext-JPA.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class MockStaffAuthenticatorTest {
	
	@Resource
	OverrideMockStaffAppAuthenticator staffAuthenticator;
	

	@Before
	public void setUp(){
	}

	@Test(expected=BadCredentialsException.class)
	public void validateUserNamePassedLocationAreRequired() throws Exception {
		staffAuthenticator.authenticate(null, null, null);
	}

	@Test(expected=BadCredentialsException.class)
	public void validateVistaLocationIsRequired() throws Exception {
		staffAuthenticator.authenticate("zztest.staff01", "pass", null);
	}

	@Test(expected=BadCredentialsException.class)
	public void validateUserNameIsRequired() throws Exception {
		staffAuthenticator.authenticate("", "pass", "688");
	}

	@Test(expected=MdwsResponseException.class)
	public void validateInvalidMdwsSiteThrowsException() throws Exception {
		staffAuthenticator.authenticate("zztest.staff02", "pass", "613");
	}
	
	@Test(expected=BadCredentialsException.class)
	public void validateInvalidCredentialsThrowsException() throws Exception {
		staffAuthenticator.authenticate("bruce.wayne", "pass", "688");
	}
	
	@Test
	public void validateLoginWithCorrectCredentials() throws Exception {
		MhpUser expectedUser = createUser("zztest", "scvtest2", "777", "Doctor");
		MhpUser actualUser = staffAuthenticator.authenticate("zztest.scvtest2", "pass", "777");
		
		assertUser(expectedUser, actualUser);
	}

	@Test
	public void validateLoginWithDifferentCorrectCredentials() throws Exception {
		MhpUser expectedUser = createUser("zztest", "doc01", "688", "Doctor");
		MhpUser actualUser = staffAuthenticator.authenticate("zztest.doc01", "pass", "688");
		assertUser(expectedUser, actualUser);
	}

	private MhpUser createUser(String firstName, String lastName, String vistaLocation, String title) {
		MhpUser expectedUser = new MhpUser();
		expectedUser.setAccessCode((firstName + "." + lastName).toLowerCase());
		expectedUser.setFirstName(firstName);
		expectedUser.setLastName(lastName);
		expectedUser.setVistaLocation(vistaLocation);
		expectedUser.setTitle(title);
		return expectedUser;
	}

	private void assertUser(MhpUser expectedUser, MhpUser actualUser) {
		assertEquals(expectedUser.getAccessCode(), actualUser.getAccessCode());
		assertEquals(expectedUser.getFirstName(), actualUser.getFirstName());
		assertEquals(expectedUser.getLastName(), actualUser.getLastName());
		assertEquals(expectedUser.getVistaLocation(), actualUser.getVistaLocation());
		assertEquals(expectedUser.getTitle(), actualUser.getTitle());
	}
}
