package com.agilex.healthcare.mobilehealthplatform.security;

import com.agilex.healthcare.mobilehealthplatform.security.infrastructure.Resource;

import java.util.*;

/**
 * Required client information used to make a grant request (buildAuthorizationResource method) and get an access
 * token (getAccessTokenParameters method).
 *
 * Important: the redirect uri must be the same for grant and get access token calls.
 */
public class ClientIdentification {
    private static final String REDIRECT_URI = "http://anywhere";

    private final String clientSecret;
    private final String clientId;
    private final String stateId;
    private final String redirectURI;

    public ClientIdentification(String clientSecret, String clientId) {
        this.clientSecret = clientSecret;
        this.clientId = clientId;
        stateId = UUID.randomUUID().toString();
        redirectURI = REDIRECT_URI;
    }

    public ClientIdentification(String clientSecret, String clientId, String redirectURI) {
        this.clientSecret = clientSecret;
        this.clientId = clientId;
        this.stateId = UUID.randomUUID().toString();
        this.redirectURI = redirectURI;
    }

    public Resource buildAuthorizationResource(String authorizationUri) {
        return new Resource(authorizationUri + "?response_type=code&state=" + stateId + "&client_id=" + clientId + "&redirect_uri=" + redirectURI + "&scope=read");
    }

    public Map<String, String> getAccessTokenParameters(String code) {
        Map<String, String> params = new HashMap<String, String>();

        params.put("client_id", clientId);
        params.put("state", stateId);
        params.put("scope", "read");
        params.put("client_secret", clientSecret);
        params.put("response_type", "token");
        params.put("code", code);
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", redirectURI);

        return params;
    }
}
