package com.agilex.healthcare.mobilehealthplatform.authorization;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Date;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(locations = { "classpath:applicationContext-JPA.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class ResourceLastAccessedTimeDAOTest{

	private static final String USER_ID = "1234567";
	
	@Resource
	ResourceLastAccessedTimeDAO dataLayer; 
	
	@Before
	public void setUp() {
		ResourceLastAccessedTime resourceLastAccessedTime = new ResourceLastAccessedTime();
		resourceLastAccessedTime.setLastAccessedTime(new Date());
		resourceLastAccessedTime.setLastLoginTime(new Date());
		resourceLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveResourceLastAccessedTime(resourceLastAccessedTime);
	}
	
	@Test
	public void testFetchingOfLastAccessedDate() {
		ResourceLastAccessedTime resourceLastAccessedTime = dataLayer.fetchResourceLastAccessedTime(USER_ID);
		assertEquals(USER_ID, resourceLastAccessedTime.getUserId());
		assertNotNull(resourceLastAccessedTime.getLastAccessedTime());
	}

	@Test
	public void testFetchingOfLastAccessedDateOfUnknownUser() {
		ResourceLastAccessedTime resourceLastAccessedTime = dataLayer.fetchResourceLastAccessedTime("Unknown");
		assertNull(resourceLastAccessedTime);
	}

	@Test
	public void testFetchingOfLastAccessedDateOfPreviouslySavedDate() {
		ResourceLastAccessedTime expectedResourceLastAccessedTime = new ResourceLastAccessedTime();
		expectedResourceLastAccessedTime.setLastAccessedTime(new Date());
		expectedResourceLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveResourceLastAccessedTime(expectedResourceLastAccessedTime);

		long currentTime = expectedResourceLastAccessedTime.getLastAccessedTime().getTime();
		
		Date earlierTime = new Date(currentTime-1000);
		ResourceLastAccessedTime earlierResourceLastAccessedTime = new ResourceLastAccessedTime();
		earlierResourceLastAccessedTime.setLastAccessedTime(earlierTime);
		earlierResourceLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveResourceLastAccessedTime(earlierResourceLastAccessedTime);
		
		ResourceLastAccessedTime actualResourceLastAccesedTime = dataLayer.fetchResourceLastAccessedTime(USER_ID);
		
		
		assertEquals(expectedResourceLastAccessedTime.getLastAccessedTime(), actualResourceLastAccesedTime.getLastAccessedTime());
	}
	
	@Test
	public void testFetchingOfLastAccessedDateOfNewlySavedDate() {
		ResourceLastAccessedTime resourceLastAccessedTime = new ResourceLastAccessedTime();
		resourceLastAccessedTime.setLastAccessedTime(new Date());
		resourceLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveResourceLastAccessedTime(resourceLastAccessedTime);

		long currentTime = resourceLastAccessedTime.getLastAccessedTime().getTime();
		
		Date laterTime = new Date(currentTime + 1000);
		ResourceLastAccessedTime expectedResourceLastAccessedTime = new ResourceLastAccessedTime();
		expectedResourceLastAccessedTime.setLastAccessedTime(laterTime);
		expectedResourceLastAccessedTime.setUserId(USER_ID);
		dataLayer.saveResourceLastAccessedTime(expectedResourceLastAccessedTime);
		
		ResourceLastAccessedTime actualResourceLastAccesedTime = dataLayer.fetchResourceLastAccessedTime(USER_ID);
		
		assertEquals(expectedResourceLastAccessedTime.getLastAccessedTime(), actualResourceLastAccesedTime.getLastAccessedTime());
	}
	
}
