package com.agilex.healthcare.mobilehealthplatform.authorization;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.provider.auth.LoginLogoutUser;

@ContextConfiguration(locations = { "classpath:applicationContext-JPA.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class LoginLogoutUserDAOTest{

	private static final String USER_ID = "1234567";
	
	@Resource
	LoginLogoutUserDAO loginLogoutUserDAO; 
	
	@Before
	public void setUp() {
		LoginLogoutUser loginLogoutUser = new LoginLogoutUser();
		loginLogoutUser.setLogout(false);
		loginLogoutUser.setUpdateDateTime(new Date());
		loginLogoutUser.setUserId(USER_ID);
		loginLogoutUserDAO.saveLoginLogoutUser(loginLogoutUser);
	}

	@Test
	public void testFetchLoginLogoutUser() {
		boolean logout = loginLogoutUserDAO.isUserLoggedOut(USER_ID);
		assertEquals(false, logout);
	}
	
	@Test
	public void testSaveAndFetchLoginLogoutUser() {
		LoginLogoutUser loginLogoutUser = new LoginLogoutUser();
		loginLogoutUser.setLogout(true);
		loginLogoutUser.setUpdateDateTime(new Date());
		loginLogoutUser.setUserId(USER_ID);
		loginLogoutUserDAO.saveLoginLogoutUser(loginLogoutUser);
		
		boolean logout = loginLogoutUserDAO.isUserLoggedOut(USER_ID);
		
		assertEquals(true, logout);
		
	}

	
}
