package com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws;

import java.net.MalformedURLException;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvcSoap;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml", "classpath:applicationContext-JPA.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class MdwsAppAuthenticatorKeepAliveTest {
	
	@Resource
	MdwsConfiguration mdwsConfiguration;
	@Resource
	OverrideMdwsAppAuthenticator authenticator;
	private MhpUser mhpUser;
	
	@After
	public void tearDown(){
		authenticator.setPollingInterval(30); //Default to 30 seconds
		authenticator.setTimeToKeepAlive(15*60); //Default to 15 minutes
		authenticator.setPersistMdwsInfo(false);
		
		authenticator.logoff(mhpUser);
	}
	
	@Test
	public void scheduledTasksGetIncreased() throws Exception {
		login();
		int newScheduledTaskSize = MdwsAppAuthenticator.scheduledTasks.size();
		Assert.assertEquals(1, newScheduledTaskSize);
	}
	
	@Ignore
	public void scheduledTasksDieAfterTimeout() throws Exception {
		authenticator.setPollingInterval(5);
		authenticator.setTimeToKeepAlive(1);
		
		login();
		Thread.sleep(10000);
		int newScheduledTaskSize = MdwsAppAuthenticator.scheduledTasks.size();
		Assert.assertEquals(0, newScheduledTaskSize);
	}
	
	@Test
	public void scheduledTasksDieAfterLogoff() throws Exception {
		authenticator.setPollingInterval(1);
		authenticator.setTimeToKeepAlive(120);
		
		login();
		
		authenticator.logoff(mhpUser);
		
		Thread.sleep(5000);
		int newScheduledTaskSize = MdwsAppAuthenticator.scheduledTasks.size();
		Assert.assertEquals(0, newScheduledTaskSize);
	}
	
	private void login() throws Exception {
		mhpUser = authenticator.authenticate("cprs1234", "cprs4321$", "777");
	}
	
	@Ignore //This is a test that takes 3 minutes to run (not something I want happening right now on CI).
	public void mdwsFailsAfter3MinutesIfNoPolling() throws Exception {
		authenticator.setPollingInterval(30);
		authenticator.setTimeToKeepAlive(1);
		authenticateAndValidateSecurityKeys(false);
	}
	
	@Ignore //This is a test that takes 3 minutes to run (not something I want happening right now on CI).
	public void mdwsStillWorksAfter3Minutes() throws Exception {
		authenticator.setPollingInterval(30);
		authenticator.setTimeToKeepAlive(240);
		
		authenticateAndValidateSecurityKeys(true);
	}

	private void authenticateAndValidateSecurityKeys(boolean shouldSucceed) throws Exception, InterruptedException, MalformedURLException {
		mhpUser = authenticator.authenticate("cprs1234", "cprs4321$", "777");
		Thread.sleep(180000);
		
		EmrSvcSoap port = MDWSConnectionUsingCookieTest.getPort();
		MDWSConnectionUsingCookieTest.setSessionId(mhpUser.getMdwsInfo().getSessionId(), port);
		
		UserSecurityKeyArray securityKeys = port.getUserSecurityKeys(mhpUser.getId());
		Assert.assertNotNull(securityKeys);
		
		if (shouldSucceed) {
			Assert.assertNull(securityKeys.getFault());
			
			MdwsKeys keys = MdwsAppAuthenticatorMhpUserUtil.getMdwsKeys(securityKeys);
			Assert.assertNotNull(keys);
		}
		else {
			Assert.assertNotNull(securityKeys.getFault()); //We should get an error from VistA as our connection is no longer valid.
		}
	}
}
