package com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws;

import static org.junit.Assert.assertEquals;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml", "classpath:applicationContext-JPA.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class MdwsAppAuthenticatorIntTest {
	
	@Resource
	MdwsConfiguration mdwsConfiguration;
	@Resource
	OverrideMdwsAppAuthenticator authenticator; 
	
	@Before
	public void setUp(){
	}
	
	@Test
	public void validateUserCanLoginWithCorrectCredentials() throws Exception{
		MhpUser mhpUser = authenticator.authenticate("cprs1234", "cprs4321$", "777");
		assertEquals("1", mhpUser.getId());
		assertEquals("PROGRAMMER", mhpUser.getLastName());
		assertEquals("ONE", mhpUser.getFirstName());
		assertEquals("PROGRAMMER,ONE", mhpUser.getDisplayName());
	}
	
	@Test(expected=RuntimeException.class) 
	public void validateUserAuthenticationFailsWithInvalidCredentials() throws Exception{
		authenticator.authenticate("OV1234", "OV1234", "500");
	}

	@Test(expected=RuntimeException.class) 
	public void validateUserAuthenticationFailsWithInvalidSiteCode() throws Exception{
		authenticator.authenticate("OV1234", "OV1234!!", "xyz");
	}

	@Test(expected=RuntimeException.class) 
	public void validateUserAuthenticationFailsWithNullSiteCode() throws Exception{
		authenticator.authenticate("OV1234", "OV1234!!", null);
	}
}
