package com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws;

import static org.junit.Assert.assertEquals;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.junit.Assert;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvc;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvcSoap;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.PatientTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedAllergyArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedPatientArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.AllergyTranslator;

public class MDWSConnectionUsingCookieTest {
	public static String EMR_SVC = "http://192.168.25.149/MDWS3.0.2.5/EmrSvc.asmx";
	public static String LVENCOUNTER_SVC = "http://192.168.25.149/MDWS3.0.2.5/FindPatientService.asmx";

	@Test
	public void testMDWSConnectionUsingCookieOnDifferentCallsOnTheSameService() throws Exception{
		EmrSvcSoap emrPort1 = getPort();
		
		emrPort1.connect("500");
		emrPort1.login("ov1234", "ov1234!!", "");
		TaggedPatientArrays patientArrays1 = emrPort1.match("vamobile");
		
		String cookie = getSessionId(emrPort1);
		
		URL wsdlLocation = new URL(MDWSConnectionUsingCookieTest.EMR_SVC + "?wsdl");
		EmrSvc emrService2 = new EmrSvc(wsdlLocation, new QName("http://mdws.domain/EmrSvc", "EmrSvc"));
		EmrSvcSoap emrPort2 = emrService2.getEmrSvcSoap();
		
		setSessionId(cookie, emrPort2);

		TaggedPatientArrays patientArrays2 = emrPort2.match("vamobile");
		
		assertEquals(patientArrays1.getArrays().getTaggedPatientArray().get(0).getCount(), patientArrays2.getArrays().getTaggedPatientArray().get(0).getCount());
	}
	
	@Test
	public void testMDWSConnectionUsingCookieOnDifferentCallsToRetrievePatientData() throws Exception{
		EmrSvcSoap emrPort1 = getPort();
		
		emrPort1.connect("500");
		emrPort1.login("ov1234", "ov1234!!", "");
		TaggedPatientArrays patientArrays1 = emrPort1.match("vamobile");
		PatientTO patientTO1 = patientArrays1.getArrays().getTaggedPatientArray().get(0).getPatients().getPatientTO().get(0);
		PatientTO patientTO2 = patientArrays1.getArrays().getTaggedPatientArray().get(0).getPatients().getPatientTO().get(1);
		System.out.println("Patient 1 ID: " + patientTO1.getLocalPid());
		System.out.println("Patient 2 ID: " + patientTO2.getLocalPid());
		
		String cookie = getSessionId(emrPort1);

		getAllergies(patientTO1.getLocalPid(), cookie);
		getAllergies(patientTO2.getLocalPid(), cookie);
	}
	
	private void getAllergies(String patientIen, String cookie) throws Exception{
		URL wsdlLocation = new URL(MDWSConnectionUsingCookieTest.EMR_SVC + "?wsdl");

		EmrSvc emrService2 = new EmrSvc(wsdlLocation, new QName("http://mdws.domain/EmrSvc", "EmrSvc"));
		EmrSvcSoap emrPort2 = emrService2.getEmrSvcSoap();
		
		setSessionId(cookie, emrPort2);
				
		emrPort2.select(patientIen);
		TaggedAllergyArrays taggedAllergies = emrPort2.getAllergiesBySite("500");
		Allergies allergies = translate(taggedAllergies);
		System.out.println("Allergies for " + patientIen + ": " + allergies.size());
	}
	
	private Allergies translate(TaggedAllergyArrays taggedAllergyArrays) {
		AllergyTranslator translator = new AllergyTranslator();
		return translator.translate(taggedAllergyArrays);
	}
	
//	private void getLVEncounterDiagnoses(String cookie) throws Exception {
//		URL wsdlLocation = new URL(MDWSConnectionUsingCookieTest.LVENCOUNTER_SVC + "?wsdl");
//
//		LVEncounterSvc mdwsService = new LVEncounterSvc(wsdlLocation, new QName("http://domaindomaindomain/LVEncounterSvc", "LVEncounterSvc"));
//		LVEncounterSvcSoap port = mdwsService.getLVEncounterSvcSoap();
//		((BindingProvider)port).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
//		((BindingProvider)port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, MDWSConnectionUsingCookieTest.LVENCOUNTER_SVC);
//		setSessionId(cookie, port);
//		
//		LVTaggedLexiconCodeLookupArrays lexicons = port.getLexiconCodeLookup("12", "ICD");
//		Assert.assertNotNull(lexicons);
//		Assert.assertNull(lexicons.getFault());
//		MdwsResponseValidator.validateMdwsObject(lexicons);
//		Codes codes = LexiconCodeLookupUtil.translateLVTaggedLexiconCodeLookupArrays(lexicons);
//		Assert.assertTrue(codes.size() > 0);
//	}

	//	@Test
//	public void testMDWSConnectionFAILSUsingCookieOnDifferentServices() throws Exception{
//		EmrSvcSoap emrPort1 = getPort();
//		
//		emrPort1.connect("688");
//		emrPort1.login("ov1234", "ov1234!!", "");
//		TaggedPatientArrays patientArrays1 = emrPort1.match("vamobile");
//		PatientTO patientTO1 = patientArrays1.getArrays().getTaggedPatientArray().get(0).getPatients().getPatientTO().get(0);
//		System.out.println("Patient 1 ID: " + patientTO1.getLocalPid());
//		
//		String sessionId = getSessionId(emrPort1);
//
//		getAllergies(patientTO1.getLocalPid(), sessionId);
//		
//		getLVEncounterDiagnoses(sessionId);
//	}
	
	@Test
	public void testGetSecurityKeys() throws Exception{
		EmrSvcSoap emrPort1 = getPort();
		
		emrPort1.connect("500");
		//Another developer emailed me: I did not get any data for OV1234, but it worked fine for doc123
		//com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws.generatedwsdl.emrservice.UserTO userTO = emrPort1.login("ov1234", "ov1234!!", "");
		com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO userTO = emrPort1.login("ov1234", "ov1234!!", "");
		UserSecurityKeyArray securityKeys = emrPort1.getUserSecurityKeys(userTO.getDUZ());
		Assert.assertNotNull(securityKeys);
		Assert.assertNull(securityKeys.getFault());
		
		MdwsKeys keys = MdwsAppAuthenticatorMhpUserUtil.getMdwsKeys(securityKeys);
		Assert.assertNotNull(keys);
	}

	public static EmrSvcSoap getPort() throws MalformedURLException {
		URL wsdlLocation = new URL(MDWSConnectionUsingCookieTest.EMR_SVC + "?wsdl");
		EmrSvc emrService1 = new EmrSvc(wsdlLocation, new QName("http://mdws.domain/EmrSvc", "EmrSvc"));
		EmrSvcSoap emrPort1 = emrService1.getEmrSvcSoap();
		
		((BindingProvider)emrPort1).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
		((BindingProvider)emrPort1).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, MDWSConnectionUsingCookieTest.EMR_SVC);
		return emrPort1;
	}

	public static void setSessionId(String cookie, Object port) {
		Client client = ClientProxy.getClient(port);
		HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
		HTTPClientPolicy policy = new HTTPClientPolicy();
		policy.setCookie("ASP.NET_SessionId=" + cookie);
		httpConduit.setClient(policy);
	}
	
	public static String getSessionId(EmrSvcSoap emrPort1) {
		Client client1 = ClientProxy.getClient(emrPort1);
		HTTPConduit httpConduit1 = (HTTPConduit)client1.getConduit();
		Map<String, Cookie> cookies = httpConduit1.getCookies();
		String sessionId = cookies.get("ASP.NET_SessionId").getValue();
		return sessionId;
	}

}
