package com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.security.AppUser;
import com.agilex.healthcare.mobilehealthplatform.security.Roles;

public class AuthenticationUtil {
	
	public static void setLoggedInUser(MhpUser authenticatedUser, String siteCode, String uniqueId) {
				
		Authentication userAuthentication = createUserAuthentication(authenticatedUser, siteCode, uniqueId);
		final Authentication oauthAuthentication = createOauth2Authentication(userAuthentication);
		
		SecurityContext context = new SecurityContext() {
			private static final long serialVersionUID = -7841498566548092084L;

			@Override
			public void setAuthentication(Authentication authentication) {
				
			}
			
			@Override
			public Authentication getAuthentication() {
				return oauthAuthentication;
			}
		};
		SecurityContextHolder.setContext(context);
	}
	
	
	private static Authentication createUserAuthentication(MhpUser authenticatedUser, String siteCode, String uniqueId){
		List<GrantedAuthority> authorities = createPatientAuthorities();

		AppUser principal = createPrincipal(authenticatedUser, new PatientIdentifier(siteCode, uniqueId), authorities);
		
		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);
		return authentication;
	}
	
	protected static UsernamePasswordAuthenticationToken createAuthentication(List<GrantedAuthority> authorities, AppUser principal, Object credentials) {
        return new UsernamePasswordAuthenticationToken(principal, credentials, authorities);
    }
    protected static List<GrantedAuthority> createPatientAuthorities() {
		return createAuthorities(Roles.ROLE_CONSUMER);
	}
    protected static AppUser createPrincipal(MhpUser authenticatedUser, PatientIdentifier patientIdentifier, List<GrantedAuthority> authorities) {
		String accessCode = authenticatedUser.getAccessCode();
        authenticatedUser.setUserIdentifier(patientIdentifier);
        authenticatedUser.setRightOfAccessAccepted(true);
        
        AppUser principal = new AppUser(accessCode, "", authorities, authenticatedUser);
		return principal;
	}
	
	protected static List<GrantedAuthority> createAuthorities(String role) {
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority(role));
		return authorities;
	}
    private static OAuth2Authentication createOauth2Authentication(Authentication userAuthentication){
    	return new OAuth2Authentication(new DefaultAuthorizationRequest(
    			Collections.<String, String> emptyMap()), userAuthentication);
    }
}
