LineMeasurement.prototype = new MouseTool();
LineMeasurement.prototype.constructor = LineMeasurement;
var isLineExceededOutside = false;

function LineMeasurement() {
    this.ToolType = "lineMeasurement";
    this.measurementData = {
        start: {
            handleActive: false
        },
        end: {
            handleActive: false
        },
        style : {
        },
        studyUid:undefined,
        measurementSubType: "2DLength",
        measureType: "line",
        measurementId: null,
        measurementType: null,
        measurementComplete: false,
        measurementUnits: null,
        isLineExceededOutside: false,
        isEditable: "undefined",
        sessionType: "undefined"
    };
}

LineMeasurement.prototype.hanleMouseDown = function(evt) {
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    if(dicomViewer.measurement.isMeasurementBroken())
    {        
        dicomViewer.measurement.setMeasurementBroken(false);
    }
    evt.preventDefault();
    var editData = dicomViewer.measurement.getDataToEdit();
    dicomViewer.measurement.setLineMeasurementEnd(false);    
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
    this.measurementData.isEditable = true;
    this.measurementData.sessionType = 0;
    var widget = imageRenderer.getRenderWidget();
    if (evt.type === "mousedown" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || editData !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            this.measurementData.measurementSubType = this.measurementSubType; 
        } else {
            this.isMousePressed = false;
        }
    }
    
    var measurementType = dicomViewer.measurement.draw.getMeasurementType();
    this.measurementData.measurementId = measurementType.measurementId;
    this.measurementData.measurementType = measurementType.measurementType;
    this.measurementData.measurementUnits = measurementType.measurementUnits;
    this.measurementData.measurementComplete = false;
    this.measurementData.textPosition = dicomViewer.measurement.hounsfieldTextPosition(this.measurementData, imageRenderer);
};

LineMeasurement.prototype.hanleMouseMove = function(evt) {
    var toolName = dicomViewer.mouseTools.getToolName();
    var value = dicomViewer.measurement.getDataToEdit();
    var imageRenderer = this.activeImageRenderer;

    if(toolName == 'lineMeasurement') {
        var cursorObj = document.getElementById('viewport_View');
        if(cursorObj != undefined && cursorObj != null){
            var cursorName = cursorObj.style.cursor;
        }
        if(cursorName.indexOf("images/measurelength.cur") >0){
            dicomViewer.measurement.isCalibratePixelSpacing(imageRenderer);
        } else if(dicomViewer.tools.getLengthCalibrationFlag() && cursorName.indexOf("images/calibrate.cur")>0 && !dicomViewer.tools.isCaliberEnabled(imageRenderer)){
            var type = {id : "0_measurement"};
            dicomViewer.tools.do2DMeasurement(type);
        }
    }

    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    if (!this.isMousePressed && !this.isLineExceededOutside) {
        return;
    }    
    var widget = imageRenderer.getRenderWidget();
    if (this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }
        this.isMousePressed = true;
    } else {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.handleActive = true;            
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
        }

        if (value === undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);

        } else {
            if (value.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                this.measurementData.end.handleActive = true;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                this.measurementData.measurementType = value.measurmentType;
                this.measurementData.measureType = value.measurmentType;
                dicomViewer.measurement.setTempData(this.measurementData);
                this.measurementData = {
                    start: {
                        handleActive: false
                    },
                    end: {
                        handleActive: false
                    },
                    measureType: value.measurmentType
                };
            }
        }
        this.measurementData.textPosition = dicomViewer.measurement.hounsfieldTextPosition(this.measurementData, imageRenderer);
        imageRenderer.drawDicomImage(false, undefined, true);
    }  
    
};

LineMeasurement.prototype.hanleMouseUp = function(evt) {
	var flagFor2dLengthCalibration = dicomViewer.tools.getFlagFor2dLengthCalibration();
    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
        if(this.isMousePressed = true) {
            this.isMousePressed = false;
        }
    }
    if (evt.which === 3 || isTouchContextMenu) {
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "linedelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft)) - 5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop)) - 5;
            var measurementDelData = {
                x: pointX,
                y: pointY,
                measureType: "linedelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        var imageRender = this.activeImageRenderer;
        //var auids = imageRender.anUIDs.split("*");
        var dContext = this.activeImageRenderer.getRenderWidget().getContext("2d");
        //dicomViewer.measurement.draw.drawMeasurements(auids[0], auids[1],dContext,imageRender.getPresentation(),imageRender);
        this.activeImageRenderer.drawDicomImage(true);
    }

    if (this.isMousePressed || this.isLineExceededOutside) {
        this.isMousePressed = false;
        this.isLineExceededOutside = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if (evt.type === "mouseup" || evt.type === "touchend" || evt.type === "mouseout") {
            var pt = this.hitTestAndGetMousePosition(evt);
            if(pt !== undefined) {
                this.measurementData.end.x = pt.x;
                this.measurementData.end.y = pt.y;
            } else {
                // touchend will return undefined. Maintain the last touchmove point as the end point
            }
        
            this.measurementData.end.handleActive = false;
            if(!flagFor2dLengthCalibration){
                this.measurementData.measurementComplete = true;
            }
        }
        dicomViewer.measurement.setMeasurementBroken(false);       
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
        if(flagFor2dLengthCalibration){
            if ((evt.type === "mouseup" || evt.type === "touchend") && !(this.measurementData.start.x == this.measurementData.end.x && 
                                            this.measurementData.start.y == this.measurementData.end.y)) {

                if(this.measurementData.measurementSubType == "2DLength") {
                    this.measurementData.measurementComplete = true;
                }
                dicomViewer.tools.lengthCalibration();
            }
        }
        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "line",
            measurementSubType:this.measurementData.measurementSubType
        };
        imageRenderer.drawDicomImage(false);
        if (flagFor2dLengthCalibration) {
            var pt = this.hitTestAndGetMousePosition(evt);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "linedelete"
            };
            dicomViewer.measurement.setTempData(measurementDelData);
            var imageRender = this.activeImageRenderer;
            var dContext = this.activeImageRenderer.getRenderWidget().getContext("2d");
            this.activeImageRenderer.drawDicomImage(true);
            dicomViewer.measurement.setTempData(undefined);
        }
        dicomViewer.measurement.resetHandeler();
    }

};

LineMeasurement.prototype.hanleDoubleClick = function(evt) {
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(dataToEdit != undefined) {
        var menuMesure = getMeasurements();
        var imageRenderer = this.activeImageRenderer;
        var widget = imageRenderer.getRenderWidget();
        if (evt === undefined || evt.which === 1 || evt.type === "mouseout") {
            var key = dataToEdit.key;
            var arrayIndex = dataToEdit.arryIndex;
            var keyArray = key.split("_");
            var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
            if(isFullScreenEnabled) {
                parentDiv = previousLayoutSelection;
            }
            var measurement = dicomViewer.measurement.getMeasurements(keyArray[0], keyArray[1]);
            if (measurement === undefined)
                return;
            measurement = measurement[arrayIndex];
            measurementResult = dicomViewer.measurement.draw.drawLineMeasurement(keyArray[0], widget, measurement, imageRenderer.getPresentation(), imageRenderer, "edit");
            if (measurementResult != null) {
                sendMeasurement(measurementResult.id, measurementResult.value);
            }

            measurement.start.handleActive = false;
            measurement.end.handleActive = false;
            dicomViewer.measurement.setDataToEdit(undefined);
        }

        this.isMousePressed = false;
        if (imageRenderer === undefined) {
            return;
        }
        imageRenderer.drawDicomImage(false);
    }
};

LineMeasurement.prototype.hanleMouseOut = function(evt) {
    if(dicomViewer.measurement.getDataToEdit() !== undefined) {
        this.hanleDoubleClick(evt);
    } else {
        this.hanleMouseUp(evt);
    }
};

/**
 * set the measurement/Annotation type
 * @param {Type} type - It specifies the measurement type(arrow,2Dline,etc..)
 */ 
LineMeasurement.prototype.setMeasurementSubType = function (type) {
    this.measurementSubType = type;
};TraceMeasurement.prototype = new MouseTool();
TraceMeasurement.prototype.constructor = TraceMeasurement;

function TraceMeasurement()
{
    this.ToolType = "traceMeasurement";
	this.measurementData = {
		start : {handleActive : false},
		end : {handleActive : false},
        style : {},
        studyUid:undefined,
		measureType: "trace",
		measurementId : null,
		measurementType: null,
	    measurementUnits : null,
        measurementComplete: false,
        displayMeasurement : false,
        isEditable: "undefined",
        sessionType: "undefined"
	};
}

TraceMeasurement.prototype.hanleMouseDown = function(evt){
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    
    if(!dicomViewer.measurement.isTraceMeasurementEnd()){
        dicomViewer.measurement.setTraceMeasurementEnd(true);
        dicomViewer.measurement.setTraceMeasurementId(dicomViewer.measurement.getTraceMeasurementId() +1);
        this.measurementData.measurementId = dicomViewer.measurement.getTraceMeasurementId();
    }
    if (this.isMousePressed) {
        this.isMousePressed = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
        this.measurementData.isEditable = true;
        this.measurementData.sessionType = 0;
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if(evt.type === "mouseup" || evt.type === "touchstart") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = false;
        }
        this.measurementData.textPosition = dicomViewer.measurement.pointTextPosition(this.measurementData, imageRenderer);
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
        //dicomViewer.measurement.addMeasurements(imageUid,frameIndex,imageRenderer,this.measurementData);
        this.measurementData = {
            start : {handleActive : false},
            end : {handleActive : false},
            measureType : "trace",
            measurementId : dicomViewer.measurement.getTraceMeasurementId(),
            displayMeasurement : false,
            style : dicomViewer.measurement.draw.getMeasurementStyle()
        };
        imageRenderer.drawDicomImage(false);
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if (dataToEdit != undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.resetHandeler();
            return;
        }
    }
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    dicomViewer.measurement.setLineMeasurementEnd(false);
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    
    var widget = imageRenderer.getRenderWidget();    
    if(evt.type === "mousedown" || evt.type === "mouseout" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || evt.type === "mouseout" || dataToEdit !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        } else {
            this.isMousePressed = false;
        }
    }

	/*var measurementType = dicomViewer.measurement.draw.getMeasurementType();
	this.measurementData.measurementId = measurementType.measurementId;
	this.measurementData.measurementType = measurementType.measurementType;
	this.measurementData.measurementUnits = measurementType.measurementUnits;*/
    //for mobile devices not getting the touchend that's why drawing the point on every touchstart
    if(evt.type == "touchstart") {
        dicomViewer.measurement.setTempData(this.measurementData);
        imageRenderer.drawDicomImage(false);
    }
};

TraceMeasurement.prototype.hanleMouseMove = function(evt, isDoubleClick) {
	var imageRenderer = this.activeImageRenderer;
	if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
	}
	if(!this.isMousePressed) {
        return;
	}
	var widget = imageRenderer.getRenderWidget();
    if(this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if(evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }
        this.isMousePressed = true;
    } else {
        if(evt.type === "mousemove" || evt.type === "touchmove" || isDoubleClick) {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
        }
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if(dataToEdit != undefined) {
            if(dataToEdit.measurmentType === "line") {
                dicomViewer.tools.do2DMeasurement(0, null, null)
            } else if(dataToEdit.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                //Dreasing 5 for viewer offset
                this.measurementData.start.x = (evt.offsetX || (evt.pageX - widget.offsetLeft))-5;
                this.measurementData.start.y = (evt.offsetY || (evt.pageY - widget.offsetTop))-5;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                dicomViewer.measurement.setTempData(this.measurementData);
            }
        } else {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);
        }
        imageRenderer.drawDicomImage(false, undefined, true);
    }
	//evt.target.style.cursor = "crosshair";
};

TraceMeasurement.prototype.hanleMouseUp = function(evt) {
    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
    }
    if(evt.which === 3 || isTouchContextMenu) {
        this.hanleDoubleClick();
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "linedelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft))-5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop))-5;
            var measurementDelData = {
                x : pointX,
                y : pointY,
                measureType : "tracedelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        this.activeImageRenderer.drawDicomImage(false);
    }
};

TraceMeasurement.prototype.hanleDoubleClick = function(evt) {
    var imageRenderer = this.activeImageRenderer;
    this.isMousePressed = false;
    if (imageRenderer === undefined) {
        return;
    }
    if(evt === undefined || evt.type === "dblclick" || evt.type === "mouseout" || evt.type === "mousewheel") {
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        var traceMeasurements = dicomViewer.measurement.getTraceMeasurements(imageUid, frameIndex);
        if(traceMeasurements != undefined) {
            dicomViewer.measurement.resetTraceEditMode(imageUid, frameIndex, dataToEdit);
        }
        this.measurementData.displayMeasurement = true;
        dicomViewer.measurement.setTraceMeasurementEnd(false);
        if(dataToEdit != undefined) {
            dicomViewer.measurement.setTempData(undefined);
            dicomViewer.measurement.setDataToEdit(undefined);
        }
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.resetHandeler();
        /*var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft))-5;
        var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop))-5;
        var measurementDelData = {
                                x : pointX,
                                y : pointY,
                                measureType : "tracedelete" 
                               };
        dicomViewer.measurement.setTempData(measurementDelData);        
        imageRenderer.drawDicomImage(false);*/        
    }
};

TraceMeasurement.prototype.hanleMouseOut = function(evt) {
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(this.isMousePressed || dataToEdit != undefined){
        this.hanleMouseDown(evt);
        this.hanleMouseMove(evt, true);
        this.hanleMouseDown(evt);
        this.hanleDoubleClick(evt);
    }
};VolumeMeasurement.prototype = new MouseTool();
VolumeMeasurement.prototype.constructor = VolumeMeasurement;

function VolumeMeasurement()
{
    this.ToolType = "volumeMeasurement";
	this.measurementData = {
		start : {handleActive : false},
		end : {handleActive : false},
        studyUid:undefined,
		measureType: "volume",
		measurementId : null,
		measurementType: null,
        measurementComplete: false,
	    measurementUnits : null        
	};
}

VolumeMeasurement.prototype.hanleMouseDown = function(evt){
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if (dataToEdit === undefined) {
        this.measurementData.measureType = "volume";
    }

    if(!dicomViewer.measurement.isVolumeMeasurementEnd()) {
        dicomViewer.measurement.setVolumeMeasurementEnd(true);
        dicomViewer.measurement.setVolumeMeasurementId(dicomViewer.measurement.getVolumeMeasurementId() +1);
        this.measurementData.measurementId = dicomViewer.measurement.getVolumeMeasurementId();
    }
    if (this.isMousePressed)
	{
		this.isMousePressed = false;
		var imageRenderer = this.activeImageRenderer;
		if (imageRenderer === undefined)
		{
			return;
		}
        this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
		var widget = imageRenderer.getRenderWidget();       
        var imageUid = undefined;
		var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {          
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
		if(evt.type === "mouseup")
		{
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = false;
		}
		else if(evt.type === "touchstop")
		{
			evt.preventDefault();
			var touch = evt.touches[0];
			//this.measurementData.end.x = touch.pageX - offset.x;
			//this.measurementData.end.y = touch.pageY - offset.y;
		}	
		dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
        

		//dicomViewer.measurement.addMeasurements(imageUid,frameIndex,imageRenderer,this.measurementData);
        this.measurementData = {
                                start : {handleActive : false},
		                        end : {handleActive : false},
		                        measureType : "volume",
                                measurementId : dicomViewer.measurement.getVolumeMeasurementId(),
                                measurementComplete : false
                               };
		imageRenderer.drawDicomImage(false);
	}
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if (this.measurementData.measureType === "volumeedit" || (this.measurementData.measureType === "volume" && dataToEdit !== undefined)) {
        this.measurementData.measureType = "volumeeditmove";
    }

    dicomViewer.measurement.setLineMeasurementEnd(false);
	this.isMousePressed = true;
	var imageRenderer = this.activeImageRenderer;
	if (imageRenderer === undefined) 
	{
		this.isMousePressed = false;
		return;
	}
    
    var widget = imageRenderer.getRenderWidget();    
	if(evt.type === "mousedown")
	{       
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion) {
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        } else {
            this.isMousePressed = false;
        }
	}
	else if(evt.type === "touchstart")
	{
		evt.preventDefault();
		var touch = evt.touches[0];
		//this.measurementData.start.x = touch.pageX - offset.x;
		//this.measurementData.start.y = touch.pageY - offset.y;
	}

	/*var measurementType = dicomViewer.measurement.draw.getMeasurementType();
	this.measurementData.measurementId = measurementType.measurementId;
	this.measurementData.measurementType = measurementType.measurementType;
	this.measurementData.measurementUnits = measurementType.measurementUnits;*/
};

VolumeMeasurement.prototype.hanleMouseMove = function(evt) {
	var imageRenderer = this.activeImageRenderer;
	if (imageRenderer === undefined)
	{
		this.isMousePressed = false;
		return;
	}
	if(!this.isMousePressed)
	{
		return;
	}
    
	var widget = imageRenderer.getRenderWidget();    
	if(this.measurementData.start.x === undefined || this.measurementData.start.y === undefined)
	{
		if(evt.type === "mousemove")
		{
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
		}
		else if(evt.type === "touchmove")
		{
			evt.preventDefault();
			var touch = evt.touches[0];
			//this.measurementData.start.x = touch.pageX - offset.x;
			//.measurementData.start.y = touch.pageY - offset.y;
		}
		this.isMousePressed = true;
	}
	else
	{
		if(evt.type === "mousemove")
		{
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
		}
		else if(evt.type === "touchmove")
		{
			evt.preventDefault();
			var touch = evt.touches[0];
			//this.measurementData.end.x = touch.pageX - offset.x;
			//this.measurementData.end.y = touch.pageY - offset.y;
		}
		var dataToEdit = dicomViewer.measurement.getDataToEdit();
		if(dataToEdit != undefined)
		{
		if(dataToEdit.measurmentType === "line")
		{
			dicomViewer.tools.do2DMeasurement(0, null, null)
		}
			else if(dataToEdit.measurmentType === "point")
			{
				dicomViewer.tools.do2DMeasurement(1, null, null)
			}
		}
		else
		{
        dicomViewer.measurement.setLineMeasurementEnd(false);
		dicomViewer.measurement.setTempData(this.measurementData);
		}

        if (this.measurementData.measureType === "volumeeditmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;

            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);
        }

		imageRenderer.drawDicomImage(false);
	}
	//evt.target.style.cursor = "crosshair";
};

VolumeMeasurement.prototype.hanleMouseUp = function(evt) {	
	if(evt.which === 3) {
        var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft))-5;
        var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop))-5;
            var measurementDelData = {
                                    x : pointX,
                                    y : pointY,
                                    measureType : "volumedelete" 
                               };

		dicomViewer.measurement.setTempData(measurementDelData);
		if (!dicomViewer.measurement.isVolumeMeasurementEnd()) {
		    if (this.measurementData.measureType === "volumeeditmove") {
				this.measurementData.measureType = "volume";
			}
		}

		this.activeImageRenderer.drawDicomImage(false);
	}else if(evt.which === 1) {
        if (this.measurementData.measureType === "volumeeditmove") {
            this.measurementData.measureType = "volumeedit";
            this.isMousePressed = false;
            dicomViewer.measurement.setVolumeMeasurementEnd(false);
            this.activeImageRenderer.drawDicomImage(false);
            dicomViewer.measurement.setDataToEdit('edit');
        }
    }
	
};


VolumeMeasurement.prototype.hanleDoubleClick = function(evt) {
    var imageRenderer = this.activeImageRenderer;
    this.isMousePressed = false;
	if (imageRenderer === undefined) 
	{		
		return;
	}
	if(evt === undefined)
	{
		this.measurementData.end.handleActive = false;
        this.measurementData.measureType = "volume";
        dicomViewer.measurement.setTempData(this.measurementData);
        dicomViewer.measurement.setVolumeMeasurementEnd(false);
	}
	else if(evt.type === "dblclick")
    {   
        var widget = imageRenderer.getRenderWidget(); 
        var pt = this.hitTestAndGetMousePosition(evt);
        this.measurementData.end.x = pt.x;
        this.measurementData.end.y = pt.y;
        this.measurementData.end.handleActive = false;
        this.measurementData.measureType = "volume";
        dicomViewer.measurement.setTempData(this.measurementData);
        dicomViewer.measurement.setVolumeMeasurementEnd(false);
    }
    
	dicomViewer.measurement.setDataToEdit(undefined);
    this.activeImageRenderer.drawDicomImage(false);
    dicomViewer.measurement.setTempData(undefined);
};function MouseTool() {
	this.isMousePressed = false;
	this.activeImageRenderer;
    this.ToolType;
}

MouseTool.prototype.hanleMouseUp = function(evet) {
	this.isMousePressed = false;
};

MouseTool.prototype.hanleMouseOver = function(evet) {
	this.isMousePressed = false;
};

MouseTool.prototype.hanleMouseOut = function(evet) {
	this.isMousePressed = false;
};

MouseTool.prototype.hanleMouseDown = function(evet) {
	this.isMousePressed = true;
};

MouseTool.prototype.hanleDoubleClick = function(evet){
};


MouseTool.prototype.hanleMouseMove = function(evet) {
};

MouseTool.prototype.isMousePressed = function() {
	return this.isMousePressed;
};

MouseTool.prototype.getActiveImageRenderer = function() {
	return this.activeImageRenderer;
};

MouseTool.prototype.setActiveImageRenderer = function(activeImageRenderer) {
	this.activeImageRenderer = activeImageRenderer;
};

MouseTool.prototype.hitTestAndGetMousePosition = function(evt, isTextAreaEvent) {
    try
    {
        // Check whether the render object is valid
        if(this.activeImageRenderer === undefined || this.activeImageRenderer === null) {
            return undefined;
        }

        // Get the image object to get the current presentation 
        var imageCanvas = null;
        this.activeImageRenderer.imagePromise.then(function(image) {
            imageCanvas = image;
        });

        // Calculate the image region with in the viewport region
        var canvas = this.activeImageRenderer.getRenderWidget();
        var viewportRect = canvas.getBoundingClientRect();
        var viewportLeftOffset = (viewportRect.left < 0 ? 0 : viewportRect.left);
        var viewportTopOffset = (viewportRect.top < 0 ? 0 : viewportRect.top);
        var scale = parseFloat(this.activeImageRenderer.scaleValue);
        var canvasMidX = viewportRect.width / 2;
        var canvasMidY = viewportRect.height / 2;
        var scaledImageWidth = (imageCanvas.columns * scale);
        var scaledImageHeight = (imageCanvas.rows * scale);
        var imageMidX = scaledImageWidth / 2;
        var imageMidY = scaledImageHeight / 2;
        var x = Math.round(canvasMidX - imageMidX);
        var dx = Math.round(canvasMidX + imageMidX);
        var y = Math.round(canvasMidY - imageMidY);
        var dy = Math.round(canvasMidY + imageMidY);

        // Get the current mouse position
        var pointX = 0;
        var pointY = 0;
        if(evt.touches === undefined) {
            if(evt.offsetX !== undefined && evt.offsetY !== undefined && isTextAreaEvent != true) {
                pointX = evt.offsetX - 5;
                pointY = evt.offsetY - 5;
            } else {
                pointX = evt.pageX - viewportLeftOffset;
                pointY = evt.pageY - viewportTopOffset;
            }
        } else if(evt.touches.length > 0) {
            //Touch event
            pointX = evt.touches[0].pageX - viewportLeftOffset;
            pointY = evt.touches[0].pageY - viewportTopOffset;
        } else if(evt.changedTouches.length > 0){
            pointX = evt.changedTouches[0].pageX - viewportLeftOffset;
            pointY = evt.changedTouches[0].pageY - viewportTopOffset;
        }

        // Assign the default X value if the current mouse X value is not in the viewport region.
        if(pointX < 0) {
            pointX = 5
        } else if (pointX >= viewportRect.width) {
            pointX = viewportRect.width - 5;
        }

        // Assign the default Y value if the current mouse Y value is not in the viewport region.
        if(pointY < 0) {
            pointY = 5
        } else if (pointY >= viewportRect.height) {
            pointY = viewportRect.height - 5;
        }

        // Update the point X position based on the image region
        if(pointX < x) {
            pointX = x;
        } else if(pointX > dx) {
            pointX = dx;
        }

        // Update the point Y position based on the image region
        if(pointY < y) {
            pointY = y;
        } else if(pointY > dy) {
            pointY = dy;
        }

        // Check whether the current point is in the image region
        var isPtInRegion = false;
        if ((pointX > x && pointX < dx) && (pointY > y && pointY < dy)) {
            isPtInRegion = true;
        }

        // Set the cursor
        // TODO: Set the cursor based on the tool type

        return { x : pointX, y : pointY, isPtInRegion : isPtInRegion, xOffset: x, yOffset: y };
    }
    catch(e) 
    { }

    return undefined;
};Pan.prototype = new MouseTool();
Pan.prototype.constructor = Pan;
var lastX,lastY;

function Pan() { }

Pan.prototype.hanleMouseDown = function(evt) {
    this.isMousePressed = true;
	document.body.style.mozUserSelect = document.body.style.webkitUserSelect = document.body.style.userSelect = 'none';	
	if(dicomViewer.scroll.isCineRunning(dicomViewer.getActiveSeriesLayout().getSeriesLayoutId())) {
        return;
    }
	var seriesLayout = dicomViewer.getActiveSeriesLayout();
	$("#" + seriesLayout.getSeriesLayoutId() + " div").each(function() {
		var imageLevelId = $(this).attr('id');
		var imageRender  = seriesLayout.getImageRender(imageLevelId);
		if(imageRender) {
			var widget = imageRender.getRenderWidget();
            if(evt.type === "touchstart")
            {
                var touch = evt.touches[0];
                lastX = touch.pageX;
                lastY = touch.pageY;
            }
            else
            {
                lastX = evt.offsetX || (evt.pageX - widget.offsetLeft);
			     lastY = evt.offsetY || (evt.pageY - widget.offsetTop);	
            }
					
		}
	});	
	evt.preventDefault();	
};

Pan.prototype.hanleMouseMove = function(evt) {	
    var imageRenderer = this.activeImageRenderer;
    if (this.isMousePressed && imageRenderer !== undefined && imageRenderer.imagePromise !== undefined) {
        if(dicomViewer.scroll.isCineRunning(dicomViewer.getActiveSeriesLayout().getSeriesLayoutId())) {
            return;
        }
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
         var tmplastX = tmplastY = 0;
        if(evt.type === "touchstart")
        {
            var touch = evt.touches[0];
            tmplastX = touch.pageX;
            tmplastY = touch.pageY;
        }
        else
        {
            tmplastX = evt.offsetX;
            tmplastY = evt.offsetY;
        }
        
        $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function() {
            var imageLevelId = $(this).attr('id');
            var imageRender = seriesLayout.getImageRender(imageLevelId);
            if(imageRender) {
                var widget = imageRender.getRenderWidget();
                if(evt.type === "touchmove")
                {
                    var touch = evt.touches[0];
                    tmplastX = touch.pageX;
                    tmplastY = touch.pageY;
                }
                else
                {
                    tmplastX = evt.offsetX || (evt.pageX - widget.offsetLeft);
                    tmplastY = evt.offsetY || (evt.pageY - widget.offsetTop);
                }
                
                
                if(lastX === undefined || lastY === undefined ) {
                    lastX = imageRender.getRenderWidget().width/2;
                    lastY = imageRender.getRenderWidget().height/2;
                }
                var dragStart = {
                    x : (tmplastX - lastX),
                    y : (tmplastY - lastY)
                };
                imageRender.doDragPan(dragStart, tmplastX, tmplastY);
            }
        });	
        lastX = tmplastX;
        lastY = tmplastY;
    }
};

Pan.prototype.hanleMouseUp = function(evt) {
	this.isMousePressed = false;
};

Pan.prototype.showHUvalue= function(x,y) {	
	/*var hupanel = document.getElementById("huDisplayPanel");
	hupanel.innerHTML = "WindowCenter :" + x + " WindowWidth :" + y;*/
};DefaultTool.prototype = new MouseTool();
DefaultTool.prototype.constructor = DefaultTool;

function DefaultTool()
{
    this.ToolType = "defaultTool";
    this.isDefaultToolActivated = false;
}

DefaultTool.prototype.hanleMouseDown = function(evt) {
    this.isMousePressed = true;
    this.isDefaultToolActivated = false;
    if(this.activeImageRenderer) {
        dicomViewer.measurement.removeTempdata();
    }

    evt.preventDefault();
};

DefaultTool.prototype.hanleMouseMove = function(evt) {
    if(this.isMousePressed && !this.isDefaultToolActivated) {
        this.isDefaultToolActivated = true;
         if(this.activeImageRenderer) {
            this.activeImageRenderer.doClickDefaultTool();
             evt.type = "mousedown";
             dicomViewer.mouseTools.getActiveTool().hanleMouseDown(evt);
        }
    }
};

DefaultTool.prototype.hanleDoubleClick = function(evt) {

};

DefaultTool.prototype.hanleMouseUp = function(evt) {
    this.isMousePressed = false;
    this.isDefaultToolActivated = false;
    if (evt.which === 3) {
        var imageRender = this.activeImageRenderer;
        if(imageRender === undefined || imageRender === null) {
            // Invalid render object
            return;
        }

        var pt = this.hitTestAndGetMousePosition(evt);

        // HitTest line measurement
        if(this.setAndValidateMeasurementDelete(pt, "linedelete")) {
            return;
        }    

        // HitTest point measurement
        if(this.setAndValidateMeasurementDelete(pt, "pointdelete")) {
            return;
        }

        // HitTest angle measurement
        if(this.setAndValidateMeasurementDelete(pt, "angledelete")) {
            return;
        }

        // HitTest ellipse measurement
        if(this.setAndValidateMeasurementDelete(pt, "ellipsedelete")) {
            return;
        }

        // HitTest trace measurement
        if(this.setAndValidateMeasurementDelete(pt, "tracedelete")) {
            return;
        }

        // HitTest volume measurement
        if(this.setAndValidateMeasurementDelete(pt, "volumedelete")) {
            return;
        }

        // HitTest mitralGradient measurement
        if(this.setAndValidateMeasurementDelete(pt, "mitralGradientdelete")) {
            return;
        }

        // HitTest rectangle measurement
        if(this.setAndValidateMeasurementDelete(pt, "rectangledelete")) {
            return;
        }

        if(this.setAndValidateMeasurementDelete(pt, "pendelete")) {
            return;
        }
    }
};

DefaultTool.prototype.setAndValidateMeasurementDelete = function(pt, deleteType) {
    dicomViewer.measurement.setTempData({ x: pt.x, y: pt.y, measureType: deleteType});
    this.activeImageRenderer.drawDicomImage(true);
    var dataToedit = dicomViewer.measurement.getDataToDelete();
    if(dataToedit === undefined || dataToedit.key === "") {
        return false;
    }

    return true;
};PointMeasurement.prototype = new MouseTool();
PointMeasurement.prototype.constructor = PointMeasurement;

function PointMeasurement() {
    this.ToolType = "pointMeasurement";
    this.measurementData = {
        start: {
            handleActive: false
        },
        end: {
            handleActive: false
        },
        style : {},
        studyUid:undefined,
        measureType: "point",
        measurementId: null,
        measurementType: null,
        measurementUnits: null,
        isEditable: "undefined",
        sessionType: "undefined"
    };
}

PointMeasurement.prototype.hanleMouseDown = function(evt) {
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    dicomViewer.measurement.setLineMeasurementEnd(false);
    var editData = dicomViewer.measurement.getDataToEdit();
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
    this.measurementData.isEditable = true;
    this.measurementData.sessionType = 0;
    var widget = imageRenderer.getRenderWidget();
    if (evt.type === "mousedown" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || editData !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        } else {
            this.isMousePressed = false;
        }
    }

    var measurementType = dicomViewer.measurement.draw.getMeasurementType();
    this.measurementData.measurementId = measurementType.measurementId;
    this.measurementData.measurementType = measurementType.measurementType;
    this.measurementData.measurementUnits = measurementType.measurementUnits;
    this.measurementData.textPosition = dicomViewer.measurement.pointTextPosition(this.measurementData, imageRenderer);
};

PointMeasurement.prototype.hanleMouseMove = function(evt) {
    this.measurementData.start.handleActive = true;
    var imageRenderer = this.activeImageRenderer;
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    if (!this.isMousePressed) {
        return;
    }
    var widget = imageRenderer.getRenderWidget();
    if (this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }

        dicomViewer.measurement.setTempData(this.measurementData);
        this.isMousePressed = true;
    } else {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
        }

        if (dataToEdit === undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);
        } else {
           /* if (dataToEdit.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else */{
				this.measurementData.measurementType = 1;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                this.measurementData.start.handleActive = true;
                this.measurementData.measureType = dataToEdit.measurmentType;
                this.measurementData.measurementType = 1;//dataToEdit.measurmentType;
                dicomViewer.measurement.setTempData(this.measurementData);
                this.measurementData = {
                    start: {
                        handleActive: true
                    },
                    end: {
                        handleActive: false
                    },
                    measureType: dataToEdit.measurmentType
                };
            }
        }
        imageRenderer.drawDicomImage(false);
    }
};

PointMeasurement.prototype.hanleMouseUp = function(evt) {
    dicomViewer.measurement.resetHandeler();
    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
        if(this.isMousePressed = true) {
            this.isMousePressed = false;
        }
    }
    if (evt.type === "mouseup" && evt.which === 3 || isTouchContextMenu) {
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "pointdelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft)) - 5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop)) - 5;
            var measurementDelData = {
                x: pointX,
                y: pointY,
                measureType: "pointdelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        this.activeImageRenderer.drawDicomImage(false);
    }
    if (this.isMousePressed) {
        this.isMousePressed = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if (evt.type === "mouseup" || evt.type === "mouseout" || evt.type === "touchend") {
            var pt = this.hitTestAndGetMousePosition(evt);
            if(pt !== undefined) {
                this.measurementData.end.x = pt.x;
                this.measurementData.end.y = pt.y;
            } else {
                // touchend will return undefined. Maintain the last touchmove point as the end point
                if(this.measurementData.end.x === undefined || this.measurementData.end.y === undefined) {
                    this.measurementData.end.x = this.measurementData.start.x;
                    this.measurementData.end.y = this.measurementData.start.y;
                }
            }

            this.measurementData.end.handleActive = false;
        }

        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if (dataToEdit == undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(true);
            this.measurementData.start.handleActive = false;
            dicomViewer.measurement.setTempData(this.measurementData);
            this.measurementData = {
                start: {
                    handleActive: false
                },
                end: {
                    handleActive: false
                },
                measureType: "point"
            };
        } else {
            this.measurementData.measureType = dataToEdit.measurmentType;
            this.measurementData.start.handleActive = true;
            dicomViewer.measurement.setTempData(this.measurementData);
            this.measurementData = {
                start: {
                    handleActive: false
                },
                end: {
                    handleActive: false
                },
                measureType: dataToEdit.measurmentType
            };

        }
		  if (dataToEdit == undefined) {
        imageRenderer.drawDicomImage(false, undefined , true);
		  }
    }
};

PointMeasurement.prototype.hanleDoubleClick = function(evt) {

    var dataToEdit = dicomViewer.measurement.getDataToEdit();
	if(dataToEdit != undefined)
	{
    var imageRenderer = this.activeImageRenderer;
    var widget = imageRenderer.getRenderWidget();
    if (evt === undefined || evt.which === 1 || evt.type === "mouseout") {
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
        var keyArray = key.split("_");
		var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
        if(isFullScreenEnabled){
            parentDiv = previousLayoutSelection;
        }
        var measurement = dicomViewer.measurement.getMeasurements(keyArray[0], keyArray[1]);
        if (measurement === undefined)
            return;
        measurement = measurement[arrayIndex];
     
        measurement.start.handleActive = false;
        measurement.end.handleActive = false;
        dicomViewer.measurement.setDataToEdit(undefined);
        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "point"
        };
		 measurementResult = dicomViewer.measurement.draw.drawPointMeasurement(keyArray[0], widget, measurement, imageRenderer.getPresentation(), imageRenderer, "edit");
        if (measurementResult != null) {
            sendMeasurement(measurementResult.id, measurementResult.value);
        }
		dicomViewer.measurement.removeTempdata();
		this.activeImageRenderer.drawDicomImage(false, undefined, true);

	}
	}
};

PointMeasurement.prototype.hanleMouseOut = function(evt) {
        this.hanleDoubleClick(evt);
};
function ToolList()
{
	this.currentTool = TOOLNAME_WINDOWLEVEL;
	this.toolList = new Array();
	this.init();
};

ToolList.prototype.init = function()
{
	this.toolList["panTool"] = new Pan();
	this.toolList[TOOLNAME_WINDOWLEVEL] = new WindowLevel();
	this.toolList[TOOLNAME_ZOOM] = new ZoomTool();
    this.toolList[TOOLNAME_WINDOWLEVEL_ROI] = new WindowLevelROI();
};

ToolList.prototype.getActiveTool = function()
{
	return this.toolList[this.currentTool];
};

ToolList.prototype.getActiveToolName = function()
{
	return this.currentTool;
};

ToolList.prototype.getWindowLevelObject = function()
{
	return this.toolList[TOOLNAME_WINDOWLEVEL];
};

ToolList.prototype.getPanToolObject = function()
{
	return this.toolList["panTool"];
};

ToolList.prototype.getZoomToolObject = function()
{
	return this.toolList[TOOLNAME_ZOOM];
};

ToolList.prototype.getWindowLevelROIObject = function()
{
	return this.toolList[TOOLNAME_WINDOWLEVEL_ROI];
};
WindowLevel.prototype = new MouseTool();
WindowLevel.prototype.constructor = WindowLevel;
function WindowLevel() {
    this.mouseDrag = {
        start : {},
        end : {}
    }
    this.previousPos = {};

    // Brought the logic from ISI Rad
    this.startLevel = 0;
    this.startWindow = 0;
    this.windowUnitsPerPixelLeft = 0;
    this.windowUnitsPerPixelRight = 0;
    this.levelUnitsPerPixelUp = 0;
    this.levelUnitsPerPixelDown = 0;
    this.minLevelValue = 0;
    this.maxLevelValue = 0;
    this.minWindowValue = 1;
    this.maxWindowValue = 0;
    this.isWinLevReversed = false;
}

WindowLevel.prototype.hanleMouseDown = function(evt) {
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer !== undefined && imageRenderer.imagePromise !== undefined) {
        var presentation = imageRenderer.getPresentation();
        if (presentation) {
            var imageCanvas = null;
            imageRenderer.imagePromise.then(function(image){
                imageCanvas = image;
            });
            this.startWindow = presentation.getWindowWidth();
            this.startLevel = presentation.getWindowCenter();
            var offset = imageRenderer.locationOnScreen();
            if(evt.type === "mousedown"){
                this.mouseDrag.start.x = evt.pageX - offset.x;
                this.mouseDrag.start.y = evt.pageY - offset.y;
                this.updateWindowLevel(imageCanvas);
                this.previousPos = this.mouseDrag.start;
            }else if(evt.type === "touchstart"){
                evt.preventDefault();
                var touch = evt.touches[0];
                this.mouseDrag.start.x = touch.pageX - offset.x;
                this.mouseDrag.start.y = touch.pageY - offset.y;
                this.updateWindowLevel(imageCanvas);
                this.previousPos = this.mouseDrag.start;
            }
        }
    }
};

WindowLevel.prototype.hanleMouseMove = function(evt) {
    var currentPos = {};
    var imageRenderer = this.activeImageRenderer;
    if (this.isMousePressed && imageRenderer !== undefined && imageRenderer.imagePromise !== undefined) {
        var presentation = imageRenderer.getPresentation();
        if (presentation) {
            var offset = imageRenderer.locationOnScreen();
            if(evt.type === "mousemove"){
                currentPos.x = (evt.pageX - offset.x);
                currentPos.y = (evt.pageY - offset.y);
            }else if(evt.type === "touchmove"){
                evt.preventDefault();
                if (evt.touches.length == 1) {
                    var touch = evt.touches[0];
                    currentPos.x = (touch.pageX - offset.x);
                    currentPos.y = (touch.pageY - offset.y);
                }
            }

            var diffX = 0, diffY = 0;
            if (currentPos.x > this.previousPos.x) {
                diffX = -(Math.abs(this.previousPos.x - currentPos.x));
            }
            if (currentPos.x < this.previousPos.x) {
                diffX = (Math.abs(this.previousPos.x - currentPos.x));
            }
            if (currentPos.y > this.previousPos.y) {
                diffY = -(Math.abs(this.previousPos.y - currentPos.y));
            }
            if (currentPos.y < this.previousPos.y) {
                diffY = (Math.abs(this.previousPos.y - currentPos.y));
            }

            if (diffX == 0 && diffY == 0) {
                return;
            }

            this.previousPos = currentPos;
            //console.log(diffX, diffY);

            if (currentPos.x >= 0
            && currentPos.y >= 0
            && currentPos.x < imageRenderer.renderWidget.width
            && currentPos.y < imageRenderer.renderWidget.height
            && ((evt.type === "touchmove" && evt.touches.length == 1) || evt.type === "mousemove"))
            {
                var deltaX = diffX;
                var deltaY = diffY;
                var deltaWindow = 0;
                var deltaLevel = 0;

                if(this.isWinLevReversed) {
                    deltaWindow = deltaX;
                    deltaLevel = deltaY;
                    deltaWindow *= deltaX > 0 ? this.windowUnitsPerPixelRight : this.windowUnitsPerPixelLeft;
                    deltaLevel *= deltaY > 0 ? this.levelUnitsPerPixelUp : this.levelUnitsPerPixelDown;
                } else {
                    deltaWindow = deltaY;
                    deltaLevel = deltaX;
                    deltaWindow *= deltaY > 0 ? this.windowUnitsPerPixelRight : this.windowUnitsPerPixelLeft;
                    deltaLevel *= deltaX > 0 ? this.levelUnitsPerPixelUp : this.levelUnitsPerPixelDown;
                }

                var window = this.startWindow + deltaWindow;
                var level = this.startLevel + deltaLevel;

                // Validate the window level values.
                if (window < this.minWindowValue) {
                    window = this.minWindowValue;
                } else if (window > this.maxWindowValue) {
                    window = this.maxWindowValue;
                }

                if (level < this.minLevelValue) {
                    level = this.minLevelValue;
                } else if (level > this.maxLevelValue) {
                    level = this.maxLevelValue;
                }

                this.startWindow = window;
                this.startLevel = level;

                var seriesLayout = dicomViewer.getActiveSeriesLayout();
                $("#"+seriesLayout.getSeriesLayoutId()+" div").each(function(){
                    var imageLevelId = $(this).attr('id');
                    var imageRender  = seriesLayout.getImageRender(imageLevelId);
                    if(imageRender) {
                        imageRender.getPresentation().setWindowingdata(level, window);
                        imageRender.getPresentation().windowLevel = 0;
                        imageRender.renderImage(false);
                        dicomViewer.tools.updateWindowLevelSettings(-1);
                    }
                });
            }
        }
    }
};

WindowLevel.prototype.hanleMouseUp = function(evt) {
     this.isMousePressed = false;
};

WindowLevel.prototype.hanleMouseOut = function(evt) {
     this.isMousePressed = false;
};

/**
 * Update the window/level values
 * @param {Type} image - Specifies the image
 */ 
WindowLevel.prototype.updateWindowLevel = function (image) {
    var presentation = image.presentation;
    this.minLevelValue = presentation.windowLevelLimits.wcLimit.min;
    this.maxLevelValue = presentation.windowLevelLimits.wcLimit.max;
    this.minWindowValue = presentation.windowLevelLimits.wwLimit.min;
    this.maxWindowValue = presentation.windowLevelLimits.wwLimit.max;

    var windowLeft = this.startWindow;
    var windowRight = this.maxWindowValue - windowLeft;
    var levelUp = this.maxLevelValue - this.startLevel;
    var levelDown = this.startLevel - this.minLevelValue;

    if(!image.isColorImage) {
        levelUp = this.minLevelValue - this.startLevel;
        levelDown = this.startLevel - this.maxLevelValue;
    }

    var pixelsLeft = 1;
    if(this.mouseDrag.start.x > 0) {
        pixelsLeft = this.mouseDrag.start.x;
    }

    var pixelsRight = this.activeImageRenderer.renderWidget.width - this.mouseDrag.start.x;
    var pixelsUp = 1;
    if(this.mouseDrag.start.y > 0) {
        pixelsUp = this.mouseDrag.start.y;
    }

    var pixelsDown =this.activeImageRenderer.renderWidget.height - this.mouseDrag.start.y;
    if(this.isWinLevReversed) {
        this.windowUnitsPerPixelLeft = windowLeft / pixelsLeft;
        this.windowUnitsPerPixelRight = windowRight / pixelsRight;
        this.levelUnitsPerPixelUp = levelUp / pixelsUp;
        this.levelUnitsPerPixelDown = levelDown / pixelsDown;
    } else {
        this.windowUnitsPerPixelLeft = windowLeft / pixelsDown;
        this.windowUnitsPerPixelRight = windowRight / pixelsUp;
        this.levelUnitsPerPixelUp = levelUp / pixelsRight;
        this.levelUnitsPerPixelDown = levelDown / pixelsLeft;
    }
};/**
 * Zoom Tool
 */
ZoomTool.prototype = new MouseTool();
ZoomTool.prototype.constructor = ZoomTool;
var lastX,lastY;

function ZoomTool() { }

ZoomTool.prototype.hanleMouseDown = function(evt) {
    this.isMousePressed = true;
    if(dicomViewer.scroll.isCineRunning(dicomViewer.getActiveSeriesLayout().getSeriesLayoutId())) {
        return;
    }
	document.body.style.mozUserSelect = document.body.style.webkitUserSelect = document.body.style.userSelect = 'none';
    var seriesLayout = dicomViewer.getActiveSeriesLayout();
	$("#" + seriesLayout.getSeriesLayoutId() + " div").each(function() {
		var imageLevelId = $(this).attr('id');
		var imageRender  = seriesLayout.getImageRender(imageLevelId);
		if(imageRender) {
			var widget = imageRender.getRenderWidget();
            if(evt.type === "touchstart")
            {
                var touch = evt.touches[0];
                lastX = touch.pageX;
			     lastY = touch.pageY;	
            }
            else
            {
                lastX = evt.offsetX || (evt.pageX - widget.offsetLeft);
			     lastY = evt.offsetY || (evt.pageY - widget.offsetTop);	
            }
					
		}
	});	
	evt.preventDefault();	
};

ZoomTool.prototype.hanleMouseMove = function(evt) {
    var imageRenderer = this.activeImageRenderer;
    if (this.isMousePressed && imageRenderer !== undefined && imageRenderer.imagePromise !== undefined) {
        if(dicomViewer.scroll.isCineRunning(dicomViewer.getActiveSeriesLayout().getSeriesLayoutId())) {
            return;
        }
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var tmplastX = tmplastY = 0;
        if(evt.type === "touchmove")
        {
            var touch = undefined;
            var firstTouch = evt.touches[0];
            var secondTouch = evt.touches[1];

            //Getting the type of gesture whether it is one touch or multi-touch(Pinch-in/Pinch-out)
            if(evt.touches.length == 1) {
                touch = firstTouch;
            } else if(firstTouch.clientX < secondTouch.clientX && firstTouch.clientY < secondTouch.clientY) {
                touch = firstTouch;
            } else if((firstTouch.clientX > secondTouch.clientX && firstTouch.clientY > secondTouch.clientY)){
                touch = secondTouch;
            } else if(firstTouch.clientX > secondTouch.clientX && firstTouch.clientY < secondTouch.clientY) {
                touch = firstTouch;
            } else if(firstTouch.clientX < secondTouch.clientX && firstTouch.clientY > secondTouch.clientY) {
                touch = secondTouch;
            }
            tmplastX = touch.pageX;
            tmplastY = touch.pageY;
        }
        else
        {
            tmplastX = evt.offsetX || (evt.pageX - widget.offsetLeft);
            tmplastY = evt.offsetY || (evt.pageY - widget.offsetTop);
        }
        
        //var delta = Math.max((lastX - tmplastX),(lastY - tmplastY));
        var delta=0;
        var tempX = lastX - tmplastX;
        var tempY = lastY - tmplastY;
        if(Math.abs(tempX) > Math.abs(tempY)) {
            delta = tempX;
        }else {
            delta = tempY;
        }

        if(delta != 0) {
            $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function() {
                    var imageLevelId = $(this).attr('id');
                    var imageRender = seriesLayout.getImageRender(imageLevelId);
                    if(imageRender) {				
                        if(lastX === undefined || lastY === undefined) {
                            lastX = imageRender.getRenderWidget().width/2;
                            lastY = imageRender.getRenderWidget().height/2;
                        }
                        imageRender.doZoom(delta,tmplastX,tmplastY);				
                    }
            });
        }
        lastX = tmplastX;
        lastY = tmplastY;
    }
};

ZoomTool.prototype.hanleMouseUp = function(evt) {
	this.isMousePressed = false;
};

ZoomTool.prototype.hanleMouseWheel = function(evt) {
    if(dicomViewer.scroll.isCineRunning(dicomViewer.getActiveSeriesLayout().getSeriesLayoutId())) {
        return;
    }
	lastX = evt.offsetX || (evt.pageX - widget.offsetLeft);
    lastY = evt.offsetY || (evt.pageY - widget.offsetTop);
	var delta = evt.wheelDelta ? evt.wheelDelta/40 : evt.detail ? -evt.detail : 0;
	if (delta) {
		//zoom(delta);
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
		$("#"+seriesLayout.getSeriesLayoutId()+" div").each(function() {
			var imageLevelId = $(this).attr('id');
			var imageRender  = seriesLayout.getImageRender(imageLevelId);
			if(imageRender) {
				if(typeof lastX =='undefined') {
					lastX = imageRender.getRenderWidget().width/2;
					lastY = imageRender.getRenderWidget().height/2;
				}
			//	evt.target.style.cursor = "url(./images/toolbar/24x24/zoomin.png), auto";
				imageRender.doZoom(delta,lastX,lastY);
			}
		});
	}
	return evt.preventDefault() && false;
};MitralMeanGradientMeasurement.prototype = new MouseTool();
MitralMeanGradientMeasurement.prototype.constructor = MitralMeanGradientMeasurement;
var leftClickEndPoints = undefined;
function MitralMeanGradientMeasurement()
{
    this.ToolType = "mitralMeanGradientMeasurement";
    this.measurementData = {
        start : {handleActive : false},
        end : {handleActive : false},
        style : {},
        studyUid:undefined,
        measureType: "mitralGradient",
        measurementId : null,
        measurementType: null,
        measurementUnits : null,
        measurementComplete: false,
        displayMeasurement : false,
        measurementIndex : null,
        measurementSubType: "mitral",
        isEditable: "undefined",
        sessionType: "undefined"
    };
}

MitralMeanGradientMeasurement.prototype.hanleMouseDown = function(evt){
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(isMobileDevice && dataToEdit !== undefined) {
        this.isMousePressed = true;
    }
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    if(evt.which == "3"){
        return;
    }

    if(!dicomViewer.measurement.isMitralMeanGradientMeasurementEnd()){
        dicomViewer.measurement.setMitralMeanGradientMeasurementEnd(true);
        dicomViewer.measurement.setMitralMeanGradientMeasurementId(dicomViewer.measurement.getMitralMeanGradientMeasurementId() +1);
        this.measurementData.measurementIndex = dicomViewer.measurement.getMitralMeanGradientMeasurementId();
    }
    if (this.isMousePressed) {
        this.isMousePressed = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
        this.measurementData.isEditable = true;
        this.measurementData.sessionType = 0;
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if(evt.type === "mouseup" || evt.type === "touchstart") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = false;
        }
        leftClickEndPoints = this.measurementData.end;
        this.measurementData.textPosition = dicomViewer.measurement.pointTextPosition(this.measurementData, imageRenderer);
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
		//dicomViewer.measurement.addMeasurements(imageUid,frameIndex,imageRenderer,this.measurementData);
        this.measurementData = {
            start : {handleActive : false},
            end : {handleActive : false},
            measureType : "mitralGradient",
            measurementIndex : dicomViewer.measurement.getMitralMeanGradientMeasurementId(),
            displayMeasurement : false,
            style : dicomViewer.measurement.draw.getMeasurementStyle()
        };
        imageRenderer.drawDicomImage(false);
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if (dataToEdit != undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.resetHandeler();
            return;
        }
    }
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    dicomViewer.measurement.setLineMeasurementEnd(false);
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    
    var widget = imageRenderer.getRenderWidget();
    if(evt.type === "mousedown" || evt.type === "mouseout" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || evt.type === "mouseout" || dataToEdit !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            this.measurementData.measurementSubType = this.measurementSubType;
        } else {
            this.isMousePressed = false;
        }
    }
    var measurementType = dicomViewer.measurement.draw.getMeasurementType();
    this.measurementData.measurementId = measurementType.measurementId;
    this.measurementData.measurementType = measurementType.measurementType;
    this.measurementData.measurementUnits = measurementType.measurementUnits;
    //for mobile devices not getting the touchend that's why drawing the point on every touchstart
    if(evt.type == "touchstart") {
        dicomViewer.measurement.setTempData(this.measurementData);
        imageRenderer.drawDicomImage(false);
    }
};

MitralMeanGradientMeasurement.prototype.hanleMouseMove = function(evt, isDoubleClick) {
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(isMobileDevice && dataToEdit !== undefined) {
        this.isMousePressed = true;
    }
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    if(!this.isMousePressed) {
        return;
    }
    
    if(evt.which == "3"){
        return;
    }
    var widget = imageRenderer.getRenderWidget();
    if(this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if(evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }
        this.isMousePressed = true;
    } else {
        if(evt.type === "mousemove" || evt.type === "touchmove" || isDoubleClick) {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
        }
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if(dataToEdit != undefined) {
            if(dataToEdit.measurmentType === "line")
            {
                dicomViewer.tools.do2DMeasurement(0, null, null)
            } else if(dataToEdit.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                var pt = this.hitTestAndGetMousePosition(evt);
                this.measurementData.start.x = pt.x;
                this.measurementData.start.y = pt.y;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                dicomViewer.measurement.setTempData(this.measurementData);
            }
        } else {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);
        }
        imageRenderer.drawDicomImage(false, undefined, true);
    }
	//evt.target.style.cursor = "crosshair";
};

MitralMeanGradientMeasurement.prototype.hanleMouseUp = function(evt) {
    if(evt.which == "3" && dicomViewer.measurement.isMitralMeanGradientMeasurementEnd()){
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined)
    {
        return;
    }
    var imageUid = undefined;
    var frameIndex = undefined;
    imageRenderer.imagePromise.then(function(image) {
        imageUid = image.imageUid;
        frameIndex = image.frameNumber;
    });
    var mitralMeasurements = dicomViewer.measurement.getMitralGradientMeasurements(imageUid, frameIndex);
    if(mitralMeasurements != undefined && leftClickEndPoints != undefined){
        dicomViewer.measurement.setLineMeasurementEnd(true);
        if(this.measurementData != undefined){
            this.measurementData.start.x = leftClickEndPoints.x;
            this.measurementData.start.y = leftClickEndPoints.y;
            this.measurementData.end.x = leftClickEndPoints.x;
            this.measurementData.end.y = leftClickEndPoints.y;
        }
        leftClickEndPoints = undefined;
        dicomViewer.measurement.setTempData(this.measurementData);
        this.measurementData = {
                                start : {handleActive : false},
                                end : {handleActive : false},
                                measureType : "mitralGradient",
                                measurementIndex : dicomViewer.measurement.getMitralMeanGradientMeasurementId(),
                                displayMeasurement : false
                               };
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.setLineMeasurementEnd(false);
        this.hanleDoubleClick(evt);
        dicomViewer.measurement.setDataToDelete();
    }
        return;
    }

    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
    }
    if(evt.which === 3 || isTouchContextMenu)
    {
        this.hanleDoubleClick();
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "mitralGradientdelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft))-5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop))-5;
            var measurementDelData = {
                x : pointX,
                y : pointY,
                measureType : "mitralGradientdelete" 
               };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        this.activeImageRenderer.drawDicomImage(false);
    }
};

MitralMeanGradientMeasurement.prototype.hanleMouseOut = function(evt) {
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(this.isMousePressed || dataToEdit != undefined) {
        this.hanleMouseDown(evt);
        this.hanleMouseMove(evt, true);
        this.hanleMouseDown(evt);
        this.hanleDoubleClick(evt);
    }
};

MitralMeanGradientMeasurement.prototype.hanleDoubleClick = function(evt) {
    var imageRenderer = this.activeImageRenderer;
    this.isMousePressed = false;
    if (imageRenderer === undefined) {
        return;
    }

    if(evt === undefined || evt.type === "dblclick" || evt.type === "mouseout" || evt.which == "3" || evt.type === "mousewheel") {
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        var mitralMeasurements = dicomViewer.measurement.getMitralGradientMeasurements(imageUid, frameIndex);
        if(mitralMeasurements != undefined){
            dicomViewer.measurement.resetMitralEditMode(imageUid, frameIndex, dataToEdit);
        }
        this.measurementData.displayMeasurement = true;
        dicomViewer.measurement.setMitralMeanGradientMeasurementEnd(false);
        if(dataToEdit != undefined) {
            dicomViewer.measurement.setTempData(undefined);
            dicomViewer.measurement.setDataToEdit(undefined);
        }
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.resetHandeler();
    }
};

/**
 * set the sub type
 * @param {Type} type - It specifies the measurement type(arrow,2Dline,etc..)
 */ 
MitralMeanGradientMeasurement.prototype.setMeasurementSubType = function (type) {
    this.measurementSubType = type;
};AngleMeasurementTool.prototype = new MouseTool();
AngleMeasurementTool.prototype.constructor = AngleMeasurementTool;

function AngleMeasurementTool()
{
    this.ToolType = "angleMeasurement";
    this.measurementData = {
        start : {handleActive : false},
        end : {handleActive : false},
        style : {},
        studyUid:undefined,
        measureType: "angle",
        measurementId : null,
        measurementType: null,
        measurementUnits : null,
        measurementComplete: false,
        displayMeasurement : false,
        isEditable: "undefined",
        sessionType: "undefined"
	};
}

var mouseDownCount = 0;
var mouseUpCount = 0;
var previousMousepointerX = 0;
var previousMousepointerY = 0;

AngleMeasurementTool.prototype.hanleMouseDown = function(evt) {
    if(mouseDownCount < 3) {
        mouseDownCount = mouseDownCount + 1;
    }
    else {
        mouseDownCount = 0;
    }
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(isMobileDevice && dataToEdit !== undefined) {
        this.isMousePressed = false;
    }
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()) {
        return;
    }

    if(!dicomViewer.measurement.isAngleMeasurementEnd()) {
        dicomViewer.measurement.setAngleMeasurementEnd(true);
        dicomViewer.measurement.setAngleMeasurementId(dicomViewer.measurement.getAngleMeasurementId() +1);
        this.measurementData.measurementId = dicomViewer.measurement.getAngleMeasurementId();
    }
    if (this.isMousePressed) {
        this.isMousePressed = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
        this.measurementData.isEditable = true;
        this.measurementData.sessionType = 0;
        if(evt.type === "mouseup") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = false;
        } else if(evt.type === "touchstop") {
            evt.preventDefault();
            var touch = evt.touches[0];
			//this.measurementData.end.x = touch.pageX - offset.x;
			//this.measurementData.end.y = touch.pageY - offset.y;
		}
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
        this.measurementData = {
            start : {handleActive : false},
            end : {handleActive : false},
            measureType : "angle",
            measurementId : dicomViewer.measurement.getAngleMeasurementId(),
            displayMeasurement : false
        };
        imageRenderer.drawDicomImage(false);
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if (dataToEdit != undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.resetHandeler();
            return;
        }
    }
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    dicomViewer.measurement.setLineMeasurementEnd(false);
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    var widget = imageRenderer.getRenderWidget();    
    if(evt.type === "mousedown") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || dataToEdit !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            if(mouseDownCount == 2) {
                this.measurementData.textPosition = dicomViewer.measurement.pointTextPosition(this.measurementData, imageRenderer);
            }
        } else {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.isMousePressed = false;
        }
    } else if(evt.type === "touchstart") {
        evt.preventDefault();
        if(this.isMousePressed) {
            var imageUid = undefined;
            var frameIndex = undefined;
            imageRenderer.imagePromise.then(function(image) {
                imageUid = image.imageUid;
                frameIndex = image.frameNumber;
            });
            this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
            this.measurementData.isEditable = true;
            this.measurementData.sessionType = 0;
        }
        var pt = this.hitTestAndGetMousePosition(evt);
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if(dataToEdit == undefined) {
            if(this.isMousePressed && this.measurementData.measureType == 'angle'){
                dicomViewer.measurement.increaseMousePressedCounter();
                if(dicomViewer.measurement.getMousePressedCounter() == "1"){
                    this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
                    this.isMousePressed = false;
                    this.measurementData.start.x = pt.x;
                    this.measurementData.start.y = pt.y;
                    this.measurementData.end.x = pt.x;
                    this.measurementData.end.y = pt.y;
                    this.measurementData.end.handleActive = true
                    dicomViewer.measurement.setTempData(this.measurementData);
                    this.activeImageRenderer.drawDicomImage(false);
                } else if(dicomViewer.measurement.getMousePressedCounter() == "2") {
                    this.isMousePressed = false;
                    this.measurementData.measureType = "angle";
                    this.measurementData.end.x = pt.x;
                    this.measurementData.end.y = pt.y;
                    dicomViewer.measurement.setLineMeasurementEnd(true);
                    dicomViewer.measurement.setTempData(this.measurementData);
                    this.activeImageRenderer.drawDicomImage(false);
                } else if(dicomViewer.measurement.getMousePressedCounter() == "3"){
                    this.isMousePressed = false;
                    dicomViewer.measurement.resetMousePressedCounter();
                    this.measurementData.start.x = pt.x;
                    this.measurementData.start.y = pt.y;
                    dicomViewer.measurement.setLineMeasurementEnd(true);
                    dicomViewer.measurement.setAngleMeasurementEnd(false);
                    dicomViewer.measurement.setTempData(this.measurementData);
                    this.activeImageRenderer.drawDicomImage(false);
                }
            }
        } else if(pt.isPtInRegion = true || dataToEdit != undefined) {
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        } else {
            this.isMousePressed = false;
        }
    }
};

AngleMeasurementTool.prototype.hanleMouseMove = function(evt) {
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(this.isMousePressed) {
        if(mouseDownCount == 3 && dataToEdit == undefined) {
            this.hanleMouseOut(evt);
            return;
        }
    }
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined)
    {
        this.isMousePressed = false;
        return;
    }
    if(!this.isMousePressed && dicomViewer.measurement.getMousePressedCounter() == "0")
    {
        return;
    }

    var widget = imageRenderer.getRenderWidget();    
    if(this.measurementData.start.x === undefined || this.measurementData.start.y === undefined)
    {
        if(evt.type === "mousemove")
        {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }
        else if(evt.type === "touchmove")
        {
            evt.preventDefault();
            return;
            var touch = evt.touches[0];
            //this.measurementData.start.x = touch.pageX - offset.x;
            //.measurementData.start.y = touch.pageY - offset.y;
        }
        this.isMousePressed = true;

    }
    else
    {
        if(evt.type === "mousemove")
        {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
        }
        else if(evt.type === "touchmove")
        {
            evt.preventDefault();
            //for mobile device, not allowing to draw angle shape while touch move
            if(dicomViewer.measurement.getDataToEdit() == undefined) {
                return;
            }
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
        }
        
        if(dataToEdit != undefined)
        {
            if(dataToEdit.measurmentType === "line")
            {
                dicomViewer.tools.do2DMeasurement(0, null, null)
            } else if(dataToEdit.measurmentType === "point")
            {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                var pt = this.hitTestAndGetMousePosition(evt);
                this.measurementData.start.x = pt.x;
                this.measurementData.start.y = pt.y;

                dicomViewer.measurement.setLineMeasurementEnd(false);
                dicomViewer.measurement.setTempData(this.measurementData);
            }
        }
        else
        {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);
        }
        imageRenderer.drawDicomImage(false, undefined, true);
    }
};

AngleMeasurementTool.prototype.hanleMouseUp = function(evt) {

    var pt = this.hitTestAndGetMousePosition(evt);
    previousMousepointerX = pt.x;
    previousMousepointerY = pt.y;

    if(mouseUpCount < 3) {
        mouseUpCount = mouseUpCount + 1;
    }
    else {
        mouseUpCount = 0;
    }

	dicomViewer.measurement.resetHandeler();
    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
        if(this.isMousePressed = true) {
            this.isMousePressed = false;
        }
    }
    if ((evt.type === "mouseup" && evt.which === 3) || isTouchContextMenu) {
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "angledelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft)) - 5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop)) - 5;
            var measurementDelData = {
                x: pointX,
                y: pointY,
                measureType: "angledelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        this.activeImageRenderer.drawDicomImage(false);
    }
    
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(dataToEdit == undefined)
    {
        if(this.isMousePressed && this.measurementData.measureType == 'angle'){
            dicomViewer.measurement.increaseMousePressedCounter();
        }

        if(dicomViewer.measurement.getMousePressedCounter() == "3"){
                mouseDownCount = 0;
                mouseUpCount = 0;
                dicomViewer.measurement.resetMousePressedCounter();
                this.isMousePressed = false;
                this.measurementData.displayMeasurement = true;
                dicomViewer.measurement.setAngleMeasurementEnd(false);
                this.activeImageRenderer.drawDicomImage(false);
            }
    }
};

AngleMeasurementTool.prototype.hanleDoubleClick = function(evt) {
    var imageRenderer = this.activeImageRenderer;
    if(evt != undefined) {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(previousMousepointerX == pt.x && previousMousepointerY == pt.y) {
            var imageUid = undefined;
            var frameIndex = undefined;
            imageRenderer.imagePromise.then(function(image) {
                imageUid = image.imageUid;
                frameIndex = image.frameNumber;
            });
            var angleMeasurements = dicomViewer.measurement.getAngleMeasurements(imageUid, frameIndex);
            if (angleMeasurements !== undefined && angleMeasurements.length !== 0) {
                measurements = angleMeasurements[angleMeasurements.length - 1];
                if (measurements != undefined && measurements.length >= 2) {
                    var firstArray = measurements[0];
                    var secondArray = measurements[1];
                    if((isNaN(secondArray.end.x) || isNaN(secondArray.end.y)) || ((secondArray.start.x == secondArray.end.x) || (secondArray.start.y == secondArray.end.y))) {
                        secondArray.end.x = firstArray.start.x + 50;
                        secondArray.end.y = firstArray.start.y + 50;
                    }
                this.activeImageRenderer.drawDicomImage(false);
                }
            }
        }
        else {
            previousMousepointerX = pt.x;
            previousMousepointerY = pt.y;
        }
    }

    this.isMousePressed = false;
    dicomViewer.measurement.resetMousePressedCounter();
    if (imageRenderer === undefined) {
        return;
    }

    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(dataToEdit != undefined) {
        if(evt === undefined || evt.type === "dblclick" || evt.type === "mouseout" || evt.type == "mousewheel") {
            var imageUid = undefined;
            var frameIndex = undefined;
            imageRenderer.imagePromise.then(function(image) {
                imageUid = image.imageUid;
                frameIndex = image.frameNumber;
            });
            dicomViewer.measurement.resetAngleEditMode(imageUid, frameIndex, dataToEdit);
            this.measurementData.displayMeasurement = true;
            dicomViewer.measurement.setAngleMeasurementEnd(false);
            dicomViewer.measurement.setDataToEdit(undefined);
            if(isMobileDevice()) {
                dicomViewer.measurement.removeTempdata();
            }
            imageRenderer.drawDicomImage(false);
        }
    }
    mouseDownCount = 0;
    mouseUpCount = 0;
};

AngleMeasurementTool.prototype.hanleMouseOut = function(evt) {
    var pt = this.hitTestAndGetMousePosition(evt);
    mouseDownCount = 0;
    mouseUpCount = 0;
    if(dicomViewer.measurement.getDataToEdit() !== undefined) {
        dicomViewer.measurement.removeTempdata();
        this.hanleDoubleClick(evt);
    } else if(dicomViewer.measurement.getMousePressedCounter() == 1) {
        this.hanleDoubleClick(evt);
        if (evt.which === 0 || evt.button == 0) {
            dicomViewer.measurement.setTempData({x: pt.x, y: pt.y, measureType: "angledelete"});
            this.activeImageRenderer.drawDicomImage(true);
        }
    } else if(dicomViewer.measurement.getMousePressedCounter() == 2) {
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
        this.hanleMouseUp(evt);
    }
};EllipseMeasurement.prototype = new MouseTool();
EllipseMeasurement.prototype.constructor = EllipseMeasurement;
var isLineExceededOutside = false;

function EllipseMeasurement() {
    this.ToolType = "ellipseMeasurement";
    this.measurementData = {
        start: {
            handleActive: false
        },
        end: {
            handleActive: false
        },
        first: {
        },
        second: {
        },
        third: {
        },
        fourth: {
        },
        center: {
        },
        style : {
        },
        studyUid:undefined,
        measureType: "ellipse",
        measurementSubType: "hounsfield",
        measurementId: null,
        measurementType: null,
        measurementComplete: false,
        measurementUnits: null,
        isLineExceededOutside: false,
        isEditable: "undefined",
        sessionType: "undefined"
    };
}

EllipseMeasurement.prototype.hanleMouseDown = function(evt) {
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    if(dicomViewer.measurement.isMeasurementBroken())
    {        
        dicomViewer.measurement.setMeasurementBroken(false);
    }
    evt.preventDefault();
    var editData = dicomViewer.measurement.getDataToEdit();
    dicomViewer.measurement.setLineMeasurementEnd(false);    
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
    this.measurementData.isEditable = true;
    this.measurementData.sessionType = 0;
    var widget = imageRenderer.getRenderWidget();
    if (evt.type === "mousedown" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || editData !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            this.measurementData.first.x = pt.x;
            this.measurementData.first.y = pt.y;
            this.measurementData.measurementSubType = this.measurementSubType; 
        } else {
            this.isMousePressed = false;
        }
    }
    
    var measurementType = dicomViewer.measurement.draw.getMeasurementType();
    this.measurementData.measurementId = measurementType.measurementId;
    this.measurementData.measurementType = measurementType.measurementType;
    this.measurementData.measurementUnits = measurementType.measurementUnits;
};

EllipseMeasurement.prototype.hanleMouseMove = function(evt) {
    var value = dicomViewer.measurement.getDataToEdit();
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    if (!this.isMousePressed && !this.isLineExceededOutside) {
        return;
    }    
    var widget = imageRenderer.getRenderWidget();
    if (this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            this.measurementData.first.x = pt.x;
            this.measurementData.first.y = pt.y;
        }

        this.isMousePressed = true;
    } else {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.handleActive = true;
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.second.x = pt.x;
            this.measurementData.second.y = pt.y;
            if (value == undefined) {
                this.adjustQuadrantsOfEllipse();
            }
        }

        if (value === undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);

        } else {
            if (value.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                this.measurementData.end.handleActive = true;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                this.measurementData.measurementType = value.measurmentType;
                this.measurementData.measureType = value.measurmentType;
                dicomViewer.measurement.setTempData(this.measurementData);
                this.measurementData = {
                    start: {
                        handleActive: false
                    },
                    end: {
                        handleActive: false
                    },
                    first: {
                    },
                    second: {
                    },
                    third: {
                    },
                    fourth: {
                    },
                    center: {
                    },
                    style : {
                    },
                    measureType: value.measurmentType,
                    measurementSubType: this.measurementData.measurementSubType
                };
            }
        }
        
        imageRenderer.drawDicomImage(false, undefined, true);
    }  
    
};

EllipseMeasurement.prototype.hanleMouseUp = function(evt) {
    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
    }
    if (evt.which === 3 || isTouchContextMenu) {
        this.hanleDoubleClick();
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "ellipsedelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft)) - 5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop)) - 5;
            var measurementDelData = {
                x: pointX,
                y: pointY,
                measureType: "ellipsedelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        var imageRender = this.activeImageRenderer;
        //var auids = imageRender.anUIDs.split("*");
        var dContext = this.activeImageRenderer.getRenderWidget().getContext("2d");
        //dicomViewer.measurement.draw.drawMeasurements(auids[0], auids[1],dContext,imageRender.getPresentation(),imageRender);
        this.activeImageRenderer.drawDicomImage(true);
    }

    if (this.isMousePressed || this.isLineExceededOutside) {
        this.isMousePressed = false;
        this.isLineExceededOutside = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if (evt.type === "mouseup"  || evt.type === "mouseout" || evt.type === "touchend") {
            var pt = this.hitTestAndGetMousePosition(evt);
            if(pt !== undefined) {
                this.measurementData.end.x = pt.x;
                this.measurementData.end.y = pt.y;
                this.measurementData.second.x = pt.x;
                this.measurementData.second.y = pt.y;
                var value = dicomViewer.measurement.getDataToEdit();
                if (value == undefined) {
                    this.adjustQuadrantsOfEllipse();
                }
            } else {
                // touchend will return undefined. Maintain the last touchmove point as the end point
            }

            this.measurementData.end.handleActive = false;
        }
        this.measurementData.textPosition = dicomViewer.measurement.hounsfieldTextPosition(this.measurementData, imageRenderer);
        dicomViewer.measurement.setMeasurementBroken(false);
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);
		
        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            first: {
            },
            second: {
            },
            third: {
            },
            fourth: {
            },
            center: {
            },
            style : {
            },
            measureType: "ellipse",
            measurementSubType: this.measurementData.measurementSubType
        };
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.resetHandeler();
    }

};

EllipseMeasurement.prototype.hanleDoubleClick = function(evt) {
    this.isMousePressed = false;
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(dataToEdit != undefined) {
        var imageRenderer = this.activeImageRenderer;
        var widget = imageRenderer.getRenderWidget();
        if (evt === undefined || evt.which === 1 || evt.type === "mouseout" || evt.type === "touchend") {
            var imageUid = undefined;
            var frameIndex = undefined;
            imageRenderer.imagePromise.then(function(image) {
                imageUid = image.imageUid;
                frameIndex = image.frameNumber;
            });
            dicomViewer.measurement.resetEllipseEditMode(imageUid, frameIndex, dataToEdit);
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setDataToEdit(undefined);
            imageRenderer.drawDicomImage(false);
        }
    }
};

EllipseMeasurement.prototype.hanleMouseOut = function(evt) {
    if(dicomViewer.measurement.getDataToEdit() !== undefined) {
        this.hanleDoubleClick(evt);
    } else {
        this.hanleMouseUp(evt);
    }
};

/**
 * set the measurement sub type
 * @param {Type} type - It specifies the measurement sub type(hounsfield or ellipse)
 */ 
EllipseMeasurement.prototype.setMeasurementSubType = function (type) {
    this.measurementSubType = type;
};

/**
 * Adjust all the quadrants of ellipse when rotating from any one of the quadrant point.
 */ 
EllipseMeasurement.prototype.adjustQuadrantsOfEllipse = function () {
    var centerX = (this.measurementData.start.x + this.measurementData.end.x) / 2;
    var centerY = (this.measurementData.start.y + this.measurementData.end.y) / 2;
    this.measurementData.center.x = centerX;
    this.measurementData.center.y = centerY;
    var point = {
        x: Math.abs(this.measurementData.second.x),
        y: Math.abs(this.measurementData.second.y)
    };
    this.measurementData.third = this.rotate(centerX, centerY, point);
    point = {
        x: Math.abs(this.measurementData.first.x),
        y: Math.abs(this.measurementData.first.y)
    };
    this.measurementData.fourth = this.rotate(centerX, centerY, point);
};

/**
 * Rotate a point to given radians with given center point.
 */ 
EllipseMeasurement.prototype.rotate = function (cx, cy, point) {
    var radians = Math.PI / 2,
        cos = Math.cos(radians),
        sin = Math.sin(radians),
        nx = (cos * (point.x - cx)) + (sin * (point.y - cy)) + cx,
        ny = (cos * (point.y - cy)) - (sin * (point.x - cx)) + cy;
    return { x: nx, y: ny };
};RectangleMeasurement.prototype = new MouseTool();
RectangleMeasurement.prototype.constructor = RectangleMeasurement;
var isLineExceededOutside = false;
var isTextAreaVisible = false;

function RectangleMeasurement() {
    this.ToolType = "rectangleMeasurement";
    this.measurementData = {
        start: {
            handleActive: false
        },
        end: {
            handleActive: false
        },
        style : {},
        studyUid:undefined,
        measureType: "rectangle",
        measurementSubType: "hounsfield",
        measurementId: null,
        measurementType: null,
        measurementComplete: false,
        measurementUnits: null,
        isLineExceededOutside: false,
        isEditable: "undefined",
        sessionType: "undefined"
    };
}

RectangleMeasurement.prototype.hanleMouseDown = function(evt) {
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }
    if(dicomViewer.measurement.isMeasurementBroken())
    {        
        dicomViewer.measurement.setMeasurementBroken(false);
    }
    evt.preventDefault();

    var editData = dicomViewer.measurement.getDataToEdit();
    if (this.measurementSubType === "text" && isTextAreaVisible && editData == undefined) {
        this.handleTextArea(this.getRegion(), true);
    }

    dicomViewer.measurement.setLineMeasurementEnd(false);    
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
    this.measurementData.isEditable = true;
    this.measurementData.sessionType = 0;
    var widget = imageRenderer.getRenderWidget();
    if (evt.type === "mousedown" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || editData !== undefined) {

           if (editData !== undefined) {
                // Check whether the mouse point is inside the text area
                var editRegion = this.getEditRegion(editData, pt);
                if(this.measurementSubType === "text" && editRegion.isPtInRegion) {
                    this.isMousePressed = false;
                    this.handleTextArea(editRegion, undefined, true);
                    return;
                }
            }
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            this.measurementData.measurementSubType = this.measurementSubType;
        } else {
            this.isMousePressed = false;
        }
    }
    
    var measurementType = dicomViewer.measurement.draw.getMeasurementType();
    this.measurementData.measurementId = measurementType.measurementId;
    this.measurementData.measurementType = measurementType.measurementType;
    this.measurementData.measurementUnits = measurementType.measurementUnits;
};

RectangleMeasurement.prototype.hanleMouseMove = function(evt, isTextAreaEvent) {
    var value = dicomViewer.measurement.getDataToEdit();
    if(this.measurementSubType === "text" && isTextAreaVisible == true && value === undefined) {
        this.handleTextArea(this.getRegion());
        return;
    }

    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    if (!this.isMousePressed && !this.isLineExceededOutside) {
        return;
    }    
    var widget = imageRenderer.getRenderWidget();
    if (this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt, isTextAreaEvent);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }

        this.isMousePressed = true;
    } else {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt, isTextAreaEvent);
            this.measurementData.end.handleActive = true;
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
        }

        if (value === undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);

        } else {
            if (value.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                this.measurementData.end.handleActive = true;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                this.measurementData.measurementType = value.measurmentType;
                this.measurementData.measureType = value.measurmentType;
                dicomViewer.measurement.setTempData(this.measurementData);
                this.measurementData = {
                    start: {
                        handleActive: false
                    },
                    end: {
                        handleActive: false
                    },
                    measureType: value.measurmentType,
                    measurementSubType : this.measurementData.measurementSubType
                };
            }
        }
        
        imageRenderer.drawDicomImage(false, undefined, true);
                                
        // Show the text overlay
        if(this.measurementSubType === "text" && value !== undefined) {
            this.handleTextArea(this.getEditRegion(value, {x: 0, y: 0}), undefined, false, true);
        }
    }  
    
};

RectangleMeasurement.prototype.hanleMouseUp = function(evt) {
    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
    }
    if (evt.which === 3 || isTouchContextMenu) {
        this.hanleDoubleClick();
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "rectangledelete"
            };
        } else {
            if (this.measurementSubType === "text" && isTextAreaVisible) {
                this.handleTextArea(this.getRegion(), true);
                return;
            }
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft)) - 5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop)) - 5;
            var measurementDelData = {
                x: pointX,
                y: pointY,
                measureType: "rectangledelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        this.activeImageRenderer.drawDicomImage(true);
    }

    if (this.isMousePressed || this.isLineExceededOutside) {
        this.isMousePressed = false;
        this.isLineExceededOutside = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if (evt.type === "mouseup"  || evt.type === "mouseout" || evt.type === "touchend") {
            var pt = this.hitTestAndGetMousePosition(evt); 
            if(pt !== undefined) {
                this.measurementData.end.x = pt.x;
                this.measurementData.end.y = pt.y;
            } else {
                // touchend will return undefined. Maintain the last touchmove point as the end point
            }

            this.measurementData.end.handleActive = false;

            // Show the text overlay
            var value = dicomViewer.measurement.getDataToEdit();
            if(this.measurementSubType === "text" && value === undefined) {
                this.handleTextArea(this.getRegion(), undefined, true);
                return;
            }
        }
        this.measurementData.textPosition = dicomViewer.measurement.hounsfieldTextPosition(this.measurementData, imageRenderer);
        dicomViewer.measurement.setMeasurementBroken(false);
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);

        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "rectangle",
            measurementSubType : this.measurementData.measurementSubType
        };
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.resetHandeler();
    }

};

RectangleMeasurement.prototype.hanleDoubleClick = function(evt) {
    if(this.measurementSubType === "text") {
        this.handleTextArea(this.getRegion(), true);
        return;
    }
    this.isMousePressed = false;
    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(dataToEdit != undefined)
    {
        var imageRenderer = this.activeImageRenderer;
        var widget = imageRenderer.getRenderWidget();
        if (evt === undefined || evt.which === 1 || evt.type === "mouseout") {
            var imageUid = undefined;
            var frameIndex = undefined;
            imageRenderer.imagePromise.then(function(image) {
                imageUid = image.imageUid;
                frameIndex = image.frameNumber;
            });
            dicomViewer.measurement.resetRectangleEditMode(imageUid, frameIndex, dataToEdit);
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setDataToEdit(undefined);
            imageRenderer.drawDicomImage(false);
        }
    }
};

RectangleMeasurement.prototype.hanleMouseOut = function(evt) {
    if(evt.toElement !== null && evt.toElement !== undefined) {
        if (evt.toElement.id === "textarea_annotation") {
            return;
        }
    }
    if(this.measurementSubType === "text" && this.activeImageRenderer !== undefined) {
        var canvas = this.activeImageRenderer.getRenderWidget();
        var viewportRect = canvas.getBoundingClientRect();
        var pointX = 0;
        var pointY = 0;
        if(evt.touches === undefined) {
            if(evt.offsetX !== undefined && evt.offsetY !== undefined) {
                pointX = evt.offsetX - 5;
                pointY = evt.offsetY - 5;
            } else {
                pointX = evt.pageX - viewportLeftOffset;
                pointY = evt.pageY - viewportTopOffset;
            }
        } else {
            pointX = evt.touches[0].pageX - viewportLeftOffset;
            pointY = evt.touches[0].pageY - viewportTopOffset;
        }

        if ((pointX > viewportRect.left && pointX < viewportRect.width) &&
            (pointY > viewportRect.top && pointY < viewportRect.height)) {
            this.handleTextArea(this.getRegion());
        } else {
            this.hanleMouseUp(evt);
            this.handleTextArea(this.getRegion(), true);
        }
        return;
    }

    if(dicomViewer.measurement.getDataToEdit() !== undefined) {
        this.hanleDoubleClick(evt);
    } else {
        this.hanleMouseUp(evt);
    }
};

/**
 * set the measurement sub type
 * @param {Type} type - It specifies the measurement sub type(hounsfield or rectangle)
 */ 
RectangleMeasurement.prototype.setMeasurementSubType = function (type) {
    this.measurementSubType = type;
};

/**
 * Set the focus to text overlay
 */ 
RectangleMeasurement.prototype.hanleMouseOver = function(evt) {
    if(this.measurementSubType === "text" && isTextAreaVisible == true) {
        this.handleTextArea(this.getRegion());
        return;
    }
};

/**
 * show the text area
 */ 
RectangleMeasurement.prototype.handleTextArea = function(region, cancel, isNew, isResize) {
    try
    {
        if(this.activeImageRenderer === undefined || this.activeImageRenderer === null) {
            return;
        }

        if(document.getElementById("textarea_annotation") && isNew) {
            isNew = undefined;
            isResize = undefined;
            isTextAreaVisible = true;
            cancel = true;
        }

        if(isNew == true || isResize == true) {
            if (region.width < 5 || region.height < 5) {
                return;
            }
            var textArea = undefined;
            if(isNew) {
                textArea = document.createElement('textarea');
            } else if (isResize) {
                if (isTextAreaVisible) {
                    textArea = document.getElementById("textarea_annotation");
                } else {
                    return;
                }
            }
            if (isNew) {
                textArea.id = "textarea_annotation"
                textArea.type = 'text';
                textArea.maxLength = 100;
                textArea.style.position = 'fixed';
                textArea.style.fontSize = "medium";
                textArea.style.backgroundColor = 'black';
                textArea.style.color = 'white';
                textArea.style.overflow = 'hidden';
                textArea.value = region.text;
                textArea.style.resize = "none";
                textArea.onkeydown = this.handleTextAreakeydown;
                textArea.onmousemove = this.handleTextAreamousemove;
            }
            textArea.style.left = region.left + 'px';
            textArea.style.top = region.top + 'px';
            textArea.style.width = region.width + 'px'; 
            textArea.style.height = region.height + 'px';
            textArea.focus();
            textArea.measurementData = this.measurementData;
            textArea.activeImageRenderer = this.activeImageRenderer;
            textArea.tool = this;
            document.body.appendChild(textArea);
            isTextAreaVisible = true;
        } else {
            var textArea = undefined;
            if(isTextAreaVisible) {
                textArea = document.getElementById("textarea_annotation");
                 if(textArea !== undefined && textArea !== null) {
                     textArea.focus();
                }
            }

            if(cancel == true) {
                this.isMousePressed = false;
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if(dataToEdit != undefined)
                {
                    var imageRenderer = this.activeImageRenderer;
                    var widget = imageRenderer.getRenderWidget();
                    var imageUid = undefined;
                    var frameIndex = undefined;
                    imageRenderer.imagePromise.then(function(image) {
                        imageUid = image.imageUid;
                        frameIndex = image.frameNumber;
                    });
                    if(isTextAreaVisible) {
                        this.measurementData.measurementText = getText("textarea_annotation");
                        if (this.measurementData.measurementText !== "") {
                            dicomViewer.measurement.updateMeasurementTextData(dataToEdit, this.measurementData.measurementText);
                        } else {
                            if(isTextAreaVisible) {
                                document.body.removeChild(textArea);
                                isTextAreaVisible = false; 
                            }
                            dicomViewer.measurement.deleteSelectedMeasurment();
                            dicomViewer.measurement.resetHandeler();
                            return;
                        }
                    }
                    dicomViewer.measurement.resetRectangleEditMode(imageUid, frameIndex, dataToEdit);
                    dicomViewer.measurement.setLineMeasurementEnd(false);
                    dicomViewer.measurement.setDataToEdit(undefined);
                    imageRenderer.drawDicomImage(false);
                } else if(isTextAreaVisible) {
                    dicomViewer.measurement.setMeasurementBroken(false);
                    dicomViewer.measurement.setLineMeasurementEnd(true);
                    this.measurementData.measurementText = getText("textarea_annotation");
                    if (this.measurementData.measurementText !== "") {
                        dicomViewer.measurement.setTempData(this.measurementData);
                    } else {
                       dicomViewer.measurement.setTempData(undefined);
                    }
                    this.measurementData =
                    {
                        start: { handleActive: false },
                        end: { handleActive: false },
                        measureType: "rectangle",
                        measurementSubType: this.measurementSubType
                    };
                    this.activeImageRenderer.drawDicomImage(false);
                }
                dicomViewer.measurement.resetHandeler();
                if(isTextAreaVisible) {
                    document.body.removeChild(textArea);
                    isTextAreaVisible = false;
                }
            }
        }
    }
    catch(e)
    { }
};

/**
 * Handle the text area mousemove event 
 */ 
RectangleMeasurement.prototype.handleTextAreamousemove = function(evt) {
    this.tool.hanleMouseMove(evt, true);
}

/**
 * Handle the text area keydown event 
 */ 
RectangleMeasurement.prototype.handleTextAreakeydown = function(e) {
    var keyCode = e.keyCode;
    if (e.ctrlKey && e.keyCode == 13) {
        $('#textarea_annotation').val($('#textarea_annotation').val() + "\n");
    } else if(e.keyCode == 13 || e.keyCode == 27) {
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if(dataToEdit != undefined) {
            this.tool.handleTextArea(this.tool.getEditRegion(), true);
        } else {
            this.tool.handleTextArea(this.tool.getRegion(), true);
        }
    }
}

RectangleMeasurement.prototype.getRegion = function(data) {
    try
    {
        var canvas = this.activeImageRenderer.getRenderWidget();
        var viewportRect = canvas.getBoundingClientRect();
        var viewportLeftOffset = (viewportRect.left < 0 ? 0 : viewportRect.left);
        var viewportTopOffset = (viewportRect.top < 0 ? 0 : viewportRect.top);

        var measureData = data;
        if(data === undefined) {
            measureData = this.measurementData;
        }

        var startPt = measureData.start;
        var endPt = measureData.end;
        var left = startPt.x + viewportLeftOffset;
        var top = startPt.y + viewportTopOffset;

        if (endPt.x < startPt.x) {
            left = endPt.x + viewportLeftOffset;
        }

        if (endPt.y < startPt.y) {
            top = endPt.y + viewportTopOffset;
        }

        var width = endPt.x - startPt.x;
        var height = endPt.y - startPt.y;
        if (endPt.x < startPt.x) {
            width = startPt.x - endPt.x;
        } if (endPt.y < startPt.y) {
            height = startPt.y - endPt.y;
        }

        return {left: left, top: top, width: width, height: height, text: ""};
    }
    catch(e)
    { }

    return undefined;
}

RectangleMeasurement.prototype.getEditRegion = function(editData, pt) {
    var region = {isPtInRegion: false};
    
    try
    {
        if(this.measurementSubType !== "text") {
            return region;
        }

        if(editData === undefined || editData.key === "") {
            return region;
        }

        var imageUids = editData.key.split("_");
        if(imageUids === undefined || imageUids === null || imageUids.length != 2) {
            return region;
        }

        var measurementData = dicomViewer.measurement.getRectangleMeasurements(imageUids[0], imageUids[1]);
        if(measurementData === undefined || measurementData === null) {
            return region;
        }

        measurementData = measurementData[editData.arryIndex];
        if(measurementData === undefined || measurementData === null) {
            return region;
        }
    
        // Get the image object to get the current presentation 
        var imageCanvas = null;
        this.activeImageRenderer.imagePromise.then(function(image) {
            imageCanvas = image;
        });
        
        // Calculate the image region with in the viewport region
        var canvas = this.activeImageRenderer.getRenderWidget();
        var viewportRect = canvas.getBoundingClientRect();
        var viewportLeftOffset = (viewportRect.left < 0 ? 0 : viewportRect.left);
        var viewportTopOffset = (viewportRect.top < 0 ? 0 : viewportRect.top);
        var scale = parseFloat(this.activeImageRenderer.scaleValue);
        var canvasMidX = viewportRect.width / 2;
        var canvasMidY = viewportRect.height / 2;
        var scaledImageWidth = (imageCanvas.columns * scale);
        var scaledImageHeight = (imageCanvas.rows * scale);
        var imageMidX = scaledImageWidth / 2;
        var imageMidY = scaledImageHeight / 2;
        var x = Math.round(canvasMidX - imageMidX);
        var y = Math.round(canvasMidY - imageMidY);
        
        var imageX = pt.x / scale;
        var imageY = pt.y / scale;
        x /= scale;
        y /= scale;
    
        var width = (measurementData.end.x - measurementData.start.x);
        var height = (measurementData.end.y - measurementData.start.y);
        if (measurementData.end.x < measurementData.start.x) {
            width = measurementData.start.x - measurementData.end.x;
        } if (measurementData.end.y < measurementData.start.y) {
            height = measurementData.start.y - measurementData.end.y;
        }
        
        var left = measurementData.start.x + x;
        var top = measurementData.start.y + y;
        if (measurementData.end.x < measurementData.start.x) {
            left = measurementData.end.x + x;
        } if (measurementData.end.y < measurementData.start.y) {
            top = measurementData.end.y + y;
        }

        var right = left + width;
        var bottom = top + height;
        var isPtInRegion = false;

        if ((imageX > left && imageX < right) && (imageY > top && imageY < bottom)) {
            isPtInRegion = true;
        }

        region = 
        {
            left: ((left * scale) + viewportLeftOffset),
            top: ((top * scale) + viewportTopOffset),
            width: width * scale,
            height: height * scale,
            isPtInRegion: isPtInRegion,
            text: measurementData.measurementText
        };

        return region;
    }
    catch(e)
    { }

    return region;
}

/**
 * Get the text area text
 * @param {Type} strTextAreaId - Specifies the text area id
 */ 
function getText(strTextAreaId) {
    var textArea = document.getElementById(strTextAreaId);
    return textArea.value.replace(new RegExp("\\n", "g"), "\n");
}DefaultTool.prototype = new MouseTool();
DefaultTool.prototype.constructor = DefaultTool;

function DefaultTool()
{
    this.ToolType = "defaultTool";
    this.isDefaultToolActivated = false;
}

DefaultTool.prototype.hanleMouseDown = function(evt) {
    this.isMousePressed = true;
    this.isDefaultToolActivated = false;
    if(this.activeImageRenderer) {
        dicomViewer.measurement.removeTempdata();
    }

    evt.preventDefault();
};

DefaultTool.prototype.hanleMouseMove = function(evt) {
    if(this.isMousePressed && !this.isDefaultToolActivated) {
        this.isDefaultToolActivated = true;
         if(this.activeImageRenderer) {
            this.activeImageRenderer.doClickDefaultTool();
             evt.type = "mousedown";
             dicomViewer.mouseTools.getActiveTool().hanleMouseDown(evt);
        }
    }
};

DefaultTool.prototype.hanleDoubleClick = function(evt) {

};

DefaultTool.prototype.hanleMouseUp = function(evt) {
    this.isMousePressed = false;
    this.isDefaultToolActivated = false;
    if (evt.which === 3) {
        var imageRender = this.activeImageRenderer;
        if(imageRender === undefined || imageRender === null) {
            // Invalid render object
            return;
        }

        var pt = this.hitTestAndGetMousePosition(evt);

        // HitTest line measurement
        if(this.setAndValidateMeasurementDelete(pt, "linedelete")) {
            return;
        }    

        // HitTest point measurement
        if(this.setAndValidateMeasurementDelete(pt, "pointdelete")) {
            return;
        }

        // HitTest angle measurement
        if(this.setAndValidateMeasurementDelete(pt, "angledelete")) {
            return;
        }

        // HitTest ellipse measurement
        if(this.setAndValidateMeasurementDelete(pt, "ellipsedelete")) {
            return;
        }

        // HitTest trace measurement
        if(this.setAndValidateMeasurementDelete(pt, "tracedelete")) {
            return;
        }

        // HitTest volume measurement
        if(this.setAndValidateMeasurementDelete(pt, "volumedelete")) {
            return;
        }

        // HitTest mitralGradient measurement
        if(this.setAndValidateMeasurementDelete(pt, "mitralGradientdelete")) {
            return;
        }

        // HitTest rectangle measurement
        if(this.setAndValidateMeasurementDelete(pt, "rectangledelete")) {
            return;
        }

        if(this.setAndValidateMeasurementDelete(pt, "pendelete")) {
            return;
        }
    }
};

DefaultTool.prototype.setAndValidateMeasurementDelete = function(pt, deleteType) {
    dicomViewer.measurement.setTempData({ x: pt.x, y: pt.y, measureType: deleteType});
    this.activeImageRenderer.drawDicomImage(true);
    var dataToedit = dicomViewer.measurement.getDataToDelete();
    if(dataToedit === undefined || dataToedit.key === "") {
        return false;
    }

    return true;
};
/*
Smooth.js version 0.1.7

Turn arrays into smooth functions.

Copyright 2012 Spencer Cohen
Licensed under MIT license (see "Smooth.js MIT license.txt")
*/

/*Constants (these are accessible by Smooth.WHATEVER in user space)
*/

(function() {
  var AbstractInterpolator, CubicInterpolator, Enum, LinearInterpolator, NearestInterpolator, PI, SincFilterInterpolator, Smooth, clipClamp, clipMirror, clipPeriodic, defaultConfig, getColumn, getType, isValidNumber, k, makeLanczosWindow, makeScaledFunction, makeSincKernel, normalizeScaleTo, shallowCopy, sin, sinc, v, validateNumber, validateVector,
    __hasProp = Object.prototype.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor; child.__super__ = parent.prototype; return child; };

  Enum = {
    /*Interpolation methods
    */
    METHOD_NEAREST: 'nearest',
    METHOD_LINEAR: 'linear',
    METHOD_CUBIC: 'cubic',
    METHOD_LANCZOS: 'lanczos',
    METHOD_SINC: 'sinc',
    /*Input clipping modes
    */
    CLIP_CLAMP: 'clamp',
    CLIP_ZERO: 'zero',
    CLIP_PERIODIC: 'periodic',
    CLIP_MIRROR: 'mirror',
    /* Constants for control over the cubic interpolation tension
    */
    CUBIC_TENSION_DEFAULT: 0,
    CUBIC_TENSION_CATMULL_ROM: 0
  };

  defaultConfig = {
    method: Enum.METHOD_CUBIC,
    cubicTension: Enum.CUBIC_TENSION_DEFAULT,
    clip: Enum.CLIP_CLAMP,
    scaleTo: 0,
    sincFilterSize: 2,
    sincWindow: void 0
  };

  /*Index clipping functions
  */

  clipClamp = function(i, n) {
    return Math.max(0, Math.min(i, n - 1));
  };

  clipPeriodic = function(i, n) {
    i = i % n;
    if (i < 0) i += n;
    return i;
  };

  clipMirror = function(i, n) {
    var period;
    period = 2 * (n - 1);
    i = clipPeriodic(i, period);
    if (i > n - 1) i = period - i;
    return i;
  };

  /*
  Abstract scalar interpolation class which provides common functionality for all interpolators
  
  Subclasses must override interpolate().
  */

  AbstractInterpolator = (function() {

    function AbstractInterpolator(array, config) {
      this.array = array.slice(0);
      this.length = this.array.length;
      if (!(this.clipHelper = {
        clamp: this.clipHelperClamp,
        zero: this.clipHelperZero,
        periodic: this.clipHelperPeriodic,
        mirror: this.clipHelperMirror
      }[config.clip])) {
        throw "Invalid clip: " + config.clip;
      }
    }

    AbstractInterpolator.prototype.getClippedInput = function(i) {
      if ((0 <= i && i < this.length)) {
        return this.array[i];
      } else {
        return this.clipHelper(i);
      }
    };

    AbstractInterpolator.prototype.clipHelperClamp = function(i) {
      return this.array[clipClamp(i, this.length)];
    };

    AbstractInterpolator.prototype.clipHelperZero = function(i) {
      return 0;
    };

    AbstractInterpolator.prototype.clipHelperPeriodic = function(i) {
      return this.array[clipPeriodic(i, this.length)];
    };

    AbstractInterpolator.prototype.clipHelperMirror = function(i) {
      return this.array[clipMirror(i, this.length)];
    };

    AbstractInterpolator.prototype.interpolate = function(t) {
      throw 'Subclasses of AbstractInterpolator must override the interpolate() method.';
    };

    return AbstractInterpolator;

  })();

  NearestInterpolator = (function(_super) {

    __extends(NearestInterpolator, _super);

    function NearestInterpolator() {
      NearestInterpolator.__super__.constructor.apply(this, arguments);
    }

    NearestInterpolator.prototype.interpolate = function(t) {
      return this.getClippedInput(Math.round(t));
    };

    return NearestInterpolator;

  })(AbstractInterpolator);

  LinearInterpolator = (function(_super) {

    __extends(LinearInterpolator, _super);

    function LinearInterpolator() {
      LinearInterpolator.__super__.constructor.apply(this, arguments);
    }

    LinearInterpolator.prototype.interpolate = function(t) {
      var k;
      k = Math.floor(t);
      t -= k;
      return (1 - t) * this.getClippedInput(k) + t * this.getClippedInput(k + 1);
    };

    return LinearInterpolator;

  })(AbstractInterpolator);

  CubicInterpolator = (function(_super) {

    __extends(CubicInterpolator, _super);

    function CubicInterpolator(array, config) {
      this.tangentFactor = 1 - Math.max(0, Math.min(1, config.cubicTension));
      CubicInterpolator.__super__.constructor.apply(this, arguments);
    }

    CubicInterpolator.prototype.getTangent = function(k) {
      return this.tangentFactor * (this.getClippedInput(k + 1) - this.getClippedInput(k - 1)) / 2;
    };

    CubicInterpolator.prototype.interpolate = function(t) {
      var k, m, p, t2, t3;
      k = Math.floor(t);
      m = [this.getTangent(k), this.getTangent(k + 1)];
      p = [this.getClippedInput(k), this.getClippedInput(k + 1)];
      t -= k;
      t2 = t * t;
      t3 = t * t2;
      return (2 * t3 - 3 * t2 + 1) * p[0] + (t3 - 2 * t2 + t) * m[0] + (-2 * t3 + 3 * t2) * p[1] + (t3 - t2) * m[1];
    };

    return CubicInterpolator;

  })(AbstractInterpolator);

  sin = Math.sin, PI = Math.PI;

  sinc = function(x) {
    if (x === 0) {
      return 1;
    } else {
      return sin(PI * x) / (PI * x);
    }
  };

  makeLanczosWindow = function(a) {
    return function(x) {
      return sinc(x / a);
    };
  };

  makeSincKernel = function(window) {
    return function(x) {
      return sinc(x) * window(x);
    };
  };

  SincFilterInterpolator = (function(_super) {

    __extends(SincFilterInterpolator, _super);

    function SincFilterInterpolator(array, config) {
      SincFilterInterpolator.__super__.constructor.apply(this, arguments);
      this.a = config.sincFilterSize;
      if (!config.sincWindow) throw 'No sincWindow provided';
      this.kernel = makeSincKernel(config.sincWindow);
    }

    SincFilterInterpolator.prototype.interpolate = function(t) {
      var k, n, sum, _ref, _ref2;
      k = Math.floor(t);
      sum = 0;
      for (n = _ref = k - this.a + 1, _ref2 = k + this.a; _ref <= _ref2 ? n <= _ref2 : n >= _ref2; _ref <= _ref2 ? n++ : n--) {
        sum += this.kernel(t - n) * this.getClippedInput(n);
      }
      return sum;
    };

    return SincFilterInterpolator;

  })(AbstractInterpolator);

  getColumn = function(arr, i) {
    var row, _i, _len, _results;
    _results = [];
    for (_i = 0, _len = arr.length; _i < _len; _i++) {
      row = arr[_i];
      _results.push(row[i]);
    }
    return _results;
  };

  makeScaledFunction = function(f, baseScale, scaleRange) {
    var scaleFactor, translation;
    if (scaleRange.join === '0,1') {
      return f;
    } else {
      scaleFactor = baseScale / (scaleRange[1] - scaleRange[0]);
      translation = scaleRange[0];
      return function(t) {
        return f(scaleFactor * (t - translation));
      };
    }
  };

  getType = function(x) {
    return Object.prototype.toString.call(x).slice('[object '.length, -1);
  };

  validateNumber = function(n) {
    if (isNaN(n)) throw 'NaN in Smooth() input';
    if (getType(n) !== 'Number') throw 'Non-number in Smooth() input';
    if (!isFinite(n)) throw 'Infinity in Smooth() input';
  };

  validateVector = function(v, dimension) {
    var n, _i, _len;
    if (getType(v) !== 'Array') throw 'Non-vector in Smooth() input';
    if (v.length !== dimension) throw 'Inconsistent dimension in Smooth() input';
    for (_i = 0, _len = v.length; _i < _len; _i++) {
      n = v[_i];
      validateNumber(n);
    }
  };

  isValidNumber = function(n) {
    return (getType(n) === 'Number') && isFinite(n) && !isNaN(n);
  };

  normalizeScaleTo = function(s) {
    var invalidErr;
    invalidErr = "scaleTo param must be number or array of two numbers";
    switch (getType(s)) {
      case 'Number':
        if (!isValidNumber(s)) throw invalidErr;
        s = [0, s];
        break;
      case 'Array':
        if (s.length !== 2) throw invalidErr;
        if (!(isValidNumber(s[0]) && isValidNumber(s[1]))) throw invalidErr;
        break;
      default:
        throw invalidErr;
    }
    return s;
  };

  shallowCopy = function(obj) {
    var copy, k, v;
    copy = {};
    for (k in obj) {
      if (!__hasProp.call(obj, k)) continue;
      v = obj[k];
      copy[k] = v;
    }
    return copy;
  };

  Smooth = function(arr, config) {
    var baseDomainEnd, dimension, i, interpolator, interpolatorClass, interpolators, k, n, properties, smoothFunc, v;
    if (config == null) config = {};
    properties = {};
    config = shallowCopy(config);
    properties.config = shallowCopy(config);
    if (config.scaleTo == null) config.scaleTo = config.period;
    if (config.sincFilterSize == null) {
      config.sincFilterSize = config.lanczosFilterSize;
    }
    for (k in defaultConfig) {
      if (!__hasProp.call(defaultConfig, k)) continue;
      v = defaultConfig[k];
      if (config[k] == null) config[k] = v;
    }
    if (!(interpolatorClass = {
      nearest: NearestInterpolator,
      linear: LinearInterpolator,
      cubic: CubicInterpolator,
      lanczos: SincFilterInterpolator,
      sinc: SincFilterInterpolator
    }[config.method])) {
      throw "Invalid method: " + config.method;
    }
    if (config.method === 'lanczos') {
      config.sincWindow = makeLanczosWindow(config.sincFilterSize);
    }
    if (arr.length < 2) throw 'Array must have at least two elements';
    properties.count = arr.length;
    smoothFunc = (function() {
      var _i, _j, _len, _len2;
      switch (getType(arr[0])) {
        case 'Number':
          properties.dimension = 'scalar';
          if (Smooth.deepValidation) {
            for (_i = 0, _len = arr.length; _i < _len; _i++) {
              n = arr[_i];
              validateNumber(n);
            }
          }
          interpolator = new interpolatorClass(arr, config);
          return function(t) {
            return interpolator.interpolate(t);
          };
        case 'Array':
          properties.dimension = dimension = arr[0].length;
          if (!dimension) throw 'Vectors must be non-empty';
          if (Smooth.deepValidation) {
            for (_j = 0, _len2 = arr.length; _j < _len2; _j++) {
              v = arr[_j];
              validateVector(v, dimension);
            }
          }
          interpolators = (function() {
            var _results;
            _results = [];
            for (i = 0; 0 <= dimension ? i < dimension : i > dimension; 0 <= dimension ? i++ : i--) {
              _results.push(new interpolatorClass(getColumn(arr, i), config));
            }
            return _results;
          })();
          return function(t) {
            var interpolator, _k, _len3, _results;
            _results = [];
            for (_k = 0, _len3 = interpolators.length; _k < _len3; _k++) {
              interpolator = interpolators[_k];
              _results.push(interpolator.interpolate(t));
            }
            return _results;
          };
        default:
          throw "Invalid element type: " + (getType(arr[0]));
      }
    })();
    if (config.clip === 'periodic') {
      baseDomainEnd = arr.length;
    } else {
      baseDomainEnd = arr.length - 1;
    }
    config.scaleTo || (config.scaleTo = baseDomainEnd);
    properties.domain = normalizeScaleTo(config.scaleTo);
    smoothFunc = makeScaledFunction(smoothFunc, baseDomainEnd, properties.domain);
    properties.domain.sort();
    /*copy properties
    */
    for (k in properties) {
      if (!__hasProp.call(properties, k)) continue;
      v = properties[k];
      smoothFunc[k] = v;
    }
    return smoothFunc;
  };

  for (k in Enum) {
    if (!__hasProp.call(Enum, k)) continue;
    v = Enum[k];
    Smooth[k] = v;
  }

  Smooth.deepValidation = true;

  (typeof exports !== "undefined" && exports !== null ? exports : window).Smooth = Smooth;

}).call(this);
WindowLevelROI.prototype = new MouseTool();
WindowLevelROI.prototype.constructor = WindowLevelROI;
var isLineExceededOutside = false;

function WindowLevelROI() {
    this.toolName = "WindowLevelROI";
    this.measurementData = {
        start: {
            handleActive: false
        },
        end: {
            handleActive: false
        },
        style : {},
        measureType: "WindowLevelROI",
        measurementId: null,
        measurementType: null,
        measurementComplete: false,
        measurementUnits: null,
        isLineExceededOutside: false
    };
}

WindowLevelROI.prototype.hanleMouseDown = function(evt) {
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled() || evt.which == 2){
        this.isMousePressed = false;
        return;
    }
    if(dicomViewer.measurement.isMeasurementBroken())
    {        
        dicomViewer.measurement.setMeasurementBroken(false);
    }
    evt.preventDefault();
    dicomViewer.measurement.setLineMeasurementEnd(false);    
    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }

    if (imageRenderer && imageRenderer !== undefined && imageRenderer.imagePromise !== undefined) {
        var presentation = null;
        var imageCanvas = null;
        imageRenderer.imagePromise.then(function(image){
            presentation = image.presentation;
            imageCanvas = image;
        });

        if (presentation) {
            imageCanvas.presentation.setPresetWindowLevelValue(0);
        }
    }

    var widget = imageRenderer.getRenderWidget();
    if (evt.type === "mousedown" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        } else {
            this.isMousePressed = false;
        }
    }

    var measurementType = dicomViewer.measurement.draw.getMeasurementType();
    this.measurementData.measurementId = measurementType.measurementId;
    this.measurementData.measurementType = measurementType.measurementType;
    this.measurementData.measurementUnits = measurementType.measurementUnits;
}; 

WindowLevelROI.prototype.hanleMouseMove = function(evt) {
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        this.isMousePressed = false;
        dicomViewer.measurement.setTempData(undefined);
        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "WindowLevelROI"
        };
        return;
    }

    var value = dicomViewer.measurement.getDataToEdit();
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }
    if (!this.isMousePressed && !this.isLineExceededOutside) {
        return;
    }
    var widget = imageRenderer.getRenderWidget();
    if (this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }

        this.isMousePressed = true;
    } else {
        if (evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.handleActive = true;
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
        }

        if (value === undefined) {
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);

        } else {
            if (value.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                this.measurementData.end.handleActive = true;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                this.measurementData.measurementType = value.measurmentType;
                this.measurementData.measureType = value.measurmentType;
                dicomViewer.measurement.setTempData(this.measurementData);
                this.measurementData = {
                    start: {
                        handleActive: false
                    },
                    end: {
                        handleActive: false
                    },
                    measureType: value.measurmentType
                };
            }
        }
        
        imageRenderer.drawDicomImage(false, undefined, undefined, true);
    }
    
};

WindowLevelROI.prototype.hanleMouseUp = function(evt) {
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        this.isMousePressed = false;
        dicomViewer.measurement.setTempData(undefined);
        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "WindowLevelROI"
        };
        return;
    }

    if (this.isMousePressed || this.isLineExceededOutside) {
        this.isMousePressed = false;
        this.isLineExceededOutside = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid; 
            frameIndex = image.frameNumber;
        });
        if (evt.type === "mouseup"  || evt.type === "mouseout" || evt.type === "touchend") {
            var pt = this.hitTestAndGetMousePosition(evt); 
            if(pt !== undefined) {
                this.measurementData.end.x = pt.x;
                this.measurementData.end.y = pt.y;
            } else {
                // touchend will return undefined. Maintain the last touchmove point as the end point
            }

            this.measurementData.end.handleActive = false;
            this.applyWindowLevel();
        }

        dicomViewer.measurement.setTempData(undefined);
        dicomViewer.measurement.setMeasurementBroken(false);
        dicomViewer.measurement.setLineMeasurementEnd(true);

        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "WindowLevelROI"
        };
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.resetHandeler();
    }
};

WindowLevelROI.prototype.hanleDoubleClick = function(evt) {

};

WindowLevelROI.prototype.hanleMouseOut = function(evt) {
    if(this.isMousePressed) {
        if(this.measurementData.start.x != undefined || this.measurementData.start.y != undefined) {
            this.hanleMouseUp(evt);
        }
    }
};

WindowLevelROI.prototype.applyWindowLevel = function() {
    try
    {
        var imageRender = this.activeImageRenderer;
        var activeImageLevelId = imageRender.parentElement;
        if(imageRender == undefined || imageRender == null) {
            return;
        }

        var auids = imageRender.anUIDs.split("*");
        var context = imageRender.getRenderWidget().getContext("2d");
        imageRender.drawDicomImage(true);

        var imageData = dicomViewer.measurement.getImageDataForMouseData(this.measurementData, imageRender, context);
        var presentation = imageRender.getPresentation();
        var windowLevelValue = dicomViewer.measurement.draw.GetROIWindowLevelValues(auids[0], 
                                                                                    context,
                                                                                    imageData,
                                                                                    presentation,
                                                                                    imageRender);
        if(windowLevelValue != undefined) {
            var window = windowLevelValue.window;
            var level = windowLevelValue.level;
            var LS_ROI_VARIANCE = 2.5;
            var minLevelValue = presentation.windowLevelLimits.wcLimit.min;
            var maxLevelValue = presentation.windowLevelLimits.wcLimit.max;
            var minWindowValue = presentation.windowLevelLimits.wwLimit.min;
            var maxWindowValue = presentation.windowLevelLimits.wwLimit.max;
            var slope = presentation.lookupObj.rescaleSlope;
            var intercept = presentation.lookupObj.rescaleIntercept;

            window = LS_ROI_VARIANCE * window;
            if(slope != 0)
            {
                window = window * slope;
                level = (level * slope) + intercept;
            }

            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            $("#"+seriesLayout.getSeriesLayoutId()+" div").each(function(){
                var imageLevelId = $(this).attr('id');
                var imageRender  = seriesLayout.getImageRender(imageLevelId);
                if(imageRender) {
                    imageRender.getPresentation().setWindowingdata(level, window);
                    imageRender.getPresentation().windowLevel = 0;
                    imageRender.renderImage(false, activeImageLevelId === imageLevelId);
                    dicomViewer.tools.updateWindowLevelSettings(-1);
                }
            });
        }
    }
    catch(e)
    { }
};
/**
 * XRefLineSelectionTool Tool
 */
XRefLineSelectionTool.prototype = new MouseTool();
XRefLineSelectionTool.prototype.constructor = XRefLineSelectionTool;

/**
 * Constructor
 */ 
function XRefLineSelectionTool() {
    this.ToolType = "XRefLineSelectionTool";
    this.measurementData = {x: 0, y: 0};
}

/**
 * Mouse Down Event
 */ 
XRefLineSelectionTool.prototype.hanleMouseDown = function(evt) {
    this.isMousePressed = true;
    if(this.activeImageRenderer !== undefined && this.activeImageRenderer !== null) {
         if (evt.type === "mousedown" || evt.type === "touchstart") {
            var pt = this.hitTestAndGetMousePosition(evt);
            if(pt.isPtInRegion) {
                this.measurementData = pt;
            } else {
                this.isMousePressed = false;
            }
        }
    }

    evt.preventDefault();
};

/**
 * Mouse Up Event
 */ 
XRefLineSelectionTool.prototype.hanleMouseUp = function(evt) {
    if(this.isMousePressed === true) {
        this.findAndNavigateImage(evt);
        this.isMousePressed = false;
    }
};

/**
 * Find the shortest distance and navigate the corresponding image
 */ 
XRefLineSelectionTool.prototype.findAndNavigateImage = function(evt) {
    try
    {
        var allViewports = dicomViewer.viewports.getAllViewports();
        if(allViewports === null || allViewports === undefined) {
            return;
        }

        var layout = dicomViewer.getActiveSeriesLayout();
        var imageRenders = layout.getAllImageRenders();
        var sourceImageUid = undefined;
        var imageRenderer = undefined;
        var mouseData = this.measurementData;
        for (var iKey in imageRenders) {
            imageRenderer = imageRenders[iKey];
            sourceImageUid =  imageRenderer.getImageUid();
            break;
        }

        if(imageRenderer === null ||
           imageRenderer === undefined ||
           sourceImageUid === null ||
           sourceImageUid === undefined) {
            return;
        }

        $.each(allViewports, function(key, value) {
            if(value.studyUid !== undefined && 
               value.studyUid === layout.studyUid &&
               value.seriesIndex !== undefined &&
               value.seriesIndex !== layout.seriesIndex) {

                var minDistance = undefined;
                var targetImageUid = undefined;
                var targetImageIndex = undefined;
                var imageIndex = 0;
                var images = dicomViewer.Series.getAllImages(value.studyUid, value.seriesIndex);

                images.forEach(function(image) {
                    var imageRefLine = dicomViewer.xRefLine.getRefLine(image.imageUid, sourceImageUid);
                    if(imageRefLine !== null && imageRefLine!== undefined) {
                        var scale = parseFloat(imageRenderer.scaleValue);
                        var x1 = imageRefLine.x1 * scale;
                        var y1 = imageRefLine.y1 * scale;
                        var x2 = imageRefLine.x2 * scale;
                        var y2 = imageRefLine.y2 * scale;
                        var x = (mouseData.x - mouseData.xOffset);
                        var y = (mouseData.y - mouseData.yOffset);

                        // Calculate the point distance and hold the shortest distance
                        var distance = getPtDistance(x, y, x1, y1, x2, y2);
                        if(minDistance === undefined) {
                            minDistance = Math.round(distance);
                            targetImageUid = image.imageUid;
                            targetImageIndex = imageIndex;
                        } else {
                            distance = Math.min(minDistance, distance);
                            if(Math.round(distance) !== Math.round(minDistance)) {
                                minDistance = Math.round(distance);
                                targetImageUid = image.imageUid;
                                targetImageIndex = imageIndex;
                            }
                        }

                        // Dump the output in console
                        if(dumpInConsole) {
                            console.log("XrefLine => x1: " + x1 + " y1: " + y1 + " x2: " + x2 + " y2: " + y2);
                            console.log("distance => " + distance);
                            console.log("minDistance => " + minDistance);
                        }
                    }
                    imageIndex++;
                });

                // Navigate the target image
                if(targetImageUid !== undefined && targetImageIndex !== undefined) {
                    dicomViewer.scroll.loadimages(value, value.seriesIndex, targetImageIndex, 0);

                    // Dump the output in console
                    if(dumpInConsole) {
                        console.log("targetImageUid => " + targetImageUid);
                        console.log("targetImageIndex => " + targetImageIndex);
                    }
                }
            }
        });
    }
    catch(e)
    { }
};

/**
 * Get the distance
 * @param {Type} x - Specifies the mouse point X  
 * @param {Type} y - Specifies the mouse point Y
 * @param {Type} x1 - Specifies the Line point X1
 * @param {Type} y1 - Specifies the Line point Y1
 * @param {Type} x2 - Specifies the Line point X2
 * @param {Type} y2 - Specifies the Line point Y2
 */ 
function getPtDistance(x, y, x1, y1, x2, y2) {
    var A = x - x1;
    var B = y - y1;
    var C = x2 - x1;
    var D = y2 - y1;

    var dot = A * C + B * D;
    var len_sq = C * C + D * D;
    var param = -1;

    // In case of 0 length line
    if (len_sq != 0) {
      param = dot / len_sq;
    }

    var xx, yy;
    if (param < 0) {
        xx = x1;
        yy = y1;
    } else if (param > 1) {
        xx = x2;
        yy = y2;
    } else {
        xx = x1 + param * C;
        yy = y1 + param * D;
    }

    var dx = x - xx;
    var dy = y - yy;

    return Math.sqrt(dx * dx + dy * dy);
}/**
 * Link Tool
 */
LinkTool.prototype = new MouseTool();
LinkTool.prototype.constructor = LinkTool;

function LinkTool() { }
SharpenTool.prototype = new MouseTool();
SharpenTool.prototype.constructor = SharpenTool;

/**
 * Constructor
 */ 
function SharpenTool() {
    this.oldx = 0;
    this.oldy = 0;  
}

SharpenTool.prototype.hanleMouseMove = function(evt) {   
        
    var seriesLayout = dicomViewer.getActiveSeriesLayout();
    $("#"+seriesLayout.getSeriesLayoutId()+" div").each(function(){
        var imageLevelId = $(this).attr('id');
        var imageRender  = seriesLayout.getImageRender(imageLevelId);
        if(imageRender) {
            
            var oldx =  this.oldx;
            var oldy = this.oldy;
                
                var deltaX = oldx - evt.clientX,
                    deltaY = oldy - evt.clientY;
            
            if (Math.abs(deltaX) > Math.abs(deltaY) && deltaX > 0) {
                //left
                if(evt.movementY <= 8){
                    imageRender.getPresentation().sharpen = evt.movementY;        
                }
            } else if (Math.abs(deltaX) > Math.abs(deltaY) && deltaX < 0) {
                //right
                if(evt.movementY <= 8){
                    imageRender.getPresentation().sharpen = evt.movementY;        
                }
            } else if (Math.abs(deltaY) > Math.abs(deltaX) && deltaY > 0) {
                //up
                if(evt.movementX <= 8){
                    imageRender.getPresentation().sharpen = evt.movementX;        
                }
            } else if (Math.abs(deltaY) > Math.abs(deltaX) && deltaY < 0) {
                //down
                if(evt.movementY <= 8){
                    imageRender.getPresentation().sharpen = evt.movementY;
                }
            }else{
                imageRender.getPresentation().sharpen = 8;
            }
            imageRender.applySharpen(imageRender.getPresentation().sharpen);
            this.oldx = evt.clientX;
            this.oldy = evt.clientY;
        }
    });
            
};
PenTool.prototype = new MouseTool();
PenTool.prototype.constructor = PenTool;
var leftClickEndPoints = undefined;
function PenTool() {
    this.ToolType = "pen";
    this.painting = true;
    this.measurementData = {
        start: {handleActive: false},
        end: {handleActive: false},
        style : {},
        studyUid:undefined,
        measureType: "pen",
        measurementId: null,
        measurementType: null,
        measurementSubType : "pen",
        measurementComplete: false,
        measurementUnits: null,
        isLineExceededOutside: false,
        measurementIndex : 0,
        isEditable: "undefined",
        sessionType: "undefined"
    };
}

PenTool.prototype.hanleMouseDown = function(evt) {

    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(isMobileDevice && dataToEdit !== undefined) {
        this.isMousePressed = true;
    }
    
    //Disable drawing measuremnts while playing cine
    if(dicomViewer.measurement.draw.isMeasuremntDisabled()){
        return;
    }

    if(evt.which == "3"){
        return;
    }

    this.isMousePressed = true;
    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }

    if(!dicomViewer.measurement.isPenToolEnd()){
        dicomViewer.measurement.setPenToolEnd(true);
        dicomViewer.measurement.setPenMeasurementId(dicomViewer.measurement.getPenMeasurementId() +1);
        this.measurementData.measurementIndex = dicomViewer.measurement.getPenMeasurementId();
        this.measurementData.studyUid = getMeasurementStudyUid(imageRenderer.seriesLevelDivId);
        this.measurementData.sessionType = 0;
        this.measurementData.isEditable = true;
    }

    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    dicomViewer.measurement.setLineMeasurementEnd(false);
    

    var widget = imageRenderer.getRenderWidget();
    if(evt.type === "mousedown" || evt.type === "mouseout" || evt.type === "touchstart") {
        var pt = this.hitTestAndGetMousePosition(evt);
        if(pt.isPtInRegion || evt.type === "mouseout" || dataToEdit !== undefined) {
            this.measurementData.style = dicomViewer.measurement.draw.getMeasurementStyle();
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
            this.measurementData.measurementSubType = "pen";
        } else {
            this.isMousePressed = false;
        }
    }

        var measurementType = dicomViewer.measurement.draw.getMeasurementType();
        this.measurementData.measurementId = measurementType.measurementId;
        this.measurementData.measurementType = measurementType.measurementType;
        //for mobile devices not getting the touchend that's why drawing the point on every touchstart
        if(evt.type == "touchstart") {
            dicomViewer.measurement.setTempData(this.measurementData);
        }

};

PenTool.prototype.hanleMouseMove = function(evt,isDoubleClick) {

    var dataToEdit = dicomViewer.measurement.getDataToEdit();
    if(isMobileDevice && dataToEdit !== undefined) {
        this.isMousePressed = true;
    }

    var imageRenderer = this.activeImageRenderer;
    if (imageRenderer === undefined) {
        this.isMousePressed = false;
        return;
    }

    if(!this.isMousePressed) {
        return;
    }

    if(evt.which == "3"){
        return;
    }
    
    var widget = imageRenderer.getRenderWidget();
    if(this.measurementData.start.x === undefined || this.measurementData.start.y === undefined) {
        if(evt.type === "mousemove" || evt.type === "touchmove") {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.start.x = pt.x;
            this.measurementData.start.y = pt.y;
        }
        this.isMousePressed = true;
    } else {
        if(evt.type === "mousemove" || evt.type === "touchmove" || isDoubleClick) {
            var pt = this.hitTestAndGetMousePosition(evt);
            this.measurementData.end.x = pt.x;
            this.measurementData.end.y = pt.y;
            this.measurementData.end.handleActive = true;
        }
        var dataToEdit = dicomViewer.measurement.getDataToEdit();
        if(dataToEdit != undefined) {
            if(dataToEdit.measurmentType === "line")
            {
                dicomViewer.tools.do2DMeasurement(0, null, null)
            } else if(dataToEdit.measurmentType === "point") {
                dicomViewer.tools.do2DMeasurement(1, null, null)
            } else {
                var pt = this.hitTestAndGetMousePosition(evt);
                this.measurementData.start.x = pt.x;
                this.measurementData.start.y = pt.y;
                dicomViewer.measurement.setLineMeasurementEnd(false);
                this.measurementData.measurementIndex = dicomViewer.measurement.getPenMeasurementId();
                dicomViewer.measurement.setTempData(this.measurementData);
            }
        } else {
            this.measurementData.measurementIndex = dicomViewer.measurement.getPenMeasurementId();
            dicomViewer.measurement.setLineMeasurementEnd(false);
            dicomViewer.measurement.setTempData(this.measurementData);
        }
        imageRenderer.drawDicomImage(false, undefined, true);
    }

    if(this.measurementData.end.x !== this.measurementData.start.x || 
       this.measurementData.end.y !== this.measurementData.start.y ) {
        this.measurementData.start.x =  this.measurementData.end.x;
        this.measurementData.start.y = this.measurementData.end.y;
    }

 

};

PenTool.prototype.hanleMouseUp = function(evt) {
    this.painting = false;
    dicomViewer.measurement.setPenToolEnd(false);

    var isTouchContextMenu = false;
    if(evt.event !== undefined && evt.event.eventPhase === 3) {
        isTouchContextMenu = true;
        if(this.isMousePressed = true) {
            this.isMousePressed = false;
        }
    }
    if (evt.which === 3 || isTouchContextMenu) {
        if(isTouchContextMenu) {
            var pt = this.hitTestAndGetMousePosition(evt.event.originalEvent);
            var measurementDelData = {
                x: pt.x,
                y: pt.y,
                measureType: "pendelete"
            };
        } else {
            var pointX = (evt.offsetX || (evt.pageX - widget.offsetLeft)) - 5;
            var pointY = (evt.offsetY || (evt.pageY - widget.offsetTop)) - 5;
            var measurementDelData = {
                x: pointX,
                y: pointY,
                measureType: "pendelete"
            };
        }
        dicomViewer.measurement.setTempData(measurementDelData);
        var imageRender = this.activeImageRenderer;
        //var auids = imageRender.anUIDs.split("*");
        var dContext = this.activeImageRenderer.getRenderWidget().getContext("2d");
        this.activeImageRenderer.drawDicomImage(true);
    }

    if (this.isMousePressed || this.isLineExceededOutside) {
        this.isMousePressed = false;
        this.isLineExceededOutside = false;
        var imageRenderer = this.activeImageRenderer;
        if (imageRenderer === undefined) {
            return;
        }
        var widget = imageRenderer.getRenderWidget();
        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });
        if (evt.type === "mouseup" || evt.type === "touchend" || evt.type === "mouseout") {
            var pt = this.hitTestAndGetMousePosition(evt);
            if(pt !== undefined) {
                this.measurementData.end.x = pt.x;
                this.measurementData.end.y = pt.y;
            } else {
                // touchend will return undefined. Maintain the last touchmove point as the end point
            }

            this.measurementData.end.handleActive = false;

        }
        dicomViewer.measurement.setLineMeasurementEnd(true);
        dicomViewer.measurement.setTempData(this.measurementData);

        this.measurementData = {
            start: {
                handleActive: false
            },
            end: {
                handleActive: false
            },
            measureType: "pen",
            measurementSubType:"pen"
        };
        imageRenderer.drawDicomImage(false);
        dicomViewer.measurement.resetHandeler();
    }

};

PenTool.prototype.hanleDoubleClick = function(evt) {

};

PenTool.prototype.hanleMouseOut = function(evt) {
    this.hanleMouseUp(evt);
};

/**
 * set the measurement/Annotation type
 * @param {Type} type - It specifies the measurement type(arrow,2Dline,etc..)
 */ 
PenTool.prototype.setMeasurementSubType = function (type) {
    this.measurementSubType = type;
};

