function DicomMetaInfoReader(){this.dicomTags=new Object();this.referenceString}DicomMetaInfoReader.prototype.loadDICOMInfo=function(a){a=JSON.parse(a);this.referenceString=a;for(var b=0;b<a.length;b++){this.dicomTags[a[b].tag]=a[b].tagValue}};DicomMetaInfoReader.prototype.getDicomTagValue=function(a){return(this.dicomTags["("+a+")"])};DicomMetaInfoReader.prototype.getReference=function(){return this.referenceString};DicomMetaInfoReader.prototype.getPhotometricInterpretation=function(){return this.dicomTags["(0028,0004)"]};DicomMetaInfoReader.prototype.getColumns=function(){return parseInt(this.dicomTags["(0028,0011)"])};DicomMetaInfoReader.prototype.getRows=function(){return parseInt(this.dicomTags["(0028,0010)"])};DicomMetaInfoReader.prototype.getBitDepth=function(){var a=parseInt(this.dicomTags["(0028,0100)"]);if(a==8){return 1}else{if(a==16){return 2}}};DicomMetaInfoReader.prototype.getWindowWidth=function(){return parseInt(this.dicomTags["(0028,1051)"])};DicomMetaInfoReader.prototype.getWindowCenter=function(){return parseInt(this.dicomTags["(0028,1050)"])};DicomMetaInfoReader.prototype.getRescaleIntercept=function(){if(this.dicomTags["(0028,1052)"]===undefined){return 0}else{return parseInt(this.dicomTags["(0028,1052)"])}};DicomMetaInfoReader.prototype.getRescaleSlope=function(){if(this.dicomTags["(0028,1053)"]===undefined){return 1}else{return parseInt(this.dicomTags["(0028,1053)"])}};DicomMetaInfoReader.prototype.getPatientName=function(){return(this.dicomTags["(0010,0010)"])};DicomMetaInfoReader.prototype.getPatientId=function(){return(this.dicomTags["(0010,0020)"])};DicomMetaInfoReader.prototype.getPatientDOB=function(){return(this.dicomTags["(0010,0030)"])};DicomMetaInfoReader.prototype.getPatientSex=function(){return(this.dicomTags["(0010,0040)"])};DicomMetaInfoReader.prototype.getStudyDate=function(){return(this.dicomTags["(0008,0020)"])};DicomMetaInfoReader.prototype.getAccessionNumber=function(){return(this.dicomTags["(0008,0050)"])};DicomMetaInfoReader.prototype.getInstitutionName=function(){return(this.dicomTags["(0008,0080)"])};DicomMetaInfoReader.prototype.getManufacturer=function(){return(this.dicomTags["(0008,0070)"])};DicomMetaInfoReader.prototype.getReferringPhysicianName=function(){return(this.dicomTags["(0008,0090)"])};DicomMetaInfoReader.prototype.getStudyInstanceUID=function(){return(this.dicomTags["(0020,000D)"])};DicomMetaInfoReader.prototype.getSeriesInstanceUID=function(){return(this.dicomTags["(0020,000E)"])};DicomMetaInfoReader.prototype.getSopInstanceUID=function(){return(this.dicomTags["(0008,0018)"])};DicomMetaInfoReader.prototype.getInstanceNumber=function(){return(this.dicomTags["(0020,0013)"])};DicomMetaInfoReader.prototype.getColumnPixelSpacing=function(){return this.getPixelSpacing().column};DicomMetaInfoReader.prototype.getRowPixelSpacing=function(){return this.getPixelSpacing().row};DicomMetaInfoReader.prototype.getPixelSpacing=function(){var a=this.dicomTags["(0028,0030)"];if(a&&a.length>0){var b=a.split("\\");return{row:parseFloat(b[0]),column:parseFloat(b[1])}}else{return{row:undefined,column:undefined}}};function ImageInfoManager(a){this.imageInfo=JSON.parse(a)}ImageInfoManager.prototype.getWindowWidth=function(){return this.imageInfo.windowWidth};ImageInfoManager.prototype.getWindowCenter=function(){return this.imageInfo.windowCenter};ImageInfoManager.prototype.getRescaleSlope=function(){return this.imageInfo.decimalRescaleSlope};ImageInfoManager.prototype.getRescaleIntercept=function(){return this.imageInfo.decimalRescaleIntercept};ImageInfoManager.prototype.getMaxPixelValue=function(){return this.imageInfo.maxPixelValue};ImageInfoManager.prototype.getMinPixelValue=function(){return this.imageInfo.minPixelValue};ImageInfoManager.prototype.setMaxPixelValue=function(a){this.imageInfo.maxPixelValue=a};ImageInfoManager.prototype.setMinPixelValue=function(a){this.imageInfo.minPixelValue=a};ImageInfoManager.prototype.isColor=function(){return this.imageInfo.isColor};ImageInfoManager.prototype.isSigned=function(){return this.imageInfo.isSigned};ImageInfoManager.prototype.isPlanar=function(){return this.imageInfo.isPlanar};ImageInfoManager.prototype.getSamplesPerPixel=function(){return this.imageInfo.samplesPerPixel};ImageInfoManager.prototype.getPlanarConfiguration=function(){return this.imageInfo.planarConfiguration};ImageInfoManager.prototype.getPixelRepresentation=function(){return this.imageInfo.pixelRepresentation};ImageInfoManager.prototype.getPhotometricInterpretation=function(){return this.imageInfo.photometricInterpretation};ImageInfoManager.prototype.getFrameSize=function(){return this.imageInfo.frameSize};ImageInfoManager.prototype.getNumberOfFrames=function(){return this.imageInfo.numberOfFrames};ImageInfoManager.prototype.getColumns=function(){return this.imageInfo.imageWidth};ImageInfoManager.prototype.setColumns=function(a){this.imageInfo.imageWidth=a};ImageInfoManager.prototype.getRows=function(){return this.imageInfo.imageHeight};ImageInfoManager.prototype.setRows=function(a){this.imageInfo.imageHeight=a};ImageInfoManager.prototype.getHighBit=function(){return this.imageInfo.highBit};ImageInfoManager.prototype.getBitsStored=function(){return this.imageInfo.bitsStored};ImageInfoManager.prototype.getBitsAllocated=function(){return this.imageInfo.bitsAllocated};ImageInfoManager.prototype.getBitDepth=function(){return this.imageInfo.highBit+1};ImageInfoManager.prototype.getPatientName=function(){return this.imageInfo.patientName};ImageInfoManager.prototype.getStudyDate=function(){return this.imageInfo.studyDate};ImageInfoManager.prototype.getStudyTime=function(){return this.imageInfo.studyTime};ImageInfoManager.prototype.getAccessionNumber=function(){return this.imageInfo.accessionNumber};ImageInfoManager.prototype.getManufacturer=function(){return this.imageInfo.manufacturer};ImageInfoManager.prototype.getInstanceNumber=function(){return this.imageInfo.instanceNumber};ImageInfoManager.prototype.getIsCompressed=function(){return this.imageInfo.isCompressed};ImageInfoManager.prototype.getDirectionalMarkers=function(){return this.imageInfo.directionalMarkers};ImageInfoManager.prototype.getCompressionMethod=function(){return this.imageInfo.compressionMethod};ImageInfoManager.prototype.getUSRegions=function(){if((this.imageInfo.measurement!=null)&&(this.imageInfo.measurement.usRegions!=null)){return this.imageInfo.measurement.usRegions}return undefined};ImageInfoManager.prototype.getContentTime=function(){var a=this.imageInfo.contentTime;if(a==undefined||a==null){a=""}return a};ImageInfoManager.prototype.getContentDate=function(){var a=this.imageInfo.contentDate;if(a==undefined||a==null){a=""}return a};ImageInfoManager.prototype.getModality=function(){var a=this.imageInfo.modality;if(a==undefined||a==null){a=""}return a};var dicomViewer=(function(F){if(F===undefined){F={}}var t;var C={};var v=undefined;var m=undefined;var f=false;var u={};var j={};var b={};var y=true;var J="3x4+1";function D(O,Q,N,P){var U=H(O.ImageUid);var S=g(O.ImageUid);if(U!=undefined&&S!=undefined&&y){N=F.getEcgMenuUrl(t.ImageUid,r());e("GridType",U.gridType,S.GridType);e("GridColor",U.gridColor,S.GridColor);e("SignalThickness",U.signalThickness,S.SignalThickness);e("Gain",U.gain,S.Gain);e("LeadFormat",U.leadFormat,S.DrawType);P=true}$("#ecgPreference").prop("disabled",false);t=F.getEcgInformationUrl(O.ImageUid);var R=F.url.getDicomImageURL(O);var T;if(window.XMLHttpRequest){T=new XMLHttpRequest()}else{T=new ActiveXObject("Microsoft.XMLHTTP")}T.onreadystatechange=function(){if(T.readyState==4&&T.status==200){if(!P){var V="1";var aN="0";var aH="1";var aw="1";var ak="8";var az="redGrid";var au=F.viewports.getViewport(Q);if(au!==undefined&&au!==null){var ad=au.getImageRender("ecgData");if(au!==undefined&&ad!==undefined){ad.applyOrRevertDisplaySettings();var am=au.preferenceInfo;if(am!==undefined&&am.selectedEcgFormat!==undefined){V=am.selectedEcgFormat.GridType;aN=am.selectedEcgFormat.GridColor;aH=am.selectedEcgFormat.SignalThickness;aw=am.selectedEcgFormat.Gain;ak=am.selectedEcgFormat.DrawType}if(am!==undefined&&am.preferenceData!==undefined){az=am.preferenceData.gridColor}}}O=F.getEcgWaveformUrl(O.ImageUid,ak,V,aN,aH,aw);var aA=F.getActiveSeriesLayout();if(aA!=null||aA!=undefined){aA.preferenceInfo.addECGParameters("GridType",V);aA.preferenceInfo.addECGParameters("GridColor",aN);aA.preferenceInfo.addECGParameters("SignalThickness",aH);aA.preferenceInfo.addECGParameters("Gain",aw);aA.preferenceInfo.addECGParameters("DrawType",ak);aA.preferenceInfo.setGridColor(az)}R=F.url.getDicomImageURL(O)}else{N.Transform="Png";R=F.url.getDicomImageURL(N);var aL="";var aA=F.getActiveSeriesLayout();var W=aA.preferenceInfo.getECGParameters();for(var aj in W){aL=aL+"&"+aj+"="+W[aj]}R=R+aL}var at=JSON.parse(T.responseText);var aI=at.LeadTypes;var ah=aI.length;var ao="";var aJ="";var aa="";var ae="<select id='3x41Value'>";for(var av=0;av<ah;av++){var aB=aI[av];ae=ae+"<option value='"+aB+"'>"+aB+"</option>";if(av===1){ao=aB}else{if(av===7){aJ=aB}else{if(av===10){aa=aB}}}}ae=ae+"</select>";$("#3x41").html("signal:"+ae);$("#3x41Value").css("color","#525252");$("#3x41Value").val(ao);ae=ae.replace("'3x41Value'","'3x43one' disabled");$("#3x43_1").html(ae);$("#3x43one").css("color","#525252");$("#3x43one").val(ao);ae=ae.replace("'3x43one'","'3x43two' disabled");$("#3x43_2").html(ae);$("#3x43two").val(aJ);$("#3x43two").css("color","#525252");ae=ae.replace("'3x43two'","'3x43three' disabled");$("#3x43_3").html(ae);$("#3x43three").val(aa);$("#3x43three").css("color","#525252");f=true;var ag=n(at.PatientName);var X=n(at.PatientAge);var aK=n(at.PatientGender);var aO=n(at.PatientId);var af=n(at.AcquisitionDateTime);var ay=n(at.DiagnosticText);var aG=n(at.PRInt);var Y=n(at.PRTAxes);var ai=n(at.QRSDur);var aq=n(at.QTQTc);var ab=n(at.VentRate);var ac=n(at.ReferringPhysician);var aF=n(at.ConfirmedPhysician);var Z="<div id='ecgData_"+Q+"' style='font-size:12px;' ><div id='ecgDataDiv_"+Q+"' style='background:white;'><table><tr><td>Naming:</td><td>&nbsp"+ag+"</td><td>&nbsp&nbsp&nbsp&nbspVent Rate:</td><td>&nbsp"+ab+"</td><td rowspan="+5+">&nbsp&nbsp&nbsp&nbsp</td><td rowspan="+5+">"+ay+"</td></tr><tr><td>Age:</td><td>&nbsp"+X+"</td><td>&nbsp&nbsp&nbsp&nbspPR Interval:</td><td>&nbsp"+aG+"</td></tr><tr><td>Gender:</td><td>&nbsp"+aK+"</td><td>&nbsp&nbsp&nbsp&nbspQRS Duration:</td><td>&nbsp"+ai+"</td></tr><tr><td>Patient Id:</td><td>&nbsp"+aO+"</td><td>&nbsp&nbsp&nbsp&nbspQT/QTc:</td><td>&nbsp"+aq+"</td></tr><tr><td>Acquisition DateTime:</td><td>&nbsp"+af+"</td><td>&nbsp&nbsp&nbsp&nbspP-R-T axes:</td><td>&nbsp"+Y+"</td></tr><tr><td></td><td></td><td>Referred by:&nbsp"+ac+"&nbsp&nbspConfirmed by:&nbsp"+aF+"</td></tr></table></div></div>";var an=$("#"+Q).height();var aC=$("#"+Q).width();$("#"+Q).html(Z);$("#"+Q).height(an);$("#"+Q).width(aC);var aD=$("#ecgData_"+Q).height();$("#"+Q).css("overflow","auto");$("#"+Q).css("background","white");var aE="imageEcgDiv"+Q;var ax="<div id='"+aE+"' align='center' style='background:white;float: left;' ></div>";$("#"+Q).append(ax);$("<input>").attr({type:"hidden",id:"imageEcgHidden"+Q,name:"bar"}).appendTo($("#"+Q));document.getElementById("imageEcgHidden"+Q).value=R;var al=document.createElement("canvas");al.setAttribute("id","imageEcgCanvas"+Q);var aM=al.getContext("2d");al.style.background="white";var ar=new Image();ar.src=R;ar.isMedian=(at.isMedian===undefined?false:at.isMedian);var ap=$("#"+Q).height()-$("#ecgData_"+Q).height();$("#"+aE).height(ap);$("#"+aE).width($("#"+Q).width());ar.onload=function(){if(O.ImageUid!==undefined){k(O.ImageUid,"green")}var aV=F.viewports.getViewport(Q);var aW=aV.getImageRender("ecgData");aW.ecgData={imageObject:ar,width:ar.width,height:ar.height};var aS=1;aW.isMedian=ar.isMedian;aW.applyOrRevertDisplaySettings(undefined,false,false);var aU=document.getElementById(aE);var aQ=aW.ecgScalepreset;if(aV.ecgZoomProperty){aQ=aV.ecgZoomProperty.level}F.tools.updateZoomLevelSettings(aQ+"_zoom");switch(aQ){case 0:aS=1;break;case 1:aS=Math.min((aU.offsetHeight-4)/ar.height,aU.offsetWidth/ar.width);break;case 2:aS=aU.offsetWidth/ar.width;break;case 3:aS=aU.offsetHeight/ar.height;break;case 6:aS=aV.ecgZoomProperty.customValue/100;break}if(aS>1){aS=Math.max(1,aS-0.05)}al.width=ar.width*aS;al.height=ar.height*aS;aS=aS.toFixed(2);aW.tempEcgScale=aS;aM.scale(aS,aS);aM.drawImage(ar,0,0);var aP=aM.getImageData(0,0,al.width,al.height);var aR=aV.preferenceInfo.getECGParameters();if(!P){aV.preferenceInfo.addECGParameters("GridType","1");aV.preferenceInfo.addECGParameters("GridColor","0");aV.preferenceInfo.addECGParameters("SignalThickness","1");aV.preferenceInfo.addECGParameters("Gain","1");aV.preferenceInfo.addECGParameters("DrawType","8")}aV.setEcgCanvas(aP);var aT=aV.getImageRender("ecgData").getImageUid();var aX=F.getHorizontalCaliper(aT);if(aX!=undefined){F.redrawBothCaliper(aV)}};$("#"+aE).append(al)}};T.open("GET",R,false);T.send()}function c(){var N=F.getActiveSeriesLayout();if(!N.isCaliperEnable){F.redrawBothCaliper(N)}}function d(N,O){t.ImageUid=G();var P=F.getEcgMenuUrl(t.ImageUid,r());e("GridType",O,N);z(P)}function M(N,O){t.ImageUid=G();var P=F.getEcgMenuUrl(t.ImageUid,r());e("GridColor",O,N);z(P)}function r(P){var R={"3x41Value":"II","3x43one":"II","3x43two":"V2","3x43three":"V5"};var N=F.getActiveSeriesLayout();var Q=N.getSeriesLayoutId();var O=leadTypeObject[Q];O=$.extend({},R,O);if(P==4){return O["3x41Value"]}else{if(P==8){return O["3x43one"]+"|"+O["3x43two"]+"|"+O["3x43three"]}else{return""}}setChangedValues()}function q(P,O){t.ImageUid=G();var N=F.getEcgMenuUrl(t.ImageUid,r(P));e("LeadFormat",O,P);z(N)}function B(O,N){t.ImageUid=G();var P=F.getEcgMenuUrl(t.ImageUid,r());e("Gain",N,O);z(P)}function s(O,P){t.ImageUid=G();var N=F.getEcgMenuUrl(t.ImageUid,r());e("SignalThickness",P,O);z(N)}function z(O){y=false;D(t,l(),O,true);var P=t.ImageUid;var Q=F.getActiveSeriesLayout();var R=Q.preferenceInfo.preferenceData;var N=Q.preferenceInfo.selectedEcgFormat;E(P,N);w(P,R);y=true}function H(N){return u[N]}function w(O,N){u[O]=N}function g(N){return b[N]}function E(O,N){b[O]=N}function A(){for(var N in b){delete b[N]}for(var N in u){delete u[N]}F.removeAllCaliperStatus()}function p(O,N){j[O]=N}function a(N){j[N]}function n(N){if(N==undefined||N==null){return""}return N}function G(){var N=F.getActiveSeriesLayout();var O=N.getImageRender("ecgData");return O.imageUid}function e(O,R,Q){var N=F.getActiveSeriesLayout();switch(O){case"GridType":$("#none").parent().css("background","");$("#onemm").parent().css("background","");$("#fivemm").parent().css("background","");$("#"+R).parent().css("background","#868696");N.preferenceInfo.preferenceData.gridType=R;N.preferenceInfo.addECGParameters("GridType",Q);break;case"GridColor":$("#redGrid").parent().css("background","");$("#greenGrid").parent().css("background","");$("#blueGrid").parent().css("background","");$("#blackGrid").parent().css("background","");$("#greyGrid").parent().css("background","");$("#"+R).parent().css("background","#868696");N.preferenceInfo.setGridColor(R);N.preferenceInfo.addECGParameters("GridColor",Q);break;case"LeadFormat":$("#threebyfour").parent().css("background","");$("#threebyfourplusone").parent().css("background","");$("#threebyfourplusthree").parent().css("background","");$("#sixbytwo").parent().css("background","");$("#twelvebyone").parent().css("background","");$("#averagecomplex").parent().css("background","");$("#"+R).parent().css("background","#868696");N.preferenceInfo.setLeadFormat(R);N.preferenceInfo.addECGParameters("DrawType",Q);break;case"Gain":$("#fivemmgain").parent().css("background","");$("#tenmmgain").parent().css("background","");$("#twentymmgain").parent().css("background","");$("#fourtymmgain").parent().css("background","");$("#"+R).parent().css("background","#868696");N.preferenceInfo.setGain(R);N.preferenceInfo.addECGParameters("Gain",Q);break;case"SignalThickness":$("#onethickness").parent().css("background","");$("#twothickness").parent().css("background","");$("#threethickness").parent().css("background","");$("#"+R).parent().css("background","#868696");N.preferenceInfo.setSignalThickness(R);N.preferenceInfo.addECGParameters("SignalThickness",Q);break}var S=F.getActiveSeriesLayout();if(S!==undefined&&S!==null){var P=S.getImageRender("ecgData");if(P!==undefined&&P!==null){if(S!==undefined){P.applyOrRevertDisplaySettings(undefined,undefined,undefined,true)}}}}function n(N){if(N==undefined||N==null){return""}return N}function l(){var N=F.getActiveSeriesLayout();return N.getSeriesLayoutId()}function k(P,O){if(j[P]==undefined){ecgRenderedCount++;var Q=F.getActiveSeriesLayout();if(Q!==null&&Q!==undefined){p(P,Q.seriesLayoutId)}}else{for(var N in j){if(N!=P){ecgRenderedCount++;p(P,F.getActiveSeriesLayout().seriesLayoutId)}else{return}}}$("#cachemanager_progress").trigger("image_cache_updated",F.imageCache.getCacheInfo());updateThumbnailCacheIndication(P,O)}function x(N){if(N==="3x4+3"){$("#3x41Value").prop("disabled",true);$("#3x43one").prop("disabled",false);$("#3x43two").prop("disabled",false);$("#3x43three").prop("disabled",false)}else{$("#3x41Value").prop("disabled",false);$("#3x43one").prop("disabled",true);$("#3x43two").prop("disabled",true);$("#3x43three").prop("disabled",true)}I(N)}function K(){var O=F.getActiveSeriesLayout();t.ImageUid=G();e("GridType","onemm","1");e("GridColor","redGrid","0");e("LeadFormat","threebyfourplusthree","8");e("Gain","tenmmgain","1");e("SignalThickness","onethickness","1");F.RevertCaliper();var N=F.getEcgMenuUrl(t.ImageUid,r());z(N)}function L(O){try{if(O!==undefined){for(var N in j){if(N===O){ecgRenderedCount--;delete j[O]}}$("#cachemanager_progress").trigger("image_cache_updated",F.imageCache.getCacheInfo())}}catch(P){}}function I(N){J=N}function o(){return J}function h(){var N=o();x(N)}F.loadEcg=D;F.gridType=d;F.gridColor=M;F.leadFormat=q;F.gain=B;F.thickness=s;F.changeNullToEmpty=n;F.loadCaliper=c;F.changeECGLedType=x;F.removeSavedECGPreference=A;F.Refresh=K;F.ClearECGCacheDetails=L;F.updateECGPreferenceDropDown=h;return F}(dicomViewer));var angleDefaults=[0,90,180,270];var orientationDefaults=[{rotate:0,mirror:0,rotateLeft:1,rotateRight:3,flipHorz:4,flipVert:6,left:0,right:1,top:2,bottom:3},{rotate:3,mirror:0,rotateLeft:2,rotateRight:0,flipHorz:7,flipVert:5,left:2,right:3,top:1,bottom:0},{rotate:2,mirror:0,rotateLeft:3,rotateRight:1,flipHorz:6,flipVert:4,left:1,right:0,top:3,bottom:2},{rotate:1,mirror:0,rotateLeft:0,rotateRight:2,flipHorz:5,flipVert:7,left:3,right:2,top:0,bottom:1},{rotate:0,mirror:1,rotateLeft:5,rotateRight:7,flipHorz:0,flipVert:2,left:1,right:0,top:2,bottom:3},{rotate:3,mirror:1,rotateLeft:6,rotateRight:4,flipHorz:3,flipVert:1,left:2,right:3,top:0,bottom:1},{rotate:2,mirror:1,rotateLeft:7,rotateRight:5,flipHorz:2,flipVert:0,left:0,right:1,top:3,bottom:2},{rotate:1,mirror:1,rotateLeft:4,rotateRight:6,flipHorz:1,flipVert:3,left:3,right:2,top:1,bottom:0}];var previousLayoutSelection="";function S4(){return(((1+Math.random())*65536)|0).toString(16).substring(1)}function guid(){return(S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4())}function ImageRenderer(g,b){this.imagePromise;this.uid=guid();this.anUIDs;this.invertFlag=false;this.zoomFlag=false;this.tScaleValue=1;this.isPresetDefault=false;this.scaleValue;this.seriesLevelDivId=b;this.parentElement=g;this.renderWidget=document.createElement("canvas");this.renderWidget.setAttribute("id",this.uid);this.renderWidgetLayer=document.createElement("canvas");this.renderWidgetLayer.style.zIndex="10";this.renderWidgetLayer.style.position="absolute";this.overlayCanvas=document.createElement("canvas");this.overlayCanvas.style.zIndex="2";this.overlayCanvas.style.position="absolute";var a=$("#"+g);var f=a.outerWidth();var h=a.outerHeight();var j=f-a.width();var e=h-a.height();this.viewportWidth=f;this.viewportHeight=h;this.renderWidget.width=this.viewportWidth-j-5;this.renderWidget.height=this.viewportHeight-e-5;this.renderWidgetLayer.width=this.viewportWidth-j;this.renderWidgetLayer.height=this.viewportHeight-e;this.overlayCanvas.width=this.viewportWidth-5;this.overlayCanvas.height=this.viewportHeight-5;this.renderWidget.style.margin=5+"px";a.append(this.renderWidget);a.append(this.renderWidgetLayer);a.append(this.overlayCanvas);this.renderWidget.style.zIndex="1";this.renderWidget.style.position="absolute";this.touchEvent=false;this.gestureEvent=false;this.seriesIndex=-1;this.imageIndex=-1;this.imageUid="";this.selfReference=this;this.presentationState=undefined;this.headerInfo=undefined;this.ecgScalepreset=2;this.tempEcgScale=0;var k=this.renderWidget.getContext("2d");this.imageCanvas=document.createElement("canvas");this.imageCanvas.canvasId=this.parentElement;trackTransforms(k);this.renderWidgetCtx=k;this.validDoubleClick=false;var c=function d(p){var m=p;var o;var n=false;var r={ptX:undefined,ptY:undefined,imageIndex:undefined,frameIndex:undefined,useStartPosition:false};this.handleEvent=function(t){if(m.seriesLevelDivId!==dicomViewer.getActiveSeriesLayout().getSeriesLayoutId()){return}displayCompressinToolTip(t,m);var u=dicomViewer.mouseTools.getActiveTool();if(u){u.setActiveImageRenderer(m);if(t.type==="mouseup"&&(t.which===3||(t.which===1&&dicomViewer.mouseTools.getToolName()===TOOLNAME_WINDOWLEVEL_ROI))){u.hanleMouseUp(t)}else{if(t.type==="mousedown"&&(t.which===1||dicomViewer.mouseTools.getToolName()===TOOLNAME_WINDOWLEVEL_ROI)){if(o==null){o=200}var w;if(o!=t.timeStamp){w=t.timeStamp-o}if(w>300){u.hanleMouseDown(t)}else{u.hanleMouseMove(t,true);u.hanleMouseDown(t)}o=t.timeStamp}else{if(t.type==="mousedown"&&t.which===2){r.ptX=undefined;r.ptY=undefined;r.useStartPosition=false}else{if(t.type==="mouseup"&&t.which===1){u.hanleMouseUp(t)}else{if(t.type==="mouseup"&&t.which===2){if(n){n=false;dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getDefaultTool());$("#viewport_View").css("cursor","default")}else{dicomViewer.scroll.toggleCineRunning()}}else{if(t.type==="mouseover"){u.hanleMouseOver(t)}else{if(t.type==="mousemove"&&dicomViewer.mouseTools.getToolName()===TOOLNAME_WINDOWLEVEL_ROI){u.hanleMouseMove(t)}else{if(t.type==="mouseout"){u.hanleMouseOut(t)}else{if(t.type==="mousemove"&&t.buttons===4){if(r.ptX===undefined||r.ptY===undefined){r.ptX=t.clientX;r.ptY=t.clientY;r.useStartPosition=false}else{var v=getNavigation(r,t);if(v!==undefined){n=true;$("#viewport_View").css("cursor","url(images/navigate.cur), auto");dicomViewer.scroll.moveToNextOrPreviousImage(!v.moveToNext,undefined,v,r.useStartPosition);if(r.useStartPosition===false){var s=dicomViewer.getActiveSeriesLayout();var x=dicomViewer.scroll.getCurrentImageAndFrameIndex(!v.moveToNext,s);r.imageIndex=x[0];r.frameIndex=x[1];r.useStartPosition=true}}else{r.ptX=undefined;r.ptY=undefined;r.frameIndex=undefined;r.imageIndex=undefined;r.useStartPosition=false;n=false}}}else{if(t.type==="mousemove"&&(t.buttons===1&&(dicomViewer.mouseTools.getToolName()==="Zoom"||dicomViewer.mouseTools.getToolName()==="WindowLevel"||dicomViewer.mouseTools.getToolName()==="pointMeasurement"||dicomViewer.mouseTools.getToolName()==="Pan"||dicomViewer.mouseTools.getToolName()==="lineMeasurement"||dicomViewer.mouseTools.getToolName()==="angleMeasurement"||dicomViewer.mouseTools.getToolName()==="rectangleMeasurement"||dicomViewer.mouseTools.getToolName()==="ellipseMeasurement"||dicomViewer.mouseTools.getToolName()==="mitralMeanGradientMeasurement"||dicomViewer.mouseTools.getToolName()===TOOLNAME_DEFAULTTOOL||dicomViewer.mouseTools.getToolName()===TOOLNAME_PEN||dicomViewer.mouseTools.getToolName()===TOOLNAME_SHARPENTOOL))){u.hanleMouseMove(t)}else{if(t.type==="mousemove"&&t.buttons===0&&(dicomViewer.mouseTools.getToolName()==="traceMeasurement"||dicomViewer.mouseTools.getToolName()==="volumeMeasurement"||dicomViewer.mouseTools.getToolName()==="lineMeasurement"||dicomViewer.mouseTools.getToolName()==="mitralMeanGradientMeasurement"||dicomViewer.mouseTools.getToolName()==="angleMeasurement"||dicomViewer.mouseTools.getToolName()==="rectangleMeasurement")){u.hanleMouseMove(t)}else{if(t.type==="dblclick"&&t.which===1){isCineEnabled(true);t.preventDefault();dicomViewer.mouseTools.setPreviousTool(dicomViewer.mouseTools.getActiveTool());u.hanleDoubleClick(t);doubleClick();m.doClickDefaultTool()}else{if(t.type==="DOMMouseScroll"&&dicomViewer.mouseTools.getToolName()=="zoom"){u.hanleMouseWheel(t)}else{if(t.type==="touchmove"){if(this.touchEvent&&!this.gestureEvent){if(t.touches.length==1){if(dicomViewer.mouseTools.getToolName()=="Zoom"){dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getPanTool())}t.preventDefault();u.hanleMouseMove(t)}else{if(t.touches.length==2){dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getZoomTool());u.setActiveImageRenderer(m);u.hanleMouseMove(t)}}}}else{if(t.type==="touchstart"){this.touchEvent=true;if(t.touches.length===1){u.hanleMouseDown(t);if(o!=t.timeStamp){var w=t.timeStamp-o}if(w<200){this.validDoubleClick=true}o=t.timeStamp}else{if(t.touches.length===2){firstTouchPos=t.touches[0].clientX;secondTouchPos=t.touches[1].clientX;diffTwoTouches=t.touches[1].clientX-t.touches[0].clientX;u.setActiveImageRenderer(m);u.hanleMouseDown(t)}}}else{if(t.type==="touchend"){if(this.validDoubleClick){isCineEnabled(true);t.preventDefault();u.hanleDoubleClick();doubleClick();this.validDoubleClick=false}else{t.preventDefault();u.hanleMouseUp(t);this.touchEvent=false}}}}}}}}}}}}}}}}}}};var l=p.renderWidgetLayer;var q=this.handleEvent;l.addEventListener("mouseup",q);l.addEventListener("mousemove",q);l.addEventListener("mouseover",q);l.addEventListener("mouseout",q);l.addEventListener("mousedown",q);l.addEventListener("dblclick",q);l.addEventListener("touchstart",q);l.addEventListener("touchmove",q);l.addEventListener("touchend",q);l.addEventListener("DOMMouseScroll",q);l.addEventListener("mousewheel",q)};c(this)}ImageRenderer.prototype.init=function(d,c,b){this.seriesIndex=c;this.imageIndex=b;this.anUIDs=d;var a=d.split("*");this.imageUid=a[0];var e=a[1];dicomViewer.renderer.setImageRenderer(this.imageUid+"_"+e,this)};ImageRenderer.prototype.loadImageRenderer=function(g,f,d){if(g!=undefined){this.imagePromise=g}this.presentationState=undefined;if(this.imagePromise==undefined){this.imagePromise=dicomViewer.imageCache.getImagePromise(f.imageUid+"_"+f.frameNumber)}var l=null;this.imagePromise.then(function(s){l=s});dicomViewer.imageCache.setImageData(l,this.parentElement);var j=undefined;if(isFullScreenEnabled){var a=dicomViewer.getActiveSeriesLayout();var p=a.getSeriesLayoutId();var h=dicomViewer.getActiveSeriesLayout();j=h.getImageRender(p+"ImageLevel0x0")}if(this.presentationState==undefined||this.presentationState==null){this.presentationState=new Presentation();if(l===undefined||l===null){return}if(l.presentation!=null||l.presentation!=undefined){l.presentation.copy(this.presentationState);this.presentationState.setWindowingdata(l.presentation.getWindowCenter(),l.presentation.getWindowWidth())}}dicomViewer.renderer.removeImageRenderer(this.imageUid+"_"+l.frameNumber);var e=this.presentationState;if(f!=undefined){this.imagePromise=dicomViewer.imageCache.getImagePromise(f.imageUid+"_"+(f.frameNumber));this.imageUid=f.imageUid;this.anUIDs=f.imageUid+"*"+(f.frameNumber);this.imageIndex=(f.imageIndex==undefined)?this.imageIndex:f.imageIndex;e.setWindowingdata(f.lastAppliedwindowCenter,f.lastAppliedWindowWidth);e.setOrientation(f.presentation.getOrientation());this.applyOrRevertDisplaySettings(e,false,false,undefined)}else{this.applyOrRevertDisplaySettings(e,true,false,undefined)}var o=l.dicominfo;this.headerInfo=o;var r=o.getRows();var c=o.getColumns();e.currentPreset=0;isRevert=true;if((l.windowCenter!=e.windowCenter||l.windowWidth!=e.windowWidth||l.invert!=e.invert)&&f==undefined){if(l.invert!=e.invert){var n=!e.invert;e.setInvertFlag(n);l.presentation.invert=n}e.setWindowingdata(l.windowCenter,l.windowWidth)}if(o.imageInfo.numberOfFrames<2&&o.imageInfo.modality!=="US"&&o.imageInfo.imageType!=IMAGETYPE_JPEG){l.isWLApplied=false;dicomViewer.updateImage(this.imageCanvas,l,e)}var q=this.renderWidgetCtx;q.setTransform(1,0,0,1,0,0);var k=undefined;if(j!=undefined&&isFullScreenEnabled){k=j.scaleValue;if(k!=undefined){l.presentation.zoom=k;e.zoomLevel=j.presentationState.zoomLevel;l.presentation.zoomLevel=j.presentationState.zoomLevel}}if(k==undefined){k=e.getZoom()}var m=e.getPan();q.translate(this.renderWidget.width/2,this.renderWidget.height/2);if(e.isScaleToFitMode()){k=this.getZoomFactor(1,r,c);e.setZoom(k);l.presentation.setPresentationMode("SCALE_TO_FIT");this.scaleValue=k;m.x=-c/2;m.y=-r/2}else{if(e.getPresentationMode()=="MAGNIFY"){l.presentation.setZoom(k);l.presentation.setPresentationMode("MAGNIFY");this.scaleValue=k;m.x=-c/2;m.y=-r/2}}this.renderImage(true);if(e!==undefined){var b=undefined;if(e.zoomLevel!==undefined&&e.zoomLevel!==-1){b=e.zoomLevel}else{if(l.presentation!==undefined&&l.presentation.zoomLevel===-1){b="6_zoom-"+(parseFloat(l.presentation.zoom)*100).toString()}}if(b!==undefined){this.setZoomLevel(b)}}this.applyPan()};ImageRenderer.prototype.refresh=function(y,j,f,a,s,k){this.anUIDs=j;var m=j.split("*");this.imageUid=m[0];var h=m[1];this.imageCanvas=document.createElement("canvas");this.imageCanvas.canvasId=this.parentElement;var o=dicomViewer.getActiveSeriesLayout();if(this.seriesIndex!==s){f=true}this.seriesIndex=s;this.imageIndex=a;if(y==null){var r=dicomViewer.imageCache.getImagePromise(this.imageUid+"_"+h);if(r===undefined){r=dicomViewer.loadAndCacheImage(this.imageUid,h,s)}this.imagePromise=r}else{this.imagePromise=y}var l=$("#"+this.parentElement).parent().closest("div").attr("id");var x=this;this.imagePromise.done(function(z){imageCanvas=z});dicomViewer.imageCache.setImageData(imageCanvas,this.parentElement);if(this.presentationState==undefined||this.presentationState==null){logger.info("presentation is undefined");this.presentationState=new Presentation();if(imageCanvas===undefined||imageCanvas===null){return}if(imageCanvas.presentation!=null||imageCanvas.presentation!=undefined){imageCanvas.presentation.copy(x.presentationState);this.presentationState.setWindowingdata(imageCanvas.presentation.getWindowCenter(),imageCanvas.presentation.getWindowWidth());var q=this.renderWidgetCtx;q.setTransform(1,0,0,1,0,0);q.translate(this.renderWidget.width/2,this.renderWidget.height/2)}v=this.presentationState}if(l==o.getSeriesLayoutId()){if(imageCanvas!=null){dicomViewer.setimageCanvasOfViewPort(l,imageCanvas,imageCanvas.presentation)}}var g=imageCanvas.dicominfo;if(!g){return}var e=g.getRows();var c=g.getColumns();var v=this.presentationState;if(v!=undefined){var b=v.getZoom();var p=v.getPan();if(v.isScaleToFitMode()){b=Math.min(this.renderWidget.height/e,this.renderWidget.width/c);v.setZoom(b);p.x=-c/2;p.y=-e/2}if(!this.zoomFlag){this.scaleValue=b}var u=dicomViewer.getActiveSeriesLayout();var d=u.getAllImageRenders();if(k&&f){this.presentationState.setWindowingdata(imageCanvas.lastAppliedwindowCenter,imageCanvas.lastAppliedWindowWidth)}else{this.presentationState.setWindowingdata(v.windowCenter,v.windowWidth)}this.renderImage(true);var n=false;var t=null;for(var w in d){if(t==null){t=d[w]}if(this==d[w]){n=true}}if(n==true){dicomViewer.viewports.refreshViewports(this)}}};ImageRenderer.prototype.locationOnScreen=function(){var c=0,a=0;var b=this.renderWidget;if(b.offsetParent){do{c+=b.offsetLeft;a+=b.offsetTop}while(b=b.offsetParent);return{x:c,y:a}}return undefined};ImageRenderer.prototype.applyPreset=function(c){var a=null;this.imagePromise.then(function(e){a=e});var b=this.presentationState;b.currentPreset=c;switch(parseInt(c)){case 1:b.setWindowingdata(a.windowCenter,a.windowWidth);b.lookupObj.setInvertData(a.invert);b.invert=a.invert;this.isPresetDefault=true;b.windowLevel=1;this.renderImage(false);break;case 2:b.setWindowingdata(40,350);b.windowLevel=2;this.renderImage(false);break;case 3:b.setWindowingdata(-600,1500);b.windowLevel=3;this.renderImage(false);break;case 4:b.setWindowingdata(40,80);b.windowLevel=4;this.renderImage(false);break;case 5:b.setWindowingdata(480,2500);b.windowLevel=5;this.renderImage(false);break;case 6:b.setWindowingdata(90,350);b.windowLevel=6;this.renderImage(false);break;case 7:if(c.length>1){var d=c.split("_");b.setWindowingdata(parseInt(d[1]),parseInt(d[2]));b.windowLevel=7;this.renderImage(false);break}}if(b!==undefined){a.presentation.setPresetWindowLevelValue(b.windowLevel)}};ImageRenderer.prototype.revert=function(c,h){isCopyAttribute=false;var m=dicomViewer.getActiveSeriesLayout();var d=m.getImageType();this.seriesIndex=h;this.anUIDs=c;var l=c.split("*");this.imageUid=l[0];var a=l[1];var g=dicomViewer.measurement.isTraceMeasurementEnd();var o=dicomViewer.measurement.isVolumeMeasurementEnd();var n=dicomViewer.measurement.isAngleMeasurementEnd();if(n){var f=dicomViewer.measurement.getAngleMeasurements(this.imageUid,a);if(f!==undefined){delete f[f.length-1];dicomViewer.measurement.removeTempdata();dicomViewer.measurement.setAngleMeasurementEnd(false)}}if(g){var e=dicomViewer.measurement.getTraceMeasurements(this.imageUid,a);if(e!==undefined){delete e[e.length-1];dicomViewer.measurement.removeTempdata();dicomViewer.measurement.setTraceMeasurementEnd(false)}}if(o){var b=dicomViewer.measurement.getVolumeMeasurements(this.imageUid,a,m.getSeriesLayoutId());if(b!==undefined){delete b[b.length-1];dicomViewer.measurement.setVolumeMeasurementEnd(false);dicomViewer.measurement.removeTempdata()}}var k=dicomViewer.imageCache.getImagePromise(this.imageUid+"_"+a);if(k===undefined){k=dicomViewer.loadAndCacheImage(m.getStudyUid(),this.imageUid,a,h,d)}var j;var p;k.then(function(q){p=q;j=q.presentation});if(j!=undefined){this.scaleValue=j.getZoom()}this.zoomFlag=false;this.applyOrRevertDisplaySettings(undefined,undefined,true,undefined);this.updatePanTransform(true);this.loadImageRenderer(k)};ImageRenderer.prototype.doStartZoomDrag=function(c,b){var a=this.renderWidgetCtx;var d=a.transformedPoint(c,b);return d};ImageRenderer.prototype.applyRGB=function(a){var b=null;var c=this;this.imagePromise.then(function(d){b=d;c.presentationState.setRGBMode(a);dicomViewer.updateImage(c.imageCanvas,b,c.presentationState);c.drawDicomImage()})};ImageRenderer.prototype.doZoom=function(h,b,a){var e=0;var g=null;this.imagePromise.then(function(m){g=m});if(h>0){e=parseFloat(this.scaleValue)+0.1}else{e=parseFloat(this.scaleValue)-0.1}if(e>8&&this.scaleValue<8){e=8}else{if(e<0.05&&this.scaleValue>0.05){e=0.05}}var c=parseFloat(e/this.scaleValue).toFixed(3);if((e>=0.05||h>0)&&(e<=8||h<0)){var j=this.renderWidgetCtx;var f=j.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);j.translate(f.x,f.y);j.translate(0,0);j.scale(c,c);j.translate(0,0);var l=j.transformedPoint(b,a);var k=j.transformedPoint(this.renderWidget.width,this.renderWidget.height);var f=j.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);var d=j.transformedPoint(0,0);this.zoomFlag=true;this.scaleValue=parseFloat(this.scaleValue*c).toFixed(3);g.presentation.setPresentationMode("MAGNIFY");g.presentation.setZoom(this.scaleValue);g.presentation.setZoomLevel(-1);if(this.presentationState!==undefined){this.presentationState.zoomLevel=-1;this.applyOrRevertDisplaySettings(g.presentation,undefined,undefined,true)}if(isCopyAttribute!==true){this.renderImage(false)}}};ImageRenderer.prototype.doZoomDrag=function(f,b,a){var g=0;var h=this.renderWidgetCtx;var j=h.transformedPoint(b,a);var d=0;if(f.y===j.y){return}if(f.y>j.y){g=2;d=parseFloat(this.scaleValue)+0.1}if(f.y<j.y){g=-2;d=parseFloat(this.scaleValue)-0.1}var c=parseFloat(d/this.scaleValue).toFixed(2);if((d>0.05||g>0)&&(d<8||g<0)){var h=this.renderWidgetCtx;var j=h.transformedPoint(b,a);var e=h.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);h.translate(e.x,e.y);h.translate(0,0);h.scale(c,c);h.translate(0,0);this.zoomFlag=true;this.scaleValue=parseFloat(this.scaleValue*c).toFixed(2);this.renderImage(false)}};ImageRenderer.prototype.doDragPan=function(l,b,a){var m=this.renderWidgetCtx;var k=null;this.imagePromise.then(function(p){k=p});var c=this.presentationState;var o=m.transformedPoint(this.renderWidget.width,this.renderWidget.height);var h=m.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);var g=m.transformedPoint(0,0);var f=0;var e=0;var n=k.rows;var d=k.columns;var j=n/d;if(j==1){if(l.x>1&&((g.x-l.x)+this.renderWidget.width/2>0)&&((g.x-l.x)+this.renderWidget.height/2>0)){f=l.x}if(l.x<1&&((o.x-l.x)-this.renderWidget.width/2<0)&&((o.x-l.x)-this.renderWidget.height/2<0)){f=l.x}if(l.y>1&&((g.y-l.y)+this.renderWidget.height/2>0)&&((g.y-l.y)+this.renderWidget.width/2>0)){e=l.y}if(l.y<1&&((o.y-l.y)-this.renderWidget.height/2<0)&&((o.y-l.y)-this.renderWidget.width/2<0)){e=l.y}}else{if(l.x>1&&(g.x+this.renderWidget.width/2>0)&&((g.x*j)+this.renderWidget.height/2>0)){f=l.x}if(l.x<1&&(o.x-this.renderWidget.width/2<0)&&((o.x*j)-this.renderWidget.height/2<0)){f=l.x}j=d/n;if(l.y>1&&(g.y+this.renderWidget.height/2>0)&&((g.y*j)+this.renderWidget.width/2>0)){e=l.y}if(l.y<1&&(o.y-this.renderWidget.height/2<0)&&((o.y*j)-this.renderWidget.width/2<0)){e=l.y}if(l.x>20||l.y>20){f=0;e=0}if(l.x<-20||l.y<-20){f=0;e=0}}if(f!==0||e!==0){m.translate(f,e);this.renderImage(false)}this.updatePanTransform()};ImageRenderer.prototype.rotate=function(f){var a=null;this.imagePromise.then(function(g){a=g});var c=this.presentationState;this.presentationState.setIsRotationChange(true);var e=f+c.getRotation();c.setRotation(e);this.presentationState.setWindowingdata(c.windowCenter,c.windowWidth);this.renderImage(false);var d=$("#"+this.parentElement).parent().closest("div").attr("id");var b=dicomViewer.getimageCanvasOfViewPort(d);b.presentation.setRotation(e);this.presentationState.setIsRotationChange(false);if(this.presentationState!==undefined){this.applyOrRevertDisplaySettings(a.presentation,undefined,undefined,true)}};ImageRenderer.prototype.invert=function(){var a=null;var c;var b=this;this.imagePromise.then(function(e){var d=!b.presentationState.getInvertFlag();a=e;b.presentationState.setInvertFlag(d);dicomViewer.updateImage(b.imageCanvas,a,b.presentationState);b.drawDicomImage()});this.renderImage(false)};ImageRenderer.prototype.applySharpen=function(c){var a=null;var d;var b=this;this.imagePromise.then(function(e){a=e;b.presentationState.setSharpen(c);dicomViewer.updateImage(b.imageCanvas,a,b.presentationState);b.drawDicomImage()});this.renderImage(false)};ImageRenderer.prototype.showOrHideOverlay=function(b){var a=this.overlayCanvas.getContext("2d");if(!b){a.clearRect(0,0,this.viewportWidth-5,this.viewportHeight-5)}else{this.applyOverLay()}};ImageRenderer.prototype.doHorizontalFlip=function(){var a=null;this.imagePromise.then(function(c){a=c});var b=this.presentationState;b.setHorizontalFilp(!b.getHorizontalFilp());this.renderImage(false);if(this.presentationState!==undefined){this.applyOrRevertDisplaySettings(a.presentation,undefined,undefined,true)}};ImageRenderer.prototype.doVerticalFilp=function(){var a=null;this.imagePromise.then(function(c){a=c});var b=this.presentationState;b.setVerticalFilp(!b.getVerticalFilp());this.renderImage(false);if(this.presentationState!==undefined){this.applyOrRevertDisplaySettings(a.presentation,undefined,undefined,true)}};ImageRenderer.prototype.setZoomLevel=function(b){var t=dicomViewer.getActiveSeriesLayout();if(t.getImageType()==IMAGETYPE_RADECG){var g=1;var q=t.getSeriesLayoutId();var s="imageEcgCanvas"+q;var l=document.getElementById(s);if(l==null||l==undefined){return}var c="imageEcgDiv"+q;var m=document.getElementById(c);var k=document.getElementById("imageEcgHidden"+q);var w=k.value;var e=l.getContext("2d");e.clearRect(0,0,l.width,l.height);var h=new Image();h.src=w;var x=this;var u={};h.onload=function(){x.ecgScalepreset=b;switch(b){case 0:g=1;break;case 1:g=Math.min((m.offsetHeight-4)/h.height,m.offsetWidth/h.width);break;case 2:g=m.offsetWidth/h.width;break;case 3:g=m.offsetHeight/h.height;break}applyECGZoom(g,e,x,l,h)};if(parseInt(b)==6){if(b.length>1){u=b.split("-");var u=b.split("-");g=(parseInt(u[1])/100);applyECGZoom(g,e,x,l,h)}}}else{if(t.getImageType()==IMAGETYPE_RADPDF){}else{if(!this.imagePromise){var r=t.scrollData.frameIndex;var a=t.imageType;imagePromise=dicomViewer.loadImageFromImageLoader(t.studyUid,this.imageUid,r,a);this.imagePromise=imagePromise}this.imagePromise.then(function(y){imageCanvas=y});var o=this.presentationState;if(!o){o=imageCanvas.presentation}var p=imageCanvas.dicominfo;var n=p.getRows();var f=p.getColumns();var d=this.scaleValue;var u={};switch(parseInt(b)){case 0:u[0]="0_zoom";this.scaleValue=this.getZoomFactor(0,n,f);o.fitToWindow=false;o.zoomLevel=0;break;case 1:this.scaleValue=this.getZoomFactor(1,n,f);o.fitToWindow=false;o.zoomLevel=1;break;case 2:this.scaleValue=this.getZoomFactor(2,n,f);o.fitToWindow=false;o.zoomLevel=2;break;case 3:this.scaleValue=this.getZoomFactor(3,n,f);o.fitToWindow=false;o.zoomLevel=3;break;case 6:if(b.length>1){u=b.split("-");var u=b.split("-");this.scaleValue=(parseInt(u[1])/100);o.fitToWindow=false;o.zoomLevel=-1}}var v=this.renderWidgetCtx;v.clearRect(-this.renderWidget.width*2,-this.renderWidget.height*2,this.renderWidget.width*4,this.renderWidget.height*4);var j=v.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);v.translate(j.x,j.y);v.translate(0,0);v.scale(this.scaleValue/d,this.scaleValue/d);v.translate(0,0);this.zoomFlag=true;if(u[0]=="0_zoom"||u[0]=="6_zoom"){imageCanvas.presentation.setPresentationMode("MAGNIFY");imageCanvas.presentation.setZoom(this.scaleValue)}else{imageCanvas.presentation.setPresentationMode("SCALE_TO_FIT");imageCanvas.presentation.setZoom(this.scaleValue)}if(o!==undefined){imageCanvas.presentation.setZoomLevel(o.zoomLevel);this.applyOrRevertDisplaySettings(imageCanvas.presentation,undefined,undefined,true)}if(isCopyAttribute!==true){this.renderImage(false)}}}};function applyECGZoom(g,b,d,c,e){if(g>1){g=Math.max(1,g-0.05)}c.width=e.width*g;c.height=e.height*g;g=g.toFixed(2);g=Math.abs(g);d.tScaleValue=g;d.tempEcgScale=g;b.scale(g,g);b.drawImage(e,0,0);if(c.width!==0&&c.height!==0){var f=b.getImageData(0,0,c.width,c.height);var a=dicomViewer.getActiveSeriesLayout();a.setEcgCanvas(f);dicomViewer.loadCaliper()}}ImageRenderer.prototype.updateXRefLine=function(a,b){dicomViewer.refLine.updateXRefLine(this,a,b)};ImageRenderer.prototype.renderImage=function(a,e){var h=$("#"+this.parentElement).parent().closest("div").attr("id");if(h!=undefined){var n=dicomViewer.viewports.getViewport(h);if(n!=undefined){var t=n.getStudyUid();var d=dicomViewer.getStudyDetails(t);var r=getStudyLayoutId(h);var g="studyInfo"+r;var s=undefined;if(isFullScreenEnabled){var v=dicomViewer.getActiveSeriesLayout();var w=v.getSeriesLayoutId();var b=dicomViewer.getActiveSeriesLayout();s=b.getImageRender(w+"ImageLevel0x0")}else{if(n!=undefined){s=n.getImageRender(h+"ImageLevel0x0")}}if(d===undefined){return}if(d.procedure===null||d.procedure===undefined||d.procedure===""||d.procedure.length===0){$("#"+g).html("&nbsp")}else{$("#"+g).html(d.procedure)}var p="";var o="";if(d.dateTime!==null&&d.dateTime!==undefined){p=d.dateTime.replace("T","@")}if(d.dicomStudyId!==null&&d.dicomStudyId!==undefined){o=d.dicomStudyId}if(p!==""||o!==""){var q=(o!==""?o+", "+p:p);$("#studyUidDateTime"+r).html(q)}}if(h==="imageviewer_studyViewer1x1_1x1"&&isFullScreenEnabled===false){seriesIndexBackup=this.seriesIndex}}var l=null;if(this.imagePromise==undefined){return}this.imagePromise.then(function(z){l=z});if(isCopyAttribute){var k=dicomViewer.configuration.cine.getCopyAttributes();if(k.windowLevel&&d.modality!=="US"){l.presentation.setWindowingdata(copyAttributePresentaion.presentationState.windowCenter,copyAttributePresentaion.presentationState.windowWidth)}if(k.invert&&d.modality!=="US"){l.presentation.setInvertFlag(copyAttributePresentaion.presentationState.getInvertFlag())}if(k.scale){this.setZoomLevel("6_zoom-"+parseFloat(copyAttributePresentaion.scaleValue)*100)}if(k.orientation){l.presentation.setOrientation(copyAttributePresentaion.presentationState.getOrientation())}}if(l!==undefined&&l!==null){var m=$("#"+this.parentElement).parent().closest("div").attr("id");var x=dicomViewer.getimageCanvasOfViewPort(m);if(x==undefined||x==null||x.imageUid!=l.imageUid){l.imageIndex=this.imageIndex;l.seriesIndex=this.seriesIndex;dicomViewer.setimageCanvasOfViewPort(m,l)}var y=this.presentationState;var j=l.dicominfo;var f=j.getRows();var c=j.getColumns();if(s!=undefined){if(s.presentationState!==undefined&&s.presentationState!==null){if(s.presentationState.invert!=this.presentationState.lookupObj.invert){this.presentationState.setInvertFlag(s.presentationState.invert)}}}if(this.presentationState.getWindowCenter()===undefined||this.presentationState.getWindowWidth()===undefined){var u={min:0,max:0};y.setWindowingdata(j.getWindowCenter(),j.getWindowWidth());y.setWindowLevel(j,u,this.invert)}if(y.windowCenter!=l.windowCenter||y.windowWidth!=l.windowWidth||this.isPresetDefault){this.isPresetDefault=false}logger.startTime("dicomViewer.updateImage");if((j.imageInfo.numberOfFrames>1&&j.imageInfo.modality==="US")||j.imageInfo.imageType===IMAGETYPE_JPEG){this.imageCanvas=l.imageData}else{dicomViewer.updateImage(this.imageCanvas,l,this.presentationState)}logger.endTime("dicomViewer.updateImage");this.presentationState=y;this.headerInfo=j;logger.startTime("Draw Dicom Image");this.drawDicomImage(false,e);logger.endTime("Draw Dicom Image")}};ImageRenderer.prototype.drawDicomImage=function(v,e,t,l){if(t==true&&!dicomViewer.tools.isShowAnnotationandMeasurement()){dicomViewer.tools.doShowHideAnnotationAndMeasurement();return}if(this.presentationState==null){return}var u=this.presentationState;var h=this.headerInfo;var s=this.renderWidgetCtx;s.clearRect(-this.renderWidget.width*6,-this.renderWidget.height*6,this.renderWidget.width*12,this.renderWidget.height*12);var a=u.getZoom();if(this.scaleValue==undefined){this.scaleValue=a}var o=u.getPan();if(u.fitToWindow){if(u.getRotation()==90||u.getRotation()==270){a=Math.min(this.renderWidget.height/column,this.renderWidget.width/row);u.setZoom(a)}else{a=Math.min(this.renderWidget.height/row,this.renderWidget.width/column);u.setZoom(a)}}s.save();var c=u.getOrientation();if(isCopyAttribute!==true){if(u.isRotation&&this.presentationState.getIsRotationChange()){c=orientationDefaults[c].rotateRight}else{if(u.vFlip){c=orientationDefaults[c].flipVert}else{if(u.hFlip){c=orientationDefaults[c].flipHorz}}}}u.setRotation(angleDefaults[orientationDefaults[c].rotate]);if(orientationDefaults[c].mirror===1){if(c===4||c===6){u.setVerticalFilp(false);u.setHorizontalFilp(true)}else{if(c===5||c===7){u.setVerticalFilp(true);u.setHorizontalFilp(false)}}}else{u.setVerticalFilp(false);u.setHorizontalFilp(false)}u.setOrientation(c);u.updateRotateAndFlip();var k=$("#"+this.parentElement).parent().closest("div").attr("id");var r=dicomViewer.getimageCanvasOfViewPort(k);if(r!=undefined){r.presentation.setOrientation(c)}isRGBToolEnabled=r?r.isRGBToolEnabled:false;s.rotate(u.getRotation()*Math.PI/180);if(u.isFlipHoriRequired()){s.scale(-a,a)}else{s.scale(a,a)}if(h!=undefined&&h.imageInfo.numberOfFrames>1){s.drawImage(this.imageCanvas,o.x,o.y)}else{s.drawImage(this.imageCanvas,o.x,o.y)}var m=this.anUIDs.split("*");var x=m[0],j=m[1];dicomViewer.directionalMarker.initDirectionalMarker(h);dicomViewer.directionalMarker.rotateDirectionalMarker(u);var f=dicomViewer.mouseTools.getToolName();if(dicomViewer.tools.isShowAnnotationandMeasurement()||t==true||l==true){if((f=="lineMeasurement")||(f=="pointMeasurement")||(f=="traceMeasurement")||(f=="volumeMeasurement")||(f=="mitralMeanGradientMeasurement")||(f=="angleMeasurement")||(f=="ellipseMeasurement")||(f=="rectangleMeasurement")||(f=="pen")){dicomViewer.draw.usRegion.drawUSRegions(s,h,u)}if(e===undefined||e==true){dicomViewer.measurement.draw.drawMeasurements(x,j,s,u,this)}}u.setHorizontalFilp(false);u.setVerticalFilp(false);if(v===undefined||v){var q=dicomViewer.getActiveSeriesLayout();var d=q.getAllImageRenders();var w;var n=false;for(var w in d){if(this==d[w]){n=true}}if(n==false){this.updateXRefLine(s,u)}}s.restore();if(dicomViewer.tools.isOverlayVisible()){this.applyOverLay()}else{var p=this.overlayCanvas.getContext("2d");p.clearRect(0,0,this.viewportWidth-5,this.viewportHeight-5)}s.save();var b=$("#"+this.parentElement).parent().closest("div").attr("id");if(b){var g=dicomViewer.progress.getSpinner(b);if(g!==undefined){g.stop();if(h&&h.imageInfo){h.imageInfo.isColor?disableOrEnableRGBTools():"";if(h!=undefined&&(h.imageInfo.modality==="US"||h.imageInfo.modality==="XA")&&h.imageInfo.numberOfFrames>1&&dicomViewer.tools.firstTimeImageLoad()){if(!dicomViewer.scroll.isCineRunning(b)){dicomViewer.scroll.toggleCineRunning();$("#viewport_View").css("cursor","default")}}}}}};ImageRenderer.prototype.applyOverLay=function(){var LayerCtx=this.overlayCanvas.getContext("2d");LayerCtx.clearRect(0,0,this.viewportWidth-5,this.viewportHeight-5);var imageCanvas=null;if(this.imagePromise===undefined){return}var render=this;this.imagePromise.done(function(image){imageCanvas=image;var displayFrameNumber=0;var totalNumberofFrame=1;var presentation=render.presentationState;if(presentation!=null){dicominfo=render.headerInfo;if(dicominfo!=null&&dicominfo!=undefined){if(dicominfo.imageInfo.numberOfFrames>1){displayFrameNumber=eval(imageCanvas.frameNumber)+1;totalNumberofFrame=dicominfo.imageInfo.numberOfFrames}if(dicomViewer.tools.isOverlayVisible()){var overlayConfig=null;if(dicominfo.imageInfo.imageType!==IMAGETYPE_JPEG){overlayConfig=dicomViewer.overlay.getOverlayConfig();var bottomLeftOverLayConfig=dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.bottomleft,dicominfo)}else{overlayConfig=["Scale"];var bottomLeftOverLayConfig=dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig,dicominfo)}var topLefOverLayConfig=dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.topleft,dicominfo);var topRightOverLayConfig=dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.topRight,dicominfo);var bottomRigthOverLayConfig=dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.bottomRight,dicominfo);LayerCtx.fillStyle="yellow";LayerCtx.font="11pt Helvetica";var windowLevelTxt="WW: "+Math.round(presentation.getWindowWidth())+", WC: "+Math.round(presentation.getWindowCenter());var scaleText="Zoom: "+Math.round(render.scaleValue*100)+"%";var seriesDesc=dicomViewer.Series.getSeriesDescription(dicomViewer.getActiveSeriesLayout().getStudyUid(),render.seriesIndex);generatDicomOverlay(topLefOverLayConfig,"topLeft",LayerCtx,windowLevelTxt,scaleText);generatDicomOverlay(bottomLeftOverLayConfig,"bottomLeft",LayerCtx,windowLevelTxt,scaleText,render.viewportHeight-5,"",displayFrameNumber,totalNumberofFrame,seriesDesc);generatDicomOverlay(topRightOverLayConfig,"topRight",LayerCtx,windowLevelTxt,scaleText,"",render.viewportWidth-5);generatDicomOverlay(bottomRigthOverLayConfig,"bottomRight",LayerCtx,windowLevelTxt,scaleText,render.viewportHeight-5,render.viewportWidth-5);LayerCtx.fillStyle="black";if(dicominfo.imageInfo.isCompressed||dicominfo.imageInfo.imageType===IMAGETYPE_RADECHO){displayOverLayWarning(LayerCtx,render.overlayCanvas.width,render.overlayCanvas.height)}applyDirectionalmarker(LayerCtx,dicominfo,render.viewportHeight,render.viewportWidth);displayRGBChannelToolTip(render)}}}})};function applyDirectionalmarker(c,e,b,d){var a=dicomViewer.directionalMarker.getDirectionalMarker();if(a!=null){c.fillStyle="yellow";c.font="11pt Helvetica";c.fillText(a.left,20,b/2);c.fillText(a.right,d-c.measureText(a.right).width*2,b/2);c.fillText(a.top,d/2,20);c.fillText(a.bottom,d/2,b-20);c.fillStyle="black"}}function displayRGBChannelToolTip(e){if(e!==undefined&&dicomViewer.tools.isOverlayVisible()){var f="";var c="black";var g=e.headerInfo;var b=false;if(g!==undefined){var a=g.imageInfo;if(a.isColor&&isRGBToolEnabled){b=true}}if(g!==undefined&&b&&e.presentationState.getRGBMode()!==undefined){if(e.presentationState.getRGBMode()===1){f="Red Channel";c="Red";dicomViewer.tools.rgbColor(1,true)}else{if(e.presentationState.getRGBMode()===2){f="Green Channel";c="Green";dicomViewer.tools.rgbColor(2,true)}else{if(e.presentationState.getRGBMode()===3){f="Blue Channel";c="Blue";dicomViewer.tools.rgbColor(3,true)}else{dicomViewer.tools.resetRGBMenu()}}}}if(f!==""){var d=e.overlayCanvas.getContext("2d");d.clearRect(e.overlayCanvas.width-d.measureText(f).width-55,e.overlayCanvas.height-60,d.measureText(f).width+1,60);d.fillStyle=c;d.font="11pt Helvetica";d.fillText(f,e.overlayCanvas.width-d.measureText(f).width,e.overlayCanvas.height-60);d.fillStyle="black"}}}function generatDicomOverlay(p,m,j,g,e,o,b,h,d,c){var a=0;var l=1;for(var f=0;f<p.length;f++){if(m=="topLeft"){var k=p[f];if((k!=undefined)&&k!=""){var n=(l)*2;displayOverlayLeftSide(k,10,n*10,j,g,e);l++}}else{if(m=="bottomLeft"){var k=p[p.length-(f+1)];if(k!=undefined&&k!=""){a=a+1;n=(a)*10;displayOverlayLeftSide(k,10,o-(n),j,g,e);a++}if(f==p.length-1&&d!=1){a=a+1;n=(a)*10;displayOverlayLeftSide("Fr :"+(h)+"/"+d,10,o-(n),j,g,e);a++}if(f==p.length-1){if(c!=undefined&&c!=""){a=a+1;n=(a)*10;displayOverlayLeftSide(c,10,o-(n),j,g,e);a++}}}else{if(m=="topRight"){var k=p[f];if(k!=undefined&&k!=""){var n=(l)*2;displayOverlayRightSide(k,b,n*10,j,g,e);l++}}else{if(m=="bottomRight"){var k=p[p.length-(f+1)];if(k!=undefined&&k!=""){a=a+1;n=(a)*10;displayOverlayRightSide(k,b,o-(n),j,g,e);a++}}}}}}}function displayOverlayLeftSide(e,d,a,b,f,c){if(e==="WCWW"){b.fillText(f,d,a)}else{if(e==="Scale"){b.fillText(c,d,a)}else{b.fillText(e,d,a)}}}function displayOverlayRightSide(c,e,f,a,d,b){if(c==="WCWW"){a.fillText(d,(e-a.measureText(d).width),f)}else{if(c==="Scale"){a.fillText(b,(e-a.measureText(b).width),f)}else{a.fillText(c,e-a.measureText(c).width,f)}}}var warningImageData=undefined;function displayOverLayWarning(c,d,a){if(warningImageData===undefined){var b=new Image();b.src="images/alert.bmp";b.onload=function(){c.drawImage(b,d-50,a-40);warningImageData=c.getImageData(d-50,a-50,d,a)}}else{c.putImageData(warningImageData,d-50,a-50)}}function displayCompressinToolTip(a,c){if(c!==undefined&&dicomViewer.tools.isOverlayVisible()){var e="";var h=c.headerInfo;if(h!==undefined&&h.imageInfo.isCompressed){if(h.imageInfo.imageType===IMAGETYPE_RADECHO){e="Jpeg compressed image"}else{if(h.imageInfo.compressionMethod!==undefined&&h.imageInfo.compressionMethod!==""){e=h.imageInfo.compressionMethod}}}if(e!==""){var g=c.getRenderWidget();var f=a.offsetX||(a.pageX-g.offsetLeft);var d=a.offsetY||(a.pageY-g.offsetTop);if(f>(c.overlayCanvas.width-50)&&d>(c.overlayCanvas.height-50)&&f<(c.overlayCanvas.width-5)&&d<(c.overlayCanvas.height-5)){var b=c.overlayCanvas.getContext("2d");b.clearRect(c.overlayCanvas.width-b.measureText(e).width-55,c.overlayCanvas.height-20,b.measureText(e).width+1,20);b.fillStyle="white";b.font="11pt Helvetica";b.fillText(e,c.overlayCanvas.width-b.measureText(e).width-55,c.overlayCanvas.height-5);b.fillStyle="black"}else{var b=c.overlayCanvas.getContext("2d");b.clearRect(c.overlayCanvas.width-b.measureText(e).width-55,c.overlayCanvas.height-20,b.measureText(e).width+1,20)}}}}function doubleClick(){var d=dicomViewer.mouseTools.getToolName();if(d!=="traceMeasurement"&&d!=="volumeMeasurement"&&d!=="mitralMeanGradientMeasurement"&&d!=="pointMeasurement"&&d!=="lineMeasurement"&&d!=="angleMeasurement"&&d!=="ellipseMeasurement"&&d!=="rectangleMeasurement"){var s=dicomViewer.getActiveSeriesLayout();var x=s.getSeriesLayoutId();var B=dicomViewer.getCurrentSeriesLayoutIds();var p=dicomViewer.viewports.getSeriesLayoutMaxId();var a=dicomViewer.getActiveSeriesLayout();var t=getStudyLayoutId(B);var y="imageviewer_"+t+"_1x1";if(p!==y&&studyLayoutValue==="1x1"){if(B===y){isFullScreenEnabled=false;p=p.replace("imageviewer_"+t+"_","");var f=p.charAt(0);var c=p.charAt(p.length-1);var e=a.seriesIndex;var k=false;if(dicomViewer.scroll.isCineRunning(s.getSeriesLayoutId())){e=dicomViewer.tools.getOrSetReArrangedSeriesPositions(parseInt(f),parseInt(c),true);k=true}dicomViewer.setSeriesLayout(a.getStudyUid(),f,c,e,false,getStudyLayoutId(x));dicomViewer.setReArrangedSeriesPositions(undefined);var l=dicomViewer.getActiveSeriesLayout();if(l!=undefined&&l!=null){if(dicomViewer.scroll.isCineRunning(l.getSeriesLayoutId())){updatePlayIcon("play.png","stop.png")}}}else{previousLayoutSelection=x;isFullScreenEnabled=true;dicomViewer.setSeriesLayout(a.getStudyUid(),1,1,a.seriesIndex,true,getStudyLayoutId(x))}}else{if(studyLayoutValue!=="1x1"&&!isFullScreenEnabled){previousLayoutSelection=x;isFullScreenEnabled=true;dicomViewer.setStudyLayout(1,1,a.getStudyUid(),a.seriesIndex,true)}else{if(isFullScreenEnabled){isFullScreenEnabled=false;var A=studyLayoutValue.split("x");var o=A[0];var m=A[1];var n={id:studyLayoutValue};var w=layoutMap;dicomViewer.tools.changeStudyLayoutFromTool(n,isFullScreenEnabled,false);layoutMap=w;for(var r=1;r<=o;r++){for(var q=1;q<=m;q++){var z="studyViewer"+r+"x"+q;var g=layoutMap[z];if(g==undefined){g="1x1"}var u=g.split("x");dicomViewer.tools.chanageWhileDrag(u[0],u[1],z);var h="imageviewer_"+z+"_1x1";var v=dicomViewer.viewports.getViewport(h);if(v!=null&&v!=undefined){if(v.studyUid!=undefined){document.getElementById(z+"_close").style.visibility="visible"}}}}dicomViewer.playRepeatCineManager();dicomViewer.changeSelection(previousLayoutSelection)}}}}if(d==="mitralMeanGradientMeasurement"||d==="traceMeasurement"||d==="lineMeasurement"||d==="pointMeasurement"||d==="ellipseMeasurement"||d==="rectangleMeasurement"||d==="angleMeasurement"){var b=dicomViewer.mouseTools.getActiveTool();b.hanleDoubleClick()}isCineEnabled(false)}ImageRenderer.prototype.getPresentation=function(){return this.presentationState};ImageRenderer.prototype.getRenderWidget=function(){return this.renderWidget};ImageRenderer.prototype.getZoomLevel=function(){return this.tScaleValue};ImageRenderer.prototype.updateSeriesIndex=function(){seriesIndex=this.seriesIndex};ImageRenderer.prototype.getSeriesIndex=function(){return this.seriesIndex};ImageRenderer.prototype.getImageUid=function(){return this.imageUid};ImageRenderer.prototype.getCurrentUIDs=function(){return this.anUIDs};ImageRenderer.prototype.applyOrRevertDisplaySettings=function(d,k,j,h){try{if(k===true){d.orientation=0;d.isRotation=false;d.rotation=0;d.hFlip=false;d.vFlip=false;d.zoom=1;d.presentationMode="SCALE_TO_FIT";d.zoomLevel=1;d.rgbMode=0}var a=dicomViewer.getActiveSeriesLayout();if(a!==undefined&&a.studyUid!==undefined){var c=dicomViewer.Series.Image.getImage(a.studyUid,this.seriesIndex,this.imageIndex);if(c===undefined||c.isImageThumbnail===undefined||c.isImageThumbnail===false){c=dicomViewer.Series.getSeries(a.studyUid,this.seriesIndex)}if(c!==undefined&&c.displaySettings!==undefined){var g=c.displaySettings;if(c.isDisplaySettingsApplied===false){c.isDisplaySettingsApplied=true;if(g.IsECG===true){this.ecgScalepreset=g.ZoomLevel}else{if(d!==undefined){d.presentationMode="SCALE_TO_FIT";d.zoomLevel=g.ZoomLevel;g.presentation=jQuery.extend(true,{},d)}}}else{if(c.isDisplaySettingsApplied===true&&j===true){c.isDisplaySettingsApplied=false}else{if(c.isDisplaySettingsApplied===true&&d!==undefined){d.presentationMode="SCALE_TO_FIT";if(c.isImageThumbnail===true){if(h===true){g.presentation=jQuery.extend(true,{},d)}else{var m=g.presentation;if(m!==undefined){var l=null;this.imagePromise.then(function(e){l=e});l.presentation.zoom=m.zoom;l.presentation.zoomLevel=m.zoomLevel;l.presentation.rotation=m.rotation;l.presentation.isRotation=m.isRotation;l.presentation.orientation=m.orientation;l.presentation.isFlipHorizontalRequired=m.isFlipHorizontalRequired;l.presentation.vFlip=m.vFlip;l.presentation.hFlip=m.hFlip;d.zoom=m.zoom;d.zoomLevel=m.zoomLevel;d.rotation=m.rotation;d.isRotation=m.isRotation;d.orientation=m.orientation;d.isFlipHorizontalRequired=m.isFlipHorizontalRequired;d.vFlip=m.vFlip;d.hFlip=m.hFlip}}}}else{if(c.isDisplaySettingsApplied===true&&g.IsECG===true){var b=a.preferenceInfo;if(h===true&&b!==undefined){g.EcgPreference=jQuery.extend(true,{},b.preferenceData);g.SelectedEcgPreference=jQuery.extend(true,{},b.selectedEcgFormat);g.isCaliperEnable=a.isCaliperEnable}else{if(b!==undefined){if(g.EcgPreference!==undefined&&g.SelectedEcgPreference!==undefined){b.selectedEcgFormat=jQuery.extend(true,{},g.SelectedEcgPreference);b.preferenceData=jQuery.extend(true,{},g.EcgPreference);a.isCaliperEnable=g.isCaliperEnable}}}}else{}}}}}}}catch(f){}};ImageRenderer.prototype.getZoomFactor=function(g,f,b){try{var c=undefined;var a=5;switch(g){case 0:c=1;break;case 1:c=Math.min(this.renderWidget.height/f,this.renderWidget.width/b);break;case 2:c=(this.renderWidget.width/b);break;case 3:c=(this.renderWidget.height/f);break;default:c=Math.min(this.renderWidget.height/f,this.renderWidget.width/b);break}if(c*100-5<0){c=a/100}return c}catch(d){}};ImageRenderer.prototype.doClickDefaultTool=function(){var b=dicomViewer.getActiveSeriesLayout();var a=dicomViewer.Series.getModality(b.getStudyUid(),b.getSeriesIndex());dicomViewer.setDefaultCursorType(a,b)};ImageRenderer.prototype.preparePrint=function(b){try{var j=document.createElement("canvas");var d=this.scaleValue;this.scaleValue=1;if(b==1){this.scaleValue=d}j.width=this.imageCanvas.width*parseFloat(this.scaleValue);j.height=this.imageCanvas.height*parseFloat(this.scaleValue);var f=j.getContext("2d");f.clearRect(0,0,j.width,j.height);f.save();f.translate(j.width/2,j.height/2);f.rotate(this.presentationState.getRotation()*Math.PI/180);if(this.presentationState.isFlipHorizontalRequired){f.scale(-this.scaleValue,this.scaleValue)}else{f.scale(this.scaleValue,this.scaleValue)}f.drawImage(this.imageCanvas,-this.imageCanvas.width/2,-this.imageCanvas.height/2);this.isPrint=true;var a=this.anUIDs.split("*");var c=a[0];var h=a[1];this.scaleValue=((parseFloat(this.scaleValue)<=1.5))?parseFloat(this.scaleValue):1.5;if(dicomViewer.tools.isShowAnnotationandMeasurement()){dicomViewer.measurement.draw.drawMeasurements(c,h,f,this.presentationState,this)}f.restore();this.scaleValue=d;this.isPrint=undefined;return j.toDataURL("image/jpeg",1)}catch(g){}};function trackTransforms(l){var f=document.createElementNS("http://www.w3.org/2000/svg","svg");var j=f.createSVGMatrix();l.getTransform=function(){return j};var k=[];var g=l.save;l.save=function(){k.push(j.translate(0,0));return g.call(l)};var h=l.restore;l.restore=function(){j=k.pop();return h.call(l)};var c=l.scale;l.scale=function(o,n){o=parseFloat(o);n=parseFloat(n);j=j.scaleNonUniform(o,n);j.a=parseFloat(j.a);j.b=parseFloat(j.b);j.c=parseFloat(j.c);j.d=parseFloat(j.d);j.e=parseFloat(j.e);j.f=parseFloat(j.f);return c.call(l,o,n)};var d=l.rotate;l.rotate=function(n){j=j.rotate(n*180/Math.PI);j.a=parseFloat(j.a);j.b=parseFloat(j.b);j.c=parseFloat(j.c);j.d=parseFloat(j.d);j.e=parseFloat(j.e);j.f=parseFloat(j.f);return d.call(l,n)};var b=l.translate;l.translate=function(o,n){o=parseFloat(o);n=parseFloat(n);j=j.translate(o,n);j.a=parseFloat(j.a);j.b=parseFloat(j.b);j.c=parseFloat(j.c);j.d=parseFloat(j.d);j.e=parseFloat(j.e);j.f=parseFloat(j.f);return b.call(l,o,n)};var a=l.transform;l.transform=function(o,n,t,s,r,q){var p=f.createSVGMatrix();o=parseFloat(o);n=parseFloat(n);t=parseFloat(t);s=parseFloat(s);r=parseFloat(r);q=parseFloat(q);p.a=o;p.b=n;p.c=t;p.d=s;p.e=r;p.f=q;j=j.multiply(p);j.a=parseFloat(j.a);j.b=parseFloat(j.b);j.c=parseFloat(j.c);j.d=parseFloat(j.d);j.e=parseFloat(j.e);j.f=parseFloat(j.f);return a.call(l,o,n,t,s,r,q)};var e=l.setTransform;l.setTransform=function(o,n,s,r,q,p){j.a=parseFloat(o);j.b=parseFloat(n);j.c=parseFloat(s);j.d=parseFloat(r);j.e=parseFloat(q);j.f=parseFloat(p);return e.call(l,o,n,s,r,q,p)};var m=f.createSVGPoint();l.transformedPoint=function(n,o){n=parseFloat(n);o=parseFloat(o);m.x=n;m.y=o;return m.matrixTransform(j.inverse())};var m=f.createSVGPoint();l.mousePoint=function(n,o){n=parseFloat(n);o=parseFloat(o);m.x=n;m.y=o;return m.matrixTransform(j)}}function getNavigation(c,b){var d=c.ptX-b.clientX;var a=c.ptY-b.clientY;if(Math.abs(d)>Math.abs(a)){if(d>0){return{moveToNext:true,xDiff:d,yDiff:undefined,frameIndex:c.frameIndex,imageIndex:c.imageIndex}}else{return{moveToNext:false,xDiff:Math.abs(d),yDiff:undefined,frameIndex:c.frameIndex,imageIndex:c.imageIndex}}}else{if(a>0){return{moveToNext:true,xDiff:undefined,yDiff:a,frameIndex:c.frameIndex,imageIndex:c.imageIndex}}else{return{moveToNext:false,xDiff:undefined,yDiff:Math.abs(a),frameIndex:c.frameIndex,imageIndex:c.imageIndex}}}return undefined}ImageRenderer.prototype.PrepareECGPrint=function(g){try{var a=dicomViewer.getActiveSeriesLayout();var d=1;if(g==1){d=parseFloat(this.tempEcgScale)}var h=a.getSeriesLayoutId();var k="imageEcgCanvas"+h;var f=document.getElementById(k);var b=document.createElement("canvas");b.width=this.ecgData.width*d;b.height=this.ecgData.height*d;var j=b.getContext("2d");j.clearRect(0,0,b.width,b.height);j.fillStyle="white";j.fillRect(0,0,b.width,b.height);j.save();j.scale(d,d);j.drawImage(this.ecgData.imageObject,0,0);if(dicomViewer.isShowcaliper(this.imageUid)){dicomViewer.printCaliper(j,this.imageUid)}j.restore();return b.toDataURL("image/jpeg",1)}catch(c){}};ImageRenderer.prototype.updatePanTransform=function(a){try{if(!this.imagePromise){return}var c=null;this.imagePromise.then(function(e){c=e});if(!c){return}if(a){c.lastAppliedPan=undefined;return}c.lastAppliedPan=this.renderWidgetCtx.getTransform();if(dumpInConsole){var b=c.lastAppliedPan;console.log("******** updatePanTransform ********");console.log("A: "+b.a);console.log("B: "+b.b);console.log("C: "+b.c);console.log("D: "+b.d);console.log("E: "+b.e);console.log("F: "+b.f);console.log("***************************")}}catch(d){}};ImageRenderer.prototype.applyPan=function(){try{if(!this.imagePromise){return}var c=null;this.imagePromise.then(function(e){c=e});if(!c){return}var d=c.lastAppliedPan;if(d){var a=this.renderWidgetCtx;var b=a.getTransform();a.setTransform(b.a,b.b,b.c,b.d,d.e,d.f);this.renderImage(false);this.updatePanTransform()}}catch(f){}};function PreferenceInfo(){this.selectedEcgFormat={};this.windowLevelSettings=1;this.zoomLevelSetting="1_zoom";this.preferenceData={gridType:"onemm",gridColor:"redGrid",leadFormat:"threebyfour",signalThickness:"onethickness",gain:"tenmmgain"}}PreferenceInfo.prototype.init=function(){this.setGridType("onemm");this.setGridColor("redGrid");this.setLeadFormat("threebyfourplusthree");this.setSignalThickness("onethickness");this.setGain("tenmmgain");this.addECGParameters("GridType","1");this.addECGParameters("GridColor","0");this.addECGParameters("SignalThickness","1");this.addECGParameters("Gain","1");this.addECGParameters("DrawType","8")};PreferenceInfo.prototype.setWindowLevelSettings=function(a){this.windowLevelSettings=a};PreferenceInfo.prototype.setZoomLevelSettings=function(a){this.zoomLevelSetting=a};PreferenceInfo.prototype.getZoomLevelSettings=function(a){return this.zoomLevelSetting};PreferenceInfo.prototype.getECGParameters=function(){return this.selectedEcgFormat};PreferenceInfo.prototype.addECGParameters=function(a,b){this.selectedEcgFormat[a]=b};PreferenceInfo.prototype.getGridType=function(){return this.preferenceData.gridType};PreferenceInfo.prototype.setGridType=function(a){this.preferenceData.gridType=a};PreferenceInfo.prototype.getGridColor=function(){return this.preferenceData.gridColor};PreferenceInfo.prototype.setGridColor=function(a){this.preferenceData.gridColor=a};PreferenceInfo.prototype.getLeadFormat=function(){return this.preferenceData.leadFormat};PreferenceInfo.prototype.setLeadFormat=function(a){this.preferenceData.leadFormat=a};PreferenceInfo.prototype.getGain=function(){return this.preferenceData.gain};PreferenceInfo.prototype.setGain=function(a){this.preferenceData.gain=a};PreferenceInfo.prototype.getSignalThickness=function(){return this.preferenceData.signalThickness};PreferenceInfo.prototype.setSignalThickness=function(a){this.preferenceData.signalThickness=a};function Presentation(){this.invert=false;this.windowWidth;this.windowCenter;this.rescaleSlope;this.rescaleIntercept;this.zoom=1;this.sharpen=0;this.zoomLevel=1;this.windowLevel=1;this.panX=0;this.PanY=0;this.rotation=0;this.isRotation=false;this.orientation=0;this.isFlipHorizontalRequired=false;this.presentationMode="SCALE_TO_FIT";this.lookupObj=new LookupTable();this.scaleMultiplier=0.8;this.currentPreset=0;this.minPixel=0;this.maxPixel=0;this.windowLevelLimits;this.vFlip=false;this.hFlip=false;this.fitToWindow=false;this.isRotationChange=false;this.rgbMode=0;this.pan={x:0,y:0}}Presentation.prototype.copy=function(a){a.invert=this.invert;a.windowWidth=this.windowWidth;a.windowCenter=this.windowCenter;a.rescaleSlope=this.rescaleSlope;a.rescaleIntercept=this.rescaleIntercept;a.zoom=this.zoom;a.sharpen=this.sharpen;a.panX=this.panX;a.PanY=this.PanY;a.rotation=this.rotation;a.isRotation=this.isRotation;a.orientation=this.orientation;a.isFlipHorizontalRequired=this.isFlipHorizontalRequired;a.presentationMode=this.presentationMode;a.lookupObj=this.lookupObj;a.scaleMultiplier=this.scaleMultiplier;a.currentPreset=this.currentPrese;a.minPixel=this.minPixel;a.maxPixel=this.maxPixel;a.windowLevelLimits=this.windowLevelLimits;a.vFlip=this.vFlip;a.hFlip=this.hFlip;a.fitToWindow=this.fitToWindow;a.rgbMode=this.rgbMode;a.zoomLevel=this.zoomLevel;a.windowLevel=this.windowLevel};Presentation.prototype.setWindowLevel=function(c,a,b){this.rescaleSlope=c.getRescaleSlope();this.rescaleIntercept=c.getRescaleIntercept();this.minPixel=a.min;this.maxPixel=a.max;this.invert=b;this.lookupObj.setData(this.windowCenter,this.windowWidth,this.rescaleSlope,this.rescaleIntercept,a,b)};Presentation.prototype.setWindowingdata=function(a,b){this.lookupObj.setWindowingdata(a,b);this.windowCenter=a;this.windowWidth=b};Presentation.prototype.setWindowLevelLimits=function(a){this.windowLevelLimits=a};Presentation.prototype.setInvertFlag=function(a){this.invert=a;this.lookupObj.setInvertData(this.invert)};Presentation.prototype.getInvertFlag=function(a){return this.invert};Presentation.prototype.getWindowWidth=function(){return this.windowWidth};Presentation.prototype.getWindowCenter=function(){return this.windowCenter};Presentation.prototype.setZoom=function(a){this.zoom=a};Presentation.prototype.getZoom=function(){return this.zoom};Presentation.prototype.setSharpen=function(a){this.sharpen=a};Presentation.prototype.getSharpen=function(){return this.sharpen};Presentation.prototype.setZoomLevel=function(a){this.zoomLevel=a};Presentation.prototype.setPresetWindowLevelValue=function(a){this.windowLevel=a};Presentation.prototype.getZoomLevel=function(){return this.zoomLevel};Presentation.prototype.setPan=function(a,b){this.pan.x=a;this.pan.y=b};Presentation.prototype.getPan=function(){return this.pan};Presentation.prototype.setRotation=function(a){if(a==360){this.rotation=0}else{this.rotation=a}this.isRotation=true};Presentation.prototype.getRotation=function(){return this.rotation};Presentation.prototype.getlookupTable=function(){return this.lookupObj};Presentation.prototype.isScaleToFitMode=function(){if(this.presentationMode=="SCALE_TO_FIT"){return true}else{return false}};Presentation.prototype.setPresentationMode=function(a){this.presentationMode=a};Presentation.prototype.getPresentationMode=function(){return this.presentationMode};Presentation.prototype.setRGBMode=function(a){this.rgbMode=a};Presentation.prototype.getRGBMode=function(){return this.rgbMode};Presentation.prototype.setVerticalFilp=function(a){this.vFlip=a;this.isRotation=false};Presentation.prototype.getVerticalFilp=function(){return this.vFlip};Presentation.prototype.setHorizontalFilp=function(a){this.hFlip=a;this.isRotation=false};Presentation.prototype.getHorizontalFilp=function(){return this.hFlip};Presentation.prototype.setOrientation=function(a){this.orientation=a};Presentation.prototype.getOrientation=function(){return this.orientation};Presentation.prototype.isFlipHoriRequired=function(){return this.isFlipHorizontalRequired};Presentation.prototype.setIsRotationChange=function(a){this.isRotationChange=a};Presentation.prototype.getIsRotationChange=function(){return this.isRotationChange};Presentation.prototype.updateRotateAndFlip=function(){var a=false;this.isFlipHorizontalRequired=false;if(this.hFlip===true){if(this.rotation===90||this.rotation===270){a=true}}var b=(this.hFlip===false&&this.vFlip===false);var c=(this.hFlip===true&&this.vFlip===true);if((this.rotation==0&&b)||(this.rotation==180&&c)){this.rotation=0;this.isFlipHorizontalRequired=false}else{if((this.rotation==90&&b)||(this.rotation==270&&c)){this.rotation=90;this.isFlipHorizontalRequired=false}else{if((this.rotation==180&&b)||(this.rotation==0&&c)){this.rotation=180;this.isFlipHorizontalRequired=false}else{if((this.rotation==270&&b)||(this.rotation==90&&c)){this.rotation=270;this.isFlipHorizontalRequired=false}else{if((this.rotation==0&&this.hFlip===true)||(this.rotation==180&&this.vFlip===true)){this.rotation=0;this.isFlipHorizontalRequired=true}else{if((this.rotation==90&&this.hFlip===true)||(this.rotation==270&&this.vFlip===true)){if(a){this.rotation=270}else{this.rotation=90}this.isFlipHorizontalRequired=true}else{if((this.rotation==180&&this.hFlip===true)||(this.rotation==0&&this.vFlip===true)){this.rotation=180;this.isFlipHorizontalRequired=true}else{if((this.rotation==270&&this.hFlip===true)||(this.rotation==90&&this.vFlip===true)){if(a){this.rotation=90}else{this.rotation=270}this.isFlipHorizontalRequired=true}}}}}}}}if(this.isFlipHorizontalRequired===true){if(this.rotation===90){this.rotation=270}else{if(this.rotation===270){this.rotation=90}}}};function SeriesLevelLayout(a){this.seriesLayoutId=a;this.seriesIndex;this.imageLayoutDimension;this.imageCount;this.isOverlayEnable=false;this.imageRenders=new Array();this.preferenceInfo;this.scrollData={imageIndex:0,frameIndex:0};this.isDragAndDrop=false;this.progressbar=undefined;this.imageType=undefined;this.leadValue={};this.ecgCanvas=undefined;this.isCaliperEnable=true;this.studyUid=undefined;this.backupEnabled=false}SeriesLevelLayout.prototype.getPreferenceInfo=function(){return this.preferenceInfo};SeriesLevelLayout.prototype.setPreferenceInfo=function(a){this.preferenceInfo=a};SeriesLevelLayout.prototype.getImageIndex=function(){return this.scrollData.imageIndex};SeriesLevelLayout.prototype.setImageIndex=function(a){this.scrollData.imageIndex=a};SeriesLevelLayout.prototype.setFrameIndex=function(a){this.scrollData.frameIndex=a};SeriesLevelLayout.prototype.getFrameIndex=function(){return this.scrollData.frameIndex};SeriesLevelLayout.prototype.getSeriesLayoutId=function(){return this.seriesLayoutId};SeriesLevelLayout.prototype.setSeriesIndex=function(a){this.seriesIndex=a};SeriesLevelLayout.prototype.getSeriesIndex=function(){return this.seriesIndex};SeriesLevelLayout.prototype.setImageLayoutDimension=function(a){this.imageLayoutDimension=a};SeriesLevelLayout.prototype.getImageLayoutDimension=function(){return this.imageLayoutDimension};SeriesLevelLayout.prototype.addImageRender=function(a,b){this.imageRenders[a]=b};SeriesLevelLayout.prototype.getImageRender=function(a){return this.imageRenders[a]};SeriesLevelLayout.prototype.getAllImageRenders=function(){return this.imageRenders};SeriesLevelLayout.prototype.removeAllImageRenders=function(){for(var a in this.imageRenders){delete this.imageRenders[a]}};SeriesLevelLayout.prototype.getImageLayoutCount=function(){var b=this.getImageLayoutDimension();if(!b){return 0}var a=b.split("x");return parseInt(a[0])*parseInt(a[1])};SeriesLevelLayout.prototype.setImageCount=function(a){this.imageCount=a};SeriesLevelLayout.prototype.getImageCount=function(){return this.imageCount};SeriesLevelLayout.prototype.getProgressbar=function(){return this.progressbar};SeriesLevelLayout.prototype.setProgressbar=function(a){this.progressbar=a};SeriesLevelLayout.prototype.refreshViewports=function(b){for(var a in this.imageRenders){if(b==this.imageRenders[a]){return}this.imageRenders[a].drawDicomImage()}};SeriesLevelLayout.prototype.getDefaultRenderer=function(){for(var a in this.imageRenders){if(this.imageRenders[a]!=undefined){return this.imageRenders[a]}}};SeriesLevelLayout.prototype.getDefaultRendererImageUid=function(){var a=this.getDefaultRenderer();if(a!=undefined){return a.imageUid}};SeriesLevelLayout.prototype.getImageType=function(){return this.imageType};SeriesLevelLayout.prototype.setImageType=function(a){this.imageType=a};SeriesLevelLayout.prototype.setStudyUid=function(a){this.studyUid=a};SeriesLevelLayout.prototype.getStudyUid=function(){return this.studyUid};SeriesLevelLayout.prototype.setEcgCanvas=function(a){this.ecgCanvas=a};SeriesLevelLayout.prototype.getEcgCanvas=function(){return this.ecgCanvas};SeriesLevelLayout.prototype.setCaliperEnable=function(a){this.isCaliperEnable=a};SeriesLevelLayout.prototype.isCaliperEnable=function(){return this.isCaliperEnable};SeriesLevelLayout.prototype.updateImageRendersTo=function(c,a){for(var b in this.imageRenders){if(b.indexOf(c)>-1){var d=b.replace(c,a);this.addImageRender(d,Object.create(this.imageRenders[b]));delete this.imageRenders[b]}}};SeriesLevelLayout.prototype.copy=function(){var a=new SeriesLevelLayout(this.seriesLayoutId);a.seriesLayoutId=this.seriesLayoutId;a.seriesIndex=this.seriesIndex;a.imageLayoutDimension=this.imageLayoutDimension;a.imageCount=this.imageCount;a.isOverlayEnable=this.isOverlayEnable;for(var b in this.imageRenders){a.addImageRender(b,this.imageRenders[b])}a.preferenceInfo=this.preferenceInfo;if(this.scrollData!==undefined){a.scrollData={};a.scrollData.imageIndex=this.scrollData.imageIndex;a.scrollData.frameIndex=this.scrollData.frameIndex}a.isDragAndDrop=this.isDragAndDrop;a.progressbar=this.progressbar;a.imageType=this.imageType;a.leadValue=this.leadValue;a.ecgCanvas=this.ecgCanvas;a.isCaliperEnable=this.isCaliperEnable;a.studyUid=this.studyUid;a.backupEnabled=this.backupEnabled;return a};var dragThumbnailStudyUid;function ThumbnailRenderer(){var a=THUMBNAIL_PANEL_WIDTH-32;this.uid=guid();this.imageURL;this.metaInfo;this.renderWidget=document.createElement("canvas");this.renderWidget.width=a;this.renderWidget.height=105;this.renderWidget.setAttribute("id","thumb"+this.uid);this.renderWidget.setAttribute("draggable",true);this.renderWidget.setAttribute("ondragstart","doDrag(event)");this.touchEvent=false;this.gestureEvent=false;this.seriesIndex;this.selfReference=this;this.studyUid;this.imageUid}var xPostion=10;var yPostion=10;var fillColour="yellow";var font="bold 8pt Helvetica";ThumbnailRenderer.prototype.createThumbnail=function(j,e,k,h,f){this.seriesIndex=h;this.imageUid=e;this.imageCountOfSeries=f;document.getElementById(k).appendChild(this.renderWidget);logger.startTime("thumbnail "+e);if(thumbnailWidth==undefined){thumbnailWidth=document.getElementById(k).offsetWidth}var c=dicomViewer.getThumbnailUrl(e);var b=dicomViewer.url.getDicomImageURL(c);logger.info("Sereies Thumbnail request URL : "+b);var g=new XMLHttpRequest();g.open("GET",b,true);var d=this;var a="";if(dicomViewer.thumbnail.isShowCacheIndicatorOnThumbnail()){a="block"}else{a="none"}g.send();g.onreadystatechange=function(){if(g.readyState==4&&g.status==200){logger.endTime("thumbnail "+e);var n=dicomViewer.Series.Image.getImage(j,h,0);var q="&nbsp";if(dicomViewer.thumbnail.isImageThumbnail(n)){q=n.instanceNumber}else{q=h+1}var l=dicomViewer.Series.getImageCount(j,h);var v=dicomViewer.changeNullToEmpty(dicomViewer.Series.getModality(j,h));var o=n.imageUid+"seriesTime";if(v==""){v="&nbsp"}if(l==""){l="&nbsp"}if(q==""){q="&nbsp"}var p="";var u=undefined;var r="";if(n.imageType===IMAGETYPE_JPEG||isBlob(n.imageType)){u=o+"_"+q;p="<div class='row'><div id='"+u+"' class='col-xs-2'><font color='#D2F4EF'>"+r+"</font></div><div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>"+q+"</font></div></div><div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+l+"</font></div><div id='"+o+"' style=\"display:"+a+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div></div>"}else{p="<div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+v+"</font></div><div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>"+q+"</font></div></div><div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+l+"</font></div><div id='"+o+"' style=\"display:"+a+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div></div>"}var t=getSeriesDescription(j,h);var m=showSeriesDescription(j,h);$("#"+k).prepend(m);if(t!=undefined&&t!=""){updateToolTip($("#"+k),t,"top")}$("#"+k).append(p);if(n.imageType===IMAGETYPE_JPEG||isBlob(n.imageType)){if(u!=undefined&&r!=""){updateToolTip($("#"+u),n.fileName,"top")}}if(n.imageType==IMAGETYPE_JPEG||n.imageType==IMAGETYPE_RADPDF||n.imageType==IMAGETYPE_PDF||isBlob(n.imageType)){if(n.imageUid!==undefined&&j!==undefined){if(nonDICOMCacheDetails[n.imageUid]==undefined){nonDICOMCacheDetails[n.imageUid]=j;nonDICOMRenderedCount++}else{for(key in nonDICOMCacheDetails){if(key!==n.imageUid){nonDICOMCacheDetails[n.imageUid]=j;nonDICOMRenderedCount++}}}$("#cachemanager_progress").trigger("image_cache_updated",dicomViewer.imageCache.getCacheInfo());updateThumbnailCacheIndication(n.imageUid,"green")}}if(thumbnailHeight==undefined){thumbnailHeight=document.getElementById(k).offsetHeight}d.draw(j,JSON.parse(g.responseText).imageData,k);var s=$("#imageThumbnail_View div").last().parent().parent().attr("id");if(thumbnailHeight&&thumbnailWidth){document.getElementById(k).style.height=thumbnailHeight+"px";document.getElementById(k).style.width=thumbnailWidth+"px"}if(s===k){dicomViewer.resizeThumbnailPanel()}}else{if(g.readyState==4&&(g.status==404||g.status==500)){var v="&nbsp";var o="&nbsp";var l="&nbsp";var q="&nbsp";var p="<div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+v+"</font></div><div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>"+q+"</font></div></div><div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+l+"</font></div><div id='"+o+"' style=\"display:"+a+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div></div>";$("#"+k).append(p)}}}};ThumbnailRenderer.prototype.createImageThumbnail=function(j,e,k,h,f){this.seriesIndex=h;this.imageUid=e;this.imageCountOfSeries=f;document.getElementById(k).appendChild(this.renderWidget);logger.startTime("thumbnail "+e);var c=dicomViewer.getThumbnailUrl(e);var b=dicomViewer.url.getDicomImageURL(c);logger.info("Image Thumbnail request URL : "+b);var g=new XMLHttpRequest();g.open("GET",b,true);var d=this;var a="";if(dicomViewer.thumbnail.isShowCacheIndicatorOnThumbnail()){a="block"}else{a="none"}g.send();g.onreadystatechange=function(){if(g.readyState==4&&g.status==200){logger.endTime("thumbnail "+e);var n=dicomViewer.Series.Image.getImage(j,h,f-1);var o=n.imageUid+"seriesTime";var u=dicomViewer.Series.getModality(j,h);var r="&nbsp";var p=dicomViewer.Series.Image.getImageFrameCount(n);if(dicomViewer.thumbnail.isSeriesContainsMultiframe(j,h)){r=n.instanceNumber}else{r=h+1}u=(u==null||u==undefined)?"":u;if(u==""){u="&nbsp"}if(p==""){p="&nbsp"}if(r==""){r="&nbsp"}var q="<div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+u+"</font></div><div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>"+r+"</font></div></div><div class='row' style='height:10px'><div class='col-xs-2'><font color='#D2F4EF'>"+p+"</font></div><div id='"+o+"' style=\"display:"+a+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div></div>";$("#"+k).append(q);var t=getSeriesDescription(j,h);var m=showSeriesDescription(j,h);$("#"+k).prepend(m);if(t!=undefined&&t!=""){updateToolTip($("#"+k),t,"top")}if(thumbnailHeight==undefined){thumbnailHeight=document.getElementById(k).offsetHeight}d.draw(j,JSON.parse(g.responseText).imageData,k);var s=$("#imageThumbnail_View div").last().parent().parent().attr("id");if(thumbnailHeight&&thumbnailWidth){document.getElementById(k).style.height=thumbnailHeight+"px";document.getElementById(k).style.width=thumbnailWidth+"px"}if(s===k){dicomViewer.resizeThumbnailPanel()}}else{if(g.readyState==4&&(g.status==404||g.status==500)){var u="&nbsp";var o="&nbsp";var l="&nbsp";var r="&nbsp";var q="<div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+u+"</font></div><div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>"+r+"</font></div></div><div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+l+"</font></div><div id='"+o+"' style=\"display:"+a+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div></div></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div>";$("#"+k).append(q)}}}};ThumbnailRenderer.prototype.createNonDCMThumbnail=function(f,c,b,e,d){var a=this;this.seriesIndex=e;this.imageUid=c;var h=d.split(".");var g=h[h.length-1];document.getElementById(b).appendChild(this.renderWidget);if(g=="mp3"){a.draw(f,"images/mp3.png",b)}else{if(g=="mp4"||g=="avi"){a.draw(f,"images/mp4.jpg",b)}else{if(g==="pdf"){a.draw(f,"images/radpdf.png",b)}else{if(g==="html"){a.draw(f,"images/html.png",b)}else{if(g==="txt"){a.draw(f,"images/text.png",b)}else{a.draw(f,"images/invalid.png",b)}}}}}var k=20;if(d.length<20){k=d.length}d=d.replace(/\^/g,"");d=d.replace(/\ /g,"");d=d.replace(/\-/g,"");var j="<div class='row'><div class='col-xs-2'><font color='#D2F4EF'>"+d.substr(0,k)+"</font></div></div>";$("#"+b).append(j)};ThumbnailRenderer.prototype.draw=function(g,f,c){var d=this.renderWidget.getContext("2d");var b=dicomViewer.Series.getImageCount(g,this.seriesIndex);var a=($("#"+c).width())/100;var e=new Image();e.onload=function(){d.translate(50*a,50);var j=Math.min(100/this.width,100/this.height);d.scale(j,j);d.drawImage(this,-this.width/2,-this.height/2);d.fillStyle=fillColour;d.font=font;var h=$("#imageThumbnail_View div").last().parent().parent().attr("id");if(h===c){}};e.src=f};ThumbnailRenderer.prototype.setStudyUid=function(a){this.studyUid=a};ThumbnailRenderer.prototype.getStudyUid=function(){return this.studyUid};var touchCount=0;var elementId=null;function loadSeries(c){c.preventDefault();var b=$("#"+c.target.id).parent().attr("id");var a=dicomViewer.thumbnail.getThumbnail(b);loadImageInViewer(a)}function doDrag(c){var a=dicomViewer.thumbnail.getThumbnail($("#"+c.target.id).parent().attr("id"));dragThumbnailStudyUid=a.getStudyUid();var b="text";c.dataTransfer.setData(b,c.target.id)}function loadImage(c){var b=c.currentTarget.id;var a=dicomViewer.thumbnail.getThumbnail(b);loadImageInViewer(a,b)}function loadImageInViewer(d,b){if(d.imageCountOfSeries===undefined){d.imageCountOfSeries=1}var j=getAndSelectLayout(d.studyUid);var h=false;if(j.studyUid==undefined||j.setStudyUid==null){h=true}if((j.studyUid!==undefined||j.studyUid!=null)&&d.studyUid!=j.studyUid){dicomViewer.thumbnail.alertThumbnailSelection(b);return}else{if(!IsSameStudy(d.studyUid)){dicomViewer.thumbnail.alertThumbnailSelection(b);return}}var e=d.getStudyUid();var f=j.seriesLayoutId;var a=undefined;if(dicomViewer.thumbnail.isSeriesContainsMultiframe(e,d.seriesIndex)){a=parseInt(dicomViewer.Series.Image.getImageIndex(e,d.seriesIndex,d.imageUid))}else{a=getImageIndexBySeriesIndex(e,d.seriesIndex)}if(j.seriesIndex===undefined&&a!==undefined){a=undefined}var g=dicomViewer.viewports.getViewportByImageIndex(e,d.seriesIndex,a);if(isFullScreenEnabled==true&&g!==undefined&&j!==undefined){if(getStudyLayoutId(g.seriesLayoutId)===getStudyLayoutId(j.seriesLayoutId)){g=undefined}}var l=true;if(g===undefined&&a!==-1){l=dicomViewer.viewports.checkVewportAvailable(f,e);if(!l){return}j.setStudyUid(e);if(h){var c=dicomViewer.Series.Image.getImage(j.studyUid,d.seriesIndex,0);viewportHeight(j.seriesLayoutId,c.imageType)}dicomViewer.loadImageFromThumbnail(d.seriesIndex,d.imageCountOfSeries);if(h&&dicomViewer.isDicomStudy(j.studyUid)&&document.getElementById(j.seriesLayoutId+"_progress")){var k=document.getElementById(j.seriesLayoutId+"_progress").style.top;k=k.replace("px","");document.getElementById(j.seriesLayoutId+"_progress").style.top=(parseInt(k)+15)+"px";var m=(j.seriesLayoutId).split("_")[1];dicomViewer.createSaveAndLoadPStateGUI("saveAndLoad_"+m,j.studyUid,m)}}else{if(g===undefined&&a===-1){j.setStudyUid(e);dicomViewer.setActiveSeriesLayout(j);dicomViewer.loadImageFromThumbnail(d.seriesIndex,d.imageCountOfSeries)}else{if(g!==undefined&&j.studyUid===undefined){j.setStudyUid(e);dicomViewer.setActiveSeriesLayout(j);dicomViewer.loadImageFromThumbnail(d.seriesIndex,d.imageCountOfSeries)}else{dicomViewer.changeSelection(g.seriesLayoutId)}}}if(myDropDown!==null){myDropDown.wrapper.hide()}var c=dicomViewer.Series.Image.getImage(d.studyUid,d.seriesIndex,d.imageCountOfSeries-1);if(canPlayCine(c.imageType)&&dicomViewer.thumbnail.canRunCine(c)){dicomViewer.startCine();updatePlayIcon("play.png","stop.png")}else{dicomViewer.scroll.stopCineImage(undefined);updatePlayIcon("stop.png","play.png")}EnableDisableNextSeriesImage(j)}function getImageIndexBySeriesIndex(d,b){var c=dicomViewer.viewports.getAllViewports();if(c===null||c===undefined){return}var a=undefined;$.each(c,function(e,f){if(f.studyUid===d&&f.seriesIndex===b){a=f.scrollData.imageIndex;return false}});return a}function updateThumbnailCacheIndication(c,b){var a;if(b==="green"){a="<img id='test' style='width:20px;'  src='images/download-complete.png' />"}else{if(b==="yellow"){a="<img id='test' style='width:20px;'  src='images/download-inprogress.png' />"}else{a=""}}$("#"+c+"seriesTime").html(a)}function showSeriesDescription(d,a){var c=getSeriesDescription(d,a);if(c===undefined||c===null){c=""}else{if(c.length>16){c=c.substring(0,15)}}var b="<div text align='top'><div ><font color='white'>"+c+"</font></div></div>";return b}function getSeriesDescription(b,a){return dicomViewer.Series.getSeriesDescription(b,a)}function getSeriesLayoutId(g){try{if(g===null||g===undefined){return undefined}var b=dicomViewer.viewports.getAllViewports();if(b===null||b===undefined){return undefined}var d=undefined;$.each(b,function(e,h){if(h.studyUid===g){d=h.seriesLayoutId;return false}});if(d===undefined){var a=dicomViewer.getActiveSeriesLayout();if(a===undefined){return undefined}if(a.studyUid===undefined){return a.getSeriesLayoutId()}var f=[];$.each(b,function(e,h){if(h.studyUid===undefined){f.push(h.seriesLayoutId)}});if(f===null||f===undefined){return undefined}if(f.length>0){f.sort();d=f[0]}}return d}catch(c){}return undefined}function getAndSelectLayout(d){var a=dicomViewer.getActiveSeriesLayout();try{if(a.studyUid===d){return a}var c=getSeriesLayoutId(d);if(c===undefined){return a}if(c===a.getSeriesLayoutId()){return a}if(!dicomViewer.IsFullScreenMode()){dicomViewer.changeSelection(c);a=dicomViewer.getActiveSeriesLayout()}return a}catch(b){console.error(b)}return a}function IsSameStudy(b){if(dicomViewer.IsFullScreenMode()){var a=dicomViewer.getActiveSeriesLayout();if(a!==undefined&&a.studyUid!==undefined){if(a.studyUid===b){return true}}else{if(a.studyUid===undefined){return true}}return false}return true}function ViewportProgreeBar(f){this.framePosition=0;this.cachedIndicationPoint=0;this.seriesIndex;this.imageIndex;this.frameIndex;this.studyUid;this.cachedPercentage=0;this.parentElementId=f;var d=$("#"+f);this.imageIndicator=document.createElement("canvas");this.cacheIndicator=document.createElement("canvas");this.imageIndicator.setAttribute("id",f+"_progress");var b=d.height();var a=d.width();var c=d.outerWidth()-a;var g=d.outerHeight()-b;var e=(d.position().top+b)-3;this.viewportWidth=d.outerWidth();this.viewportHeight=d.outerHeight();this.imageIndicator.width=this.viewportWidth-c-2;this.imageIndicator.height=10;d.append(this.imageIndicator);this.imageIndicator.style.zIndex="8";this.imageIndicator.style.position="absolute";this.imageIndicator.style.top=e+"px"}ViewportProgreeBar.prototype.setSeriesInfo=function(d,b,a,c){this.seriesIndex=b;this.imageIndex=a;this.frameIndex=c;this.studyUid=d;this.drawImageCacheIndicator()};ViewportProgreeBar.prototype.drawImageCacheIndicator=function(){if(this.seriesIndex==undefined||this.imageIndex==undefined){return}logger.debug("Move Cache Indicator for SeriesIndex: "+this.seriesIndex+" and ImageIndex: "+this.imageIndex);var e=dicomViewer.Series.Image.getImage(this.studyUid,this.seriesIndex,this.imageIndex);var b=0;var f=dicomViewer.thumbnail.isSeriesContainsMultiframe(this.studyUid,this.seriesIndex);if(f&&dicomViewer.thumbnail.isImageThumbnail(e)){b=dicomViewer.Series.Image.getImageFrameCount(e);this.cacheIndicator.width=b;this.cacheIndicator.height=10;var a=this.cacheIndicator.getContext("2d");a.beginPath();a.moveTo(0,0);a.lineTo(this.cacheIndicator.width,0);a.lineWidth=10;a.strokeStyle="#BDBDBD";a.stroke();for(var d=0;d<b;d++){var k=dicomViewer.imageCache.isInCache(e.imageUid+"_"+d);if(k==true){a.beginPath();a.moveTo(d,0);a.lineTo(d+1,0);a.lineWidth=10;a.strokeStyle="#1C1C1C";a.stroke()}}}else{b=dicomViewer.Series.getImageCount(this.studyUid,this.seriesIndex);this.cacheIndicator.width=b*5;this.cacheIndicator.height=10;var a=this.cacheIndicator.getContext("2d");a.beginPath();a.moveTo(0,0);a.lineTo(this.cacheIndicator.width,0);a.lineWidth=10;a.strokeStyle="#BDBDBD";a.stroke();for(var c=0;c<b;c++){var g=dicomViewer.Series.Image.getImage(this.studyUid,this.seriesIndex,c);var h=dicomViewer.imageCache.isInCache(g.imageUid+"_0");if(h==true){a.beginPath();a.moveTo(c*5,0);a.lineTo(c*5+5,0);a.lineWidth=10;a.strokeStyle="#1C1C1C";a.stroke()}}}var j=this.imageIndicator.getContext("2d");j.clearRect(0,0,this.imageIndicator.width,this.imageIndicator.height);j.drawImage(this.cacheIndicator,0,0,this.imageIndicator.width,this.imageIndicator.height);j.beginPath();if(this.framePosition==0){var l=dicomViewer.getActiveSeriesLayout();var m=0;if(l!==null){m=l.getImageLayoutCount()-1}this.updateFramePosition(m,b)}j.rect(this.framePosition,0,5,4);j.fillStyle="white";j.fill();j.lineWidth=1;j.strokeStyle="white";j.stroke()};ViewportProgreeBar.prototype.updateImagePosition=function(b,a){this.updateFramePosition(a,b);this.drawImageCacheIndicator()};ViewportProgreeBar.prototype.updateFramePosition=function(b,a){var c=((b+1)/a)*100;var d=this.imageIndicator.width*(c/100);this.framePosition=d};var dicomViewer=(function(d){if(d===undefined){d={}}var a={};var f={};function c(g,q,o,h){var j=g.ImageUid;if(q!=null){$("#"+q).empty();var m="SR"+q;var n="<div id="+m+"/>";$("#"+q).append(n);$("#"+q)[0].isHtml=true;$("#"+q)[0].HtmlId=m;$("#"+m).css("background","white");$("#"+m).css("overflow","auto");$("#"+m).css("width",$("#"+q).width()-3);$("#"+m).css("height",$("#"+q).height()-3);$("#"+m).css("padding",5);$("#"+m).removeClass("disableSelection");$("#"+q).removeClass("disableSelection");$("#"+getStudyLayoutId(q)).removeClass("disableSelection")}if(a[j]==undefined){var r=d.url.getDicomImageURL(g);var l;if(window.XMLHttpRequest){l=new XMLHttpRequest()}else{l=new ActiveXObject("Microsoft.XMLHTTP")}g=d.getSRreportUrl(g.ImageUid);var p=d.url.getDicomImageURL(g);l.onreadystatechange=function(){if(l.readyState==4&&l.status==200){if(q!=null){$("#"+m).append(l.responseText)}a[j]=l.responseText;var s={imageUid:j,imageData:a[j],imageType:"nonimage",};f[m]=j;o.resolve(a[j])}};l.open("get",p,true);l.send()}else{$("#"+m).append(a[j]);var k=o.state();if(k!="resolved"){o.resolve(a[j])}}}function e(g){if(f[g]===undefined){return false}else{return true}}function b(j){var k=d.getActiveSeriesLayout();var l="SR"+k.getSeriesLayoutId();var g=parseFloat($("#"+l).css("font-size"));if(j=="4_zoom"){$("#"+l).css({fontSize:g+1})}else{if(j=="5_zoom"){$("#"+l).css({fontSize:g-1})}else{var h=(parseFloat(j.split("-")[1]))/100;h=h-1;$("#"+l).css({fontSize:12.75+h})}}}d.loadSR=c;d.containsSR=e;d.zoomSR=b;return d}(dicomViewer));var dicomViewer=(function(c){if(c===undefined){c={}}function b(e,d,h){$("#"+d).empty();var f="<video width='"+$("#"+d).width()+"'";var g;if(h==="mp3"){f=f+' poster="images/mp3.png"';g="audio/mp3"}else{if(h==="mp4"){g="video/mp4"}else{if(h==="webm"){g="video/webm"}else{if(h==="avi"){g="video/avi"}}}}f=f+"height='"+$("#"+d).height()+"'controls><source src="+e+" type="+g+"></video>";$("#"+d).append(f)}function a(f,d){$("#"+d).empty();var e="<video width='"+$("#"+d).width()+"' height='"+$("#"+d).height()+"' controls>";var g=f.length;for(i=0;i<g;i++){e=e+"<source src="+f[i].url+" type="+f[i].type+">"}e=e+"</video>";$("#"+d).append(e)}c.loadPlayer=b;c.loadVideoPlayer=a;return c}(dicomViewer));var dicomViewer=(function(f){if(f===undefined){f={}}var a=40;var s=5;function g(w,t){try{var A="<div id='pdfData_"+t+"'><div style='background:white;'></div></div>";$("#"+t).html(A);$("#"+t).height($("#"+t).height());$("#"+t).width($("#"+t).width());$("#"+t).css("overflow","auto");$("#"+t).css("background","black");var v="imagePdfDiv"+t;var x="<div id='"+v+"' align='center' style='background:black;float: left;' ></div>";$("#"+t).append(x);var z=document.createElement("canvas");z.setAttribute("id","imagePdfCanvas"+t);z.setAttribute("width",$("#"+t).width());z.setAttribute("height",$("#"+t).height());z.style.background="black";var u=$("#"+t).height()-$("#pdfData_"+t).height();$("#"+v).height(u);$("#"+v).width($("#"+t).width());$("#"+v).append(z);$("#pageNumber").unbind("keypress");$("#pageNumber").bind("keypress",{},k);PDFJS.disableStream=false;PDFJS.getDocument(w).then(function(C){var B=o(t);if(B!==null&&B!==undefined){B.pdfData={imageData:C,pageCount:C.numPages,currentPageNumber:0,viewportId:t,PState:new Presentation()};if(t==f.getActiveSeriesLayout().seriesLayoutId){activeSeriesPDFData=B.pdfData;isPDFActiveSeries=true}l(1,undefined,B);if(isPDFActiveSeries==true){b(activeSeriesPDFData)}}else{console.error("Invalid pdf renderer")}})}catch(y){}}function h(t){try{if(t===null||t===undefined){return}var v=t.pdfData;if(v===null||v===undefined){return}var w=v.imageData;if(w===null||w===undefined){return}w.getPage(v.currentPageNumber).then(function(C){var G=C.getViewport(1);var H=document.getElementById("imagePdfDiv"+v.viewportId);var I=document.getElementById("imagePdfCanvas"+v.viewportId);var z=I.getContext("2d");var E=a;var A=s;var D=(H.clientWidth-E)/G.width;var F=(H.clientHeight-A)/G.height;var x=1;switch(v.PState.zoomLevel){case 0:x=1;break;case 1:x=Math.min(D,F);break;case 2:x=D;break;case 3:x=F;break;case 4:x=v.PState.zoom;break;default:x=Math.min(D,F);break}var B=C.getViewport(x,v.PState.rotation,v.PState.hFlip,v.PState.vFlip);v.PState.zoom=x;I.height=B.height;I.width=B.width;var y={canvasContext:z,viewport:B};C.render(y)})}catch(u){}}function l(v,y,w){try{if(w===null||w===undefined){w=o();if(w===null||w===undefined){return}}var A=w.pdfData;if(A===null||A===undefined){return}var t=0;var u=0;var z=A.pageCount;var u=A.currentPageNumber;switch(v){case 1:t=1;break;case 2:t=Math.min(z,u+1);break;case 3:t=Math.max(1,u-1);break;case 4:t=z;break;case 5:t=(y<1?1:(y>z?z:y));break;default:t=1;break}if(A.currentPageNumber==t){b(A);return}A.currentPageNumber=t;h(w);b(A)}catch(x){}}function d(t,v){try{var u=o();if(u===null||u===undefined){return}var x=u.pdfData;if(x===null||x===undefined){return}x.PState.zoomLevel=t;if(v!=undefined){x.PState.zoomLevel=4;x.PState.zoom=v}h(u)}catch(w){}}function o(u){try{var t=null;if(u!==undefined){t=f.viewports.getViewport(u)}else{t=f.getActiveSeriesLayout()}if(t!==undefined&&t!==null){return t.getImageRender("pdfData")}}catch(v){}return undefined}function k(u){var t=(u.keyCode?u.keyCode:u.which);if(t==13){u.preventDefault();l(5,parseInt(u.currentTarget.value))}}function b(v){var t=f.getActiveSeriesLayout();if(t==undefined||t==null){return}var u=f.Series.Image.getImage(t.studyUid,t.seriesIndex,t.scrollData.imageIndex);if(u.imageType==IMAGETYPE_PDF||u.imageType==IMAGETYPE_TIFF||u.imageType==IMAGETYPE_RADPDF){document.getElementById("pageNumber").value=v.currentPageNumber;document.getElementById("totalPagesLabel").textContent="of "+v.pageCount;v.currentPageNumber>=v.pageCount?$("#nextPage").addClass("k-state-disabled"):$("#nextPage").removeClass("k-state-disabled");v.currentPageNumber<=1?$("#previousPage").addClass("k-state-disabled"):$("#previousPage").removeClass("k-state-disabled");v.currentPageNumber==1?$("#firstPage").addClass("k-state-disabled"):$("#firstPage").removeClass("k-state-disabled");v.currentPageNumber==v.pageCount?$("#lastPage").addClass("k-state-disabled"):$("#lastPage").removeClass("k-state-disabled");v.pageCount==1?pdfToolBarElement.hide():pdfToolBarElement.show()}}function p(t){var u=null;if(u===null){u=o(t);if(u===null||u===undefined){return}}var v=u.pdfData;if(v===null||v===undefined){return}b(v)}function r(){l(1)}function j(){l(2)}function m(){l(3)}function n(){l(4)}function q(){var t=o();if(t===null||t===undefined){return}var u=t.pdfData;if(u===null||u===undefined){return}u.PState.rotation=(u.PState.rotation+90)<360?u.PState.rotation+90:0;h(t)}function e(t){var u=o();if(u===null||u===undefined){return}var v=u.pdfData;if(v===null||v===undefined){return}t?v.PState.hFlip=!v.PState.hFlip:v.PState.vFlip=!v.PState.vFlip;h(u)}function c(){var t=o();if(t===null||t===undefined){return}var u=t.pdfData;if(u===null||u===undefined){return}u.currentPageNumber=0;u.PState=undefined;u.PState=new Presentation();l(1,undefined,t)}f.createPDF=g;f.openFirstPage=r;f.openNextPage=j;f.openPreviousPage=m;f.openLastPage=n;f.setPdfZoom=d;f.updatePaging=p;f.rotate=q;f.flip=e;f.revert=c;return f}(dicomViewer));