function DicomMetaInfoReader() {
	this.dicomTags =  new Object();	
	this.referenceString;
};
							  
DicomMetaInfoReader.prototype.loadDICOMInfo = function(returnString) {
	
	returnString = JSON.parse(returnString);
	this.referenceString = returnString;
	for ( var i = 0; i < returnString.length; i++)
	{
		this.dicomTags[returnString[i].tag] = returnString[i].tagValue;
	}		
};

DicomMetaInfoReader.prototype.getDicomTagValue = function(tag)
{
	return (this.dicomTags['('+tag+')']);
};

DicomMetaInfoReader.prototype.getReference = function()
{
	return  this.referenceString;
};

DicomMetaInfoReader.prototype.getPhotometricInterpretation = function()
{
	return this.dicomTags['(0028,0004)'];
};

DicomMetaInfoReader.prototype.getColumns = function()
{
	//throw new Error("DICOM meta information is not loaded");
	return  parseInt(this.dicomTags['(0028,0011)']);
};

DicomMetaInfoReader.prototype.getRows = function()
{
	//throw new Error("DICOM meta information is not loaded");
	return parseInt(this.dicomTags['(0028,0010)']);
};

DicomMetaInfoReader.prototype.getBitDepth = function()
{
	var tmpBitStored = parseInt(this.dicomTags['(0028,0100)']);
	if (tmpBitStored == 8) return 1;
	else if (tmpBitStored == 16) return 2;
};

DicomMetaInfoReader.prototype.getWindowWidth = function()
{
	return parseInt(this.dicomTags['(0028,1051)']);
};

DicomMetaInfoReader.prototype.getWindowCenter = function()
{
	return parseInt(this.dicomTags['(0028,1050)']);
};

DicomMetaInfoReader.prototype.getRescaleIntercept = function()
{
	if(this.dicomTags['(0028,1052)'] === undefined)
	{
		return 0;
	}
	else
	{
		return parseInt(this.dicomTags['(0028,1052)']);
	}
};

DicomMetaInfoReader.prototype.getRescaleSlope = function()
{
	if(this.dicomTags['(0028,1053)'] === undefined)
	{
		return 1;
	}
	else
	{
		return parseInt(this.dicomTags['(0028,1053)']);
	}
};

DicomMetaInfoReader.prototype.getPatientName = function()
{
	return (this.dicomTags['(0010,0010)']);
};

DicomMetaInfoReader.prototype.getPatientId = function()
{
	return (this.dicomTags['(0010,0020)']);
};

DicomMetaInfoReader.prototype.getPatientDOB = function()
{
	return (this.dicomTags['(0010,0030)']);
};

DicomMetaInfoReader.prototype.getPatientSex = function()
{
	return (this.dicomTags['(0010,0040)']);
};

DicomMetaInfoReader.prototype.getStudyDate = function()
{
	return (this.dicomTags['(0008,0020)']);
};

DicomMetaInfoReader.prototype.getAccessionNumber = function()
{
	return (this.dicomTags['(0008,0050)']);
};

DicomMetaInfoReader.prototype.getInstitutionName = function()
{
	return (this.dicomTags['(0008,0080)']);
};

DicomMetaInfoReader.prototype.getManufacturer = function()
{
	return (this.dicomTags['(0008,0070)']);
};

DicomMetaInfoReader.prototype.getReferringPhysicianName = function()
{
	return (this.dicomTags['(0008,0090)']);
};

DicomMetaInfoReader.prototype.getStudyInstanceUID = function()
{
	return (this.dicomTags['(0020,000D)']);
};

DicomMetaInfoReader.prototype.getSeriesInstanceUID = function()
{
	return (this.dicomTags['(0020,000E)']);
};

DicomMetaInfoReader.prototype.getSopInstanceUID = function()
{
	return (this.dicomTags['(0008,0018)']);
};

DicomMetaInfoReader.prototype.getInstanceNumber = function()
{
	return (this.dicomTags['(0020,0013)']);
};

DicomMetaInfoReader.prototype.getColumnPixelSpacing = function()
{
	return this.getPixelSpacing().column;
};

DicomMetaInfoReader.prototype.getRowPixelSpacing = function()
{
	return this.getPixelSpacing().row;
};

DicomMetaInfoReader.prototype.getPixelSpacing = function()
{
	var pixelSpacing = this.dicomTags['(0028,0030)'];
	if(pixelSpacing && pixelSpacing.length > 0) 
	{
		var split = pixelSpacing.split('\\');
		return {
			row: parseFloat(split[0]),
			column: parseFloat(split[1])
			};
	}
	else
	{
		return {
			row: undefined,
			column: undefined
			};
	}
};
function ImageInfoManager(imageInfo)
{
    this.imageInfo = JSON.parse(imageInfo);
}

ImageInfoManager.prototype.getWindowWidth = function()
{
    return this.imageInfo.windowWidth;
};

ImageInfoManager.prototype.getWindowCenter = function()
{
    return this.imageInfo.windowCenter;
};

ImageInfoManager.prototype.getRescaleSlope = function()
{
    return this.imageInfo.decimalRescaleSlope;
};

ImageInfoManager.prototype.getRescaleIntercept = function()
{
    return this.imageInfo.decimalRescaleIntercept;
};

ImageInfoManager.prototype.getMaxPixelValue = function()
{
    return this.imageInfo.maxPixelValue;
};

ImageInfoManager.prototype.getMinPixelValue = function()
{
    return this.imageInfo.minPixelValue;
};

ImageInfoManager.prototype.setMaxPixelValue = function(maxPixelValue)
{
    this.imageInfo.maxPixelValue = maxPixelValue;
};

ImageInfoManager.prototype.setMinPixelValue = function(minPixelValue)
{
    this.imageInfo.minPixelValue = minPixelValue;
};

ImageInfoManager.prototype.isColor  = function()
{
    return this.imageInfo.isColor;
};

ImageInfoManager.prototype.isSigned  = function()
{
    return this.imageInfo.isSigned;
};

ImageInfoManager.prototype.isPlanar  = function()
{
    return this.imageInfo.isPlanar;
};

ImageInfoManager.prototype.getSamplesPerPixel = function()
{
    return this.imageInfo.samplesPerPixel;
};

ImageInfoManager.prototype.getPlanarConfiguration = function()
{
    return this.imageInfo.planarConfiguration;
};

ImageInfoManager.prototype.getPixelRepresentation = function()
{
    return this.imageInfo.pixelRepresentation;
};

ImageInfoManager.prototype.getPhotometricInterpretation = function()
{
    return this.imageInfo.photometricInterpretation;
};

ImageInfoManager.prototype.getFrameSize = function () {

    return this.imageInfo.frameSize;
};

ImageInfoManager.prototype.getNumberOfFrames = function ()
{
    return this.imageInfo.numberOfFrames;
};

ImageInfoManager.prototype.getColumns = function()
{
    return this.imageInfo.imageWidth;
};
ImageInfoManager.prototype.setColumns = function(columns)
{
    this.imageInfo.imageWidth = columns;
};
ImageInfoManager.prototype.getRows = function()
{
    return this.imageInfo.imageHeight;
};
ImageInfoManager.prototype.setRows = function(rows)
{
    this.imageInfo.imageHeight = rows;
};
ImageInfoManager.prototype.getHighBit = function()
{
    return this.imageInfo.highBit;
};

ImageInfoManager.prototype.getBitsStored = function()
{
    return this.imageInfo.bitsStored;
};

ImageInfoManager.prototype.getBitsAllocated = function()
{
    return this.imageInfo.bitsAllocated;
};

ImageInfoManager.prototype.getBitDepth = function()
{
    return this.imageInfo.highBit + 1;
};

ImageInfoManager.prototype.getPatientName = function()
{
    return this.imageInfo.patientName;
};

ImageInfoManager.prototype.getStudyDate = function ()
{
    return this.imageInfo.studyDate;
};

ImageInfoManager.prototype.getStudyTime = function () {
    return this.imageInfo.studyTime;
};

ImageInfoManager.prototype.getAccessionNumber = function ()
{
    return this.imageInfo.accessionNumber;
};

ImageInfoManager.prototype.getManufacturer = function()
{
    return this.imageInfo.manufacturer;
};

ImageInfoManager.prototype.getInstanceNumber = function()
{
    return this.imageInfo.instanceNumber;
};

ImageInfoManager.prototype.getIsCompressed  = function()
{
    return this.imageInfo.isCompressed;
};

ImageInfoManager.prototype.getDirectionalMarkers  = function()
{
    return this.imageInfo.directionalMarkers;
};
ImageInfoManager.prototype.getCompressionMethod   = function()
{
    return this.imageInfo.compressionMethod;
};
ImageInfoManager.prototype.getUSRegions = function () {

    if ((this.imageInfo.measurement != null) && (this.imageInfo.measurement.usRegions != null)) {
        return this.imageInfo.measurement.usRegions;
    }

    return undefined;
};
ImageInfoManager.prototype.getContentTime = function()
{
    var contentTime = this.imageInfo.contentTime;
    if(contentTime == undefined || contentTime == null) {
        contentTime = "";
    }
    
    return contentTime;
};

ImageInfoManager.prototype.getContentDate = function ()
{
    var contentDate = this.imageInfo.contentDate;
    if(contentDate == undefined || contentDate == null) {
        contentDate = "";
    }
    
    return contentDate;
};

ImageInfoManager.prototype.getModality = function ()
{
    var modality = this.imageInfo.modality;
    if(modality == undefined || modality == null) {
        modality = "";
    }
    
    return modality;
};/*
Call the loadstudy method while loading the body(onload) of the viewer page
Load Study request is completed it calls the set setSeriesLayout inside the imageviewport.js
From that it will call the setImageLevelLayout method inside the imageviewport.js
There we check the image type(ECG|| PDF || RAD || RADECHO) if the type is ECG it ill call the loadEcg method inside the EcgRender.js
*/
var dicomViewer = (function(dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var urlPram;
    var selectedEcgFormat = {};
    var verticalCaliperValue = undefined;
    var verContxtValue = undefined
    var isEcgPrefornecCreated = false;
    var ecgPreferenceValue = {};
    var ecgCacheDetails ={};
    var ecgPreferenceType = {};
    var isToUseSavedValue = true;
    var configuredLeadType = "3x4+1" ;

    function loadEcg(urlParameters, divId, menuUrl, flag) {
        var savedPreferenceValue = getECGPreferenceValue(urlParameters.ImageUid);
        var savedPreferenceType = getECGPreferenceType(urlParameters.ImageUid);

        if(savedPreferenceValue != undefined && savedPreferenceType != undefined && isToUseSavedValue) {            
            menuUrl = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue());
          
            updatePreference("GridType", savedPreferenceValue["gridType"], savedPreferenceType["GridType"]);           
            updatePreference("GridColor", savedPreferenceValue["gridColor"], savedPreferenceType["GridColor"]);
            updatePreference("SignalThickness", savedPreferenceValue["signalThickness"], savedPreferenceType["SignalThickness"]);
            updatePreference("Gain", savedPreferenceValue["gain"], savedPreferenceType["Gain"]);
            updatePreference("LeadFormat", savedPreferenceValue["leadFormat"], savedPreferenceType["DrawType"]);
        
            flag = true;
        }
      
        $("#ecgPreference").prop("disabled", false);
        urlPram = dicomViewer.getEcgInformationUrl(urlParameters.ImageUid);
        var url = dicomViewer.url.getDicomImageURL(urlParameters);

        var request;
        if (window.XMLHttpRequest) { // If the browser if IE7+[or]Firefox[or]Chrome[or]Opera[or]Safari
            request = new XMLHttpRequest();
        } else { //If browser is IE6, IE5
            request = new ActiveXObject("Microsoft.XMLHTTP");
        }
        request.onreadystatechange = function() {
            if (request.readyState == 4 && request.status == 200) {
                if (!flag) {

                    var gridType = "1";
                    var gridColor = "0";
                    var signalThickness = "1";
                    var gain = "1";
                    var drawType = "8";
                    var gridColorSelection = "redGrid";

                    // Get the ECG preference
                    var activeSeriesLayout = dicomViewer.viewports.getViewport(divId);
                    if(activeSeriesLayout !== undefined && activeSeriesLayout !== null) {
                        var imageRender = activeSeriesLayout.getImageRender("ecgData");   
                        if(activeSeriesLayout !== undefined && imageRender !== undefined) {
                            imageRender.applyOrRevertDisplaySettings();
                            var preferenceInfo = activeSeriesLayout.preferenceInfo;

                            // Selected ECG Preference selection
                            if(preferenceInfo !== undefined && preferenceInfo.selectedEcgFormat !== undefined) {
                                gridType = preferenceInfo.selectedEcgFormat.GridType;
                                gridColor = preferenceInfo.selectedEcgFormat.GridColor;
                                signalThickness = preferenceInfo.selectedEcgFormat.SignalThickness;
                                gain = preferenceInfo.selectedEcgFormat.Gain;
                                drawType = preferenceInfo.selectedEcgFormat.DrawType;
                            }

                            // ECG Preference selection
                            if(preferenceInfo !== undefined && preferenceInfo.preferenceData !== undefined) {
                                gridColorSelection = preferenceInfo.preferenceData.gridColor;
                            }
                        }
                    }

                    urlParameters = dicomViewer.getEcgWaveformUrl(urlParameters.ImageUid,
                        drawType, gridType, gridColor, signalThickness, gain);
                    // Set default values to the ECG URL parameters
                    var seriesLayout = dicomViewer.getActiveSeriesLayout();
                    if (seriesLayout != null || seriesLayout != undefined) {
                        seriesLayout.preferenceInfo.addECGParameters("GridType", gridType);
                        seriesLayout.preferenceInfo.addECGParameters("GridColor", gridColor);
                        seriesLayout.preferenceInfo.addECGParameters("SignalThickness", signalThickness);
                        seriesLayout.preferenceInfo.addECGParameters("Gain", gain);
                        seriesLayout.preferenceInfo.addECGParameters("DrawType", drawType);
                        //Drag and Drop or click the Ecg thumbnal after chnaging the grid color to gray
                        //If we dont set grid color to red(white claiper in red grid)the claiper will display white
                        seriesLayout.preferenceInfo.setGridColor(gridColorSelection);
                    }
                    url = dicomViewer.url.getDicomImageURL(urlParameters);
                } else {
                    menuUrl.Transform = "Png";
                    url = dicomViewer.url.getDicomImageURL(menuUrl);
                    var parameteres = "";
                    // Load the ECG parameter values using existing selected preference information
                    var seriesLayout = dicomViewer.getActiveSeriesLayout();
                    var selectedECGFormat = seriesLayout.preferenceInfo.getECGParameters();
                    for (var key in selectedECGFormat) {
                        parameteres = parameteres + "&" + key + "=" + selectedECGFormat[key];
                    }
                    url = url + parameteres;
                }

                var jsonData = JSON.parse(request.responseText);

                //if(isEcgPrefornecCreated === false)
                {
                    var leadTyptes = jsonData.LeadTypes;
                    var lengthOfLeadTypes = leadTyptes.length;

                    var valueOne = "";
                    var valueTwo = "";
                    var valueThree = "";
                    var optionString = "<select id='3x41Value'>";
                    for (var index = 0; index < lengthOfLeadTypes; index++) {
                        //<option value="I">I</option>
                        var value = leadTyptes[index];
                        optionString = optionString + "<option value='" + value + "'>" + value + "</option>";
                        if (index === 1)
                            valueOne = value;
                        else if (index === 7)
                            valueTwo = value;
                        else if (index === 10)
                            valueThree = value;
                    }
                    optionString = optionString + "</select>";

                    $("#3x41").html("signal:" + optionString);
                    $("#3x41Value").css('color', '#525252');
                    $("#3x41Value").val(valueOne);

                    optionString = optionString.replace("'3x41Value'", "'3x43one' disabled");
                    $("#3x43_1").html(optionString);
                    $("#3x43one").css('color', '#525252');
                    $("#3x43one").val(valueOne);
                    optionString = optionString.replace("'3x43one'", "'3x43two' disabled");
                    $("#3x43_2").html(optionString);
                    $("#3x43two").val(valueTwo);
                    $("#3x43two").css('color', '#525252');
                    optionString = optionString.replace("'3x43two'", "'3x43three' disabled");
                    $("#3x43_3").html(optionString);
                    $("#3x43three").val(valueThree);
                    $("#3x43three").css('color', '#525252');
                    isEcgPrefornecCreated = true;

                    /*var cachedImagesCount = 0; 
                    if(dicomViewer.getCacheInfo != undefined)
                        cachedImagesCount = dicomViewer.getCacheInfo.numberOfImagesCached;

                    var totalCachedcount = cachedImagesCount + ecgRenderedCount;
                    $("#cachemanager_progress").attr("title", "Number of images cached : " + totalCachedcount);
                    setECGCacheDetails(urlParameters.ImageUid, dicomViewer.getActiveSeriesLayout().seriesLayoutId); 
                    updateThumbnailCacheIndication(urlParameters.ImageUid, "green");*/


                }

                var name = changeNullToEmpty(jsonData.PatientName);
                var age = changeNullToEmpty(jsonData.PatientAge);
                var gender = changeNullToEmpty(jsonData.PatientGender);
                var patientId = changeNullToEmpty(jsonData.PatientId);
                var acquisitionDateTime = changeNullToEmpty(jsonData.AcquisitionDateTime);

                var diagnosticText = changeNullToEmpty(jsonData.DiagnosticText);
                var print = changeNullToEmpty(jsonData.PRInt);
                var prtaxes = changeNullToEmpty(jsonData.PRTAxes);
                var qrsdur = changeNullToEmpty(jsonData.QRSDur);
                var qtatc = changeNullToEmpty(jsonData.QTQTc);
                var ventrate = changeNullToEmpty(jsonData.VentRate);

                var referringPhysician = changeNullToEmpty(jsonData.ReferringPhysician);
                var confirmedPhysician = changeNullToEmpty(jsonData.ConfirmedPhysician);

                var jasonDataDiv = "<div id='ecgData_" + divId + "' style='font-size:12px;' ><div id='ecgDataDiv_" + divId + "' style='background:white;'>" +
                    "<table>" +
                    "<tr>" +
                    "<td>Naming:</td>" + "<td>&nbsp" + name + "</td>" +
                    "<td>&nbsp&nbsp&nbsp&nbspVent Rate:</td>" + "<td>&nbsp" + ventrate + "</td>" +
                    "<td rowspan=" + 5 + ">&nbsp&nbsp&nbsp&nbsp</td>" +
                    "<td rowspan=" + 5 + ">" + diagnosticText + "</td>" +
                    "</tr>" +
                    "<tr>" +
                    "<td>Age:</td>" + "<td>&nbsp" + age + "</td>" +
                    "<td>&nbsp&nbsp&nbsp&nbspPR Interval:</td>" + "<td>&nbsp" + print + "</td>" +
                    "</tr>" +
                    "<tr>" +
                    "<td>Gender:</td>" + "<td>&nbsp" + gender + "</td>" +
                    "<td>&nbsp&nbsp&nbsp&nbspQRS Duration:</td>" + "<td>&nbsp" + qrsdur + "</td>" +
                    "</tr>" +
                    "<tr>" +
                    "<td>Patient Id:</td>" + "<td>&nbsp" + patientId + "</td>" +
                    "<td>&nbsp&nbsp&nbsp&nbspQT/QTc:</td>" + "<td>&nbsp" + qtatc + "</td>" +
                    "</tr>" +
                    "<tr>" +
                    "<td>Acquisition DateTime:</td>" + "<td>&nbsp" + acquisitionDateTime + "</td>" +
                    "<td>&nbsp&nbsp&nbsp&nbspP-R-T axes:</td>" + "<td>&nbsp" + prtaxes + "</td>" +
                    "</tr>" +
                    "<tr><td></td><td></td><td>Referred by:&nbsp" + referringPhysician + "&nbsp&nbsp" +
                    "Confirmed by:&nbsp" + confirmedPhysician + "</td></tr>" +
                    "</table>" +
                    "</div></div>";
                
                var heightOfImageViewerDiv = $("#" + divId).height();
                var widthOfImageViewerDiv = $("#" + divId).width();
                $("#" + divId).html(jasonDataDiv);
                $("#" + divId).height(heightOfImageViewerDiv);
                $("#" + divId).width(widthOfImageViewerDiv);
                
                var heightOfEcgDataDiv = $("#ecgData_" + divId).height();
                $("#" + divId).css("overflow", "auto");
                $("#" + divId).css("background", "white");
                var imageEcgDivId = "imageEcgDiv" + divId;
                var jImageEcgDiv = "<div id='" + imageEcgDivId + "' align='center' style='background:white;float: left;' ></div>";
                $("#" + divId).append(jImageEcgDiv);
                $('<input>').attr({
                    type: 'hidden',
                    id: 'imageEcgHidden' + divId,
                    name: 'bar'
                }).appendTo($("#" + divId));
                document.getElementById("imageEcgHidden" + divId).value = url;
                var myCanvas = document.createElement("canvas");
                myCanvas.setAttribute("id", "imageEcgCanvas" + divId);
                var context = myCanvas.getContext("2d");
                myCanvas.style.background = "white";
                // load image from data url
                var imageObj = new Image();
                imageObj.src = url;
                imageObj.isMedian = (jsonData.isMedian === undefined ? false : jsonData.isMedian);
                var heigtOfEcgImage = $("#" + divId).height() - $("#ecgData_" + divId).height();
                $("#" + imageEcgDivId).height(heigtOfEcgImage);
                $("#" + imageEcgDivId).width($("#" + divId).width());
                //myCanvas.height = $("#imageEcgDiv").height();

                imageObj.onload = function() {

                    //myCanvas.width = imageObj.width;
                    //myCanvas.height = imageObj.height;
                    if(urlParameters.ImageUid !== undefined){
                        updateCacheIndicatorIconAndCountForECG(urlParameters.ImageUid, "green");
                    }
                    var seriesLayout = dicomViewer.viewports.getViewport(divId);
                    var imageRender = seriesLayout.getImageRender("ecgData");
                    imageRender.ecgData = {
                        imageObject : imageObj,
                        width : imageObj.width,
                        height : imageObj.height
                    };
                    var tempScaleValue = 1;
                    //if(!flag){                        

                    imageRender.isMedian = imageObj.isMedian;
                    imageRender.applyOrRevertDisplaySettings(undefined, false, false);
                    var jImageEcgDiv = document.getElementById(imageEcgDivId);
                    var level = imageRender.ecgScalepreset;

                    if(seriesLayout.ecgZoomProperty) {
                        level = seriesLayout.ecgZoomProperty.level;
                    }
                    dicomViewer.tools.updateZoomLevelSettings(level+"_zoom");
                    switch (level) {
                        case 0: //Set Zoom level to 100%
                            tempScaleValue = 1;

                            break;
                        case 1: //Set Zoom level to Window (widht and Height)
                            tempScaleValue = Math.min((jImageEcgDiv.offsetHeight - 4) / imageObj.height, jImageEcgDiv.offsetWidth / imageObj.width);

                            break;
                        case 2: //Set Zoom level Window to Window width
                            tempScaleValue = jImageEcgDiv.offsetWidth / imageObj.width;

                            break;
                        case 3: //Set Zoom level Window to Window height
                            tempScaleValue = jImageEcgDiv.offsetHeight / imageObj.height;

                            break;
                        case 6: //Set Custom Zoom level
                            tempScaleValue = seriesLayout.ecgZoomProperty.customValue/100;
                            break;
                    }
                    if (tempScaleValue > 1) tempScaleValue = Math.max(1, tempScaleValue - 0.05);
                    myCanvas.width = imageObj.width * tempScaleValue;
                    myCanvas.height = imageObj.height * tempScaleValue;

                    tempScaleValue = tempScaleValue.toFixed(2);
                    imageRender.tempEcgScale = tempScaleValue

                    context.scale(tempScaleValue, tempScaleValue);
                    context.drawImage(imageObj, 0, 0);

                    var imageData = context.getImageData(0, 0, myCanvas.width, myCanvas.height);
                    var ecgParamerts = seriesLayout.preferenceInfo.getECGParameters()
                    if (!flag) {
                        seriesLayout.preferenceInfo.addECGParameters("GridType", "1");
                        seriesLayout.preferenceInfo.addECGParameters("GridColor", "0");
                        seriesLayout.preferenceInfo.addECGParameters("SignalThickness", "1");
                        seriesLayout.preferenceInfo.addECGParameters("Gain", "1");
                        seriesLayout.preferenceInfo.addECGParameters("DrawType", "8");
                    }

                    seriesLayout.setEcgCanvas(imageData);
                    var imageUid = seriesLayout.getImageRender("ecgData").getImageUid();
                    var horizontalCaliper = dicomViewer.getHorizontalCaliper(imageUid);
                    if (horizontalCaliper != undefined) {
                        dicomViewer.redrawBothCaliper(seriesLayout);
                    }
                };

                $("#" + imageEcgDivId).append(myCanvas);
            }
        }

        request.open("GET", url, false);
        request.send();
    }

    function loadCaliper() {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if (!seriesLayout.isCaliperEnable) {
            dicomViewer.redrawBothCaliper(seriesLayout);
        }
    }

    function gridType(type, value) {
        urlPram.ImageUid = getActiveLayoutImageUid();
        var gridTypeUrl = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue());
        updatePreference("GridType", value, type);
        loadECGandSavePreference(gridTypeUrl);
        /* loadEcg(urlPram, getCurrentSeriesLayoutDivID(), gainUrl, true);
        setChangedValues();*/
    }

    function gridColor(color, value) {
        urlPram.ImageUid = getActiveLayoutImageUid();
        var gridcolor = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue());
        updatePreference("GridColor", value, color);
        loadECGandSavePreference(gridcolor);
       /* loadEcg(urlPram, getCurrentSeriesLayoutDivID(), gainUrl, true);
        setChangedValues();*/
    }

    /**
     * To get the signal type value for the selected lead type
     * @param {Boolean} format - (it can be 1,2,4,8,16)
    */ 
    function getLeadValue(format) {
        var leadDefault = {
            "3x41Value" : "II",
            "3x43one" : "II",
            "3x43two" : "V2",
            "3x43three" : "V5"
        };
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var layoutDivId = seriesLayout.getSeriesLayoutId();
        var leadObject = leadTypeObject[layoutDivId];
        //Updating the lead object values for the updated signal type
        leadObject = $.extend({}, leadDefault, leadObject);
        if (format == 4) {
            return leadObject["3x41Value"];
        } else if(format == 8) {
            return leadObject["3x43one"] + '|' + leadObject["3x43two"] + '|' + leadObject["3x43three"];
        } else {
            return "";
        }
        setChangedValues();
    }

    function leadFormat(format, value) {
        urlPram.ImageUid = getActiveLayoutImageUid();
        var leadFormatUrl = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue(format));
        updatePreference("LeadFormat", value, format);
        loadECGandSavePreference(leadFormatUrl);
       /* loadEcg(urlPram, getCurrentSeriesLayoutDivID(), gainUrl, true);
        setChangedValues();*/
    }

    function gain(gain, value) {
        urlPram.ImageUid = getActiveLayoutImageUid();
        var gainUrl = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue());
        updatePreference("Gain", value, gain);
        loadECGandSavePreference(gainUrl);
       /* loadEcg(urlPram, getCurrentSeriesLayoutDivID(), gainUrl, true);
        setChangedValues();*/
    }

    function thickness(thickness, value) {
        urlPram.ImageUid = getActiveLayoutImageUid();
        var thicknessUrl = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue());
        updatePreference("SignalThickness", value, thickness);
        loadECGandSavePreference(thicknessUrl);
       /* loadEcg(urlPram, getCurrentSeriesLayoutDivID(), thicknessUrl, true);
        setChangedValues();*/
      
    }
    
     function loadECGandSavePreference(url){
        isToUseSavedValue = false;
        loadEcg(urlPram, getCurrentSeriesLayoutDivID(), url, true);
       
        var imageUID = urlPram.ImageUid;
        var viewportTemp = dicomViewer.getActiveSeriesLayout();
        var ecgPreferenceValue = viewportTemp.preferenceInfo.preferenceData;
        var ecgpreferenceType = viewportTemp.preferenceInfo.selectedEcgFormat;

        setECGPreferenceType(imageUID, ecgpreferenceType);
        setECGPreferenceValue(imageUID, ecgPreferenceValue);
        
        isToUseSavedValue = true;
    }

    function getECGPreferenceValue(imageUID) {
        return ecgPreferenceValue[imageUID];
    }

    function setECGPreferenceValue(imageUID, preferenceValue) {
        ecgPreferenceValue[imageUID] = preferenceValue;
    }
    
     function getECGPreferenceType(imageUID) {
        return ecgPreferenceType[imageUID];
    }

    function setECGPreferenceType(imageUID, preferenceType) {
        ecgPreferenceType[imageUID] = preferenceType;
    }
    
    function removeSavedECGPreference() {
        for(var key in ecgPreferenceType){
                delete ecgPreferenceType[key];  
        }
        for(var key in ecgPreferenceValue){
                delete ecgPreferenceValue[key];  
        } 
        dicomViewer.removeAllCaliperStatus();
    }
    
    function setECGCacheDetails(imageUID, divID) {
        ecgCacheDetails[imageUID] = divID;
    }

    function getECGCacheDetails(imageUID) {
        ecgCacheDetails[imageUID];
    }

    function changeNullToEmpty(value) {
        if (value == undefined || value == null) {
            return "";
        }
        return value;
    }

    function getActiveLayoutImageUid() {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var render = seriesLayout.getImageRender("ecgData")
        return render.imageUid;
    }


    /**
     * Update the ECG preference information. This information will be maintain at Series Level.
     */
    function updatePreference(preferenceType, value, type) {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        switch (preferenceType) {
            case "GridType":
                $("#none").parent().css("background", "");
                $("#onemm").parent().css("background", "");
                $("#fivemm").parent().css("background", "");
                $("#" + value).parent().css("background", "#868696");

                seriesLayout.preferenceInfo.preferenceData.gridType = value;
                seriesLayout.preferenceInfo.addECGParameters("GridType", type);
                break;
            case "GridColor":
                $("#redGrid").parent().css("background", "");
                $("#greenGrid").parent().css("background", "");
                $("#blueGrid").parent().css("background", "");
                $("#blackGrid").parent().css("background", "");
                $("#greyGrid").parent().css("background", "");
                $("#" + value).parent().css("background", "#868696");

                seriesLayout.preferenceInfo.setGridColor(value);
                seriesLayout.preferenceInfo.addECGParameters("GridColor", type);
                break;
            case "LeadFormat":
                $("#threebyfour").parent().css("background", "");
                $("#threebyfourplusone").parent().css("background", "");
                $("#threebyfourplusthree").parent().css("background", "");
                $("#sixbytwo").parent().css("background", "");
                $("#twelvebyone").parent().css("background", "");
                $("#averagecomplex").parent().css("background", "");
                $("#" + value).parent().css("background", "#868696");

                seriesLayout.preferenceInfo.setLeadFormat(value);
                seriesLayout.preferenceInfo.addECGParameters("DrawType", type);
                break;
            case "Gain":
                $("#fivemmgain").parent().css("background", "");
                $("#tenmmgain").parent().css("background", "");
                $("#twentymmgain").parent().css("background", "");
                $("#fourtymmgain").parent().css("background", "");
                $("#" + value).parent().css("background", "#868696");

                seriesLayout.preferenceInfo.setGain(value);
                seriesLayout.preferenceInfo.addECGParameters("Gain", type);
                break;
            case "SignalThickness":
                $("#onethickness").parent().css("background", "");
                $("#twothickness").parent().css("background", "");
                $("#threethickness").parent().css("background", "");
                $("#" + value).parent().css("background", "#868696");

                seriesLayout.preferenceInfo.setSignalThickness(value);
                seriesLayout.preferenceInfo.addECGParameters("SignalThickness", type);
                break;
        }

        // Update the ECG preference in series level
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        if(activeSeriesLayout !== undefined && activeSeriesLayout !== null) {
            var imageRender = activeSeriesLayout.getImageRender("ecgData");
            if(imageRender !== undefined && imageRender !== null) {
                if(activeSeriesLayout !== undefined) {
                    imageRender.applyOrRevertDisplaySettings(undefined, undefined, undefined, true);       
                }
            }
        }
    }

    function changeNullToEmpty(value) {
        if (value == undefined || value == null) {
            return "";
        }
        return value;
    }
    
    /**
     * Get the corresponding Series Layout id.
     */
    function getCurrentSeriesLayoutDivID() {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();

        return seriesLayout.getSeriesLayoutId();
    }

    function updateCacheIndicatorIconAndCountForECG(imageUID, indicatorColor){
       if(ecgCacheDetails[imageUID] == undefined) {
            ecgRenderedCount++;
            var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
            if(activeSeriesLayout !== null && activeSeriesLayout !== undefined) {
                setECGCacheDetails(imageUID, activeSeriesLayout.seriesLayoutId);     
            }
        }

        else{
            for(var key in ecgCacheDetails){
                if( key != imageUID){
                    ecgRenderedCount++;
                    setECGCacheDetails(imageUID, dicomViewer.getActiveSeriesLayout().seriesLayoutId); 
                }else{
                    return;
                }
            }
        }

        $("#cachemanager_progress").trigger("image_cache_updated",  dicomViewer.imageCache.getCacheInfo());
        updateThumbnailCacheIndication(imageUID, indicatorColor);
    }

    /**
     * While Chnaging the ECG prefernce values from the toolbar
     * enable or disable the 3x4+3 or 3x4+1 input values
     **/
    function changeECGLedType(value) {
        if (value === "3x4+3") {
            $("#3x41Value").prop("disabled", true);
            $("#3x43one").prop("disabled", false);
            $("#3x43two").prop("disabled", false);
            $("#3x43three").prop("disabled", false);
        } else {
            $("#3x41Value").prop("disabled", false);
            $("#3x43one").prop("disabled", true);
            $("#3x43two").prop("disabled", true);
            $("#3x43three").prop("disabled", true);
        }
        setConfiguredLeadType(value);
    }

    /**
    * Initialize the ECG Preference with default values.
    */
    function Refresh(){
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        urlPram.ImageUid = getActiveLayoutImageUid();
        updatePreference("GridType", "onemm", "1");
        updatePreference("GridColor", "redGrid", "0");
        updatePreference("LeadFormat", "threebyfourplusthree", "8");
        updatePreference("Gain", "tenmmgain", "1");
        updatePreference("SignalThickness", "onethickness", "1");
        dicomViewer.RevertCaliper();
        var refreshUrl = dicomViewer.getEcgMenuUrl(urlPram.ImageUid, getLeadValue());
        loadECGandSavePreference(refreshUrl);
    }

    /**
    * Clear ECG cache details 
    */
    function ClearECGCacheDetails(imageUid){
        try{
            if(imageUid !== undefined){
              for(var key in ecgCacheDetails){
                if( key === imageUid){
                  ecgRenderedCount--;
                  delete ecgCacheDetails[imageUid];
                }
              }
             $("#cachemanager_progress").trigger("image_cache_updated",  dicomViewer.imageCache.getCacheInfo());
            }
        }
        catch(e)
        { }
    }

    function setConfiguredLeadType(leadType){
        configuredLeadType = leadType;
    }

    function getConfiguredLeadType(){
        return configuredLeadType;
    }

    function updateECGPreferenceDropDown()
    {
        var leadtype = getConfiguredLeadType();
        changeECGLedType(leadtype);
    }

    dicomViewer.loadEcg = loadEcg;
    dicomViewer.gridType = gridType;
    dicomViewer.gridColor = gridColor;
    dicomViewer.leadFormat = leadFormat;
    dicomViewer.gain = gain;
    dicomViewer.thickness = thickness;
    dicomViewer.changeNullToEmpty = changeNullToEmpty;
    dicomViewer.loadCaliper = loadCaliper;
    dicomViewer.changeECGLedType = changeECGLedType;
    dicomViewer.removeSavedECGPreference = removeSavedECGPreference;
    dicomViewer.Refresh = Refresh;
    dicomViewer.ClearECGCacheDetails = ClearECGCacheDetails;
    dicomViewer.updateECGPreferenceDropDown = updateECGPreferenceDropDown;

    return dicomViewer;
}(dicomViewer));var angleDefaults = [0, 90, 180, 270];
var orientationDefaults = [
    {
        rotate: 0,
        mirror: 0,
        rotateLeft: 1,
        rotateRight: 3,
        flipHorz: 4,
        flipVert: 6,
        left: 0,
        right: 1,
        top: 2,
        bottom: 3
    }, // 0 --> Rotate 0

    {
        rotate: 3,
        mirror: 0,
        rotateLeft: 2,
        rotateRight: 0,
        flipHorz: 7,
        flipVert: 5,
        left: 2,
        right: 3,
        top: 1,
        bottom: 0
    }, // 1 --> Rotate 270
    {
        rotate: 2,
        mirror: 0,
        rotateLeft: 3,
        rotateRight: 1,
        flipHorz: 6,
        flipVert: 4,
        left: 1,
        right: 0,
        top: 3,
        bottom: 2
    }, // 2 --> Rotate 180
    {
        rotate: 1,
        mirror: 0,
        rotateLeft: 0,
        rotateRight: 2,
        flipHorz: 5,
        flipVert: 7,
        left: 3,
        right: 2,
        top: 0,
        bottom: 1
    }, // 3 --> Rotate 90

    {
        rotate: 0,
        mirror: 1,
        rotateLeft: 5,
        rotateRight: 7,
        flipHorz: 0,
        flipVert: 2,
        left: 1,
        right: 0,
        top: 2,
        bottom: 3
    }, // 4 -> Rotate 0 + Horizontal Flip
    {
        rotate: 3,
        mirror: 1,
        rotateLeft: 6,
        rotateRight: 4,
        flipHorz: 3,
        flipVert: 1,
        left: 2,
        right: 3,
        top: 0,
        bottom: 1
    }, // 5 -> Rotate 270 + Vertical Flip
    {
        rotate: 2,
        mirror: 1,
        rotateLeft: 7,
        rotateRight: 5,
        flipHorz: 2,
        flipVert: 0,
        left: 0,
        right: 1,
        top: 3,
        bottom: 2
    }, // 6 -> Rotate 180 + Horizontal Flip
    {
        rotate: 1,
        mirror: 1,
        rotateLeft: 4,
        rotateRight: 6,
        flipHorz: 1,
        flipVert: 3,
        left: 3,
        right: 2,
        top: 1,
        bottom: 0
    }]; // 7 -> Rotate 90 + Vertical Flip
var previousLayoutSelection = "";
//Function to generate a guid
function S4() {
    return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
}
function guid() {
    return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4()
            + S4() + S4());
}
function ImageRenderer(appendTo,seriesLevelDivId) {

    this.imagePromise;
    this.uid = guid();
    this.anUIDs;
    this.invertFlag = false;
    this.zoomFlag = false;
    this.tScaleValue = 1;
    this.isPresetDefault = false;

    //scale value use to display the zoom precentage in overylay
    //this.scaleValue changes in renderImage, doZoom, refresh and revert methods
    this.scaleValue;

    this.seriesLevelDivId = seriesLevelDivId;
    this.parentElement = appendTo;
    this.renderWidget = document.createElement("canvas");
    this.renderWidget.setAttribute("id", this.uid);

    this.renderWidgetLayer = document.createElement("canvas");
    this.renderWidgetLayer.style.zIndex = "10";
    this.renderWidgetLayer.style.position = "absolute";

    this.overlayCanvas = document.createElement("canvas");
    this.overlayCanvas.style.zIndex = "2";
    this.overlayCanvas.style.position = "absolute";

    var appendToElement = $('#' + appendTo);
    var appendToOuterWidth = appendToElement.outerWidth();
    var appendToOuterHeight = appendToElement.outerHeight();

    var wPadding = appendToOuterWidth - appendToElement.width();
    var hPadding = appendToOuterHeight - appendToElement.height();

    this.viewportWidth = appendToOuterWidth;
    this.viewportHeight = appendToOuterHeight;

    this.renderWidget.width = this.viewportWidth - wPadding - 5;
    this.renderWidget.height = this.viewportHeight - hPadding - 5;
    this.renderWidgetLayer.width = this.viewportWidth - wPadding;
    this.renderWidgetLayer.height = this.viewportHeight - hPadding;
    this.overlayCanvas.width = this.viewportWidth - 5;
    this.overlayCanvas.height = this.viewportHeight - 5;

    this.renderWidget.style.margin = 5 + 'px';

    appendToElement.append(this.renderWidget);
    appendToElement.append(this.renderWidgetLayer);
    appendToElement.append(this.overlayCanvas);

    this.renderWidget.style.zIndex = "1";
    this.renderWidget.style.position = "absolute";
    this.touchEvent = false;
    this.gestureEvent = false;
    this.seriesIndex = -1;
    this.imageIndex = -1;
    this.imageUid = "";
    this.selfReference = this;
    this.presentationState = undefined;
    this.headerInfo = undefined;
    //Set default as window width
    this.ecgScalepreset = 2;
    this.tempEcgScale = 0;
    //Added for Zoom Feature
    var ctx = this.renderWidget.getContext('2d');
    this.imageCanvas = document.createElement("canvas");
    this.imageCanvas.canvasId = this.parentElement;
    trackTransforms(ctx);
    this.renderWidgetCtx = ctx;
    this.validDoubleClick = false;

    var addMouseHandler = function handleMouseEvent(imageRenderer) {
        var self = imageRenderer;
        var lastClickTimeStamp;
        var isStackNavigation = false;
        var lastMousePosition =
            {
                ptX : undefined,
                ptY : undefined,
                imageIndex : undefined,
                frameIndex : undefined,
                useStartPosition : false
            }

        this.handleEvent = function(evt) {
            if(self.seriesLevelDivId !== dicomViewer.getActiveSeriesLayout().getSeriesLayoutId()) return;
            displayCompressinToolTip(evt,self);
            var tool = dicomViewer.mouseTools.getActiveTool();
            if (tool) {
                tool.setActiveImageRenderer(self);
                if (evt.type === "mouseup" && (evt.which === 3 || (evt.which === 1 &&  dicomViewer.mouseTools.getToolName() === TOOLNAME_WINDOWLEVEL_ROI))) {
                    tool.hanleMouseUp(evt);
                }
                else if (evt.type === "mousedown" && (evt.which === 1 || dicomViewer.mouseTools.getToolName() === TOOLNAME_WINDOWLEVEL_ROI)) {
                    //Calculating the time difference in the two consecutive clicks to determine whether it is double-click event or not
                    if(lastClickTimeStamp == null) {
                        lastClickTimeStamp = 200;
                    }
                    var diff;
                    if(lastClickTimeStamp != evt.timeStamp) {
                        diff = evt.timeStamp - lastClickTimeStamp;
                    }
                    //If the two clicks time difference is less than 300ms then considering it as double-click event
                    if(diff > 300) {
                        tool.hanleMouseDown(evt);
                    } else {
                        tool.hanleMouseMove(evt, true);
                        tool.hanleMouseDown(evt);
                    }
                    lastClickTimeStamp = evt.timeStamp;
                } else if (evt.type === "mousedown"  && evt.which === 2) {
                    lastMousePosition.ptX = undefined;
                    lastMousePosition.ptY = undefined;
                    lastMousePosition.useStartPosition = false;
                } else if (evt.type === "mouseup"  && evt.which === 1) {
                    tool.hanleMouseUp(evt);
                } else if (evt.type === "mouseup"  && evt.which === 2) {
                    if (isStackNavigation) {
                        isStackNavigation = false;
                        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getDefaultTool());
                        $('#viewport_View').css('cursor', 'default');
                    } else {
                        dicomViewer.scroll.toggleCineRunning();
                    }
                } else if (evt.type === "mouseover") {
                    tool.hanleMouseOver(evt);
                } else if (evt.type === "mousemove" && dicomViewer.mouseTools.getToolName() === TOOLNAME_WINDOWLEVEL_ROI) {
                    tool.hanleMouseMove(evt);
                } else if (evt.type === "mouseout") {
                    tool.hanleMouseOut(evt);
                } else if (evt.type === "mousemove" && evt.buttons === 4) {
                    if (lastMousePosition.ptX === undefined || lastMousePosition.ptY === undefined) {
                        lastMousePosition.ptX = evt.clientX;
                        lastMousePosition.ptY = evt.clientY;
                        lastMousePosition.useStartPosition = false;
                    } else {
                        var navigatePos = getNavigation(lastMousePosition, evt);
                        if (navigatePos !== undefined) {
                            isStackNavigation = true;
                            $('#viewport_View').css('cursor','url(images/navigate.cur), auto');
                            dicomViewer.scroll.moveToNextOrPreviousImage(!navigatePos.moveToNext, undefined, navigatePos, lastMousePosition.useStartPosition);
                            if (lastMousePosition.useStartPosition === false) {
                                var seriesLayout = dicomViewer.getActiveSeriesLayout();
                                var imageAndFrameIndex = dicomViewer.scroll.getCurrentImageAndFrameIndex(!navigatePos.moveToNext, seriesLayout);
                                lastMousePosition.imageIndex = imageAndFrameIndex[0];
                                lastMousePosition.frameIndex = imageAndFrameIndex[1];
                                lastMousePosition.useStartPosition = true;
                            }
                        } else {
                            lastMousePosition.ptX = undefined;
                            lastMousePosition.ptY = undefined;
                            lastMousePosition.frameIndex = undefined;
                            lastMousePosition.imageIndex = undefined;
                            lastMousePosition.useStartPosition = false;
                            isStackNavigation = false;
                        }
                    }
                } else if (evt.type === "mousemove" && (evt.buttons === 1 && 
                                                        (dicomViewer.mouseTools.getToolName() === "Zoom"|| 
                                                         dicomViewer.mouseTools.getToolName() === "WindowLevel" || 
                                                         dicomViewer.mouseTools.getToolName() === "pointMeasurement" || 
                                                         dicomViewer.mouseTools.getToolName() === "Pan" || 
                                                         dicomViewer.mouseTools.getToolName() === "lineMeasurement" || 
                                                         dicomViewer.mouseTools.getToolName() === "angleMeasurement" || 
                                                         dicomViewer.mouseTools.getToolName() === 'rectangleMeasurement' || 
                                                         dicomViewer.mouseTools.getToolName() === 'ellipseMeasurement' || 
                                                         dicomViewer.mouseTools.getToolName() === 'mitralMeanGradientMeasurement' ||
                                                         dicomViewer.mouseTools.getToolName() === TOOLNAME_DEFAULTTOOL ||
                                                         dicomViewer.mouseTools.getToolName() === TOOLNAME_PEN || 
                                                        dicomViewer.mouseTools.getToolName() === TOOLNAME_SHARPENTOOL))) {
                    tool.hanleMouseMove(evt);
                } else if (evt.type === "mousemove" && evt.buttons === 0 && 
                           (dicomViewer.mouseTools.getToolName() === 'traceMeasurement' ||
                            dicomViewer.mouseTools.getToolName() === 'volumeMeasurement' || 
                            dicomViewer.mouseTools.getToolName() === 'lineMeasurement' || 
                            dicomViewer.mouseTools.getToolName() === 'mitralMeanGradientMeasurement'||
                            dicomViewer.mouseTools.getToolName() === 'angleMeasurement' || 
                            dicomViewer.mouseTools.getToolName() === 'rectangleMeasurement')) {
                    tool.hanleMouseMove(evt);
                } else if (evt.type === "dblclick" && evt.which === 1) {
                    isCineEnabled(true);
                    evt.preventDefault();
                    dicomViewer.mouseTools.setPreviousTool(dicomViewer.mouseTools.getActiveTool());
                    tool.hanleDoubleClick(evt);
                    doubleClick();
                    self.doClickDefaultTool();

                } /*else if (evt.type === "mousewheel" && dicomViewer.mouseTools.getToolName() === 'Zoom') {
					dicomViewer.tools.updateZoomLevelSettings(-1);
					tool.hanleMouseWheel(evt);
				}*/ else if (evt.type === "DOMMouseScroll" && dicomViewer.mouseTools.getToolName() == 'zoom') {
                    tool.hanleMouseWheel(evt);
                } else if (evt.type === "touchmove") {
                    if (this.touchEvent && !this.gestureEvent) {
                        if(evt.touches.length == 1) {
                            //For the mobile devices, if the selected tool is zoom then on moving one finger over the selected viewport it will pan the image
                            if(dicomViewer.mouseTools.getToolName() == 'Zoom') {
                                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getPanTool());
                            }

                            evt.preventDefault();
                            tool.hanleMouseMove(evt);
                        } else if(evt.touches.length == 2) {
                            //For two touces automatically it will zoom even without selecting the zoom tool from the toolbar
                            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getZoomTool());
                            tool.setActiveImageRenderer(self);
                            tool.hanleMouseMove(evt);
                        }
                    }
                } else if (evt.type === "touchstart") {
                    this.touchEvent = true;
                    if (evt.touches.length === 1) {
                        tool.hanleMouseDown(evt);
                        //Calculating the time difference in the two consecutive clicks to determine whether it is double-click gesture or not
                        if(lastClickTimeStamp != evt.timeStamp) {
                            var diff = evt.timeStamp - lastClickTimeStamp;
                        }
                        //If the two clicks time difference is less than 200ms then considering it as double-click gesture
                        if(diff < 200) {
                            this.validDoubleClick = true;
                        }
                        lastClickTimeStamp = evt.timeStamp;
                    } else if(evt.touches.length === 2) {
                        firstTouchPos = evt.touches[0].clientX;
                        secondTouchPos = evt.touches[1].clientX;
                        diffTwoTouches = evt.touches[1].clientX - evt.touches[0].clientX;
                        tool.setActiveImageRenderer(self);
                        tool.hanleMouseDown(evt);
                    }
                } else if (evt.type === "touchend") {
                    if(this.validDoubleClick) {
                        isCineEnabled(true);
                        evt.preventDefault();
                        tool.hanleDoubleClick();
                        doubleClick();
                        this.validDoubleClick = false;
                    } else {
                        evt.preventDefault();
                        tool.hanleMouseUp(evt);
                        this.touchEvent=false;
                    }
                }
            }
        };
        var imageRenderAddEventListener = imageRenderer.renderWidgetLayer;
        var handleEventObj = this.handleEvent;
        imageRenderAddEventListener.addEventListener("mouseup", handleEventObj);
        imageRenderAddEventListener.addEventListener("mousemove", handleEventObj);
        imageRenderAddEventListener.addEventListener("mouseover", handleEventObj);
        imageRenderAddEventListener.addEventListener("mouseout", handleEventObj);
        imageRenderAddEventListener.addEventListener("mousedown", handleEventObj);
        imageRenderAddEventListener.addEventListener("dblclick", handleEventObj);
        imageRenderAddEventListener.addEventListener("touchstart", handleEventObj);
        imageRenderAddEventListener.addEventListener("touchmove", handleEventObj);
        imageRenderAddEventListener.addEventListener("touchend", handleEventObj);
        imageRenderAddEventListener.addEventListener('DOMMouseScroll',handleEventObj);
        imageRenderAddEventListener.addEventListener('mousewheel',handleEventObj);
    };
    addMouseHandler(this);
};

/*Initiate the image render*/
ImageRenderer.prototype.init = function(anUIDs, seriesIndex, imageIndex) {
    this.seriesIndex = seriesIndex;
    this.imageIndex = imageIndex;
    this.anUIDs = anUIDs;
    var aUIDs = anUIDs.split("*");
    this.imageUid = aUIDs[0];
    var frameIndex = aUIDs[1];
    dicomViewer.renderer.setImageRenderer(this.imageUid+"_"+frameIndex,this);
};

ImageRenderer.prototype.loadImageRenderer = function(imagePromise,imagCanvasPresentation,studyUid)
{
    // Added frame index with imaage Id to get image from cache
    /*var imagePromise = dicomViewer.imageCache.getImagePromise(imageUid+frameIndex);
	if(imagePromise === undefined)
	{
		imagePromise = dicomViewer.loadAndCacheImage(imageUid,frameIndex);
	}*/


    if(imagePromise != undefined)
        this.imagePromise = imagePromise;
    this.presentationState = undefined;
    if(this.imagePromise==undefined)
    {
        this.imagePromise =dicomViewer.imageCache.getImagePromise( imagCanvasPresentation.imageUid+"_"+imagCanvasPresentation.frameNumber);
    }

    var imageCanvas = null;
    this.imagePromise.then(function(image) {
        imageCanvas = image;
    });
    dicomViewer.imageCache.setImageData(imageCanvas, this.parentElement);

    var renderer = undefined;
    if(isFullScreenEnabled){
        var sereiesLayout = dicomViewer.getActiveSeriesLayout();
        var activeSeriesLayoutId = sereiesLayout.getSeriesLayoutId();
        var activeViewport = dicomViewer.getActiveSeriesLayout();
        renderer = activeViewport.getImageRender(activeSeriesLayoutId+ "ImageLevel0x0");
    }

    if( this.presentationState == undefined ||  this.presentationState == null){
        this.presentationState = new Presentation();
        if (imageCanvas === undefined || imageCanvas === null) {
            return;
        }
        if(imageCanvas.presentation != null || imageCanvas.presentation != undefined)
        {
            imageCanvas.presentation.copy(this.presentationState );
            this.presentationState.setWindowingdata(imageCanvas.presentation.getWindowCenter(),imageCanvas.presentation.getWindowWidth());
        }
    }

    dicomViewer.renderer.removeImageRenderer(this.imageUid+"_"+imageCanvas.frameNumber);
    var presentation = this.presentationState;//imageCanvas.presentation;
    //this.presentationState = presentation;
    //image presemtation is already exist change the WW and WC based on that
    if(imagCanvasPresentation != undefined) {
        this.imagePromise = dicomViewer.imageCache.getImagePromise(imagCanvasPresentation.imageUid +"_"+ (imagCanvasPresentation.frameNumber));
        this.imageUid = imagCanvasPresentation.imageUid;
        this.anUIDs = imagCanvasPresentation.imageUid +"*"+ (imagCanvasPresentation.frameNumber);
        this.imageIndex = (imagCanvasPresentation.imageIndex == undefined) ? this.imageIndex: imagCanvasPresentation.imageIndex;
        presentation.setWindowingdata(imagCanvasPresentation.lastAppliedwindowCenter,imagCanvasPresentation.lastAppliedWindowWidth);
        presentation.setOrientation(imagCanvasPresentation.presentation.getOrientation());
        this.applyOrRevertDisplaySettings(presentation, false, false, undefined);
    }
    else {
        // Apply the display settings
        this.applyOrRevertDisplaySettings(presentation, true, false, undefined);
    }

    var dicominfo = imageCanvas.dicominfo;
    this.headerInfo = dicominfo;
    var row = dicominfo.getRows();
    var column = dicominfo.getColumns();
    presentation.currentPreset = 0;
    isRevert = true;
    if((imageCanvas.windowCenter != presentation.windowCenter ||
        imageCanvas.windowWidth != presentation.windowWidth
        || imageCanvas.invert != presentation.invert) && imagCanvasPresentation == undefined )
    {
        if(imageCanvas.invert != presentation.invert)
        {
            var invertData = !presentation.invert;
            presentation.setInvertFlag(invertData);
            imageCanvas.presentation.invert = invertData;
        }
        presentation.setWindowingdata(imageCanvas.windowCenter,imageCanvas.windowWidth);
        //dicomViewer.updateImage(this.imageCanvas,imageCanvas,presentation);
    }
    if(dicominfo.imageInfo.numberOfFrames < 2 && dicominfo.imageInfo.modality !== "US" && dicominfo.imageInfo.imageType != IMAGETYPE_JPEG) {
        imageCanvas.isWLApplied = false;
        dicomViewer.updateImage(this.imageCanvas,imageCanvas,presentation);
    }

    var ctx = this.renderWidgetCtx;
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    var scaleFactor = undefined;
    if(renderer != undefined && isFullScreenEnabled){
        scaleFactor = renderer.scaleValue;
        if(scaleFactor != undefined){
            imageCanvas.presentation.zoom = scaleFactor;
            presentation.zoomLevel = renderer.presentationState.zoomLevel;
            imageCanvas.presentation.zoomLevel = renderer.presentationState.zoomLevel;
        }
    }

    if(scaleFactor == undefined){
        scaleFactor = presentation.getZoom();
    }
    var pan = presentation.getPan();
    ctx.translate( this.renderWidget.width/2,this.renderWidget.height/2);

    if (presentation.isScaleToFitMode())
    {
        scaleFactor = this.getZoomFactor(1, row, column);
        presentation.setZoom(scaleFactor);
        imageCanvas.presentation.setPresentationMode("SCALE_TO_FIT");
        this.scaleValue = scaleFactor;
        pan.x = -column/2;
        pan.y= -row/2;
    }
    else if (presentation.getPresentationMode() == "MAGNIFY")
    { //For retaining the zoom value after dbl-click
        imageCanvas.presentation.setZoom(scaleFactor);
        imageCanvas.presentation.setPresentationMode("MAGNIFY");
        this.scaleValue = scaleFactor;
        pan.x = -column/2;
        pan.y= -row/2;
    }

    this.renderImage(true);

    // Apply the zoom
    if(presentation !== undefined) {
        var zoomLevel = undefined;
        if(presentation.zoomLevel !== undefined && presentation.zoomLevel !== -1) {
            zoomLevel = presentation.zoomLevel;
        } else if(imageCanvas.presentation !== undefined && imageCanvas.presentation.zoomLevel === -1) {
            zoomLevel = "6_zoom" + "-" + (parseFloat(imageCanvas.presentation.zoom) * 100).toString();
        }

        if(zoomLevel !== undefined) {
            this.setZoomLevel(zoomLevel);
        }
    }

    // Apply Pan
    this.applyPan();
};

/*Refresh*/
ImageRenderer.prototype.refresh = function(imageToRender, anUIDs,presentationRefreshStatus, imageIndex, seriesIndex, isPlayStudy) {
    this.anUIDs = anUIDs;
    var aUIDs = anUIDs.split("*");
    this.imageUid= aUIDs[0];
    var frameIndex=aUIDs[1];
    this.imageCanvas = document.createElement("canvas");
    this.imageCanvas.canvasId = this.parentElement;
    var seriesLayout = dicomViewer.getActiveSeriesLayout();

    //If the current playing series index and the series index of the next image is not same then considering it change in the series and for the new series the presentation values will be different.
    if(this.seriesIndex !== seriesIndex) {
        presentationRefreshStatus = true;
    }
    this.seriesIndex = seriesIndex;
    this.imageIndex = imageIndex;
    if(imageToRender == null)
    {
        //Load image
        var imagePromise = dicomViewer.imageCache.getImagePromise(this.imageUid+"_"+frameIndex);
        if(imagePromise === undefined)
        {
            imagePromise = dicomViewer.loadAndCacheImage(this.imageUid,frameIndex,seriesIndex);
        }
        this.imagePromise = imagePromise;
    }
    else
    {
        this.imagePromise = imageToRender;
    }

    var viewPortDivId = $('#'+this.parentElement).parent().closest('div').attr('id');

    var render = this;
    this.imagePromise.done(function(image) {
        imageCanvas = image;
    });
    dicomViewer.imageCache.setImageData(imageCanvas, this.parentElement);

    //Viewer is blank(this.presentationState is undefined) while play cine and scroll images
    if( this.presentationState == undefined || this.presentationState == null){
        logger.info("presentation is undefined");
        this.presentationState = new Presentation();
        if (imageCanvas === undefined || imageCanvas === null) {
            return;
        }
        if(imageCanvas.presentation != null || imageCanvas.presentation != undefined)
        {
            imageCanvas.presentation.copy(render.presentationState );
            this.presentationState.setWindowingdata(imageCanvas.presentation.getWindowCenter(),imageCanvas.presentation.getWindowWidth());
            //To avoid panning the images in the viewport while play cine and scroll images
            var ctx =  this.renderWidgetCtx;
            ctx.setTransform(1, 0, 0, 1, 0, 0);
            ctx.translate(this.renderWidget.width/2,this.renderWidget.height/2);
        }
        presentation = this.presentationState;
    }


    if(viewPortDivId == seriesLayout.getSeriesLayoutId())
    {
        if(imageCanvas != null )
        {
            //seriesLayout.setImageIndex(this.imageIndex);
            //seriesLayout.setFrameIndex(imageCanvas.frameNumber);
            //imageCanvas.seriesIndex = this.seriesIndex;
            //imageCanvas.imageIndex = this.imageIndex;
            dicomViewer.setimageCanvasOfViewPort(viewPortDivId,imageCanvas, imageCanvas.presentation);
        };
    }

    var dicominfo = imageCanvas.dicominfo;
    if(!dicominfo) {
        return;
    }
    var row = dicominfo.getRows();
    var column = dicominfo.getColumns();


    var presentation = this.presentationState;//imageCanvas.presentation;
    if(presentation != undefined)
    {
        //presentation = imageCanvas.presentation;
        //this.presentationState = presentation;
        // return;

        var scaleFactor = presentation.getZoom();
        var pan = presentation.getPan();
        if (presentation.isScaleToFitMode())
        {
            scaleFactor = Math.min(this.renderWidget.height / row, this.renderWidget.width / column);
            presentation.setZoom(scaleFactor);
            pan.x = -column/2;
            pan.y= -row/2;
        }

        //When the zoom Flag is false it ill set the defult zoom value
        if(!this.zoomFlag)
        {
            this.scaleValue = scaleFactor;
        }

        //Gets the active viewport
        var layout = dicomViewer.getActiveSeriesLayout();

        //Get all image renderer
        var imageRenders = layout.getAllImageRenders();

        //If the repeat study button is enabled and the next image belongs to next series then applying the last applied window values else for the same series applying the current presentation window level values
        if(isPlayStudy && presentationRefreshStatus) {
            this.presentationState.setWindowingdata(imageCanvas.lastAppliedwindowCenter,imageCanvas.lastAppliedWindowWidth);
        } else {
            this.presentationState.setWindowingdata(presentation.windowCenter,presentation.windowWidth);
        }        
        this.renderImage(true);
        //Falg to check if the passed image renderer is in the active viewport
        var isInActiveViewPort = false;
        var activeRenderer = null;
        for (var iKey in imageRenders)
        {
            if(activeRenderer == null)
            {
                activeRenderer = imageRenders[iKey];
            }
            if( this == imageRenders[iKey])
            {
                isInActiveViewPort = true;
            }
        }
        if(isInActiveViewPort == true)
        {
            dicomViewer.viewports.refreshViewports(this);
        }
    }
};

ImageRenderer.prototype.locationOnScreen= function() {
    var curleft = 0, curtop = 0;
    var obj = this.renderWidget;
    if (obj.offsetParent) {
        do {
            curleft += obj.offsetLeft;
            curtop += obj.offsetTop;
        } while (obj = obj.offsetParent);
        return { x: curleft, y: curtop };
    }
    return undefined;
};

/*Applying preset for images*/
ImageRenderer.prototype.applyPreset = function (preset) {

    var imageCanvas = null;
    this.imagePromise.then(function(image){
        imageCanvas = image;
    });
    var presentation =  this.presentationState;//imageCanvas.presentation;
    presentation.currentPreset = preset;
    switch (parseInt(preset)) {
        case 1:
            presentation.setWindowingdata(imageCanvas.windowCenter,imageCanvas.windowWidth);
            presentation.lookupObj.setInvertData(imageCanvas.invert);
            presentation.invert = imageCanvas.invert;
            this.isPresetDefault = true;
            presentation.windowLevel = 1;
            this.renderImage(false);
            break;

        case 2:
            presentation.setWindowingdata(40,350);
            presentation.windowLevel = 2;
            this.renderImage(false);
            break;

        case 3:
            presentation.setWindowingdata(-600,1500);
            presentation.windowLevel = 3;
            this.renderImage(false);
            break;

        case 4:
            presentation.setWindowingdata(40,80);
            presentation.windowLevel = 4;
            this.renderImage(false);
            break;

        case 5:
            presentation.setWindowingdata(480,2500);
            presentation.windowLevel = 5;
            this.renderImage(false);
            break;

        case 6:
            presentation.setWindowingdata(90,350);
            presentation.windowLevel = 6;
            this.renderImage(false);
            break;

        case 7:
            // for custom window level there are 3 values separated with a "_". Split that and use.
            if(preset.length > 1) {
                var value = preset.split("_");
                presentation.setWindowingdata(parseInt(value[1]),parseInt(value[2]));
                presentation.windowLevel = 7;
                this.renderImage(false);
                break;
            }
                            }

    if(presentation !== undefined) {
        imageCanvas.presentation.setPresetWindowLevelValue(presentation.windowLevel);
    }
};

/* Revert */
ImageRenderer.prototype.revert = function(anUIDs, seriesIndex) {
    //this.init(anUIDs, seriesIndex);
    isCopyAttribute = false;
    var seriesLayout = dicomViewer.getActiveSeriesLayout();
    var imageType = seriesLayout.getImageType();
    this.seriesIndex = seriesIndex;
    this.anUIDs = anUIDs;
    var aUIDs = anUIDs.split("*");
    this.imageUid = aUIDs[0];
    var frameIndex=aUIDs[1];
    var isTraceInComplete = dicomViewer.measurement.isTraceMeasurementEnd();
    var isVolumeComplete = dicomViewer.measurement.isVolumeMeasurementEnd();
    var isAngleComplete = dicomViewer.measurement.isAngleMeasurementEnd();

    //When the trace measurement is incomplete and click the reset button it ill deleted the incomplete
    //trace from the map
    if(isAngleComplete)
    {
        var angleMeasurements = dicomViewer.measurement.getAngleMeasurements(this.imageUid, frameIndex);
        if(angleMeasurements !== undefined)
        {
            delete angleMeasurements[angleMeasurements.length-1];
            dicomViewer.measurement.removeTempdata();
            dicomViewer.measurement.setAngleMeasurementEnd(false);
        }
    }
    //When the trace measurement is incomplete and click the reset button it ill deleted the incomplete
    //trace from the map
    if(isTraceInComplete)
    {
        var traceMeasurements = dicomViewer.measurement.getTraceMeasurements(this.imageUid, frameIndex);
        if(traceMeasurements !== undefined)
        {
            delete traceMeasurements[traceMeasurements.length-1];
            dicomViewer.measurement.removeTempdata();
            dicomViewer.measurement.setTraceMeasurementEnd(false);
        }
    }
    //When the volume measurement is incomplete and click the reset button it ill deleted the incomplete
    //volume from the map
    if(isVolumeComplete)
    {
        var volumeMeasurements = dicomViewer.measurement.getVolumeMeasurements(this.imageUid, frameIndex, seriesLayout.getSeriesLayoutId());
        if(volumeMeasurements !== undefined)
        {
            delete volumeMeasurements[volumeMeasurements.length-1];
            dicomViewer.measurement.setVolumeMeasurementEnd(false);
            dicomViewer.measurement.removeTempdata();
        }
    }
    var imagePromise = dicomViewer.imageCache.getImagePromise(this.imageUid+"_"+frameIndex);
    if(imagePromise === undefined)
    {
        imagePromise = dicomViewer.loadAndCacheImage(seriesLayout.getStudyUid(), this.imageUid,frameIndex,seriesIndex,imageType);
    }

    var presentation;
    var imageCanvas;
    imagePromise.then(function(image){
        imageCanvas = image;
        presentation = image.presentation;
    });

    if(presentation != undefined)
        this.scaleValue = presentation.getZoom();
    this.zoomFlag = false;
    this.applyOrRevertDisplaySettings(undefined, undefined, true, undefined);
    this.updatePanTransform(true);
    this.loadImageRenderer(imagePromise);
};

ImageRenderer.prototype.doStartZoomDrag =function(lastX,lastY){
    var ctx = this.renderWidgetCtx;
    var pt = ctx.transformedPoint(lastX,lastY);
    return pt;
};

/* Apply RGB values */
ImageRenderer.prototype.applyRGB =function(rgbMode){
    var imageCanvas = null;
    var render = this;
    this.imagePromise.then(function(image) {
        imageCanvas = image;
        render.presentationState.setRGBMode(rgbMode);
        dicomViewer.updateImage(render.imageCanvas,imageCanvas, render.presentationState);
        render.drawDicomImage();
    });
}

/* Zoom the image on left mouse scroll based on current mouse pointer */
ImageRenderer.prototype.doZoom =function(clicks,lastX,lastY){

    //	this.presentationState.factor = "zoom"
    var factor = 0;
    var imageCanvas = null;
    this.imagePromise.then(function(image) {
        imageCanvas = image;
    });
    if(clicks > 0) factor = parseFloat(this.scaleValue) + 0.10;
    else factor = parseFloat(this.scaleValue) - 0.10;
    if (factor > 8.0 && this.scaleValue < 8.0) {
        factor = 8.0;
    } else if (factor < 0.05 && this.scaleValue > 0.05) {
        factor = 0.05;
    }
    var tempScaleValue =  parseFloat(factor / this.scaleValue).toFixed(3) ;
    if((factor >= 0.05 || clicks > 0) && (factor <= 8.0 || clicks < 0))
    {
        var ctx = this.renderWidgetCtx;
        var canvasMidPoint = ctx.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);
        ctx.translate(canvasMidPoint.x,canvasMidPoint.y);
        ctx.translate(0,0);
        ctx.scale(tempScaleValue,tempScaleValue);
        ctx.translate(0,0);

        var pt = ctx.transformedPoint(lastX,lastY);
        var canvasEndPoint = ctx.transformedPoint(this.renderWidget.width,this.renderWidget.height);
        var canvasMidPoint = ctx.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);
        var canvasStartPoint = ctx.transformedPoint(0,0);

        /*if( (canvasEndPoint.x < this.renderWidget.width/2 &&
           canvasEndPoint.y < this.renderWidget.height/2) &&
           (canvasStartPoint.x > -this.renderWidget.width/2 &&
           canvasStartPoint.y > -this.renderWidget.height/2) )
        {

            ctx.translate(pt.x,pt.y);
            ctx.scale(tempScaleValue,tempScaleValue);
            ctx.translate(-pt.x,-pt.y);
        }else{
            if( (canvasEndPoint.x < this.renderWidget.width/2 &&
                canvasEndPoint.y < this.renderWidget.height/2) &&
               (canvasStartPoint.x < -this.renderWidget.width/2 ||
               canvasStartPoint.y < -this.renderWidget.height/2 ) )
            {
                ctx.translate(canvasStartPoint.x,canvasStartPoint.y);
                ctx.scale(tempScaleValue,tempScaleValue);
                ctx.translate(-canvasStartPoint.x,-canvasStartPoint.y);
            }
            else if ( (canvasEndPoint.x > this.renderWidget.width/2 ||
               canvasEndPoint.y > this.renderWidget.height/2) &&
               (canvasStartPoint.x > -this.renderWidget.width/2 &&
               canvasStartPoint.y > -this.renderWidget.height/2 ) )
            {
                ctx.translate(canvasEndPoint.x,canvasEndPoint.y);
                ctx.scale(tempScaleValue,tempScaleValue);
                ctx.translate(-canvasEndPoint.x,-canvasEndPoint.y);
            }else
            {
                ctx.translate(canvasMidPoint.x,canvasMidPoint.y);
                ctx.translate(0,0);
                ctx.scale(tempScaleValue,tempScaleValue);
                ctx.translate(0,0);
            }
        }*/
        this.zoomFlag = true;
        this.scaleValue = parseFloat(this.scaleValue * tempScaleValue).toFixed(3) ;
        //For retaining the zoom value after dbl-click
        imageCanvas.presentation.setPresentationMode("MAGNIFY");
        imageCanvas.presentation.setZoom(this.scaleValue);

        // Set the current zoom level
        imageCanvas.presentation.setZoomLevel(-1);
        if(this.presentationState !== undefined) {
            this.presentationState.zoomLevel = -1;
            this.applyOrRevertDisplaySettings(imageCanvas.presentation, undefined, undefined, true);
        }

        if(isCopyAttribute !== true) {
            this.renderImage(false);
        }
    }
};

/* Zoom the image on left mouse drag based on current mouse pointer */
ImageRenderer.prototype.doZoomDrag =function(dragStart,lastX,lastY){
    var clicks = 0;
    var ctx = this.renderWidgetCtx;
    var pt = ctx.transformedPoint(lastX,lastY);
    var factor = 0;
    if(dragStart.y === pt.y) return; // No change on the mouse drag
    if(dragStart.y > pt.y  ){ // Drag left mouse down
        clicks = 2;
        factor = parseFloat(this.scaleValue) + 0.10;
    }
    if(dragStart.y < pt.y  ){ // Drag left mouse up
        clicks = -2;
        factor = parseFloat(this.scaleValue) - 0.10;
    }
    var tempScaleValue =  parseFloat(factor / this.scaleValue).toFixed(2) ;
    if((factor > 0.05 || clicks > 0) && (factor < 8.0 || clicks < 0))
    {
        var ctx = this.renderWidgetCtx;
        var pt = ctx.transformedPoint(lastX,lastY);
        var canvasMidPoint = ctx.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);
        ctx.translate(canvasMidPoint.x,canvasMidPoint.y);
        ctx.translate(0,0);
        ctx.scale(tempScaleValue,tempScaleValue);
        ctx.translate(0,0);

        /* var canvasEndPoint = ctx.transformedPoint(this.renderWidget.width,this.renderWidget.height);
            var canvasMidPoint = ctx.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);
            var canvasStartPoint = ctx.transformedPoint(0,0);

        if( (canvasEndPoint.x < this.renderWidget.width/2 &&
           canvasEndPoint.y < this.renderWidget.height/2) &&
           (canvasStartPoint.x > -this.renderWidget.width/2 &&
           canvasStartPoint.y > -this.renderWidget.height/2) )
        {
            ctx.translate(pt.x,pt.y);
            ctx.scale(tempScaleValue,tempScaleValue);
            ctx.translate(-pt.x,-pt.y);
        }else{
            if( (canvasEndPoint.x < this.renderWidget.width/2 &&
                canvasEndPoint.y < this.renderWidget.height/2) &&
               (canvasStartPoint.x < -this.renderWidget.width/2 ||
               canvasStartPoint.y < -this.renderWidget.height/2 ) )
            {
                ctx.translate(canvasStartPoint.x,canvasStartPoint.y);
                ctx.scale(tempScaleValue,tempScaleValue);
                ctx.translate(-canvasStartPoint.x,-canvasStartPoint.y);
            }
            else if ( (canvasEndPoint.x > this.renderWidget.width/2 ||
               canvasEndPoint.y > this.renderWidget.height/2) &&
               (canvasStartPoint.x > -this.renderWidget.width/2 &&
               canvasStartPoint.y > -this.renderWidget.height/2 ) )
            {
                ctx.translate(canvasEndPoint.x,canvasEndPoint.y);
                ctx.scale(tempScaleValue,tempScaleValue);
                ctx.translate(-canvasEndPoint.x,-canvasEndPoint.y);
            }else
            {
                ctx.translate(canvasMidPoint.x,canvasMidPoint.y);
                ctx.translate(0,0);
                ctx.scale(tempScaleValue,tempScaleValue);
                ctx.translate(0,0);
            }
        }*/
        this.zoomFlag = true;
        this.scaleValue = parseFloat(this.scaleValue * tempScaleValue).toFixed(2) ;
        this.renderImage(false);
    }
};

/* Pan the image on mouse drag */
ImageRenderer.prototype.doDragPan =function(dragStart,lastX,lastY){
    var ctx = this.renderWidgetCtx;
    var imageCanvas = null;
    this.imagePromise.then(function(image){
        imageCanvas = image;
    });
    var presentationState = this.presentationState;//imageCanvas.presentation;

    var canvasEndPoint = ctx.transformedPoint(this.renderWidget.width,this.renderWidget.height);
    var canvasMidPoint = ctx.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);
    var canvasStartPoint = ctx.transformedPoint(0,0);

    var deltaX = 0;
    var deltaY = 0;


    var rows = imageCanvas.rows;
    var columns = imageCanvas.columns;
    var rowColumnRatio =  rows/columns;
    if(rowColumnRatio == 1){	
        if(dragStart.x > 1 && ((canvasStartPoint.x - dragStart.x ) + this.renderWidget.width/2 > 0)
           && ((canvasStartPoint.x - dragStart.x ) + this.renderWidget.height/2 > 0)){
            deltaX = dragStart.x;
        }
        if(dragStart.x < 1 && ((canvasEndPoint.x - dragStart.x ) - this.renderWidget.width/2 < 0)
           && ((canvasEndPoint.x - dragStart.x ) - this.renderWidget.height/2 < 0)){
            deltaX = dragStart.x;
        }
        if(dragStart.y > 1 && ((canvasStartPoint.y - dragStart.y ) + this.renderWidget.height/2 > 0)
           && ((canvasStartPoint.y - dragStart.y ) + this.renderWidget.width/2 > 0)){
            deltaY = dragStart.y;
        }
        if(dragStart.y < 1 && ((canvasEndPoint.y - dragStart.y ) - this.renderWidget.height/2 < 0)
           && ((canvasEndPoint.y - dragStart.y ) - this.renderWidget.width/2 < 0)){
            deltaY = dragStart.y;
        }	
    } else {
        if(dragStart.x > 1 && (canvasStartPoint.x + this.renderWidget.width/2 > 0)
           && ((canvasStartPoint.x * rowColumnRatio)+ this.renderWidget.height/2 > 0)){
            deltaX = dragStart.x;
        }   
        if(dragStart.x < 1 && (canvasEndPoint.x - this.renderWidget.width/2 < 0)
           && ((canvasEndPoint.x * rowColumnRatio) - this.renderWidget.height/2 < 0)){
            deltaX = dragStart.x;
        }

        rowColumnRatio =  columns/rows;
        if(dragStart.y > 1 && (canvasStartPoint.y + this.renderWidget.height/2 > 0)
           && ((canvasStartPoint.y * rowColumnRatio) + this.renderWidget.width/2 > 0)){
            deltaY = dragStart.y;
        }
        if(dragStart.y < 1 && (canvasEndPoint.y - this.renderWidget.height/2 < 0)
           && ((canvasEndPoint.y * rowColumnRatio) - this.renderWidget.width/2 < 0)){
            deltaY = dragStart.y;
        }
        if(dragStart.x > 20 || dragStart.y > 20){
            deltaX = 0;
            deltaY = 0;
        }
        if(dragStart.x < -20 || dragStart.y < -20){
            deltaX = 0;
            deltaY = 0;
        }
    }

    if(deltaX !== 0 || deltaY !==0)
    {
        ctx.translate(deltaX,deltaY);
        this.renderImage(false);
    }

    this.updatePanTransform();
};

/*Rotate*/
ImageRenderer.prototype.rotate=function(angle){
    var imageCanvas = null;
    this.imagePromise.then(function(image){
        imageCanvas = image;
    });
    var presentationState = this.presentationState;//imageCanvas.presentation;
    this.presentationState.setIsRotationChange(true);
    var angleOfRotation = angle + presentationState.getRotation();
    presentationState.setRotation(angleOfRotation);
    this.presentationState.setWindowingdata(presentationState.windowCenter,presentationState.windowWidth);
    this.renderImage(false);
    var viewPortDivId = $('#'+this.parentElement).parent().closest('div').attr('id');
    var imageCanvasValue = dicomViewer.getimageCanvasOfViewPort(viewPortDivId);
    imageCanvasValue.presentation.setRotation(angleOfRotation);
    this.presentationState.setIsRotationChange(false);

    if(this.presentationState !== undefined) {
        this.applyOrRevertDisplaySettings(imageCanvas.presentation, undefined, undefined, true);
    }
};

/* Invert */
ImageRenderer.prototype.invert = function() {
    var imageCanvas = null;
    var invertFalg;
    var render = this;
    this.imagePromise.then(function(image) {
        var invertValue = !render.presentationState.getInvertFlag();
        imageCanvas = image;
        render.presentationState.setInvertFlag( invertValue);
        dicomViewer.updateImage(render.imageCanvas,imageCanvas, render.presentationState);
        render.drawDicomImage();
    });

    this.renderImage(false);
};

ImageRenderer.prototype.applySharpen = function(sharpen) {
    var imageCanvas = null;
    var invertFalg;
    var render = this;
    this.imagePromise.then(function(image) {
        imageCanvas = image;
        render.presentationState.setSharpen(sharpen);
        dicomViewer.updateImage(render.imageCanvas,imageCanvas, render.presentationState);
        render.drawDicomImage();
    });

    this.renderImage(false);
};



ImageRenderer.prototype.showOrHideOverlay = function(overLayFlag) {
    var LayerCtx = this.overlayCanvas.getContext("2d");
    if (!overLayFlag) {
        LayerCtx.clearRect(0, 0,this.viewportWidth-5,this.viewportHeight-5);
    } else {
        this.applyOverLay();
    }
}

ImageRenderer.prototype.doHorizontalFlip = function()
{
    var imageCanvas = null;
    this.imagePromise.then(function(image){
        imageCanvas = image;
    });
    var presentationState = this.presentationState;//imageCanvas.presentation;
    presentationState.setHorizontalFilp(!presentationState.getHorizontalFilp());
    this.renderImage(false);

    if(this.presentationState !== undefined) {
        this.applyOrRevertDisplaySettings(imageCanvas.presentation, undefined, undefined, true);
    }
};

ImageRenderer.prototype.doVerticalFilp = function()
{
    var imageCanvas = null;
    this.imagePromise.then(function(image){
        imageCanvas = image;
    });
    var presentationState = this.presentationState;//imageCanvas.presentation;
    presentationState.setVerticalFilp(!presentationState.getVerticalFilp());
    this.renderImage(false);

    if(this.presentationState !== undefined) {
        this.applyOrRevertDisplaySettings(imageCanvas.presentation, undefined, undefined, true);
    }
};

ImageRenderer.prototype.setZoomLevel = function(level)
{
    var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();

    if(activeSeriesLayout.getImageType() == IMAGETYPE_RADECG) {
        var tempScaleValue = 1;
        var layoutId = activeSeriesLayout.getSeriesLayoutId();
        var imageEcgDivId = "imageEcgCanvas"+layoutId;
        var myCanvas = document.getElementById(imageEcgDivId);
        if(myCanvas == null || myCanvas == undefined) return;
        var jImageEcgDivId = "imageEcgDiv"+layoutId;
        var jImageEcgDiv = document.getElementById(jImageEcgDivId);
        var jImageEcgHidden = document.getElementById("imageEcgHidden"+layoutId);
        var jImageEcgURL = jImageEcgHidden.value;
        var context = myCanvas.getContext("2d");
        context.clearRect(0,0,myCanvas.width,myCanvas.height);
        var imageObj = new Image();
        imageObj.src = jImageEcgURL;
        var render = this;
        var value = {};
        imageObj.onload = function() {
            render.ecgScalepreset = level;
            switch(level) {
                case 0: //Set Zoom level to 100%
                    tempScaleValue = 1;
                    break;

                case 1: //Set Zoom level to Window (widht and Height)
                    tempScaleValue = Math.min((jImageEcgDiv.offsetHeight-4) / imageObj.height, jImageEcgDiv.offsetWidth / imageObj.width);
                    break;

                case 2: //Set Zoom level Window to Window width
                    tempScaleValue = jImageEcgDiv.offsetWidth / imageObj.width;
                    break;

                case 3: //Set Zoom level Window to Window height
                    tempScaleValue = jImageEcgDiv.offsetHeight / imageObj.height;
                    break;
                        }
            applyECGZoom(tempScaleValue, context, render, myCanvas, imageObj);
        }
        if(parseInt(level) == 6) {
            if(level.length > 1) {
                value = level.split("-");
                var value = level.split("-");
                tempScaleValue = (parseInt(value[1])/100);
                applyECGZoom(tempScaleValue, context, render, myCanvas, imageObj);
            }
        }
    } else if(activeSeriesLayout.getImageType() == IMAGETYPE_RADPDF) {

    }
    else {

        if(!this.imagePromise) {
            var frameIndex = activeSeriesLayout.scrollData.frameIndex;
            var imageType = activeSeriesLayout.imageType;
            imagePromise = dicomViewer.loadImageFromImageLoader(activeSeriesLayout.studyUid, this.imageUid, frameIndex, imageType);
            this.imagePromise = imagePromise;
        }

        this.imagePromise.then(function(image){
            imageCanvas = image;
        });
        var presentationState = this.presentationState;//imageCanvas.presentation;
        if(!presentationState) {
            presentationState = imageCanvas.presentation;
        }

        var dicominfo = imageCanvas.dicominfo;
        var row = dicominfo.getRows();
        var column = dicominfo.getColumns();
        var tmpScaleValue = this.scaleValue;
        var value = {};
        switch(parseInt(level)) {
            case 0: //Set Zoom level to 100%
                value[0] = "0_zoom";
                this.scaleValue = this.getZoomFactor(0, row, column);
                presentationState.fitToWindow = false;
                presentationState.zoomLevel = 0;
                break;
            case 1: //Set Zoom level to Window (widht and Height)
                this.scaleValue = this.getZoomFactor(1, row, column);
                presentationState.fitToWindow = false;
                presentationState.zoomLevel = 1;
                break;
            case 2: //Set Zoom level Window to Window width
                this.scaleValue = this.getZoomFactor(2, row, column);
                presentationState.fitToWindow = false;
                presentationState.zoomLevel = 2;
                break;
            case 3: //Set Zoom level Window to Window height
                this.scaleValue = this.getZoomFactor(3, row, column);
                presentationState.fitToWindow = false;
                presentationState.zoomLevel = 3;
                break;
            case 6: //Set Zoom level Window the custom value
                if(level.length > 1) {
                    value = level.split("-");
                    var value = level.split("-");
                    this.scaleValue = (parseInt(value[1])/100);
                    presentationState.fitToWindow = false;
                    presentationState.zoomLevel = -1;
                }
                              }
        //this.scaleValue = presentationState.getZoom();
        var ctx = this.renderWidgetCtx;
        ctx.clearRect( -this.renderWidget.width *2 ,-this.renderWidget.height*2 , this.renderWidget.width *4 ,this.renderWidget.height*4);
        var canvasMidPoint = ctx.transformedPoint(this.renderWidget.width/2,this.renderWidget.height/2);
        ctx.translate(canvasMidPoint.x,canvasMidPoint.y);
        ctx.translate(0,0);
        ctx.scale(this.scaleValue/tmpScaleValue,this.scaleValue/tmpScaleValue);
        ctx.translate(0,0);
        this.zoomFlag = true;
        //For retaining the zoom value after dbl-click
        if(value[0] == "0_zoom" || value[0] == "6_zoom") {
            imageCanvas.presentation.setPresentationMode("MAGNIFY");
            imageCanvas.presentation.setZoom(this.scaleValue);
        } else {
            imageCanvas.presentation.setPresentationMode("SCALE_TO_FIT");
            imageCanvas.presentation.setZoom(this.scaleValue);
        }

        // Set the current zoom level
        if(presentationState !== undefined) {
            imageCanvas.presentation.setZoomLevel(presentationState.zoomLevel);
            this.applyOrRevertDisplaySettings(imageCanvas.presentation, undefined, undefined, true);
        }

        if(isCopyAttribute !== true) {
            this.renderImage(false);
        }
    }
};

/**
    * apply zoom level to ECG
    * @param scaleValue - specifies the temporary scale value.
    * @param context - specifies the 2d context
    * @param render - specifies the image render
    * @param myCanvas - specifies the canvas object
    * @param imageObj - specifies the image obj
    */
function applyECGZoom (scaleValue, context, render, myCanvas, imageObj)
{
    if(scaleValue > 1 ) scaleValue = Math.max(1,scaleValue - 0.05);
    myCanvas.width = imageObj.width * scaleValue;
    myCanvas.height = imageObj.height * scaleValue;
    scaleValue = scaleValue.toFixed(2);
    scaleValue = Math.abs(scaleValue);
    render.tScaleValue = scaleValue;
    render.tempEcgScale = scaleValue;
    context.scale(scaleValue, scaleValue);
    context.drawImage(imageObj, 0, 0);

    if (myCanvas.width !== 0 && myCanvas.height !== 0) {
        var imageData = context.getImageData(0, 0, myCanvas.width, myCanvas.height);
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        seriesLayout.setEcgCanvas(imageData);
        dicomViewer.loadCaliper();
    }
};

ImageRenderer.prototype.updateXRefLine = function( actualDC , presentation)
{
    dicomViewer.refLine.updateXRefLine(this, actualDC, presentation);
};
/*Render Image*/
ImageRenderer.prototype.renderImage = function( scaleFlag, isActiveImageLevelId)
{
    var divId = $("#"+this.parentElement).parent().closest('div').attr('id');
    if(divId != undefined){
        var viewportObject = dicomViewer.viewports.getViewport(divId);
        if(viewportObject != undefined){
            var studyUid = viewportObject.getStudyUid();
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            var studyLayoutId = getStudyLayoutId(divId);
            var studyInformationdiv = "studyInfo"+studyLayoutId;
            var renderer = undefined;
            if(isFullScreenEnabled){
                var sereiesLayout = dicomViewer.getActiveSeriesLayout();
                var activeSeriesLayoutId = sereiesLayout.getSeriesLayoutId();
                var activeViewport = dicomViewer.getActiveSeriesLayout();
                renderer = activeViewport.getImageRender(activeSeriesLayoutId+ "ImageLevel0x0");
            }
            else if(viewportObject != undefined){
                renderer =  viewportObject.getImageRender(divId+ "ImageLevel0x0");
            }
            if(studyDetails === undefined)
                return;

            if(studyDetails.procedure === null || studyDetails.procedure === undefined || studyDetails.procedure === "" ||studyDetails.procedure.length ===0){
                $("#"+studyInformationdiv).html("&nbsp");
            }else
                $("#"+studyInformationdiv).html(studyDetails.procedure);

            var studyTime = "";
            var studyId = "";
            if(studyDetails.dateTime !== null && studyDetails.dateTime !== undefined) {
                studyTime = studyDetails.dateTime.replace("T", "@");
            }

            if(studyDetails.dicomStudyId !== null && studyDetails.dicomStudyId !== undefined) {
                studyId = studyDetails.dicomStudyId;
            }

            if(studyTime !== "" || studyId !== "") {
                var studyDisplayText = (studyId !== "" ? studyId +", " + studyTime : studyTime);
                $("#studyUidDateTime"+studyLayoutId).html(studyDisplayText);    
            }
        }
        if(divId === "imageviewer_studyViewer1x1_1x1" && isFullScreenEnabled === false)
        {
            seriesIndexBackup = this.seriesIndex;
        }
    }
    var imageCanvas = null;
    if(this.imagePromise == undefined) return;
    this.imagePromise.then(function(image){
        imageCanvas = image;
    });

    if(isCopyAttribute) {
        var tempAttribute = dicomViewer.configuration.cine.getCopyAttributes();

        //WindowLevel
        if(tempAttribute.windowLevel && studyDetails.modality !== "US") {
            imageCanvas.presentation.setWindowingdata(copyAttributePresentaion.presentationState.windowCenter, copyAttributePresentaion.presentationState.windowWidth);
        }

        if(tempAttribute.invert && studyDetails.modality !== "US") {
            imageCanvas.presentation.setInvertFlag(copyAttributePresentaion.presentationState.getInvertFlag());
        }

        if(tempAttribute.scale) {
            this.setZoomLevel("6_zoom-"+parseFloat(copyAttributePresentaion.scaleValue)*100);
        }

        //Orientation
        if(tempAttribute.orientation) {
            imageCanvas.presentation.setOrientation(copyAttributePresentaion.presentationState.getOrientation());
        }
    }

    if (imageCanvas !== undefined && imageCanvas !== null) {
        var viewPortDivId = $('#'+this.parentElement).parent().closest('div').attr('id');
        var imageCanvasValue = dicomViewer.getimageCanvasOfViewPort(viewPortDivId);
        if(imageCanvasValue == undefined || imageCanvasValue == null || imageCanvasValue.imageUid != imageCanvas.imageUid )
        {
            imageCanvas.imageIndex = this.imageIndex;
            imageCanvas.seriesIndex = this.seriesIndex;
            // imageCanvas.frameNumber = 0;
            dicomViewer.setimageCanvasOfViewPort(viewPortDivId,imageCanvas);
        }
        //this.presentationState.setInvertFlag(this.presentationState.invert);
        var presentation = this.presentationState;//imageCanvas.presentation;
        var dicominfo = imageCanvas.dicominfo;
        var row = dicominfo.getRows();
        var column = dicominfo.getColumns();

        if(renderer!= undefined){
            if(renderer.presentationState !== undefined &&
               renderer.presentationState !== null) {
                if(renderer.presentationState.invert != this.presentationState.lookupObj.invert){
                    this.presentationState.setInvertFlag(renderer.presentationState.invert);
                }
            }
        }
        if (this.presentationState.getWindowCenter() === undefined || this.presentationState.getWindowWidth() === undefined) {
            var minMaxPixel = {
                min: 0,
                max: 0
            };
            presentation.setWindowingdata(dicominfo.getWindowCenter(), dicominfo.getWindowWidth());
            presentation.setWindowLevel(dicominfo, minMaxPixel, this.invert);
        }
        if (presentation.windowCenter != imageCanvas.windowCenter || presentation.windowWidth != imageCanvas.windowWidth || this.isPresetDefault)
        {
            this.isPresetDefault = false;
        }
        logger.startTime("dicomViewer.updateImage");
        if((dicominfo.imageInfo.numberOfFrames > 1 && dicominfo.imageInfo.modality === "US") || dicominfo.imageInfo.imageType === IMAGETYPE_JPEG) {
            this.imageCanvas = imageCanvas.imageData;
        } else {
            dicomViewer.updateImage(this.imageCanvas,imageCanvas,this.presentationState);
        }

        logger.endTime("dicomViewer.updateImage");
        this.presentationState = presentation;
        this.headerInfo = dicominfo;
        logger.startTime("Draw Dicom Image");
        this.drawDicomImage(false, isActiveImageLevelId);
        logger.endTime("Draw Dicom Image");
    }
}

ImageRenderer.prototype.drawDicomImage = function(refreshFlag, isActiveImageLevelId, isShowAnnotation, isAutoWindowLevel)
{
    if(isShowAnnotation == true && !dicomViewer.tools.isShowAnnotationandMeasurement()){
        dicomViewer.tools.doShowHideAnnotationAndMeasurement();
        return;
    }
    if(this.presentationState == null) return;
    var presentation = this.presentationState;
    var dicominfo = this.headerInfo;
    var actualDC = this.renderWidgetCtx;
    // clear canvas
    actualDC.clearRect(-this.renderWidget.width*6, -this.renderWidget.height*6, this.renderWidget.width *12 ,this.renderWidget.height*12);

    var scaleFactor = presentation.getZoom();
    //set the defult zoom value to this.scaleValue
    if( this.scaleValue == undefined)
    {
        this.scaleValue = scaleFactor;
    }
    var pan = presentation.getPan();
    if(presentation.fitToWindow)
    {
        if (presentation.getRotation() == 90 || presentation.getRotation() == 270)
        {
            scaleFactor = Math.min(this.renderWidget.height / column, this.renderWidget.width / row);
            presentation.setZoom(scaleFactor);
        }
        else
        {
            scaleFactor = Math.min(this.renderWidget.height / row, this.renderWidget.width / column);
            presentation.setZoom(scaleFactor);
        }
    }
    actualDC.save();

    var orientation = presentation.getOrientation();
    if(isCopyAttribute !== true) {
        if (presentation.isRotation && this.presentationState.getIsRotationChange()) {
            orientation = orientationDefaults[orientation].rotateRight;
        } else {
            if (presentation.vFlip) {
                orientation = orientationDefaults[orientation].flipVert;
            } else if (presentation.hFlip) {
                orientation = orientationDefaults[orientation].flipHorz;
            }
        }
    }

    presentation.setRotation(angleDefaults[orientationDefaults[orientation].rotate]);

    if (orientationDefaults[orientation].mirror === 1) {
        if (orientation === 4 || orientation === 6) {
            presentation.setVerticalFilp(false);
            presentation.setHorizontalFilp(true);
        } else if (orientation === 5 || orientation === 7) {
            presentation.setVerticalFilp(true);
            presentation.setHorizontalFilp(false);
        }
    } else {
        presentation.setVerticalFilp(false);
        presentation.setHorizontalFilp(false);
    }

    // Set the current orientation
    presentation.setOrientation(orientation);
    // Update the Rotate and flip information
    presentation.updateRotateAndFlip();

    var viewPortDivId = $('#'+this.parentElement).parent().closest('div').attr('id');
    var imageCanvasValue = dicomViewer.getimageCanvasOfViewPort(viewPortDivId);
    if(imageCanvasValue != undefined)
        imageCanvasValue.presentation.setOrientation(orientation);
    isRGBToolEnabled = imageCanvasValue ? imageCanvasValue.isRGBToolEnabled : false;


    // Rotate the image
    actualDC.rotate(presentation.getRotation() * Math.PI / 180);

    if (presentation.isFlipHoriRequired()) {
        actualDC.scale(-scaleFactor, scaleFactor);
    }
    else {
        actualDC.scale(scaleFactor, scaleFactor);
    }
    if(dicominfo != undefined && dicominfo.imageInfo.numberOfFrames > 1)
    {
        actualDC.drawImage(this.imageCanvas, pan.x, pan.y);
    }
    else
    {
        actualDC.drawImage(this.imageCanvas, pan.x, pan.y);
    }
    
    var aUIDs = this.anUIDs.split("*");
    var imageUid= aUIDs[0], frameIndex=aUIDs[1];
    dicomViewer.directionalMarker.initDirectionalMarker(dicominfo);
    dicomViewer.directionalMarker.rotateDirectionalMarker(presentation);

    var toolName = dicomViewer.mouseTools.getToolName();

    if(dicomViewer.tools.isShowAnnotationandMeasurement() || isShowAnnotation == true || isAutoWindowLevel == true) {
        if ((toolName == 'lineMeasurement') || (toolName == 'pointMeasurement') || 
            (toolName == 'traceMeasurement') || (toolName == 'volumeMeasurement') || 
            (toolName == 'mitralMeanGradientMeasurement') || (toolName == 'angleMeasurement') ||
            (toolName == 'ellipseMeasurement') ||(toolName == 'rectangleMeasurement') || 
            (toolName == 'pen'))
            dicomViewer.draw.usRegion.drawUSRegions(actualDC, dicominfo, presentation);
        if (isActiveImageLevelId === undefined || isActiveImageLevelId == true) {
            dicomViewer.measurement.draw.drawMeasurements(imageUid,frameIndex,actualDC,presentation,this);
        }
    }

    // Reset the flip values so that next time flip or rotation will work as expected.
    presentation.setHorizontalFilp(false);
    presentation.setVerticalFilp(false);

    // Refresh flag false is for draw lines and point measurement.
    // So we need not to require refresh all the viewports to draw a line in single viewport.
    if(refreshFlag === undefined || refreshFlag )
    {
        //Gets the active viewport
        var layout = dicomViewer.getActiveSeriesLayout();

        //Get all image renderer
        var imageRenders = layout.getAllImageRenders();
        var iKey;
        //Falg to check if the passed image renderer is in the active viewport
        var isInActiveViewPort = false;

        for (var iKey in imageRenders)
        {
            if( this == imageRenders[iKey])
            {
                isInActiveViewPort = true;
            }
        }
        if(isInActiveViewPort == false)
        {
            this.updateXRefLine( actualDC, presentation);
        }
    }


    actualDC.restore();
    // Adding basic header info on image

    if (dicomViewer.tools.isOverlayVisible() /*&& dicominfo.imageInfo.imageType != IMAGETYPE_JPEG*/){
        this.applyOverLay();
    } else {
        var LayerCtx = this.overlayCanvas.getContext("2d");
        LayerCtx.clearRect(0, 0,this.viewportWidth-5,this.viewportHeight-5);
    }

    actualDC.save();

    var parentDivId = $('#'+this.parentElement).parent().closest('div').attr('id');
    if(parentDivId)
    {
        var spinner = dicomViewer.progress.getSpinner(parentDivId);
        if (spinner !== undefined) {
            spinner.stop();
            if(dicominfo && dicominfo.imageInfo) {
                dicominfo.imageInfo.isColor ? disableOrEnableRGBTools() : "";

                if (dicominfo != undefined && (dicominfo.imageInfo.modality === "US" || dicominfo.imageInfo.modality === "XA") && dicominfo.imageInfo.numberOfFrames > 1 && dicomViewer.tools.firstTimeImageLoad() ) {
                    if(!dicomViewer.scroll.isCineRunning(parentDivId)) {
                        dicomViewer.scroll.toggleCineRunning();
                        $('#viewport_View').css('cursor', 'default');
                    }
                }
            }
        }
    }
};

ImageRenderer.prototype.applyOverLay = function()
{
    var LayerCtx = this.overlayCanvas.getContext("2d");
    LayerCtx.clearRect(0, 0, this.viewportWidth-5, this.viewportHeight-5);
    var imageCanvas = null;
    if(this.imagePromise === undefined){
        return;
    }
    var render = this;
    this.imagePromise.done(function(image){
        imageCanvas = image;

        var displayFrameNumber = 0 ;
        var totalNumberofFrame = 1;
        var presentation = render.presentationState;//imageCanvas.presentation;
        if(presentation  != null)
        {
            dicominfo = render.headerInfo;
            if(dicominfo != null && dicominfo != undefined) {
                if(dicominfo.imageInfo.numberOfFrames > 1)
                {
                    displayFrameNumber = eval(imageCanvas.frameNumber)+1;
                    totalNumberofFrame = dicominfo.imageInfo.numberOfFrames;
                }

                if (dicomViewer.tools.isOverlayVisible())
                {
                    var overlayConfig = null;

                    if(dicominfo.imageInfo.imageType !== IMAGETYPE_JPEG)
                    {
                        overlayConfig = dicomViewer.overlay.getOverlayConfig();
                        var bottomLeftOverLayConfig = dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.bottomleft,dicominfo);
                    }
                    else
                    {
                        overlayConfig = ["Scale"];
                        var bottomLeftOverLayConfig = dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig,dicominfo);
                    }

                    var topLefOverLayConfig = dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.topleft,dicominfo);
                    var topRightOverLayConfig = dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.topRight,dicominfo);
                    //var bottomLeftOverLayConfig = dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.bottomleft,dicominfo);
                    var bottomRigthOverLayConfig = dicomViewer.overlay.getOverLayValuesForCofig(overlayConfig.bottomRight,dicominfo);

                    LayerCtx.fillStyle = "yellow";
                    LayerCtx.font = "11pt Helvetica";

                    var windowLevelTxt = "WW: " + Math.round(presentation.getWindowWidth()) + ", WC: " + Math.round(presentation.getWindowCenter());
                    //getting the scale value and convert to zoom precentage
                    var scaleText = "Zoom: "+Math.round(render.scaleValue*100)+"%";
                    //"Zoom: "+(presentation.getZoom().toFixed(2))*100+"%";
                    var seriesDesc = dicomViewer.Series.getSeriesDescription(dicomViewer.getActiveSeriesLayout().getStudyUid(), render.seriesIndex );
                    generatDicomOverlay(topLefOverLayConfig,"topLeft",LayerCtx,windowLevelTxt,scaleText);
                    generatDicomOverlay(bottomLeftOverLayConfig, "bottomLeft",LayerCtx, windowLevelTxt,scaleText, render.viewportHeight-5,"",displayFrameNumber,totalNumberofFrame,seriesDesc);
                    generatDicomOverlay(topRightOverLayConfig,"topRight",LayerCtx, windowLevelTxt,scaleText,"",render.viewportWidth-5);
                    generatDicomOverlay(bottomRigthOverLayConfig, "bottomRight",LayerCtx, windowLevelTxt,scaleText, render.viewportHeight-5, render.viewportWidth-5);
                    LayerCtx.fillStyle = "black";

                    //if the image is comprepressed call the displayOverLayWarning method
                    if(dicominfo.imageInfo.isCompressed || dicominfo.imageInfo.imageType === IMAGETYPE_RADECHO){
                        displayOverLayWarning(LayerCtx, render.overlayCanvas.width, render.overlayCanvas.height);
                    }

                    applyDirectionalmarker(LayerCtx,dicominfo,render.viewportHeight, render.viewportWidth);
                    displayRGBChannelToolTip(render);
                }
            }

        }
    });
}

function applyDirectionalmarker(LayerCtx,dicominfo,height, width)
{
    var directionalMarker = dicomViewer.directionalMarker.getDirectionalMarker();
    if(directionalMarker != null)
    {
        LayerCtx.fillStyle = "yellow";
        LayerCtx.font = "11pt Helvetica";
        LayerCtx.fillText(directionalMarker.left,20, height/2);
        LayerCtx.fillText(directionalMarker.right, width-LayerCtx.measureText(directionalMarker.right).width*2, height/2);
        LayerCtx.fillText(directionalMarker.top, width/2,20);
        LayerCtx.fillText(directionalMarker.bottom, width/2,height - 20);
        LayerCtx.fillStyle = "black";
    }
}

/**
	*Display Red, Blue or Green channel is applied
	*/
function displayRGBChannelToolTip(imageRender)
{
    //var seriesLayout = dicomViewer.getActiveSeriesLayout();
    //var imageLevelId = $("#" + seriesLayout.getSeriesLayoutId() + " div").attr('id');
    //var imageRender  = seriesLayout.getImageRender(imageLevelId);
    if(imageRender !== undefined && dicomViewer.tools.isOverlayVisible())
    {
        var message = "";
        var fillStyle = "black"
        var dicominfo = imageRender.headerInfo;

        // Enable/Disable RGB tool
        var enableRGBTool = false;
        if(dicominfo !== undefined) {
            var imageInfo = dicominfo.imageInfo;
            if(imageInfo.isColor && isRGBToolEnabled) {
                enableRGBTool = true;
            }
        }

        if(dicominfo !== undefined && enableRGBTool && imageRender.presentationState.getRGBMode() !== undefined)
        {
            if(imageRender.presentationState.getRGBMode() === 1)
            {
                message = "Red Channel";
                fillStyle = "Red";
                dicomViewer.tools.rgbColor(1, true);
            }
            else if(imageRender.presentationState.getRGBMode() === 2)
            {
                message = "Green Channel";
                fillStyle = "Green";
                dicomViewer.tools.rgbColor(2, true);
            }
            else if(imageRender.presentationState.getRGBMode() === 3)
            {
                message = "Blue Channel";
                fillStyle = "Blue";
                dicomViewer.tools.rgbColor(3, true);
            } else {
                dicomViewer.tools.resetRGBMenu();
            }
        }
        if(message !== "")
        {
            var LayerCtx = imageRender.overlayCanvas.getContext("2d");
            LayerCtx.clearRect(imageRender.overlayCanvas.width -LayerCtx.measureText(message).width-55, imageRender.overlayCanvas.height-60,LayerCtx.measureText(message).width+1, 60);
            LayerCtx.fillStyle = fillStyle;
            LayerCtx.font = "11pt Helvetica";
            LayerCtx.fillText(message,imageRender.overlayCanvas.width -LayerCtx.measureText(message).width, imageRender.overlayCanvas.height-60);
            LayerCtx.fillStyle = "black";
        }
    }
}

function generatDicomOverlay(OverLayConfigObject, location, LayerCtx, windowLevelTxt,scaleText, height, width , displayFrameNumber, totalNumberofFrame, seriesDesc)
{
    var postionIndex = 0;
    var postionIncrement = 1;
    for (var i=0; i<OverLayConfigObject.length; i++) {
        if(location == "topLeft")
        {
            var valueOfDicomTag = OverLayConfigObject[i];
            if((valueOfDicomTag  != undefined ) && valueOfDicomTag != "")
            {
                var postion = (postionIncrement)*2;
                displayOverlayLeftSide(valueOfDicomTag,10,postion*10,LayerCtx,windowLevelTxt,scaleText);
                postionIncrement++;
            }
        }
        else if(location == "bottomLeft")
        {
            var valueOfDicomTag = OverLayConfigObject[OverLayConfigObject.length-(i+1)];
            if(valueOfDicomTag  != undefined && valueOfDicomTag != "")
            {
                postionIndex=postionIndex+1;
                postion	= (postionIndex)*10;
                displayOverlayLeftSide(valueOfDicomTag, 10, height-(postion), LayerCtx, windowLevelTxt,scaleText);
                postionIndex++;
            }
            //when the for loop is in last time and the total number of frame is greater than 1 it ill execute the code for diplaying frames count in viewport
            if(i == OverLayConfigObject.length-1 && totalNumberofFrame != 1)
            {
                postionIndex=postionIndex+1;
                postion	= (postionIndex)*10;
                displayOverlayLeftSide("Fr :"+(displayFrameNumber)+"/"+totalNumberofFrame,10, height-(postion),LayerCtx,windowLevelTxt,scaleText);
                postionIndex++;
            }
            if(i == OverLayConfigObject.length-1)
            {
                if( seriesDesc != undefined && seriesDesc != ""){
                    postionIndex = postionIndex+1;
                    postion	= (postionIndex)*10;
                    displayOverlayLeftSide(seriesDesc, 10, height-(postion), LayerCtx, windowLevelTxt, scaleText);
                    postionIndex++;
                }
            }
        }
        else if(location == "topRight")
        {
            var valueOfDicomTag = OverLayConfigObject[i];
            if(valueOfDicomTag  != undefined && valueOfDicomTag != "" )
            {
                var postion = (postionIncrement)*2;
                displayOverlayRightSide(valueOfDicomTag, width ,postion*10, LayerCtx, windowLevelTxt,scaleText);
                postionIncrement++;
            }
        }
        else if(location == "bottomRight")
        {
            var valueOfDicomTag = OverLayConfigObject[OverLayConfigObject.length-(i+1)];
            if(valueOfDicomTag  != undefined && valueOfDicomTag != "" )
            {
                postionIndex=postionIndex+1;
                postion	= (postionIndex)*10;
                displayOverlayRightSide(valueOfDicomTag, width,height-(postion), LayerCtx, windowLevelTxt,scaleText);
                postionIndex++;
            }
        }
    }
}

function displayOverlayLeftSide(valueOfDicomTag, width, height, LayerCtx,windowLevelTxt,scaleText)
{
    if (valueOfDicomTag === "WCWW")
    {
        LayerCtx.fillText(windowLevelTxt, width, height);
    }
    else if(valueOfDicomTag === "Scale")
    {
        LayerCtx.fillText(scaleText, width, height);
    }
    else
    {
        LayerCtx.fillText(valueOfDicomTag, width, height);
    }
}

function displayOverlayRightSide(valueOfDicomTag, renderWidth, postion, LayerCtx, windowLevelTxt,scaleText)
{
    if(valueOfDicomTag === "WCWW")
    {
        LayerCtx.fillText(windowLevelTxt,(renderWidth- LayerCtx.measureText(windowLevelTxt).width),postion);
    }
    else if(valueOfDicomTag === "Scale")
    {
        LayerCtx.fillText(scaleText,(renderWidth- LayerCtx.measureText(scaleText).width),postion);
    }
    else
    {
        LayerCtx.fillText(valueOfDicomTag,  renderWidth- LayerCtx.measureText(valueOfDicomTag).width,postion);
    }
}
/**
	*Display warning icon for compressed images
	*/
var warningImageData  = undefined;
function displayOverLayWarning(context, width, height)
{
    if(warningImageData === undefined){
        var img = new Image();
        img.src = "images/alert.bmp";
        img.onload = function(){
            context.drawImage(img,width-50,height-40);
            warningImageData = context.getImageData(width-50,height-50, width, height);
        }
    }else{
        context.putImageData(warningImageData,width-50,height-50);
    }
}
/**
	*Display warning icon for compressed images
	*/
function displayCompressinToolTip(evt,imageRender)
{
    //var seriesLayout = dicomViewer.getActiveSeriesLayout();
    //var imageLevelId = $("#" + seriesLayout.getSeriesLayoutId() + " div").attr('id');
    //var imageRender  = seriesLayout.getImageRender(imageLevelId);
    if(imageRender !== undefined && dicomViewer.tools.isOverlayVisible())
    {
        var message = "";
        var dicominfo = imageRender.headerInfo;
        if(dicominfo !== undefined && dicominfo.imageInfo.isCompressed)
        {
            if(dicominfo.imageInfo.imageType === IMAGETYPE_RADECHO)
                message = "Jpeg compressed image";
            else if(dicominfo.imageInfo.compressionMethod !== undefined && dicominfo.imageInfo.compressionMethod !== "")
                message = dicominfo.imageInfo.compressionMethod;
        }
        if(message !== "")
        {
            var widget = imageRender.getRenderWidget();
            var	lastX = evt.offsetX || (evt.pageX - widget.offsetLeft);
            var	lastY = evt.offsetY || (evt.pageY - widget.offsetTop);

            if(lastX > (imageRender.overlayCanvas.width -50) && lastY > (imageRender.overlayCanvas.height - 50) &&
               lastX < (imageRender.overlayCanvas.width -5) && lastY < (imageRender.overlayCanvas.height - 5))
            {

                var LayerCtx = imageRender.overlayCanvas.getContext("2d");
                LayerCtx.clearRect(imageRender.overlayCanvas.width -LayerCtx.measureText(message).width-55, imageRender.overlayCanvas.height-20,LayerCtx.measureText(message).width+1, 20);
                LayerCtx.fillStyle = "white";
                LayerCtx.font = "11pt Helvetica";
                LayerCtx.fillText(message,imageRender.overlayCanvas.width -LayerCtx.measureText(message).width-55, imageRender.overlayCanvas.height-5);
                LayerCtx.fillStyle = "black";
            }else
            {
                var LayerCtx = imageRender.overlayCanvas.getContext("2d");
                LayerCtx.clearRect(imageRender.overlayCanvas.width -LayerCtx.measureText(message).width-55, imageRender.overlayCanvas.height-20,LayerCtx.measureText(message).width+1, 20);

            }
        }
    }
}

/**
*Double click over the viewport makes it fullscreen(i.e. 1x1 Study Layout) and vice versa.
*/
function doubleClick() {
    var toolName = dicomViewer.mouseTools.getToolName();
    if (toolName !== 'traceMeasurement' && toolName !== 'volumeMeasurement' && 
        toolName !== 'mitralMeanGradientMeasurement' && toolName !== 'pointMeasurement' && 
        toolName !== 'lineMeasurement' && toolName !== 'angleMeasurement' && 
        toolName !== 'ellipseMeasurement' && toolName !== 'rectangleMeasurement') {
        var sereiesLayout = dicomViewer.getActiveSeriesLayout();
        var activeSeriesLayoutId = sereiesLayout.getSeriesLayoutId();
        var currentSeriesLayoutIds = dicomViewer.getCurrentSeriesLayoutIds();
        var maxSeriesLayoutId = dicomViewer.viewports.getSeriesLayoutMaxId();
        var activeViewport = dicomViewer.getActiveSeriesLayout();
        var studyDivId = getStudyLayoutId(currentSeriesLayoutIds);
        var layoutDivId = "imageviewer_"+studyDivId+"_"+"1x1";
        if (maxSeriesLayoutId !== layoutDivId && studyLayoutValue === "1x1") {
            if (currentSeriesLayoutIds === layoutDivId) {
                isFullScreenEnabled = false;
                maxSeriesLayoutId = maxSeriesLayoutId.replace("imageviewer_"+studyDivId+"_", '');
                var row = maxSeriesLayoutId.charAt(0);
                var columm = maxSeriesLayoutId.charAt(maxSeriesLayoutId.length - 1);
                var imageAndSeriesIndex = activeViewport.seriesIndex;

                // Set the rearranged series positions
                var isSeriesReArranged = false;
                if(dicomViewer.scroll.isCineRunning(sereiesLayout.getSeriesLayoutId())) {
                    imageAndSeriesIndex = dicomViewer.tools.getOrSetReArrangedSeriesPositions(parseInt(row), parseInt(columm), true);
                    isSeriesReArranged = true;
                }
                dicomViewer.setSeriesLayout(activeViewport.getStudyUid(),row, columm, imageAndSeriesIndex, false, getStudyLayoutId(activeSeriesLayoutId));
                dicomViewer.setReArrangedSeriesPositions(undefined);
                var backserieslayout = dicomViewer.getActiveSeriesLayout();
                if(backserieslayout != undefined && backserieslayout !=null){
                    if(dicomViewer.scroll.isCineRunning(backserieslayout.getSeriesLayoutId())){
                        updatePlayIcon("play.png","stop.png");
                    }
                }
            } else {
                previousLayoutSelection = activeSeriesLayoutId;
                isFullScreenEnabled = true;
                dicomViewer.setSeriesLayout(activeViewport.getStudyUid(),1, 1, activeViewport.seriesIndex, true, getStudyLayoutId(activeSeriesLayoutId));
            }
        } else {
            if(studyLayoutValue !== "1x1" && !isFullScreenEnabled){
                previousLayoutSelection = activeSeriesLayoutId;
                isFullScreenEnabled = true;
                dicomViewer.setStudyLayout(1, 1, activeViewport.getStudyUid(), activeViewport.seriesIndex, true);
            } else if(isFullScreenEnabled) {
                isFullScreenEnabled = false;
                var splitedRowAndColumn = studyLayoutValue.split("x");
                var studyRow = splitedRowAndColumn[0];
                var studyColumn = splitedRowAndColumn[1];
                var obj = {
                    id: studyLayoutValue
                };
                var tempLayOutmap = layoutMap;
                dicomViewer.tools.changeStudyLayoutFromTool(obj, isFullScreenEnabled, false);
                layoutMap = tempLayOutmap;
                for (var i = 1; i <= studyRow; i++) {
                    for (var j = 1; j <= studyColumn; j++) {
                        var studyDiv = "studyViewer" + i + "x" + j;
                        var rowCalValue = layoutMap[studyDiv];
                        if (rowCalValue == undefined) {
                            rowCalValue = "1x1";
                        }
                        var rcArray = rowCalValue.split("x");
                        dicomViewer.tools.chanageWhileDrag(rcArray[0], rcArray[1], studyDiv);

                        // shown the view port close icon
                        var layoutId = "imageviewer_"+ studyDiv+ "_1x1";
                        var viewport = dicomViewer.viewports.getViewport(layoutId);
                        if(viewport != null &&  viewport != undefined) {
                            if(viewport.studyUid != undefined) {
                                document.getElementById(studyDiv + '_close').style.visibility = "visible";
                            }
                        }
                    }
                }
                dicomViewer.playRepeatCineManager();
                dicomViewer.changeSelection(previousLayoutSelection);
            }
        }
    }
    //If there is any measurement/annotation tool selected then on double-click completing the shape
    if(toolName === "mitralMeanGradientMeasurement" || toolName === "traceMeasurement" || 
       toolName === "lineMeasurement" || toolName === "pointMeasurement" || 
       toolName === "ellipseMeasurement" || toolName === "rectangleMeasurement" || 
       toolName === "angleMeasurement") {
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();
    }
    isCineEnabled(false);
};

ImageRenderer.prototype.getPresentation = function() {
    return this.presentationState;
};
ImageRenderer.prototype.getRenderWidget = function() {
    return this.renderWidget;
};

ImageRenderer.prototype.getZoomLevel = function() {
    return this.tScaleValue;
}

/*Update the series index while DnD*/
ImageRenderer.prototype.updateSeriesIndex =function()
{
    seriesIndex = this.seriesIndex;	//updating the series index
};

/*Returns the series index*/
ImageRenderer.prototype.getSeriesIndex =function()
{
    return this.seriesIndex;
};

/*Returns the image Id*/
ImageRenderer.prototype.getImageUid =function()
{
    return this.imageUid;
};


/*Returns the current imageLocator*/
ImageRenderer.prototype.getCurrentUIDs = function()
{
    return this.anUIDs;
};


/**
 * Apply or revert display settings
 * @param {Type} presentation - Specifies the current presentation
 * @param {Type} isDefaultPresentation - Specifies the flag for default presentation
 * @param {Type} revert - Specifies the flag for revert the display settings
 * @param {Type} save - Specifies the flag for save the display settings
 */ 
ImageRenderer.prototype.applyOrRevertDisplaySettings = function(presentation, isDefaultPresentation, revert, save) {
    try
    {
        // Default presentation values.
        if(isDefaultPresentation === true) {
            presentation.orientation = 0;
            presentation.isRotation = false;
            presentation.rotation = 0;
            presentation.hFlip = false;
            presentation.vFlip = false;
            presentation.zoom = 1;
            presentation.presentationMode = "SCALE_TO_FIT";
            presentation.zoomLevel = 1;
            presentation.rgbMode = 0;
        }

        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        if(activeSeriesLayout !== undefined && activeSeriesLayout.studyUid !== undefined) {
            var seriesOrImage = dicomViewer.Series.Image.getImage(activeSeriesLayout.studyUid, this.seriesIndex, this.imageIndex);
            if(seriesOrImage === undefined || 
               seriesOrImage.isImageThumbnail === undefined || 
               seriesOrImage.isImageThumbnail === false ) {
                seriesOrImage = dicomViewer.Series.getSeries(activeSeriesLayout.studyUid, this.seriesIndex);
            }

            if(seriesOrImage !== undefined && seriesOrImage.displaySettings !== undefined) {
                var displaySettings = seriesOrImage.displaySettings;
                if(seriesOrImage.isDisplaySettingsApplied === false) {
                    seriesOrImage.isDisplaySettingsApplied = true;
                    if(displaySettings.IsECG === true) {
                        this.ecgScalepreset = displaySettings.ZoomLevel;
                    } else if(presentation !== undefined) {
                        presentation.presentationMode = "SCALE_TO_FIT";
                        presentation.zoomLevel = displaySettings.ZoomLevel;
                        displaySettings.presentation = jQuery.extend(true, {}, presentation);
                    }
                } else if(seriesOrImage.isDisplaySettingsApplied === true && revert === true) {
                    seriesOrImage.isDisplaySettingsApplied = false;
                } else if(seriesOrImage.isDisplaySettingsApplied === true && presentation !== undefined) {
                    presentation.presentationMode = "SCALE_TO_FIT";
                    if(seriesOrImage.isImageThumbnail === true) {
                        if(save === true) {
                            displaySettings.presentation = jQuery.extend(true, {}, presentation);
                        } else {
                            var restorePresentation = displaySettings.presentation;
                            if(restorePresentation !== undefined) {
                                var imageCanvas = null;
                                this.imagePromise.then(function(image) {
                                    imageCanvas = image;
                                });

                                // Apply the restore presentation in image canvas presentation
                                imageCanvas.presentation.zoom = restorePresentation.zoom;
                                imageCanvas.presentation.zoomLevel = restorePresentation.zoomLevel;
                                imageCanvas.presentation.rotation = restorePresentation.rotation;
                                imageCanvas.presentation.isRotation = restorePresentation.isRotation;
                                imageCanvas.presentation.orientation = restorePresentation.orientation;
                                imageCanvas.presentation.isFlipHorizontalRequired = restorePresentation.isFlipHorizontalRequired;
                                imageCanvas.presentation.vFlip = restorePresentation.vFlip;
                                imageCanvas.presentation.hFlip = restorePresentation.hFlip;                                

                                // Apply the restore presentation in current presentation
                                presentation.zoom = restorePresentation.zoom;
                                presentation.zoomLevel = restorePresentation.zoomLevel;
                                presentation.rotation = restorePresentation.rotation;
                                presentation.isRotation = restorePresentation.isRotation;
                                presentation.orientation = restorePresentation.orientation;
                                presentation.isFlipHorizontalRequired = restorePresentation.isFlipHorizontalRequired;
                                presentation.vFlip = restorePresentation.vFlip;
                                presentation.hFlip = restorePresentation.hFlip;
                            }
                        }
                    }
                } else if(seriesOrImage.isDisplaySettingsApplied === true && displaySettings.IsECG === true) {
                    var preferenceInfo = activeSeriesLayout.preferenceInfo;
                    if(save === true && preferenceInfo !== undefined) {
                        displaySettings.EcgPreference = jQuery.extend(true, {}, preferenceInfo.preferenceData);
                        displaySettings.SelectedEcgPreference = jQuery.extend(true, {}, preferenceInfo.selectedEcgFormat);
                        displaySettings.isCaliperEnable = activeSeriesLayout.isCaliperEnable;
                    } else if(preferenceInfo !== undefined) {
                        if(displaySettings.EcgPreference !== undefined && displaySettings.SelectedEcgPreference !== undefined) {
                            preferenceInfo.selectedEcgFormat = jQuery.extend(true, {}, displaySettings.SelectedEcgPreference);
                            preferenceInfo.preferenceData = jQuery.extend(true, {}, displaySettings.EcgPreference);
                            activeSeriesLayout.isCaliperEnable = displaySettings.isCaliperEnable;
                        }
                    }
                } else {
                    //Already applied the display settings 
                }
            }
        }
    }
    catch(e)
    { }
}

/**
 * Get the zoom factor
 * @param {Type} level - Specifies the zoom level
 * @param {Type} row - Specifies the image width
 * @param {Type} column - Specifies the image height
 */ 
ImageRenderer.prototype.getZoomFactor = function(level, row, column) {
    try
    {
        var zoomFactor = undefined;
        var minZoomValue = 5; //(in percentage)
        switch(level)
                {
            case 0: //Set Zoom level to 100%
                zoomFactor = 1;
                break;

            case 1: //Set Zoom level to Window (widht and Height)
                zoomFactor = Math.min(this.renderWidget.height / row, this.renderWidget.width / column);
                break;

            case 2: //Set Zoom level Window to Window width
                zoomFactor = (this.renderWidget.width / column);
                break;

            case 3: //Set Zoom level Window to Window height
                zoomFactor = (this.renderWidget.height / row) ;
                break;

            default: //Set Zoom level to Window (widht and Height)
                zoomFactor = Math.min(this.renderWidget.height / row, this.renderWidget.width / column);
                break;
        }

        if(zoomFactor*100 - 5 < 0) {
            zoomFactor = minZoomValue/100;
        }
        return zoomFactor;
    }
    catch(e)
    { }
}

/* Change the default cursor tool based on the modality while mouse drag */
ImageRenderer.prototype.doClickDefaultTool =function(){

    // set the defualt cursor for the loaded/selected view port modality
    var seriesLayout = dicomViewer.getActiveSeriesLayout();
    var modality = dicomViewer.Series.getModality(seriesLayout.getStudyUid(), seriesLayout.getSeriesIndex());
    dicomViewer.setDefaultCursorType(modality, seriesLayout);
};

/**
 * Print the Zoom level applied image
 * printOption - 1->At Current Zoom
 * printOption - 2->at 100%
 */ 
ImageRenderer.prototype.preparePrint = function(printOption)
{
    try
    {
        var printCanvas = document.createElement("canvas");
        var previousScaleValue = this.scaleValue;
        this.scaleValue = 1;
        if(printOption == 1) {
            this.scaleValue = previousScaleValue;
        }

        printCanvas.width = this.imageCanvas.width * parseFloat(this.scaleValue);
        printCanvas.height = this.imageCanvas.height * parseFloat(this.scaleValue);
        var printContext = printCanvas.getContext('2d');

        printContext.clearRect(0,0,printCanvas.width,printCanvas.height);
        printContext.save();
        printContext.translate(printCanvas.width/2,printCanvas.height/2);
        printContext.rotate(this.presentationState.getRotation() * Math.PI/180);

        //Apply the scale based on the image flip
        if(this.presentationState.isFlipHorizontalRequired) {
            printContext.scale(-this.scaleValue, this.scaleValue);
        } else {
            printContext.scale(this.scaleValue, this.scaleValue);
        }

        //Draw image
        printContext.drawImage(this.imageCanvas, -this.imageCanvas.width/2, -this.imageCanvas.height/2);

        this.isPrint = true;
        var aUIDs = this.anUIDs.split("*");
        var imageUid= aUIDs[0];
        var frameIndex=aUIDs[1];
        this.scaleValue = ((parseFloat(this.scaleValue) <= 1.5 )) ? parseFloat(this.scaleValue) : 1.5;
        //Draw the measurements
        if(dicomViewer.tools.isShowAnnotationandMeasurement()) {
            dicomViewer.measurement.draw.drawMeasurements(imageUid, frameIndex, printContext, this.presentationState, this);
        }
        printContext.restore();
        this.scaleValue = previousScaleValue;
        this.isPrint = undefined;

        return printCanvas.toDataURL('image/jpeg', 1.0);
    }
    catch(e)
    { }
};

//Adds ctx.getTransform() - returns an SVGMatrix
//Adds ctx.transformedPoint(x,y) - returns an SVGPoint
function trackTransforms(ctx){
    var svg = document.createElementNS("http://www.w3.org/2000/svg",'svg');
    var xform = svg.createSVGMatrix();
    ctx.getTransform = function(){
        return xform;
    };

    var savedTransforms = [];
    var save = ctx.save;
    ctx.save = function(){
        savedTransforms.push(xform.translate(0,0));
        return save.call(ctx);
    };
    var restore = ctx.restore;
    ctx.restore = function(){
        xform = savedTransforms.pop();
        return restore.call(ctx);
    };

    var scale = ctx.scale;
    ctx.scale = function(sx,sy){
        sx = parseFloat(sx);
        sy = parseFloat(sy);
        xform = xform.scaleNonUniform(sx,sy);
        xform.a = parseFloat(xform.a);
        xform.b = parseFloat(xform.b);
        xform.c = parseFloat(xform.c);
        xform.d = parseFloat(xform.d);
        xform.e = parseFloat(xform.e);
        xform.f = parseFloat(xform.f);
        return scale.call(ctx,sx,sy);
    };
    var rotate = ctx.rotate;
    ctx.rotate = function(radians){
        xform = xform.rotate(radians*180/Math.PI);
        xform.a = parseFloat(xform.a);
        xform.b = parseFloat(xform.b);
        xform.c = parseFloat(xform.c);
        xform.d = parseFloat(xform.d);
        xform.e = parseFloat(xform.e);
        xform.f = parseFloat(xform.f);
        return rotate.call(ctx,radians);
    };
    var translate = ctx.translate;
    ctx.translate = function(dx,dy){
        dx = parseFloat(dx);
        dy = parseFloat(dy);
        xform = xform.translate(dx,dy);
        xform.a = parseFloat(xform.a);
        xform.b = parseFloat(xform.b);
        xform.c = parseFloat(xform.c);
        xform.d = parseFloat(xform.d);
        xform.e = parseFloat(xform.e);
        xform.f = parseFloat(xform.f);
        return translate.call(ctx,dx,dy);
    };
    var transform = ctx.transform;
    ctx.transform = function(a,b,c,d,e,f){
        var m2 = svg.createSVGMatrix();
        a = parseFloat(a);
        b = parseFloat(b);
        c = parseFloat(c);
        d = parseFloat(d);
        e = parseFloat(e);
        f = parseFloat(f);
        m2.a=a; m2.b=b; m2.c=c; m2.d=d; m2.e=e; m2.f=f;
        xform = xform.multiply(m2);
        xform.a = parseFloat(xform.a);
        xform.b = parseFloat(xform.b);
        xform.c = parseFloat(xform.c);
        xform.d = parseFloat(xform.d);
        xform.e = parseFloat(xform.e);
        xform.f = parseFloat(xform.f);
        return transform.call(ctx,a,b,c,d,e,f);
    };
    var setTransform = ctx.setTransform;
    ctx.setTransform = function(a,b,c,d,e,f){
        xform.a = parseFloat(a);
        xform.b = parseFloat(b);
        xform.c = parseFloat(c);
        xform.d = parseFloat(d);
        xform.e = parseFloat(e);
        xform.f = parseFloat(f);
        return setTransform.call(ctx,a,b,c,d,e,f);
    };
    var pt  = svg.createSVGPoint();
    ctx.transformedPoint = function(x,y){
        x = parseFloat(x);
        y = parseFloat(y);
        pt.x=x; pt.y=y;
        return pt.matrixTransform(xform.inverse());
    };
    var pt  = svg.createSVGPoint();
    ctx.mousePoint = function(x,y){
        x = parseFloat(x);
        y = parseFloat(y);
        pt.x=x; pt.y=y;
        return pt.matrixTransform(xform);
    };
}

function getNavigation(lastMousePosition, e)
{
    var xDiff = lastMousePosition.ptX - e.clientX;
    var yDiff = lastMousePosition.ptY - e.clientY;

    if (Math.abs(xDiff) > Math.abs(yDiff)) {
        if (xDiff > 0) {
            return { moveToNext : true, xDiff : xDiff,  yDiff : undefined, frameIndex : lastMousePosition.frameIndex, imageIndex : lastMousePosition.imageIndex};
        } else {
            return { moveToNext : false, xDiff : Math.abs(xDiff),  yDiff : undefined, frameIndex : lastMousePosition.frameIndex, imageIndex : lastMousePosition.imageIndex};
        }
    } else {
        if (yDiff > 0) {
            return { moveToNext : true, xDiff : undefined,  yDiff : yDiff, frameIndex : lastMousePosition.frameIndex, imageIndex : lastMousePosition.imageIndex};
        } else {
            return { moveToNext : false, xDiff : undefined,  yDiff : Math.abs(yDiff), frameIndex : lastMousePosition.frameIndex, imageIndex : lastMousePosition.imageIndex};
        }
    }
    return undefined;
}

/**
 * Prepare the print for ECG modality
 * printOption - Specifies the print option
 */ 
ImageRenderer.prototype.PrepareECGPrint = function(printOption) {
    try
    {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var ScaleValue = 1;
        if(printOption == 1) {
            ScaleValue = parseFloat(this.tempEcgScale);
        }

        var layoutId = activeSeriesLayout.getSeriesLayoutId();
        var imageEcgDivId = "imageEcgCanvas"+layoutId;
        var originalCanvas = document.getElementById(imageEcgDivId);
        var printCanvas = document.createElement("canvas");

        printCanvas.width = this.ecgData.width * ScaleValue;
        printCanvas.height = this.ecgData.height * ScaleValue;
        var printContext = printCanvas.getContext('2d');

        printContext.clearRect(0,0,printCanvas.width,printCanvas.height);
        printContext.fillStyle = 'white';
        printContext.fillRect(0, 0, printCanvas.width, printCanvas.height);
        printContext.save();
        printContext.scale(ScaleValue, ScaleValue);
        printContext.drawImage(this.ecgData.imageObject, 0, 0);
        if(dicomViewer.isShowcaliper(this.imageUid)) {
            dicomViewer.printCaliper(printContext, this.imageUid);
        }

        printContext.restore();
        return printCanvas.toDataURL('image/jpeg', 1.0);
    }
    catch(e)
    { }
}

/**
 * Set the pan transform
 */ 
ImageRenderer.prototype.updatePanTransform = function(revert) {
    try
    {
        if(!this.imagePromise) {
            return;
        }

        var imageCanvas = null;
        this.imagePromise.then(function(image){
            imageCanvas = image;
        });

        if(!imageCanvas) {
            return;
        }

        if(revert) {
            imageCanvas.lastAppliedPan = undefined;
            return;
        }

        imageCanvas.lastAppliedPan = this.renderWidgetCtx.getTransform();

        if(dumpInConsole) {
            var tpts = imageCanvas.lastAppliedPan;
            console.log("******** updatePanTransform ********");
            console.log("A: " + tpts.a);
            console.log("B: " + tpts.b);
            console.log("C: " + tpts.c);
            console.log("D: " + tpts.d);
            console.log("E: " + tpts.e);
            console.log("F: " + tpts.f);
            console.log("***************************");
        }
    }
    catch(e)
    { }
}

/**
 * Appply the pan
 * presentation - Set the presentation
 */ 
ImageRenderer.prototype.applyPan = function() {
    try
    {
        if(!this.imagePromise) {
            return;
        }

        var imageCanvas = null;
        this.imagePromise.then(function(image){
            imageCanvas = image;
        });

        if(!imageCanvas) {
            return;
        }

        var lastAppliedPan = imageCanvas.lastAppliedPan;
        if(lastAppliedPan) {
            var ctx = this.renderWidgetCtx;
            var tpts = ctx.getTransform();
            ctx.setTransform(tpts.a, tpts.b, tpts.c, tpts.d, lastAppliedPan.e, lastAppliedPan.f);
            this.renderImage(false);
            this.updatePanTransform();
        }
    }
    catch(e)
    { }
}/**
 * Preference info class is used to maintain the preference information for ECG.
 * These preference will be maintain at SeriesLevel Layout.
 */
function PreferenceInfo() {
    "use strict";
    // Selected ECG format is used to pass the URL to get images from server.
    this.selectedEcgFormat = {};

    this.windowLevelSettings = 1;
	
	this.zoomLevelSetting = "1_zoom"

    // ECG Preference with default values.
    this.preferenceData = {
        gridType : 'onemm',
        gridColor : 'redGrid',
        leadFormat : 'threebyfour',
        signalThickness : 'onethickness',
        gain : 'tenmmgain'
    };
}

/**
 * Initialize the preference default values.
 */
PreferenceInfo.prototype.init = function () {
    "use strict";
    this.setGridType('onemm');
    this.setGridColor('redGrid');
    this.setLeadFormat('threebyfourplusthree');
    this.setSignalThickness('onethickness');
    this.setGain('tenmmgain');

    this.addECGParameters("GridType", "1");
    this.addECGParameters("GridColor", "0");
    this.addECGParameters("SignalThickness", "1");
    this.addECGParameters("Gain", "1");
    this.addECGParameters("DrawType", "8");
};

PreferenceInfo.prototype.setWindowLevelSettings = function(windowLevelId) {
    this.windowLevelSettings = windowLevelId;
}

PreferenceInfo.prototype.setZoomLevelSettings = function(zoomLevelSetting) {
    this.zoomLevelSetting = zoomLevelSetting;
}

PreferenceInfo.prototype.getZoomLevelSettings = function(windowLevelId) {
    return this.zoomLevelSetting;
}

PreferenceInfo.prototype.getECGParameters = function () {
    "use strict";
    return this.selectedEcgFormat;
};

PreferenceInfo.prototype.addECGParameters = function (key, value) {
    "use strict";
    this.selectedEcgFormat[key] = value;
};

PreferenceInfo.prototype.getGridType = function () {
    "use strict";
    return this.preferenceData.gridType;
};

PreferenceInfo.prototype.setGridType = function (gridType) {
    "use strict";
    this.preferenceData.gridType = gridType;
};

PreferenceInfo.prototype.getGridColor = function () {
    "use strict";
    return this.preferenceData.gridColor;
};

PreferenceInfo.prototype.setGridColor = function (gridColor) {
    "use strict";
    this.preferenceData.gridColor = gridColor;
};

PreferenceInfo.prototype.getLeadFormat = function () {
    "use strict";
    return this.preferenceData.leadFormat;
};

PreferenceInfo.prototype.setLeadFormat = function (leadFormat) {
    "use strict";
    this.preferenceData.leadFormat = leadFormat;
};

PreferenceInfo.prototype.getGain = function () {
    "use strict";
    return this.preferenceData.gain;
};

PreferenceInfo.prototype.setGain = function (gain) {
    "use strict";
    this.preferenceData.gain = gain;
};

PreferenceInfo.prototype.getSignalThickness = function () {
    "use strict";
    return this.preferenceData.signalThickness;
};

PreferenceInfo.prototype.setSignalThickness = function (signalThickness) {
    "use strict";
    this.preferenceData.signalThickness = signalThickness;
};function Presentation()
{
	this.invert = false;
	this.windowWidth;
	this.windowCenter;
	this.rescaleSlope;
	this.rescaleIntercept;
	this.zoom = 1.0;
    this.sharpen = 0;
    this.zoomLevel = 1;
    this.windowLevel = 1;
	this.panX = 0;
	this.PanY = 0;
	this.rotation = 0;
    this.isRotation = false;
    this.orientation = 0;
    this.isFlipHorizontalRequired = false;
	this.presentationMode = "SCALE_TO_FIT"; //Could be SCALE_TO_FIT /MAGNIFY 
	this.lookupObj = new LookupTable();
	this.scaleMultiplier = 0.8;
	this.currentPreset=0;
	this.minPixel=0;
	this.maxPixel=0;
	this.windowLevelLimits;
	this.vFlip = false;
    this.hFlip = false;
    this.fitToWindow = false;
    this.isRotationChange = false;
	this.rgbMode = 0;
 	this.pan = {
			x : 0,
			y : 0
		};
}

Presentation.prototype.copy=function(presentation)
{
    presentation.invert = this.invert;
	presentation.windowWidth = this.windowWidth;
	presentation.windowCenter = this.windowCenter;
	presentation.rescaleSlope = this.rescaleSlope;
	presentation.rescaleIntercept = this.rescaleIntercept;
	presentation.zoom = this.zoom;
    presentation.sharpen = this.sharpen;
	presentation.panX = this.panX ;
	presentation.PanY = this.PanY;
	presentation.rotation = this.rotation;
    presentation.isRotation = this.isRotation;
    presentation.orientation = this.orientation;
    presentation.isFlipHorizontalRequired = this.isFlipHorizontalRequired;
	presentation.presentationMode = this.presentationMode; //Could be SCALE_TO_FIT /MAGNIFY 
	presentation.lookupObj = this.lookupObj;
	presentation.scaleMultiplier = this.scaleMultiplier;
	presentation.currentPreset = this.currentPrese;
	presentation.minPixel = this.minPixel;
	presentation.maxPixel = this.maxPixel;
	presentation.windowLevelLimits = this.windowLevelLimits;
	presentation.vFlip = this.vFlip;
    presentation.hFlip = this.hFlip;
    presentation.fitToWindow = this.fitToWindow;
	presentation.rgbMode = this.rgbMode;
	presentation.zoomLevel = this.zoomLevel ;
    presentation.windowLevel = this.windowLevel ;
}

Presentation.prototype.setWindowLevel=function(dicominfo,minMax,invert)
{	
	this.rescaleSlope= dicominfo.getRescaleSlope();
	this.rescaleIntercept=dicominfo.getRescaleIntercept();
	this.minPixel = minMax.min;
	this.maxPixel = minMax.max;
	this.invert = invert;	
	this.lookupObj.setData(this.windowCenter, this.windowWidth, this.rescaleSlope, this.rescaleIntercept,minMax,invert);
};	

Presentation.prototype.setWindowingdata=function(wc,ww)
{
	this.lookupObj.setWindowingdata(wc,ww);
	this.windowCenter=wc;
	this.windowWidth=ww;	
};

Presentation.prototype.setWindowLevelLimits = function(windowLevelLimits)
{
	this.windowLevelLimits = windowLevelLimits;
}

Presentation.prototype.setInvertFlag = function(flag)
{
	this.invert = flag;	
	this.lookupObj.setInvertData(this.invert);	
}

Presentation.prototype.getInvertFlag = function(flag)
{
	return this.invert;		
}

Presentation.prototype.getWindowWidth=function()
{
	return this.windowWidth	;
};

Presentation.prototype.getWindowCenter=function()
{
	return this.windowCenter;
};

Presentation.prototype.setZoom=function(zoom)
{
	this.zoom = zoom;	
};

Presentation.prototype.getZoom=function()
{
	return this.zoom;	
};

Presentation.prototype.setSharpen=function(sharpen)
{
    this.sharpen = sharpen;	
};

Presentation.prototype.getSharpen=function()
{
    return this.sharpen;	
};


Presentation.prototype.setZoomLevel=function(zoomLevel)
{
    this.zoomLevel = zoomLevel;
};

Presentation.prototype.setPresetWindowLevelValue=function(windowLevel)
{
    this.windowLevel = windowLevel;
};

Presentation.prototype.getZoomLevel=function()
{
    return this.zoomLevel;
};

Presentation.prototype.setPan=function(x, y)
{
	
	this.pan.x = x;
	this.pan.y = y;
};

Presentation.prototype.getPan=function()
{
	return this.pan;
};
Presentation.prototype.setRotation=function(rotation)
{
	if(rotation == 360)
	{
		this.rotation = 0;
	}
	else
	{	
		this.rotation = rotation;
	}
    this.isRotation = true;
};

Presentation.prototype.getRotation=function()
{
	return this.rotation;
};

Presentation.prototype.getlookupTable=function()
{
	return this.lookupObj;
};

Presentation.prototype.isScaleToFitMode=function()
{
	if(this.presentationMode == "SCALE_TO_FIT") return true;
	else return false;	
};

Presentation.prototype.setPresentationMode = function(pMode) {
    this.presentationMode = pMode;
}

Presentation.prototype.getPresentationMode = function() {
    return this.presentationMode;
}

Presentation.prototype.setRGBMode = function (rgbMode) {
    this.rgbMode = rgbMode;
};

Presentation.prototype.getRGBMode = function () {
    return this.rgbMode;
};

Presentation.prototype.setVerticalFilp = function(vFlip)
{
    this.vFlip = vFlip;
    this.isRotation = false;
};

Presentation.prototype.getVerticalFilp = function()
{
    return this.vFlip;
};

Presentation.prototype.setHorizontalFilp = function(hFlip)
{
    this.hFlip = hFlip;
    this.isRotation = false;
};

Presentation.prototype.getHorizontalFilp = function()
{
    return this.hFlip;
};

Presentation.prototype.setOrientation = function (orientation) {
    this.orientation = orientation;
};

Presentation.prototype.getOrientation = function () {
    return this.orientation;
};

Presentation.prototype.isFlipHoriRequired = function () {
    return this.isFlipHorizontalRequired;
};

Presentation.prototype.setIsRotationChange = function(flag){
    this.isRotationChange = flag;
};

Presentation.prototype.getIsRotationChange = function(){
    return this.isRotationChange;
};
Presentation.prototype.updateRotateAndFlip = function () {
    var isRotated = false;
    this.isFlipHorizontalRequired = false;

    if (this.hFlip === true) {
        if (this.rotation === 90 || this.rotation === 270) {
            isRotated = true;
        }
    }

    var isFlipNone = (this.hFlip === false && this.vFlip === false);
    var isFlipBoth = (this.hFlip === true && this.vFlip === true);
    if ((this.rotation == 0 && isFlipNone) || (this.rotation == 180 && isFlipBoth)) {
        this.rotation = 0;
        this.isFlipHorizontalRequired = false;
    } else if ((this.rotation == 90 && isFlipNone) || (this.rotation == 270 && isFlipBoth)) {
        this.rotation = 90;
        this.isFlipHorizontalRequired = false;
    } else if ((this.rotation == 180 && isFlipNone) || (this.rotation == 0 && isFlipBoth)) {
        this.rotation = 180;
        this.isFlipHorizontalRequired = false;
    } else if ((this.rotation == 270 && isFlipNone) || (this.rotation == 90 && isFlipBoth)) {
        this.rotation = 270;
        this.isFlipHorizontalRequired = false;
    } else if ((this.rotation == 0 && this.hFlip === true) || (this.rotation == 180 && this.vFlip === true)) {
        this.rotation = 0;
        this.isFlipHorizontalRequired = true;
    } else if ((this.rotation == 90 && this.hFlip === true) || (this.rotation == 270 && this.vFlip === true)) {
        if (isRotated) {
            this.rotation = 270;
        } else {
            this.rotation = 90;
        }
        this.isFlipHorizontalRequired = true;
    } else if ((this.rotation == 180 && this.hFlip === true) || (this.rotation == 0 && this.vFlip === true)) {
        this.rotation = 180;
        this.isFlipHorizontalRequired = true;
    } else if ((this.rotation == 270 && this.hFlip === true) || (this.rotation == 90 && this.vFlip === true)) {
        if (isRotated) {
            this.rotation = 90;
        } else {
            this.rotation = 270;
        }

        this.isFlipHorizontalRequired = true;
    }

    if (this.isFlipHorizontalRequired === true) {
        if (this.rotation === 90) {
            this.rotation = 270;
        } else if (this.rotation === 270) {
            this.rotation = 90;
        }
    }
};function SeriesLevelLayout(seriesLayoutId)
{
	this.seriesLayoutId = seriesLayoutId;
	this.seriesIndex;
	this.imageLayoutDimension;
	this.imageCount;
	this.isOverlayEnable = false;
	this.imageRenders = new Array();
    this.preferenceInfo;

	this.scrollData = {
		imageIndex : 0,
		frameIndex : 0		
	};
    this.isDragAndDrop = false;
    this.progressbar = undefined;
    this.imageType = undefined;
    this. leadValue = {};
    this.ecgCanvas = undefined;
    this.isCaliperEnable = true;
	this.studyUid = undefined;
    this.backupEnabled = false;
}

SeriesLevelLayout.prototype.getPreferenceInfo = function()
{
	return this.preferenceInfo;
};

SeriesLevelLayout.prototype.setPreferenceInfo = function(preferenceInfo)
{
	this.preferenceInfo = preferenceInfo;
};

SeriesLevelLayout.prototype.getImageIndex = function()
{
	return this.scrollData.imageIndex;
};

SeriesLevelLayout.prototype.setImageIndex = function(index)
{
	this.scrollData.imageIndex = index;
};

SeriesLevelLayout.prototype.setFrameIndex = function(index)
{
	this.scrollData.frameIndex = index;
};

SeriesLevelLayout.prototype.getFrameIndex = function()
{
	return this.scrollData.frameIndex;
};

SeriesLevelLayout.prototype.getSeriesLayoutId = function()
{
	return this.seriesLayoutId;
};

SeriesLevelLayout.prototype.setSeriesIndex=function(seriesIndex)
{
	this.seriesIndex = seriesIndex;	
};

SeriesLevelLayout.prototype.getSeriesIndex = function()
{
	return this.seriesIndex;
};

SeriesLevelLayout.prototype.setImageLayoutDimension = function(dimension)
{
	this.imageLayoutDimension = dimension;
};

SeriesLevelLayout.prototype.getImageLayoutDimension = function()
{
	return this.imageLayoutDimension;
};

SeriesLevelLayout.prototype.addImageRender = function(addImageRender, imageRender)
{
	this.imageRenders[addImageRender] = imageRender;
};

SeriesLevelLayout.prototype.getImageRender = function(imageLayoutId)
{
	return this.imageRenders[imageLayoutId];
};

SeriesLevelLayout.prototype.getAllImageRenders = function()
{
    return this.imageRenders;
};

SeriesLevelLayout.prototype.removeAllImageRenders = function()
{
	for (var key in this.imageRenders)
    {
       delete this.imageRenders[key];
    }
};

SeriesLevelLayout.prototype.getImageLayoutCount = function()
{
	var dim = this.getImageLayoutDimension();
	if(!dim)
	{
		return 0;
	}
	var ir = dim.split("x");
	return parseInt(ir[0])*parseInt(ir[1]);
};

SeriesLevelLayout.prototype.setImageCount = function(count)
{
	this.imageCount = count;
};

SeriesLevelLayout.prototype.getImageCount = function()
{
	return this.imageCount;
};

SeriesLevelLayout.prototype.getProgressbar = function()
{
    return this.progressbar;
};

SeriesLevelLayout.prototype.setProgressbar = function(progressbar)
{
    this.progressbar = progressbar;
};

SeriesLevelLayout.prototype.refreshViewports = function( soucre)
{
    for (var key in this.imageRenders)
    {
        if(soucre == this.imageRenders[key])
        {
            return;
        }
        this.imageRenders[key].drawDicomImage();
    }
};

SeriesLevelLayout.prototype.getDefaultRenderer = function()
{
    for (var key in this.imageRenders)
    {
       if(this.imageRenders[key] != undefined)
        {
            return this.imageRenders[key];
        }
    }
};

SeriesLevelLayout.prototype.getDefaultRendererImageUid = function( )
{
    var aRenderer = this.getDefaultRenderer();
    if(aRenderer != undefined)
    {
        return aRenderer.imageUid;
    }
};
SeriesLevelLayout.prototype.getImageType = function()
{
	return this.imageType;
};

SeriesLevelLayout.prototype.setImageType = function(imageType)
{
	this.imageType = imageType;
};
SeriesLevelLayout.prototype.setStudyUid = function(studyUid)
{
	this.studyUid = studyUid;
};
SeriesLevelLayout.prototype.getStudyUid = function()
{
	return this.studyUid;
};
SeriesLevelLayout.prototype.setEcgCanvas = function(value)
{
    this.ecgCanvas = value;
}
SeriesLevelLayout.prototype.getEcgCanvas = function()
{
    return this.ecgCanvas;
}

SeriesLevelLayout.prototype.setCaliperEnable = function(isCaliperEnable)
{
    this.isCaliperEnable = isCaliperEnable;
}
SeriesLevelLayout.prototype.isCaliperEnable = function()
{
    return this.isCaliperEnable;
}
SeriesLevelLayout.prototype.updateImageRendersTo = function(oldSeriesLayoutId,newSeriesLayoutId)
{
    for (var key in this.imageRenders)
    {
        if(key.indexOf(oldSeriesLayoutId) > -1){
            var newKey = key.replace(oldSeriesLayoutId, newSeriesLayoutId);
            this.addImageRender(newKey,Object.create(this.imageRenders[key]));
            delete this.imageRenders[key];
        }
    }
}
SeriesLevelLayout.prototype.copy = function()
{
    var viewport = new SeriesLevelLayout(this.seriesLayoutId);
    viewport.seriesLayoutId = this.seriesLayoutId;
	viewport.seriesIndex = this.seriesIndex;
	viewport.imageLayoutDimension = this.imageLayoutDimension;
	viewport.imageCount = this.imageCount;
	viewport.isOverlayEnable = this.isOverlayEnable;
	//viewport = this.imageRenders = new Array();
    for (var key in this.imageRenders)
    {
       viewport.addImageRender(key,this.imageRenders[key]);
    }
    viewport.preferenceInfo = this.preferenceInfo;
    if(this.scrollData !== undefined)
    {
        viewport.scrollData = {};
        viewport.scrollData.imageIndex = this.scrollData.imageIndex;
        viewport.scrollData.frameIndex = this.scrollData.frameIndex;
    }
	
    viewport.isDragAndDrop = this.isDragAndDrop;
    viewport.progressbar = this.progressbar;
    viewport.imageType = this.imageType;
    viewport.leadValue = this. leadValue;
    viewport.ecgCanvas = this.ecgCanvas;
    viewport.isCaliperEnable = this.isCaliperEnable;
	viewport.studyUid = this.studyUid;
    viewport.backupEnabled = this.backupEnabled;
    return viewport;
}/**
 * Create thumbnail images
 *  */
var dragThumbnailStudyUid;
function ThumbnailRenderer() {
    var thumbnailWidth = THUMBNAIL_PANEL_WIDTH-32;
    this.uid = guid();
    this.imageURL;
    this.metaInfo;
    this.renderWidget = document.createElement("canvas");
    this.renderWidget.width = thumbnailWidth;
    this.renderWidget.height = 105;
    this.renderWidget.setAttribute("id", "thumb" + this.uid);
    this.renderWidget.setAttribute("draggable", true);
    this.renderWidget.setAttribute("ondragstart", "doDrag(event)");
    // this.renderWidget.setAttribute("ontouchstart", "loadSeries(event)");
    // this.renderWidget.setAttribute("onclick", "loadImage(event)");
    this.touchEvent = false;
    this.gestureEvent = false;
    this.seriesIndex;
    this.selfReference = this;
    //this.imageUid;
	this.studyUid;
	this.imageUid;
};
var xPostion = 10;
var yPostion = 10;
var fillColour = "yellow";
var font = "bold 8pt Helvetica";

/**
 *@param imageUid
 *@param appendTo
 *@param seriesIndex
 *@param imageCountOfSeries
 *Create the thumbnail url and send request when the requeststatus is success
 *create the div for series thumbnail and draw the thumbnail image in canvas
 */
ThumbnailRenderer.prototype.createThumbnail = function (studyUid,imageUid, appendTo, seriesIndex, imageCountOfSeries) {
    this.seriesIndex = seriesIndex;
    this.imageUid = imageUid;
    this.imageCountOfSeries = imageCountOfSeries;
    document.getElementById(appendTo).appendChild(this.renderWidget);
	logger.startTime("thumbnail "+imageUid)

    if(thumbnailWidth == undefined ) {
        thumbnailWidth = document.getElementById(appendTo).offsetWidth;
    }

    //Load image
    /*var urlParameters = {
        Format: "Abstract",
        //Broker: dicomViewer.broker.getBroker(),
        ImageUid: imageUid,
        studyUid: dicomViewer.Study.getStudyUid(),
        SecurityToken: dicomViewer.security.getSecurityToken(),
		RequestId: new Date().getTime()
    };*/
	var urlParameters = dicomViewer.getThumbnailUrl(imageUid);
    var url = dicomViewer.url.getDicomImageURL(urlParameters);
	logger.info("Sereies Thumbnail request URL : "+url);
    var request = new XMLHttpRequest();
    request.open('GET', url, true);
    var thumbnailRendererObject = this;
	var cacheIndicatorDisplay = "";
	if(dicomViewer.thumbnail.isShowCacheIndicatorOnThumbnail())
        cacheIndicatorDisplay = "block";
    else
       cacheIndicatorDisplay = "none";
    request.send();
    
    request.onreadystatechange = function () {
        if (request.readyState == 4 && request.status == 200) {
            logger.endTime("thumbnail "+imageUid);
            var image = dicomViewer.Series.Image.getImage(studyUid,seriesIndex, 0);
            var instanceNumber = "&nbsp";
            if (dicomViewer.thumbnail.isImageThumbnail(image)) {
                instanceNumber = image.instanceNumber;
            } else {
                instanceNumber = seriesIndex + 1;
            }
            var imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
            var modality = dicomViewer.changeNullToEmpty(dicomViewer.Series.getModality(studyUid, seriesIndex));
            var seriesTimeId = image.imageUid + "seriesTime";
			if(modality == "") modality = "&nbsp";
            if(imageCount == "") imageCount = "&nbsp";
            if(instanceNumber == "") instanceNumber = "&nbsp";
            
            var datadiv = "";
            var imageFileId = undefined;
            var imageFileDescription = "";
            if(image.imageType === IMAGETYPE_JPEG || isBlob(image.imageType)) {
                imageFileId = seriesTimeId + "_" + instanceNumber;

              	datadiv  =  "<div class='row'>" +
                        	"<div id='" + imageFileId + "' class='col-xs-2'><font color='#D2F4EF'>" + imageFileDescription + "</font></div>" + "<div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>" + instanceNumber + "</font></div></div><div class='row'>" + "<div class='col-xs-2'><font color='#D2F4EF'>" + imageCount + "</font></div>" 
							+ "<div id='" + seriesTimeId + "' style=\"display:"+cacheIndicatorDisplay+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div>" + "</div>"
            }else{
              datadiv  = "<div class='row'>" +
                "<div class='col-xs-2'><font color='#D2F4EF'>" + modality + "</font></div>" + "<div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>" + instanceNumber + "</font></div></div><div class='row'>" + "<div class='col-xs-2'><font color='#D2F4EF'>" + imageCount + "</font></div>" 
                  + "<div id='" + seriesTimeId + "' style=\"display:"+cacheIndicatorDisplay+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div>" + "</div>"
            }
            //<div style='height:10px;width:10px;background:red;border-radius: 5px;'></div>
            var seriesDescText = getSeriesDescription(studyUid, seriesIndex);
            var seriesDesc = showSeriesDescription(studyUid, seriesIndex);             
            $("#" + appendTo).prepend(seriesDesc);
            if(seriesDescText != undefined && seriesDescText != "")
                updateToolTip($("#" + appendTo ), seriesDescText, 'top');
            
            $("#" + appendTo).append(datadiv);
            if(image.imageType === IMAGETYPE_JPEG || isBlob(image.imageType)) {
                if(imageFileId != undefined && imageFileDescription != "") {
                    updateToolTip($("#" + imageFileId ), image.fileName, 'top');                    
                }
            }

            if(image.imageType == IMAGETYPE_JPEG || image.imageType == IMAGETYPE_RADPDF || image.imageType == IMAGETYPE_PDF || isBlob(image.imageType)){
                if(image.imageUid !== undefined && studyUid !== undefined){
                    if(nonDICOMCacheDetails[image.imageUid] == undefined) {
                        nonDICOMCacheDetails[image.imageUid] = studyUid;
                        nonDICOMRenderedCount++;
                    }else {
                        for(key in nonDICOMCacheDetails){
                            if(key !== image.imageUid){
                                nonDICOMCacheDetails[image.imageUid] = studyUid;
                                nonDICOMRenderedCount++;
                            }
                        }
                    }
                    $("#cachemanager_progress").trigger("image_cache_updated",  dicomViewer.imageCache.getCacheInfo());
                    updateThumbnailCacheIndication(image.imageUid, "green");
                }
            }

            if(thumbnailHeight == undefined){
                thumbnailHeight = document.getElementById(appendTo).offsetHeight;
            }

            thumbnailRendererObject.draw(studyUid, JSON.parse(request.responseText).imageData, appendTo);
            var lastDivId = $("#imageThumbnail_View div").last().parent().parent().attr('id'); //document.getElementById("myList").lastChild

            if(thumbnailHeight && thumbnailWidth) {
                document.getElementById(appendTo).style.height = thumbnailHeight +"px";
                document.getElementById(appendTo).style.width = thumbnailWidth + "px";
             }

            if(lastDivId === appendTo)
            {
                dicomViewer.resizeThumbnailPanel();
            }
        } else if (request.readyState == 4 && (request.status == 404 || request.status == 500)) {
            // If the requested thumbnail image is not loaded successfully, we just shown empty values to add thumbnail gap issue.
            var modality = "&nbsp";
            var seriesTimeId = "&nbsp";
            var imageCount = "&nbsp";
            var instanceNumber = "&nbsp";
            var datadiv = "<div class='row'>" +
                "<div class='col-xs-2'><font color='#D2F4EF'>" + modality + "</font></div>" + "<div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>" + instanceNumber + "</font></div></div><div class='row'>" + "<div class='col-xs-2'><font color='#D2F4EF'>" + imageCount + "</font></div>" + "<div id='" + seriesTimeId + "' style=\"display:"+cacheIndicatorDisplay+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div>" + "</div>"
            $("#" + appendTo).append(datadiv);
        }
    }
};

/**
 *@param imageUid
 *@param appendTo
 *@param seriesIndex
 *@param imageCountOfSeries
 *Create the thumbnail url and send request when the requeststatus is success
 *create the div for image thumbnail and draw the thumbnail image in canvas
 */
ThumbnailRenderer.prototype.createImageThumbnail = function (studyUid, imageUid, appendTo, seriesIndex, imageCountOfSeries) {
    this.seriesIndex = seriesIndex;
    this.imageUid = imageUid;
    this.imageCountOfSeries = imageCountOfSeries;
    document.getElementById(appendTo).appendChild(this.renderWidget);
	logger.startTime("thumbnail "+imageUid);
    //Load image
    var urlParameters = dicomViewer.getThumbnailUrl(imageUid);
    var url = dicomViewer.url.getDicomImageURL(urlParameters);
	logger.info("Image Thumbnail request URL : "+url);
    var request = new XMLHttpRequest();
    request.open('GET', url, true);
    var thumbnailRendererObject = this;
	var cacheIndicatorDisplay = "";
	if(dicomViewer.thumbnail.isShowCacheIndicatorOnThumbnail())
        cacheIndicatorDisplay = "block";
    else
       cacheIndicatorDisplay = "none";
    request.send();
    request.onreadystatechange = function () {
        if (request.readyState == 4 && request.status == 200) {
			logger.endTime("thumbnail "+imageUid);
            var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageCountOfSeries - 1);
            var seriesTimeId = image.imageUid + "seriesTime";
            var modality = dicomViewer.Series.getModality(studyUid, seriesIndex);
            var instanceNumber = "&nbsp";
            var framecount = dicomViewer.Series.Image.getImageFrameCount(image);

            if (dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex)) {
                instanceNumber = image.instanceNumber;
            } else {
                instanceNumber = seriesIndex + 1;
            }

            modality =  (modality == null || modality == undefined) ? "" : modality;
            if(modality == "") modality = "&nbsp";
            if(framecount == "") framecount = "&nbsp";
            if(instanceNumber == "") instanceNumber = "&nbsp";
            var datadiv = "<div class='row'>" +
                "<div class='col-xs-2'><font color='#D2F4EF'>" + modality  +"</font></div>" + "<div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>" + instanceNumber + "</font></div></div><div class='row' style='height:10px'>" + "<div class='col-xs-2'><font color='#D2F4EF'>" + framecount + "</font></div>" + "<div id='" + seriesTimeId + "' style=\"display:"+cacheIndicatorDisplay+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div>" 
            + "</div>";
            //<div style='height:10px;width:10px;background:red;border-radius: 5px;'></div>
            
            
            $("#" + appendTo).append(datadiv);
            
            //Show the series description in the thumbnail
            var seriesDescText = getSeriesDescription(studyUid, seriesIndex);
            var seriesDesc = showSeriesDescription(studyUid, seriesIndex);                       
            $("#" + appendTo).prepend(seriesDesc);
            if(seriesDescText != undefined && seriesDescText != "")
                updateToolTip($("#" + appendTo ), seriesDescText, 'top');

            if(thumbnailHeight == undefined) {
                thumbnailHeight = document.getElementById(appendTo).offsetHeight;
            }

            thumbnailRendererObject.draw(studyUid, JSON.parse(request.responseText).imageData, appendTo);
            var lastDivId = $("#imageThumbnail_View div").last().parent().parent().attr('id'); //document.getElementById("myList").lastChild

            if(thumbnailHeight && thumbnailWidth) {
                document.getElementById(appendTo).style.height = thumbnailHeight +"px";
                document.getElementById(appendTo).style.width = thumbnailWidth + "px";
             }

            if(lastDivId === appendTo)
            {
                dicomViewer.resizeThumbnailPanel();
            }
        } else if (request.readyState == 4 && (request.status == 404 || request.status == 500)) {
            // If the requested thumbnail image is not loaded successfully, we just shown empty values to add thumbnail gap issue.
            var modality = "&nbsp";
            var seriesTimeId = "&nbsp";
            var imageCount = "&nbsp";
            var instanceNumber = "&nbsp";
            var datadiv = "<div class='row'>" +
                "<div class='col-xs-2'><font color='#D2F4EF'>" + modality + "</font></div>" + "<div class='col-xs-2 col-xs-offset-4'><font color='#D2F4EF'>" + instanceNumber + "</font></div></div><div class='row'>" + "<div class='col-xs-2'><font color='#D2F4EF'>" + imageCount + "</font></div>" + "<div id='" + seriesTimeId + "' style=\"display:"+cacheIndicatorDisplay+"\" class='col-xs-2 col-xs-offset-4'><img id='test' style='width:20px;' src='images/download-tostart.png' /></div>" + "</div></div><div class='row'><div class='col-xs-2'><img id='tmpIcon' style='width:20px;' src='images/no-indicator.png' /></div></div>";            
            //<div style='height:10px;width:10px;background:red;border-radius: 5px;'></div>
            $("#" + appendTo).append(datadiv);
        }
    }
};

/**
 *@param imageType
 */
ThumbnailRenderer.prototype.createNonDCMThumbnail = function (studyUid, imageUid, thumbnailId, seriesIndex, fileName)
{
    
     var thumbnailRendererObject = this;
    this.seriesIndex = seriesIndex;
    this.imageUid = imageUid;    
     var splitedValue = fileName.split(".");
    var fileExtension = splitedValue[splitedValue.length-1]
    
    document.getElementById(thumbnailId).appendChild(this.renderWidget);
    if(fileExtension == "mp3")
    {
        thumbnailRendererObject.draw(studyUid,"images/mp3.png", thumbnailId);
        //modality = fileName;
    }
    else if(fileExtension == "mp4"  || fileExtension == "avi")
    {
        thumbnailRendererObject.draw(studyUid, "images/mp4.jpg", thumbnailId);
        //modality = fileName;
    }
    else if(fileExtension === "pdf"){
        thumbnailRendererObject.draw(studyUid, "images/radpdf.png", thumbnailId);
    }
    else if(fileExtension === "html"){
        thumbnailRendererObject.draw(studyUid, "images/html.png",thumbnailId);
    }
    else if(fileExtension === "txt"){
        thumbnailRendererObject.draw(studyUid, "images/text.png",thumbnailId);
    }else{
        thumbnailRendererObject.draw(studyUid, "images/invalid.png",thumbnailId);
    }
    
    var fileLength = 20;
    if(fileName.length<20){
        fileLength = fileName.length;
    }
    fileName =   fileName.replace(/\^/g, '');
    fileName =   fileName.replace(/\ /g, '');
    fileName =   fileName.replace(/\-/g, '');
                
    
  /*  if(imageType == IMAGETYPE_RADPDF)
    {
        thumbnailRendererObject.draw(studyUid,"images/radpdf.png");
        modality = "ECG";
    }
    else if(imageType == IMAGETYPE_RADECG)
    {
        thumbnailRendererObject.draw(studyUid, "images/radecg.png");
        modality = "ECG";
    }    */
    var datadiv = "<div class='row'>" +"<div class='col-xs-2'><font color='#D2F4EF'>" + fileName.substr(0,fileLength) + "</font></div></div>"
    $("#" + thumbnailId).append(datadiv);
};

/**
 *@param dataURL
 *Using the dataURL(contaions the url path of thumbnail image) display thumbnail image
 */
ThumbnailRenderer.prototype.draw = function (studyUid, dataURL, thumbnailId) {

    var context = this.renderWidget.getContext("2d");
    var imageCount = dicomViewer.Series.getImageCount(studyUid,this.seriesIndex);
    //For shifting the thumbnail image at the center (movement along x-axis)
    var widthMultiplier = ($("#"+thumbnailId).width())/100;
    // load image from data url
    var imageObj = new Image();
    imageObj.onload = function () {
        context.translate(50 * widthMultiplier, 50);
        var scale = Math.min(100 / this.width, 100 / this.height);
        context.scale(scale, scale);
        context.drawImage(this, -this.width / 2, -this.height / 2);
        context.fillStyle = fillColour;
        context.font = font;
        var lastDivId = $("#imageThumbnail_View div").last().parent().parent().attr('id');
        if(lastDivId === thumbnailId) {
            //dicomViewer.resizeThumbnailPanel();
        }
    };
    imageObj.src = dataURL;
};
ThumbnailRenderer.prototype.setStudyUid = function (studyUid) {
	this.studyUid = studyUid;
}
ThumbnailRenderer.prototype.getStudyUid = function () {
	return this.studyUid;
}
/*
 * loadSeries : to load the series from thumbnail to current viewport using
 * touch double tab
 */
var touchCount = 0;
var elementId = null;

function loadSeries(ev) {
    ev.preventDefault();
    var thumbnailId = $('#' + ev.target.id).parent().attr('id');
    var thumbnailRenderer = dicomViewer.thumbnail.getThumbnail(thumbnailId);
    loadImageInViewer(thumbnailRenderer);
}

/**
 *@param ev
 *Using ev get the thumbnail div id and get the thumbnail render object and set values to the MouseEvent
 */
function doDrag(ev) {
    var thumbnailRenderer = dicomViewer.thumbnail.getThumbnail($('#' + ev.target.id).parent().attr('id'));
	dragThumbnailStudyUid = thumbnailRenderer.getStudyUid();
	var dragThumDetails = "text";
	ev.dataTransfer.setData(dragThumDetails, ev.target.id);
}

function loadImage(ev) {
    var thumbnailId = ev.currentTarget.id;
    var thumbnailRenderer = dicomViewer.thumbnail.getThumbnail(thumbnailId);
    loadImageInViewer(thumbnailRenderer, thumbnailId);
}
function loadImageInViewer(thumbnailRenderer, thumbnailId) {    
    
	if(thumbnailRenderer.imageCountOfSeries === undefined) thumbnailRenderer.imageCountOfSeries = 1;

    // Get the series layout
    var seriesLayout = getAndSelectLayout(thumbnailRenderer.studyUid);
    var isViewportHeightUpdate = false;
     if(seriesLayout.studyUid == undefined || seriesLayout.setStudyUid == null) {
        isViewportHeightUpdate = true;
    }
    if((seriesLayout.studyUid !== undefined || seriesLayout.studyUid != null) &&thumbnailRenderer.studyUid != seriesLayout.studyUid)
    {
        dicomViewer.thumbnail.alertThumbnailSelection(thumbnailId);
        return;
    } else if(!IsSameStudy(thumbnailRenderer.studyUid)) {
        dicomViewer.thumbnail.alertThumbnailSelection(thumbnailId);
        return;
    }
    var studyUid = thumbnailRenderer.getStudyUid();	
    var currentSeriesLayoutId = seriesLayout.seriesLayoutId;
    var imageIndex = undefined;
    if (dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, thumbnailRenderer.seriesIndex)) {
        imageIndex = parseInt( dicomViewer.Series.Image.getImageIndex(studyUid, thumbnailRenderer.seriesIndex, thumbnailRenderer.imageUid));
    }
    else {
        imageIndex = getImageIndexBySeriesIndex(studyUid, thumbnailRenderer.seriesIndex);
    }

    // Allow to load the new/same series 
    if(seriesLayout.seriesIndex === undefined && imageIndex !== undefined) {
        imageIndex = undefined;
    }

    var viewport = dicomViewer.viewports.getViewportByImageIndex(studyUid, thumbnailRenderer.seriesIndex, imageIndex);

    // Check whether the active viewport and selected series view port id is same
    if(isFullScreenEnabled == true && viewport !== undefined && seriesLayout !== undefined) {
        if(getStudyLayoutId(viewport.seriesLayoutId) === getStudyLayoutId(seriesLayout.seriesLayoutId)) {
            viewport = undefined;
        }
    }

    var checkViewport = true;
    if(viewport === undefined && imageIndex !== -1) {
        checkViewport = dicomViewer.viewports.checkVewportAvailable(currentSeriesLayoutId, studyUid);
        if(!checkViewport) {
            return;
        }
        seriesLayout.setStudyUid(studyUid);
        if(isViewportHeightUpdate) {
            var image = dicomViewer.Series.Image.getImage(seriesLayout.studyUid, thumbnailRenderer.seriesIndex, 0);
            viewportHeight(seriesLayout.seriesLayoutId,image.imageType);
        }
        //dicomViewer.scroll.stopCineImage(true);    
        dicomViewer.loadImageFromThumbnail(thumbnailRenderer.seriesIndex, thumbnailRenderer.imageCountOfSeries);
        if(isViewportHeightUpdate && dicomViewer.isDicomStudy(seriesLayout.studyUid) && document.getElementById(seriesLayout.seriesLayoutId+"_progress")) {
            var progressHeight = document.getElementById(seriesLayout.seriesLayoutId+"_progress").style.top;
            progressHeight = progressHeight.replace('px','');
            document.getElementById(seriesLayout.seriesLayoutId+"_progress").style.top = (parseInt(progressHeight)+15) + "px" ;
            var viewportId = (seriesLayout.seriesLayoutId).split("_")[1];
            dicomViewer.createSaveAndLoadPStateGUI("saveAndLoad_"+viewportId, seriesLayout.studyUid, viewportId);
        }

    }else if(viewport === undefined && imageIndex === -1){
		seriesLayout.setStudyUid(studyUid);
		dicomViewer.setActiveSeriesLayout(seriesLayout);
		dicomViewer.loadImageFromThumbnail(thumbnailRenderer.seriesIndex, thumbnailRenderer.imageCountOfSeries);
	}else if(viewport !== undefined && seriesLayout.studyUid === undefined) {
		seriesLayout.setStudyUid(studyUid);
		dicomViewer.setActiveSeriesLayout(seriesLayout);
		dicomViewer.loadImageFromThumbnail(thumbnailRenderer.seriesIndex, thumbnailRenderer.imageCountOfSeries);
	}else {
        dicomViewer.changeSelection(viewport.seriesLayoutId);        
    }
    if(myDropDown !== null) myDropDown.wrapper.hide();
     var image = dicomViewer.Series.Image.getImage(thumbnailRenderer.studyUid,thumbnailRenderer.seriesIndex, thumbnailRenderer.imageCountOfSeries-1);
    if (canPlayCine(image.imageType) && dicomViewer.thumbnail.canRunCine(image)) {
        dicomViewer.startCine();
        updatePlayIcon("play.png","stop.png");
    } else {
        dicomViewer.scroll.stopCineImage(undefined);
        updatePlayIcon("stop.png","play.png");
    }
    
    //Toggling the state of the Next and Previous Image/Series Button on mouse wheel click
    EnableDisableNextSeriesImage(seriesLayout);
}

function getImageIndexBySeriesIndex(studyUid, seriesIndex) {
    var allViewports = dicomViewer.viewports.getAllViewports();
    if(allViewports === null || allViewports === undefined) {
        return;
    }

    var imageIndex = undefined;
    $.each(allViewports, function(key, value) {
        if(value.studyUid === studyUid && value.seriesIndex === seriesIndex) {
            imageIndex = value.scrollData.imageIndex;
            return false;
        }
    });

    return imageIndex;
}

function updateThumbnailCacheIndication(imageUid, color){
    //var progressDiv = "<div style='height:10px;width:10px;background:"+color+";border-radius: 5px;'></div>";
    var progressDiv;
    if(color === "green")
        progressDiv= "<img id='test' style='width:20px;'  src='images/download-complete.png' />";
    else if(color === "yellow")
        progressDiv= "<img id='test' style='width:20px;'  src='images/download-inprogress.png' />";        
    else
       progressDiv= "";
    $("#"+imageUid+"seriesTime").html(progressDiv);
}

function  showSeriesDescription(studyUid, seriesIndex){
    var seriesDesc = getSeriesDescription(studyUid, seriesIndex); 
    if(seriesDesc === undefined || seriesDesc === null) 
        seriesDesc = "";
    else if(seriesDesc.length > 16){
        seriesDesc = seriesDesc.substring(0, 15);
    }
    var seriesDescID = "<div text align='top'><div ><font color='white'>" +seriesDesc+ "</font></div></div>";
    
    return seriesDescID;
}

function getSeriesDescription(studyUid, seriesIndex){
    return dicomViewer.Series.getSeriesDescription(studyUid, seriesIndex);
}

/**
 * Get the series layout id
 * @param {Type} studyUid - Study Uid
 */ 
function getSeriesLayoutId(studyUid) {
    try
    {
        if(studyUid === null || studyUid === undefined) {
            return undefined;
        }

        var allViewports = dicomViewer.viewports.getAllViewports();
        if(allViewports === null || allViewports === undefined) {
            return undefined;
        }

        // Get the matched series layout id
        var seriesLayoutId = undefined;
        $.each(allViewports, function(key, value) {
            if(value.studyUid === studyUid) {
                seriesLayoutId = value.seriesLayoutId;
                return false;
            }
        });

        // Get the unoccupied viewport 
        if(seriesLayoutId === undefined) {
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            if(seriesLayout === undefined) {
                return undefined;
            }

            // Check whether active view port is occupied
            if(seriesLayout.studyUid === undefined) {
                return seriesLayout.getSeriesLayoutId();
            }

            // Get the first unoccupied viewport
            var seriesLayouts = [];
            $.each(allViewports, function(key, value) {
                if(value.studyUid === undefined) {
                    seriesLayouts.push(value.seriesLayoutId);
                }
            });

            // Check whether the layout is valid or not 
            if(seriesLayouts === null || seriesLayouts === undefined) {
                return undefined;
            }

            // Sort the layout values to load the selected study in the first unoccupied viewport
            if(seriesLayouts.length > 0) {
                seriesLayouts.sort();
                seriesLayoutId = seriesLayouts[0];
            }
        }

        return seriesLayoutId;
    }
    catch(e)
    { }

    return undefined;
}

/**
 * Get and select the layout
 * @param {Type} studyUid - Study Uid
 */ 
function getAndSelectLayout(studyUid) {
    var seriesLayout = dicomViewer.getActiveSeriesLayout();
    
    try
    {
        // Check whether the active and selected study Uid is same.
        if(seriesLayout.studyUid === studyUid) {
            return seriesLayout;
        }

        // Get the series layout Id
        var seriesLayoutId = getSeriesLayoutId(studyUid);
        if(seriesLayoutId === undefined) {
            return seriesLayout;
        }

        // Check whether both layout are same.
        if(seriesLayoutId === seriesLayout.getSeriesLayoutId()) {
            return seriesLayout;
        }

        // Change the layout selection
        if(!dicomViewer.IsFullScreenMode()) {
            dicomViewer.changeSelection(seriesLayoutId);
            seriesLayout = dicomViewer.getActiveSeriesLayout();
        }

        return seriesLayout;
    }
    catch(e)
    { 
        console.error(e);
    }

    return seriesLayout;
}

/**
 * Check whether the study is same in 1x1 study layout
 * @param {Type} studyUid - Specifies the study Uid
 */ 
function IsSameStudy(studyUid) {
    if(dicomViewer.IsFullScreenMode()) {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if(seriesLayout !== undefined && seriesLayout.studyUid !== undefined) {
            if(seriesLayout.studyUid === studyUid) {
                return true;
            }
        } else if(seriesLayout.studyUid === undefined) {
            // Allow to load the study because the active view port is empty
            return true;
        }

        return false;
    }

    return true;
}function ViewportProgreeBar(viewportId) {
    this.framePosition = 0;
    this.cachedIndicationPoint = 0;
    this.seriesIndex;
    this.imageIndex;
    this.frameIndex;
	this.studyUid;
    
    this.cachedPercentage = 0;
    
    this.parentElementId = viewportId;
    var viewportElement = $('#' + viewportId);
	this.imageIndicator = document.createElement("canvas");
    this.cacheIndicator = document.createElement("canvas");
	this.imageIndicator.setAttribute("id", viewportId + "_progress");
    
    var heightOfElement = viewportElement.height();
    var widthOfElement = viewportElement.width();
    
    var wPadding = viewportElement.outerWidth() - widthOfElement;
	var hPadding = viewportElement.outerHeight() - heightOfElement;
    var topValue = (viewportElement.position().top+heightOfElement)-3;
	
	this.viewportWidth = viewportElement.outerWidth() ;
 	this.viewportHeight = viewportElement.outerHeight();    	
	this.imageIndicator.width = this.viewportWidth - wPadding-2;
	this.imageIndicator.height = 10;
    
    viewportElement.append(this.imageIndicator);
	
	this.imageIndicator.style.zIndex = "8";
	this.imageIndicator.style.position = "absolute";
    this.imageIndicator.style.top = topValue+"px";
}

ViewportProgreeBar.prototype.setSeriesInfo = function (studyUid,seriesIndex, imageIndex, frameIndex) {
    this.seriesIndex = seriesIndex;
    this.imageIndex = imageIndex;
    this.frameIndex = frameIndex;
	this.studyUid = studyUid;
    this.drawImageCacheIndicator();
};

ViewportProgreeBar.prototype.drawImageCacheIndicator = function () {
    if (this.seriesIndex == undefined  || this.imageIndex == undefined) {
        return;
    }

    logger.debug("Move Cache Indicator for SeriesIndex: " + this.seriesIndex + " and ImageIndex: " + this.imageIndex);
    var image = dicomViewer.Series.Image.getImage(this.studyUid,this.seriesIndex, this.imageIndex);
    var imageCount = 0;
    var isSeriesHasMultiframe =  dicomViewer.thumbnail.isSeriesContainsMultiframe(this.studyUid,this.seriesIndex);
    if (isSeriesHasMultiframe && dicomViewer.thumbnail.isImageThumbnail(image)) {
        imageCount = dicomViewer.Series.Image.getImageFrameCount(image);
        this.cacheIndicator.width = imageCount;
        this.cacheIndicator.height = 10;
        var context = this.cacheIndicator.getContext('2d');

        //Fill gray
        context.beginPath();
        context.moveTo(0, 0);
        context.lineTo(this.cacheIndicator.width, 0);
        context.lineWidth = 10;
        context.strokeStyle = '#BDBDBD';
        context.stroke();

        for (var frame = 0; frame < imageCount; frame++)
        {
            var imagePromise = dicomViewer.imageCache.isInCache(image.imageUid +"_"+ frame);
            if (imagePromise == true) {
                context.beginPath();
                context.moveTo(frame,0);
                context.lineTo(frame + 1,0);
                context.lineWidth = 10;
                context.strokeStyle = '#1C1C1C';
                context.stroke();
            }
        }
    }
    else
    {
        imageCount = dicomViewer.Series.getImageCount(this.studyUid, this.seriesIndex);
        this.cacheIndicator.width = imageCount * 5 ;
        this.cacheIndicator.height = 10;
        var context = this.cacheIndicator.getContext('2d');

        //Fill gray
        context.beginPath();
        context.moveTo(0,0);
        context.lineTo(this.cacheIndicator.width,0);
        context.lineWidth = 10;
        context.strokeStyle = '#BDBDBD';
        context.stroke();
        for(var anImageIndex = 0; anImageIndex < imageCount; anImageIndex++)
        {
            var anImage = dicomViewer.Series.Image.getImage(this.studyUid,this.seriesIndex,anImageIndex);        
            var hasImageInCache = dicomViewer.imageCache.isInCache(anImage.imageUid + "_0" );
            if (hasImageInCache == true) {
                context.beginPath();
                context.moveTo(anImageIndex * 5 ,0);
                context.lineTo(anImageIndex * 5 + 5,0);
                context.lineWidth = 10;
                context.strokeStyle = '#1C1C1C';
                context.stroke();
            }
        }
    }

    var contextFinal = this.imageIndicator.getContext('2d');
    contextFinal.clearRect(0,0,this.imageIndicator.width,this.imageIndicator.height);
    contextFinal.drawImage(this.cacheIndicator,0,0,this.imageIndicator.width,this.imageIndicator.height);
    contextFinal.beginPath();

    // No possible of having zero index in the image
    if (this.framePosition == 0)
    {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var imageLayoutCount = 0;
        if (seriesLayout !== null) {
            imageLayoutCount = seriesLayout.getImageLayoutCount() - 1;
        }

        this.updateFramePosition(imageLayoutCount, imageCount);
    }

    contextFinal.rect(this.framePosition,0, 5, 4);
    contextFinal.fillStyle = 'white';
    contextFinal.fill();
    contextFinal.lineWidth = 1;
    contextFinal.strokeStyle = 'white';
    contextFinal.stroke();
};

ViewportProgreeBar.prototype.updateImagePosition = function(totalCount, currentIndex)
{
    this.updateFramePosition(currentIndex, totalCount);
    this.drawImageCacheIndicator();
};

ViewportProgreeBar.prototype.updateFramePosition = function(currentIndex, totalCount) {    
    var percentageVal = ((currentIndex + 1) / totalCount) * 100;
    var framePosition = this.imageIndicator.width * (percentageVal/100);
    this.framePosition = framePosition;
};var dicomViewer = (function(dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }
    var srMap = {};
    var srLayoutMap = {};

    function loadSR(urlParameters, divId,imagePromise, imageType) {
        var imageUid = urlParameters.ImageUid;
        if(divId != null) {
            $("#" + divId).empty();
            var srDIvId = "SR" + divId;
            var viewportDiv = "<div id=" + srDIvId + "/>"
            $("#" + divId).append(viewportDiv);

            // Add the html data property
            $("#" + divId)[0].isHtml = true;
            $("#" + divId)[0].HtmlId = srDIvId;

            $("#" + srDIvId).css("background","white");
            $("#" + srDIvId).css("overflow","auto");
            $("#" + srDIvId).css("width",$("#" + divId).width()-3);
            $("#" + srDIvId).css("height",$("#" + divId).height()-3);
            $("#" + srDIvId).css("padding",5);    
            $("#" + srDIvId).removeClass('disableSelection');
            $("#" + divId).removeClass('disableSelection');
            $("#" + getStudyLayoutId(divId)).removeClass('disableSelection');
        }
        
        if(srMap[imageUid] == undefined) {
            var imageInfoURL = dicomViewer.url.getDicomImageURL(urlParameters);
            var request;
            if(window.XMLHttpRequest) {
                // If the browser if IE7+[or]Firefox[or]Chrome[or]Opera[or]Safari
                request = new XMLHttpRequest();
            } else {
                //If browser is IE6, IE5
                request = new ActiveXObject("Microsoft.XMLHTTP");
            }
            
            urlParameters = dicomViewer.getSRreportUrl(urlParameters.ImageUid);
            var SrReportURL = dicomViewer.url.getDicomImageURL(urlParameters);
            request.onreadystatechange = function() {
                if(request.readyState == 4 && request.status == 200) {
                    if(divId != null) $("#"+srDIvId).append(request.responseText);
                    srMap[imageUid] = request.responseText;
                    var image = {
                        imageUid: imageUid,
                        imageData: srMap[imageUid],
                        imageType: "nonimage",
                    };
                    srLayoutMap[srDIvId] = imageUid;
                    imagePromise.resolve(srMap[imageUid]);
                }
            }
            request.open("get", SrReportURL, true);
            request.send();
        } else {
            $("#"+srDIvId).append(srMap[imageUid]);
            var status = imagePromise.state()
            if(status != "resolved")
            imagePromise.resolve(srMap[imageUid]);
        }
    }

    function containsSR(divId) {
        if(srLayoutMap[divId] === undefined ) return false;
        else return true;
    }

    /**
     * Update the zoom value for the SR modality (HTML) files by increasing/decreasing the font size
     * @param {Type} zoom - zoom button id/ custom zoom value
     */
    function zoomSR(zoom) {
        var activeLayout = dicomViewer.getActiveSeriesLayout();
        var srDIvId = "SR"+activeLayout.getSeriesLayoutId();
        var size = parseFloat($("#" + srDIvId).css("font-size"))
        if(zoom == "4_zoom") {
            //SR Zoom In
            $("#" + srDIvId).css({ fontSize: size + 1 });
        } else if(zoom == "5_zoom") {
            //SR Zoom Out
            $("#" + srDIvId).css({ fontSize: size - 1 });
        } else {
            //Calculating the zoom factor from the zoom percentage given in custom zoom dialog box
            var zoomFactor = (parseFloat(zoom.split("-")[1]))/100;
            zoomFactor = zoomFactor - 1;
            $("#" + srDIvId).css({ fontSize: 12.75 + zoomFactor});
        }
    }
    
    dicomViewer.loadSR = loadSR;
    dicomViewer.containsSR = containsSR;
    dicomViewer.zoomSR = zoomSR;

return dicomViewer;
}(dicomViewer));var dicomViewer = (function(dicomViewer) {

        if (dicomViewer === undefined) {
            dicomViewer = {};
        }
    
    function loadPlayer(url, divId, format){
        
        $("#" + divId).empty();
        var player = "<video width='" + $("#" + divId).width() + "'";

        var type;
        if (format === "mp3") {
            player = player + ' poster="images/mp3.png"';
            type = "audio/mp3";
        }
        else if (format === "mp4"){
            type = "video/mp4";
        }
        else if (format === "webm") {
            type = "video/webm";
        }
        else if (format === "avi") {
            type = "video/avi";
        }

        player = player+"height='"+$("#" + divId).height()+"'controls>"
                            +"<source src="+url+" type="+type+">"
                            +"</video>";        
        $("#"+divId).append(player);
        
    }

    function loadVideoPlayer(urls, divId) {

        $("#" + divId).empty();
        var player = "<video width='" + $("#" + divId).width() + "'" + " height='" + $("#" + divId).height() + "' controls>";

        var urlLen = urls.length;
        for (i = 0; i < urlLen; i++) {
            player = player + "<source src=" + urls[i].url + " type=" + urls[i].type + ">";
        }

        player = player + "</video>";
        $("#" + divId).append(player);
    }

    dicomViewer.loadPlayer = loadPlayer;
    dicomViewer.loadVideoPlayer = loadVideoPlayer;
    
return dicomViewer;
}(dicomViewer));var dicomViewer = (function(dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var SCROLLBAR_PADDING = 40;
    var VERTICAL_PADDING = 5;

    /**
     * create the PDF view
     * @param {Type} url - Specifies the Url
     * @param {Type} divId - parent viewport id
     */ 
    function createPDF(url, divId) {
        try
        {
            // Create the DIV to hold the pdf canvas
            var pdfDataElement = "<div id='pdfData_" + divId + "'><div style='background:white;'></div></div>";
            $("#" + divId).html(pdfDataElement);
            $("#" + divId).height($("#" + divId).height());
            $("#" + divId).width($("#" + divId).width());
            $("#" + divId).css("overflow", "auto");
            $("#" + divId).css("background", "black");
            var imagePdfDivId = "imagePdfDiv" + divId;
            var jImagePdfDiv = "<div id='" + imagePdfDivId + "' align='center' style='background:black;float: left;' ></div>";
            $("#" + divId).append(jImagePdfDiv);

            // Create the pdf canvas
            var pdfCanvas = document.createElement("canvas");
            pdfCanvas.setAttribute("id", "imagePdfCanvas" + divId);
            pdfCanvas.setAttribute("width", $("#" + divId).width());
            pdfCanvas.setAttribute("height", $("#" + divId).height());
            pdfCanvas.style.background = "black";

            // Append the canvas
            var heigtOfPdfImage = $("#" + divId).height() - $("#pdfData_" + divId).height();
            $("#" + imagePdfDivId).height(heigtOfPdfImage);
            $("#" + imagePdfDivId).width($("#" + divId).width());
            $("#" + imagePdfDivId).append(pdfCanvas);

            // Bind the page number key press
            $("#pageNumber").unbind("keypress");
            $("#pageNumber").bind("keypress", {}, pageNumberKeyPressEvent);
            
            // Load the pdf
            PDFJS.disableStream = false;
            PDFJS.getDocument(url).then(function(pdfData) {
                var renderer = getRenderer(divId);
                if(renderer !== null && renderer !== undefined) {
                    renderer.pdfData =
                    {
                        imageData: pdfData,
                        pageCount: pdfData.numPages,
                        currentPageNumber: 0,
                        viewportId: divId,
                        PState: new Presentation()
                    };

                    if(divId == dicomViewer.getActiveSeriesLayout().seriesLayoutId) {
                        activeSeriesPDFData = renderer.pdfData;
                        isPDFActiveSeries = true;
                    }

                    // Open the first page
                    navigatePage(1, undefined, renderer);
                    if(isPDFActiveSeries == true) {
                        enableorDisableNavigations(activeSeriesPDFData);
                    }
                } else {
                    console.error("Invalid pdf renderer");
                }
            });
        }
        catch(e)
        { }
    }

    /**
     * Open the page
     * @param {Type} renderer - Specifies the renderer object
     */ 
    function openPage(renderer) {
        try 
        {
            if(renderer === null || renderer === undefined) {
                // Invalid renderer
                return;
            }

            var pdfData = renderer.pdfData;
            if(pdfData === null || pdfData === undefined) {
                // Invalid pdf object
                return;
            }

            var imageData = pdfData.imageData;
            if(imageData === null || imageData === undefined) {
                // Invalid pdf image data object
                return;
            }

            // Render page
            imageData.getPage(pdfData.currentPageNumber).then(function(page) {
                var actualViewport = page.getViewport(1);
                var pageElement = document.getElementById("imagePdfDiv" + pdfData.viewportId);
                var pdfCanvas = document.getElementById("imagePdfCanvas" + pdfData.viewportId);
                var pdfCanvasContext = pdfCanvas.getContext('2d');

                var hPadding = SCROLLBAR_PADDING;
                var vPadding = VERTICAL_PADDING;
                var pageWidthScale = (pageElement.clientWidth - hPadding) / actualViewport.width;
                var pageHeightScale = (pageElement.clientHeight - vPadding) / actualViewport.height;

                var zoomFactor = 1;
                switch(pdfData.PState.zoomLevel) {
                    case 0:
                        zoomFactor = 1;
                        break;

                    case 1:
                        zoomFactor = Math.min(pageWidthScale, pageHeightScale);
                        break;

                    case 2:
                        zoomFactor = pageWidthScale;
                        break;

                    case 3:
                        zoomFactor = pageHeightScale;
                        break;

                    case 4:
                        zoomFactor = pdfData.PState.zoom;
                        break;

                    default:
                        zoomFactor = Math.min(pageWidthScale, pageHeightScale);
                        break;
                }

                var viewport = page.getViewport(zoomFactor, pdfData.PState.rotation, pdfData.PState.hFlip, pdfData.PState.vFlip);
                pdfData.PState.zoom = zoomFactor;
                pdfCanvas.height = viewport.height;
                pdfCanvas.width = viewport.width;

                var renderContext = {
                  canvasContext: pdfCanvasContext,
                  viewport: viewport
                };
                page.render(renderContext);
            })
        }
        catch(e)
        { }
    }

    /**
     * Update the page
     * @param {Type} pageNavigation - Specifies the page navigation id 
     * @param {Type} customPageNumber - Specifies the custom page number
     * @param {Type} renderer - Specifies the renderer object
     */ 
    function navigatePage(pageNavigation, customPageNumber, renderer) {
        try
        {
            if(renderer === null || renderer === undefined) {
                renderer = getRenderer();
                if(renderer === null || renderer === undefined) {
                    // Invalid renderer
                    return;
                }
            }

            var pdfData = renderer.pdfData;
            if(pdfData === null || pdfData === undefined) {
                // Invalid pdf object
                return;
            }

            var pageNumber = 0;
            var currentPageNumber = 0;
            var numOfPages = pdfData.pageCount;
            var currentPageNumber = pdfData.currentPageNumber;
            switch(pageNavigation)
            {
                case 1:
                {
                    // First Page
                    pageNumber = 1;
                    break;
                }

                case 2:
                {
                    // Next Page
                    pageNumber = Math.min(numOfPages, currentPageNumber + 1);
                    break;
                }

                case 3:
                {
                    // Previous Page
                    pageNumber = Math.max(1, currentPageNumber - 1);
                    break;
                }

                case 4:
                {
                    // Last Page
                    pageNumber = numOfPages;
                    break;
                }

                case 5:
                {
                    // custom Page
                    pageNumber = (customPageNumber < 1 ? 1 : (customPageNumber > numOfPages ? numOfPages : customPageNumber));
                    break;
                }

                default:
                {
                    // First Page
                    pageNumber = 1;
                    break;
                }
            }

            if(pdfData.currentPageNumber == pageNumber) {
                enableorDisableNavigations(pdfData);
                return;
            }

            // Open the page
            pdfData.currentPageNumber = pageNumber;
            openPage(renderer);
            enableorDisableNavigations(pdfData);
        }
        catch(e)
        { }
    }
    
    /**
     * set the pdf zoom
     * @param {Type} zoomMode  - Specifies the zoom mode
     * @param {Type} zoomfactor - Specifies the zoom factor
     */ 
    function setPdfZoom(zoomMode, zoomfactor) {
        try
        {
            var renderer = getRenderer();
            if(renderer === null || renderer === undefined) {
                // Invalid renderer
                return;
            }

            var pdfData = renderer.pdfData;
            if(pdfData === null || pdfData === undefined) {
                // Invalid pdf object
                return;
            }

            // Update the zoom mode and zoom factor
            pdfData.PState.zoomLevel = zoomMode;
            if(zoomfactor != undefined) {
                pdfData.PState.zoomLevel = 4;
                pdfData.PState.zoom = zoomfactor;
            }

            // Refresh the page 
            openPage(renderer);
        }
        catch(e)
        { }
    }
    
    /**
     * Get the renderer
     */ 
    function getRenderer(divId) {
        try
        {
            var seriesLayout = null;
            if(divId !== undefined) {
                seriesLayout = dicomViewer.viewports.getViewport(divId);
            } else {
                seriesLayout = dicomViewer.getActiveSeriesLayout();
            }

            if(seriesLayout !== undefined && seriesLayout !== null) {
                return seriesLayout.getImageRender("pdfData");
            }
        }
        catch(e)
        { }

        return undefined;
    }
    
    /**
     * Binthe key press event
     * @param {Type} e - Spectifies the key press event
     */ 
    function pageNumberKeyPressEvent(e) {
        var code = (e.keyCode ? e.keyCode : e.which);
        if (code == 13) { //Enter keycode
            e.preventDefault();
            navigatePage(5, parseInt(e.currentTarget.value));
        }
    };
    
    /**
     * Enable and Disable the PDF tools
     * @param {Type} divId - Spcifies the pdf properties
     */ 
    function enableorDisableNavigations(pdfData) {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if(seriesLayout == undefined || seriesLayout == null) {
            return;
        }

        var image = dicomViewer.Series.Image.getImage(seriesLayout.studyUid, seriesLayout.seriesIndex, seriesLayout.scrollData.imageIndex);
        if(image.imageType == IMAGETYPE_PDF || image.imageType == IMAGETYPE_TIFF || image.imageType == IMAGETYPE_RADPDF) {
            document.getElementById("pageNumber").value = pdfData.currentPageNumber;
            document.getElementById("totalPagesLabel").textContent = "of "+pdfData.pageCount;
            pdfData.currentPageNumber >= pdfData.pageCount ? $("#nextPage").addClass("k-state-disabled") : $("#nextPage").removeClass("k-state-disabled");
            pdfData.currentPageNumber <= 1 ? $("#previousPage").addClass("k-state-disabled") : $("#previousPage").removeClass("k-state-disabled");
            pdfData.currentPageNumber == 1 ? $("#firstPage").addClass("k-state-disabled") : $("#firstPage").removeClass("k-state-disabled");
            pdfData.currentPageNumber == pdfData.pageCount ? $("#lastPage").addClass("k-state-disabled") : $("#lastPage").removeClass("k-state-disabled");
            pdfData.pageCount == 1 ?  pdfToolBarElement.hide() :  pdfToolBarElement.show();
        }
    }

    /**
     * Update the navigation control
     * @param {Type} divId - Specifies the seriesLayoutId
     */ 
    function updatePaging(divId) {
        var renderer = null;
        if(renderer === null ) {
            renderer = getRenderer(divId);
            if(renderer === null || renderer === undefined) {
                // Invalid renderer
                return;
            }
        }

        var pdfData = renderer.pdfData;
        if(pdfData === null || pdfData === undefined) {
            // Invalid pdf object
            return;
        }

        enableorDisableNavigations(pdfData);
    }

        /**
     * Open the first page
     */ 
    function openFirstPage() {
        navigatePage(1);
    }

    /**
     * Open the next page
     */ 
    function openNextPage() {
        navigatePage(2);
    }
    
    /**
     * Open the previous page
     */ 
    function openPreviousPage() {
        navigatePage(3);
    }

    /**
     * Open the last page
     */ 
    function openLastPage() {
        navigatePage(4);
    }

    /**
     * Rotate the PDF 
     */ 
    function rotate() {
        var renderer = getRenderer();
        if(renderer === null || renderer === undefined) {
            // Invalid renderer
            return;
        }

        var pdfData = renderer.pdfData;
        if(pdfData === null || pdfData === undefined) {
            // Invalid pdf object
            return;
        }
        pdfData.PState.rotation =  (pdfData.PState.rotation + 90) < 360 ? pdfData.PState.rotation + 90 : 0;
        openPage(renderer);
    }

    /**
     * Flip the PDF
     * @param {Type} isHFlip - Boolean - it specifies the Horizontal or Vertical flip
     */ 
    function flip(isHFlip) {
        
        var renderer = getRenderer();
        if(renderer === null || renderer === undefined) {
            // Invalid renderer
            return;
        }
        var pdfData = renderer.pdfData;
        if(pdfData === null || pdfData === undefined) {
            // Invalid pdf object
            return;
        }
        isHFlip ? pdfData.PState.hFlip = !pdfData.PState.hFlip : pdfData.PState.vFlip = !pdfData.PState.vFlip;
        openPage(renderer);
    }

    /**
     * Revert the applied changes
     */ 
    function revert() {
        var renderer = getRenderer();
        if(renderer === null || renderer === undefined) {
            // Invalid renderer
            return;
        }

        var pdfData = renderer.pdfData;
        if(pdfData === null || pdfData === undefined) {
            // Invalid pdf object
            return;
        }
        pdfData.currentPageNumber = 0;
        pdfData.PState = undefined;
        pdfData.PState = new Presentation();
        navigatePage(1, undefined, renderer);
    }

    dicomViewer.createPDF = createPDF;
    dicomViewer.openFirstPage = openFirstPage;    
    dicomViewer.openNextPage = openNextPage;
    dicomViewer.openPreviousPage = openPreviousPage;
    dicomViewer.openLastPage = openLastPage;
    dicomViewer.setPdfZoom = setPdfZoom;
    dicomViewer.updatePaging = updatePaging;
    dicomViewer.rotate = rotate;
    dicomViewer.flip = flip;
    dicomViewer.revert = revert;

    return dicomViewer;
}(dicomViewer));