// Angular application and Study Controller
(function () {
    var angularApp = angular.module('StudyBrowserApp', ['ngGrid', 'ui.router', 'ui.bootstrap', 'angularFileUpload']);
    angularApp.controller('StudyBrowserController', ['$scope', '$upload', '$http', '$sce', function ($scope, $upload, $http, $sce) {

        $scope.showProgress = false;
        $scope.loadProgress = 0;
        $scope.filePaths = [];
        $scope.imageFiles = [];
        $scope.studies = [];

        $scope.seriesList = [];
        $scope.imageList = [];
        $scope.selectedImages = [];

        $scope.imageUrl = "js/pdfjs/viewer.html";

        $scope.gridOptions = {
            data: 'studies',
            columnDefs: [{ field: 'studyId', displayName: 'Study ID', cellTemplate: '<div class="ngCellText"><a href="/hydra/viewer?studyId={{row.getProperty(col.field)}}&broker=folder&securityToken=none">{{row.getProperty(col.field)}}</a></div>' },
                         { field: 'procedure', displayName: 'Procedure' },
                         { field: 'modality', displayName: 'Modality' },
                         { field: 'dateTime', displayName: 'Date/Time' },
                         { field: 'imageCount', displayName: 'Images' }],
            selectedItems: $scope.seriesList,
            multiSelect: false,
            enableRowReordering: false,
            showGroupPanel: false,
            maintainColumnRatios: false,
            groups: [],
            showFooter: false,
            enableColumnResize: true,
            enableColumnReordering: true
        };

        $scope.gridSeries = {
            data: 'seriesList[0].series',
            columnDefs: [{ field: 'seriesNumber', displayName: 'Series Number' },
                         { field: 'description', displayName: 'Description' },
                         { field: 'modality', displayName: 'Modality' },
                         { field: 'imageCount', displayName: 'Images' }],
            selectedItems: $scope.imageList,
            multiSelect: false,
            enableRowReordering: false,
            showGroupPanel: false,
            maintainColumnRatios: false,
            groups: [],
            showFooter: false,
            enableColumnResize: true,
            enableColumnReordering: true
        };

        $scope.gridImages = {
            data: 'imageList[0].images',
            columnDefs: [{ field: 'imageId', displayName: 'Image Id' },
                         { field: 'imageType', displayName: 'Image Type' }],
            selectedItems: $scope.selectedImages,
            multiSelect: false,
            enableRowReordering: false,
            showGroupPanel: false,
            maintainColumnRatios: false,
            groups: [],
            showFooter: false,
            enableColumnResize: true,
            enableColumnReordering: true
        };

        $scope.onDisplayImage = function () {
            if ($scope.selectedImages == null || $scope.selectedImages.length == 0) {
                alert("No image selected.");
            }
            else {
                //var url = "/hydra/api/images?studyId=201409121603&broker=folder&securityToken=none&imageId=ORO00003632555&format=frame&transform=pdf";
                var url = "js/pdfjs/viewer.html?file=/hydra/api/images?studyId=201409121603&broker=folder&securityToken=none&imageId=ORO00003632555&format=frame&transform=pdf";
                //$scope.imageUrl = $sce.trustAsResourceUrl(url);
                $scope.imageUrl = url;
                $scope.apply($scope.imageUrl);
            }
        };

        $scope.loadStudies = function () {
            $http.get("/hydra/api/studies?broker=folder&studyid=*").success(function (data, status, headers, config) {
                $scope.studies = angular.fromJson(data);
            });
        }

		$scope.onFileSelect = function ($files) {
			$scope.updateLoadProgress(50);
			$scope.showProgress = true;
			$scope.filePaths = $files;
		};

		$scope.updateLoadProgress = function(progress) {
			$scope.loadProgress = progress;
			console.log("Load progress: " + $scope.loadProgress);
			$scope.$apply();
		};

		$scope.onUploadImages = function () {
		    if ($scope.filePaths == null || $scope.filePaths.length == 0) {
		        alert("No images selected.");
		    }
		    else {
		        for (var i = 0; i < $scope.filePaths.length; i++) {
		            var filePath = $scope.filePaths[i];
		            var imageFile =
                    {
                        filePath: filePath.webkitRelativePath,
                        fileName: filePath.name,
                        contentType: filePath.type,
                        size: filePath.size,
                        file: filePath,
                        percentComplete: 0
                    };

		            $scope.imageFiles.push(imageFile);
                }

		        for (i = 0; i < $scope.imageFiles.length; i++) {
		            var imageFile = $scope.imageFiles[i];
		            $scope.uploadImage(imageFile);
		        }
            }
		};

		$scope.uploadImage = function (imageFile) {

		    console.log("Preparing to upload file: " + imageFile.fileName);
		    var uploadUrl = "/hydra/api/images?broker=folder";
		    imageFile.upload = $upload.upload({
		        url: uploadUrl,
		        method: 'POST',
		        file: imageFile.file
		    }).progress(function (evt) {
		        imageFile.percentComplete = parseInt(100.0 * evt.loaded / evt.total);
		    }).success(function (data, status, headers, config) {
		        var index = $scope.imageFiles.indexOf(imageFile);
		        $scope.imageFiles.splice(index, 1);
		    }).error(function (data, status, headers, config) {
		        console.log("Error uploading: " + status);
		    });
		}

		$scope.loadStudies();

    }]);



}());