var myHub = $.connection.sessionHub;
var currentDisplayContextList = [];
var idleTime = 0;

// add new display context to the viewer
myHub.client.addDisplayContext = function (sessionId, displayContextList) {

    if (!isCurrentSession(sessionId)) return;

    var i;
    var displayContexts = [];
    var firstLoadedContext = undefined;
    for (i = 0; i < displayContextList.length; i++) {                
        var contextId = displayContextList[i];
        contextId = decodeURIComponent(contextId).trim();
        var selectedContextId = currentDisplayContextList.filter(function (existingContextId) {
            return (existingContextId.trim().toLowerCase() === contextId.toLowerCase());
            })[0];

        // Check whether the context id is already loaded or not
        if(selectedContextId !== undefined) {
            if(firstLoadedContext === undefined) {
                firstLoadedContext = selectedContextId;
            }

            continue;
        }

        // Add the context id in the current session
        if(addContextId(contextId) == true) {
            displayContexts.push(contextId);
        }
    }

    // Display the context 
    if(displayContexts.length > 0) {
        AppendStudy(displayContexts);
    } else if(firstLoadedContext !== undefined) {
        ActivateStudy(firstLoadedContext);
    }
};

myHub.client.removeDisplayContext = function (sessionId, displayContextList) {

    if (!isCurrentSession(sessionId)) return;


    var i;
    for (i = 0; i < displayContextList.length; i++) {
        var contextId = displayContextList[i];
        contextId = decodeURIComponent(contextId).trim();
        var selectedContextId = currentDisplayContextList.filter(function (existingContextId) {
            return (existingContextId.trim().toLowerCase() === contextId.toLowerCase());
        })[0];

        // Check whether the context id is already loaded or not
        if(selectedContextId === undefined) {
            continue;
        }

        // Remove the context id
        removeStudyByContextID(selectedContextId);
        removeContextId(selectedContextId);
        if (currentDisplayContextList.length == 0) {
            showOrClearSession(false);
        }
    }
};

myHub.client.getDisplayContext = function (sessionId) {

    if (!isCurrentSession(sessionId)) return null;

    return currentDisplayContextList;
};

/**
 * Send the viewer status to Hix server
 * @param {Type} errorCode - Specifies the error code
 * @param {Type} descritpion  - Specifies the error description
 */ 
function sendViewerStatusMessage(errorCode, descritpion) {
    try
    {
        if(myHub === null || myHub === undefined) {
            return;
        }

        myHub.invoke('SendViewerMessage', errorCode, descritpion).done(function () {
        }).fail(function (error) {
            console.log('Invocation of SendViewerMessage failed. Error: ' + error);
        });
    }
    catch(e)
    { }
}

$(document).ready(function() {
    //Increment the idle time counter every minute.
    var idleInterval = setInterval(timerIncrement, 60000); // 1 minute

    //Zero the idle timer on mouse movement.
    $(this).mousemove(function (e) {
        idleTime = 0;
    });
    $(this).keypress(function (e) {
        idleTime = 0;
    });
});

function timerIncrement() {
    idleTime = idleTime + 1;
    /*if (idleTime > 0) { // 1 minutes

    }*/
}

/**
 * To get idle timeout status
 */
myHub.client.getSessionIdleTime = function (taskId, sessionId) {
    try
    {
        if(myHub === null || myHub === undefined) {
            return;
        }

        if (!isCurrentSession(sessionId)) {
            setSessionIdleTime(taskId, false, 0);
            return;
        }

        setSessionIdleTime(taskId, true, idleTime * 60);
    }
    catch(e)
    { }
};

/**
 * Send the viewer idle timeout status to Hix server
 */
function setSessionIdleTime(taskId, isValidSession, idleTime) {
    myHub.invoke('setSessionIdleTime', taskId, isValidSession, idleTime, currentDisplayContextList).done(function () {
    }).fail(function (error) {
        console.log('Invocation of setSessionIdleTime failed. Error: ' + error);
    });
}

/**
 * Remove the context Id 
 * @param {Type} contextId - Specifies the display context id
 */ 
function removeContextId(contextId) {
    try
    {
        if(contextId === null || 
           contextId === undefined ||
           currentDisplayContextList === null ||
           currentDisplayContextList === undefined|| 
           currentDisplayContextList.length == 0) {
            return;
        }

        contextId = decodeURIComponent(contextId).trim();

        for (i = 0; i < currentDisplayContextList.length; i++) {
            if (currentDisplayContextList[i].trim().toLowerCase() === contextId.toLowerCase()) {
                currentDisplayContextList.splice(i, 1);
                PostRemoveContext(contextId);
                return;
            }
        }
    }
    catch(e)
    { }
}

/**
 * Add the context id
 * @param {Type} contextId  - Specifies the display context id
 */ 
function addContextId(contextId) {
    try
    {
        if(contextId === null || 
           contextId === undefined) {
            return false;
        }

        contextId = decodeURIComponent(contextId).trim();

        // check if context id already exists (case insensitive)
        for (i = 0; i < currentDisplayContextList.length; i++) {                
            if (currentDisplayContextList[i].trim().toLowerCase() === contextId.toLowerCase())
                return false;
        }

        // add to list in original format trimmed
        currentDisplayContextList.push(contextId);
        return true;
    }
    catch(e)
    { }

    return false;
}

    /**
     * post the remove context url to server
     */ 
    function PostRemoveContext(contextId){
        try
        {
            var removeContextUrl = dicomViewer.url.getRemoveContextUrl(getSessionId());
            var contextList = [];
            contextList.push(contextId);
            var contextIdList = JSON.stringify(contextList);
            $.ajax({
                type: 'DELETE',
                url: removeContextUrl,
                data: contextIdList
            })
            .success(function(data) {
                 console.log("successfully posted the remove context Url request to server");
            })
            .fail(function(data) {
                console.log("failed to post the remove context Url request to server");
            })
        }
        catch(e)
        {
        }
    }