var logger = (function (logger) {
    "use strict";

    var isLoggerEnabled = false;

    if (logger === undefined || logger === null) {
        logger = {};
    }
    var log = log4javascript.getDefaultLogger();
     
    function trace(obj) {
        if (isLoggerEnabled) {
            log.trace(obj);
        }
    }

    function debug(obj) {
        if (isLoggerEnabled) {
            log.debug(obj);
        }
    }

    function info(obj) {
        if (isLoggerEnabled) {
            log.info(obj);
        }
    }

    function error(obj) {
        if (isLoggerEnabled) {
            log.error(obj);
        }
    }

    function warn(obj) {
        if (isLoggerEnabled) {
            log.warn(obj);
        }
    }

    function fatal(obj) {
        if (isLoggerEnabled) {
            log.fatal(obj);
		}
    }
	
	function startTime(name)
	{
		if (isLoggerEnabled) {
            log.time(name);
		}
	}
	
	function endTime(name)
	{
		if (isLoggerEnabled) {
            log.timeEnd(name);
		}
	}
    
    logger.trace = trace;
    logger.debug = debug;
    logger.info = info;
    logger.error = error;
    logger.warn = warn;
    logger.fatal = fatal;
	logger.startTime = startTime;
	logger.endTime = endTime;
    return logger;
}(logger));