(function($, window) {

    $.fn.contextMenu = function(settings) {

        return this.each(function() {

            // Open context menu
            $(this).on("contextmenu", function(e) {
				var widthOfViewport =$("#viewport_View").width();
				var heightOfViewport = $("#viewport_View").height();
				
                var currentCursor = $('#viewport_View').css('cursor');
                var layout = dicomViewer.getActiveSeriesLayout();
                var toolName = dicomViewer.mouseTools.getToolName();
				
				

                if (currentCursor.indexOf("brightness.cur") > -1 || layout.imageType === IMAGETYPE_RADECG || 
                    toolName === 'traceMeasurement' || toolName === 'volumeMeasurement' || toolName === 'pointMeasurement' || 
                    toolName === 'lineMeasurement' || toolName === 'mitralMeanGradientMeasurement' || toolName === 'angleMeasurement' ||
                    toolName === 'ellipseMeasurement') {
                    //open menu
                    $(settings.menuSelector)
                        .data("invokedOn", $(e.target))
                        .show()
                        .css({
                            position: "absolute",
                            left: getLeftLocation(e),
                            top: getTopLocation(e)
                        })
                        .off('click')
                        .on('click', function(e) {
                            $(this).hide();

                            var $invokedOn = $(this).data("invokedOn");
                            var $selectedMenu = $(e.target);

                            //settings.menuSelected.call(this, $invokedOn, $selectedMenu);
                        });
                } else {
                    dicomViewer.tools.doWindowLevel();
                }
				
				var currentLocation = getLeftLocation(e);
				var widthOfContextMenu = $("#contextMenu").width();
				var widthOfContexSubMenu = $("#100").width();
				if((currentLocation+widthOfContexSubMenu) >= widthOfViewport)
				{
					setSubmenuToLeft("zoomSubMenu", widthOfViewport);
					setSubmenuToLeft("100", widthOfViewport);
					setSubmenuToLeft("105", widthOfViewport);
					setSubmenuToLeft("gridSubMenu", widthOfViewport);
					setSubmenuToLeft("gridColor", widthOfViewport);
					setSubmenuToLeft("leadFormatSubmenu", widthOfViewport);
					setSubmenuToLeft("gainSubmenu", widthOfViewport);
					setSubmenuToLeft("signalthicknesSubmenu", widthOfViewport);
				}else
				{
					setSubmenuToRight("zoomSubMenu");
					setSubmenuToRight("100");
					setSubmenuToRight("105");
					setSubmenuToRight("gridSubMenu");
					setSubmenuToRight("gridColor");
					setSubmenuToRight("leadFormatSubmenu");
					setSubmenuToRight("gainSubmenu");
					setSubmenuToRight("signalthicknesSubmenu");
				}

                return false;
            });

            //make sure menu closes on any click
            $(document).click(function() {
                $(settings.menuSelector).hide();
            });
        });
		
		function setSubmenuToLeft(subMenuId, widthOfViewPort){
			var widthOfSubMenu = $("#"+subMenuId).width();
			var displayPostionOfSubMenu = widthOfViewPort-(widthOfViewPort+widthOfSubMenu);
			$("#"+subMenuId).css({
				 position: "absolute",
				 left: displayPostionOfSubMenu+"px",
				 "border-radius": "6px 0px 6px 6px"
               	});
		}
		
		function setSubmenuToRight(subMenuDivId)
		{
				$("#"+subMenuDivId).css({
						 left: "100%",
					 "border-radius": "0px 6px 6px 6px"
                })
		}

        function getLeftLocation(e) {
            var layout = dicomViewer.getActiveSeriesLayout();
             $("#context-volume").hide();
            if (layout.imageType === IMAGETYPE_RADECG) {
                showOrHideEcgMenue(true);
				showOrHideDicomMenu(false)
                
				$("#context-edit").hide();
                $("#context-delete").hide();
                $("#context-deleteAll").hide();

            } else {
                showOrHideEcgMenue(false);
                var dataToedit = dicomViewer.measurement.getDataToDelete();
                if (dataToedit.key === "") {
                	showOrHideDicomMenu(true);
					
                    $("#context-edit").hide();
                    $("#context-delete").hide();
                    $("#context-deleteAll").hide();
                } else {
                  showOrHideDicomMenu(false);
                    $("#context-edit").show();
                    $("#context-delete").show();
                    $("#context-deleteAll").show();
                }
            }
            var mouseWidth = e.pageX;
            var pageWidth = $(window).width();
            var menuWidth = $(settings.menuSelector).width();
			var widthOfViewport =$("#viewport_View").width();
			var heightOfViewport = $("#viewport_View").height();
			 	var thumbnailWidth = $("#img").width();
		    var toolBarheigt = $("#toolBar").height();
			if(widthOfViewport>=(e.pageX-thumbnailWidth) && heightOfViewport>=(e.pageY)){
			  $("#contextMenu").show();
			}else{
			  $("#contextMenu").hide();
			}
		
            // opening menu would pass the side of the page
            if (mouseWidth + menuWidth > pageWidth &&
                menuWidth < mouseWidth) {
                return mouseWidth - menuWidth;
            }
            return mouseWidth;
        }

        function showOrHideEcgMenue(flag) {
            if (flag) {
                $("#gridtype").show();
                $("#gridcolor").show();
                $("#leadformat").show();
                $("#gain").show();
                $("#signalthickness").show();
                $("#drawcaliper").show();
            } else {
                $("#gridtype").hide();
                $("#gridcolor").hide();
                $("#leadformat").hide();
                $("#gain").hide();
                $("#signalthickness").hide();
                $("#drawcaliper").hide();
            }
        }

        function showOrHideDicomMenu(flag) {
            if (flag) {
                $("#context-pan").show();
                $("#context-zoom").show();
                $("#context-length").show();
				$("#context-length-calibration").show();
                $("#context-2dPoint").show();
                $("#context-angle").show();
                //$("#context-volume").show();
                $("#context-MitralValve").show();
                $("#context-AorticValve").show();
                $("#context-trace").show();

            } else {
                $("#context-pan").hide();
                $("#context-zoom").hide();
                $("#context-length").hide();
				$("#context-length-calibration").hide();
                $("#context-2dPoint").hide();
                $("#context-angle").hide();
                $("#context-trace").hide();
                $("#context-volume").hide();
                $("#context-MitralValve").hide();
                $("#context-AorticValve").hide();
            }
        }

        function getTopLocation(e) {
            var mouseHeight = e.pageY;
            var pageHeight = $(window).height();
            var menuHeight = $(settings.menuSelector).height();

            // opening menu would pass the bottom of the page
            if (mouseHeight + menuHeight > pageHeight &&
                menuHeight < mouseHeight) {
                return mouseHeight - menuHeight;
            }
            return mouseHeight;
        }

    };
})(jQuery, window);