var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }
	
	/* We can change broker value broker variable OR using setBroker function */
	var broker = "isix";
	
	function getBroker()
	{
		return broker;
	}
	
	function setBroker(brokerValue)
	{
		broker = brokerValue;
	}
	
	dicomViewer.broker = {
		getBroker : getBroker,
		setBroker : setBroker
	};
	
	  
    return dicomViewer;
}(dicomViewer));/**
 * This module deals with caching images
 */

var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }
  
    var cachedImages = {};  
    var cachedImagesBySeries = {};  
    var maximumSizeInBytesForMobileDevice = 100 * 1024 * 1024; // 100 MB cache
    var maximumSizeInBytesForSystem = 800 * 1024 * 1024; // 800 MB cache
    
    var maximumSizeInBytes = 800 * 1024 * 1024; // 800 MB cache
    var maximumSizeToReduceInBytes = (maximumSizeInBytes * 0.40); // 250 MB cache
    var maximumSizeToReduceInBytesInViewingSeries = (maximumSizeInBytes * 0.20); // 125 MB cache

    var browserLoadingMemorySize = 50 * 1024 * 1024; // 50 MB cache approximately
    var compilationMemorySize = 10 * 1024 * 1024; // 10 MB cache approximately
    var stringMemorySize = 8 * 1024 * 1024; // 8 MB cache approximately
    var cacheSizeInBytes = browserLoadingMemorySize + compilationMemorySize + stringMemorySize;

    var cacheInformation = { series : {} };

    // Hold the visual viewport image raw data
    var viewportImageDataMap = new Map();

    function putImagePromise(studyUid, imageUid, frameIndex, imagePromise, seriesIndex)
    { 
        var modality = dicomViewer.Series.getModality(studyUid, seriesIndex);		
       if(imageUid === undefined)
        {
            throw "getImagePromise: imageUid must not be undefined";
        }
        if(imagePromise === undefined)
        {
            throw "getImagePromise: imagePromise must not be undefined";
        }

        if(cachedImages.hasOwnProperty(imageUid) === true) {
            //throw "putImagePromise: imageUid already in cache";
			return;
        }

        var cachedImage = {
            imageUid : imageUid,
            studyUid:studyUid,
			frameIndex : frameIndex,
            imagePromise : imagePromise,
            timeStamp : new Date(),
            sizeInBytes: 0,
            modality: modality,
            seriesIndex : seriesIndex
        };
        
        imagePromise.done(function(image) {
            if(image.imageType == "image" && cachedImages[imageUid+"_"+frameIndex] === undefined)
            {  
                purgeCacheIfNecessary(image.sizeInBytes);
                if(dicomViewer.imageCache.isCache90PercentageFull())
                {
                     var isImageVisible = false;
                    if(dicomViewer.thumbnail.isSeriesContainsMultiframe(cachedImage.studyUid,cachedImage.seriesIndex))
                    {                       
                         var imageIndex =  parseInt( dicomViewer.Series.Image.getImageIndex(cachedImage.studyUid, cachedImage.seriesIndex, cachedImage.imageUid));   
                        isImageVisible = dicomViewer.viewports.isImageVisible(cachedImage.seriesIndex,imageIndex);                      
                    }else
                    {
                        isImageVisible = dicomViewer.viewports.isImageVisible(cachedImage.seriesIndex);                        
                    }
                    if(isImageVisible) purgeCacheIfNecessary(image.sizeInBytes,isImageVisible);
                    //if(dicomViewer.imageCache.isCache95PercentageFull())
                    //    return;
                }
                cachedImages[imageUid+"_"+frameIndex] = cachedImage;            
                if(cachedImagesBySeries[seriesIndex] === undefined) cachedImagesBySeries[seriesIndex] = {};
                if(cachedImagesBySeries[seriesIndex][imageUid] === undefined) cachedImagesBySeries[seriesIndex][imageUid] = {};
                cachedImagesBySeries[seriesIndex][imageUid][frameIndex] = imageUid+"_"+frameIndex;               

                cachedImage.loaded = true;

                if(image.sizeInBytes === undefined)
                {
                    throw "putImagePromise: image does not have sizeInBytes property or";
                }
                if(image.sizeInBytes.toFixed === undefined) {
                    throw "putImagePromise: image.sizeInBytes is not a number";
                }
                cachedImage.sizeInBytes = image.sizeInBytes;
                cachedImage.image = image;                
                cacheSizeInBytes += cachedImage.sizeInBytes; 
                addCacheInfo(studyUid, seriesIndex,imageUid,frameIndex);
            }
        });
    }
    
    function purgeCacheViewingSeries()
    {   
         var i = 0;
        var reducedSize = 0;
        var arrayToSearchImage = Object.keys(cachedImages);        
         while(parseInt(reducedSize) < parseInt(maximumSizeToReduceInBytesInViewingSeries) && i < arrayToSearchImage.length)
        {
            var lastCachedImageKey = arrayToSearchImage[ i];            
            var lastCachedImage =  cachedImages[lastCachedImageKey];
            if(lastCachedImage != null) {
                var isPurge  = isPurgeFirstImage(lastCachedImage);
                if(isPurge)
                {
                    cacheSizeInBytes -= lastCachedImage.sizeInBytes;   
                    reducedSize += lastCachedImage.sizeInBytes; 
                    removeCacheInfo(lastCachedImage.seriesIndex, lastCachedImage.imageUid, lastCachedImage.frameIndex);
                    deleteCacheImage(lastCachedImageKey);  
                    cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex] = undefined;
                    delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex];
                    // Reduce the processed image count when the image is un loading from series
                    dicomViewer.reduceProcessedImageCount(lastCachedImage.studyUid, lastCachedImage.seriesIndex);

                    if(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid]).length ===0)
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid];
                    if(cachedImagesBySeries[lastCachedImage.seriesIndex] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex]).length ===0)
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex];
                    updateCacheIndicators(lastCachedImage.studyUid,lastCachedImage.seriesIndex, lastCachedImage.imageUid);
                }
            }
            i++;
        }                
        arrayToSearchImage = [];
    }
    
    function purgeCacheIfNecessary(sizeInBytes,forcePurge)
    {
        // if max cache size has not been exceded, do nothing
        if(!dicomViewer.imageCache.isCache95PercentageFull())
        {
            return;
        }

        // cache size has been exceeded, create list of images sorted by timeStamp
        // so we can purge the least recently used image
        function compare(a,b) {
            if(a.timeStamp < b.timeStamp) {
                return 1;
            }
            if(a.timeStamp > b.timeStamp) {
                return -1;
            }
            return 0;
        }        
        var arrayToSearchImage = Object.keys(cachedImages);
        arrayToSearchImage.sort(compare);
        
        // remove images as necessary        
        var i = 0;
        var reducedSize = 0;
        var prevNextCount = dicomViewer.getPrevNextCount();
        if(forcePurge !== undefined && forcePurge === true) prevNextCount = 0;
        while(parseInt(reducedSize + sizeInBytes) < parseInt(maximumSizeToReduceInBytes) && i < arrayToSearchImage.length)
        {
            var lastCachedImageKey = arrayToSearchImage[i];                
            var lastCachedImage =  cachedImages[lastCachedImageKey];
            
            if(lastCachedImage != null)
            {
                var imageIndex =  parseInt( dicomViewer.Series.Image.getImageIndex(lastCachedImage.studyUid, lastCachedImage.seriesIndex, lastCachedImage.imageUid));   
                
                var isViewing = false;
                if(dicomViewer.thumbnail.isSeriesContainsMultiframe(lastCachedImage.studyUid,lastCachedImage.seriesIndex))
                {
                    for( var j= imageIndex - prevNextCount; j<= (imageIndex + prevNextCount);j++)
                    {
                        if(dicomViewer.viewports.isImageVisible(lastCachedImage.seriesIndex,j) === true)
                        {
                            isViewing = true;
                            break;
                        }
                       
                    }
                          
                }else
                {
                    for( var j= lastCachedImage.seriesIndex - prevNextCount; j<= (lastCachedImage.seriesIndex + prevNextCount);j++)
                    {
                        if(dicomViewer.viewports.isImageVisible(j) === true)
                        {
                            isViewing = true;
                            break;
                        }
                    }
                }
                 var isPurge  = isPurgeFirstImage(lastCachedImage);
                if(isViewing === false && isPurge)
                {
                    cacheSizeInBytes -= lastCachedImage.sizeInBytes; 
                    reducedSize += lastCachedImage.sizeInBytes;                                      
                    removeCacheInfo(lastCachedImage.seriesIndex, lastCachedImage.imageUid, lastCachedImage.frameIndex);
                    deleteCacheImage(lastCachedImageKey); 
                    cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex] = undefined;
                    delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex];
                    // Reduce the processed image count when the image is un loading from series
                    dicomViewer.reduceProcessedImageCount(lastCachedImage.studyUid, lastCachedImage.seriesIndex);

                    if(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid]).length ===0)
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid];
                    if(cachedImagesBySeries[lastCachedImage.seriesIndex] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex]).length ===0)
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex];
                    updateCacheIndicators(lastCachedImage.studyUid,lastCachedImage.seriesIndex, lastCachedImage.imageUid);
                }
            } 
            i = i + 1;
        }       
        arrayToSearchImage = [];
    }
    
    function purgeCacheAll(deleteAll,forcePurge)
    {   
        var arrayToSearchImage = Object.keys(cachedImages);  
        var prevNextCount = dicomViewer.getPrevNextCount();        
        if(deleteAll === true || (forcePurge !== undefined && forcePurge === true)) prevNextCount = 0;
        for(var i=0; i< arrayToSearchImage.length; i++)
        {
            var lastCachedImageKey = arrayToSearchImage[ i];            
            var lastCachedImage =  cachedImages[lastCachedImageKey];
            
            if(lastCachedImage != null)
            {
                var imageIndex =   parseInt( dicomViewer.Series.Image.getImageIndex(lastCachedImage.studyUid, lastCachedImage.seriesIndex, lastCachedImage.imageUid));                       
                    var isViewing = false;
                    if(dicomViewer.thumbnail.isSeriesContainsMultiframe(lastCachedImage.studyUid,lastCachedImage.seriesIndex))
                    {
                        for( var j= imageIndex - prevNextCount; j<= (imageIndex + prevNextCount);j++)
                        {

                                if(dicomViewer.viewports.isImageVisible(lastCachedImage.seriesIndex,j) === true)
                                {
                                    isViewing = true;
                                    break;
                                }
                        }
                    }else
                    {
                        for( var j= lastCachedImage.seriesIndex - prevNextCount; j<= (lastCachedImage.seriesIndex + prevNextCount);j++)
                        {
                                if(dicomViewer.viewports.isImageVisible(j) === true)
                                {
                                    isViewing = true;
                                    break;
                                }
                        }
                    } 
                    var isPurge  = isPurgeFirstImage(lastCachedImage);                   
                    if(isViewing === false && isPurge)
                    {
                        cacheSizeInBytes -= lastCachedImage.sizeInBytes;                                          
                        removeCacheInfo(lastCachedImage.seriesIndex, lastCachedImage.imageUid, lastCachedImage.frameIndex);
                        deleteCacheImage(lastCachedImageKey);  
                        cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex] = undefined;
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex];
                        // Reduce the processed image count when the image is un loading from series
                        dicomViewer.reduceProcessedImageCount(lastCachedImage.studyUid, lastCachedImage.seriesIndex);
                         
                    if(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid]).length ===0)
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid];
                    if(cachedImagesBySeries[lastCachedImage.seriesIndex] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex]).length ===0)
                        delete cachedImagesBySeries[lastCachedImage.seriesIndex];
                    updateCacheIndicators(lastCachedImage.studyUid,lastCachedImage.seriesIndex, lastCachedImage.imageUid);
                    }
            }              
        }        
        arrayToSearchImage = [];
    }
    
    function clearCache(studyUid)
    {   
        var arrayToSearchImage = Object.keys(cachedImages);        
        for(var i=0; i< arrayToSearchImage.length; i++)
        {
            var lastCachedImageKey = arrayToSearchImage[ i];            
            var lastCachedImage =  cachedImages[lastCachedImageKey];
            
            if(lastCachedImage != null)
            {
                if (studyUid !== undefined && lastCachedImage.studyUid !== studyUid) {
                    continue;
                }
                cacheSizeInBytes -= lastCachedImage.sizeInBytes;                                          
                removeCacheInfo(lastCachedImage.seriesIndex, lastCachedImage.imageUid, lastCachedImage.frameIndex);
                deleteCacheImage(lastCachedImageKey);  
                cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex] = undefined;
                delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid][lastCachedImage.frameIndex];
                // Reduce the processed image count when the image is un loading from series
                dicomViewer.reduceProcessedImageCount(lastCachedImage.studyUid, lastCachedImage.seriesIndex);

                if(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid]).length ===0)
                    delete cachedImagesBySeries[lastCachedImage.seriesIndex][lastCachedImage.imageUid];
                if(cachedImagesBySeries[lastCachedImage.seriesIndex] !== undefined && Object.keys(cachedImagesBySeries[lastCachedImage.seriesIndex]).length ===0)
                    delete cachedImagesBySeries[lastCachedImage.seriesIndex];
                updateCacheIndicators(lastCachedImage.studyUid,lastCachedImage.seriesIndex, lastCachedImage.imageUid);
            }              
        }        
        arrayToSearchImage = [];
    }
    
    function addCacheInfo(studyUid, seriesIndex,imageUid,frameIndex)
    {
        var frameInfo = {
                frameNumber : frameIndex ,
                imageUid : imageUid,
                seriesIndex : seriesIndex
            };      
        var series = cacheInformation.series[seriesIndex];
        if(series === undefined)
        {
            series = {};           
            cacheInformation.series[seriesIndex] = series;                        
        }
        var image =  series[imageUid];
        if(image === undefined)
        {
            image = {};            
            series[imageUid] = image;            
        }
        image[frameIndex] = frameInfo;
       
 
        var imageIndex = dicomViewer.getImageIndexForImageUid(studyUid, seriesIndex, imageUid);
        if(imageIndex == undefined)
            imageIndex = 0;
        $("#cachemanager_progress").trigger("image_cache_updated", getCacheInfo());
        updateCacheIndicators(studyUid,seriesIndex, imageUid);
        var progressBar = dicomViewer.cacheIndicator.getCacheIndicator(seriesIndex,imageIndex);
        if(progressBar == undefined)
        {
            progressBar = dicomViewer.cacheIndicator.getCacheIndicator(seriesIndex,imageIndex-1);
        }
        if(progressBar != undefined)
        {
            var progressBarId = progressBar.imageIndicator.id
            var image = dicomViewer.Series.Image.getImage(studyUid,seriesIndex,imageIndex);
            if(image !== undefined)
            {
                var totalFrame = dicomViewer.Series.Image.getImageFrameCount(image);
                frameIndex = frameIndex+1;
                var thumbnailId = "imageviewer_"+dicomViewer.replaceDotValue(studyUid)+"_"+(seriesIndex)+"_thumb"+(imageIndex);   
                var element = document.getElementById(thumbnailId);
                if(element == null)
                {
                 totalFrame = dicomViewer.Series.getImageCount(studyUid,seriesIndex);
                 frameIndex = imageIndex+1;
                }
                $("#"+progressBarId).trigger("update",[totalFrame,frameIndex,progressBar]);
            }            
        }
    }
    function updateCacheIndicators(studyUid,seriesIndex, imageUid)
    {
        var imageIndex = dicomViewer.getImageIndexForImageUid(studyUid, seriesIndex, imageUid);
        if(imageIndex !== undefined)
        {
            var imageValue = dicomViewer.Series.Image.getImage(studyUid,seriesIndex,imageIndex); 
            if(imageValue !== undefined)
            {
                if(dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex))
                {
                    var totalNumberOfFrames = dicomViewer.Series.Image.getImageFrameCount(imageValue);
                        if((cachedImagesBySeries[seriesIndex] === undefined ||    
                            cachedImagesBySeries[seriesIndex][imageUid] === undefined) ||
                                Object.keys(cachedImagesBySeries[seriesIndex]).length === 0 ||    
                                    Object.keys(cachedImagesBySeries[seriesIndex][imageUid]).length === 0)
                    {
                        updateThumbnailCacheIndication(imageUid,"red"); 
                    }
                    else
                    {
                        if(Object.keys(cachedImagesBySeries[seriesIndex][imageUid]).length >= totalNumberOfFrames)
                            updateThumbnailCacheIndication(imageUid,"green");
                        else if(Object.keys(cachedImagesBySeries[seriesIndex][imageUid]).length === 0)
                            updateThumbnailCacheIndication(imageUid,"red");
                        else
                            updateThumbnailCacheIndication(imageUid,"yellow");
                    }   
                }
                else
                {
                    var imageValue = dicomViewer.Series.Image.getImage(studyUid,seriesIndex,0);
                    var totalNumberOFImages = dicomViewer.Series.getImageCount(studyUid,seriesIndex);
                    if(cachedImagesBySeries[seriesIndex] !== undefined && cachedImagesBySeries[seriesIndex].length !== 0)
                    {
                        if(Object.keys(cachedImagesBySeries[seriesIndex]).length >= totalNumberOFImages)
                        {
                           var thumbnailImageId =  dicomViewer.Series.Image.getImageUid(dicomViewer.Series.Image.getImage(studyUid,seriesIndex, 0));
                           updateThumbnailCacheIndication(thumbnailImageId,"green");
                        }
                        else if(Object.keys(cachedImagesBySeries[seriesIndex]).length === 0)
                        {
                            updateThumbnailCacheIndication(imageValue.imageUid,"red");
                        }else
                        {
                            updateThumbnailCacheIndication(imageValue.imageUid,"yellow");
                        }
                    }else
                    {
                        updateThumbnailCacheIndication(imageValue.imageUid,"red");   
                    }

                }
            }
        }
    }
    function removeCacheInfo(seriesIndex,imageUid,frameIndex)
    {
        var series = cacheInformation.series[seriesIndex];
        if(series === undefined)
        {
            throw "removeCacheInfo : series is undefind";
        }
        var image =  series[imageUid];
         if(image === undefined)
        {
            throw "removeCacheInfo : image is undefind";
        }        
        image[frameIndex] = undefined;
        if( Object.keys(image).length == 0)
            image = undefined;
        $("#cachemanager_progress").trigger("image_cache_updated", getCacheInfo());
    }

    
    function getImagePromise(imageUid)
    {
        if(imageUid === undefined)
        {
            throw "getImagePromise: imageUid must not be undefined";
        }
        var cachedImage = cachedImages[imageUid];
        if(cachedImage === undefined)
        {
            return undefined;
        }

        // bump time stamp for cached image
        cachedImage.timeStamp = new Date();
        return cachedImage.imagePromise;
    }
    

    /**
     * Check the given imageUid is available in cache array or image array.
     */
    function isInCache(imageUid)
    {
        if(imageUid === undefined)
        {
            return false;
        }

        var cachedImage = cachedImages[imageUid];
        if(cachedImage === undefined)
        {
            return undefined;
        }
        return cachedImage.imagePromise != null;
    }

    function getCacheInfo()
    {
        return {
            maximumSizeInBytes : maximumSizeInBytes,
            cacheSizeInBytes : cacheSizeInBytes,
            numberOfImagesCached: Object.keys(cachedImages).length
        };
    }
    
    function setMaximumSizeBytes(numBytes)
    {
        if(numBytes === undefined) {
            throw "setMaximumSizeBytes: parameter numBytes must not be undefined";
        }
        if(numBytes.toFixed === undefined) {
            throw "setMaximumSizeBytes: parameter numBytes must be a number";
        }

        maximumSizeInBytes = numBytes;
        purgeCacheIfNecessary();
    }

    function isCache90PercentageFull()
    {
        var cacheInfo = getCacheInfo();
        return (((cacheInfo.cacheSizeInBytes/cacheInfo.maximumSizeInBytes) * 100) > 90);
    }
    function isCache95PercentageFull()
    {
        var cacheInfo = getCacheInfo();
        return (((cacheInfo.cacheSizeInBytes/cacheInfo.maximumSizeInBytes) * 100) > 95);
    }
	function setCacheSize(isMobileDevice){
        if(isMobileDevice)
            maximumSizeInBytes = maximumSizeInBytesForMobileDevice; // 800 MB cache
        else
            maximumSizeInBytes = maximumSizeInBytesForSystem; // 800 MB cache
        maximumSizeToReduceInBytes = (maximumSizeInBytes * 0.40); // 250 MB cache
        maximumSizeToReduceInBytesInViewingSeries = (maximumSizeInBytes * 0.20); // 125 MB cache
    
        
	}
	
    /**
     * Get the cache percentage
     */ 
    function getCachePercentage()
    {
        var cacheInfo = getCacheInfo();
        return ((cacheInfo.cacheSizeInBytes/cacheInfo.maximumSizeInBytes) * 100);
    }

    /**
     * Return the image's raw pixel buffer array data
     * @param {Type} image - Rendered image in the viewport
     */
    function getRawData(image) {
        try
        {
            if(image === undefined || image === null) {
                return undefined;
            }

            if(!image.isCompressed) {
                return image.imageData;
            }

            var rawImageData = pako.inflate(image.imageData);
            if (image.bitsAllocated == 16) {
                var imageDataLength = rawImageData.length;
                var rawImageData16 = new Uint16Array(imageDataLength / 2);
                var pixelIndex = 0;
                for (var i = 0; i < imageDataLength; i += 2) {
                    rawImageData16[pixelIndex++] = (rawImageData[i + 1] * 256) + rawImageData[i];
                }

                rawImageData = rawImageData16;
            }

            return rawImageData;
        }
        catch(e)
        { }
    }

    /**
     * To set the Visual viewport image id as well as raw pixel data in Key value form
     * @param {Type} image - Rendered image in the viewport
     * @param {Type} canvasId - specifies the canvas id
     */
    function setImageData(image, canvasId, isBackup) {
        try
        {
            if(image == null || image == undefined || 
               canvasId == null || canvasId == undefined) {
                // Invalid object
                return;
            }

            if(!image.isCompressed) {
                return;
            }

            // Set the default memory
            if(cacheSizeInBytes == 0) {
                cacheSizeInBytes = browserLoadingMemorySize + compilationMemorySize + stringMemorySize;
            }

            var isNewImageData = false;
            var frameNumber = (isNaN(image.frameNumber) ? 0 : image.frameNumber);
            var imageKey = canvasId + " | " + image.imageUid + "_" + frameNumber;
            var imageData = viewportImageDataMap.get(imageKey);
            if(imageData === undefined || imageData === null) {
                viewportImageDataMap.set(imageKey, getRawData(image));
                isNewImageData = true;
            }

            // Delete the existing image in the map for same renderer
            viewportImageDataMap.forEach(function(value, key, map) {
                if(key !== imageKey) {
                    if(value !== undefined) {
                        cacheSizeInBytes -= value.length;
                        cacheSizeInBytes -= image.renderSizeInBytes;
                    }
                    map.set(key, undefined);
                } else if(isNewImageData){
                    cacheSizeInBytes += value.length;
                    cacheSizeInBytes += image.renderSizeInBytes;
                }
            });

            if(dumpInConsole) {
                var cacheInKB = cacheSizeInBytes / 1024;
                var cacheInMB = cacheInKB / 1024;
                if(cacheInMB > 800) {
                    console.error("cacheInMB => " + cacheInMB);
                }
            }

            if(isBackup === true) {
                return viewportImageDataMap.get(imageKey);
            }
        }
        catch(e)
        { }
    }

    /**
     * To get the Visual viewport image's raw pixel buffer array data
     * @param {Type} image - Rendered image in the viewport
     * @param {Type} canvasId - specifies the canvas id
     */
    function getImageData(image, canvasId) {
        try
        {
            if(image == null || image == undefined || 
               canvasId == null || canvasId == undefined) {
                // Invalid object
                return;
            }

            if(!image.isCompressed) {
                return image.imageData;
            } else {
                var frameNumber = (isNaN(image.frameNumber) ? 0 : image.frameNumber);
                var imageKey = canvasId + " | " + image.imageUid + "_" + frameNumber;
                var imageData = viewportImageDataMap.get(imageKey);
                if(imageData === undefined || imageData === null) {
                    imageData = setImageData(image, canvasId, true);
                }

                return imageData;
            }
        }
        catch(e)
        { }

        return undefined;
    }

    /**
     * Delete the cache image
     * @param {Type} imageKey - Specifies the image key 
     */ 
    function deleteCacheImage(imageKey) {
        try
        { 
            var cacheImage = cachedImages[imageKey];
            if(cacheImage === undefined) {
                return;
            }

            var image = cacheImage.image;
            if(image === undefined || image === null) {
                return;
            }

            image.imageData = undefined;
            image.wlCanvas = undefined;
            image.wlCanvasContext = undefined;
            image.wlCanvasData = undefined;

            delete cachedImages[imageKey];
            cachedImages[imageKey] = undefined;
        }
        catch(e)
        { }
    }

     /**
     * check the last cache image is series first image or not
     * @param {Type} lastCachedImage - Specifies the lastCachedImage details
     */ 
    function isPurgeFirstImage(lastCachedImage){
        try {
             //check multi frame or not.
            var imageValue = dicomViewer.Series.Image.getImage(lastCachedImage.studyUid,0,0);  
            var isMultiFrame = dicomViewer.thumbnail.isImageThumbnail(imageValue,true);

            var imageIndex = !isMultiFrame ? parseInt( dicomViewer.Series.Image.getImageIndex(lastCachedImage.studyUid, lastCachedImage.seriesIndex, lastCachedImage.imageUid)) :"";
            if((isMultiFrame && lastCachedImage.frameIndex == 0) || (!isMultiFrame && imageIndex == 0) ) {
                return false;
            }
        }
        catch(e)
        { }
        return true;
    }

     /**
     * Cache the first image of the series
     * @param {Type} study - Specifies the study details
     */ 
    function cacheFirstImage (study) {
        try
        {
            if(study.seriesCount < 1) {
                return;
            }

            var imageValue = dicomViewer.Series.Image.getImage(study.studyUid, 0,0);  
            var isMultiFrame = dicomViewer.thumbnail.isImageThumbnail(imageValue,true);
            var seriesCount = study.seriesCount

            if(isMultiFrame){
                seriesCount = study.series[0].images.length;
            }

            for(var index = 0; index < seriesCount; index++) {
                var imageUid;
                var seriesIndex = index;
                var imageIndex = 0;

                if(imageValue.imageType !== "video") {
                    if(isMultiFrame) {
                        seriesIndex = 0;
                        imageIndex = index;
                    }
                    imageUid = study.series[seriesIndex].images[imageIndex].imageUid ;
                    
                    //Storing the image in the cache for given imageUid and loading the Image promise which will resolve to the loaded image object.
                    var loadImageDeferred = dicomViewer.loadAndCacheImage(study.studyUid, imageUid, 0, index, study.series[seriesIndex].images[imageIndex].imageType);
                    
                    loadImageDeferred.done(function(image) {
                        //Get Renderer object
                        var renderer = dicomViewer.renderer.getImageRenderer(image.imageUid+"_"+image.frameNumber);
                        if(renderer) {
                            dicomViewer.renderer.removeImageRenderer(image.imageUid+"_"+image.frameNumber);
                            var deferred = $.Deferred();
                            deferred.resolve(image);
                            var serieLayout = dicomViewer.getActiveSeriesLayout();
                            var imageCanvasValue = dicomViewer.getimageCanvasOfViewPort(serieLayout.getSeriesLayoutId());
                            //Rendering the first image for all the series in the layout
                            renderer.loadImageRenderer(deferred, undefined, study.studyUid);
                        }
                    });
                } else {
                    imageUid = study[index].imageUid;
                    dicomViewer.loadAndCacheImage(study.studyUid, imageUid, 0, index, imageValue.imageType);
                }
            }
        }
    catch(e)
    { }
}

    // module exports

    dicomViewer.imageCache = {
        isCache90PercentageFull: isCache90PercentageFull,
        isCache95PercentageFull: isCache95PercentageFull,
        purgeCacheViewingSeries : purgeCacheViewingSeries,
        putImagePromise : putImagePromise,
        getImagePromise: getImagePromise,
        getCacheInfo : getCacheInfo,
        setMaximumSizeBytes : setMaximumSizeBytes,
        isInCache : isInCache,
		setCacheSize : setCacheSize,
        purgeCacheAll : purgeCacheAll,
        clearCache : clearCache,
        getCachePercentage : getCachePercentage,
        setImageData: setImageData,
        getImageData: getImageData,
        getRawData: getRawData,
        cacheFirstImage: cacheFirstImage
    };

    return dicomViewer;
}(dicomViewer));/**
 * New node file
 */
var dicomViewer = (function (dicomViewer) {

    "use strict";
	
	var imageRendererMap = {};
    var cacheDataMap = {};
    var cachedImageCount = 0;
    var prevNextCount = 2;
    var timeOutSecs = 2;
    var studiesToCache = new Array();
    var cacheData = {
			studyUid : undefined,
            frameIndex: 0,
            imageIndex : 0,
            nextcacheincrement : 1,
            previouscachecount : 0,
            incrementside:1,
            seriesIndex:0,
            enabled: true,
			cachedCount:0
        };
    var totalStudiesMap = new Map();
    
    function addStudyToCacheMap(studyUid)
	{
        var found = false;
        for(var i=0; i< studiesToCache.length; i++)
        {
            if(studiesToCache[i] === studyUid)
            {                
                found = true;                
            }
        }
        if(!found)
            studiesToCache[studiesToCache.length] =  studyUid;
             
	}  
    function removeStudyFromCacheMap(studyUid)
	{   
        var deleted = false;
        for(var i=0; i< studiesToCache.length; i++)
        {
            if(deleted)
            {
                studiesToCache[i-1] = studiesToCache[i];
            }
            if(studiesToCache[i] === studyUid)
            {                
                deleted = true;                
            }
        }
        if(deleted)
            delete studiesToCache[studiesToCache.length - 1];
	}

    // Set the value as undefined for respective study
    // This operation will happen when the complete series are cached
    function removeStudyFromTotalStudiesMap(studyUid)
    {
        var study = totalStudiesMap.get(studyUid);
        if(study != null && study != undefined){
            totalStudiesMap.set(studyUid, undefined);
        }
    }

    // Decrease the processed image count for respective series
    // This operation will happen when an image is unloading
    function reduceProcessedImageCount(studyUid, seriesIndex)
    {
        var study = totalStudiesMap.get(studyUid);
        if(study != null && study != undefined){
            study.Series.forEach(function(series) {
                if(series.seriesIndex === seriesIndex) {
                    series.ProcessedImageCount -= 1;
                    if(series.ProcessedImageCount < 0) {
                        series.ProcessedImageCount = 0;	
                    }
                }
             });
        }
    }

	function startCacheImages(studyUid,isManualTrigger, study)
	{
        cacheData.enabled = true;
        cacheImages(studyUid, true, study);
	}    
    
    
    function cacheImages(studyUid, isManualTrigger, studyDetails)
	{
		if(cacheData.studyUid === undefined)
		{
			cacheData.studyUid = studyUid;
		}
		else if(cacheData.studyUid != studyUid){
			cacheData.studyUid = studyUid;
            cacheData.frameIndex = (cacheData.cachedCount != 0 ? -1 : 0);
            cacheData.imageIndex = 0;
            cacheData.nextcacheincrement = 1;
            cacheData.previouscachecount = 0;
            cacheData.incrementside = 1;
            cacheData.seriesIndex = 0;
            cacheData.enabled = true;
		}

        // Add the list of series for respective study to Map.
        // From the map we can identify actual processed image count 
        // and total image count for respective series
        if(studyUid !== undefined && studyUid !== null) {
            var study = { Series: undefined };
            study = totalStudiesMap.get(studyUid);
            if(study === undefined || study == null){
                study = { Series: new Array() };
                var SeriesCount = dicomViewer.Study.getSeriesCount(studyUid);
                for(var index = 0; index < SeriesCount; index++){
                    var series = {seriesIndex: index,
                                  TotalImageCount: dicomViewer.Series.getImageCount(studyUid, index),
                                  ProcessedImageCount : 0
                                 };
                    study.Series.push(series);
                }

                // Set the study
                totalStudiesMap.set(studyUid, study);
            } else {
                // check whether the series is presented in the map
                var existingSeries = undefined;
                study.Series.forEach(function(series) {
                    if(series.seriesIndex === cacheData.seriesIndex) {
                        existingSeries = series;
                    }
                 });

                // Add the series to study map if the series doesn't exist
                if(existingSeries === undefined) {
                    existingSeries = {seriesIndex: cacheData.seriesIndex, 
                              TotalImageCount: dicomViewer.Series.getImageCount(studyUid, cacheData.seriesIndex),
                              ProcessedImageCount : 0
                            };
                    study.Series.push(existingSeries);
                }

                // Increase the processed image count
                if(existingSeries.TotalImageCount != existingSeries.ProcessedImageCount){
                    existingSeries.ProcessedImageCount += 1;   
                }
            }

            // Update the cache progress text in spinner
            UpdateCacheProgress(studyUid);
        }

        //Set the manula trigger flag to indicate that it is user created 
        if (isManualTrigger == undefined)
        {
            isManualTrigger = true;            
        }
        //If the caching is not enabled then returen.
        if(cacheData.enabled === false)
        {
            return;
        }
        
        //If it is a an automated request then stop the caching when the cache is full.
        if(isManualTrigger === false && dicomViewer.imageCache.isCache90PercentageFull())
        {
						
			var image = dicomViewer.Series.Image.getImage(studyUid, cacheData.seriesIndex,cacheData.imageIndex);
            if (image.imageType === IMAGETYPE_RAD || image.imageType === IMAGETYPE_RADECHO || image.imageType === IMAGETYPE_JPEG || image.imageType == IMAGETYPE_RADSR || image.imageType == IMAGETYPE_CDA)
            {
                var imageUid = dicomViewer.Series.Image.getImageUid(image);   

                var loadImageDeferred = dicomViewer.loadAndCacheImage(studyUid,imageUid,cacheData.frameIndex, cacheData.seriesIndex, image.imageType);
                cacheData.cachedCount+=1;
                cachedImageCount += 1;
                loadImageDeferred.done(function(image)
                {			
                    

                    //Get Renderer object
                    var renderer = dicomViewer.renderer.getImageRenderer(image.imageUid+"_"+image.frameNumber);
                    if(renderer)
                    {
                        removeImageRenderer(image.imageUid+"_"+image.frameNumber);
                        var deferred = $.Deferred();
                        deferred.resolve(image);
                        var serieLayout = dicomViewer.getActiveSeriesLayout();
                        var imageCanvasValue = dicomViewer.getimageCanvasOfViewPort(serieLayout.getSeriesLayoutId());
                        renderer.loadImageRenderer(deferred/*,imageCanvasValue*/);
                    }

                });	
		        if(cacheData.previouscachecount < prevNextCount)
                {                    
                    dicomViewer.imageCache.purgeCacheAll(false);
                    if(!dicomViewer.imageCache.isCache90PercentageFull())
                    {
                        setTimeout(function() {
                           cacheImages(cacheData.studyUid, false );
                        }, timeOutSecs);
                    }else
                    {
                        var viewingCurrentSeries = false;
                        if(dicomViewer.thumbnail.isImageThumbnail(image))
                        {
                            viewingCurrentSeries = dicomViewer.viewports.isImageVisible(cacheData.seriesIndex,cacheData.imageIndex);
                        }
                        else
                        {
                            viewingCurrentSeries = dicomViewer.viewports.isImageVisible(cacheData.seriesIndex);
                        } 
                        if(viewingCurrentSeries)
                        {
                            dicomViewer.imageCache.purgeCacheAll(true);
                            cacheData.previouscachecount = 0;
                            if(!dicomViewer.imageCache.isCache90PercentageFull())
                            {
                                setTimeout(function() {
                                   cacheImages(cacheData.studyUid,true);
                                }, timeOutSecs);
                            }else
                                cacheData.enabled = false; 
                        }else
                            cacheData.enabled = false;
                    }
                }else
                {
                    cacheData.enabled = false; 
                }
                if(cacheData.enabled === false ) 
                    return;
		      }
            else
            {
                cacheData.enabled = false;
                return;
            }
        }
		var image = dicomViewer.Series.Image.getImage(studyUid,cacheData.seriesIndex,cacheData.imageIndex);
        if(image === undefined) 
		{
             cacheData.enabled = false;   
            return;
        }
		if(cacheData.cachedCount != 0)
		{
			var cacheFrameIndex = cacheData.frameIndex + 1; 
            var frameCount = dicomViewer.Series.Image.getImageFrameCount(image);
            if(frameCount=== undefined)
                    frameCount = 1;
			cacheFrameIndex = Math.min(frameCount, cacheFrameIndex);
			cacheFrameIndex = Math.max(0, cacheFrameIndex);            
            
			if(cacheFrameIndex >= frameCount)
			{
                if(cacheDataMap.length > 0)
                {
                    var newCacheData = cacheDataMap[cacheDataMap.length];
                    cacheData.enabled = true;
                    cacheData.seriesIndex = parseInt(newCacheData.seriesIndex);
                    cacheData.imageIndex = newCacheData.imageIndex;
                    cacheData.frameIndex = newCacheData.frameIndex;                    
                    cacheData.cachedCount = 0;
                    cacheData.nextcacheincrement = 1;
                    cacheData.previouscachecount = 0;
                    cacheData.incrementside = 1;
                    delete cacheDataMap[cacheDataMap.length];
                }
                else if(dicomViewer.thumbnail.isImageThumbnail(image,true))
                {
                    var cacheImageIndex = cacheData.imageIndex + (cacheData.nextcacheincrement * cacheData.incrementside);                
                    cacheData.nextcacheincrement = cacheData.nextcacheincrement + 1;
                    if( cacheImageIndex < 0)
                    {
                        cacheData.incrementside = 1;
                        cacheData.previouscachecount = prevNextCount + 1;
                        cacheImageIndex = cacheImageIndex + cacheData.nextcacheincrement;
                        cacheData.nextcacheincrement = 1;
                    }
                    else if(cacheData.previouscachecount < prevNextCount)
                    {
                        if(cacheData.incrementside === -1)
                        {
                            cacheData.incrementside = 1;
                            cacheData.previouscachecount = cacheData.previouscachecount +1;                    
                        }
                        else 
                        {
                            cacheData.incrementside = -1;
                        }
                    }else
                    {
                        cacheData.incrementside = 1;
                        cacheData.nextcacheincrement = 1;
                        cacheData.previouscachecount = prevNextCount + 1;
                    }
                }
                else
                {
                     cacheImageIndex = cacheData.imageIndex + 1;
                }
                var imageCount = dicomViewer.Series.getImageCount(studyUid, cacheData.seriesIndex);
                //ImageCount is undefined for jpeg non diccom images we are setting to 1 as default
                if(imageCount=== undefined)
                    imageCount = 1;
                
				cacheImageIndex = Math.min(imageCount,cacheImageIndex);
				cacheImageIndex = Math.max(0, cacheImageIndex);
		        
               
                
				// if no change turn off prefetching for this stack
				if( cacheImageIndex >= imageCount)
				{			
                    if(dicomViewer.thumbnail.isImageThumbnail(image))
                    {
                        var cacheSeriesIndex = cacheData.seriesIndex + (cacheData.nextcacheincrement * cacheData.incrementside);                
                        cacheData.nextcacheincrement = cacheData.nextcacheincrement + 1;
                        if( cacheSeriesIndex < 0)
                        {
                            cacheData.incrementside = 1;
                            cacheData.previouscachecount = prevNextCount + 1;
                            cacheSeriesIndex = cacheSeriesIndex + cacheData.nextcacheincrement;
                            cacheData.nextcacheincrement = 1;
                        }
                        else if(cacheData.previouscachecount < prevNextCount)
                        {
                            if(cacheData.incrementside === -1)
                            {
                                cacheData.incrementside = 1;
                                cacheData.previouscachecount = cacheData.previouscachecount +1;                    
                            }
                            else 
                            {
                                cacheData.incrementside = -1;
                            }
                        }else
                        {
                            cacheData.incrementside = 1;
                            cacheData.nextcacheincrement = 1;
                            cacheData.previouscachecount = prevNextCount + 1;
                        }
                    }
                    else
                    {
                        cacheSeriesIndex = cacheData.seriesIndex + 1;
                    }
					 cacheSeriesIndex = Math.min(dicomViewer.Study.getSeriesCount(studyUid) - 1, cacheSeriesIndex);
					 cacheSeriesIndex = Math.max(0, cacheSeriesIndex);
					 if(cacheSeriesIndex === cacheData.seriesIndex)
					 {
						removeStudyFromCacheMap(studyUid)
                        removeStudyFromTotalStudiesMap(studyUid);
                        if(studiesToCache.length > 0)
                        {
                            cacheData.seriesIndex = 0;
                            cacheData.cachedCount = 0;
                            cacheImages(studiesToCache[0], false );
                        }
						return;
					 }
					 else
					{
						 cacheData.imageIndex = 0;
						 cacheImageIndex = 0;
					}
					 cacheData.seriesIndex = cacheSeriesIndex;
				}
				cacheData.frameIndex = 0;
				cacheFrameIndex = 0;
				cacheData.imageIndex = cacheImageIndex;
			}           
			cacheData.frameIndex = cacheFrameIndex;
		}
		var image = dicomViewer.Series.Image.getImage(studyUid, cacheData.seriesIndex,cacheData.imageIndex);
        var imageType  = image.imageType;
        //When image type is blob increase the series index and check the next series
        //if (imageType ===IMAGETYPE_BLOB)
        if (isBlob(imageType))
        {
            var numberOfSeries = dicomViewer.Study.getSeriesCount(studyUid);
            if(numberOfSeries-1 === cacheData.seriesIndex)
            {                
                removeStudyFromCacheMap(studyUid)
                removeStudyFromTotalStudiesMap(studyUid);
                if(studiesToCache.length > 0)
                {
                    cacheData.seriesIndex = 0;
                    cacheData.cachedCount = 0;
                    cacheImages(studiesToCache[0], false );
                }
                return;
            }
            cacheData.seriesIndex  = cacheData.seriesIndex+1;
             setTimeout(function() {
            	 cacheImages(cacheData.studyUid, false );
            }, timeOutSecs);
        }        
        else if (imageType === IMAGETYPE_RAD || imageType === IMAGETYPE_RADECHO || imageType === IMAGETYPE_JPEG || imageType == IMAGETYPE_RADSR || imageType == IMAGETYPE_CDA)
		{
		    var imageUid = dicomViewer.Series.Image.getImageUid(image);   
            var loadImageDeferred;
            var isMultiFrame = dicomViewer.thumbnail.isImageThumbnail(image,true);
            if(isMultiFrame) {
                loadImageDeferred= dicomViewer.loadAndCacheImage(studyUid,imageUid,cacheData.frameIndex, cacheData.imageIndex, image.imageType);
            } else {
                loadImageDeferred= dicomViewer.loadAndCacheImage(studyUid,imageUid,cacheData.frameIndex, cacheData.seriesIndex, image.imageType);
            }

            loadImageDeferred.done(function(image)
            {			
                cacheData.cachedCount+=1;
                cachedImageCount += 1;

                //Get Renderer object
                var renderer = dicomViewer.renderer.getImageRenderer(image.imageUid+"_"+image.frameNumber);
                if(renderer)
                {
                    removeImageRenderer(image.imageUid+"_"+image.frameNumber);
                    var deferred = $.Deferred();
                    deferred.resolve(image);
                    var serieLayout = dicomViewer.getActiveSeriesLayout();
                    var imageCanvasValue = dicomViewer.getimageCanvasOfViewPort(serieLayout.getSeriesLayoutId());
                    renderer.loadImageRenderer(deferred, undefined, studyUid/*,imageCanvasValue*/);
                }

                if(!dicomViewer.thumbnail.isImageThumbnail(image))
                {
                    isManualTrigger = dicomViewer.viewports.isImageVisible(cacheData.seriesIndex);
                }
                else
                {
                    isManualTrigger = dicomViewer.viewports.isImageVisible(cacheData.seriesIndex,cacheData.imageIndex);           
                }

                // Dump the cache memory size in console
                if(dumpInConsole) {
                    dumpCacheSize();
                }

               if(isManualTrigger)  isManualTrigger = (!dicomViewer.imageCache.isCache90PercentageFull());            
                setTimeout(function() {                    
                     cacheImages(cacheData.studyUid,false);
                }, timeOutSecs);

            });		
		}
        else
        {
            cacheData.enabled = false;
            return;
        }
        if(studyDetails) {
            dicomViewer.imageCache.cacheFirstImage(studyDetails);
        }
	}

    function stopCacheProgress()
    {
        cacheData.enabled = false;        
    }
    
    function getPrevNextCount()
    {
        return prevNextCount;    
    }
    
    function removeCacheMapInStudy(studyUid)
    {
        for(var key in cacheDataMap)
        {
            delete cacheDataMap[key];
        }
    }
    
    function setCacheDataToCache(studyUid,seriesIndex,imageIndex,frameIndex)
    {
        var isCacheNeeded = true; 
        var isImageVisible = false; 
        var imageValue = dicomViewer.Series.Image.getImage(studyUid, seriesIndex,imageIndex);  
        var isMultiFrame = dicomViewer.thumbnail.isImageThumbnail(imageValue,true);       
        
        if(isMultiFrame)
        {            
            isImageVisible = dicomViewer.viewports.isImageVisible(cacheData.seriesIndex,cacheData.imageIndex);            
        }else
        {
            isImageVisible = dicomViewer.viewports.isImageVisible(cacheData.seriesIndex);            
        }
        if(isImageVisible && dicomViewer.imageCache.isCache90PercentageFull())
        {
            dicomViewer.imageCache.purgeCacheAll(false);
            if(dicomViewer.imageCache.isCache90PercentageFull())
                dicomViewer.imageCache.purgeCacheAll(true);
            if(dicomViewer.imageCache.isCache90PercentageFull())
                dicomViewer.imageCache.purgeCacheViewingSeries();
        }
        if(cacheData.enabled === true && isImageVisible === true)
        {
             if(isMultiFrame && seriesIndex === cacheData.seriesIndex && imageIndex === cacheData.imageIndex)
                isCacheNeeded = false;
            if(!isMultiFrame && seriesIndex === cacheData.seriesIndex)
                isCacheNeeded = false;
            if(isCacheNeeded)
            {
                var newCacheData = {
                    studyUid : studyUid,
                    frameIndex: frameIndex,
                    imageIndex : imageIndex,
                    nextcacheincrement : 1,
                    previouscachecount : 0,
                    incrementside:1,
                    seriesIndex:seriesIndex,
                    enabled: true,
                    cachedCount:0
                };
                cacheDataMap[cacheDataMap.length] = newCacheData;
            }            
        }
        else
        {            
            cacheData.studyUid = studyUid;
            cacheData.seriesIndex = parseInt(seriesIndex);
            cacheData.imageIndex = imageIndex;
            if(frameIndex !== undefined) cacheData.frameIndex = frameIndex;
            else cacheData.frameIndex = 0;
            cacheData.cachedCount = 0;
            cacheData.nextcacheincrement = 1;
            cacheData.previouscachecount = 0;
            cacheData.incrementside = 1;  
        }
        cacheData.enabled = true;
    }
    
	function isCacheEnabled()
    {
        return cacheData.enabled;
    }
    function restartCache(studyUid, seriesIndex, imageIndex, forceCache)
    {
        if( cacheData.seriesIndex != seriesIndex || forceCache){
			stopCacheProgress();
			setCacheDataToCache(studyUid,seriesIndex,imageIndex);
			startCacheImages(studyUid);
		}
    }
    
	function setImageRenderer(imageUid,renderer)
	{
		if(imageUid === undefined)
		{
			throw "Exception: imageUid should not be null/undefined"
		}
		
		imageRendererMap[imageUid] = renderer;
	}
	
	function getImageRenderer(imageUid)
	{
		return imageRendererMap[imageUid];
	}
    
    function removeImageRenderer(imageUid)
    {
        delete imageRendererMap[imageUid];
    }
	
    // Update the spinner text
    function UpdateCacheProgress(studyUID) {
        try
        {
            var study = totalStudiesMap.get(studyUID);
            if(study !== undefined && study !== null) {
                var allViewports = dicomViewer.viewports.getAllViewports();
                if(allViewports !== null && allViewports !== undefined) {
                    var seriesLayoutId = undefined;
                    $.each(allViewports, function(key, value) {
                        study.Series.forEach(function(series) {
                            if(value.studyUid === studyUID){
                                if(value.seriesIndex === series.seriesIndex) {
                                    seriesLayoutId = value.seriesLayoutId;
                                    if(seriesLayoutId !== undefined && studyUID !== undefined) {
                                        var imageCount = series.TotalImageCount;
                                        var cacheProgressText = "&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbspPlease Wait...<br>Image Caching " + series.ProcessedImageCount + " Of " + imageCount;
                                        $("#"+seriesLayoutId+"_spinner").css({'text-align': 'left'});
                                        $("#"+seriesLayoutId+"_spinner").html(cacheProgressText);
                                    }
                                }
                            }
                        });
                    });
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Dump cache memory size
     */ 
    function dumpCacheSize() {
        var cacheInfo = dicomViewer.imageCache.getCacheInfo();
        if(cacheInfo !== undefined && cacheInfo !== null) {
            var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
            var i = parseInt(Math.floor(Math.log(cacheInfo.cacheSizeInBytes) / Math.log(1024)));
            var totalsize = Math.round(cacheInfo.cacheSizeInBytes / Math.pow(1024, i), 2) + ' ' + sizes[i];
            console.log("Cache size: " + totalsize);
        }
    }

	dicomViewer.renderer = {
		setImageRenderer : setImageRenderer,
		getImageRenderer : getImageRenderer,
        removeImageRenderer : removeImageRenderer
	};
	dicomViewer.cacheImages = cacheImages;
    dicomViewer.isCacheEnabled = isCacheEnabled;
	dicomViewer.startCacheImages = startCacheImages;
    dicomViewer.stopCacheProgress = stopCacheProgress;
    dicomViewer.setCacheDataToCache = setCacheDataToCache;
    dicomViewer.restartCache = restartCache;
    dicomViewer.getPrevNextCount = getPrevNextCount;
    dicomViewer.removeCacheMapInStudy =removeCacheMapInStudy;
    dicomViewer.addStudyToCacheMap = addStudyToCacheMap;
    dicomViewer.removeStudyFromCacheMap = removeStudyFromCacheMap;
    dicomViewer.reduceProcessedImageCount = reduceProcessedImageCount;
    return dicomViewer;
}(dicomViewer));var dicomViewer = (function(dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var dicomHeaders = {};
    /**
     *@param url
     *Send the request based  on the url(image info call)
     *when the call is success(200) it will be resolved in jquery deffered
     *if the result is not success it will be rejected in jquery deffered
     *and return the jquery deffered object
     */
    function getDicomHeaderInfo(url) {
        if (url === undefined) {
            throw "Exception: url should not be undefined";
        }
        var deferred = $.Deferred();
        var oReq = new XMLHttpRequest();
        oReq.open("get", url, true);
        oReq.responseType = 'application/json';
        oReq.onreadystatechange = function(oEvent) {
            // TODO: consider sending out progress messages here as we receive the pixel data
            if (oReq.readyState === 4) {
                if (oReq.status === 200) {
                    var text = oReq.responseText;
                    deferred.resolve(text);
                } else {
                    deferred.reject();
                }
            }
            else if(oReq.status === 500) {
                var description = xhttp.statusText + "\nFailed to get the dicom geader information for this url." + "\nURL: " + url;  
                sendViewerStatusMessage(xhttp.status.toString(), description);
            }
        };
        oReq.send();
        return deferred;
    }

    function getDicomHeaderInfo(url) {

        if (url === undefined) {

            throw "Exception: url should not be undefined";

        }
		logger.startTime("imageInfocall");
        var deferred = $.Deferred();
        var oReq = new XMLHttpRequest();
        oReq.open("get", url, true);
        //oReq.responseType = 'application/json';
        oReq.onreadystatechange = function(oEvent) {
            // TODO: consider sending out progress messages here as we receive the pixel data
            if (oReq.readyState === 4) {

                if (oReq.status === 200) {
                    var text = oReq.responseText;
                    deferred.resolve(text);
					logger.endTime("imageInfocall");
                } else {
                    deferred.reject();
                }
            }
            else if(oReq.status === 500) {
                var description = xhttp.statusText + "\nFailed to get the dicom geader information for this url." + "\nURL: " + url; 
                sendViewerStatusMessage(xhttp.status.toString(), description);
            }
        };
        oReq.send();
        return deferred;
    }

    function getDicomHeaderValues(studyUid, imageUid) {
		var urlParameters = dicomViewer.getDicomHeaderUrl(imageUid);
        var metaURL = dicomViewer.url.getDicomImageURL(urlParameters);
        var request = new XMLHttpRequest();
        request.open('GET', metaURL, false);
        var thumbnailRendererObject = this;        
        if(request.status === 500) {
            var description = xhttp.statusText + "\nFailed to get the dicom header values for the respective images." + "\nImage UID: " + imageUid + "\nStudy UID: " + studyUid; 
                sendViewerStatusMessage(xhttp.status.toString(), description);
        }
        request.send();
        return JSON.parse(request.responseText);
    }

	function getMetadata(studyUid, imageUid) {
		var urlParameters = dicomViewer.getDicomHeaderUrl(imageUid);
        var metaURL = dicomViewer.url.getDicomImageMetadataURL(urlParameters);
        var deferred = $.Deferred();
        var oReq = new XMLHttpRequest();
        oReq.open("get", metaURL, true);
        //oReq.responseType = 'application/json';
        oReq.onreadystatechange = function(oEvent) {
            // TODO: consider sending out progress messages here as we receive the pixel data
            if (oReq.readyState === 4) {

                if (oReq.status === 200) {
                    var text = oReq.responseText;
                    deferred.resolve(text);
					logger.endTime("imageInfocall");
                } else {
                    deferred.reject();
                }
            }
            else if(oReq.status === 500) {
                var description = xhttp.statusText + "\nFailed to get the meta data for the respective image." + "\nImage UID: " + imageUid + "\nStudy UID: " + studyUid; 
                sendViewerStatusMessage(xhttp.status.toString(), description);
            }     
        };
        oReq.send();
        return deferred;
    }
	
    function putDicomHeader(imageUid, dicomHeader) {
        if (imageUid === undefined) {
            throw "putDicomHeader: imageUid should not be null/undefined";
        }
        if (dicomHeader === undefined) {
            throw "putDicomHeader: dicomHeader not be null/undefined";
        }
        dicomHeaders[imageUid] = dicomHeader;
    }

    /**
     *@param imageUid
     *@param dicomHeader
     *store the imageInfo object to the dicomHeaders using the image id as key
     */
    function putDicomHeader(imageUid, dicomHeader) {
        if (imageUid === undefined) {
            throw "putDicomHeader: imageUid should not be null/undefined";
        }
        if (dicomHeader === undefined) {
            throw "putDicomHeader: dicomHeader not be null/undefined";
        }

        dicomHeaders[imageUid] = dicomHeader;
    }

    /**
     *@param imageUid
     *Retrieve the imageInfo object from the dicomHeaders using the image id as key
     */
    function getDicomHeader(imageUid) {
        if (imageUid === undefined) {
            throw "getDicomHeader: imageUid should not be null/undefined";
        }
        return dicomHeaders[imageUid];
    }

    dicomViewer.header = {
        getDicomHeaderInfo: getDicomHeaderInfo,
        putDicomHeader: putDicomHeader,
        getDicomHeader: getDicomHeader,
        getDicomHeader: getDicomHeader,
        getDicomHeaderValues: getDicomHeaderValues,
        getMetadata: getMetadata
    };

    return dicomViewer;

}(dicomViewer));/*
    To render the patient orientation lables
*/
var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }
    var hFlipCount = false;
    var vFlipCount = false;
    var directionalMarker = {
            left : 'L',
            right : 'R',
            bottom : 'F',
            top : 'H'
    };
    
    function initDirectionalMarker(imageinfo)
    { 
        if(imageinfo != undefined) {
            var markers = imageinfo.getDirectionalMarkers();
            if(markers != null)
            {
                // Set the default values if the markers is not available to avoid null condition.
                if (directionalMarker == null)
                {
                    directionalMarker = {
                    left : 'L',
                    right : 'R',
                    bottom : 'F',
                    top : 'H'
                  };
                }

                directionalMarker.left = markers.left;
                directionalMarker.right = markers.right;
                directionalMarker.bottom  = markers.bottom;
                directionalMarker.top = markers.top;
            }
            else
            {
                directionalMarker = null;
            }
        }
    }
    
    /* Get the image orientation */
    function getDirectionalMarker( )
    {
    	return  directionalMarker;	
    }
    
    /* Rotate the patient lables to the degree given */
    function rotateDirectionalMarker(presentation)
    {
    	var rotation = (presentation.getRotation()) / 90; // Find the number of times to rotate the patient lables
        var rotationDirection = rotation < 0 ? -1 : 1;  // Find the rotation direction from current position        
        rotation = rotation * rotationDirection;
        if(directionalMarker != null)
        {
            for( var rotationCount = 0; rotationCount < rotation; rotationCount++)
            {
                if(rotationDirection ==1)   // Rotate in clock wise
                { 
                    var left = directionalMarker.left;
                    directionalMarker.left = directionalMarker.bottom;
                    directionalMarker.bottom = directionalMarker.right;
                    directionalMarker.right = directionalMarker.top;
                    directionalMarker.top = left;
                }else // Rotate in anti-clock wise
                {
                    var left = directionalMarker.left;
                    directionalMarker.left = directionalMarker.top;
                    directionalMarker.top = directionalMarker.right;
                    directionalMarker.right = directionalMarker.bottom;
                    directionalMarker.bottom = left;
                }
            }
            if(presentation.getHorizontalFilp() && presentation.getVerticalFilp())
            {
               hFlipCount = false;
               vFlipCount = false;
            }
            if((presentation.getHorizontalFilp() && !hFlipCount) || (presentation.getHorizontalFilp() && !vFlipCount) || (presentation.getHorizontalFilp() && vFlipCount))
            {
                var left = directionalMarker.left;
                directionalMarker.left = directionalMarker.right;
                directionalMarker.right = left;
                hFlipCount = !hFlipCount;
            }
            if((presentation.getVerticalFilp() && !vFlipCount) || (presentation.getVerticalFilp() && !hFlipCount) || (presentation.getVerticalFilp() && hFlipCount))
            {
                var top = directionalMarker.top;
                directionalMarker.top = directionalMarker.bottom;
                directionalMarker.bottom = top;
                vFlipCount = !vFlipCount;
            }
        }
    }    
    
    
    dicomViewer.directionalMarker = {
    		initDirectionalMarker : initDirectionalMarker,
            getDirectionalMarker : getDirectionalMarker,
    		rotateDirectionalMarker : rotateDirectionalMarker    		
    };
    
    return dicomViewer;
}(dicomViewer));/**
 * New node file
 */

var dicomViewer = (function(dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var isMeasurementEdit;
    var dicomImageMeasurements = {};
    
    var dicomImageAngleMeasurements = {};
    
    var dicomImageEllipseMeasurements = {};
    
    var dicomImageRectangleMeasurements = {};

    var dicomImageTraceMeasurements = {};

    var dicomImageVolumeMeasurements = {};

    var dicomImageMitralGradientMeasurements = {};

    var dicomImagePenMeasurements = {};

    var mousePressedCounter = 0;
    
    var tempdata = undefined; // On going data

	var lineMeasurementUnit = "UNITS_CM"; // centimeters as default
	
    var dataToDelete = {
        measurmentType: "",
        key: "",
        arryIndex: "",
        isEditable: "",
        sessionType: 0
    };

    var dataToEdit = undefined;

    var activeImageRenderer = undefined;

    var isLineDeleteCheck = false;
    var isPointDeleteCheck = false;
    var isAngleDeleteCheck = false;
    var isEllipseDeleteCheck = false;
    var isRectangleDeleteCheck = false;
    var isTraceDeleteCheck = false;
    var isVolumeDeleteCheck = false;
	var isMitralGradineDelete = false;
    var isPenDelete = false;

    var MT_LENGTH = "LENGTH";
    var MT_LINE = "LINE";
    var MT_ARROW = "ARROW";
    var MT_POINT = "POINT";
    var MT_ANGLE = "ANGLE";
    var MT_ELLIPSE = "ELLIPSE";
    var MT_HOUNSFIELDELLIPSE = "HOUNSFIELDELLIPSE";
    var MT_RECT = "RECT";
    var MT_HOUNSFIELDRECT = "HOUNSFIELDRECT";
    var MT_TEXT = "TEXT";
    var MT_TRACE = "TRACE";
    var MT_MG = "MG";
    var MT_ASPV = "ASPV";
    var MT_ARPV = "ARPV";
    var MT_MRPV = "MRPV";
    var MT_ARL = "ARL";
    var MT_MRL = "MRL";
    var MT_MVALT = "MVALT";
    var MT_FREEHAND = "FREEHAND";
    var MT_PEN = "PEN";

    var selectedSessionType = 2;

    function setTempData(mouseData) {
        tempdata = mouseData;
    }

    function getTempData() {
        return tempdata;
    }

    function removeTempdata() {
        tempdata = undefined;
    }

    function getDefaultLineMeasurement() {
        return {
            start: {
                x: undefind,
                y: undefined
            },
            end: {
                x: undefined,
                y: undefined
            },
            measurementType: "line"
        };
    }

    function getImageDataForMouseData(mouseData, imageRenderer, context) {
        var start, end = null;
        var first, second, third, fourth, center = null;
        start = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.start, imageRenderer, context);
        end = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.end, imageRenderer, context);
        if (mouseData.measureType == "ellipse") {
            first = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.first, imageRenderer, context);
            second = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.second, imageRenderer, context);
            third = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.third, imageRenderer, context);
            fourth = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.fourth, imageRenderer, context);
            center = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData.center, imageRenderer, context);
        }

        var imageData = {};
        imageData.start = start;
        imageData.end = end;
        imageData.first = first;
        imageData.second = second;
        imageData.third = third;
        imageData.fourth = fourth;
        imageData.center = center;
        imageData.measureType = mouseData.measureType;
        imageData.measurementId = mouseData.measurementId;
        imageData.measurementType = mouseData.measurementType;
        imageData.measurementUnits = mouseData.measurementUnits;
        imageData.measurementComplete = mouseData.measurementComplete;
        imageData.measurementSubType = mouseData.measurementSubType;
        imageData.measurementText = mouseData.measurementText;
        imageData.studyUid = mouseData.studyUid;
        imageData.isEditable = mouseData.isEditable;
        imageData.sessionType = mouseData.sessionType;
        imageData.style = mouseData.style;
        return imageData;
    }


    function getCanvasDataForImageData(imageData, imageRenderer) {
        var start, end = null;
        var first, second, third, fourth, center = null;
        start = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.start, imageRenderer);
        end = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.end, imageRenderer);

        if (imageData.measureType == "ellipse") {
            first = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.first, imageRenderer);
            second = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.second, imageRenderer);
            third = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.third, imageRenderer);
            fourth = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.fourth, imageRenderer);
            center = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates(imageData.center, imageRenderer);
        }

        var canvasData = {};
        canvasData.start = start;
        canvasData.end = end;
        canvasData.first = first;
        canvasData.second = second;
        canvasData.third = third;
        canvasData.fourth = fourth;
        canvasData.center = center;
        canvasData.measureType = imageData.measureType;
        canvasData.measurementId = imageData.measurementId;
        canvasData.measurementType = imageData.measurementType;
        canvasData.measurementUnits = imageData.measurementUnits;
        canvasData.measurementComplete = imageData.measurementComplete;
        canvasData.measurementSubType = imageData.measurementSubType;
        canvasData.measurementText = imageData.measurementText;
        canvasData.studyUid = imageData.studyUid;
        canvasData.isEditable = imageData.isEditable;
        canvasData.sessionType = imageData.sessionType;
        canvasData.style = imageData.style;
        return canvasData;
    }

    var lineMeasurementEnd = false;

    function setLineMeasurementEnd(flag) {
        lineMeasurementEnd = flag;
    }

    function isLineMeasurementEnd() {
        return lineMeasurementEnd;
    }

    var measurementBroken = false;

    function setMeasurementBroken(flag) {
        measurementBroken = flag;
    }

    function isMeasurementBroken() {
        return measurementBroken;
    }
    
    var traceMeasurementEnd = false;

    function setTraceMeasurementEnd(flag) {
        traceMeasurementEnd = flag;
    }

	function isTraceMeasurementEnd() {
        return traceMeasurementEnd;
    }

    var traceMeasurementId = -1;

    function setTraceMeasurementId(traceId) {
        traceMeasurementId = traceId;
    }

    function getTraceMeasurementId() {
        return traceMeasurementId;
    }
    
    // Angle Measurement
    var angleMeasurementEnd = false;

    function setAngleMeasurementEnd(flag) {
        angleMeasurementEnd = flag;
    }

	function isAngleMeasurementEnd() {
        return angleMeasurementEnd;
    }
    
    var angleMeasurementId = -1;

    function setAngleMeasurementId(angleId) {
        angleMeasurementId = angleId;
    }

    function getAngleMeasurementId() {
        return angleMeasurementId;
    }

    function resetMousePressedCounter() {
        mousePressedCounter = 0;
    }
    function getMousePressedCounter() {
        return mousePressedCounter;
    }
    function increaseMousePressedCounter() {
        mousePressedCounter = mousePressedCounter+1;
    }
    
    
    var volumeMeasurementEndFlag = false;

    function setVolumeMeasurementEnd(flag) {
        volumeMeasurementEndFlag = flag;
    }

    function isVolumeMeasurementEnd() {
        return volumeMeasurementEndFlag;
    }

    var volumeMeasurementId = -1;

    function setVolumeMeasurementId(volumeId) {
        volumeMeasurementId = volumeId;
    }

    function getVolumeMeasurementId() {
        return volumeMeasurementId;
    }

    var mitralMeanGradientMeasurementEnd = false;

    function setMitralMeanGradientMeasurementEnd(flag) {
        mitralMeanGradientMeasurementEnd = flag;
    }

	function isMitralMeanGradientMeasurementEnd() {
        return mitralMeanGradientMeasurementEnd;
    }

    var mitralMeanGradientMeasurementId = -1;

    function setMitralMeanGradientMeasurementId(Id) {
        mitralMeanGradientMeasurementId = Id;
    }

    function getMitralMeanGradientMeasurementId() {
        return mitralMeanGradientMeasurementId;
    }

    var penToolEnd = false;
    function setPenToolEnd(flag) {
        penToolEnd = flag;
    }

    function isPenToolEnd() {
        return penToolEnd;
    }

    function addMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context) {
        removeTempdata();		
        if (imageRenderer === undefined) {
            throw "addMeasurements : imageRenderer is null/undefined";
        }

        var measurements = dicomImageMeasurements[imageUid + "_" + frameIndex];
        if (measurements === undefined) {
            measurements = [];
        }
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        imageData.textPosition = mosueData.textPosition;
        mosueData = undefined; // Release the memory for the data 
        measurements[measurements.length] = imageData;
        imageData = undefined; // Release the memory for the data
        dicomImageMeasurements[imageUid + "_" + frameIndex] = measurements;

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }

    var isNearToStartPoint, isNearToFirstPoint;
    var isNearToEndPoint, isNearToSecondPoint;
    var isNearToStartX, isNearToThirdPoint;
    var isNearToEndX, isNearToFourthPoint;
    var indexToEditMitral = 0;

	function resetHandeler()
	{
		isNearToStartPoint = undefined;
		isNearToEndPoint = undefined;
        isNearToStartX = undefined;
        isNearToEndX = undefined;

        isNearToFirstPoint = undefined;
        isNearToSecondPoint = undefined;
        isNearToThirdPoint = undefined;
        isNearToFourthPoint = undefined;
        indexToEditMitral = 0;
	}
    function updateMeasurements(dataToedit, imageRenderer, mosueData, context) {
		removeTempdata();
        if (imageRenderer === undefined) {
            throw "addMeasurements : imageRenderer is null/undefined";
        }

        var measurement = dicomImageMeasurements[dataToedit.key];
        if (measurement === undefined) {
            return;
        }

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToedit);
		measurement = measurement[dataToedit.arryIndex];
		var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
		if(measurement.measureType === "line")
		{
			if(isNearToStartPoint == undefined)
			{
			 isNearToStartPoint = findNearHanleByPoint(imageData.end, measurement.start);
			}
			else if(isNearToEndPoint == undefined)
			{
             isNearToEndPoint = findNearHanleByPoint(imageData.end, measurement.end);
			}
			if(isNearToStartPoint)
			{
			measurement.start.x = imageData.end.x;
			measurement.start.y = imageData.end.y;
			}
			else if(isNearToEndPoint)
			{
			measurement.end.x = imageData.end.x;
			measurement.end.y = imageData.end.y;
			}
			dicomImageMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
		}else
		{
        mosueData = undefined; // Release the memory for the data
		if(measurement.measurementId === imageData.measurementId)
		{
        	measurement = imageData;
		}else
		{
			measurement.end = imageData.end;
			measurement.start = imageData.start;
		}
        dicomImageMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
		}
    }

    function getMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMeasurements : frameIndex is null/undefined";
        }		
        return dicomImageMeasurements[imageUid + "_" + frameIndex];
    }
    // Angle measurement
    function getAngleMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMeasurements : frameIndex is null/undefined";
        }
        return dicomImageAngleMeasurements[imageUid + "_" + frameIndex];
    }
    
    function resetAngleEditMode(imageUid, frameIndex, dataToEdit) {
        if (imageUid === undefined) {
            throw "resetAngleEditMode: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "resetAngleEditMode : frameIndex is null/undefined";
        }
        var angleMeasurement = dicomImageAngleMeasurements[imageUid + "_" + frameIndex];
        if (angleMeasurement === undefined) {
            throw "resetAngleEditMode : angleMeasurement is null/undefined";
        }
        var measurementData = angleMeasurement[dataToEdit.arryIndex];
        for(i=0; i<measurementData.length; i++) {
            measurementData[i].editMode = false;
        }
        angleMeasurement[dataToEdit.arryIndex] = measurementData;
        dicomImageAngleMeasurements[imageUid + "_" + frameIndex] = angleMeasurement;
    }

    function addAngleMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addAngleMeasurements : imageRenderer is null/undefined";
        }

        var angleMeasurements = dicomImageAngleMeasurements[imageUid + "_" + frameIndex];

        if (angleMeasurements === undefined) {
            angleMeasurements = [];
        }
        var measurements = angleMeasurements[mosueData.measurementId];
        if (measurements === undefined) {
            measurements = [];
        }
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        imageData.textPosition = mosueData.textPosition;
        var measureLength = measurements.length;
        measurements[measureLength] = imageData;
        if (measureLength == 1) {
            measurements[0].editMode = false;
            measurements[1].editMode = false;
        }

        angleMeasurements[mosueData.measurementId] = measurements;
        dicomImageAngleMeasurements[imageUid + "_" + frameIndex] = angleMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }
    
    function addTraceMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addTraceMeasurements : imageRenderer is null/undefined";
        }

        var tarceMeasurements = dicomImageTraceMeasurements[imageUid + "_" + frameIndex];

        if (tarceMeasurements === undefined) {
            tarceMeasurements = [];
        }
        var measurements = tarceMeasurements[mosueData.measurementId];
        if (measurements === undefined) {
            measurements = [];
        }
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        imageData.textPosition = mosueData.textPosition;
        var measureLength = measurements.length;
        measurements[measureLength] = imageData;
        tarceMeasurements[mosueData.measurementId] = measurements;
        dicomImageTraceMeasurements[imageUid + "_" + frameIndex] = tarceMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }
    
    function getTraceMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMeasurements : frameIndex is null/undefined";
        }
        return dicomImageTraceMeasurements[imageUid + "_" + frameIndex];
    }
    function updateTraceMeasurements(dataToedit, imageRenderer, mosueData, context) {
		removeTempdata();
        if (imageRenderer === undefined) {
            throw "addMeasurements : imageRenderer is null/undefined";
        }

        var measurement = dicomImageTraceMeasurements[dataToedit.key];
        if (measurement === undefined) {
            return;
        }

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToedit);
		measurement = measurement[dataToedit.arryIndex];
		var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
		if(measurement.measureType === "line")
		{
			if(isNearToStartPoint == undefined)
			{
			 isNearToStartPoint = findNearHanleByPoint(imageData.end, measurement.start);
			}
			else if(isNearToEndPoint == undefined)
			{
             isNearToEndPoint = findNearHanleByPoint(imageData.end, measurement.end);
			}
			if(isNearToStartPoint)
			{
			measurement.start.x = imageData.end.x;
			measurement.start.y = imageData.end.y;
			}
			else if(isNearToEndPoint)
			{
			measurement.end.x = imageData.end.x;
			measurement.end.y = imageData.end.y;
			}
			dicomImageTraceMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
		}else
		{
        mosueData = undefined; // Release the memory for the data
		if(measurement.measurementId === imageData.measurementId)
		{
        	measurement = imageData;
		}else
		{
			measurement.end = imageData.end;
			measurement.start = imageData.start;
		}
        dicomImageTraceMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
		}
    }

    function resetTraceEditMode(imageUid, frameIndex, dataToEdit) {
        if (imageUid === undefined) {
            throw "resetTraceEditMode: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "resetTraceEditMode : frameIndex is null/undefined";
        }
        var traceMeasurement = dicomImageTraceMeasurements[imageUid + "_" + frameIndex];
        if (traceMeasurement === undefined) {
            throw "resetTraceEditMode : traceMeasurement is null/undefined";
        }

        var measurementIndex;
        if (dataToEdit == undefined) {
            measurementIndex = traceMeasurement.length - 1;
        } else {
            measurementIndex = dataToEdit.arryIndex;
        }
        var measurementData = traceMeasurement[measurementIndex];
        for(i=0; i<measurementData.length; i++) {
            measurementData[i].editMode = false;
        }
        traceMeasurement[measurementIndex] = measurementData;
        dicomImageTraceMeasurements[imageUid + "_" + frameIndex] = traceMeasurement;
    }

    function addEllipseMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context, measurementResult) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addTraceMeasurements : imageRenderer is null/undefined";
        }

        var ellipseMeasurements = dicomImageEllipseMeasurements[imageUid + "_" + frameIndex];

        if (ellipseMeasurements === undefined) {
            ellipseMeasurements = [];
        }

        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context); 
        imageData.textPosition = mosueData.textPosition;
        var measureLength = ellipseMeasurements.length;
        ellipseMeasurements[measureLength] = imageData;
        ellipseMeasurements[measureLength].measurementResult = measurementResult;
        ellipseMeasurements[measureLength].editMode = false;
        dicomImageEllipseMeasurements[imageUid + "_" + frameIndex] = ellipseMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }
    
    function resetEllipseEditMode(imageUid, frameIndex, dataToEdit) {
        if (imageUid === undefined) {
            throw "resetEditMode: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "resetEditMode : frameIndex is null/undefined";
        }
        var measurementData = dicomImageEllipseMeasurements[imageUid + "_" + frameIndex];
        if (measurementData === undefined) {
            throw "resetEllipseEditMode : measurementData is null/undefined";
        }

        measurementData[dataToEdit.arryIndex].editMode = false;
        dicomImageEllipseMeasurements[imageUid + "_" + frameIndex] = measurementData;
    }
    
    function getEllipseMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMeasurements : frameIndex is null/undefined";
        }
        return dicomImageEllipseMeasurements[imageUid + "_" + frameIndex];
    }
    function updateEllipseMeasurements(dataToedit, imageRenderer, mosueData, context) {
		removeTempdata();
        if (imageRenderer === undefined) {
            throw "addMeasurements : imageRenderer is null/undefined";
        }

        var measurement = dicomImageEllipseMeasurements[dataToedit.key];
        if (measurement === undefined) {
            return;
        }

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToedit);
		measurement = measurement[dataToedit.arryIndex];
		var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        if(measurement.measureType === "ellipse")
		{
            if (isNearToFirstPoint == undefined) {
                isNearToFirstPoint = findNearHanleByPoint(imageData.end, measurement.first);
            } if (isNearToSecondPoint == undefined) {
                isNearToSecondPoint = findNearHanleByPoint(imageData.end, measurement.second);
            } if (isNearToThirdPoint == undefined) {
                isNearToThirdPoint = findNearHanleByPoint(imageData.end, measurement.third);
            } if (isNearToFourthPoint == undefined) {
                isNearToFourthPoint = findNearHanleByPoint(imageData.end, measurement.fourth);
            }

            if (isNearToFirstPoint) {
                if(!validateEllipseMovement(1, imageData, measurement)) {
                    return;
                }
                var startAngle = findAngle(1, measurement);
                measurement.start.x = imageData.end.x;
                measurement.start.y = imageData.end.y;
                measurement.first.x = imageData.end.x;
                measurement.first.y = imageData.end.y;
                adjustQuadrantsOfEllipse(1, measurement, startAngle);
                isNearToSecondPoint = undefined;
                isNearToThirdPoint = undefined;
                isNearToFourthPoint = undefined;
             } else if (isNearToSecondPoint) {
                if(!validateEllipseMovement(2, imageData, measurement)) {
                    return;
                }
                var startAngle = findAngle(2, measurement);
                measurement.end.x = imageData.end.x;
                measurement.end.y = imageData.end.y;
                measurement.second.x = imageData.end.x;
                measurement.second.y = imageData.end.y;
                adjustQuadrantsOfEllipse(2, measurement, startAngle);
                isNearToFirstPoint = undefined;
                isNearToThirdPoint = undefined;
                isNearToFourthPoint = undefined;
             } else if (isNearToThirdPoint) {
                if(!validateEllipseMovement(3, imageData, measurement)) {
                    return;
                }
                var startAngle = findAngle(3, measurement);
                measurement.third.x = imageData.end.x;
                measurement.third.y = imageData.end.y;
                adjustQuadrantsOfEllipse(3, measurement, startAngle);
                measurement.start = measurement.first;
                measurement.end = measurement.second;
                isNearToFirstPoint = undefined;
                isNearToSecondPoint = undefined;
                isNearToFourthPoint = undefined;
             } else if (isNearToFourthPoint) {
                if(!validateEllipseMovement(4, imageData, measurement)) {
                    return;
                }
                var startAngle = findAngle(4, measurement);
                measurement.fourth.x = imageData.end.x;
                measurement.fourth.y = imageData.end.y;
                adjustQuadrantsOfEllipse(4, measurement, startAngle);
                measurement.start = measurement.first;
                measurement.end = measurement.second;
                isNearToFirstPoint = undefined;
                isNearToSecondPoint = undefined;
                isNearToThirdPoint = undefined;
             } else {
                isNearToFirstPoint = undefined;
                isNearToSecondPoint = undefined;
                isNearToThirdPoint = undefined;
                isNearToFourthPoint = undefined;
            }

            measurement.editMode = true;
			dicomImageEllipseMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
		}else
		{
        mosueData = undefined; // Release the memory for the data
		if(measurement.measurementId === imageData.measurementId)
		{
        	measurement = imageData;
		}else
		{
			measurement.end = imageData.end;
			measurement.start = imageData.start;
            measurement.second = imageData.second;
            measurement.first = imageData.first;

		}
        dicomImageEllipseMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
		}
    }
    
    /**
     * Returns false if distance is less than minimum.
     * @param {Type} nearToPoint 
     * @param {Type} imageData 
     * @param {Type} measurement 
     */ 
    function validateEllipseMovement(nearToPoint, imageData, measurement) {
        var tempData = {
            start : measurement.center,
            end : imageData.end
        };
        var dist2Center = findQuadrantsDistance(nearToPoint, measurement, measurement.center);
        var distance = parseFloat(getLength(tempData), 2);
        if (distance < 50 && distance != dist2Center) {
            return false;
        }
        var totalDist = findQuadrantsDistance(nearToPoint, measurement, imageData.end);

        if ((distance + dist2Center - totalDist) > 10) {
            return false;
        }
        return true;
    }

    /**
     * 
     * @param {Type} nearToPoint 
     * @param {Type} measurement 
     * @param {Type} startAngle 
     */ 
    function adjustQuadrantsOfEllipse(nearToPoint, measurement, startAngle) {
        var cx = measurement.center.x,
            cy = measurement.center.y,
            endAngle = adjustCenterOfEllipse(nearToPoint, measurement),
            toAngle = endAngle - startAngle;
        if (nearToPoint == 1 || nearToPoint == 2) {
            applyTransform(cx, cy, measurement, 3, toAngle);
        } else if (nearToPoint == 3 || nearToPoint == 4) {
            applyTransform(cx, cy, measurement, 1, toAngle);
        }
    }

    /**
     * Apply the transform to the center of quadrant in case of rotation.
     * @param {Type} nearToPoint 
     * @param {Type} measurement 
     */ 
    function adjustCenterOfEllipse(nearToPoint, measurement) {
        var point = measurement.first;
        if (nearToPoint == 3 || nearToPoint == 4) {
            point = measurement.fourth;
        }
        var dx = point.x - measurement.center.x,
            dy = point.y - measurement.center.y,
            distance = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2)),
            angle = findAngle(nearToPoint, measurement);
        measurement.center = {
            x: point.x + Math.cos(angle) * distance,
            y: point.y + Math.sin(angle) * distance
        };
        return angle;
    }

    /**
     * Returns angle between two given points.
     * @param {Type} nearToPoint 
     * @param {Type} measurement 
     */ 
    function findAngle(nearToPoint, measurement) {
        var isFirstHalf = (nearToPoint == 1 || nearToPoint == 2),
            start = isFirstHalf ? measurement.start : measurement.fourth,
            end = isFirstHalf ? measurement.end : measurement.third,
            dx = end.x - start.x,
            dy = end.y - start.y,
            distance = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2)),
            cosalpha = dx / distance,
            angle;
        if (dy / distance < 0)
        {
            angle = (Math.PI * 2 - Math.acos(cosalpha));
        }
        else
        {
            angle = (Math.acos(cosalpha));
        }
        return angle;
    }

    /**
     * Apply the transform to all the quadrants in case of rotation.
     * @param {Type} cx 
     * @param {Type} cy 
     * @param {Type} measurement 
     * @param {Type} applyToPoint 
     * @param {Type} toAngle 
     */ 
    function applyTransform(cx, cy, measurement, applyToPoint, toAngle) {
        var rotatedPt,
            translatedPt,
            xDiff = measurement.center.x - cx,
            yDiff = measurement.center.y - cy;
        if (applyToPoint == 3) {
            rotatedPt = rotate(cx, cy, measurement, 3, -toAngle, 0, true);
            translatedPt = {
                x: rotatedPt.x + xDiff,
                y: rotatedPt.y + yDiff
            }
            measurement.third = translatedPt;
            rotatedPt = rotate(cx, cy, measurement, 4, -toAngle, 0, true);
            translatedPt = {
                x: rotatedPt.x + xDiff,
                y: rotatedPt.y + yDiff
            }
            measurement.fourth = translatedPt;
        } else if (applyToPoint == 1) {
            rotatedPt = rotate(cx, cy, measurement, 1, -toAngle, 0, true);
            translatedPt = {
                x: rotatedPt.x + xDiff,
                y: rotatedPt.y + yDiff
            }
            measurement.first = translatedPt;
            rotatedPt = rotate(cx, cy, measurement, 2, -toAngle, 0, true);
            translatedPt = {
                x: rotatedPt.x + xDiff,
                y: rotatedPt.y + yDiff
            }
            measurement.second = translatedPt;
        }
    }

    /**
     * Rotate a point to given radians with given center point.
     * @param {Type} cx 
     * @param {Type} cy 
     * @param {Type} measurement 
     * @param {Type} toRotate 
     * @param {Type} radians 
     * @param {Type} distance 
     * @param {Type} isCenter 
     */ 
    function rotate(cx, cy, measurement, toRotate, radians, distance, isCenter) {
        var point;
        if (toRotate == 1) {
            point = {
                x: measurement.first.x,
                y: measurement.first.y
            }
        } else if (toRotate == 2) {
            point = {
                x: measurement.second.x,
                y: measurement.second.y
            }
        } else if (toRotate == 3) {
            point = {
                x: measurement.third.x,
                y: measurement.third.y
            }
        } else if (toRotate == 4) {
            point = {
                x: measurement.fourth.x,
                y: measurement.fourth.y
            }
        }
        if (isCenter) {
            var cos = Math.cos(radians),
            sin = Math.sin(radians),
            nx = (cos * (point.x - cx)) + (sin * (point.y - cy)) + cx,
            ny = (cos * (point.y - cy)) - (sin * (point.x - cx)) + cy;
            return { x: nx, y: ny };
        }
        var rotatedPoint = {
            x: point.x + Math.cos(radians) * distance,
            y: point.y + Math.sin(radians) * distance
        }
        return rotatedPoint;
    }

    /**
     * 
     * @param {Type} measurement 
     * @param {Type} endPt 
     */ 
    function findQuadrantsDistance(nearToPoint, measurement, endPt) {
        var tempData, distance;
        if (nearToPoint == 1) {
            tempData = {
                start : measurement.second,
                end : endPt
            };
        } else if (nearToPoint == 2) {
            tempData = {
                start : measurement.first,
                end : endPt
            };
        } else if (nearToPoint == 3) {
            tempData = {
                start : measurement.fourth,
                end : endPt
            };
        } else if (nearToPoint == 4) {
            tempData = {
                start : measurement.third,
                end : endPt
            };
        }
        distance = parseFloat(getLength(tempData), 2);
        return distance;
    }

    /**
     * To hold rectangle measurements and annotations
     * @param {Type} imageUid 
     * @param {Type} frameIndex 
     * @param {Type} imageRenderer 
     * @param {Type} mosueData 
     * @param {Type} context 
     * @param {Type} measurementResult 
     */ 
    function addRectangleMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context, measurementResult) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addTraceMeasurements : imageRenderer is null/undefined";
        }

        var rectangleMeasurements = dicomImageRectangleMeasurements[imageUid + "_" + frameIndex];

        if (rectangleMeasurements === undefined) {
            rectangleMeasurements = [];
        }

        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context); 
        imageData.textPosition = mosueData.textPosition;
        var measureLength = rectangleMeasurements.length;
        rectangleMeasurements[measureLength] = imageData;
        rectangleMeasurements[measureLength].measurementResult = measurementResult;
        rectangleMeasurements[measureLength].editMode = false;
        dicomImageRectangleMeasurements[imageUid + "_" + frameIndex] = rectangleMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }

    /**
     * To reset the edit mode of rectangle measurements
     * @param {Type} imageUid 
     * @param {Type} frameIndex 
     * @param {Type} dataToEdit 
     */ 
    function resetRectangleEditMode(imageUid, frameIndex, dataToEdit) {
        if (imageUid === undefined) {
            throw "resetEditMode: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "resetEditMode : frameIndex is null/undefined";
        }
        var measurementData = dicomImageRectangleMeasurements[imageUid + "_" + frameIndex];
        measurementData[dataToEdit.arryIndex].editMode = false;
        dicomImageRectangleMeasurements[imageUid + "_" + frameIndex] = measurementData;
    }

    /**
     * To get rectangle measurement from the array
     * @param {Type} imageUid 
     * @param {Type} frameIndex 
     */ 
    function getRectangleMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMeasurements : frameIndex is null/undefined";
        }
        return dicomImageRectangleMeasurements[imageUid + "_" + frameIndex];
    }

    /**
     * To update rectangle measurement data
     * @param {Type} dataToedit 
     * @param {Type} imageRenderer 
     * @param {Type} mosueData 
     * @param {Type} context 
     */ 
    function updateRectangleMeasurements(dataToedit, imageRenderer, mosueData, context) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addMeasurements : imageRenderer is null/undefined";
        }

        var measurement = dicomImageRectangleMeasurements[dataToedit.key];
        if (measurement === undefined) {
            return;
        }

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToedit);
        measurement = measurement[dataToedit.arryIndex];
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        if(measurement.measureType === "rectangle") {
            
            if (isNearToStartPoint == undefined) {
                isNearToStartPoint = findNearHanleByPoint(imageData.end, measurement.start);
            } if (isNearToEndPoint == undefined) {
                isNearToEndPoint = findNearHanleByPoint(imageData.end, measurement.end);
            } if (isNearToStartX == undefined) {
                isNearToStartX = isHandleNearByX(imageData.end, measurement.start);
            } if (isNearToEndX == undefined) {
                isNearToEndX = isHandleNearByX(imageData.end, measurement.end);
            }
            
            if (isNearToStartPoint) {
                measurement.start.x = imageData.end.x;
                measurement.start.y = imageData.end.y;
                isNearToEndPoint = undefined;
                isNearToStartX = undefined;
                isNearToEndX = undefined;
             } else if (isNearToEndPoint) {
                measurement.end.x = imageData.end.x;
                measurement.end.y = imageData.end.y;
                isNearToStartPoint = undefined;
                isNearToStartX = undefined;
                isNearToEndX = undefined;
             } else if (isNearToStartX) {
                measurement.start.x = imageData.end.x;
                measurement.end.y = imageData.end.y;
                isNearToStartPoint = undefined;
                isNearToEndPoint = undefined;
                isNearToEndX = undefined;
             } else if (isNearToEndX) {
                measurement.start.y = imageData.end.y;
                measurement.end.x = imageData.end.x;
                isNearToStartPoint = undefined;
                isNearToEndPoint = undefined;
                isNearToStartX = undefined;
             } else {
                isNearToStartPoint = undefined;
                isNearToEndPoint = undefined;
                isNearToStartX = undefined;
                isNearToEndX = undefined;
            }
            
            measurement.editMode = true;
            dicomImageRectangleMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
        } else {
            mosueData = undefined; // Release the memory for the data
            if(measurement.measurementId === imageData.measurementId) {
                measurement = imageData;
            } else {
                measurement.end = imageData.end;
                measurement.start = imageData.start;
            }
            dicomImageRectangleMeasurements[dataToedit.key][dataToedit.arryIndex] = measurement;
        }
    }

    /**
     * To check if the mouse point is near by rectangle measurement corners
     * @param {Type} mouseData 
     * @param {Type} point 
     */ 
    function isHandleNearByX(mouseData, point) {
        if (point.x - 2 <= mouseData.x &&
            point.x + 2 >= mouseData.x) {
            return true;
        }
        return false;
    }

    function addVolumeMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addVolumeMeasurements : imageRenderer is null/undefined";
        }

        var volumeMeasurements = dicomImageVolumeMeasurements[imageUid + "_" + frameIndex];

        if (volumeMeasurements === undefined) {
            volumeMeasurements = [];
        }
        var measurements = volumeMeasurements[mosueData.measurementId];
        if (measurements === undefined) {
            measurements = [];
        }
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        measurements[measurements.length] = imageData;
        volumeMeasurements[mosueData.measurementId] = measurements;
        dicomImageVolumeMeasurements[imageUid + "_" + frameIndex] = volumeMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

    }
   
    function getVolumeMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMeasurements : frameIndex is null/undefined";
        }
        return dicomImageVolumeMeasurements[imageUid + "_" + frameIndex];
    }

    function removeMeasurement(imageUid, frameIndex) {

    }

    function addMitralGradientMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addMitralGradientMeasurements : imageRenderer is null/undefined";
        }

        var mitralMeasurements = dicomImageMitralGradientMeasurements[imageUid + "_" + frameIndex];

        if (mitralMeasurements === undefined) {
            mitralMeasurements = [];
        }
        var measurements = mitralMeasurements[mosueData.measurementIndex];
        if (measurements === undefined) {
            measurements = [];
        }
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        imageData.textPosition = mosueData.textPosition;
        var measureLength = measurements.length;
        measurements[measureLength] = imageData;
        if (!mitralMeanGradientMeasurementEnd) {
            for (i = 0; i < measureLength; i++) {
                measurements[i].editMode = false;
            }
        }
        mitralMeasurements[mosueData.measurementIndex] = measurements;
        dicomImageMitralGradientMeasurements[imageUid + "_" + frameIndex] = mitralMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }

    function resetMitralEditMode(imageUid, frameIndex, dataToEdit) {
        if (imageUid === undefined) {
            throw "resetMitralEditMode: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "resetMitralEditMode : frameIndex is null/undefined";
        }
        var mitralMeasurement = dicomImageMitralGradientMeasurements[imageUid + "_" + frameIndex];
        if (mitralMeasurement === undefined) {
            throw "resetMitralEditMode : mitralMeasurement is null/undefined";
        }

        var measurementIndex;
        if (dataToEdit == undefined) {
            measurementIndex = mitralMeasurement.length - 1;
        } else {
            measurementIndex = dataToEdit.arryIndex;
        }
        var measurementData = mitralMeasurement[measurementIndex];
        if(measurementData == undefined){
            return;
        }

        for(i=0; i<measurementData.length; i++) {
            measurementData[i].editMode = false;
        }
        mitralMeasurement[measurementIndex] = measurementData;
        dicomImageMitralGradientMeasurements[imageUid + "_" + frameIndex] = mitralMeasurement;
    }

    function getMitralGradientMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMitralGradientMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMitralGradientMeasurements : frameIndex is null/undefined";
        }
        return dicomImageMitralGradientMeasurements[imageUid + "_" + frameIndex];
    }
    
    function getLength(data) {
        var dx = (data.start.x - data.end.x);
        var dy = (data.start.y - data.end.y);
        var lengthInPixels = Math.sqrt(dx * dx + dy * dy);

        return lengthInPixels.toFixed(2);
    }

    function getMousePos(canvas, pointX, pointY) {
        var rect = canvas.getBoundingClientRect();
        return {
            x: pointX - rect.left,
            y: pointY - rect.top
        };
    }

    function findTraceToDelete(mouseData, imageRenderer) {
        isTraceDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*","_");
//        loop: for (var i in dicomImageTraceMeasurements) {
  //          if (dicomImageTraceMeasurements.hasOwnProperty(i)) {
                var tarceMeasurements = dicomImageTraceMeasurements[measurementKey];
                if (tarceMeasurements !== undefined) {
                    for (var n = 0; n < tarceMeasurements.length; n++) {
                        if (activeImageRenderer === undefined) {
                            var measurements = tarceMeasurements[n];
                            if (measurements !== undefined) {
                                for (var m = 0; m < measurements.length; m++) {
                                    var data = measurements[m];
                                    if (data !== undefined && data.measureType == "trace") {
                                        var originalLineDistance = getLength(data);

                                        var tempData = {
                                            start: {
                                                x: data.start.x,
                                                y: data.start.y
                                            },
                                            end: {
                                                x: mouseData.x,
                                                y: mouseData.y
                                            },
                                            measureType: "line"
                                        };
                                        var firstDistance = getLength(tempData);

                                        var tempData2 = {
                                            start: {
                                                x: mouseData.x,
                                                y: mouseData.y
                                            },
                                            end: {
                                                x: data.end.x,
                                                y: data.end.y
                                            },
                                            measureType: "line"
                                        };

                                        var secondDistance = getLength(tempData2);

                                        var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                                        if (Math.abs(totalDistance - originalLineDistance) < 5) {
                                            dataToDelete.measurmentType = "Trace";
                                            dataToDelete.key = measurementKey;
                                            dataToDelete.arryIndex = n;
                                            dataToDelete.isEditable = data.isEditable;
                                            dataToDelete.sessionType = data.sessionType;
                                            activeImageRenderer = imageRenderer;
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
          //  }
        //}

        if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isAngleDeleteCheck === false) {
            findAngleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function findVolumeToDelete(mouseData, imageRenderer) {
        isVolumeDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*","_");
        //loop: for (var i in dicomImageVolumeMeasurements) {
          //  if (dicomImageVolumeMeasurements.hasOwnProperty(i)) {
                var volumeMeasurements = dicomImageVolumeMeasurements[measurementKey];
                if (volumeMeasurements !== undefined) {
                    for (var n = 0; n < volumeMeasurements.length; n++) {
                        var measurements = volumeMeasurements[n];
                        if (measurements !== undefined) {
                            for (var m = 0; m < measurements.length; m++) {
                                var data = measurements[m];
                                if (data !== undefined && data.measureType == "volume") {
                                    var originalLineDistance = getLength(data);

                                    var tempData = {
                                        start: {
                                            x: data.start.x,
                                            y: data.start.y
                                        },
                                        end: {
                                            x: mouseData.x,
                                            y: mouseData.y
                                        },
                                        measureType: "line"
                                    };
                                    var firstDistance = getLength(tempData);

                                    var tempData2 = {
                                        start: {
                                            x: mouseData.x,
                                            y: mouseData.y
                                        },
                                        end: {
                                            x: data.end.x,
                                            y: data.end.y
                                        },
                                        measureType: "line"
                                    };

                                    var secondDistance = getLength(tempData2);

                                    var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                                    if (Math.abs(totalDistance - originalLineDistance) < 5 || (originalLineDistance < 5 && originalLineDistance > 0)) {
                                        dataToDelete.measurmentType = "volume";
                                        dataToDelete.key = measurementKey;
                                        dataToDelete.arryIndex = n;
                                        dataToDelete.isEditable = data.isEditable;
                                        dataToDelete.sessionType = data.sessionType;
                                        activeImageRenderer = imageRenderer;
                                        return;

                                    }
                                }
                            }
                        }
                    }
                }
           // }
       // }
        if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isAngleDeleteCheck === false) {
            findAngleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function findMitralToDelete(mouseData, imageRenderer){
        isMitralGradineDelete = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*","_");
        //loop: for (var i in dicomImageVolumeMeasurements) {
          //  if (dicomImageVolumeMeasurements.hasOwnProperty(i)) {
                var volumeMeasurements = dicomImageMitralGradientMeasurements[measurementKey];
                if (volumeMeasurements !== undefined) {
                    for (var n = 0; n < volumeMeasurements.length; n++) {
                        var measurements = volumeMeasurements[n];
                        if (measurements !== undefined) {
                            for (var m = 0; m < measurements.length; m++) {
                                var data = measurements[m];
                                if (data !== undefined && data.measureType == "mitralGradient") {
                                    var originalLineDistance = getLength(data);

                                    var tempData = {
                                        start: {
                                            x: data.start.x,
                                            y: data.start.y
                                        },
                                        end: {
                                            x: mouseData.x,
                                            y: mouseData.y
                                        },
                                        measureType: "mitralGradient"
                                    };
                                    var firstDistance = getLength(tempData);

                                    var tempData2 = {
                                        start: {
                                            x: mouseData.x,
                                            y: mouseData.y
                                        },
                                        end: {
                                            x: data.end.x,
                                            y: data.end.y
                                        },
                                        measureType: "mitralGradient"
                                    };

                                    var secondDistance = getLength(tempData2);

                                    var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                                    if (Math.abs(totalDistance - originalLineDistance) < 5) {
                                        dataToDelete.measurmentType = "mitralGradient";
                                        dataToDelete.key = measurementKey;
                                        dataToDelete.arryIndex = n;
                                        dataToDelete.isEditable = data.isEditable;
                                        dataToDelete.sessionType = data.sessionType;
                                        activeImageRenderer = imageRenderer;
                                        return;

                                    }
                                }
                            }
                        }
                    }
                }
           // }
       // }
        if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isAngleDeleteCheck === false) {
            findAngleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function deleteSelectedMeasurment() {
        if (activeImageRenderer != undefined) {
            var key = dataToDelete.key;
            var arrayIndex = dataToDelete.arryIndex;			
            var measurementType = dataToDelete.measurmentType;
            if(measurementType === "mitralGradient") {
                delete dicomImageMitralGradientMeasurements[key][arrayIndex];
            }
            else if (measurementType === "Trace") {
                delete dicomImageTraceMeasurements[key][arrayIndex];
            } else if (measurementType === "volume") {
                delete dicomImageVolumeMeasurements[key][arrayIndex];
            } else if (measurementType === "line" || measurementType === "point") {
				delete dicomImageMeasurements[key][arrayIndex];
            } else if (measurementType === "angle") {
				delete dicomImageAngleMeasurements[key][arrayIndex];
            } else if (measurementType === "ellipse") {
				delete dicomImageEllipseMeasurements[key][arrayIndex];
            } else if (measurementType === "rectangle") {
                delete dicomImageRectangleMeasurements[key][arrayIndex];
            } else if (measurementType === "pen") {
                delete dicomImagePenMeasurements[key][arrayIndex];
            }

            updateDirtyPState(activeImageRenderer.seriesLevelDivId, dataToDelete, true);
			dataToEdit = undefined;
            activeImageRenderer.renderImage(false);
            activeImageRenderer = undefined;
        }
    }

    function updateMeasurementTextData(dataToedit, text) {
        var measurement = dicomImageRectangleMeasurements[dataToedit.key];
        if (measurement === undefined) {
            return;
        }
        dicomImageRectangleMeasurements[dataToedit.key][dataToedit.arryIndex].measurementText = text;
    }

    function findLineToDelete(mouseData, imageRenderer) {
        var flagFor2dLengthCalibration = dicomViewer.tools.getFlagFor2dLengthCalibration();
        isLineDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*", "_");
     //   loop: for (var i in dicomImageMeasurements) {
        //    if (dicomImageMeasurements.hasOwnProperty(i)) {
                var measurements = dicomImageMeasurements[measurementKey];
                if (measurements !== undefined) {
                    for (var m = 0; m < measurements.length; m++) {
                        var data = measurements[m];
                        if (data !== undefined && data.measureType == "line") {
                            var originalLineDistance = getLength(data);

                            var tempData = {
                                start: {
                                    x: data.start.x,
                                    y: data.start.y
                                },
                                end: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                measureType: "line"
                            };
                            var firstDistance = getLength(tempData);

                            var tempData2 = {
                                start: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                end: {
                                    x: data.end.x,
                                    y: data.end.y
                                },
                                measureType: "line"
                            };

                            var secondDistance = getLength(tempData2);

                            var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                            if (Math.abs(totalDistance - originalLineDistance) < 5 /*|| originalLineDistance < 5*/ ) {
                                //delete dicomImageMeasurements[i][m];
                                dataToDelete.measurmentType = "line";
                                dataToDelete.key = measurementKey;
                                dataToDelete.arryIndex = m;
                                dataToDelete.isEditable = data.isEditable;
                                dataToDelete.sessionType = data.sessionType;
                                activeImageRenderer = imageRenderer;
                                return;
                            }
                        }
                    }
                }
                if(flagFor2dLengthCalibration) {
                    dataToDelete.measurmentType = "line";
                    dataToDelete.key = measurementKey;
                    dataToDelete.arryIndex = m;
                    activeImageRenderer = imageRenderer;
                    setDataToDelete();
                    return;
                }
           // }
        //}
        if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function findPointToDelete(mouseData, imageRenderer) {
        isPointDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*","_");
       // loop: for (var i in dicomImageMeasurements) {
      //      if (dicomImageMeasurements.hasOwnProperty(i)) {
                var measurements = dicomImageMeasurements[measurementKey];
                if (measurements !== undefined) {
                    for (var m = 0; m < measurements.length; m++) {
                        var data = measurements[m];
                        if (data !== undefined && data.measureType == "point") {
                            if (Math.abs(data.end.x - mouseData.x) < 5 && Math.abs(data.end.y - mouseData.y) < 5) {
                                dataToDelete.measurmentType = "point";
                                dataToDelete.key = measurementKey;
                                dataToDelete.arryIndex = m;
                                dataToDelete.isEditable = data.isEditable;
                                dataToDelete.sessionType = data.sessionType;
                                activeImageRenderer = imageRenderer;
                                return;
                            }
                        }
                    }
                }
    //        }
    //    }
       if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isAngleDeleteCheck === false) {
            findAngleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function findEllipseToDelete(mouseData, imageRenderer) {
        isEllipseDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*", "_");
     //   loop: for (var i in dicomImageMeasurements) {
        //    if (dicomImageMeasurements.hasOwnProperty(i)) {
                var measurements = dicomImageEllipseMeasurements[measurementKey];
                if (measurements !== undefined) {
                    for (var m = 0; m < measurements.length; m++) {
                        var data = measurements[m];
                        if (data !== undefined && data.measureType == "ellipse") {
                            var originalLineDistance = getLength(data);

                            var tempData1 = {
                                start: {
                                    x: data.first.x,
                                    y: data.first.y
                                },
                                end: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                measureType: "ellipse"
                            };
                            var firstDistance = getLength(tempData1);

                            var tempData2 = {
                                start: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                end: {
                                    x: data.second.x,
                                    y: data.second.y
                                },
                                measureType: "ellipse"
                            };

                            var secondDistance = getLength(tempData2);

                            var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                            var isEditable = false;
                            if (Math.abs(totalDistance - originalLineDistance) < 15) {
                                isEditable = true;
                            } else {
                                var tempData = {
                                    start: {
                                        x: data.third.x,
                                        y: data.third.y
                                    },
                                    end: {
                                        x: data.fourth.x,
                                        y: data.fourth.y
                                    },
                                    measureType: "ellipse"
                                };
                                var secondLineDistance = getLength(tempData);

                                var tempData3 = {
                                    start: {
                                        x: data.third.x,
                                        y: data.third.y
                                    },
                                    end: {
                                        x: mouseData.x,
                                        y: mouseData.y
                                    },
                                    measureType: "ellipse"
                                };
                                var thirdDistance = getLength(tempData3);

                                var tempData4 = {
                                    start: {
                                        x: mouseData.x,
                                        y: mouseData.y
                                    },
                                    end: {
                                        x: data.fourth.x,
                                        y: data.fourth.y
                                    },
                                    measureType: "ellipse"
                                };

                                var fourthDistance = getLength(tempData4);

                                totalDistance = parseInt(thirdDistance) + parseInt(fourthDistance);
                                if (Math.abs(totalDistance - secondLineDistance) < 15) {
                                    isEditable = true;
                                }
                            }

                            if (isEditable) {
                                //delete dicomImageMeasurements[i][m];
                                dataToDelete.measurmentType = "ellipse";
                                dataToDelete.key = measurementKey;
                                dataToDelete.arryIndex = m;
                                dataToDelete.isEditable = data.isEditable;
                                dataToDelete.sessionType = data.sessionType;
                                activeImageRenderer = imageRenderer;
                                return;
                            }
                        }
                    }
                }
           // }
        //}
        if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function findRectangleToDelete(mouseData, imageRenderer) {
        isRectangleDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*", "_");
     //   loop: for (var i in dicomImageMeasurements) {
        //    if (dicomImageMeasurements.hasOwnProperty(i)) {
                var measurements = dicomImageRectangleMeasurements[measurementKey];
                if (measurements !== undefined) {
                    for (var m = 0; m < measurements.length; m++) {
                        var data = measurements[m];
                        if (data !== undefined && data.measureType == "rectangle") {
                            var originalLineDistance = getLength(data);

                            var tempData = {
                                start: {
                                    x: data.start.x,
                                    y: data.start.y
                                },
                                end: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                measureType: "rectangle"
                            };
                            var firstDistance = getLength(tempData);

                            var tempData2 = {
                                start: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                end: {
                                    x: data.end.x,
                                    y: data.end.y
                                },
                                measureType: "rectangle"
                            };

                            var secondDistance = getLength(tempData2);
                            
                            var tempData3 = {
                                start: {
                                    x: data.start.x,
                                    y: data.end.y
                                },
                                end: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                measureType: "rectangle"
                            };

                            var thirdDistance = getLength(tempData3);
                            
                            var tempData4 = {
                                start: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                end: {
                                    x: data.end.x,
                                    y: data.start.y
                                },
                                measureType: "rectangle"
                            };

                            var fourthDistance = getLength(tempData4);

                            var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                            var totalDistance1 = parseInt(thirdDistance) + parseInt(fourthDistance);
                            if (Math.abs(totalDistance - originalLineDistance) < 15 || Math.abs(totalDistance1 - originalLineDistance) < 15) {
                                //delete dicomImageMeasurements[i][m];
                                dataToDelete.measurmentType = "rectangle";
                                dataToDelete.key = measurementKey;
                                dataToDelete.arryIndex = m;
                                dataToDelete.isEditable = data.isEditable;
                                dataToDelete.sessionType = data.sessionType;
                                activeImageRenderer = imageRenderer;
                                return;
                            }
                        }
                    }
                }
           // }
        //}
        if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }
    
    function PointInRect(x, y) {
        return this.x <= x && x <= this.x + this.width &&
               this.y <= y && y <= this.y + this.height;
    }

    function findAngleToDelete(mouseData, imageRenderer) {
        isAngleDeleteCheck = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*","_");
        var tarceMeasurements = dicomImageAngleMeasurements[measurementKey];
        if (tarceMeasurements !== undefined) {
            for (var n = 0; n < tarceMeasurements.length; n++) {
                if (activeImageRenderer === undefined) {
                    var measurements = tarceMeasurements[n];
                    if (measurements !== undefined) {
                        for (var m = 0; m < measurements.length; m++) {
                            var data = measurements[m];
                            if (data !== undefined && data.measureType == "angle") {
                                var originalLineDistance = getLength(data);

                                var tempData = {
                                    start: {
                                        x: data.start.x,
                                        y: data.start.y
                                    },
                                    end: {
                                        x: mouseData.x,
                                        y: mouseData.y
                                    },
                                    measureType: "line"
                                };
                                var firstDistance = getLength(tempData);

                                var tempData2 = {
                                    start: {
                                        x: mouseData.x,
                                        y: mouseData.y
                                    },
                                    end: {
                                        x: data.end.x,
                                        y: data.end.y
                                    },
                                    measureType: "line"
                                };

                                var secondDistance = getLength(tempData2);

                                var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                                if (Math.abs(totalDistance - originalLineDistance) < 5) {
                                    dataToDelete.measurmentType = "angle";
                                    dataToDelete.key = measurementKey;
                                    dataToDelete.arryIndex = n;
                                    dataToDelete.isEditable = data.isEditable;
                                    dataToDelete.sessionType = data.sessionType;
                                    activeImageRenderer = imageRenderer;
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer);
        } else if (activeImageRenderer === undefined && isMitralGradineDelete === false) {
            findMitralToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    function resetMeasurementFlag() {
        isLineDeleteCheck = false;
        isPointDeleteCheck = false;
        isAngleDeleteCheck = false;
        isEllipseDeleteCheck = false;
        isRectangleDeleteCheck = false;
        isTraceDeleteCheck = false;
        isVolumeDeleteCheck = false;
        isMitralGradineDelete = false;
        isPenToolEnd = false;
    }

    function findNearHandle(mouseData, imageRenderer, context) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        loop: for (i in dicomImageMeasurements) {
            if (dicomImageMeasurements.hasOwnProperty(i)) {
                var measurements = dicomImageMeasurements[i];
                if (measurements !== undefined) {
                    for (var m = 0; m < measurements.length; m++) {
                        data = measurements[m];
                        if (data !== undefined) {
                            var isNearToStartPoint = findNearHanleByPoint(imageData, data.start);
                            var isNearToEndPoint = findNearHanleByPoint(imageData, data.end);
                            if (isNearToStartPoint) {
                                data.start.handleActive = true;
                                measurements.splice(m, 1);
                                break loop;
                            } else if (isNearToEndPoint) {
                                data.end.handleActive = true;
                                measurements.splice(m, 1);
                                break loop;
                            } else {
                                data = undefined;
                            }
                        }
                    }
                }
            }
        }
        if (data !== undefined) {
            return getMouseDataForImageData(data, imageRenderer, context);
        }
        return undefined;
    }


    function findNearHandleToEdit(mouseData, imageRenderer, context, dataToEdit) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
		var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
        var measurements = dicomImageMeasurements[key];
		if(measurements === undefined)
			return;
		measurements = measurements[arrayIndex];
        data = dicomImageMeasurements[key][arrayIndex];
        if (data !== undefined) {
            var isNearToStartPoint = findNearHanleByPoint(imageData, data.start);
            var isNearToEndPoint = findNearHanleByPoint(imageData, data.end);
            if (isNearToStartPoint) {
                data.start.handleActive = true;
                data.start.x = imageData.x;
                data.start.y = imageData.y;
            } else if (isNearToEndPoint) {
                data.end.handleActive = true;
                data.end.x = imageData.x;
                data.end.y = imageData.y;
            } else {
                data = undefined;
            }

        }
        if (data !== undefined) {
            return getMouseDataForImageData(data, imageRenderer, context);
        }
        return undefined;
    }

    function updateVolumeintoArray(mouseData, imageRenderer, context, dataToEdit) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
		var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
        var measurements = dicomImageVolumeMeasurements[key];

		if(measurements === undefined)
			return;
		measurements = measurements[arrayIndex];
        data = dicomImageVolumeMeasurements[key][arrayIndex];
        for (var index = 0; index < data.length; index++) {
           var tempData = data[index];
            if (tempData !== undefined) {
                var isNearToStartPoint = findNearHanleByPoint(imageData, tempData.start);
                var isNearToEndPoint = findNearHanleByPoint(imageData, tempData.end);
                if ((data.length -1) === index) {
                    if (isNearToEndPoint) {
                        tempData.start.x = imageData.x;
                        tempData.start.y = imageData.y;
                        tempData.end.x = imageData.x;
                        tempData.end.y = imageData.y;
                    }
                } else {
                    if (isNearToStartPoint) {
                        tempData.start.x = imageData.x;
                        tempData.start.y = imageData.y;
                    } else if (isNearToEndPoint) {
                        tempData.end.x = imageData.x;
                        tempData.end.y = imageData.y;
                    }
                }
            }
        }
    }
    
	function updateTraceIntoArray(mouseData, imageRenderer, context, dataToEdit) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
		var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
        var measurements = dicomImageTraceMeasurements[key];

		if(measurements === undefined)
			return;
        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToEdit);
		measurements = measurements[arrayIndex];
        data = dicomImageTraceMeasurements[key][arrayIndex];
        for (var index = indexToEditMitral; index < data.length; index++) {
           var tempData = data[index];
            if (tempData !== undefined) {
                var isNearToStartPoint = findNearHanleByPoint(imageData, tempData.start);
                if (isNearToStartPoint && index == 0) {
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    indexToEditMitral = index;
                    index = data.length;
                } else if (isNearToStartPoint && index == data.length - 1){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    tempData.end.x = imageData.x;
                    tempData.end.y = imageData.y;
                    data[index - 1].end.x = imageData.x;
                    data[index - 1].end.y = imageData.y;
                    dicomImageTraceMeasurements[key][arrayIndex] = data;
                    indexToEditMitral = index;
                    index = data.length;
                } else if (isNearToStartPoint){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    data[index - 1].end.x = imageData.x;
                    data[index - 1].end.y = imageData.y;
                    dicomImageTraceMeasurements[key][arrayIndex] = data;
                    indexToEditMitral = index;
                    index = data.length;
                }
            }
            tempData.editMode = true;
        }
    }
    
    function updateAngleIntoArray(mouseData, imageRenderer, context, dataToEdit) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
        var measurements = dicomImageAngleMeasurements[key];

		if(measurements === undefined)
			return;

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToEdit);
		measurements = measurements[arrayIndex];
        data = dicomImageAngleMeasurements[key][arrayIndex];
        for (var index = 0; index < data.length; index++) {
           var tempData = data[index];
            if (tempData !== undefined) {
                var isNearToStartPoint = findNearHanleByPoint(imageData, tempData.start);
                var isNearToEndPoint = findNearHanleByPoint(imageData, tempData.end);
                if (isNearToEndPoint) {
                    tempData.end.x = imageData.x;
                    tempData.end.y = imageData.y;
                }else if(isNearToStartPoint){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                }
                tempData.editMode = true;
            }
        }
    }
    
	function updateMitralMeanGradientintoArray(mouseData, imageRenderer, context, dataToEdit) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
		var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
        var measurements = dicomImageMitralGradientMeasurements[key];

		if(measurements === undefined)
			return;

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToEdit);
		measurements = measurements[arrayIndex];
        data = dicomImageMitralGradientMeasurements[key][arrayIndex];
        for (var index = indexToEditMitral; index < data.length; index++) {
           var tempData = data[index];
            if (tempData !== undefined) {
                var isNearToStartPoint = findNearHanleByPoint(imageData, tempData.start);
                if (isNearToStartPoint && index == 0) {
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    indexToEditMitral = index;
                    index = data.length;
                } else if (isNearToStartPoint && index == data.length - 1 && tempData.measurementSubType == "mitral"){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    tempData.end.x = imageData.x;
                    tempData.end.y = imageData.y;
                    data[index - 1].end.x = imageData.x;
                    data[index - 1].end.y = imageData.y;
                    dicomImageMitralGradientMeasurements[key][arrayIndex] = data;
                    indexToEditMitral = index;
                    index = data.length;
                } else if (isNearToStartPoint){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    data[index - 1].end.x = imageData.x;
                    data[index - 1].end.y = imageData.y;
                    dicomImageMitralGradientMeasurements[key][arrayIndex] = data;
                    indexToEditMitral = index;
                    index = data.length;
                }
            }
            tempData.editMode = true;
        }
    }
	
    function findNearHanleByPoint(mouseData, point) {
        if (point.x - 10 <= mouseData.x &&
            point.x + 10 >= mouseData.x &&
            point.y - 10 <= mouseData.y &&
            point.y + 10 >= mouseData.y) {
            return true;
        }
        return false;
    }   
    

    function getMouseDataForImageData(imageData, imageRenderer, context) {
        var startPoint = dicomViewer.measurement.draw.getMousePointForImageCoordinates(imageData.start, imageRenderer, context);
        var endPoint = dicomViewer.measurement.draw.getMousePointForImageCoordinates(imageData.end, imageRenderer, context);
        var mouseData = {};
        mouseData.start = startPoint;
        mouseData.end = endPoint;
        mouseData.measureType = imageData.measureType;
        return mouseData;
    }


    function removeAllMeasurements(imageUid, frameIndex, renderer) {
        if (imageUid === undefined || frameIndex === undefined) {
            throw "Error in imageUid or FrameIndex";
        }		
        delete dicomImageMeasurements[imageUid + "_" + frameIndex];
        delete dicomImageTraceMeasurements[imageUid + "_" + frameIndex];
        delete dicomImageVolumeMeasurements[imageUid + "_" + frameIndex];
        delete dicomImageMitralGradientMeasurements[imageUid + "_" + frameIndex];
        delete dicomImageAngleMeasurements[imageUid + "_" + frameIndex];
        delete dicomImageEllipseMeasurements[imageUid + "_" + frameIndex];
        delete dicomImageRectangleMeasurements[imageUid + "_" + frameIndex];
        delete dicomImagePenMeasurements[imageUid + "_" + frameIndex];
		setDataToEdit(undefined);

        if(renderer !== undefined && renderer !== null) {
            updateDirtyPState(renderer.seriesLevelDivId, { key: imageUid + "_" + frameIndex }, true);
        }
    }

    var imageContexts = {};

    function setImageContext(imageUid, frameIndex, context) {
        imageContexts[imageUid + "_" + frameIndex] = context;
    }

    function getImageContext(imageUid, frameIndex) {
        return imageContexts[imageUid + "_" + frameIndex];
    }

    function setDataToEdit(data) {
        if (activeImageRenderer != undefined && data === "edit") {
            dataToEdit = dataToDelete;
            var auids = dataToEdit.key.split("_");
			var sereiesId = $('#'+activeImageRenderer.parentElement).parent().closest('div').attr('id');
            if(isFullScreenEnabled){
                sereiesId = previousLayoutSelection;
            }
            var measurementData;
            if (dataToEdit.measurmentType === "volume") {
                measurementData = getVolumeMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData);
                measurementData.measureType = "volumeedit";
                dicomViewer.measurement.setTempData(measurementData);
            } else if (dataToEdit.measurmentType === "mitralGradient") {
                measurementData = getMitralGradientMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData[0]);
            }else if (dataToEdit.measurmentType === "Trace") {
                measurementData = getTraceMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData[0]);
            }else if (dataToEdit.measurmentType === "angle") {
                measurementData = getAngleMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData[0]);
            }else if (dataToEdit.measurmentType === "ellipse") {
                measurementData = getEllipseMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData);
            } else if (dataToEdit.measurmentType === "rectangle") {
                measurementData = getRectangleMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData);
            }else if (dataToEdit.measurmentType === "pen") {
                measurementData = getPenMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                dicomViewer.measurement.setTempData(measurementData);
            } else {
                measurementData = getMeasurements(auids[0], auids[1], sereiesId)[dataToEdit.arryIndex];
                measurementData.end.handleActive = true;
                measurementData.start.handleActive = true;
            }
            setTool(measurementData);
            activeImageRenderer.renderImage(false);
            isMeasurementEdit = true;
        }
        if (data === undefined) {
            //editing done
            isMeasurementEdit = false;
            dataToEdit = data;
        }
    }

    /**
     * Set the image tool while editing the selected shape
     * @param {Type} measurement - type of the annotation/measurement data
     */ 
    function setTool(measurement) {
        dicomViewer.mouseTools.setPreviousTool(dicomViewer.mouseTools.getActiveTool());
        dicomViewer.mouseTools.setCursor(dicomViewer.mouseTools.getToolCursor(1));
        if(measurement.measureType == "line") {
            if(measurement.measurementSubType == "2DLength") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool());
            } else if (measurement.measurementSubType == "2DLine") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(4));
            } else if(measurement.measurementSubType == "Arrow") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(5));
            } else if(measurement.measurementId == "mitralRegurgitationLength") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(1));
            } else if(measurement.measurementId == "aorticRegurgitationLength") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(2));
            } else if(measurement.measurementId == "mitralValveAnteriorLeafletThickness") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(3));
            }
            return;
        }
        if(measurement.measureType == "rectangle") {
            if(measurement.measurementSubType == "hounsfield") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getRectangleMeasureTool());
            } else if(measurement.measurementSubType == "rectangle") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getRectangleMeasureTool(1));
            } else if(measurement.measurementSubType == "text") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getRectangleMeasureTool(2));
            }
            return;
        }
        if(measurement.measureType == "ellipse") {
            if(measurement.measurementSubType == "hounsfield") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getEllipseMeasureTool());
            } else if(measurement.measurementSubType == "ellipse") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getEllipseMeasureTool(1));
            }
            return;
        }
        if(measurement.measureType == "point") {
            if(measurement.measurementId == "mitralRegurgitationPeakVelocity") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(1));
            } else if(measurement.measurementId == "aorticRegurgitationPeakVelocity") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(2));
            } else if(measurement.measurementId == "aorticStenosisPeakVelocity") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(3));
            } else {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool());
            }
            return;
        }
        if($.isArray(measurement) && measurement.length > 0) {
            if(measurement[0].measureType == "angle") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getAngleMeasureTool());
            } else if(measurement[0].measureType == "trace") {
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getTraceMeasureTool());
            }
            if(measurement[0].measureType == "mitralGradient") {
                if(measurement[0].measurementSubType == "mitral") {
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getMitralMeanGradientMeasureTool());
                } else if(measurement[0].measurementSubType == "freehand") {
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getMitralMeanGradientMeasureTool(1));
                }
            }
        }
    }

    function getDataToDelete() {
        return dataToDelete;
    }

    function getDataToEdit() {
        return dataToEdit;
    }
	
	function setDataToDelete()
	{
		dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
	}
	
	function setCoordinate(coordinate) {
        this.coordinate = coordinate;
    }
    
    function getCoordinate() {
        return this.coordinate;
    }

    /**
     * 
     * set the default the unit type  
     */ 
    function getDefaultLineMeasurementUnit() {
        return this.lineMeasurementUnit= lineMeasurementUnit;
    }

    /**
     * 
     * verify the image uid having pixel spacing or not
     */ 
    function isCalibratePixelSpacing(render){
        if(dicomViewer.tools.isCaliberEnabled(render)){
            dicomViewer.tools.setLengthCalibrationFlag(true);
            dicomViewer.tools.setCalibrationActiveTool();
        }
    }

    /**
     * Save the study presentation state
     * @param {Type} pStateDetails - Specifies the PState details
     */ 
    function savePState(pStateDetails) {
        try
        {
            if(pStateDetails === undefined) {
                // Invalid input parameters
                return;
            }

            // Check whether the presentation state is enabled or not
            if(isPStateEnabled() !== true) {
                return;
            }

            var studyUid = pStateDetails.studyUid;
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }
            showAndHideSplashWindow("show", "Saving Presentation", pStateDetails.viewportId);
            var imagePStates = {};

            // Length measurements
            $.each(dicomImageMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value.studyUid)) {
                        return;
                    }

                    var measurementType = undefined;
                    if(value.measureType === "line") {
                        switch(value.measurementSubType) {
                            case "2DLength":
                                measurementType = MT_LENGTH;
                                break;

                            case "2DLine":
                                measurementType = MT_LINE;
                                break;

                            case "Arrow":
                                measurementType = MT_ARROW;
                                break;
                        }

                        if(measurementType === undefined) {
                            if(value.measurementId !== undefined && value.measurementId !== null) {
                                measurementType = getUSMeasurementType(value.measurementId);
                            }
                        }
                    } else if(value.measureType === "point") {
                        measurementType = MT_POINT;
                        if(value.measurementId !== undefined && value.measurementId !== null) {
                            measurementType = getUSMeasurementType(value.measurementId);
                        }
                    }

                    addImagePState(imagePStates, key, value, measurementType);
                });
            });

            // Angle measurements
            $.each(dicomImageAngleMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value[0].studyUid)) {
                        return;
                    }

                    addImagePState(imagePStates, key, value, MT_ANGLE);
                });
            });

            // Ellipse measurements
            $.each(dicomImageEllipseMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value.studyUid)) {
                        return;
                    }

                    var measurementType = undefined;
                    switch(value.measurementSubType) {
                        case "hounsfield":
                            measurementType = MT_HOUNSFIELDELLIPSE;
                            break;

                        case "ellipse":
                            measurementType = MT_ELLIPSE;
                            break;
                    }

                    addImagePState(imagePStates, key, value, measurementType);
                });
            });

            // Rectangle measurements
            $.each(dicomImageRectangleMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value.studyUid)) {
                        return;
                    }

                    var measurementType = undefined;
                    switch(value.measurementSubType) {
                        case "hounsfield":
                            measurementType = MT_HOUNSFIELDRECT;
                            break;

                        case "rectangle":
                            measurementType = MT_RECT;
                            break;

                        case "text":
                            measurementType = MT_TEXT;
                            break;
                    }

                    addImagePState(imagePStates, key, value, measurementType);
                });
            });

            // Trace measurements
            $.each(dicomImageTraceMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value[0].studyUid)) {
                        return;
                    }

                    addImagePState(imagePStates, key, value, MT_TRACE);
                });
            });

            // Mitral gradient measurements
            $.each(dicomImageMitralGradientMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value[0].studyUid)) {
                        return;
                    }

                    var measurementType = MT_MG;
                    switch(value[0].measurementSubType)
                    {
                        case "freehand":
                            measurementType = MT_FREEHAND;
                            break;
                    }

                    addImagePState(imagePStates, key, value, measurementType);
                });
            });

            // pen measurements
            $.each(dicomImagePenMeasurements, function(key, values) {
                values.forEach(function(value) {
                    if(!isSameStudy(studyUid, value[0].studyUid)) {
                        return;
                    }
                    addImagePState(imagePStates, key, value, MT_PEN);
                });
            });

            // Save the presentation state
            var studyPState = getStudyPState(imagePStates, pStateDetails);
            if(studyPState === undefined || studyPState === null) {
                // Invalid PState objects
                return;
            }

            // Send the presentation state to server
            var contextId = studyDetails.modality == "General" ? studyDetails[0].contextId : studyDetails.contextId;
            var pStateUrl = dicomViewer.url.getPStateUrl(contextId);
            var pState = JSON.stringify(studyPState);
            $.ajax({
                type: 'POST',
                contentType: "application/json; charset=utf-8",
                url: pStateUrl,
                async: false,
                data: pState,
                cache: false
            })
            .success(function(data) {
                var description = "Successfully saved the presentation state for the context id: " + decodeURIComponent(studyDetails.contextId);
                sendViewerStatusMessage("200", description);
                showAndHideSplashWindow("success", "Presentation state saved successfully");

                // Refresh PStates
                loadPState(studyUid, undefined, true);
                $("#saveAndLoadPStateMenu_"+pStateDetails.viewportId)[0].style.display="none";
            })
            .fail(function(data) {
                var description = "Failed to save the presentation state for the context id: " + decodeURIComponent(studyDetails.contextId);
                sendViewerStatusMessage("500", description);
                showAndHideSplashWindow("error", "Failed to save the presentation state");

            })
            .error(function(xhr, status) {
                var description = xhr.statusText + "\nFailed to save the presentation state to server";
                sendViewerStatusMessage(xhr.status.toString(), description);
                showAndHideSplashWindow("error", "Failed to save presentation state in server");

            });
        }
        catch(e) {
            showAndHideSplashWindow("error", "Failed to save presentation state");
        }
        setTimeout(function(){$("#saveAndLoadPStateMenu_"+pStateDetails.viewportId)[0].style.display="block";},1500)
    }

    /**
     * show and hide the spalash window
     * @param {Type} messageType - Type of message
     * @param {Type} message - message content
     * @param {Type} studyViewer - study viewer viewportID
     */ 
    function showAndHideSplashWindow(messageType, message, viewportId) {
        try
        {
            if(messageType == "show") {
                $("#splash-window").show().center(viewportId);
                $("#splash-content")[0].innerHTML="<img src = images/presentaionLoader.gif>  "+message+"";
                $("#splash-content").show();
                $("#saveAndLoadPStateMenu_"+viewportId)[0].style.display = "none";
            }
            else if(messageType == "success") {
                setTimeout(function(){$("#splash-content")[0].innerHTML=""+message+"";},1000)
            } else {
                setTimeout(function(){$("#splash-content")[0].innerHTML=""+message+"";},1000)
            }
        }catch(e) 
        { }
        setTimeout(function(){$("#splash-window").fadeOut(1000);}, 1500)
    }

    /**
     * Load the study presentation
     * @param {Type} studyUid - Specifies the studyUid
     * @param {Type} selectedPState - Specifies the selected PState
     * @param {Type} isRefreshMenuOnly - Specifies the flag to refesh the PState menu
     */ 
    function loadPState(studyUid, selectedPState, isRefreshMenuOnly, isStatus) {
        try
        {
            if(studyUid === undefined) {
                // Invalid input parameters
                return;
            }

            // Check whether the presentation state is enabled or not
            if(isPStateEnabled() !== true) {
                return;
            }

            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            var viewportId = (selectedPState == undefined) ? undefined : ((selectedPState == null) ? undefined : selectedPState.split("_"));
            if(isRefreshMenuOnly === undefined && viewportId!=undefined && isStatus !== false) {
                showAndHideSplashWindow("show", "Applying Presentation",viewportId[1]);
            }

            var contextId = studyDetails.modality == "General" ? studyDetails[0].contextId : studyDetails.contextId;
            var pStateUrl = dicomViewer.url.getPStateUrl(contextId);
            $.ajax({
                url: pStateUrl,
                cache: false,
                async: false
            })
            .done(function(data) {
                if(data == undefined || data == null || data.length == 0) {
                    if(isRefreshMenuOnly == false) {
                        resetPState(studyDetails);
                    }

                    return;
                }

                // Parse the JSON PState string
                data.forEach(function(item) {
                    if(item.data !== undefined && item.data !== null) {
                        item.presentationStates = JSON.parse(item.data);
                    }
                });

                var userDUZ = getUserDuz();
                var recentPState = undefined;
                if(selectedPState !== undefined) {
                    // Get the selected presentation state
                    recentPState = data.filter(function(o) {return o.id === selectedPState.split("_")[2];})[0];

                    // Check whether the pstate is external
                    if(recentPState === undefined) {
                        var existingPState = studyDetails.PStates.All.filter(function(o) {return o.id === selectedPState.split("_")[2];})[0];
                        if(existingPState !== undefined) {
                            recentPState = data.filter(function(o) {return o.contextId === existingPState.contextId;})[0];
                        }
                    }

                    // Check whether the selected PState is other user 
                    var isOtherUser = (userDUZ !== parseInt(recentPState.userId));
                    if(isOtherUser) {
                        recentPState.isEditable = false;
                    }
                } else {
                    // Get the recent presentation state
                    var userPStates = data.filter(function(o) { return userDUZ === parseInt(o.userId); });
                    if(!userPStates || userPStates.length === 0) {
                        userPStates = data.filter(function(o) { return userDUZ !== parseInt(o.userId); });
                    }

                    if(userPStates !== undefined && userPStates !== null) {
                        var recentDate = Math.max.apply(null, userPStates.map(function(o) {
                            if(!o.isExternal) {
                                return new Date(parseDate(o.dateTime));
                            } else {
                                return -1;
                            }
                        }));

                        // Check whether the pstate is external
                        if(recentDate === -1) {
                            recentPState = userPStates.filter(function(o) { return (o.isExternal === true); })[0];
                        } else {
                            recentPState = userPStates.filter(function(o) { return new Date(parseDate(o.dateTime)).valueOf() === recentDate; })[0];
                        }
                    }
                }

                // Update the presentation state
                updatePState(recentPState, studyDetails);
                refreshPState(studyUid);

                if(isRefreshMenuOnly === undefined && isStatus !== false) {
                    showAndHideSplashWindow("success", "Applied Presentation successfully");
                }

                // Update the study presentations states
                var activePStateId = (recentPState !== undefined ? recentPState.id : undefined);
                isRefreshMenuOnly = (isRefreshMenuOnly == true ? true : (selectedPState != undefined ? true : false));
                updateStudyPStates(data, studyDetails, activePStateId, isRefreshMenuOnly);
                viewportId != undefined ? $("#saveAndLoadPStateMenu_"+viewportId[1])[0].style.display="none" : "";
            })
            .fail(function(data) {
                resetPState(studyDetails);

                var description = "Failed to get the presentation state for the context id: " + decodeURIComponent(studyDetails.contextId);
                sendViewerStatusMessage("500", description);
                if(isRefreshMenuOnly === undefined) {
                    showAndHideSplashWindow("error", "Failed to Apply Presentation state");
                }
            })
            .error(function(xhr, status) {
                resetPState(studyDetails);

                var description = xhr.statusText + "\nFailed to get the presentation state from server";
                sendViewerStatusMessage(xhr.status.toString(), description);
                if(isRefreshMenuOnly === undefined) {
                    showAndHideSplashWindow("error", "Failed to get presentation state from server");
                }
            });
        }
        catch(e) { 
            showAndHideSplashWindow("error", "Error in applying presentation state");
        }
        (viewportId!=undefined ) ? setTimeout(function(){$("#saveAndLoadPStateMenu_"+viewportId[1])[0].style.display="block";},1500) : "";
    }

    /**
     * To convert given date format into milliseconds
     * @param {Type} dateString 
     */ 
    function parseDate(dateString){
        var time = Date.parse(dateString);
        if(!time){
            if(!time){
                bound = dateString.indexOf(' ');
                var dateData = dateString.slice(0, bound).split('-');
                var timeData = dateString.slice(bound+1, -1).split(':');

                time = Date.UTC(dateData[0],dateData[1]-1,dateData[2],timeData[0],timeData[1],timeData[2]);
            }
        }
        return time;
    }

    /**
     * Load the length or point measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurementKey - Specifies the measurement key
     * @param {Type} measurements - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */ 
    function loadLengthOrPointMeasurement(imageKey, measurementKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurementKey === undefined || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var measureType = undefined;
            var measurementSubType = undefined;
            var measurementType = -1;
            var measurementUnits = undefined;
            var measurementId = undefined;
            switch(measurementKey) {
                case MT_LENGTH:
                    measurementSubType = "2DLength";
                    measurementType = 0;
                    measureType = "line";
                    break;

                case MT_LINE:
                    measurementSubType = "2DLine";
                    measurementType = 9;
                    measureType = "line";
                    break;

                case MT_ARROW:
                    measurementSubType = "Arrow";
                    measurementType = 10;
                    measureType = "line";
                    break;

                case MT_MVALT:
                    measurementSubType = "mitralValveAnteriorLeafletThickness";
                    measurementId = measurementSubType;
                    measurementType = 0;
                    measurementUnits = "mm";
                    measureType = "line";
                    break;

                case MT_MRL:
                    measurementSubType = "mitralRegurgitationLength";
                    measurementId = measurementSubType;
                    measurementType = 0;
                    measurementUnits = "cm";
                    measureType = "line";
                    break;

                case MT_ARL:
                    measurementSubType = "aorticRegurgitationLength";
                    measurementId = measurementSubType;
                    measurementType = 0;
                    measurementUnits = "cm";
                    measureType = "line";
                    break;

                case MT_POINT:
                    measurementSubType = "point";
                    measurementType = 1;
                    measureType = "point";
                    break;

                case MT_MRPV:
                    measurementSubType = "mitralRegurgitationPeakVelocity";
                    measurementId = measurementSubType;
                    measurementType = 1;
                    measurementUnits = "m/s";
                    measureType = "point";
                    break;

                case MT_ARPV:
                    measurementSubType = "aorticRegurgitationPeakVelocity";
                    measurementId = measurementSubType;
                    measurementType = 1;
                    measurementUnits = "m/s";
                    measureType = "point";
                    break;

                case MT_ASPV:
                    measurementSubType = "aorticStenosisPeakVelocity";
                    measurementId = measurementSubType;
                    measurementType = 1;
                    measurementUnits = "m/s";
                    measureType = "point";
                    break;
            }

            var measurements = dicomImageMeasurements[imageKey];
            if (measurements === undefined) {
                measurements = [];
            }

            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start = 
                {
                    handleActive: false,
                    x: parseFloat(points[index]),
                    y: parseFloat(points[index+1])
                };

                var end =
                {
                    handleActive: false,
                    x: parseFloat(points[index+2]),
                    y: parseFloat(points[index+3])
                };

                var measurementData =
                {
                    start: start,
                    end: end,
                    measureType: measureType,
                    measurementSubType: measurementSubType,
                    measurementId: measurementId,
                    measurementComplete: true,
                    measurementType: measurementType,
                    measurementUnits: measurementUnits,
                    studyUid: measurement.studyUid,
                    isEditable: isEditable,
                    sessionType: 1,
                    style : getGrpahicStyle(measurement)
                };

                measurements.push(measurementData);
            }
            dicomImageMeasurements[imageKey] = measurements;
        }
        catch(e)
        { }
    }

    /**
     * Load the angle measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurement - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */ 
    function loadAngleMeasurement(imageKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var angleMeasurements = dicomImageAngleMeasurements[imageKey];
            if (angleMeasurements === undefined) {
                angleMeasurements = [];
            }

            var measurementId = angleMeasurements.length;
            var measurements = angleMeasurements[measurementId];
            if (measurements === undefined) {
                measurements = [];
            }

            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start = 
                {
                    handleActive: false,
                    x: parseFloat(points[index]),
                    y: parseFloat(points[index+1])
                };

                var end =
                {
                    handleActive: false,
                    x: parseFloat(points[index+2]),
                    y: parseFloat(points[index+3])
                };

                var measurementData =
                {
                    start: start,
                    end: end,
                    measureType: "angle",
                    measurementSubType: undefined,
                    measurementId: measurementId,
                    measurementComplete: true,
                    measurementType: undefined,
                    measurementUnits: undefined,
                    editMode: false,
                    studyUid: measurement.studyUid,
                    isEditable: isEditable,
                    sessionType: 1,
                    style : getGrpahicStyle(measurement)
                };

                measurements.push(measurementData);
            }

            angleMeasurements[measurementId] = measurements;
            dicomImageAngleMeasurements[imageKey] = angleMeasurements;
        }
        catch(e)
        { }
    }

    /**
     * Load the ellipse measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurementKey - Specifies the measurement key
     * @param {Type} measurements - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */
    function loadEllipseMeasurement(imageKey, measurementKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurementKey === undefined  || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var measurementSubType = undefined;
            var measurementType = undefined;
            switch(measurementKey) {
                case MT_ELLIPSE:
                    measurementSubType = "ellipse";
                    measurementType = 11;
                    break;

                case MT_HOUNSFIELDELLIPSE:
                    measurementSubType = "hounsfield";
                    measurementType = 7;
                    break;
            }

            var ellipseMeasurements = dicomImageEllipseMeasurements[imageKey];
            if (ellipseMeasurements === undefined) {
                ellipseMeasurements = [];
            }

            var measurementResult = undefined;
            if(measurementSubType === "hounsfield") {
                var text = measurement.text;
                if(text !== undefined) {
                    measurementResult = text.split(",");
                }
            }

            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start, end = null;
                var first, second, third, fourth, center = null;
                start = 
                {
                    handleActive: false,
                    x: parseFloat(points[index]),
                    y: parseFloat(points[index+1])
                };

                end =
                {
                    handleActive: false,
                    x: parseFloat(points[index+2]),
                    y: parseFloat(points[index+3])
                };

                if (points.length > 4) {
                    first = 
                    {
                        x: parseFloat(points[index]),
                        y: parseFloat(points[index+1])
                    };

                    second =
                    {
                        x: parseFloat(points[index+2]),
                        y: parseFloat(points[index+3])
                    };

                    third = 
                    {
                        x: parseFloat(points[index+4]),
                        y: parseFloat(points[index+5])
                    };

                    fourth =
                    {
                        x: parseFloat(points[index+6]),
                        y: parseFloat(points[index+7])
                    };
                }

                if (points.length > 8) {
                    center = 
                    {
                        x: parseFloat(points[index+8]),
                        y: parseFloat(points[index+9])
                    };
                }

                index = points.length;

                var measurementData =
                {
                    start: start,
                    end: end,
                    first: first,
                    second: second,
                    third: third,
                    fourth: fourth,
                    center: center,
                    measureType: "ellipse",
                    measurementSubType: measurementSubType,
                    measurementId: -1,
                    measurementComplete: true,
                    measurementType: measurementType,
                    measurementUnits: undefined,
                    editMode: false,
                    measurementResult: measurementResult,
                    studyUid: measurement.studyUid,
                    isEditable: isEditable,
                    sessionType: 1,
                    style : getGrpahicStyle(measurement)
                };

                ellipseMeasurements.push(measurementData);
            }

            dicomImageEllipseMeasurements[imageKey] = ellipseMeasurements;
        }
        catch(e)
        { }
    }

    /**
     * Load the rectangle measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurementKey - Specifies the measurement key
     * @param {Type} measurements - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */
    function loadRectangleMeasurement(imageKey, measurementKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurementKey === undefined  || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var measurementSubType = undefined;
            var measurementType = undefined;
            switch(measurementKey) {
                case MT_RECT:
                    measurementSubType = "rectangle";
                    measurementType = 12;
                    break;

                case MT_HOUNSFIELDRECT:
                    measurementSubType = "hounsfield";
                    measurementType = 14;
                    break;

                case MT_TEXT:
                    measurementSubType = "text";
                    measurementType = 8;
                    break;
            }

            var rectangleMeasurements = dicomImageRectangleMeasurements[imageKey];
            if (rectangleMeasurements === undefined) {
                rectangleMeasurements = [];
            }

            var measurementResult = undefined;
            var measurementText = undefined;
            if(measurementSubType === "hounsfield" || measurementSubType === "text") {
                var text = measurement.text;
                if(text !== undefined) {
                    if(measurementSubType === "text") {
                        measurementText = text.replace("<BR>", "\n");
                        measurementText = measurementText.replace("<br>", "\n");
                    } else {
                        measurementResult = text.split(",");
                    }
                }
            }

            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start = 
                {
                    handleActive: false,
                    x: parseFloat(points[index]),
                    y: parseFloat(points[index+1])
                };

                var end =
                {
                    handleActive: false,
                    x: parseFloat(points[index+2]),
                    y: parseFloat(points[index+3])
                };

                var measurementData =
                {
                    start: start,
                    end: end,
                    measureType: "rectangle",
                    measurementSubType: measurementSubType,
                    measurementId: -1,
                    measurementComplete: true,
                    measurementType: measurementType,
                    measurementUnits: undefined,
                    editMode: false,
                    measurementResult: measurementResult,
                    measurementText: measurementText,
                    studyUid: measurement.studyUid,
                    isEditable: isEditable,
                    sessionType: 1,
                    style : getGrpahicStyle(measurement)
                };

                rectangleMeasurements.push(measurementData);
            }

            dicomImageRectangleMeasurements[imageKey] = rectangleMeasurements;
        }
        catch(e)
        { }
    }

    /**
     * Load the trace measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurement - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */ 
    function loadTraceMeasurement(imageKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var tarceMeasurements = dicomImageTraceMeasurements[imageKey];
            if (tarceMeasurements === undefined) {
                tarceMeasurements = [];
            }

            var measurementId = tarceMeasurements.length;
            var measurements = tarceMeasurements[measurementId];
            if (measurements === undefined) {
                measurements = [];
            } 
            
            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start = 
                {
                    handleActive: false,
                    x: parseFloat(points[index]),
                    y: parseFloat(points[index+1])
                };

                var end =
                {
                    handleActive: false,
                    x: parseFloat(points[index+2]),
                    y: parseFloat(points[index+3])
                };

                var measurementData =
                {
                    start: start,
                    end: end,
                    measureType: "trace",
                    measurementSubType: undefined,
                    measurementId: measurementId,
                    measurementComplete: true,
                    measurementType: 2,
                    measurementUnits: undefined,
                    editMode: false,
                    studyUid: measurement.studyUid,
                    isEditable: isEditable,
                    sessionType: 1,
                    style : getGrpahicStyle(measurement)
                };

                measurements.push(measurementData);
            }
            
            tarceMeasurements[measurementId] = measurements;
            dicomImageTraceMeasurements[imageKey] = tarceMeasurements;
        }
        catch(e)
        { }
    }

    /**
     * Load the Mitral Gradient measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurementKey - Specifies the measurement key* 
     * @param {Type} measurement - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */ 
    function loadMitralGradientMeasurement(imageKey, measurementKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var measurementSubType = undefined;
            var measurementType = undefined;
            switch(measurementKey) {
                case MT_MG:
                    measurementSubType = MT_MG;
                    measurementType = 5;
                    break;

                case MT_FREEHAND:
                    measurementSubType = "freehand";
                    measurementType = 13;
                    break;
            }

            var mitralMeasurements = dicomImageMitralGradientMeasurements[imageKey];
            if (mitralMeasurements === undefined) {
                mitralMeasurements = [];
            }

            var measurementId = mitralMeasurements.length;
            var measurements = mitralMeasurements[measurementId];
            if (measurements === undefined) {
                measurements = [];
            }

            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start = 
                {
                    handleActive: false,
                    x: parseFloat(points[index]),
                    y: parseFloat(points[index+1])
                };

                var end =
                {
                    handleActive: false,
                    x: parseFloat(points[index+2]),
                    y: parseFloat(points[index+3])
                };

                var measurementData =
                {
                    start: start,
                    end: end,
                    measureType: "mitralGradient",
                    measurementSubType: measurementSubType,
                    measurementId: measurementId,
                    measurementComplete: true,
                    measurementType: measurementType,
                    measurementUnits: undefined,
                    editMode: false,
                    studyUid: measurement.studyUid,
                    isEditable: isEditable,
                    sessionType: 1,
                    style : getGrpahicStyle(measurement)
                };

                measurements.push(measurementData);
            }
            
            mitralMeasurements[measurementId] = measurements;
            dicomImageMitralGradientMeasurements[imageKey] = mitralMeasurements;
        }
        catch(e)
        { }
    }

    /**
     * Get UUID
     */ 
    function getUUID() {
        try
        {
            var d = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = (d + Math.random()*16)%16 | 0;
                d = Math.floor(d/16);
                return (c=='x' ? r : (r&0x3|0x8)).toString(16);
            });

            return uuid;
        }
        catch(e)
        { }
    }

    /**
     * get image PState
     * @param {Type} imagePStates - Specifies the image PStates
     * @param {Type} imageKey - Specifies the image key 
     */ 
    function getImagePState(imagePStates, imageKey) {
        try
        {
            var imagePState = imagePStates[imageKey];
            if(imagePState !== undefined) {
                return imagePState;
            } else {
                var imageUids = imageKey.split("_");
                imagePState = {};
                imagePState.id = getUUID();
                imagePState.imageId = imageUids[0];
                imagePState.frameNumber = imageUids[1];
                imagePState.objects = [];
                imagePState.layers = [];

                imagePStates[imageKey] = imagePState;
            }

            return imagePState;
        }
        catch(e)
        { }
    }

    /**
     * Get the study PState
     * @param {Type} imagePStates - Specifies the image PState
     * @param {Type} pStateDescription - Specifies the presentation state description
     * @param {Type} isPrivate - Specifies the flag to make private
     * @param {Type} isEditable - Specifies the flag to make editalbe
     */ 
    function getStudyPState(imagePStates, pStateDetails, isPrivate, isEditable) {
        try
        {
            if(imagePStates == undefined || imagePStates == null || imagePStates.length == 0) {
                // Invalid or empty image PStates
                return undefined;
            }

            var studyUid = pStateDetails.studyUid;
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            var description = "";
            if(studyDetails.PStates !== undefined && studyDetails.PStates !== null) {
                description = studyDetails.PStates.Active.description;
            }

            var studyPState = {};
            var isPrivate = (pStateDetails.isPrivate === undefined ? false : pStateDetails.isPrivate);
            var isEditable = (pStateDetails.isEditable === undefined ? true : pStateDetails.isEditable);
            var isNew = (pStateDetails.isNew === undefined ? false : pStateDetails.isNew);
            description = (description === undefined ? "" : description);

            // Update the PState with an existing PState
            if(!isNew) {
                if(studyDetails.PStates !== undefined) {
                    if(studyDetails.PStates.Active.isNew == true) {
                        removeUnSavedPState(studyDetails);
                        studyPState.id = getUUID();
                    } else {
                        studyPState.id = studyDetails.PStates.Active.id;
                    }
                }
            }

            studyPState.isPrivate = isPrivate;
            studyPState.isEditable = isEditable;
            studyPState.description = description;

            var presentationStates = [];
            $.each(imagePStates, function(key, imagePState) {
                presentationStates.push(imagePState);
            });
            studyPState.data = JSON.stringify(presentationStates);

            return studyPState;
        }
        catch(e)
        { }

        return undefined;
    }

    /**
     * Get the graphic object PState
     * @param {Type} measuements - Specifies the measurements
     * @param {Type} measurementType - Specifies the measurement type
     */ 
    function getGraphicObjectPState(measuements, measurementType) {
        try
        {
            if(measuements == undefined || measuements == null) {
                // Invalid measurements
                return undefined;
            }

            var graphicObject = {};
            graphicObject.id = getUUID();
            graphicObject.type = measurementType;
            graphicObject.points = [];
            graphicObject.text = "";
            graphicObject.graphicLayerIndex = 0;
            graphicObject.style = getGrpahicStyle(measuements);

            switch(measurementType)
            {
                case MT_LENGTH:
                case MT_LINE:
                case MT_ARROW:
                case MT_POINT:
                case MT_MVALT:
                case MT_MRL:
                case MT_ARL:
                case MT_MRPV:
                case MT_ARPV:
                case MT_ASPV:
                {
                    addPointsInPState(measuements, graphicObject.points);
                    break;
                }

                case MT_ANGLE:
                case MT_TRACE:
                case MT_MG:
                case MT_PEN:
                case MT_FREEHAND:
                {
                    measuements.forEach(function(value) {
                        addPointsInPState(value, graphicObject.points);
                    });
                    break;
                }

                case MT_ELLIPSE:
                case MT_HOUNSFIELDELLIPSE:
                case MT_RECT:
                case MT_HOUNSFIELDRECT:
                case MT_TEXT:
                {
                    var isEllispe = (measurementType === MT_HOUNSFIELDELLIPSE ||
                                                        measurementType === MT_HOUNSFIELDRECT);
                    addPointsInPState(measuements, graphicObject.points, isEllispe);
                    if(isEllispe) {
                        var text = "";
                        measuements.measurementResult.forEach(function(textItem) {
                            text += textItem;
                            text += ",";
                        });
                        graphicObject.text = text.slice(0, -1);
                    } else if(measurementType === MT_TEXT) {
                        graphicObject.text = measuements.measurementText;
                    }
                    break;
                }
            }

            return graphicObject;
        }
        catch(e)
        { }

        return undefined;
    }

    /**
     * Add points in PState 
     * @param {Type} measuements -  Specifies the measurements
     * @param {Type} points - points
     */ 
    function addPointsInPState(measuements, points, isEllispe) {
        try
        {
            points.push(Math.round(measuements.start.x));
            points.push(Math.round(measuements.start.y));
            points.push(Math.round(measuements.end.x));
            points.push(Math.round(measuements.end.y));

            if (isEllispe) {
                if (measuements.first != null) {
                    points.push(Math.round(measuements.first.x));
                    points.push(Math.round(measuements.first.y));
                    points.push(Math.round(measuements.second.x));
                    points.push(Math.round(measuements.second.y));
                    points.push(Math.round(measuements.third.x));
                    points.push(Math.round(measuements.third.y));
                    points.push(Math.round(measuements.fourth.x));
                    points.push(Math.round(measuements.fourth.y));
                }
                if (measuements.center != null) {
                    points.push(Math.round(measuements.center.x));
                    points.push(Math.round(measuements.center.y));
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Add the image PState
     * @param {Type} imagePStates - Specifies the image PStates
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measuements - Specifies the measurements
     * @param {Type} measurementType - Specifies the measurement type
     */ 
    function addImagePState(imagePStates, imageKey, measuements, measurementType) {
        try
        {
            var imagePState = getImagePState(imagePStates, imageKey);
            var graphicObject = getGraphicObjectPState(measuements, measurementType);
            if(graphicObject === undefined) {
                return;
            }

            imagePState.objects.push(graphicObject);
            imagePStates[imageKey] = imagePState;
        }
        catch(e)
        { }
    }

    /**
     * Get US measurement type
     * @param {Type} measurement - Specifies the measurement subtype
     */ 
    function getUSMeasurementType(measurementSubType) {
        switch(measurementSubType) {
            case "mitralValveAnteriorLeafletThickness":
                return MT_MVALT;

            case "mitralRegurgitationLength":
                return MT_MRL;

            case "aorticRegurgitationLength":
                return MT_ARL;

            case "mitralRegurgitationPeakVelocity":
                return MT_MRPV;

            case "aorticRegurgitationPeakVelocity":
                return MT_ARPV;

            case "aorticStenosisPeakVelocity":
                return MT_ASPV;
        }

        return undefined;
    }

    /**
     * Get the graphic style
     * @param {Type} measuements - Specifies the measuerment data
     */ 
    function getGrpahicStyle(measuements) {
        try
        {
            var measurementStyle = measuements.style;
            if(!measurementStyle) {
                measurementStyle = dicomViewer.measurement.draw.getMeasurementStyle();
            }

            var style =
            {
                lineColor : measurementStyle.lineColor,
                lineWidth : parseFloat(measurementStyle.lineWidth),
                textColor : measurementStyle.textColor,
                fontName : measurementStyle.fontName,
                fontSize : parseInt(measurementStyle.fontSize),
                isBold : measurementStyle.isBold,
                isItalic : measurementStyle.isItalic
            };

            return style;
        }
        catch(e)
        { }
    }

    /**
     * Check whether the study is same
     * @param {Type} selectedStudyUid - Specifies the selected study Uid
     * @param {Type} measurementStudyUid  - Specifies the measurement study Uid
     */ 
    function isSameStudy(selectedStudyUid, measurementStudyUid) {
        if(measurementStudyUid === undefined || selectedStudyUid === undefined) {
            return false;
        }

        if(selectedStudyUid === measurementStudyUid) {
            return true;
        }

        return false;
    }

    /**
     * Update the presentation state
     * @param {Type} selctedPState - Specifies the presentation state
     * @param {Type} studyDetails - Specifies the study details
     */ 
    function updatePState(selctedPState, studyDetails) {
        try
        {
            // Delete all measurements and annotations
            deleteAllPStates(studyDetails.studyUid);

            if(selctedPState === undefined ||
               selctedPState === null ||
               studyDetails === undefined ||
               studyDetails === null) {
               // Invalid input parameters 
                return;
            }

            // Flag to edit the measurement or annotation
            var isEditable = true;
            if(selctedPState.isEditable !== undefined && selctedPState.isEditable !== null) {
                isEditable = selctedPState.isEditable;
            }

            selctedPState.presentationStates.forEach(function(pState) {
                var imageKey = pState.imageId + "_" + pState.frameNumber;
                pState.objects.forEach(function(graphicObjects) {
                    graphicObjects.studyUid = studyDetails.studyUid;
                    switch(graphicObjects.type) {
                        case MT_LENGTH:
                        case MT_LINE:
                        case MT_ARROW:
                        case MT_MVALT:
                        case MT_MRL:
                        case MT_ARL:
                        case MT_POINT:
                        case MT_MRPV:
                        case MT_ARPV:
                        case MT_ASPV:
                        {
                            loadLengthOrPointMeasurement(imageKey, graphicObjects.type, graphicObjects, isEditable);
                            break;
                        }

                        case MT_ANGLE:
                        {
                            loadAngleMeasurement(imageKey, graphicObjects, isEditable);
                            break;
                        }

                        case MT_ELLIPSE:
                        case MT_HOUNSFIELDELLIPSE:
                        {
                            loadEllipseMeasurement(imageKey, graphicObjects.type, graphicObjects, isEditable);
                            break;
                        }

                        case MT_RECT:
                        case MT_HOUNSFIELDRECT:
                        case MT_TEXT:
                        {
                            loadRectangleMeasurement(imageKey, graphicObjects.type, graphicObjects, isEditable);
                            break;
                        }

                        case MT_TRACE:
                        {
                            loadTraceMeasurement(imageKey, graphicObjects, isEditable);
                            break;
                        }

                        case MT_MG:
                        case MT_FREEHAND:
                        {
                            loadMitralGradientMeasurement(imageKey, graphicObjects.type, graphicObjects, isEditable);
                            break;
                        }
                        case MT_PEN:
                        {
                            loadPenMeasurement(imageKey, graphicObjects.type, graphicObjects, isEditable);
                            break;
                        }
                    }
                });
            });
        }
        catch(e)
        { }
    }

    /**
     * Update the study presentation states
     * @param {Type} pStates - Specifies the PStates
     * @param {Type} studyDetails - Specifies the study details
     * @param {Type} activePStateId - Specifies the active PState Id
     * @param {Type} isRefreshMenu - Specifies the flag to refesh PState menu
     */ 
    function updateStudyPStates(pStates, studyDetails, activePStateId, isRefreshMenu) {
        try
        {
            if(pStates == undefined || 
               pStates === null || 
               studyDetails === undefined ||
               studyDetails === null) {
                return;
            }

            // Create the object to hold the PState
            studyDetails.PStates = {};
            studyDetails.PStates.All = [];
            studyDetails.PStates.userDUZ = getUserDuz();

            pStates.forEach(function(pState) {
                var isOtherUser = (studyDetails.PStates.userDUZ !== parseInt(pState.userId));
                var isEditable = (isOtherUser ? false : pState.isEditable);

                if(!isDuplicatePState(studyDetails.PStates.All, pState)) {
                    studyDetails.PStates.All.push(
                    {
                        id: pState.id,
                        //name: getPStateDisplayName(pState),
                        name: pState.description,
                        dateTime: pState.dateTime,
                        description: pState.description,
                        isEditable: isEditable,
                        isOtherUser: isOtherUser,
                        isExternal: pState.isExternal,
                        contextId : pState.contextId
                    });
                }

                if(pState.id === activePStateId) {
                    studyDetails.PStates.Active =
                    {
                        id: pState.id,
                        //name: getPStateDisplayName(pState),
                        name: pState.description,
                        dateTime: pState.dateTime,
                        description: pState.description,
                        isEditable: isEditable,
                        isDirty: false,
                        imagePStates: pState.presentationStates,
                        isOtherUser: isOtherUser,
                        isExternal: pState.isExternal,
                        contextId : pState.contextId
                    };
                } else if(activePStateId == undefined && studyDetails.PStates.Active === undefined) {
                    studyDetails.PStates.Active = { isEmpty: true };
                }
            });

            // Sort by recent date
            studyDetails.PStates.All.sort(function(a, b)
            {
                if(!a.isExternal && !b.isExternal) {
                    return new Date(parseDate(b.dateTime)) - new Date(parseDate(a.dateTime));
                } else {
                    return -1;
                }
            });
            dicomViewer.updatePState(studyDetails.studyUid);
        }
        catch(e)
        { }
    }

    /**
     * Check whether the PState is duplicated or not
     * @param {Type} pStates - Specifies the PStates
     * @param {Type} pState - Specifies the selected PState
     */ 
    function isDuplicatePState(pStates, pState) {
        try
        {
            var isDuplicate = false; 

            pStates.forEach(function(item) {
                if(pState.id === item.id) {
                    isDuplicate = true;
                    return false;
                }
            });

            return isDuplicate;
        }
        catch(e)
        { }

        return false;
    }

    /**
     * Delete all measurements
     * @param {Type} studyUid - Specifies the study Uid
     */ 
    function deleteAllPStates(studyUid) {
        try
        {
            if(studyUid === undefined || studyUid === null) {
                return;
            }
            var deleteAllPState = [];
            deleteAllPState.push(dicomImageMeasurements);
            deleteAllPState.push(dicomImageAngleMeasurements);
            deleteAllPState.push(dicomImageEllipseMeasurements);
            deleteAllPState.push(dicomImageRectangleMeasurements);
            deleteAllPState.push(dicomImageTraceMeasurements);
            deleteAllPState.push(dicomImageMitralGradientMeasurements);
            deleteAllPState.push(dicomImagePenMeasurements);
            var imageUids=[];
            var isIndex = false;

            dicomViewer.mouseTools.setPreviousTool(dicomViewer.mouseTools.getActiveTool());
            dicomViewer.mouseTools.setCursor(dicomViewer.mouseTools.getToolCursor(1));

            $.each(deleteAllPState, function(key, values) {
                $.each(values, function(id, ImageId) {
                    ImageId.some(function(o) {
                        var obj = o;
                        var studyId = (Object.prototype.toString.call(obj) === '[object Array]') ? obj[0].studyUid : obj.studyUid;
                        if(studyId === studyUid && !isIndex) {
                            imageUids.push(id);
                            return true;
                        } else if(studyId === studyUid && imageUids.indexOf(id) == -1) {
                            imageUids.push(id);
                            return true;
                        }
                    });
                });
                isIndex = true;
            });

            imageUids.forEach(function(imageUid) {
                var imageUidFrameNumber = imageUid.split("_");
                removeAllMeasurements(imageUidFrameNumber[0], imageUidFrameNumber[1]);
            });
        }
        catch(e)
        { }
    }

    /**
     * Create the new presentation state
     * @param {Type} e - Specifies the id
     */ 
    function newPState(e) {
        try
        {
            var studyUid = e.split("_")[1];
            if(studyUid === undefined || studyUid === null) {
                // Invalid parameters
                return;
            }

            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            // Create the object to hold the PState
            if(studyDetails.PStates == undefined || studyDetails.PStates == null) {
                studyDetails.PStates = {};
            }

            // Create the array to hold all PStates
            if(studyDetails.PStates.All == undefined || studyDetails.PStates.All == null) {
                studyDetails.PStates.All = [];
            }

            var newId = getUUID();
            var newTitle = "untitled";
            studyDetails.PStates.All.push({ id: newId, name: newTitle, dateTime: "", description: "" });
            studyDetails.PStates.Active = { id: newId, name: newTitle, dateTime: "", description: "", isNew: true };
            updateNewDirtyActivePState(studyDetails);
        }
        catch(e)
        { }
    }

    /**
     * Delete the presentation state
     * @param {Type} e - Specifies the id
     */ 
    function deletePState(e) {
        try
        {
            var studyUid = e.split("_")[1];
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            // Send the presentation state to server
            var contextId = studyDetails.modality == "General" ? studyDetails[0].contextId : studyDetails.contextId;
            var pStateUrl = dicomViewer.url.getPStateUrl(contextId);
            var pState = JSON.stringify({id: studyDetails.PStates.Active.id});
            $.ajax({
                type: 'DELETE',
                url: pStateUrl,
                async: false,
                data: pState,
                cache: false
            })
            .success(function(data) {
                var description = "Successfully deleted the presentation state for the context id: " + decodeURIComponent(studyDetails.contextId);
                sendViewerStatusMessage("200", description);

                // Refresh PStates
                loadPState(studyUid, undefined, false);
            })
            .fail(function(data) {
                var description = "Failed to delete the presentation state for the context id: " + decodeURIComponent(studyDetails.contextId);
                sendViewerStatusMessage("500", description);
            })
            .error(function(xhr, status) {
                var description = xhr.statusText + "\nFailed to delete the presentation state to server";
                sendViewerStatusMessage(xhr.status.toString(), description);
            });
        }
        catch(e)
        { }
    }

    /**
     * Remove the unsaved PState
     * @param {Type} studyDetails - Specifies the study details
     */ 
    function removeUnSavedPState(studyDetails) {
        try
        {
            var unsavedPStateIndex = studyDetails.PStates.All.map(function(item)
            {
                return item.id; 
            }).indexOf(studyDetails.PStates.Active.id);

            if(unsavedPStateIndex !== -1) {
                studyDetails.PStates.All.splice(unsavedPStateIndex, 1);
            }
        }
        catch(e)
        { }
    }

    /**
     * Reset the PStates
     * @param {Type} studyDetails - Specify the study details
     */ 
    function resetPState(studyDetails) {
        try
        {
            if(studyDetails.PStates === undefined || studyDetails.PStates === null) {
                return;
            }

            var studyUid = studyDetails.studyUid;
            studyDetails.PStates = undefined;

            dicomViewer.updatePState(studyUid);
            deleteAllPStates(studyUid);
            refreshPState(studyUid);
        }
        catch(e)
        { }
    }

    /**
    * Refresh the PStates
    * @param {Type} studyUid - Specify the study Uid
    */ 
    function refreshPState(studyUid) {
        try
        {
            var allViewports = dicomViewer.viewports.getAllViewports();
            if(allViewports === null || allViewports === undefined) {
                return;
            }

            // Refresh renderer
            $.each(allViewports, function(key, value) {
                if(value.studyUid === studyUid) {
                    $("#"+value.seriesLayoutId+" div").each(function() {
                        var imageLevelId = $(this).attr('id');
                        var imageRender  = value.getImageRender(imageLevelId);
                        if(imageRender) {
                            imageRender.drawDicomImage(false);
                        }
                    });
                }
            });
        }
        catch(e)
        { }
    }

    /**
     * Save or delete the unsaved PState
     * @param {Type} studyDetails - Specifies the PState
     * @param {Type} isSave - Specify the flag to save or edit the PState
     */ 
    function saveOrDeleteUnSavedPState(studyDetails, isSave) {
        try
        {
            if(isSave == true) {
                savePState({ studyUid: studyDetails.studyUid, isNew: true });
            } else {
                removeUnSavedPState(studyDetails);
                loadPState(studyDetails.studyUid, undefined, false);
            }
        }
        catch(e)
        { }
    }

    /**
     * Edit presentaion state 
     * @param {Type} e - Specifies the id
     */ 
    function editPState(e) {
        try
        {
            var studyDetails = dicomViewer.getStudyDetails(e.split("_")[1]);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            if(studyDetails.PStates === undefined || studyDetails.PStates === null) {
                return null;
            }

            var activePState = studyDetails.PStates.Active;
            document.getElementById("presentationName").value = activePState.name;
            document.getElementById("editPStateDescription").value = (activePState.description == undefined) ? "" : activePState.description;
            $("#edit-PState").dialog("open");
        }
        catch(e)
        { }
    }

    /**
     * Show the confirmation message box
     */ 
    function showConfirmMessage(message) {
        return window.confirm(message);
    }
    
    /**
     * 
     * To get session type  
     */ 
    function getSessionType() {
        return selectedSessionType;
    }
    
    /**
     * To set session type
     * @param {int} sessionType, 0 - Session; 1 - Stored; 2 - All
     */ 
    function setSessionType(sessionType) {
        selectedSessionType = sessionType;
    }
    
    /**
     * To show measurements based on selected session type
     * @param {int} sessionType
     */ 
    function isMeasurementDrawable(sessionType) {
        if (selectedSessionType === 2) {
            return true;
        }
        return selectedSessionType === sessionType;
    }

    /**
     * Update dirty presentation state 
     * @param {Type} seriesLevelDivId - Specifies the viewport id
     * @param {Type} measurementData - Specifies the measurement data
     * @param {Type} isDelete - Specifies the flag to delete PState 
     * @param {Type} isUpdate - Specifies the flag to update PState 
     */ 
    function updateDirtyPState(seriesLevelDivId, measurementData, isDelete, isUpdate) {
        try
        {
            // Check whether the presentation state is enabled or not
            if(isPStateEnabled() !== true) {
                return;
            }

            var studyDiv = getStudyLayoutId(seriesLevelDivId);
            if(studyDiv === null || studyDiv === undefined) {
                return;
            }

            var viewport = dicomViewer.viewports.getViewport(seriesLevelDivId);
            if(viewport === null || viewport === undefined) {
                return;
            }

            var studyUid = viewport.studyUid;
            if(studyUid === null || studyUid === undefined) {
                return;
            }

            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                return;
            }

            // Create new presentation if an existing PState is invalid
            if(studyDetails.PStates == undefined ||
               studyDetails.PStates == null ||
               studyDetails.PStates.Active.isEmpty == true) {
                return newPState("newPState_"+studyUid);
            }

            if(studyDetails.PStates.Active.isNew == true || 
               studyDetails.PStates.Active.isEditable == false) {
                updateNewDirtyActivePState(studyDetails);
                return;
            }

            if(studyDetails.PStates.Active.isDescriptionUpdated == true) {
                updateDirtyActivePState(studyDetails, studyDiv, true);
                return;
            }

            var isDirty = false;
            if(measurementData !== undefined && measurementData !== null) {
                var imagePStates = studyDetails.PStates.Active.imagePStates;
                var key = measurementData.key;
                var arrayIndex = measurementData.arryIndex;
                var measurementType = measurementData.measurmentType;
                var sessionType = measurementData.sessionType;
                var measurement = undefined;

                // Get the session type if we call delete all measurement/annotations
                if(sessionType === undefined && isUpdate !== true) {
                    sessionType = 0;
                    if(imagePStates !== undefined) {
                        var imageUids = key.split("_");
                        imagePStates.some(function(o)
                        {
                            if(o.imageId === imageUids[0] && o.frameNumber == imageUids[1]) {
                                sessionType = 1;
                            }

                            return (sessionType == 1 ? true : false);
                        });
                    }
                }

                if(isDelete == true || isUpdate == true) {
                    var imageUids = key.split("_");
                    if(imagePStates !== undefined && sessionType == 1) {
                        imagePStates.some(function(o)
                        {
                            if(o.imageId === imageUids[0] && o.frameNumber == imageUids[1]) {
                                o.isDirty = true;
                                isDirty = true;
                            }

                            return isDirty;
                        });
                    } else if(imagePStates !== undefined) {
                        imagePStates.some(function(o)
                        {
                            if(o.isDirty == true) {
                                isDirty = true;
                            }

                            return isDirty;
                        });
                    }
                } else {
                    if(measurementType === "mitralGradient") {
                        measurement = dicomImageMitralGradientMeasurements[key][arrayIndex];
                    } else if (measurementType === "Trace") {
                        measurement = dicomImageTraceMeasurements[key][arrayIndex];
                    } else if (measurementType === "volume") {
                        measurement = dicomImageVolumeMeasurements[key][arrayIndex];
                    } else if (measurementType === "line" || measurementType === "point") {
                        measurement = dicomImageMeasurements[key][arrayIndex];
                    } else if (measurementType === "angle") {
                        measurement = dicomImageAngleMeasurements[key][arrayIndex];
                    } else if (measurementType === "ellipse") {
                        measurement = dicomImageEllipseMeasurements[key][arrayIndex];
                    } else if (measurementType === "rectangle") {
                        measurement = dicomImageRectangleMeasurements[key][arrayIndex];
                    }

                    if(Object.prototype.toString.call(measurement) === '[object Array]') {
                        measurement = measurement[0];
                    }

                    isDirty = (measurement.sessionType == 1 ? true : false);
                    if(imagePStates !== undefined && isDirty == true) {
                        var imageUids = key.split("_");
                        imagePStates.some(function(o)
                        {
                            if(o.imageId === imageUids[0] && o.frameNumber == imageUids[1]) {
                                o.isDirty = true;
                                return true;
                            }
                        });
                    }
                }

                if(!isDirty) {
                    isDirty = isNewPStateAddedInAnExistingPState(studyUid);
                }
            } else {
                isDirty = isNewPStateAddedInAnExistingPState(studyUid);
            }

            updateDirtyActivePState(studyDetails, studyDiv, isDirty);
        }
        catch(e)
        { }
    }

    /**
     * Check whether the measurement is dirty or not
     * @param {Type} values - Specifies the measurement values
     * @param {Type} studyUid - Specifies the study Uid
     */ 
    function isDirtyPState(values, studyUid) {
        try
        {
            var isDirty = false;
            values.some(function(o)
            {
                if(o.studyUid === studyUid && o.sessionType == 0) {
                    isDirty = true;
                }

                return isDirty;
            });
        }
        catch(e)
        { }

        return isDirty;
    }

    /**
     * update the dirty active presentation state
     * @param {Type} studyDetails - Specifies the study details
     * @param {Type} studyDiv - Specifies the study layout id
     * @param {Type} isDirty - Specifies the flag for dirty
     */ 
    function updateDirtyActivePState(studyDetails, studyLayoutId, isDirty) {
        try
        {
            var activePStateName = studyDetails.PStates.Active.name ;
            
            var selectedPStateId = 0;
            var menuId = "#loadPSSubmenu_"+studyLayoutId+"_";
            studyDetails.PStates.All.some(function(pState) {
                if(pState.id === studyDetails.PStates.Active.id) {
                    selectedPStateId = pState.menuId;
                    return true;
                }
            });

            var innerHtml = ($(menuId + selectedPStateId)[0].innerHTML).replace("*","");
            var updatedText = isDirty ? activePStateName+"<font color='red' size=4>*</font>" : "<font color='white'>"+activePStateName+"</font>";
            innerHtml = innerHtml.replace(studyDetails.PStates.Active.name,updatedText);
            $(menuId + selectedPStateId)[0].innerHTML = innerHtml;
            studyDetails.PStates.Active.isDirty = isDirty;
            dicomViewer.enableOrDisablePStatesMenu(studyDetails, studyLayoutId);

            return true;
        }
        catch(e)
        { }

        return false;
    }

    /**
     * Check whether the new PState is added in an existing PState
     * @param {Type} studyUid - Specifies the study Uid
     */ 
    function isNewPStateAddedInAnExistingPState(studyUid) {
        try
        {
            var isAdded = false;
            var allMeasurementPState = [];
            allMeasurementPState.push(dicomImageMeasurements);
            allMeasurementPState.push(dicomImageEllipseMeasurements);
            allMeasurementPState.push(dicomImageRectangleMeasurements);

            $.each(allMeasurementPState, function(key, values) {
                $.each(values, function(id, measurementArray) {
                    isAdded = isDirtyPState(measurementArray, studyUid);
                    return (isAdded == true ? false : true);
                });
                return (isAdded == true ? false : true);
            });

            if(isAdded) {
                return isAdded;
            }

            allMeasurementPState = [];
            allMeasurementPState.push(dicomImageAngleMeasurements);
            allMeasurementPState.push(dicomImageTraceMeasurements);
            allMeasurementPState.push(dicomImageMitralGradientMeasurements);
            allMeasurementPState.push(dicomImagePenMeasurements);

            $.each(allMeasurementPState, function(key, values) {
                $.each(values, function(id, measurementArray) {
                    measurementArray.some(function(o) {
                        isAdded = isDirtyPState(o, studyUid);
                        return isAdded;
                    });
                    return (isAdded == true ? false : true);
                });
                return (isAdded == true ? false : true);
            });

            if(isAdded) {
                return isAdded;
            }
        }
        catch(e)
        { }

        return false;
    }

    /**
     * Update the active PState description
     * @param {Type} description - Specifies the description
     */ 
    function updateActivePStateDescription(description) {
        try
        {
            var viewport = dicomViewer.getActiveSeriesLayout();
            if(viewport == undefined || viewport == null) {
                return;
            }

            var studyUid = viewport.studyUid;
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails == undefined || studyDetails == null) {
                return;
            }

            if(studyDetails.PStates == undefined || studyDetails.PStates == null) {
                return;
            }

            var isDirty = false;
            var activePState = studyDetails.PStates.Active;
            activePState.description = description;
            studyDetails.PStates.All.some(function(o) {
                if(activePState.description !== o.description && activePState.id == o.id) {
                    isDirty = true;
                    return true;
                }
            });

            studyDetails.PStates.Active.isDescriptionUpdated = isDirty;
            var imageRender = viewport.imageRenders;
            for (var key in imageRender) {
                var render = imageRender[key];
                var frameIndex = render.anUIDs.split("*")[1];
                updateDirtyPState(render.seriesLevelDivId,
                                  { key: render.imageUid + "_" + frameIndex },
                                  false,
                                  true);
            }
        }
        catch(e)
        { }
    }

    /**
     * update the new dirty active state
     * @param {Type} studyDetails - Specifies the study details
     */ 
    function updateNewDirtyActivePState(studyDetails) {
        try
        {
            if(studyDetails.PStates.Active.isNew !== true) {
                return;
            }

            studyDetails.PStates.Active.isDirty = !isEmptyPState(studyDetails.studyUid);
            if(studyDetails.PStates.All.length == 1 && studyDetails.PStates.Active.isDirty == false) {
                studyDetails.PStates = undefined;
            }

            dicomViewer.updatePState(studyDetails.studyUid);
        }
        catch(e)
        { }
    }

    /**
     * Check whether the PStates are empty or not
     * @param {Type} values - Specifies the measurement values
     * @param {Type} studyUid - Specifies the study Uid
     */ 
    function isEmptyPStates(values, studyUid) {
        try
        {
            var isEmpty = true;
            values.some(function(o)
            {
                if(o.studyUid === studyUid) {
                    isEmpty = false;
                }

                return (isEmpty == true ? false : true);
            });
        }
        catch(e)
        { }

        return isEmpty;
    }

    /**
     * Check whether the PState is empty or not
     * @param {Type} studyUid - Specifies the study Uid
     */ 
    function isEmptyPState(studyUid) {
        try
        {
            var isEmpty = true;
            var allMeasurementPState = [];
            allMeasurementPState.push(dicomImageMeasurements);
            allMeasurementPState.push(dicomImageEllipseMeasurements);
            allMeasurementPState.push(dicomImageRectangleMeasurements);

            $.each(allMeasurementPState, function(key, values) {
                if(jQuery.isEmptyObject(values)) {
                    return true;
                }

                $.each(values, function(id, measurementArray) {
                    if(jQuery.isEmptyObject(measurementArray)) {
                        return true;
                    }

                    isEmpty = isEmptyPStates(measurementArray, studyUid);
                    return isEmpty;
                });

                return isEmpty;
            });

            if(!isEmpty) {
                return isEmpty;
            }

            allMeasurementPState = [];
            allMeasurementPState.push(dicomImageAngleMeasurements);
            allMeasurementPState.push(dicomImageTraceMeasurements);
            allMeasurementPState.push(dicomImageMitralGradientMeasurements);
            allMeasurementPState.push(dicomImagePenMeasurements);

            $.each(allMeasurementPState, function(key, values) {
                if(jQuery.isEmptyObject(values)) {
                    return true;
                }

                $.each(values, function(id, measurementArray) {
                    if(jQuery.isEmptyObject(measurementArray)) {
                        return true;
                    }

                    measurementArray.some(function(o) {
                        isEmpty = isEmptyPStates(o, studyUid);
                        return (isEmpty == true ? false : true);
                    });

                    return isEmpty;
                });

                return isEmpty;
            });

            if(!isEmpty) {
                return isEmpty;
            }
        }
        catch(e)
        { }

        return true;
    }

    /**
     * Return the position(i.e. left, right or top-left) of the hounsfield measurement text
     * @param {Type} data - Start and End value of the hounsfield shape(Ellipse/Rectangle)
     */
    function hounsfieldTextPosition(data, renderer) {
        startPoint = {
                x : Math.min(data.start.x, data.end.x),
                y : Math.min(data.start.y, data.end.y)
        };
        var pos = "right";
        var widget = renderer.getRenderWidget();
        if((startPoint.x >= widget.width/2) && (startPoint.y >= widget.height/2)) {
            pos = "top-left";
        } else if(startPoint.y >= widget.height/2) {
            pos = "top";
        } else if(startPoint.x >= widget.width/2) {
            pos = "left";
        }
        return pos;
    }

     /**
     * Return the position(i.e. left, right or top-left) of the hounsfield measurement text
     * @param {Type} data - Start and End value of the point, angle shape(Point/Angle)
     */
    function pointTextPosition(data, renderer) {
        startPoint = {
                x : data.start.x,
                y : data.start.y
        };
        var pos = "right";
        var widget = renderer.getRenderWidget();
        if((startPoint.x >= widget.width/3) && (startPoint.y >= widget.height/2)) {
            pos = "top-left";
        } else if(startPoint.y >= widget.height/2) {
            pos = "top";
        } else if(startPoint.x >= widget.width/3) {
            pos = "left";
        }
        return pos;
    }
    
    /**
     * set the flag if measurement is edited
     */ 
    function isEditMeasurement() {
        return isMeasurementEdit;
    }

    /**
     * Get the pstate display name
     * @param {Type} pState - Specifies the pstate
     */ 
    //function getPStateDisplayName(pState) {
    //    var displayName = pState.userId + " - " + (pState.isExternal ?  pState.description : pState.dateTime);

    //    try
    //    {
    //        if(pState.userDetails) {
    //            var displayPrefix = pState.userId;
    //            if(pState.userDetails.initials) {
    //                displayPrefix = pState.userDetails.initials;
    //            } else if(pState.userDetails.name) {
    //                displayPrefix = pState.userDetails.name;
    //            }

    //            displayName = displayPrefix + " - " + (pState.isExternal ?  pState.description : pState.dateTime);
    //        }
    //    }
    //    catch(e)
    //    { }

    //    return displayName;
    //}

    /**
     * Add the drawn measurements
     * @param {Type} imageUid 
     * @param {Type} frameIndex 
     * @param {Type} imageRenderer 
     * @param {Type} mosueData 
     * @param {Type} context 
     */ 
    function addPenMeasurements(imageUid, frameIndex, imageRenderer, mosueData, context) {
        removeTempdata();
        if (imageRenderer === undefined) {
            throw "addMitralGradientMeasurements : imageRenderer is null/undefined";
        }

        var penMeasurements = dicomImagePenMeasurements[imageUid + "_" + frameIndex];

        if(penMeasurements === undefined) {
            penMeasurements = [];
        }
        var measurements = penMeasurements[mosueData.measurementIndex];
        if (measurements === undefined) {
            measurements = [];
        }
        var imageData = getImageDataForMouseData(mosueData, imageRenderer, context);
        var measureLength = measurements.length;
        measurements[measureLength] = imageData;
        if (!mitralMeanGradientMeasurementEnd) {
            for (i = 0; i < measureLength; i++) {
                measurements[i].editMode = false;
            }
        }
        penMeasurements[mosueData.measurementIndex] = measurements;
        dicomImagePenMeasurements[imageUid + "_" + frameIndex] = penMeasurements;

        mosueData = undefined; // Release the memory for the data 
        imageData = undefined; // Release the memory for the data

        updateDirtyPState(imageRenderer.seriesLevelDivId);
    }
    
    /**
     * Get the drawn measuremnts
     * @param {Type} imageUid 
     * @param {Type} frameIndex 
     */ 
    function getPenMeasurements(imageUid, frameIndex) {
        if (imageUid === undefined) {
            throw "getMitralGradientMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "getMitralGradientMeasurements : frameIndex is null/undefined";
        }
        return dicomImagePenMeasurements[imageUid + "_" + frameIndex];
    }

    /**
     * Find the mouse postion is near the drawn pen measurement to delete.
     * @param {Type} mouseData 
     * @param {Type} imageRenderer 
     */ 
    function findPenToDelete(mouseData, imageRenderer){
        isPenDelete = true;
        activeImageRenderer = undefined;
        removeTempdata();
        var measurementKey = imageRenderer.anUIDs.replace("*","_");

        var penMeasurements = dicomImagePenMeasurements[measurementKey];
        if (penMeasurements !== undefined) {
            for (var n = 0; n < penMeasurements.length; n++) {
                var measurements = penMeasurements[n];
                if (measurements !== undefined) {
                    for (var m = 0; m < measurements.length; m++) {
                        var data = measurements[m];
                        if (data !== undefined && data.measureType == "pen") {
                            var originalLineDistance = getLength(data);

                            var tempData = {
                                start: {
                                    x: data.start.x,
                                    y: data.start.y
                                },
                                end: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                measureType: "pen"
                            };
                            var firstDistance = getLength(tempData);

                            var tempData2 = {
                                start: {
                                    x: mouseData.x,
                                    y: mouseData.y
                                },
                                end: {
                                    x: data.end.x,
                                    y: data.end.y
                                },
                                measureType: "pen"
                            };

                            var secondDistance = getLength(tempData2);

                            var totalDistance = parseInt(firstDistance) + parseInt(secondDistance);
                            if (Math.abs(totalDistance - originalLineDistance) < 5) {
                                dataToDelete.measurmentType = "pen";
                                dataToDelete.key = measurementKey;
                                dataToDelete.arryIndex = n;
                                dataToDelete.isEditable = data.isEditable;
                                dataToDelete.sessionType = data.sessionType;
                                activeImageRenderer = imageRenderer;
                                return;
                            }
                        }
                    }
                }
            }
        }

        if (activeImageRenderer === undefined && isLineDeleteCheck === false) {
            findLineToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isPointDeleteCheck === false) {
            findPointToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isTraceDeleteCheck === false) {
            findTraceToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isVolumeDeleteCheck === false) {
            findVolumeToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isAngleDeleteCheck === false) {
            findAngleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isEllipseDeleteCheck === false) {
            findEllipseToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined && isRectangleDeleteCheck === false) {
            findRectangleToDelete(mouseData, imageRenderer)
        } else if (activeImageRenderer === undefined) {
            dataToDelete = {
                measurmentType: "",
                key: "",
                arryIndex: "",
                isEditable: "",
                sessionType: 0
            };
        }
    }

    var PenMeasurementId = -1;
    /**
     * set the no.of measuremts drawn in pen.
     * @param {Type} Id -  it specifies the integer.
     */ 
    function setPenMeasurementId(Id) {
        PenMeasurementId = Id;
    }

    /**
    * get the count of the drawn measurements
    */ 
    function getPenMeasurementId() {
        return PenMeasurementId;
    }

    /**
     * Update the pen measurements in to the array
     * @param {Type} mouseData 
     * @param {Type} imageRenderer 
     * @param {Type} context 
     * @param {Type} dataToEdit 
     */ 
    function updatePenintoArray(mouseData, imageRenderer, context, dataToEdit) {
        var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(mouseData, imageRenderer, context);
        var i;
        var data = undefined;
        var key = dataToEdit.key;
        var arrayIndex = dataToEdit.arryIndex;
        var parentDiv = $('#'+imageRenderer.parentElement).parent().closest('div').attr('id');
        var measurements = dicomImagePenMeasurements[key];

        if(measurements === undefined)
            return;

        updateDirtyPState(imageRenderer.seriesLevelDivId, dataToEdit);
        measurements = measurements[arrayIndex];
        data = dicomImagePenMeasurements[key][arrayIndex];
        for (var index = indexToEditMitral; index < data.length; index++) {
            var tempData = data[index];
            if (tempData !== undefined) {
                var isNearToStartPoint = findNearHanleByPoint(imageData, tempData.start);
                if (isNearToStartPoint && index == 0) {
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    indexToEditMitral = index;
                    index = data.length;
                } 
                else if (isNearToStartPoint && index == data.length - 1 && tempData.measurementSubType == "pen"){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    tempData.end.x = imageData.x;
                    tempData.end.y = imageData.y;
                    data[index - 1].end.x = imageData.x;
                    data[index - 1].end.y = imageData.y;
                    dicomImageMitralGradientMeasurements[key][arrayIndex] = data;
                    indexToEditMitral = index;
                    index = data.length;
                } else if (isNearToStartPoint){
                    tempData.start.x = imageData.x;
                    tempData.start.y = imageData.y;
                    data[index - 1].end.x = imageData.x;
                    data[index - 1].end.y = imageData.y;
                    dicomImagePenMeasurements[key][arrayIndex] = data;
                    indexToEditMitral = index;
                    index = data.length;
                }
            }
            tempData.editMode = true;
        }
    }

    /**
     * Load the Mitral Gradient measurement
     * @param {Type} imageKey - Specifies the image key
     * @param {Type} measurementKey - Specifies the measurement key* 
     * @param {Type} measurement - Specifies the measurement array
     * @param {Type} isEditable - Specifies the flag to edit the measurement/annotation
     */ 
    function loadPenMeasurement(imageKey, measurementKey, measurement, isEditable) {
        try
        {
            if(imageKey === undefined || measurement === undefined) {
                // Invalid input parameters
                return;
            }

            var points = measurement.points;
            if(points === undefined || points === null || points.length == 0) {
                return;
            }

            var measurementSubType = undefined;
            var measurementType = undefined;

            switch(measurementKey) {
                case MT_PEN:
                    measurementSubType = "pen";
                    measurementType = 15;
                    break;
            }

            var penMeasurements = dicomImagePenMeasurements[imageKey];
            if (penMeasurements === undefined) {
                penMeasurements = [];
            }

            var measurementId = penMeasurements.length;
            var measurements = penMeasurements[measurementId];
            if (measurements === undefined) {
                measurements = [];
            }

            var start = {};
            var end = {};
            for(var index = 0; index < points.length; index+=4) {
                var start = 
                    {
                        handleActive: false,
                        x: parseFloat(points[index]),
                        y: parseFloat(points[index+1])
                    };

                var end =
                    {
                        handleActive: false,
                        x: parseFloat(points[index+2]),
                        y: parseFloat(points[index+3])
                    };

                var measurementData =
                    {
                        start: start,
                        end: end,
                        measureType: "pen",
                        measurementSubType: measurementSubType,
                        measurementId: measurementId,
                        measurementComplete: true,
                        measurementType: measurementType,
                        measurementUnits: undefined,
                        editMode: false,
                        studyUid: measurement.studyUid,
                        isEditable: isEditable,
                        sessionType: 1,
                        style : getGrpahicStyle(measurement)
                    };

                measurements.push(measurementData);
            }

            penMeasurements[measurementId] = measurements;
            dicomImagePenMeasurements[imageKey] = penMeasurements;
        }
        catch(e)
        { }
    }

    dicomViewer.measurement = {
        getMeasurements: getMeasurements,
        addMeasurements: addMeasurements,
        updateMeasurements: updateMeasurements,
        getTraceMeasurements: getTraceMeasurements,
        addTraceMeasurements: addTraceMeasurements,
        updateTraceMeasurements: updateTraceMeasurements,
        getEllipseMeasurements: getEllipseMeasurements,
        addEllipseMeasurements: addEllipseMeasurements,
        updateEllipseMeasurements: updateEllipseMeasurements,
        updateTraceIntoArray: updateTraceIntoArray,
        updateAngleIntoArray: updateAngleIntoArray,
        getVolumeMeasurements: getVolumeMeasurements,
        addVolumeMeasurements: addVolumeMeasurements,
        addMitralGradientMeasurements: addMitralGradientMeasurements,
        getMitralGradientMeasurements: getMitralGradientMeasurements,
        removeAllMeasurements: removeAllMeasurements,
        setTempData: setTempData,
        getTempData: getTempData,
        findNearHandle: findNearHandle,
        getMouseDataForImageData: getMouseDataForImageData,
        getImageDataForMouseData: getImageDataForMouseData,
        getCanvasDataForImageData: getCanvasDataForImageData,
        setImageContext: setImageContext,
        getImageContext: getImageContext,
        setLineMeasurementEnd: setLineMeasurementEnd,
        setTraceMeasurementEnd: setTraceMeasurementEnd,
		setVolumeMeasurementEnd: setVolumeMeasurementEnd,
        setMitralMeanGradientMeasurementEnd: setMitralMeanGradientMeasurementEnd,
        isLineMeasurementEnd: isLineMeasurementEnd,
        isTraceMeasurementEnd: isTraceMeasurementEnd,
        isVolumeMeasurementEnd: isVolumeMeasurementEnd,
        isMitralMeanGradientMeasurementEnd: isMitralMeanGradientMeasurementEnd,
        setTraceMeasurementId: setTraceMeasurementId,
        setMitralMeanGradientMeasurementId: setMitralMeanGradientMeasurementId,
        getTraceMeasurementId: getTraceMeasurementId,
        setVolumeMeasurementId: setVolumeMeasurementId,
        getVolumeMeasurementId: getVolumeMeasurementId,
        getMitralMeanGradientMeasurementId: getMitralMeanGradientMeasurementId,
		updateMitralMeanGradientintoArray: updateMitralMeanGradientintoArray,
        findLineToDelete: findLineToDelete,
        findPointToDelete: findPointToDelete,
        findAngleToDelete: findAngleToDelete,
        findTraceToDelete: findTraceToDelete,
		findMitralToDelete: findMitralToDelete,
        deleteSelectedMeasurment: deleteSelectedMeasurment,
        findVolumeToDelete: findVolumeToDelete,
        resetMeasurementFlag: resetMeasurementFlag,
        setDataToEdit: setDataToEdit,
        getDataToEdit: getDataToEdit,
        getDataToDelete: getDataToDelete,
        findNearHandleToEdit: findNearHandleToEdit,
		resetHandeler : resetHandeler,
		removeTempdata : removeTempdata,
        updateVolumeintoArray : updateVolumeintoArray,
		setDataToDelete : setDataToDelete,
        isMeasurementBroken : isMeasurementBroken,
        setMeasurementBroken : setMeasurementBroken,
        getAngleMeasurements: getAngleMeasurements,
        setAngleMeasurementEnd: setAngleMeasurementEnd,
        isAngleMeasurementEnd: isAngleMeasurementEnd,
        setAngleMeasurementId: setAngleMeasurementId,
        getAngleMeasurementId: getAngleMeasurementId,
        addAngleMeasurements: addAngleMeasurements,
        resetMousePressedCounter: resetMousePressedCounter,
        getMousePressedCounter: getMousePressedCounter,
        increaseMousePressedCounter: increaseMousePressedCounter,
		setCoordinate: setCoordinate,
        getCoordinate: getCoordinate,
        findEllipseToDelete: findEllipseToDelete,
        getDefaultLineMeasurementUnit:getDefaultLineMeasurementUnit,
        isCalibratePixelSpacing : isCalibratePixelSpacing,
        resetEllipseEditMode: resetEllipseEditMode,
        resetAngleEditMode: resetAngleEditMode,
        resetTraceEditMode: resetTraceEditMode,
        resetMitralEditMode: resetMitralEditMode,
        getRectangleMeasurements: getRectangleMeasurements,
        addRectangleMeasurements: addRectangleMeasurements,
        updateRectangleMeasurements: updateRectangleMeasurements,
        resetRectangleEditMode: resetRectangleEditMode,
        findRectangleToDelete: findRectangleToDelete,
        savePState: savePState,
        loadPState: loadPState,
        editPState: editPState,
        updateMeasurementTextData: updateMeasurementTextData,
        newPState: newPState,
        deletePState: deletePState,
        saveOrDeleteUnSavedPState: saveOrDeleteUnSavedPState,
        getSessionType: getSessionType,
        setSessionType: setSessionType,
        isMeasurementDrawable: isMeasurementDrawable,
        updateActivePStateDescription : updateActivePStateDescription,
        hounsfieldTextPosition : hounsfieldTextPosition,
        isEditMeasurement : isEditMeasurement,
        showAndHideSplashWindow : showAndHideSplashWindow,
        pointTextPosition: pointTextPosition,
        setPenToolEnd : setPenToolEnd,
        isPenToolEnd : isPenToolEnd,
        addPenMeasurements: addPenMeasurements,
        getPenMeasurements: getPenMeasurements,
        findPenToDelete: findPenToDelete,
        updatePenintoArray: updatePenintoArray,
        getPenMeasurementId: getPenMeasurementId,
        setPenMeasurementId: setPenMeasurementId
    }

    return dicomViewer;
}(dicomViewer));/**
 * New node file
 */
var dicomViewer = (function(dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var lineStatus = "added";

    var physicalUnitsXYDirectionArray = ["none", "%", "dB", "cm", "sec", "hertz", "dB/sec", "cm/sec", "cm\u00B2", "cm\u00B2/sec", "cm\u00B3", "cm\u00B3/sec", "\u00B0"];
    
    var measurementId = null;

    var measurementType = -1;

    var measurementUnits = null;

    var measurementStyle = {
        lineColor : "#00FFFF",
        lineWidth : 1,
        textColor: "#00FFFF",
        isBold: false,
        isItalic: false,
        fontName: "Arial",
        fontSize: 12
    };

    var smoothConfig = {
        method: 'cubic',
        clip: 'periodic',
        lanczosFilterSize: 2,
        cubicTension: 0
      };

    /**
     *Set the Display measurement style
     */
    function setMeasurementStyle(measureStyle) {
        try
        {
            measurementStyle = measureStyle;
        }
        catch(e)
        { }
    }

    function isValidPixelSpacing(pixelSpacing) {
        if (pixelSpacing !== undefined && pixelSpacing !== null) {
            return true;
        }
        return false;
    }

    function drawMeasurements(imageUid, frameIndex, context, presentation, imageRenderer) {

		var displayMeasurement = false;
		
        if (imageUid === undefined) {
            throw "drawMeasurements: imageUid is null/undefined";
        }
        if (frameIndex === undefined) {
            throw "drawMeasurements : frameIndex is null/undefined";
        }
        var parentDiv = $('#' + imageRenderer.parentElement).parent().closest('div').attr('id');
        /*if(isFullScreenEnabled){
            parentDiv = previousLayoutSelection;
        }*/
        if (parentDiv === undefined)
            return;
        var tempData = dicomViewer.measurement.getTempData();
        if (parentDiv === dicomViewer.getActiveSeriesLayout().getSeriesLayoutId() && tempData) {
            var tool = dicomViewer.mouseTools.getActiveTool();
            var activeImageUid = undefined;
            if (tool) {
                var activeImageRenderer = tool.getActiveImageRenderer();
                if(activeImageRenderer) {
                    activeImageUid = activeImageRenderer.anUIDs.split("*")[0];
                }
            }
            if (tempData.measureType === "linedelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findLineToDelete(imageData, imageRenderer);
            } else if (tempData.measureType === "pointdelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context, parentDiv);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findPointToDelete(imageData, imageRenderer);
            }else if (tempData.measureType === "angledelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context, parentDiv);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findAngleToDelete(imageData, imageRenderer);
            }else if (tempData.measureType === "ellipsedelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context, parentDiv);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findEllipseToDelete(imageData, imageRenderer);
            }else if (tempData.measureType === "rectangledelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context, parentDiv);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findRectangleToDelete(imageData, imageRenderer);
            } else if (tempData.measureType === "WindowLevelROIdelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context, parentDiv);
                dicomViewer.measurement.resetMeasurementFlag();
            } else if (tempData.measureType === "tracedelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findTraceToDelete(imageData, imageRenderer);
            } else if (tempData.measureType === "volumedelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findVolumeToDelete(imageData, imageRenderer);
            } else if (tempData.measureType === "mitralGradientdelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findMitralToDelete(imageData, imageRenderer);
            } else if (tempData.measureType === "pendelete") {
                var imageData = dicomViewer.measurement.draw.getImageCoordinatesForMousePoint(tempData, imageRenderer, context);
                dicomViewer.measurement.resetMeasurementFlag();
                dicomViewer.measurement.findPenToDelete(imageData, imageRenderer);
            } else if (tempData.measureType === "line") {
                lineStatus = "added";
                var measurementResult;
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    dicomViewer.measurement.updateMeasurements(dataToEdit, imageRenderer, tempData, context);
                    var editPoint = dicomViewer.measurement.findNearHandleToEdit(tempData.start, imageRenderer, context, dataToEdit); //dicomViewer.measurement.findNearHandleToEdit(tempData.start, imageRenderer, context, dataToEdit);
                    if (editPoint !== undefined) {
                        if (editPoint.start.handleActive) {
                            tempData.start.x = editPoint.start.x;
                            tempData.start.y = editPoint.start.y;
                        } else if (editPoint.end.handleActive) {
                            tempData.end.x = editPoint.end.x;
                            tempData.end.y = editPoint.end.y;
                        }
                        lineStatus = "modified";
                        dicomViewer.measurement.updateMeasurements(dataToEdit, imageRenderer, tempData, context);
                    }
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    if(activeImageUid == imageUid) {
                        measurementResult = drawLineMeasurement(imageUid, context, imageData, presentation, imageRenderer);
                    }
                }
                if (dicomViewer.measurement.isLineMeasurementEnd() && lineStatus === "added") {
                    if (measurementResult != null) {
                        sendMeasurement(measurementResult.id, measurementResult.value);
                    }
                    var lengthOfTemp = parseFloat(getLengthText(tempData))
                    if (lengthOfTemp > 0.05)
                        dicomViewer.measurement.addMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
						if (dicomViewer.tools.getFlagFor2dLengthCalibration()) {
                        var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                        var coordinate = {
                             start: imageData.start,
                             end: imageData.end
                         };
                         dicomViewer.measurement.setCoordinate(coordinate);
                    }
                }
            } 
            else if (tempData.measureType === "ellipse")
            {
                lineStatus = "added";
                var measurementResult;
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updateEllipseMeasurements(dataToEdit, imageRenderer, tempData, context);
                    lineStatus = "modified";
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    if(activeImageUid == imageUid) {
                        measurementResult = drawEllipseMeasurement(imageUid, context, imageData, presentation, imageRenderer, undefined, dicomViewer.measurement.isLineMeasurementEnd() ? false : true);
                    }
                }
                if (dicomViewer.measurement.isLineMeasurementEnd() && lineStatus === "added") {                    
                    var lengthOfTemp = parseFloat(getLengthText(tempData));
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    measurementResult = drawEllipseMeasurement(imageUid, context, imageData, presentation, imageRenderer, true, false);              
                    if (lengthOfTemp > 0.05)
                        dicomViewer.measurement.addEllipseMeasurements(imageUid, frameIndex, imageRenderer, tempData, context, measurementResult);
                }
            } else if (tempData.measureType === "rectangle") {
                lineStatus = "added";
                var measurementResult;
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updateRectangleMeasurements(dataToEdit, imageRenderer, tempData, context);
                    lineStatus = "modified";
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    if(activeImageUid == imageUid) {
                        measurementResult = drawRectangleMeasurement(imageUid, context, imageData, presentation, imageRenderer, undefined, dicomViewer.measurement.isLineMeasurementEnd() ? false : true);
                    }
                }
                if (dicomViewer.measurement.isLineMeasurementEnd() && lineStatus === "added") {                    
                    var lengthOfTemp = parseFloat(getLengthText(tempData));
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    measurementResult = drawRectangleMeasurement(imageUid, context, imageData, presentation, imageRenderer, true, false);              
                    if (lengthOfTemp > 0.05)
                        dicomViewer.measurement.addRectangleMeasurements(imageUid, frameIndex, imageRenderer, tempData, context, measurementResult);
                }
            } else if (tempData.measureType === "WindowLevelROI") {
                lineStatus = "added";
                var measurementResult;
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    lineStatus = "modified";
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    measurementResult = drawWindowLevelROIMeasurement(imageUid, context, imageData, presentation, imageRenderer, undefined);
                }
                if (dicomViewer.measurement.isLineMeasurementEnd() && lineStatus === "added") {
                    var lengthOfTemp = parseFloat(getLengthText(tempData));
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    measurementResult = drawWindowLevelROIMeasurement(imageUid, context, imageData, presentation, imageRenderer, true);
                }

                if( !dicomViewer.tools.isShowAnnotationandMeasurement()) {
                    return;
                }
            } else if (tempData.measureType === "point") {
                lineStatus = "added";
                var measurementResult;
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    dicomViewer.measurement.updateMeasurements(dataToEdit, imageRenderer, tempData, context);
                    var editPoint = dicomViewer.measurement.findNearHandleToEdit(tempData.start, imageRenderer, context, dataToEdit);
                    if (editPoint !== undefined) {
                        if (editPoint.start.handleActive) {
                            tempData.start.x = editPoint.end.x;
                            tempData.start.y = editPoint.end.y;
                        } else if (editPoint.end.handleActive) {
                            tempData.start.x = editPoint.start.x;
                            tempData.start.y = editPoint.start.y;
                        }
                        lineStatus = "modified";
                    }
                } else {                    
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    measurementResult = drawPointMeasurement(imageUid, context, imageData, presentation, imageRenderer);
                }

                if (dicomViewer.measurement.isLineMeasurementEnd() && lineStatus === "added") {
                    if (measurementResult != null) {
                        //console.log("Line has been " + lineStatus + " with start point x = " + (imageCoordinate.start.x).toFixed(2) + " y = " + (imageCoordinate.start.y).toFixed(2) + " and end point x = " + (imageCoordinate.end.x).toFixed(2) + " y = " + (imageCoordinate.end.y).toFixed(2) + ". length of line is " + length);
                        //console.log("" + measurementResult.id + ":" + measurementResult.value);
                        sendMeasurement(measurementResult.id, measurementResult.value);
                    }
                    dicomViewer.measurement.addMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
                }
            } else if (tempData.measureType === "trace") {
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updateTraceIntoArray(tempData.end, imageRenderer, context, dataToEdit);
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    if(activeImageUid == imageUid) {
                        var measurementResult = drawTraceMeasurement(imageUid, context, imageData, presentation, imageRenderer, false, undefined, undefined, dicomViewer.measurement.isTraceMeasurementEnd() ? true : false);
                    }

                    if (dicomViewer.measurement.isLineMeasurementEnd()) {
                        lineStatus = "added";
                        dicomViewer.measurement.addTraceMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
                    }
                }
            } else if (tempData.measureType === "angle") {
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updateAngleIntoArray(tempData.end, imageRenderer, context, dataToEdit);                    
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    imageData.textPosition = tempData.textPosition;
                    if(activeImageUid == imageUid) {
                        var measurementResult = drawAngleMeasurement(imageUid, context, imageData, presentation, imageRenderer, dicomViewer.measurement.isAngleMeasurementEnd() ? true : false);
                    }

                    if (dicomViewer.measurement.isLineMeasurementEnd()) {
                        lineStatus = "added";
                        dicomViewer.measurement.addAngleMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
                    }
                }
            } else if (tempData.measureType === "volumeeditmove") {
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updateVolumeintoArray(tempData.end, imageRenderer, context, dataToEdit);

                    updateDynamicVolumes(tempData, imageUid, imageData, frameIndex, parentDiv, presentation, context, imageRenderer);
                }
            } else if (tempData.measureType === "volume") {
                var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                var measurementResult = drawLineMeasurement(imageUid, context, imageData, presentation, imageRenderer);

                if (!dicomViewer.measurement.isVolumeMeasurementEnd()) {
                    updateDynamicVolumes(tempData, imageUid, imageData, frameIndex, parentDiv, presentation, context, imageRenderer);
                } else if (dicomViewer.measurement.isLineMeasurementEnd()) {
                    lineStatus = "added";
                    dicomViewer.measurement.addVolumeMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
                }
            } else if (tempData.measureType === "mitralGradient") {
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updateMitralMeanGradientintoArray(tempData.end, imageRenderer, context, dataToEdit);                    
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    var isMeasurementEnd = dicomViewer.measurement.isMitralMeanGradientMeasurementEnd() ? true : false;
                    imageData.textPosition = tempData.textPosition;
                    if(activeImageUid == imageUid) {
                        if(imageData.measurementSubType === "freehand") {
                            drawFreeHandMeasurement(imageUid, context, imageData, presentation, imageRenderer, false, isMeasurementEnd, undefined);
                        } else {
                            drawMitralMeanGradientMeasurement(imageUid, context, imageData, presentation, imageRenderer, false, undefined, isMeasurementEnd);
                        }
                    }

                    if (dicomViewer.measurement.isLineMeasurementEnd()) {
                        lineStatus = "added";
                        dicomViewer.measurement.addMitralGradientMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
                    } else {
                        var mitralMeasurements = dicomViewer.measurement.getMitralGradientMeasurements(imageUid, frameIndex);
                        if(mitralMeasurements != undefined && mitralMeasurements[tempData.measurementIndex] == undefined) displayMeasurement = true;

                    }
                }
            } else if (tempData.measureType === "pen") {
                var dataToEdit = dicomViewer.measurement.getDataToEdit();
                if (dataToEdit != undefined) {
                    tempData.measurementId = dataToEdit.arryIndex;
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    dicomViewer.measurement.updatePenintoArray(tempData.end, imageRenderer, context, dataToEdit);
                } else {
                    var imageData = dicomViewer.measurement.getImageDataForMouseData(tempData, imageRenderer, context);
                    var isMeasurementEnd = dicomViewer.measurement.isPenToolEnd() ? true : false;
                    if(activeImageUid == imageUid) {
                        if(imageData.measurementSubType === "pen") {
                            drawPenMeasurement(imageUid, context, imageData, presentation, imageRenderer, isMeasurementEnd);
                        }
                    }
                    dicomViewer.measurement.addPenMeasurements(imageUid, frameIndex, imageRenderer, tempData, context);
                }
            }
        }

        var measurements = dicomViewer.measurement.getMeasurements(imageUid, frameIndex);
        if (measurements !== undefined && measurements.length !== 0) {
            for (var i = 0; i < measurements.length; i++) {
                var data = measurements[i];
                if (data !== undefined) {
                    if (data.measureType === "line") {
                        var dataToEdit = dicomViewer.measurement.getDataToEdit();
                        if (dataToEdit != undefined && i != dataToEdit.arryIndex) {
                            data.end.handleActive = false;
                            data.start.handleActive = false;
                        }
                        if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                            drawLineMeasurement(imageUid, context, data, presentation, imageRenderer);
                        }
                    } else if (data.measureType === "point") {
                        var dataToEdit = dicomViewer.measurement.getDataToEdit();
                        if(dataToEdit != undefined) {
                            if(i != dataToEdit.arryIndex) {
                                data.end.handleActive = false;
                                data.start.handleActive = false;
                            } else {
                                //while editing point measurement, again updating the position of the text for the selected point
                                data.textPosition = dicomViewer.measurement.pointTextPosition(data, imageRenderer);
                            }
                        }
                        if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                            drawPointMeasurement(imageUid, context, data, presentation, imageRenderer);
                        }
                    }
                }
            }
        }
        
        var ellipseMeasurements = dicomViewer.measurement.getEllipseMeasurements(imageUid, frameIndex);
        if (ellipseMeasurements !== undefined && ellipseMeasurements.length !== 0) {
            var measurementResult = undefined;
            for (var i = 0; i < ellipseMeasurements.length; i++) {
                measurements = ellipseMeasurements[i];
                var dataResultX = 0;
                var dataResultY = 0;
                if (measurements !== undefined) {                    
                    if (measurements.measureType === "ellipse") {
                        if (dicomViewer.measurement.isMeasurementDrawable(measurements.sessionType)) {
                            drawEllipseMeasurement(imageUid, context, measurements, presentation, imageRenderer, (measurements.editMode) ? undefined : true, measurements.editMode);
                        }
                    }
                }
            }
        }
        
        var rectangleMeasurements = dicomViewer.measurement.getRectangleMeasurements(imageUid, frameIndex);
        if (rectangleMeasurements !== undefined && rectangleMeasurements.length !== 0) {
            var measurementResult = undefined;
            for (var i = 0; i < rectangleMeasurements.length; i++) {
                measurements = rectangleMeasurements[i];
                var dataResultX = 0;
                var dataResultY = 0;
                if (measurements !== undefined) {                    
                    if (measurements.measureType === "rectangle") {
                        if (dicomViewer.measurement.isMeasurementDrawable(measurements.sessionType)) {
                            drawRectangleMeasurement(imageUid, context, measurements, presentation, imageRenderer, (measurements.editMode) ? undefined : true, measurements.editMode,measurements.editMode);
                        }
                    }
                }
            }
        }

        var traceMeasurements = dicomViewer.measurement.getTraceMeasurements(imageUid, frameIndex);

        if (traceMeasurements !== undefined && traceMeasurements.length !== 0) {
            var measurementResult = undefined;
            for (var i = 0; i < traceMeasurements.length; i++) {
                measurements = traceMeasurements[i];
                var dataResultX = 0;
                var dataResultY = 0;
                if (measurements !== undefined && measurements.length !== 0) {
                    for (var j = 0; j < measurements.length; j++) {
                        var data = measurements[j];
                        if (data.measureType === "trace") {
                            if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                                dataResultX = parseInt(dataResultX) + parseInt((data.start.x).toFixed(0));
                                dataResultY = parseInt(dataResultY) + parseInt((data.start.y).toFixed(0));
                                var averageX = (parseInt(dataResultX) / (j + 1)).toFixed(0);
                                var averageY = (parseInt(dataResultY) / (j + 1)).toFixed(0);
                                var display = false;
                                if (j === measurements.length - 1) display = true;
                                measurementResult = drawTraceMeasurement(imageUid, context, data, presentation, imageRenderer, display, averageX, averageY, data.editMode);
                            }
                        }
                    }
                }
            }
            if (measurementResult != undefined)
                sendMeasurement(measurementResult.id, measurementResult.value);
        }
        
        // Angle measurement
         var angleMeasurements = dicomViewer.measurement.getAngleMeasurements(imageUid, frameIndex);

        if (angleMeasurements !== undefined && angleMeasurements.length !== 0) {
            var measurementResult = undefined;
            for (var i = 0; i < angleMeasurements.length; i++) {
                measurements = angleMeasurements[i];
                if (measurements !== undefined && measurements.length !==0) {
                    for (var j = 0; j < measurements.length; j++) {
                        var data = measurements[j]; 
                        if (data.measureType === "angle") {
                            if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                                measurementResult = drawAngleMeasurement(imageUid, context, data, presentation, imageRenderer, data.editMode);
                            }
                        }
                    }
                    
                    for(var iIndex=0; iIndex < measurements.length-1; iIndex++){
                        var firstLine = measurements[iIndex];
                        var secondLine = measurements[iIndex+1];
                        var endPoint;
                       	var centerPoint = {
                                x:firstLine.end.x.toFixed(0),
                                y:firstLine.end.y.toFixed(0)
                            };
                            var startPoint = {
                                x:firstLine.start.x.toFixed(0),
                                y:firstLine.start.y.toFixed(0)
                            };
                        if ((firstLine.end.x.toFixed(0) == secondLine.end.x.toFixed(0))&&
	                        (firstLine.end.y.toFixed(0) == secondLine.end.y.toFixed(0))){
                            endPoint = {
                                x:secondLine.start.x.toFixed(0),
                                y:secondLine.start.y.toFixed(0)
                            };
                        } else{
                            endPoint = {
                                x:secondLine.end.x.toFixed(0),
                                y:secondLine.end.y.toFixed(0)
                            };
                        }
                        var angleValue = calculateAngle(startPoint,endPoint,centerPoint);
                        if (dicomViewer.measurement.isMeasurementDrawable(measurements.sessionType)) {
                            drawAngleValue(context,firstLine,secondLine,imageRenderer,presentation,angleValue,"o");
                        }
                    }
                }
            }
        }
        
        var volumeMeasurements = dicomViewer.measurement.getVolumeMeasurements(imageUid, frameIndex);

        if (volumeMeasurements !== undefined && volumeMeasurements.length !== 0) {
            for (var i = 0; i < volumeMeasurements.length; i++) {
                measurements = volumeMeasurements[i];
                if (measurements !== undefined && measurements.length !== 0) {
                    var dataToEdit = dicomViewer.measurement.getDataToEdit();
                    var isQualifyforEdit = (dataToEdit !== undefined && (i === dataToEdit.arryIndex));
                    var data;
                    for (var j = 0; j < measurements.length; j++) {
                        data = measurements[j];
                        if (data.measureType === "volume") {
                            drawLineWithoutMeasurement(imageUid, context, data, presentation, imageRenderer, false, isQualifyforEdit);
                        }
                    }
                    if (!(i == volumeMeasurements.length - 1 && dicomViewer.measurement.isVolumeMeasurementEnd())) {
                        var firstPoint = {
                            start: {
                                x: measurements[0].start.x,
                                y: measurements[0].start.y
                            },
                            end: {
                                x: measurements[measurements.length - 1].end.x,
                                y: measurements[measurements.length - 1].end.y
                            },
                            measureType: "line",
                            style: data.style
                        };
                        drawLineWithoutMeasurement(imageUid, context, firstPoint, presentation, imageRenderer, true, isQualifyforEdit);
                    }
                }
            }

        }

        var mitralMeasurements = dicomViewer.measurement.getMitralGradientMeasurements(imageUid, frameIndex);

        if (mitralMeasurements !== undefined && mitralMeasurements.length !== 0) {
            var measurementResult = undefined;
            for (var i = 0; i < mitralMeasurements.length; i++) {
                measurements = mitralMeasurements[i];
                var dataResultX = 0;
                var dataResultY = 0;
                var dataMitralGradiant = 0;
                var gradiantValues = getAvgMitralMeanGradients(imageUid, measurements);

                if (measurements !== undefined && measurements.length !== 0) {
                    var freeHandPoints = [];
                    if (measurements[0].measureType === "mitralGradient" &&
                        measurements[0].measurementSubType === "freehand") {
                        for (var j = 0; j < measurements.length; j++) {
                            var imageCoordinate = dicomViewer.measurement.getCanvasDataForImageData(measurements[j], imageRenderer);
                            if(j == 0) {
                                freeHandPoints.push([parseInt(imageCoordinate.start.x),
                                                    parseInt(imageCoordinate.start.y)]);
                            }

                            freeHandPoints.push([parseInt(imageCoordinate.end.x),
                                                 parseInt(imageCoordinate.end.y)]);
                        }
                    }

                    for (var j = 0; j < measurements.length; j++) {
                        var data = measurements[j];
                        if (data.measureType === "mitralGradient") {
                            var display = false;
                            if (j === measurements.length - 1) display = true;
                            if(data.measurementSubType === "freehand") {
                                if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                                    drawFreeHandMeasurement(imageUid, context, data, presentation, imageRenderer, display, data.editMode, freeHandPoints);
                                }
                            } else {
                                if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                                    measurementResult = drawMitralMeanGradientMeasurement(imageUid, context, data, presentation, imageRenderer, display, gradiantValues, data.editMode);
                                }
                            }

                            if(data.measurementSubType !== "freehand") {
                                if ((i != mitralMeasurements.length -1 && j == measurements.length - 1 ) ||
                                   (i == mitralMeasurements.length -1 && j == measurements.length - 1 && (!dicomViewer.measurement.isMitralMeanGradientMeasurementEnd() || displayMeasurement))) {
                                    var firstPoint = {
                                        start: {
                                            x: measurements[0].start.x,
                                            y: measurements[0].start.y
                                        },
                                        end: {
                                            x: measurements[measurements.length - 1].end.x,
                                            y: measurements[measurements.length - 1].end.y
                                        },
                                        measureType: "line",
                                        style: data.style
                                    };
                                    if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                                        drawLineWithoutMeasurement(imageUid, context, firstPoint, presentation, imageRenderer, true, isQualifyforEdit);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (measurementResult != undefined)
                sendMeasurement(measurementResult.id, measurementResult.value);
        }

        var penMeasurement = dicomViewer.measurement.getPenMeasurements(imageUid, frameIndex);
        if(penMeasurement !== undefined && penMeasurement.length !== 0) {
            var measurementResult = undefined;
            for (var i = 0; i < penMeasurement.length; i++) {
                measurements = penMeasurement[i];
                var dataResultX = 0;
                var dataResultY = 0;

                if (measurements !== undefined && measurements.length !== 0) {
                    var penPoints = [];
                    for (var j = 0; j < measurements.length; j++) {
                        var data = measurements[j];
                        var display = false;
                        if (j === measurements.length - 1) {
                            display = true;
                        }
                        if(data.measurementSubType === "pen") {
                            if (dicomViewer.measurement.isMeasurementDrawable(data.sessionType)) {
                                drawPenMeasurement(imageUid, context, data, presentation, imageRenderer, data.editMode);
                            }
                        }
                    }
                }
            }
        }

    }

    function updateDynamicVolumes(tempData, imageUid, imageData, frameIndex, parentDiv, presentation, context, imageRenderer) {
        tempData.measurementComplete = true;
        var volumeMeasurements = dicomViewer.measurement.getVolumeMeasurements(imageUid, frameIndex);

        if (volumeMeasurements !== undefined && volumeMeasurements.length !== 0) {
            var measurements = volumeMeasurements[imageData.measurementId];
            if (measurements !== undefined && measurements.length !== 0) {
                var lastLineData = measurements[measurements.length - 1];
                if (imageData.measureType === "volume" || imageData.measureType === "volumeeditmove") {
                    drawLineWithoutMeasurement(imageUid, context, imageData, presentation, imageRenderer, false);
                }
                var lastData = [];
                if (tempData.measurementComplete === true) {
                    lastData = {
                        start: {
                            x: measurements[0].start.x,
                            y: measurements[0].start.y
                        },
                        end: {
                            x: lastLineData.end.x,
                            y: lastLineData.end.y
                        },
                        measureType: "line"
                    };
                    drawLineWithoutMeasurement(imageUid, context, lastData, presentation, imageRenderer, true);
                }
                //Find the mid point between the line
                //[(x_1 + x_2)/2 , (y_1 + y_2)/2]
                var midPointX = (lastData.start.x + lastData.end.x) / 2;
                var midPointY = (lastData.start.y + lastData.end.y) / 2;
                var arrLength = [];
                var lengthData = [];
                for (var j = 0; j < measurements.length - 1; j++) {
                    lengthData = {
                        start: {
                            x: midPointX,
                            y: midPointY
                        },
                        end: {
                            x: measurements[j].end.x,
                            y: measurements[j].end.y
                        },
                        measureType: "line"
                    };
                    //drawLineWithoutMeasurement(imageUid, context, lengthData, presentation, imageRenderer,true);

                    var value = getLengthText(lengthData);
                    arrLength[j] = parseInt(value.split(" ")[0]);
                }
                var maxIndex = findIndexOfGreatest(arrLength);
                lengthData = {
                    start: {
                        x: midPointX,
                        y: midPointY
                    },
                    end: {
                        x: measurements[maxIndex].end.x,
                        y: measurements[maxIndex].end.y
                    },
                    measureType: "line"
                };
                drawLineWithoutMeasurement(imageUid, context, lengthData, presentation, imageRenderer, true);
                var point = measurements[maxIndex];
                var slope = (lastData.end.y - lastData.start.y) / (lastData.end.x - lastData.start.x);
                var slope2 = (-1 / slope);
                var newAngle = Math.atan(slope2);
                var delta_x_A_C = 20000 * Math.cos(newAngle);
                var delta_y_A_C = 20000 * Math.sin(newAngle);
                var newX1 = point.end.x + delta_x_A_C;
                var newY1 = point.end.y + delta_y_A_C;

                delta_x_A_C = -20000 * Math.cos(newAngle);
                delta_y_A_C = -20000 * Math.sin(newAngle);
                var newX2 = point.end.x + delta_x_A_C;
                var newY2 = point.end.y + delta_y_A_C;


                newAngle = Math.atan(slope);
                delta_x_A_C = 20000 * Math.cos(newAngle);
                delta_y_A_C = 20000 * Math.sin(newAngle);
                var newX3 = lastData.end.x + delta_x_A_C;
                var newY3 = lastData.end.y + delta_y_A_C;

                delta_x_A_C = -20000 * Math.cos(newAngle);
                delta_y_A_C = -20000 * Math.sin(newAngle);
                var newX4 = lastData.end.x + delta_x_A_C;
                var newY4 = lastData.end.y + delta_y_A_C;
                var newIntersect = getIntersectionPoint(newX1, newY1,
                    newX2, newY2,
                    newX3, newY3, newX4, newY4);
                if (newIntersect === null)
                    return;
                midPointX = newIntersect.x;
                midPointY = newIntersect.y;
                var newData = {
                    start: {
                        x: midPointX,
                        y: midPointY
                    },
                    end: {
                        x: measurements[maxIndex].end.x,
                        y: measurements[maxIndex].end.y
                    },
                    measureType: "line"
                };
                drawLineWithoutMeasurement(imageUid, context, newData, presentation, imageRenderer, true);
                var firstPoint = [];
                var drawWithXAxis = false;
                if (Math.abs(midPointX - point.end.x) > Math.abs(midPointY - point.end.y)) {
                    drawWithXAxis = true;
                }


                var angle_A_B = Math.atan2((newData.end.y - newData.start.y), (newData.end.x - newData.start.x));
                console.log(angle_A_B);
                var distance = -arrLength[maxIndex];
                var pointsToBeSent = {};
                var pointIndex = 0;
                for (var iTemp = 0; iTemp < (2 * arrLength[maxIndex]) / 10; iTemp++) {
                    var delta_x_A_C = distance * Math.cos(angle_A_B);
                    var delta_y_A_C = distance * Math.sin(angle_A_B)
                    var x3 = midPointX + delta_x_A_C;
                    var y3 = midPointY + delta_y_A_C;
                    var b = y3 - (slope * x3);
                    var point1 = [];
                    var point2 = [];
                    if (drawWithXAxis) {
                        point1 = {
                            x: (x3 - arrLength[maxIndex]),
                            y: ((slope * (x3 - arrLength[maxIndex])) + b)
                        };
                        point2 = {
                            x: (x3 + arrLength[maxIndex]),
                            y: ((slope * (x3 + arrLength[maxIndex])) + b)
                        };
                    } else {
                        point1 = {
                            x: ((y3 - arrLength[maxIndex] - b) / slope),
                            y: (y3 - arrLength[maxIndex])
                        };
                        point2 = {
                            x: ((y3 + arrLength[maxIndex] - b) / slope),
                            y: (y3 + arrLength[maxIndex])
                        };
                    }
                    var intersectPoint1 = undefined;
                    var intersectPoint2 = undefined;

                    for (var j = 0; j < measurements.length; j++) {

                        var intersect = getIntersectionPoint(measurements[j].start.x, measurements[j].start.y,
                            measurements[j].end.x, measurements[j].end.y,
                            x3, y3, point1.x, point1.y);
                        if (intersect != null) {
                            if (intersectPoint1 == null || intersectPoint1 == undefined) intersectPoint1 = intersect;
                            else if (intersectPoint2 == null || intersectPoint2 == undefined) intersectPoint2 = intersect;
                        }
                        intersect = getIntersectionPoint(measurements[j].start.x, measurements[j].start.y,
                            measurements[j].end.x, measurements[j].end.y,
                            x3, y3, point2.x, point2.y);
                        if (intersect != null) {
                            if (intersectPoint1 == null || intersectPoint1 == undefined) intersectPoint1 = intersect;
                            else if (intersectPoint2 == null || intersectPoint2 == undefined) intersectPoint2 = intersect;
                        }

                        if (intersectPoint1 !== null && intersectPoint2 !== null &&
                            intersectPoint1 !== undefined && intersectPoint2 !== undefined) {
                            firstPoint = {
                                start: {
                                    x: intersectPoint1.x,
                                    y: intersectPoint1.y
                                },
                                end: {
                                    x: intersectPoint2.x,
                                    y: intersectPoint2.y
                                },
                                measureType: "line"
                            };
                            drawLineWithoutMeasurement(imageUid, context, firstPoint, presentation, imageRenderer, true);
                            pointsToBeSent[pointIndex] = [];
                            pointsToBeSent[pointIndex][0] = intersectPoint1;
                            pointsToBeSent[pointIndex][1] = intersectPoint2;
                            pointIndex++;
                            intersectPoint1 = undefined;
                            intersectPoint2 = undefined;
                        }
                    }

                    distance = distance + 10;

                }
                var measurementToBeSent = {};
                for (var k = 0; k < measurements.length; k++) {
                    measurementToBeSent[k] = [];
                    measurementToBeSent[k][0] = measurements[k].start;
                    measurementToBeSent[k][1] = measurements[k].end;
                }
                var sendData = {
                    volumeId: imageData.measurementId,
                    volumePoints: measurementToBeSent,
                    volumeSegments: pointsToBeSent
                };
                sendVolumeMeasurements(JSON.stringify(sendData));
            }
        }
    }

    function getImageCoordinatesForMousePoint(mousePoint, imageRenderer, context) {
        var presentation = imageRenderer.presentationState;
        if (imageRenderer === undefined) {
            throw "getImageCoordinatesForMousePoint: imageRenderer is null/undefined";
        }
        if (imageRenderer.imagePromise === undefined) {
            throw "getImageCoordinatesForMousePoint: imagePromise is null/undefined";
        }
        if (mousePoint == null) {
            return null;
        }

        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });

        //var context = dicomViewer.measurement.getImageContext(imageUid,frameIndex);
        if (context === undefined) {
            throw "getImageCoordinatesForMousePoint: canvas 2d context is null/undefined";
        }
        if (presentation === undefined) {
            throw "getImageCoordinatesForMousePoint: presentation is null/undefined";
        }
        var pan = presentation.getPan();
        var imageCordinate = {};

        var contextPoint = context.transformedPoint(mousePoint.x, mousePoint.y);

        imageCordinate.x = (contextPoint.x - pan.x);
        imageCordinate.y = (contextPoint.y - pan.y);
        imageCordinate.handleActive = mousePoint.handleActive;

        return imageCordinate;
    }

    function getMousePointForImageCoordinates(imageCoordinate, imageRenderer, context) {
        var presentation = imageRenderer.presentationState;
        if (imageRenderer === undefined) {
            throw "getMousePointForImageCoordinates: imageRenderer is null/undefined";
        }
        if (imageRenderer.imagePromise === undefined) {
            throw "getMousePointForImageCoordinates: imagePromise is null/undefined";
        }
        if (imageCoordinate == null) {
            return null;
        }

        var imageUid = undefined;
        var frameIndex = undefined;
        imageRenderer.imagePromise.then(function(image) {
            imageUid = image.imageUid;
            frameIndex = image.frameNumber;
        });

        // var context = dicomViewer.measurement.getImageContext(imageUid,frameIndex);
        if (context === undefined) {
            throw "getMousePointForImageCoordinates: canvas 2d context is null/undefined";
        }
        if (presentation === undefined) {
            throw "getMousePointForImageCoordinates: presentation is null/undefined";
        }
        var pan = presentation.getPan();
        var mousePoint = {};
        var contextPoint = context.mousePoint(parseFloat(imageCoordinate.x) + pan.x, parseFloat(imageCoordinate.y) + pan.y);
        mousePoint.x = contextPoint.x;
        mousePoint.y = contextPoint.y;
        mousePoint.handleActive = imageCoordinate.handleActive;

        return mousePoint;
    }

    function getCanvasCoordinatesForImageCoordinates(imageCoordinate, imageRenderer) {
        var presentation = imageRenderer.presentationState;
        if (imageRenderer === undefined) {
            throw "getMousePointForImageCoordinates: imageRenderer is null/undefined";
        }
        if (imageRenderer.imagePromise === undefined) {
            throw "getMousePointForImageCoordinates: imagePromise is null/undefined";
        }
        if (presentation === undefined) {
            throw "getMousePointForImageCoordinates: presentation is null/undefined";
        }
        if (imageCoordinate == null) {
            return null;
        }

        var pan = presentation.getPan();
        var canvasCoordinates = {};
        canvasCoordinates.x = parseFloat(imageCoordinate.x) + pan.x;
        canvasCoordinates.y = parseFloat(imageCoordinate.y) + pan.y;
        canvasCoordinates.handleActive = imageCoordinate.handleActive;

        return canvasCoordinates;
    }

    function drawLineWithoutMeasurement(imageUid, context, data, presentation, imageRenderer, dottedLine, isQualifyforEdit) {
        var imageCoordinate = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        var scale = presentation.getZoom();
        // draw the line
        var currentTempData = dicomViewer.measurement.getTempData();
        if (isQualifyforEdit === true && currentTempData !== undefined && currentTempData.measureType !== null && currentTempData.measureType === "volumeedit" && (data.end.handleActive || data.start.handleActive)) {            
            var radius = 2 / (imageRenderer.scaleValue / scale);
            context.beginPath();
            context.strokeStyle = '#DAA520';
            context.arc(imageCoordinate.start.x, imageCoordinate.start.y, radius, 0, 2 * Math.PI, false);
            context.closePath();
            context.stroke();
        }

        context.beginPath();
        updateContextStyle(context, imageCoordinate.style ,false, imageRenderer.scaleValue);

        context.moveTo(imageCoordinate.start.x, imageCoordinate.start.y);
        context.lineTo(imageCoordinate.end.x, imageCoordinate.end.y);

        if (dottedLine) context.setLineDash([5/scale, 10/scale]);
        else context.setLineDash([]);
        context.closePath();
        context.stroke();
    }

    function drawLineMeasurement(imageUid, context, data, presentation, imageRenderer, editValue) {
        var imageCoordinate = data;
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
        var usRegionFound = false;
        var resultText = null;
        var applyCalibration = false;
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var measurementUnit = null; 
        applyCalibration = ( measurementUnit = getUnitMeasurementMap(seriesLayout.studyUid+"|"+imageRenderer.seriesIndex+"|"+imageRenderer.imageIndex+"|"+imageRenderer.anUIDs.split("*")[1]) ) ? true : false;

        //set the last calibrated image
        setActiveCalibratedImage(seriesLayout.studyUid+"|"+imageRenderer.seriesIndex+"|"+imageRenderer.imageIndex+"|"+imageRenderer.anUIDs.split("*")[1]);

        var dicomImageInfo = dicomHeader.imageInfo.measurement;
        var pixelSpacing = dicomImageInfo ? dicomImageInfo.pixelSpacing : undefined;
        var isCaliber  = dicomViewer.tools.getCursorType();

        if(measurementUnit != null && applyCalibration) {
            var value = getLengthUsingPixelSpacing(imageCoordinate, measurementUnit.pixelSpacing, false);
            if (parseFloat(value) > 0.05) {

                var calibrateFlag = (pixelSpacing == undefined ||
                                     (pixelSpacing.row <= 0 && pixelSpacing.column <= 0)) ? false : true;
                resultText = getDisplayLengthText(value, calibrateFlag, data.measurementComplete,measurementUnit.unitType, calibrateFlag);
            } else {
                return;
            }
        }
        else if ((isCaliber == "calibrate") || (dicomImageInfo != null && dicomImageInfo !== undefined)) {
            if (isValidPixelSpacing(pixelSpacing)) {
                 var value = getLengthUsingPixelSpacing(imageCoordinate, pixelSpacing, true);
                if (parseFloat(value) > 0.05) {
                    resultText = getDisplayLengthText(value, false, data.measurementComplete,undefined);
                } else if(pixelSpacing.row <= 0 && pixelSpacing.column <= 0 && dicomViewer.tools.getFlagFor2dLengthCalibration() && data.measurementSubType != "2DLine" && data.measurementSubType != "Arrow"){
                    value = 1;
                    resultText = "";
                } else if(data.measurementSubType == "2DLine" || data.measurementSubType == "Arrow") {
                    value = 1;
                    resultText = "";
                } else {
                    return;
                }
            } else if((isCaliber === "calibrate")) {
                value = 1;
                resultText = "";
            } else if (dicomImageInfo && (dicomImageInfo.measurement.usRegions != null) && (dicomImageInfo.measurement.usRegions.length > 0)) {

                var regionSpatialFormat = 0;
                var physicalUnitsXDirection = 0;
                var physicalUnitsYDirection = 0;
                var physicalDeltaX = 0.0;
                var physicalDeltaY = 0.0;

                for (var i = 0; i < dicomHeader.imageInfo.measurement.usRegions.length; i++) {
                    var usRegion = dicomHeader.imageInfo.measurement.usRegions[i];

                    if (((imageCoordinate.start.x <= usRegion.regionLocationMaxX1) && (imageCoordinate.start.x >= usRegion.regionLocationMinX0)) &&
                        ((imageCoordinate.start.y <= usRegion.regionLocationMaxY1) && (imageCoordinate.start.y >= usRegion.regionLocationMinY0)) &&
                        ((imageCoordinate.end.x <= usRegion.regionLocationMaxX1) && (imageCoordinate.end.x >= usRegion.regionLocationMinX0)) &&
                        ((imageCoordinate.end.y <= usRegion.regionLocationMaxY1) && (imageCoordinate.end.y >= usRegion.regionLocationMinY0)) &&
                        (!((usRegion.regionSpatialFormat == 0) && (usRegion.physicalUnitsXDirection == 0) && (usRegion.physicalUnitsYDirection == 0)))) {

                        usRegionFound = true;
                        regionSpatialFormat = usRegion.regionSpatialFormat;
                        physicalUnitsXDirection = usRegion.physicalUnitsXDirection;
                        physicalUnitsYDirection = usRegion.physicalUnitsYDirection;
                        physicalDeltaX = usRegion.physicalDeltaX;
                        physicalDeltaY = usRegion.physicalDeltaY;
                        break;
                    }
                }

                if (usRegionFound) {

                    if ((regionSpatialFormat == 1) && (physicalUnitsXDirection == 3) && (physicalUnitsYDirection == 3)) {

                        var pixelSpacing = {
                            column: Math.abs(physicalDeltaX) * 10.0,
                            row: Math.abs(physicalDeltaY) * 10.0,
                        };

                        var lengthInCM = getLengthUsingPixelSpacing(imageCoordinate, pixelSpacing, true);

                        if (imageCoordinate.measurementUnits != null) {
                            if (imageCoordinate.measurementUnits == "mm") {
                                lengthInCM *= 10.0;
                                resultText = "" + lengthInCM.toFixed(2) + " mm";
                            } else
                                resultText = "" + lengthInCM.toFixed(2) + " cm";
                        } else {
                            if (lengthInCM < 0.01) {
                                lengthInCM *= 10000.0;
                                resultText = "" + lengthInCM.toFixed(2) + " \u00B5" + "cm";
                            } else if (lengthInCM < 1) {
                                lengthInCM *= 10.0;
                                resultText = "" + lengthInCM.toFixed(2) + " mm";
                            } else
                                resultText = "" + lengthInCM.toFixed(2) + " cm";
                        }
                    } else {

                        var lengthX = Math.abs(imageCoordinate.end.x - imageCoordinate.start.x) * Math.abs(physicalDeltaX);
                        var lengthY = Math.abs(imageCoordinate.end.y - imageCoordinate.start.y) * Math.abs(physicalDeltaY);

                        var unitsX;
                        var unitsY;
                        if ((physicalUnitsXDirection < 0) || (physicalUnitsXDirection > 12)) {
                            unitsX = "unknown";
                        } else if ((physicalUnitsYDirection < 0) || (physicalUnitsYDirection > 12)) {
                            unitsY = "unknown";
                        } else {
                            unitsX = physicalUnitsXYDirectionArray[physicalUnitsXDirection];
                            unitsY = physicalUnitsXYDirectionArray[physicalUnitsYDirection];
                        }

                        if (imageCoordinate.measurementType == 1) // Y- Axis
                            resultText = "" + lengthY.toFixed(2) + " " + unitsY;
                        else // X-axis
                            resultText = "" + lengthX.toFixed(2) + " " + unitsX;
                    }
                } else
                    resultText = getLengthText(imageCoordinate);
            } else {
                resultText = getLengthText(imageCoordinate);
            }
            var value = resultText.split(" ")[0];
            if (parseFloat(value) < 0.05) {
                return;
            }
        } else {
            resultText = getLengthText(imageCoordinate);
        }

        if (editValue === undefined) {
            var dist =  Math.sqrt(Math.pow(data.end.x - data.start.x, 2) 
                                  + Math.pow(data.end.y - data.start.y, 2));

            if(data.measurementSubType == "Arrow") {
                if (dist * imageRenderer.scaleValue < 10) {
                    return;
                }
            }

            // draw the line
            context.beginPath();
            updateContextStyle(context, data.style, false, imageRenderer.scaleValue)
            context.moveTo(data.start.x, data.start.y);
            context.lineTo(data.end.x, data.end.y);
            context.setLineDash([]);
            context.closePath();
            context.stroke();

            drawLineHandles(imageUid, context, data, presentation, imageRenderer);

            if(data.measurementSubType != "2DLine" && data.measurementSubType != "Arrow") {
                drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, false);
            }
        }
        // for reporting
        if ((usRegionFound) && (imageCoordinate.measurementId != null)) {
            return {
                id: imageCoordinate.measurementId,
                value: resultText
            };
        }

        return null;
    }

    function drawEllipseMeasurement(imageUid, context, data, presentation, imageRenderer, isEllipseEnd, isEditMode) {
        var imageCoordinate = data;
        var result = 0;
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var deltaY = (data.start.y - data.end.y);
        var deltaX = (data.end.x - data.start.x);
        if(data.start.y < data.end.y)
            result = Math.abs(Math.atan2(deltaY, deltaX));
        else
            result = Math.abs(Math.atan2(deltaY, deltaX)) * -1;

        var zoom = presentation.getZoom();
        if (data !== undefined) {
            if (data.first == null || data.first == undefined) {
                // PR file Ellipse - Compund graphic sequence
                drawEllipseWithinRectangleBounds(context, data);
            } else {
                // calculate and draw the four ellipse quadrants.
                drawQuadrantsOfEllipse(data, context, imageRenderer.scaleValue, zoom);
                if(isEditMode == undefined || isEditMode) {
                    var radius = (4 * imageRenderer.viewportHeight) / (1000 * imageRenderer.scaleValue) ;
                    context.setLineDash([]);
                    // draws the four quadrant points.
                    drawArcandLine(data.first, undefined, radius, true, "#DAA520", context);
                    drawArcandLine(data.second, undefined, radius, true, "#DAA520", context);
                    drawArcandLine(data.third, undefined, radius, true, "#DAA520", context);
                    drawArcandLine(data.fourth, undefined, radius, true, "#DAA520", context);
                }
            }
        }
        if(isEllipseEnd != undefined && data.measurementSubType != "ellipse")
        {
            if(isEllipseEnd)
            {
                resultText = calculateStandardDeviation(imageUid, context, imageCoordinate, presentation, imageRenderer);
                drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, false, true);
                return resultText;
            }
            else
            {
                drawMeasurementsLength(context, data, imageRenderer, presentation, imageCoordinate.measurementResult, false, true);
            }
        }
        return null;
    }
    
    /**
     * darws ellipse with 2 points (Compund graphic sequence)
     * @param {Type} context 
     * @param {Type} data 
     */ 
    function drawEllipseWithinRectangleBounds(context, data) {
        context.save();
        context.beginPath();
        //Dynamic scaling
        var scalex = 1*((data.end.x-data.start.x)/2);
        var scaley = 1*((data.end.y-data.start.y)/2);
        scalex =  scalex == 0 ? 1 : scalex;
        scaley =  scaley == 0 ? 1 : scaley;
        context.scale(scalex,scaley);
        //Create ellipse
        var point = {
            x: (data.start.x/scalex)+1,
            y: (data.start.y/scaley)+1
        }
        drawArcandLine(point, undefined, 1, true, data.style.lineColor, context);
        //Restore and draw
        context.restore();
    }

    /**
     * draws Arc or Line using given inputs.
     * @param {Type} start 
     * @param {Type} end 
     * @param {Type} radius 
     * @param {Type} isArc 
     * @param {Type} strokeStyle 
     * @param {Type} context 
     */ 
    function drawArcandLine(start, end, radius, isArc, strokeStyle, context) {
        context.beginPath();
        context.strokeStyle = strokeStyle;
        context.moveTo(start.x, start.y);
        if (isArc) {
            context.arc(start.x, start.y, radius, 0, 2 * Math.PI, false);
        } else {
            context.lineTo(end.x, end.y);
        }
        context.closePath();
        context.stroke();
    }

    /**
     * 
     * @param {Type} data 
     * @param {Type} context 
     * @param {Type} scaleValue 
     */ 
    function drawQuadrantsOfEllipse(data, context, scaleValue, zoom) {
        // draws cross line between quadrants.
        context.setLineDash([5/zoom], [5/zoom]);
        drawArcandLine(data.first, data.second, undefined, false, data.style.lineColor, context);
        drawArcandLine(data.fourth, data.third, undefined, false, data.style.lineColor, context);
        context.setLineDash([], []);

        context.save();
        
        updateContextStyle(context, data.style, false, scaleValue);

        if (data.center == null || data.center == undefined) {
            // PR file Ellipse - Compund graphic sequenceata
            data.center = {
                x: (data.first.x + data.second.x) / 2,
                y: (data.first.y + data.second.y) / 2
            }
        }

        // draws the curve segment from first quadrant to fourth quadrant.
        drawQuadrant(data.first, data.fourth, { q1: data.third, q2: data.second }, data.center, context);
        
        // draws the curve segment from fourth quadrant to second quadrant.
        drawQuadrant(data.fourth, data.second, { q1: data.first, q2: data.third }, data.center, context);
        
        // draws the curve segment from second quadrant to third quadrant.
        drawQuadrant(data.second, data.third, { q1: data.fourth, q2: data.first }, data.center, context);
        
        // draws the curve segment from third quadrant to first quadrant.
        drawQuadrant(data.third, data.first, { q1: data.second, q2: data.fourth } , data.center, context);
        
        context.restore();
    }

    /**
     * 
     * @param {Type} start 
     * @param {Type} end 
     * @param {Type} oppositeQuads 
     * @param {Type} center 
     * @param {Type} context 
     * @param {Type} quadrant 
     */ 
    function drawQuadrant(start, end, oppositeQuads, center, context) {
        context.setLineDash([]);
        // check if the quadrants are circular form.
        if (isCircularQuadrant(start, end, center)) {
            // draws circular curve.
            renderCurveSegment(0, Math.PI * 0.5, center, start, false, context);
        } else {
            // draws two curve segment between starting and ending quadrant.
            
            // calculate two center points and angles to draw the curve
            var quadInfo = getQuadrantInfo(start, end, oppositeQuads, center, context);
            
            var angle = Math.abs(quadInfo.r2Angle);
            var swap = quadInfo.isSwapped;
            var center = quadInfo.c2Pt;
            
            // draws the first curve segment of a quadrant.
            var firstEndPt = renderCurveSegment(0, angle, center, swap ? start : end, swap ? false : true, context);
            
            angle = Math.abs(quadInfo.r1Angle);
            center = quadInfo.c1Pt;
            // draws the second curve segment of a quadrant.
            var secondEndPt = renderCurveSegment(0, angle, center, swap ? end : start, swap ? true : false, context);
            
            // connects the missing path between two curve segments.
            if (firstEndPt != undefined && secondEndPt != undefined) {
                context.moveTo(firstEndPt.x, firstEndPt.y);
                context.quadraticCurveTo(firstEndPt.x, firstEndPt.y, secondEndPt.x, secondEndPt.y);
                context.stroke();
            }
        }
    }

    /**
     * Returns the endpoint for the drawn curve segment.
     * @param {Type} startAngle 
     * @param {Type} endAngle 
     * @param {Type} center 
     * @param {Type} quadrant 
     * @param {Type} isNegative 
     * @param {Type} context 
     */ 
    function renderCurveSegment(startAngle, endAngle, center, quadrant, isNegative, context) {
        var point;
        for (var i = startAngle; i < endAngle; i += 0.01) {
            point = rotate(center.x, center.y, quadrant, isNegative ? -i : i);
            if (i == startAngle) {
                context.moveTo(point.x, point.y);
            } else {
                context.lineTo(point.x, point.y);
            }
        }
        context.stroke();
        return point;
    }

    function checkLoop(isNegative, i, endAngle) {
        return isNegative ? i > endAngle : i < endAngle;
    }
    
    function incrLoop(isNegative, i) {
        return isNegative ? i - 0.01 : i + 0.01;
    }

    /**
     * Rotate a point to given radians with given center point.
     * @param {Type} cx 
     * @param {Type} cy 
     * @param {Type} point 
     * @param {Type} radians 
     */ 
    function rotate(cx, cy, point, radians) {
            cos = Math.cos(radians),
            sin = Math.sin(radians),
            nx = (cos * (point.x - cx)) + (sin * (point.y - cy)) + cx,
            ny = (cos * (point.y - cy)) - (sin * (point.x - cx)) + cy;
        return { x: nx, y: ny};
    }

    /**
     * Checks whether the quadrants are circular.
     * @param {Type} start 
     * @param {Type} end 
     * @param {Type} center 
     */ 
    function isCircularQuadrant(start, end, center) {
        var firstPos = findDSAValue(start, center),
            secondPos = findDSAValue(end, center);
        if (Math.abs(secondPos.distance - firstPos.distance) <= 2) {
            return true;
        }
        return false;
    }

    /**
     * Calculate distance, angle and slope values for two given points.
     * @param {Type} start 
     * @param {Type} end 
     */ 
    function findDSAValue(start, end) {
        var dx = end.x - start.x,
            dy = end.y - start.y,
            distance = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2)),
            cosalpha = dx / distance,
            angle, slope;
        slope = (end.y - start.y) / (end.x - start.x);
        if (dy / distance < 0)
        {
            angle = (Math.PI * 2 - Math.acos(cosalpha));
        }
        else
        {
            angle = (Math.acos(cosalpha));
        }
        return { distance : distance, angle : angle, slope : slope };
    }

    /**
     * Calculates the two center points and angles to draw the two curve segments of the quadrants.
     * @param {Type} start 
     * @param {Type} end 
     * @param {Type} oppositeQuads 
     * @param {Type} center 
     * @param {Type} context 
     */ 
    function getQuadrantInfo(start, end, oppositeQuads, center, context) {
        /* Refer the following pdf for the calculations.
        https://academics.rowan.edu/csm/departments/math/facultystaff/faculty/osler/106%20APPROXIMATING%20AN%20ELLIPSE%20WITH%20FOUR%20CIRCULAR%20ARCS%20Sept2submission%20to%20MACE_Rev3a.pdf
        *
        */
        var quadrantInfo = {},
            dx, dy, slopeDistance, startDist, endDist,
            cosalpha, r1Angle, r2Angle, slope, c1Pt, c2Pt;
        
        var startPos = findDSAValue(center, start);
        startDist = startPos.distance;
        var endPos = findDSAValue(center, end);
        endDist = endPos.distance;
        var slopePos = findDSAValue(start, end);
        slopeDistance = slopePos.distance;
        
        r2Angle = slopePos.angle - Math.PI;
        r1Angle = Math.abs(Math.PI - ((Math.PI * 0.5) + r2Angle));
        
        var multiplier = (r2Angle > -Math.PI * 0.5 && r2Angle < Math.PI * 0.5) ? -1 : 1;
        var finalDist = startDist - endDist,
            finalStartPt = start, finalEndPt = end,
            finalStartPos = startPos, finalEndPos = endPos,
            opposite = oppositeQuads.q1, isSwapped = false;
        
        // Swap the end points if the end point distance to center point is greater than start point distance.
        if (endDist > startDist) {
            finalDist = endDist - startDist;
            finalStartPt = end;
            finalEndPt = start;
            finalStartPos = endPos;
            finalEndPos = startPos;
            multiplier = -multiplier;
            opposite = oppositeQuads.q2;
            isSwapped= true;
        }

        // find mid point after subtracting the difference to center along the slope of start and end points.
        var normalizedSlopeDist = (slopeDistance - finalDist) / 2;
        slope = slopePos.slope;
        var midPt = {
            x: finalStartPt.x + multiplier * (normalizedSlopeDist / Math.sqrt(1 + Math.pow(slope, 2))),
            y: finalStartPt.y + multiplier * ((slope * normalizedSlopeDist) / Math.sqrt(1 + Math.pow(slope, 2)))
        };
        
        // find a point of perpendicular line to the slope from the above mid point.
        slope = - (1 / slope);
        multiplier = (r2Angle > 0 && r2Angle < Math.PI) ? -1 : 1;
        tempPt = {
            x: midPt.x + multiplier * (slopeDistance / Math.sqrt(1 + Math.pow(slope, 2))),
            y: midPt.y + multiplier * ((slope * slopeDistance) / Math.sqrt(1 + Math.pow(slope, 2)))
        };
        
        // find the two centers to draw the curve segments.
        var centers = findC1andC2Points(finalStartPt, finalEndPt, opposite, center, midPt, tempPt);
        
        // find two angles of curve segments.
        var centerPos = findDSAValue(centers.c1Pt, centers.c2Pt);
        r1Angle = Math.atan((centerPos.slope - finalStartPos.slope) / ( 1 + (finalStartPos.slope * centerPos.slope)));
        r2Angle = Math.atan((centerPos.slope - finalEndPos.slope) / ( 1 + (finalEndPos.slope * centerPos.slope)));
        
        r1Angle = isNaN(r1Angle) ? (Math.PI * 0.25) : r1Angle;
        r2Angle = isNaN(r2Angle) ? (Math.PI * 0.25) : r2Angle;

        quadrantInfo = {
           r1Angle: r1Angle,
           r2Angle: r2Angle,
           c1Pt: centers.c1Pt,
           c2Pt: centers.c2Pt,
           isSwapped: isSwapped
       }
       return quadrantInfo;
    }

    /**
     * Returns two center points using given lines by finding its intersections.
     * @param {Type} start 
     * @param {Type} end 
     * @param {Type} opposite 
     * @param {Type} center 
     * @param {Type} midPt 
     * @param {Type} tempPt 
     */ 
    function findC1andC2Points(start, end, opposite, center, midPt, tempPt) {
        var c2Pt = findIntersectingPt(midPt, end, opposite, tempPt),
            c1Pt = findIntersectingPt(midPt, center, start, c2Pt);
        return { c1Pt : c1Pt, c2Pt : c2Pt };
    }

    /**
     * Return the point of intersection.
     */ 
    function findIntersectingPt (pt1, pt2, pt3, pt4) {
        // Line AB represented as a1x + b1y = c1
        var a1 = pt4.y - pt1.y;
        var b1 = pt1.x - pt4.x;
        var c1 = a1*(pt1.x) + b1*(pt1.y);

        // Line CD represented as a2x + b2y = c2
        var a2 = pt3.y - pt2.y;
        var b2 = pt2.x - pt3.x;
        var c2 = a2*(pt2.x)+ b2*(pt2.y);

        var determinant = a1*b2 - a2*b1,
            intersectingPt;
        if (determinant == 0)
        {
            // The lines are parallel.
        }
        else
        {
            intersectingPt = {
                x: (b2*c1 - b1*c2)/determinant,
                y: (a1*c2 - a2*c1)/determinant
            };
        }
        return intersectingPt;
    }

    /**
     * To draw rectangle measurement of hounsfield and annotation types
     * @param {Type} imageUid 
     * @param {Type} context 
     * @param {Type} data 
     * @param {Type} presentation 
     * @param {Type} imageRenderer 
     * @param {Type} isRectangleEnd 
     * @param {Type} isEditMode 
     */ 
    function drawRectangleMeasurement(imageUid, context, data, presentation, imageRenderer, isRectangleEnd, isEditMode,isEdit) {
        var imageCoordinate = getAndUpdateTextBounds(context, data, imageRenderer);
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var deltaY = (data.end.y - data.start.y);
        var deltaX = (data.end.x - data.start.x);

        var result = 0;
        if(data.start.y < data.end.y)
            result = Math.abs(Math.atan2(deltaY, deltaX));
        else
            result = Math.abs(Math.atan2(deltaY, deltaX)) * -1;
        
        if (data !== undefined) {
            context.beginPath();
            //Restore and draw
            updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
            if (data.measurementSubType === "text") {
                context.setLineDash([4, 4]);
            } else {
                context.setLineDash([]);
            }
            //Create rectangle
            if(!(data.measurementType == 8 && data.measurementSubType === "text" && 
                 ((isRectangleEnd == undefined && isEditMode == false && isEdit == undefined) ||
                 (isRectangleEnd == true && isEditMode == false))
                )) {
                context.moveTo(data.start.x, data.start.y);
                context.lineTo(data.start.x, data.end.y);
                context.lineTo(data.end.x, data.end.y);
                context.lineTo(data.end.x, data.start.y);
                context.closePath();
                context.stroke();
            }

            context.setLineDash([]);
            if(isEditMode == undefined || isEditMode) {
                var radius = (4 * imageRenderer.viewportHeight) / (1000 * imageRenderer.scaleValue) ;
                context.lineWidth = radius;
                context.beginPath();
                context.strokeStyle = "#DAA520";
                context.arc(data.start.x, data.start.y, radius, 0, 2 * Math.PI, false);
                context.closePath();
                context.stroke();

                context.beginPath();
                context.strokeStyle = "#DAA520";
                context.arc(data.start.x, data.end.y, radius, 0, 2 * Math.PI, false);
                context.closePath();
                context.stroke();

                context.beginPath();
                context.strokeStyle = "#DAA520";
                context.arc(data.end.x, data.end.y, radius, 0, 2 * Math.PI, false);
                context.closePath();
                context.stroke();

                context.beginPath();
                context.strokeStyle = "#DAA520";
                context.arc(data.end.x, data.start.y, radius, 0, 2 * Math.PI, false);
                context.closePath();
                context.stroke();
            }
        }

        var isText = (data.measurementSubType === "text") ? true : false;
        if(isRectangleEnd != undefined && data.measurementSubType === "hounsfield")
        {
            if(isRectangleEnd)
            {
                resultText = calculateStandardDeviation(imageUid, context, imageCoordinate, presentation, imageRenderer);
                drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, false, false, false, true);
                return resultText;
            }
            else
            {
                drawMeasurementsLength(context, data, imageRenderer, presentation, imageCoordinate.measurementResult, false, false, false, true);
            }
        } else if((isEdit && isText) || (isRectangleEnd != undefined && isText)) {
            if ((isEdit) || (isRectangleEnd && data.measurementText !== undefined && data.measurementText.length > 0)) {
                resultText = data.measurementText;
                drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, false, false, true);
            }
        }
        return null;
    }

    function drawPointMeasurement(imageUid, context, data, presentation, imageRenderer, editValue) {
        var imageCoordinate = data;
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var scale = presentation.getZoom();
        var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);

        var resultText = null;
        if (dicomHeader.imageInfo.measurement != null) {
            if ((dicomHeader.imageInfo.measurement.usRegions != null) && (dicomHeader.imageInfo.measurement.usRegions.length > 0)) {
                var usRegionFound = false;
                var regionSpatialFormat = 0;
                var physicalUnitsXDirection = 0;
                var physicalUnitsYDirection = 0;
                var roiPosXValue = 0.0;
                var roiPosYValue = 0.0;
                var isReferencePixelX0Present = false;
                var isReferencePixelY0Present = false;

                for (var i = 0; i < dicomHeader.imageInfo.measurement.usRegions.length; i++) {
                    var usRegion = dicomHeader.imageInfo.measurement.usRegions[i];

                    if (((usRegion.regionSpatialFormat == 2) || (usRegion.regionSpatialFormat == 3)) &&
                        ((imageCoordinate.start.x <= usRegion.regionLocationMaxX1) && (imageCoordinate.start.x >= usRegion.regionLocationMinX0)) &&
                        ((imageCoordinate.start.y <= usRegion.regionLocationMaxY1) && (imageCoordinate.start.y >= usRegion.regionLocationMinY0))) {
                        usRegionFound = true;
                        regionSpatialFormat = usRegion.regionSpatialFormat;
                        physicalUnitsXDirection = usRegion.physicalUnitsXDirection;
                        physicalUnitsYDirection = usRegion.physicalUnitsYDirection;
                        isReferencePixelX0Present = usRegion.isReferencePixelX0Present;
                        isReferencePixelY0Present = usRegion.isReferencePixelY0Present;

                        if (isReferencePixelX0Present) {
                            roiPosXValue = (imageCoordinate.start.x - (usRegion.regionLocationMinX0 + usRegion.referencePixelX0) + usRegion.referencePixelPhysicalValueX) * usRegion.physicalDeltaX;
                        }

                        if (isReferencePixelY0Present) {

                            if (usRegion.regionSpatialFormat == 2)
                            // M-Mode
                                roiPosYValue = -((usRegion.regionLocationMinY0 + usRegion.referencePixelY0) - imageCoordinate.end.y + usRegion.referencePixelPhysicalValueY) * Math.abs(usRegion.physicalDeltaY);
                            else
                            // Spectral
                                roiPosYValue = ((usRegion.regionLocationMinY0 + usRegion.referencePixelY0) - imageCoordinate.end.y + usRegion.referencePixelPhysicalValueY) * Math.abs(usRegion.physicalDeltaY);
                        }

                        break;
                    }
                }

                if (usRegionFound) {

                    var unitsX;
                    var unitsY;
                    if ((physicalUnitsXDirection < 0) || (physicalUnitsXDirection > 12)) {
                        unitsX = "unknown";
                    } else if ((physicalUnitsYDirection < 0) || (physicalUnitsYDirection > 12)) {
                        unitsY = "unknown";
                    } else {
                        unitsX = physicalUnitsXYDirectionArray[physicalUnitsXDirection];
                        unitsY = physicalUnitsXYDirectionArray[physicalUnitsYDirection];
                    }

                    if ((!isReferencePixelX0Present) && (isReferencePixelY0Present)) {
                        if (imageCoordinate.measurementType == 1) {
                            // Y- Axis
                            resultText = formatMeasurementResult(roiPosYValue, unitsY, imageCoordinate.measurementUnits);
                            //resultText = "" + roiPosYValue.toFixed(2) + " " + unitsY;
                        } else {

                            resultText = formatMeasurementResult(null, unitsX, imageCoordinate.measurementUnits);
                            //resultText = "n/a " + unitsX;
                        }
                    } else if ((isReferencePixelX0Present) && (!isReferencePixelY0Present)) {
                        if (imageCoordinate.measurementType == 1) {
                            // Y- Axis
                            resultText = formatMeasurementResult(null, unitsY, imageCoordinate.measurementUnits);
                            //resultText = "n/a " + unitsY;
                        } else {
                            resultText = formatMeasurementResult(roiPosXValue, unitsX, imageCoordinate.measurementUnits);
                            //resultText = "" + roiPosXValue.toFixed(2) + " " + unitsX;
                        }
                    } else if ((!isReferencePixelX0Present) && (!isReferencePixelY0Present)) {
                        if (imageCoordinate.measurementType == 1) {
                            // Y- Axis
                            resultText = formatMeasurementResult(null, unitsY, imageCoordinate.measurementUnits);
                            //resultText = "n/a " + unitsY;
                        } else {
                            resultText = formatMeasurementResult(null, unitsX, imageCoordinate.measurementUnits);
                            //resultText = "n/a " + unitsX
                        }
                    } else
                    if (imageCoordinate.measurementType == 1) {
                        // Y- Axis
                        resultText = formatMeasurementResult(roiPosYValue, unitsY, imageCoordinate.measurementUnits);
                        //resultText = "" + roiPosYValue.toFixed(2) + " " + unitsY;
                    } else {
                        resultText = formatMeasurementResult(roiPosXValue, unitsX, imageCoordinate.measurementUnits);
                        //resultText = "" + roiPosXValue.toFixed(2) + " " + unitsX;
                    }
                } else {
                    resultText = "" + (imageCoordinate.end.x).toFixed(0) + " pix, " + (imageCoordinate.end.y).toFixed(0) + " pix";
                }
            } else {
                resultText = "" + (imageCoordinate.end.x).toFixed(0) + " pix, " + (imageCoordinate.end.y).toFixed(0) + " pix";
            }
        } else {
            resultText = "" + (imageCoordinate.end.x).toFixed(0) + " pix, " + (imageCoordinate.end.y).toFixed(0) + " pix";
        }

        if (editValue === undefined) {
            // draw the line
            context.beginPath();
            updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
            //var rectSize = 2 / (imageRenderer.scaleValue / scale);
            var rectSize = (3 * imageRenderer.viewportHeight) / (1000 * imageRenderer.scaleValue) ;
            //context.fillRect(data.end.x, data.end.y, rectSize, rectSize);
            context.arc(data.end.x, data.end.y, rectSize, 0, 2 * Math.PI, false);
            if (data.start.handleActive)
                context.fillStyle = '#DAA520';
            else
                context.fillStyle = data.style.lineColor;
            context.fill();
            context.closePath();

            context.stroke();

            drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, true);
        }

        // for reporting
        if ((usRegionFound) && (imageCoordinate.measurementId != null)) {
            return {
                id: imageCoordinate.measurementId,
                value: resultText
            };
        }

        return null;
    }

    function drawTraceMeasurement(imageUid, context, data, presentation, imageRenderer, drawTraceEnd, averageX, averageY, isEditMode) {
        var imageCoordinate = data;
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var scale = presentation.getZoom();
        var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
        var usRegionFound = false;

        // draw the line
        context.beginPath();
        if (isEditMode == undefined || isEditMode)
            context.fillStyle = '#DAA520';
        else
            context.fillStyle = data.style.lineColor;
        var rectSize = 2 / (imageRenderer.scaleValue / scale);
        //context.fillRect(data.end.x, data.end.y, rectSize, rectSize);
        context.arc(data.start.x, data.start.y, rectSize, 0, 2 * Math.PI, false);
        context.closePath();
        context.fill();
        context.beginPath();
        updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
        context.moveTo(data.start.x, data.start.y);
        context.lineTo(data.end.x, data.end.y);
        context.setLineDash([5/scale, 10/scale]);
        context.closePath();
        context.stroke();

        if (drawTraceEnd) {
            // Draw the text
            resultText = "" + (averageX) + " pix, " + (averageY) + " pix";
            drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, false);

            // for reporting
            if ((usRegionFound) && (imageCoordinate.measurementId != null)) {
                return {
                    id: imageCoordinate.measurementId,
                    value: resultText
                };
            }
        }
        return null;
    }

    // Draw angle 
    function drawAngleMeasurement(imageUid, context, data, presentation, imageRenderer, isEditMode) {
        var imageCoordinate = data;
        
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var scale = presentation.getZoom();
        
        // draw the line
        context.beginPath();
        updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
        var rectSize = 2 / (imageRenderer.scaleValue / scale);
        
        if (data.start.handleActive)
            context.fillStyle = '#DAA520';
        else
            context.fillStyle = data.style.lineColor;
        context.fill();
        context.moveTo(data.start.x, data.start.y);
        context.lineTo(data.end.x, data.end.y);
        context.setLineDash([]);
        context.closePath();
        context.stroke();
        if (isEditMode == undefined || isEditMode) {
            drawLineHandles(imageUid, context, data, presentation, imageRenderer);
        }
        return null;
    }
    
/**
 * Calculates the angle (in degree) between two vectors pointing outward from one center
 *
 * @param p0 first point
 * @param p1 second point
 * @param c center point
 */
    function calculateAngle(p0,p1,c) {
        var p0c = Math.sqrt(Math.pow(c.x-p0.x,2)+Math.pow(c.y-p0.y,2)); // p0->c (b)   
        var p1c = Math.sqrt(Math.pow(c.x-p1.x,2)+Math.pow(c.y-p1.y,2)); // p1->c (a)
        var p0p1 = Math.sqrt(Math.pow(p1.x-p0.x,2)+Math.pow(p1.y-p0.y,2)); // p0->p1 (c)
    
        var angleRad = Math.acos((p1c*p1c+p0c*p0c-p0p1*p0p1)/(2*p1c*p0c));
        var resultDeg = (angleRad*180)/Math.PI;
        return resultDeg.toFixed(2);
    }
        
    function drawMitralMeanGradientMeasurement(imageUid, context, data, presentation, imageRenderer, drawTraceEnd, gadiantValues, isEditMode) {
        var imageCoordinate = data;
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        data.textPosition = imageCoordinate.textPosition;
        var scale = presentation.getZoom();
        var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
        var usRegionFound = false;

        // draw the line
        context.beginPath();
        if (isEditMode == undefined || isEditMode)
            context.fillStyle = '#DAA520';
        else
            context.fillStyle = data.style.lineColor;
        var rectSize = 2 / (imageRenderer.scaleValue / scale);
        //context.fillRect(data.end.x, data.end.y, rectSize, rectSize);
        context.arc(data.start.x, data.start.y, rectSize, 0, 2 * Math.PI, false);
        context.closePath();
        context.fill();
        context.beginPath();
        updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
        context.moveTo(data.start.x, data.start.y);
        context.lineTo(data.end.x, data.end.y);
        context.setLineDash([5/scale, 10/scale]);
        context.closePath();
        context.stroke();

        if (drawTraceEnd) {
            // Draw the text
            if (gadiantValues.Unit == "pix") {
                resultText = "" + (gadiantValues.PixelX) + " pix, " + (gadiantValues.PixelY) + " pix";
            } else {
                resultText = "" + (gadiantValues.Value) + " " + gadiantValues.Unit;
            }

            drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, false);

            // for reporting
            if (imageCoordinate.measurementId != null) {
                return {
                    id: imageCoordinate.measurementId,
                    value: resultText
                };
            }
        }
        return null;
    }

    /**
     * Draw the free hand measurement
     */ 
    function drawFreeHandMeasurement(imageUid, context, data, presentation,
                                      imageRenderer, drawTraceEnd, isEditMode, measurements) {
        try
        {
            var imageCoordinate = data;
            data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
            var scale = presentation.getZoom();

            context.beginPath();
            if (isEditMode == undefined || isEditMode) {
                context.fillStyle = '#DAA520';
            } else {
                context.fillStyle = data.style.lineColor;
            }

            var rectSize = 2 / (imageRenderer.scaleValue / scale);
            context.arc(data.start.x, data.start.y, rectSize, 0, 2 * Math.PI, false);
            context.closePath();
            context.fill();

            // Draw line
            if(measurements != undefined) {
                if(measurements.length >= 2) {
                    context.beginPath();
                    context.setLineDash([]);
                    context.moveTo.apply(context, measurements[0]);

                    // Draw the line curve
                    var length = measurements.length;
                    for (var i = 0; 0 <= length ? i < length : i > length; 0 <= length ? i++ : i--) {
                        addCurveSegment(context, i, measurements);
                    }
                    var lineJoin = context.lineJoin;
                    var lineCap = context.lineCap;
                    updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
                    context.lineJoin = 'round';
                    context.lineCap = 'round';
                    context.stroke();
                    context.lineJoin = lineJoin;
                    context.lineCap = lineCap;
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Draw pen
     */ 
    function drawPenMeasurement(imageUid, context, data, presentation,
                                      imageRenderer, isEditMode) {
        try
        {
            var imageCoordinate = data;
            data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
            var scale = presentation.getZoom();
            var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
            var usRegionFound = false;

            // draw the line
            context.beginPath();
            if (isEditMode == undefined || isEditMode)
                context.fillStyle = '#DAA520';
            else
                context.fillStyle = data.style.lineColor;
            var rectSize = 2 / (imageRenderer.scaleValue / scale);
            //context.fillRect(data.end.x, data.end.y, rectSize, rectSize);
            context.closePath();
            context.fill();
            context.beginPath();
            updateContextStyle(context, data.style, false, imageRenderer.scaleValue);
            context.lineJoin = 'round';
            context.lineCap = 'round';
            context.moveTo(data.start.x, data.start.y);
            context.lineTo(data.end.x, data.end.y);
            context.setLineDash([]);
            context.closePath();
            context.stroke();
        }
        catch(e)
        { }
    }

    /**
     * Calculate the line distance
     * @param {Type} a - Specifies the point 1
     * @param {Type} b - Specifies the point 2
     */ 
    function distance(a, b) {
        return Math.sqrt(Math.pow(a[0] - b[0], 2) + Math.pow(a[1] - b[1], 2));
    }

    /**
     * Add the curve segment
     */ 
    function addCurveSegment (context, i, points) {
        try
        {
            var averageLineLength, du, end, pieceCount, pieceLength, s, start, t, u, _ref, _ref2, _ref3;
            s = Smooth(points, smoothConfig);
            averageLineLength = 1;
            pieceCount = 2;

            for (t = 0, _ref = 1 / pieceCount; t < 1; t += _ref) {
                _ref2 = [s(i + t), s(i + t + 1 / pieceCount)], start = _ref2[0], end = _ref2[1];
                pieceLength = distance(start, end);
                du = averageLineLength / pieceLength;
                for (u = 0, _ref3 = 1 / pieceCount; 0 <= _ref3 ? u < _ref3 : u > _ref3; u += du) {
                    context.lineTo.apply(context, s(i + t + u));
                }
            }

            context.lineTo.apply(context, s(i + 1));
        }
        catch(e)
        { }
    }

    function getAvgMitralMeanGradients(imageUid, measurements) {

        if (measurements == null || measurements.length == 0) {
            return null;
        }

        var isSameUnits = true;
        var isNanVal = false;

        var avgGradiants = {
            Value: 0,
            PixelX: 0,
            PixelY: 0,
            Unit: ""
        };
        for (var index = 0; index < measurements.length; index++) {
            var data = measurements[index];
            var gradientVal = getAvgMitralMeanGradient(imageUid, data);
            if (gradientVal.Unit != "pix") {
                gradientVal.PixelX = (data.start.x).toFixed(0);
                gradientVal.PixelY = (data.start.y).toFixed(0);
            } else {
                isSameUnits = false;
            }

            if (gradientVal.Value == "N/A") {
                isNanVal = true;
            }

            avgGradiants.PixelX = parseInt((avgGradiants.PixelX)) + parseInt((gradientVal.PixelX));
            avgGradiants.PixelY = parseInt((avgGradiants.PixelY)) + parseInt((gradientVal.PixelY));
            avgGradiants.Value = (isNanVal == false ? parseFloat((avgGradiants.Value).toFixed(2)) + parseFloat((gradientVal.Value)) : 0);
            avgGradiants.Unit = (isSameUnits == false ? "pix" : gradientVal.Unit);
        }

        avgGradiants.PixelX = (avgGradiants.PixelX / measurements.length).toFixed(0);
        avgGradiants.PixelY = (avgGradiants.PixelY / measurements.length).toFixed(0);
        avgGradiants.Value = (isNanVal == false ? (avgGradiants.Value / measurements.length).toFixed(2) : "N/A ");
        return avgGradiants;
    }

    function getAvgMitralMeanGradient(imageUid, data) {
        var imageCoordinate = data;
        var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);

        var resultText = {};
        if (dicomHeader.imageInfo.measurement != null) {
            if ((dicomHeader.imageInfo.measurement.usRegions != null) && (dicomHeader.imageInfo.measurement.usRegions.length > 0)) {
                var usRegionFound = false;
                var regionSpatialFormat = 0;
                var physicalUnitsXDirection = 0;
                var physicalUnitsYDirection = 0;
                var roiPosXValue = 0.0;
                var roiPosYValue = 0.0;
                var isReferencePixelX0Present = false;
                var isReferencePixelY0Present = false;

                for (var i = 0; i < dicomHeader.imageInfo.measurement.usRegions.length; i++) {
                    var usRegion = dicomHeader.imageInfo.measurement.usRegions[i];

                    if (((usRegion.regionSpatialFormat == 2) || (usRegion.regionSpatialFormat == 3)) &&
                        ((imageCoordinate.start.x <= usRegion.regionLocationMaxX1) && (imageCoordinate.start.x >= usRegion.regionLocationMinX0)) &&
                        ((imageCoordinate.start.y <= usRegion.regionLocationMaxY1) && (imageCoordinate.start.y >= usRegion.regionLocationMinY0))) {
                        usRegionFound = true;
                        regionSpatialFormat = usRegion.regionSpatialFormat;
                        physicalUnitsXDirection = usRegion.physicalUnitsXDirection;
                        physicalUnitsYDirection = usRegion.physicalUnitsYDirection;
                        isReferencePixelX0Present = usRegion.isReferencePixelX0Present;
                        isReferencePixelY0Present = usRegion.isReferencePixelY0Present;

                        if (isReferencePixelX0Present) {
                            roiPosXValue = (imageCoordinate.start.x - (usRegion.regionLocationMinX0 + usRegion.referencePixelX0) + usRegion.referencePixelPhysicalValueX) * usRegion.physicalDeltaX;
                        }

                        if (isReferencePixelY0Present) {

                            if (usRegion.regionSpatialFormat == 2)
                            // M-Mode
                                roiPosYValue = -((usRegion.regionLocationMinY0 + usRegion.referencePixelY0) - imageCoordinate.start.y + usRegion.referencePixelPhysicalValueY) * Math.abs(usRegion.physicalDeltaY);
                            else
                            // Spectral
                                roiPosYValue = ((usRegion.regionLocationMinY0 + usRegion.referencePixelY0) - imageCoordinate.start.y + usRegion.referencePixelPhysicalValueY) * Math.abs(usRegion.physicalDeltaY);
                        }

                        break;
                    }
                }

                if (usRegionFound) {

                    var unitsX;
                    var unitsY;
                    if ((physicalUnitsXDirection < 0) || (physicalUnitsXDirection > 12)) {
                        unitsX = "unknown";
                    } else if ((physicalUnitsYDirection < 0) || (physicalUnitsYDirection > 12)) {
                        unitsY = "unknown";
                    } else {
                        unitsX = physicalUnitsXYDirectionArray[physicalUnitsXDirection];
                        unitsY = physicalUnitsXYDirectionArray[physicalUnitsYDirection];
                    }

                    if ((!isReferencePixelX0Present) && (isReferencePixelY0Present)) {
                        if (imageCoordinate.measurementType == 5) // Y- Axis
                            return formatMitralGradientMeasurement(roiPosYValue, unitsY, imageCoordinate.measurementUnits);
                        //resultText = "" + roiPosYValue.toFixed(2) + " " + unitsY;
                        else
                            return formatMitralGradientMeasurement(null, unitsX, imageCoordinate.measurementUnits);
                        //resultText = "n/a " + unitsX;
                    } else if ((isReferencePixelX0Present) && (!isReferencePixelY0Present)) {
                        if (imageCoordinate.measurementType == 5) // Y- Axis
                            return formatMitralGradientMeasurement(null, unitsY, imageCoordinate.measurementUnits);
                        //resultText = "n/a " + unitsY;
                        else
                            return formatMitralGradientMeasurement(roiPosXValue, unitsX, imageCoordinate.measurementUnits);
                        //resultText = "" + roiPosXValue.toFixed(2) + " " + unitsX;
                    } else if ((!isReferencePixelX0Present) && (!isReferencePixelY0Present)) {
                        if (imageCoordinate.measurementType == 5) // Y- Axis
                            return formatMitralGradientMeasurement(null, unitsY, imageCoordinate.measurementUnits);
                        //resultText = "n/a " + unitsY;
                        else
                            return formatMitralGradientMeasurement(null, unitsX, imageCoordinate.measurementUnits);
                        //resultText = "n/a " + unitsX
                    } else
                    if (imageCoordinate.measurementType == 5) // Y- Axis
                        return formatMitralGradientMeasurement(roiPosYValue, unitsY, imageCoordinate.measurementUnits);
                    //resultText = "" + roiPosYValue.toFixed(2) + " " + unitsY;
                    else
                        return formatMitralGradientMeasurement(roiPosXValue, unitsX, imageCoordinate.measurementUnits);
                    //resultText = "" + roiPosXValue.toFixed(2) + " " + unitsX;
                } else {
                    //resultText = "" + (imageCoordinate.start.x).toFixed(0) + " pix, " + (imageCoordinate.end.y).toFixed(0) + " pix";
                }
            } else {
                //resultText = "" + (imageCoordinate.start.x).toFixed(0) + " pix, " + (imageCoordinate.start.y).toFixed(0) + " pix";
            }
        } else {
            //resultText = "" + (imageCoordinate.start.x).toFixed(0) + " pix, " + (imageCoordinate.start.y).toFixed(0) + " pix";
        }

        resultText.Value = 0;
        resultText.PixelX = (imageCoordinate.start.x).toFixed(0);
        resultText.PixelY = (imageCoordinate.start.y).toFixed(0);
        resultText.Unit = "pix";

        return resultText;
    }

    // Determine length(pixel) of point on line from midpoint based on image zoom percentage
    function getLenAsPerZoom(zoomVal)
	{
        // Check whether the typof of zoomval and convert back to float to avoid the viewer crash
        if(typeof zoomVal == "string"){
            zoomVal = parseFloat(zoomVal);
        }

        var zoomValue = zoomVal.toFixed(2);
        var length = 10;
        if(zoomValue >= "2.5"){
			length = 5;		
		} else if(zoomValue < "2.5" && zoomValue >= "1.00"){
            length = 10;
        } else if(zoomValue < "1.00" && zoomValue >= "0.80"){
            length = 15;
        } else if(zoomValue < "0.80" && zoomValue >= "0.60"){
            length = 20;
        } else if(zoomValue < "0.60" && zoomValue >= "0.40"){
            length = 30;
        } else if(zoomValue < "0.40" && zoomValue >= "0.20"){
            length = 50;
        }else if(zoomValue < "0.20" && zoomValue >= "0.10"){
            length = 60;
        }else if(zoomValue < "0.10"){
            length = 80;
        }
        return length;
    }
	
    // Get point on angle tool lines to draw small point betweent them
	function getPointOnLine(x1,y1,x2,y2,zoomVal){
        
        // Determine line lengths
        var xlen = x2 - x1;
        var ylen = y2 - y1;

        // Determine hypotenuse length 
        var hlen = Math.sqrt(Math.pow(xlen,2) + Math.pow(ylen,2));

        // The variable identifying the length of the `shortened` line.
        // In this case 10 units.
        var smallerLen = getLenAsPerZoom(zoomVal);

        // Determine the ratio between they shortened value and the full hypotenuse.
        var ratio = smallerLen / hlen;

        var smallerXLen = xlen * ratio;
        var smallerYLen = ylen * ratio;

        var Point ={
            x:x1 + smallerXLen,
            y:y1 + smallerYLen
        };
     return Point;
    }
	
   // Draw Angle values, arc and angle unit
    function drawAngleValue(context, firstLine, secondLine, imageRenderer, presentation, resultText, angleUnit){
        
        var firstLineData = dicomViewer.measurement.getCanvasDataForImageData(firstLine, imageRenderer);
        var PointToStart = getPointOnLine(firstLineData.end.x,firstLineData.end.y,firstLineData.start.x,firstLineData.start.y,presentation.zoom);   
        
        var secondLineData = dicomViewer.measurement.getCanvasDataForImageData(secondLine, imageRenderer);
        secondLineData.textPosition = secondLine.textPosition;
        // firstLineData.end is always center point
        var secondPointX;
        var secondPointY;
        if(firstLineData.end.x == secondLineData.end.x){
            secondPointX = secondLineData.start.x;
            secondPointY = secondLineData.start.y;
        }else{
            secondPointX = secondLineData.end.x;
            secondPointY = secondLineData.end.y;
        }
        var PointToEnd = getPointOnLine(firstLineData.end.x,firstLineData.end.y,secondPointX,secondPointY,presentation.zoom);
                
        // Draw the small line
        context.beginPath();
        updateContextStyle(context, firstLineData.style, false, imageRenderer.scaleValue);
        context.moveTo(PointToStart.x, PointToStart.y);
        context.lineTo(PointToEnd.x, PointToEnd.y);
        context.closePath();
        context.stroke();
        
        // Draw angle value  and unit
        var textX = firstLineData.end.x;
        var textY = firstLineData.end.y;
        var scale = presentation.getZoom();
        updateContextStyle(context, firstLineData.style, true, imageRenderer.scaleValue);
        context.save();

        context.translate(textX, textY);
        context.rotate(-1 * (presentation.getRotation() * Math.PI / 180));
        if(imageRenderer.isPrint == true && presentation.isFlipHorizontalRequired){
            if (presentation.rotation && (presentation.rotation !== 180 && presentation.orientation !== 6) ) {
                context.scale(1, -1);
            } else {
                context.scale(-1, 1);
            } 
        } else if (presentation.vFlip && presentation.hFlip) {
            context.scale(-1, -1);
        } else if (presentation.hFlip) {
            context.scale(-1, 1);
        } else if (presentation.vFlip) {
            context.scale(1, -1);
        } else {
            context.scale(1, 1);
        }

        var newTextX = 35;
        var delY = 15;
        
        if(!isNaN(resultText)) {
            var textWidth = context.measureText(text).width;
            if(secondLineData.textPosition == "right") {
                context.textAlign = "start";
                context.fillText(angleUnit, newTextX, delY);
                context.textAlign = "end";
                context.textBaseline="top";
                context.fillText(" " + resultText, newTextX, delY);
                context.restore();
                return;
            }
            if(secondLineData.textPosition == "left") {
                newTextX = -(3/2*textWidth + (15 / imageRenderer.scaleValue));
            }
            //Shifting the text more up if it is going outside the bottom of the viewport
            if(secondLineData.textPosition == "top") {
                delY = - (15 / imageRenderer.scaleValue);
            }
            if(secondLineData.textPosition == "top-left") {
                newTextX = -(3/2*textWidth + (15 / imageRenderer.scaleValue));
                delY = - (15 / imageRenderer.scaleValue);
            }
            
//            console.log(secondLineData.textPosition)
            context.textAlign = "start";
            context.fillText(angleUnit, newTextX, delY );
            context.textAlign = "end";
            context.textBaseline="top";
            context.fillText(" " + resultText, newTextX, delY);
            if(fontSize <= 15) {
                delY+= (15 / imageRenderer.scaleValue);
            }else {
                delY+=fontSize;
            }
        }

        context.closePath();
        context.stroke();
        context.restore();
    }

   // Draw Lines of angle measurement tool
    function drawMeasurementsLength(context, data, imageRenderer, presentation, resultText, isPoint, isEllipse, isText, isRect) {
        var textX;
        var textY;
        if (isText) {
            updateContextStyle(context, data.style, true, imageRenderer.scaleValue, true);
            var fontSize = data.style.fontSize / imageRenderer.scaleValue;
            var width = data.end.x - data.start.x;
            var height = data.end.y - data.start.y;
            if (data.end.x < data.start.x) {
                width = data.start.x - data.end.x;
            } if (data.end.y < data.start.y) {
                height = data.start.y - data.end.y;
            }
            //Text annotation rectangle coordinates
            x1 = Math.min(data.start.x, data.end.x);
            x2 = Math.max(data.start.x, data.end.x);
            y1 = Math.min(data.start.y, data.end.y);
            y2 = Math.max(data.start.y, data.end.y);
            
            if(presentation.rotation == 90 ||presentation.rotation == 270) {
                //switching the width and height of the rectangle
                temp = width;
                width = height;
                height = temp;
            }
            //On the basis of orientation of the image, rendering the result text starting at the top-left corner of the rectangle
            switch(presentation.orientation) {
                    case 0 : textX = x1; //0 degree
                             textY = y1 + fontSize;
                             break;
                    case 1 : textX = x2 - fontSize; // 270 degree
                             textY = y1;
                             break;
                    case 2 : textX = x2; // 180 degree
                             textY = y2 - fontSize;
                             break;
                    case 3 : textX = x1 + fontSize; // 90 degree
                             textY = y2;
                             break;
                    case 4 : textX = x2; //0 degree
                             textY = y1 + fontSize;
                             break;
                    case 5 : textX = x1 + fontSize; // 270 degree
                             textY = y1;
                             break;
                    case 6 : textX = x1; // 180 degree
                             textY = y2 - fontSize;
                             break;
                    case 7 : textX = x2 - fontSize; // 270 degree
                             textY = y2;
                           }
            
            context.save();
            context.translate(textX, textY);
            context.rotate(-1 * (presentation.getRotation() * Math.PI / 180));
            if(imageRenderer.isPrint == true && presentation.isFlipHorizontalRequired){
                if (presentation.rotation && (presentation.rotation !== 180 && presentation.orientation !== 6) ) {
                    context.scale(1, -1);
                } else {
                    context.scale(-1, 1);
                } 
            } else if (presentation.vFlip && presentation.hFlip) {
                context.scale(-1, -1);
            } else if (presentation.hFlip) {
                context.scale(-1, 1);
            } else if (presentation.vFlip) {
                context.scale(1, -1);
            } else {
                context.scale(1, 1);
            }

            var words = data.measurementText.split("\n");
            var actualLineIndex = 0;
            for (var i = 0; i < words.length; i++) {
                var prependText = "";
                var appendText = "";
                var diffX = "";
                var isAppend = false;
                var lineHeight = actualLineIndex * fontSize;

                if (words[i] == "") {
                    continue;
                } else {
                    actualLineIndex++;
                }

                if (lineHeight > height - fontSize) {
                    break;
                }

                var textWidth = context.measureText(words[i]);
                var perTextWidth = textWidth.width / words[i].length;

                diffX =  words.length ? parseInt(width) : 0 ;
                isAppend = false;

                if (diffX > parseInt(perTextWidth * 2)) {
                    var sliceIndex = parseInt(diffX / perTextWidth);

                        // get the slice index by word ends
                        var splitText = words[i].split(/\s+/);
                        var previousWordPos = 0;
                        for(var k = 0; k < splitText.length; k++ ) {
                            var currentLength = (splitText[k].length) + 1;
                            if(currentLength == sliceIndex || previousWordPos == sliceIndex) {
                                sliceIndex = currentLength;
                                break;
                            } else if((previousWordPos + currentLength) >= sliceIndex ) {
                                sliceIndex = previousWordPos == 0 ? sliceIndex : previousWordPos;
                                break;
                            }
                            previousWordPos += currentLength;
                        }

                        var trimmedText = words[i].slice(0, sliceIndex);
                        var trimmedTextWidth = context.measureText(trimmedText);
                        var perTextWidth = trimmedTextWidth.width / trimmedText.length;

                        if (trimmedTextWidth.width > parseInt(width)) {
                            diffX =  trimmedTextWidth.width - parseInt(width);
                            var sliceIndex = parseInt(diffX / perTextWidth);
                            var slicedText = trimmedText.slice(sliceIndex, trimmedText.length);
                            words.splice(i+1, 0, slicedText);
                            slicedText = words[i].slice(trimmedText.length, words[i].length);
                            words.splice(i+2, 0, slicedText);
                            words[i] = trimmedText.slice(0, sliceIndex);
                            i--;
                            actualLineIndex--;
                            continue;
                        } else if (trimmedTextWidth.width < parseInt(textWidth.width / 4)) {
                            if (words[i+1] !== undefined) {
                                words[i+1] = words[i] + words[i+1];
                                words.splice(i, 1);
                                i--;
                                actualLineIndex--;
                                continue;
                            }
                        }
                        prependText = words[i].slice(sliceIndex, words[i].length);
                        if (i == words.length - 1) {
                            words[i] = trimmedText;
                            words.push(prependText);
                        } else {
                            words[i] = trimmedText;
                            words.splice(i+1, 0, prependText);
                        } 
                }
                context.fillText(words[i], 0, lineHeight);
            }

            context.restore();
            return;
        } else if (isEllipse || isRect) {
            updateContextStyle(context, data.style, true, imageRenderer.scaleValue);
            var fontSize = data.style.fontSize / imageRenderer.scaleValue;
            var textX = (data.start.x + data.end.x) / 2;
            var textY = (data.start.y + data.end.y) / 2;
            var delY=0;
            context.save();
            context.translate(textX, textY);
            context.rotate(-1 * (presentation.getRotation() * Math.PI / 180));
            if(imageRenderer.isPrint == true && presentation.isFlipHorizontalRequired){
                if (presentation.rotation && (presentation.rotation !== 180 && presentation.orientation !== 6) ) {
                    context.scale(1, -1);
                } else {
                    context.scale(-1, 1);
                } 
            } else if (presentation.vFlip && presentation.hFlip) {
                context.scale(-1, -1);
            } else if (presentation.hFlip) {
                context.scale(-1, 1);
            } else if (presentation.vFlip) {
                context.scale(1, -1);
            } else {
                context.scale(1, 1);
            }
            
            //Whether it is ellipse or rectangle the start and end points will be this
            if (isRect) {
                var rectangle = {
                    x1 : Math.min(data.start.x, data.end.x),
                    x2 : Math.max(data.start.x, data.end.x)
                };
            } else {
                var rectangle = {
                    x1 : Math.min(data.first.x, data.second.x, data.third.x, data.fourth.x),
                    x2 : Math.max(data.first.x, data.second.x, data.third.x, data.fourth.x)
                };
                
            }
            textX = (rectangle.x2 - rectangle.x1) / 2;
            var textWidth = context.measureText(text).width;
            
            //Switching the text at the left side if it is going outside the right-end of the viewport
            if(data.textPosition == "left") {
                newTextX = -(textX + 2*textWidth + (30 / imageRenderer.scaleValue));
                lineX = -textX - (30 / imageRenderer.scaleValue);
            } else {
                newTextX = textX + (30 / imageRenderer.scaleValue);
                lineX = textX;
            }
            
            //Shifting the text more up if it is going outside the bottom of the viewport
            if(data.textPosition == "top") {
                delY = delY - (30 / imageRenderer.scaleValue);
            }
            
            if(data.textPosition == "top-left") {
                newTextX = -(textX + 2*textWidth + (30 / imageRenderer.scaleValue));
                lineX = -textX - (30 / imageRenderer.scaleValue);
                delY = delY - (30 / imageRenderer.scaleValue);
            }

            for(var iIndex=0; iIndex < resultText.length; iIndex++){
                var text = resultText[iIndex];
                context.fillText(" " + text, newTextX, delY);
                if(fontSize <= 15) {
                delY+= (15 / imageRenderer.scaleValue);
                }else {
                    delY+=fontSize;
                }
            }
            if (resultText.length > 0) {
                context.beginPath();
                context.moveTo(lineX, 0);
                context.lineTo(lineX + (30 / imageRenderer.scaleValue), 0);
                context.setLineDash([2, 2]);
                context.stroke();
            }
            context.restore();
            return;
        } else if (isPoint) {
            var scale = presentation.getZoom();
            updateContextStyle(context, data.style, true, imageRenderer.scaleValue);
            var textX = data.end.x;
            var textY = data.end.y;
            context.save();
            var txtDistance = 4 / (imageRenderer.scaleValue / scale);
            if(presentation.getOrientation() % 4 == 2 || presentation.getOrientation() % 4 == 1) txtDistance = -1 * txtDistance;
            context.translate(textX + txtDistance, textY - txtDistance);
            context.rotate(-1 * (presentation.getRotation() * Math.PI / 180));
            var delY=0;
            var newTextX = 0;
            var aTextX = (data.start.x - data.end.x) / 2;

                if(imageRenderer.isPrint == true && presentation.isFlipHorizontalRequired){
            if (presentation.rotation && (presentation.rotation !== 180 && presentation.orientation !== 6) ) {
                context.scale(1, -1);
            } else {
                context.scale(-1, 1);
            } 
        } else if (presentation.vFlip && presentation.hFlip) {
            context.scale(-1, -1);
        } else if (presentation.hFlip) {
            context.scale(-1, 1);
        } else if (presentation.vFlip) {
            context.scale(1, -1);
        } else {
            context.scale(1, 1);
        }

        if(data.textPosition == "right") {
            context.fillText(" " + resultText, 0, 15);
            context.restore();
            return;
        }
        var textWidth = context.measureText(text).width;
        if(data.textPosition == "left") {
            newTextX = -(3/2*textWidth + (15 / imageRenderer.scaleValue));
            delY = 15;
        }
        //Shifting the text more up if it is going outside the bottom of the viewport
        if(data.textPosition == "top") {
            newTextX = 0;
            delY = - (15 / imageRenderer.scaleValue);
        }
        if(data.textPosition == "top-left") {
            newTextX = -(3/2*textWidth + (15 / imageRenderer.scaleValue));
            delY = - (15 / imageRenderer.scaleValue);
        }
        context.fillText(" " + resultText, newTextX, delY);
        if(fontSize <= 15) {
            delY+= (15 / imageRenderer.scaleValue);
        }else {
            delY+=fontSize;
        }
        context.restore();
        } else {
            updateContextStyle(context, data.style, true, imageRenderer.scaleValue);
            var textX = (data.start.x + data.end.x) / 2;
            var atext = (data.start.x - data.end.x) / 2;
            var textY = (data.start.y + data.end.y) / 2;
            var textWidth = resultText.length;
            var delY=0;
            context.save();
            context.translate(textX, textY);
            context.rotate(-1 * (presentation.getRotation() * Math.PI / 180));

        if(imageRenderer.isPrint == true && presentation.isFlipHorizontalRequired){
            if (presentation.rotation && (presentation.rotation !== 180 && presentation.orientation !== 6) ) {
                context.scale(1, -1);
            } else {
                context.scale(-1, 1);
            } 
        } else if (presentation.vFlip && presentation.hFlip) {
            context.scale(-1, -1);
        } else if (presentation.hFlip) {
            context.scale(-1, 1);
        } else if (presentation.vFlip) {
            context.scale(1, -1);
        } else {
            context.scale(1, 1);
        }

            if(data.textPosition == "right") {
               context.fillText(" " + resultText, 0, 0);
               context.restore();
               return;
               }
         //Switching the text at the left side if it is going outside the right-end of the viewport
            if(data.textPosition == "left") {
                newTextX = -7*textWidth - (15/imageRenderer.scaleValue);
                delY=0;
            }
            //Shifting the text more up if it is going outside the bottom of the viewport
            if(data.textPosition == "top") {
                newTextX = 0;
                delY = delY - (15 / imageRenderer.scaleValue);
            }
            
            if(data.textPosition == "top-left") {
                newTextX = -7*textWidth - (15/imageRenderer.scaleValue);
                delY = delY - (15 / imageRenderer.scaleValue);
            }

            context.fillText(" " + resultText, newTextX, delY);
             if(fontSize <= 15) {
                delY+= (15 / imageRenderer.scaleValue);
            }else {
                delY+=fontSize;
            }
        context.restore();
        }
    }
    
    function getIntersectionPoint(x1, y1, x2, y2, x3, y3, x4, y4) {
        var d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0) return null;

        var xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
        var yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;


        if (xi < Math.min(x1, x2) || xi > Math.max(x1, x2)) return null;
        if (xi < Math.min(x3, x4) || xi > Math.max(x3, x4)) return null;

        return {
            x: xi,
            y: yi
        };
    }

    function formatMeasurementResult(result, units, desiredUnits) {

        if ((desiredUnits != null) && (units == "cm/sec")) {

            if (result == null)
                return "N/A " + desiredUnits;

            if (desiredUnits == "m/s") {
                result /= 100.0;
                return "" + Math.abs(result.toFixed(2)) + " " + desiredUnits;
            } else if (desiredUnits == "mmHg") {
                result /= 100.0;
                result = (result * result) * 4.0;
                return "" + Math.abs(result.toFixed(2)) + " " + desiredUnits;
            }
        }

        if (result == null)
            return "N/A " + units;
        else
            return "" + Math.abs(result.toFixed(2)) + " " + units;
    }

    function formatMitralGradientMeasurement(result, units, desiredUnits) {

        var gradiantResult = {
            Value: "",
            Unit: ""
        }
        if ((desiredUnits != null) && (units == "cm/sec")) {

            if (result == null) {
                gradiantResult.Value = "N/A";
                gradiantResult.Unit = desiredUnits;
                return gradiantResult;
            }

            if (desiredUnits == "m/s") {
                result /= 100.0;
                gradiantResult.Value = result.toFixed(2);
                gradiantResult.Unit = desiredUnits;
                return gradiantResult;
            } else if (desiredUnits == "mmHg") {
                result /= 100.0;
                result = (result * result) * 4.0;
                gradiantResult.Value = result.toFixed(2);
                gradiantResult.Unit = desiredUnits;
                return gradiantResult;
            }
        }

        if (result == null) {
            gradiantResult.Value = "N/A";
            gradiantResult.Unit = units;
            return gradiantResult;
        } else {
            gradiantResult.Value = Math.abs(result.toFixed(2));
            gradiantResult.Unit = units;
            return gradiantResult;
        }
    }

    function getLengthText(data) {
        var dx = (data.start.x - data.end.x);
        var dy = (data.start.y - data.end.y);
        var lengthInPixels = Math.sqrt(dx * dx + dy * dy);

        return "" + lengthInPixels.toFixed(2) + " pix";
    }

    // not defined for empty array
    function findIndexOfGreatest(elements) {
        var max = elements[0];
        var maxIndex = 0;

        for (var i = 1; i < elements.length; i++) {
            if (elements[i] > max) {
                maxIndex = i;
                max = elements[i];
            }
        }
        return maxIndex;
    }

    function getLengthUsingPixelSpacing(data, pixelSpacing, bInCM) {

        var dx = Math.abs(data.start.x - data.end.x);
        var dy = Math.abs(data.start.y - data.end.y);

        dx *= pixelSpacing.column;
        dy *= pixelSpacing.row;

        var lengthInCM = undefined;
        if (dx == 0.0) lengthInCM = dy;
        else if (dy == 0.0) lengthInCM = dx;
        else lengthInCM = dy / (Math.sin(Math.atan(dy / dx)));

        if(bInCM)
            lengthInCM /= 10.0;

        return lengthInCM;
    }

    function getDisplayLengthText(value, isCalibrated, isMeasurementCompleted, theUnitType, isOwnerPixelSpacing) {
        if(dicomViewer.tools.getFlagFor2dLengthCalibration() && !isMeasurementCompleted){
            return "";
        }

        var unit = "cm";
        var resultValue = value;
        var unitType = "";

        if(theUnitType != undefined) {
            unitType = theUnitType;
        } else {
            unitType = dicomViewer.measurement.getDefaultLineMeasurementUnit();
        }

        if (unitType == "UNITS_MM") {
            unit = "mm";
            resultValue = resultValue * 10.0;
        } else if (unitType == "UNITS_INCHES") {
            unit = "in";
            resultValue = resultValue / 2.54;
        }

        unit = " " + unit + (isCalibrated == true ? " (c*)" : (isOwnerPixelSpacing == false ? " (c)" : ""));
        var resultText = "" + resultValue.toFixed(2) + unit;

        return resultText;
    }

    function drawLineHandles(imageUid, context, data, presentation, imageRenderer) {
        //console.log("Draw line handles");

        var scale = presentation.getZoom();
        if (data.end.handleActive || data.start.handleActive) {
            context.beginPath();
            context.strokeStyle = '#DAA520';
            var radius = (4 * imageRenderer.viewportHeight) / (1000 * imageRenderer.scaleValue) ;
            context.lineWidth = radius;
            context.arc(data.end.x, data.end.y, radius, 0, 2 * Math.PI, false);
            context.closePath();
            context.stroke();
            context.beginPath();
            context.arc(data.start.x, data.start.y, radius, 0, 2 * Math.PI, false);
            context.closePath();
            context.stroke();
            if (data.measurementSubType != "Arrow") {
                return;
            }
        } else if(data.measureType == "angle") {
            return;
        }
        var lengthOfSlope = (10 * imageRenderer.viewportHeight) / (1000 * imageRenderer.scaleValue) ;
        var slope = (data.start.y - data.end.y) / (data.start.x - data.end.x);
        var startHandle = getHandlePoint(data.start.x, data.start.y, lengthOfSlope, slope)
        var endHandle = getHandlePoint(data.end.x, data.end.y, lengthOfSlope, slope)

        var isFill = (data.measurementSubType == "Arrow") ? true : false;
        updateContextStyle(context, data.style, isFill, imageRenderer.scaleValue);
        if(data.measurementSubType == "Arrow") {
            drawArrow(context, data.end.x, data.end.y, data.start.x, data.start.y, imageRenderer.scaleValue);
        } else {
            drawLine(context, imageRenderer, startHandle, endHandle);
        }
    }

     /**
     * draw line measurement
     * @param context - specifies the 2d context
     * @param imageRenderer - specifies the image render
     * @param startHandle - specifies the start handle
     * @param endHandle - specifies the end handle
     */
    function drawLine(context, imageRenderer, startHandle, endHandle) {
        // draw the line
        context.beginPath();
        context.moveTo(startHandle[0].x, startHandle[0].y);
        context.lineTo(startHandle[1].x, startHandle[1].y);
        context.moveTo(endHandle[0].x, endHandle[0].y);
        context.lineTo(endHandle[1].x, endHandle[1].y);
        context.closePath();
        context.stroke();
    }

     /**
     * draw arrow
     * @param context - specifies the 2d context
     * @param x1 - specifies the first point
     * @param y1 - specifies the second point
     * @param x2 - specifies the third point 
     * @param y2 - specifies the fourth point
     */
    function drawArrow(context, x1, y1, x2, y2, scaleValue) {
        var ang = Math.atan2(y2-y1,x2-x1);
        if(ang != 0) {
            context.beginPath();
            context.moveTo(x1,y1);
            // default arrow array
            var arrow = [[ 2, 0 ], [ -10, -4 ], [ -10, 4]];
            for(pt in arrow) {
                // scaling the arrow dimensions with respect to the scale value
                arrow[pt][0] = arrow[pt][0]/scaleValue;
                arrow[pt][1] = arrow[pt][1]/scaleValue;
            }
            drawFilledPolygon(context, translateShape(rotateShape(arrow, ang),x2,y2));
        }
    }

     /**
     * fill arrow polygon
     * @param context - specifies the 2d context
     * @param shape - specifies the shape whether angle or polygon like that.
     */
    function drawFilledPolygon(context, shape) {
        context.beginPath();
        context.moveTo(shape[0][0], shape[0][1]);
        
        for(p in shape)
            if (p > 0) context.lineTo(shape[p][0], shape[p][1]);
        context.lineTo(shape[0][0], shape[0][1]);
        context.fill();
    }

     /**
     * draw arrow like shape
     * @param shape - specifies the shape whether angle or polygon like that.
     * @param ang - specifies the angle
     */
    function rotateShape(shape, ang) {
        var rv = [];
        for(p in shape)
            rv.push(rotatePoint(ang,shape[p][0],shape[p][1]));
        return rv;
    }
    
     /**
     * translate the shape
     * @param shape - specifies the shape whether angle or polygon like that.
     * @param x - specifies the first point
     * @param y - specifies the second point
     */
    function translateShape(shape,x,y) {
        var rv = [];
        for(p in shape)
            rv.push([ shape[p][0] + x, shape[p][1] + y ]);
        return rv;
    }

     /**
     * rotate the point
     * @param ang - specifies the angle
     * @param x - specifies the first point
     * @param y - specifies the second point.
     */
    function rotatePoint(ang,x,y) {
        return [
            (x * Math.cos(ang)) - (y * Math.sin(ang)),
            (x * Math.sin(ang)) + (y * Math.cos(ang))
        ];
    }

    function getHandlePoint(px, py, length, slope) {
        // if slope is 0 or undefined, we can't use our regular formula
        if (slope === 0) {
            return [{
                x: px,
                y: py + length
            }, {
                x: px,
                y: py - length
            }];
        } else if (slope === undefined) {
            return [{
                x: px + length,
                y: py
            }, {
                x: px - length,
                y: py
            }];
        } else {
            var m = -1 / slope;
            var x1 = (Math.pow(m, 2) * px + length * Math.sqrt(Math.pow(m, 2) + 1) + px) / (Math.pow(m, 2) + 1);
            var x2 = (Math.pow(m, 2) * px - length * Math.sqrt(Math.pow(m, 2) + 1) + px) / (Math.pow(m, 2) + 1);
            var y1 = m * (x1 - px) + py;
            var y2 = m * (x2 - px) + py;
            return [{
                x: parseFloat(x1.toFixed(1)),
                y: parseFloat(y1.toFixed(1))
            }, {
                x: parseFloat(x2.toFixed(1)),
                y: parseFloat(y2.toFixed(1))
            }];
        }
    }

    function setMeasurementType(type, id, units) {
        measurementType = type;
        measurementId = id;
        measurementUnits = units;
    }

    function getMeasurementType() {
        return {
            measurementType: measurementType,
            measurementId: measurementId,
            measurementUnits: measurementUnits
        };
    }
    
    //Return true when the cine is playing on the selected viewport
    function isMeasuremntDisabled(){
        var imageElement = document.getElementById("playButton_wrapper").getElementsByTagName('img')[0];
        var playerButtomImage = imageElement.src;
        if(playerButtomImage.indexOf("stop.png") > -1 ) {
            return true;
        } else {
          return false;  
        }
    }
    
    /**
    * 
    * @param {Type} value 
    */ 
    function sign(value)
    {
        return ( value >= 0) ? 1 : -1;
    }
    
    /**
    * Calculate the mean value of the region
    * @param {Type}  
    */ 
    function calculateStandardDeviation(imageUid, context, data, presentation, imageRenderer, editValue)
    {         
        var imageCanvas;
        imageRenderer.imagePromise.then(function(image){
            imageCanvas = image;
        });
        
        var displayString = [];
        var startX = Math.min(Math.round(data.start.x), Math.round(data.end.x));
        var startY = Math.min(Math.round(data.start.y), Math.round(data.end.y));
        
        var endX = Math.max(Math.round(data.start.x), Math.round(data.end.x));
        var endY = Math.max(Math.round(data.start.y), Math.round(data.end.y));
        
        var ptStart = { x: startX, y: startY };
        var ptEnd = { x: endX, y: endY };       
    
        var nSgnX = sign(ptEnd.x - ptStart.x);
        var nSgnY = sign(ptEnd.y - ptStart.y);
        var numberOfPixels = 0;
    
        var nAggregate = 0;
        var ptDifferenceX = Math.abs(ptEnd.x - ptStart.x) / 2;
        var ptDifferenceY = Math.abs(ptEnd.y - ptStart.y) / 2;
        var dXOverA = 0;
            var dYOverB = 0;
        var mean = 0;
        var pixelList = [];
        var ptOrigin =
            {
            x : (ptStart.x + ptEnd.x) / 2,
            y : (ptStart.y + ptEnd.y) / 2
            }
    
        // Calculate the mean value
        var isValidRegion = (ptDifferenceX > 1 ? true : (ptDifferenceY > 1 ? true : false));
        var imageData =  dicomViewer.imageCache.getImageData(imageCanvas, imageRenderer.imageCanvas.canvasId);
        if(imageCanvas!== undefined && imageData !== undefined && isValidRegion)
        {
            var nPixelValue;
            for (var j = ptStart.y ; j <= ptEnd.y ; j += 1 * nSgnY)
            {
                for (var i = ptStart.x ; i <= ptEnd.x ; i += 1 * nSgnX)
                {
                   dXOverA = ((i - ptOrigin.x) / ptDifferenceX);
                   dYOverB = ((j - ptOrigin.y) / ptDifferenceY);

                    nPixelValue = imageData[(imageCanvas.columns * j) + i];
                    if(nPixelValue === undefined) {
                         nPixelValue = imageCanvas.minPixel;
                    }

                    pixelList.push(nPixelValue);
                    nAggregate += nPixelValue;
                    numberOfPixels++;
                }
            }

            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            var measurementUnit = null; 
            var pixelSpacing = (measurementUnit = getUnitMeasurementMap(seriesLayout.studyUid+"|"+imageRenderer.seriesIndex+"|"+imageRenderer.imageIndex+"|"+imageRenderer.anUIDs.split("*")[1])) ?measurementUnit.pixelSpacing : undefined;
            
            // Check for pixel spacing
            if(pixelSpacing === undefined){
                var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
                pixelSpacing = dicomHeader.imageInfo.measurement.pixelSpacing
            }

            var unitType = measurementUnit ? measurementUnit.unitType : undefined ;
            mean = (nAggregate / numberOfPixels).toFixed(2);
            var stdDevMean = mean;
            if(presentation !== undefined && presentation !== null) {
                var slope = presentation.lookupObj.rescaleSlope;
                var intercept = presentation.lookupObj.rescaleIntercept;
                mean = parseFloat(mean) * slope + intercept;
            }

            displayString.push("Area: "+getEllipseArea(numberOfPixels, pixelSpacing, unitType));
            displayString.push("Avg: "+parseFloat(mean).toFixed(2));
            displayString.push("StdDev: "+getEllipseStdDev(pixelList, stdDevMean, numberOfPixels));   
        }
        return displayString;
    }
    
    /**
    * To get the area string
    * @param {Type} numberOfPixels - No of pixels in the selected region
    */ 
    function getEllipseArea(numberOfPixels, pixelSpacing, unit)
    {
        var pixelSpacingX = 1.0;
        var pixelSpacingY = 1.0;
    
        if(pixelSpacing.column !== undefined){
            pixelSpacingX = pixelSpacing.column;
        }
        if(pixelSpacing.row !== undefined){
            pixelSpacingX = pixelSpacing.row;
        }

        // Calculate the area
        var area = numberOfPixels * pixelSpacingX * pixelSpacingY;
        if (unit === undefined || unit === null ) {
            unit = dicomViewer.measurement.getDefaultLineMeasurementUnit();
            area /= 10;
        }

        // Convert to other units if needed
        var areaString = "";
        switch(unit)
        {
            case  "UNITS_MM":
                area = area * 10.0;
                suffix = "sqmm";
            break;
            case "UNITS_CM":
                 area /= 10;
                suffix = "sqcm";
            break;

            case "UNITS_INCHES":
                area = (area / (25.4 * 25.4)) * 10;
                suffix = "sqin";
            break;
        }
    
        areaString = area.toFixed(2) + " " + suffix;    
        return areaString;
    }

    /**
     * Get the standard deviation
     * @param {Type} pixelList - Pixels with in the region
     * @param {Type} average - Mean value
     * @param {Type} numberOfPixels - No Of pixels
     */ 
    function getEllipseStdDev(pixelList, average, numberOfPixels)
    {         
        if(pixelList.length > 1)
        {
            var nAggregateSE = 0;
            pixelList.forEach(function(pixelValue)
            {
                nAggregateSE += ((pixelValue - average) * (pixelValue - average));
            });

            return Math.sqrt(nAggregateSE / (numberOfPixels - 1)).toFixed(2);
        }
        return 0;
    }

     /**
     * To draw WindowLevelROI measurement
     * @param {Type} imageUid 
     * @param {Type} context 
     * @param {Type} data 
     * @param {Type} presentation 
     * @param {Type} imageRenderer 
     */ 
    function drawWindowLevelROIMeasurement(imageUid, context, data, presentation, imageRenderer, isRectangleEnd, isEnd) {
        var imageCoordinate = data;
        data = dicomViewer.measurement.getCanvasDataForImageData(data, imageRenderer);
        
        var deltaY = (data.end.y - data.start.y);
        var deltaX = (data.end.x - data.start.x);
        var result = 0;
        if(data.start.y < data.end.y)
            result = Math.abs(Math.atan2(deltaY, deltaX));
        else
            result = Math.abs(Math.atan2(deltaY, deltaX)) * -1;
        
        if (data !== undefined) {
            context.save();
            context.beginPath();
            //Restore and draw
            context.restore();
            context.strokeStyle = '#CCCC66';
            var radius = (3 * imageRenderer.viewportHeight) / (1000 * imageRenderer.scaleValue) ;
            context.lineWidth = radius;
            //Create rectangle
            context.moveTo(data.start.x, data.start.y);
            context.lineTo(data.start.x, data.end.y);
            context.lineTo(data.end.x, data.end.y);
            context.lineTo(data.end.x, data.start.y);
            
            context.closePath();
            context.stroke();
        }
        
        return null;
    }

    /**
     * To get the ROI WindowLevel values
     * @param {Type} imageUid 
     * @param {Type} context 
     * @param {Type} data 
     * @param {Type} presentation 
     * @param {Type} imageRenderer 
     */ 
    function GetROIWindowLevelValues(imageUid, context, data, presentation, imageRenderer)
    {
        var imageCanvas;
        imageRenderer.imagePromise.then(function(image){
            imageCanvas = image;
        });

        var displayString = [];
        var startX = Math.min(Math.round(data.start.x), Math.round(data.end.x));
        var startY = Math.min(Math.round(data.start.y), Math.round(data.end.y));
        
        var endX = Math.max(Math.round(data.start.x), Math.round(data.end.x));
        var endY = Math.max(Math.round(data.start.y), Math.round(data.end.y));
        
        var ptStart = { x: startX, y: startY };
        var ptEnd = { x: endX, y: endY };       

        var nSgnX = sign(ptEnd.x - ptStart.x);
        var nSgnY = sign(ptEnd.y - ptStart.y);
        var numberOfPixels = 0;
    
        var nAggregate = 0;
        var ptDifferenceX = Math.abs(ptEnd.x - ptStart.x) / 2;
        var ptDifferenceY = Math.abs(ptEnd.y - ptStart.y) / 2;
        var dXOverA = 0;
            var dYOverB = 0;
        var mean = 0;
        var pixelList = [];
        var ptOrigin =
            {
            x : (ptStart.x + ptEnd.x) / 2,
            y : (ptStart.y + ptEnd.y) / 2
            }

        // Calculate the mean value
        var imageData =  dicomViewer.imageCache.getImageData(imageCanvas, imageRenderer.imageCanvas.canvasId);
        if(imageCanvas !== undefined && imageData !== undefined && ptDifferenceX > 1 && ptDifferenceY > 1)
        {
            var nPixelValue;
            for (var j = ptStart.y ; j <= ptEnd.y ; j += 1 * nSgnY)
            {
                for (var i = ptStart.x ; i <= ptEnd.x ; i += 1 * nSgnX)
                {
                   dXOverA = ((i - ptOrigin.x) / ptDifferenceX);
                   dYOverB = ((j - ptOrigin.y) / ptDifferenceY);

                   // Check whether the pixel is inside the selected region
                   //if (dXOverA * Math.abs(dXOverA) + dYOverB * Math.abs(dYOverB) <= 1)
                   {
                       //nPixelValue = context.getImageData(i, j, 1, 1).data[0];                       
                       nPixelValue = imageData[(imageCanvas.columns * j) + i];
                       if(nPixelValue === undefined) {
                           nPixelValue = imageCanvas.minPixel;
                       }
                       pixelList.push(nPixelValue);
                       nAggregate += nPixelValue;
                       numberOfPixels++;
                   }
                }
            }
            
            mean = (nAggregate / numberOfPixels).toFixed(2);
            return {
                level  : parseInt(mean),
                window : parseInt(getEllipseStdDev(pixelList, mean, numberOfPixels))
            };
        }
    }

    /**
     * get and update the text bounds
     * @param {Type} context - Specifies the context
     * @param {Type} data - Specifies the data
     * @param {Type} imageRenderer - Specifies the image renderer
     */ 
    function getAndUpdateTextBounds(context, data, imageRenderer) {
        try
        {
            if(data.measurementSubType !== "text") {
                return data;
            }

            var height = data.end.y - data.start.y;
            if (data.end.y < data.start.y) {
                height = data.start.y - data.end.y;
            }

            // To avoid the external presentation text rendering
            if(height == 0) {
                var fontSize = 15 / imageRenderer.scaleValue;
                var lineWidth = data.style.lineWidth / imageRenderer.scaleValue;
                data.end.x = data.start.x + context.measureText(data.measurementText).width + (lineWidth * 2);
                data.end.y = data.start.y + fontSize + (lineWidth * 2);
            }

            return data;
        }
        catch(e)
        { }

        return data;
    }

    /**
     * Get the measurement style
     */ 
    function getMeasurementStyle() {
        return measurementStyle;
    }
    
    function updateContextStyle(context, measurementStyle, isFill, scaleValue, isText) {
        if(isText) {
            context.fillStyle = measurementStyle.textColor;
        } else if (isFill) {
            context.fillStyle = measurementStyle.lineColor;
        } else {
            context.strokeStyle = measurementStyle.lineColor;
        }

        var fontStyle = "normal";
        if (measurementStyle.isItalic && measurementStyle.isBold) {
            fontStyle = "italic bold";
        } else if (measurementStyle.isItalic) {
            fontStyle = "italic";
        } if (measurementStyle.isBold) {
            fontStyle = "bold";
        }
        context.lineWidth = measurementStyle.lineWidth / scaleValue;
        context.font = fontStyle +  " " + (measurementStyle.fontSize / scaleValue) + "px" + " " + measurementStyle.fontName;
    }

    dicomViewer.measurement.draw = {
        drawMeasurements: drawMeasurements,
        setMeasurementType: setMeasurementType,
        getMeasurementType: getMeasurementType,
        getHandlePoint: getHandlePoint,
        getMousePointForImageCoordinates: getMousePointForImageCoordinates,
        getImageCoordinatesForMousePoint: getImageCoordinatesForMousePoint,
        getCanvasCoordinatesForImageCoordinates: getCanvasCoordinatesForImageCoordinates,
        drawLineMeasurement: drawLineMeasurement,
        drawPointMeasurement: drawPointMeasurement,
        setMeasurementStyle: setMeasurementStyle,
        getMeasurementStyle: getMeasurementStyle,
        isMeasuremntDisabled: isMeasuremntDisabled,
        drawWindowLevelROIMeasurement : drawWindowLevelROIMeasurement,
        GetROIWindowLevelValues : GetROIWindowLevelValues
    };

    return dicomViewer;
}(dicomViewer));var dicomViewer = (function(dicomViewer){
	
	if(dicomViewer === undefined)
	{
		dicomViewer = {};
	}
    
    function drawUSRegions(context,imageInfo,presentation)
    {
        var usRegions = imageInfo.getUSRegions();
        if(usRegions === undefined)
        {
            return;
        }
        for(var i=0;i<usRegions.length;i++)
        {
            drawRegions(context,usRegions[i],presentation);
        }
    }
    
    function drawRegions(context,region,presentation)
    {
        var cordinates = getRegionCordinatesInCanvas(region,presentation);
        
        context.beginPath();
        context.rect(cordinates.x0, cordinates.y0, (cordinates.x1 - cordinates.x0) , (cordinates.y1 - cordinates.y0));       
        context.lineWidth = 1/presentation.getZoom();
        context.strokeStyle = 'blue';
        context.setLineDash([15]);
        context.stroke();
    }
    
    function getRegionCordinatesInCanvas(region,presentation)
    {         
        if(presentation === undefined)
        {
            throw "getRegionCordinatesInCanvas: presentation is null/undefined";
        }
        var pan = presentation.getPan();
        var canvasCoordinates = {};
        canvasCoordinates.x0 = region.regionLocationMinX0 +  pan.x;
        canvasCoordinates.x1 = region.regionLocationMaxX1 +  pan.x;
        canvasCoordinates.y0 = region.regionLocationMinY0 + pan.y;
        canvasCoordinates.y1 = region.regionLocationMaxY1 + pan.y;
        
        return canvasCoordinates;
    }
    
  
    
    dicomViewer.draw = {
        usRegion : {
                        drawUSRegions : drawUSRegions,
                        drawRegions : drawRegions
            }
    };
    
    return dicomViewer;
    
}(dicomViewer));/**
 * This module deals with ImageLoaders, loading images and caching images
 */

var dicomViewer = (function(dicomViewer) {

    "use strict";

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    //This varibale help to enable or disable the jpeg or png request
    var jpegLoaderEnabled = true;
    
    //Return true or false based on the jpeg image request is enabled or disabled
    function isJpegEnabled() {
        return jpegLoaderEnabled;
    }
    
    function loadImageFromImageLoader(studyUid, imageUid, frameNumber, imageType) {
        var imagePromise = getDicomInfo(studyUid, imageUid, frameNumber, imageType);
        return imagePromise;
    }


    // Loads an image given an imageUid and returns a promise which will resolve
    // to the loaded image object or fail if an error occurred.  The loaded image
    // is not stored in the cache
    function loadImage(imageUid, frameNumber) {
        if (imageUid === undefined) {
            throw "loadImage: parameter imageUid must not be undefined";
        }

        var imagePromise = dicomViewer.imageCache.getImagePromise(imageUid + "_" + frameNumber);
        if (imagePromise !== undefined) {
            return imagePromise;
        }

        imagePromise = loadImageFromImageLoader(imageUid, frameNumber);
        if (imagePromise === undefined) {
            throw "loadImage: no image loader for imageUid";
        }

        return imagePromise;
    }
    
    // Loads an image given an imageUid and returns a promise which will resolve
    // to the loaded image object or fail if an error occurred.  The image is
    // stored in the cache
    function loadAndCacheImage(studyUid, imageUid, frameNumber, seriesIndex, imageType) {


        if (imageUid === undefined) {
            throw "loadAndCacheImage: parameter imageUid must not be undefined";
        }

        var imagePromise = dicomViewer.imageCache.getImagePromise(imageUid + "_" + frameNumber);
        if (imagePromise !== undefined) {
            return imagePromise;
        }
        
        if(!dicomViewer.isCacheEnabled())
        {            
            var imageIndex =  parseInt( dicomViewer.Series.Image.getImageIndex(studyUid, seriesIndex, imageUid));
            dicomViewer.setCacheDataToCache(studyUid,seriesIndex,imageIndex,frameNumber);
            dicomViewer.startCacheImages(studyUid,true);
        }
        imagePromise = dicomViewer.imageCache.getImagePromise(imageUid + "_" + frameNumber);
        if (imagePromise !== undefined) {
            return imagePromise;
        }
        imagePromise = loadImageFromImageLoader(studyUid, imageUid, frameNumber, imageType);
        if (imagePromise === undefined) {
            throw "loadAndCacheImage: no image loader for imageUid";
        }
        dicomViewer.imageCache.putImagePromise(studyUid, imageUid, frameNumber, imagePromise, seriesIndex);
        return imagePromise;
    }


    // registers an imageLoader plugin with dicomViewer for the specified scheme
    function registerImageLoader(scheme, imageLoader) {
        imageLoaders[scheme] = imageLoader;
    }

    // Registers a new unknownImageLoader and returns the previous one (if it exists)
    function registerUnknownImageLoader(imageLoader) {
        var oldImageLoader = unknownImageLoader;
        unknownImageLoader = imageLoader;
        return oldImageLoader;
    }

    function updateImage(imageCanvas, image, presentation) {
        //var presentation = image.presentation;
        var lookUpTable = presentation.getlookupTable();
        imageCanvas.height = image.rows;
        imageCanvas.width = image.columns;
        var context = imageCanvas.getContext("2d");
        context.setTransform(1, 0, 0, 1, 0, 0);
        // clear the canvas
        context.fillStyle = 'black';
        context.fillRect(0, 0, image.columns, image.rows);

        if (image.isWLApplied == false ||
            image.lastAppliedwindowCenter != presentation.windowCenter || 
            image.lastAppliedWindowWidth != presentation.windowWidth || 
            image.lastAppliedInvert != presentation.invert || 
            image.lastAppliedRGBMode != presentation.rgbMode ||
            image.lastAppliedSharpenLevel != presentation.sharpen ||
            image.is6000Overlay != dicomViewer.tools.is6000OverlayVisible()) {
                // Update the flags
                image.lastAppliedwindowCenter = presentation.windowCenter;
                image.lastAppliedWindowWidth = presentation.windowWidth;
                image.lastAppliedInvert = presentation.invert;
                image.presentation.invert = presentation.invert;
                image.presentation.rgbMode = presentation.rgbMode;
                image.lastAppliedRGBMode = presentation.rgbMode;
                image.lastAppliedWindowLevel = presentation.windowLevel;
                image.is6000Overlay = dicomViewer.tools.is6000OverlayVisible();
                image.isWLApplied = true;
                image.presentation.sharpen = presentation.sharpen;
                image.lastAppliedSharpenLevel = presentation.sharpen;

                // Get the wl canvas context
                image.wlCanvasContext.fillStyle = 'white';
                image.wlCanvasContext.fillRect(0,0, image.wlCanvas.width, image.wlCanvas.height);
                image.wlCanvasData = image.wlCanvasContext.getImageData(0, 0, image.wlCanvas.width, image.wlCanvas.height);

                var imageData = dicomViewer.imageCache.getImageData(image, imageCanvas.canvasId);
                if (image.isColorImage) {
                    lookUpTable.applyColorLUT(imageData, image.wlCanvasData, image.columns, image.rows, presentation.getRGBMode());
                } else {
                    lookUpTable.applyLUT(imageData, image.wlCanvasData, image.columns, image.rows);

                    // Apply 6000 overlay
                    if(dicomViewer.tools.is6000OverlayVisible()) {
                        lookUpTable.apply6000Overlay(image, image.wlCanvasData);
                    }
                }
            
            image.wlCanvasContext.putImageData(image.wlCanvasData, 0, 0);
            image.wlCanvasData = null;

            // If applysharpen true then use sharpen tool
            // Sharpen tool will work once the canvas image is created
            if(image.applySharpen) {
                lookUpTable.applySharpen(image.wlCanvasContext, image.wlCanvas.width, image.wlCanvas.height, image.presentation.sharpen);
            }
        }

        context.drawImage(image.wlCanvas, 0,0, image.columns, image.rows, 0, 0, image.columns, image.rows);
    }

    function getDicomInfo(studyUid, imageUid, frameNumber,  imageType) {
		var deferred = $.Deferred();
        var urlParameters = dicomViewer.getImageInfoURl(imageUid);
        var defferedValue = undefined;
        var dicominfo = dicomViewer.header.getDicomHeader(imageUid);
        if (dicominfo === undefined) {
            var metaURL = dicomViewer.url.getDicomImageURL(urlParameters);
			logger.info("Imageinfo Request URL : "+metaURL);
            var w;
            var workerData = {
                request: "DicomInfo",
                url: metaURL
            };

            if (typeof(Worker) !== "undefined") {
                if(numberOfWebWorkers < 10){
                    if (typeof(w) == "undefined") {
                        w = new Worker("js/dicom/imageCacheWorker.js?v=20171017171723");
                    }
                    numberOfWebWorkers = numberOfWebWorkers+1;
                    w.postMessage(workerData);
                    w.onmessage = function(event) {						
                        numberOfWebWorkers = numberOfWebWorkers-1;
                        var text = event.data;

                        dicominfo = new ImageInfoManager(text);
                        var imageType = dicominfo.imageInfo.imageType;
                        var seriesTime = dicominfo.imageInfo.seriesTime;
                        //getting the div id to display series time inside the image thumbnails
                        var ImageThumbseriesTime = imageUid + "seriesTime";
                        var imageThumbnailDom = document.getElementById(ImageThumbseriesTime);
                        if (imageThumbnailDom != null) {
                            // document.getElementById(ImageThumbseriesTime).style.color = "#D2F4EF";
                            //document.getElementById(ImageThumbseriesTime).textContent = seriesTime;
                        }

                        //dicominfo.loadDICOMInfo(text);
                        var studyDetails = dicomViewer.getStudyDetails(studyUid);
                        if(dicominfo.imageInfo && dicominfo.imageInfo.overlays) {
                            if(!studyDetails.is6000OverLay) {
                                studyDetails.is6000OverLay = true;
                                showAndHide6000OverlayMenu(dicomViewer.getActiveSeriesLayout());
                            }
                        }
                        dicomViewer.header.putDicomHeader(imageUid, dicominfo);
                        loader(imageUid, frameNumber, dicominfo, urlParameters, deferred, studyUid);

                        w.terminate();
                        w = undefined;
                    };
                }
            } else {


                var def = dicomViewer.header.getDicomHeaderInfo(metaURL);

                def.done(function(text) {
                    var imageType = text.imageType;
                    dicominfo = new ImageInfoManager(text);
                    /* var seriesTime = dicominfo.imageInfo.seriesTime;
                    //getting the div id to display series time inside the image thumbnails
                    var ImageThumbseriesTime = imageUid + "seriesTime";
                    var imageThumbnailDom = document.getElementById(ImageThumbseriesTime);
                    if (imageThumbnailDom != null) {
                        document.getElementById(ImageThumbseriesTime).style.color = "#D2F4EF";
                        document.getElementById(ImageThumbseriesTime).textContent = seriesTime;
                    }
    */
                    //dicominfo.loadDICOMInfo(text);
                    dicomViewer.header.putDicomHeader(imageUid, dicominfo);
                    loader(imageUid, frameNumber, dicominfo, urlParameters, deferred, studyUid);

                });

            }
        } else {
            loader(imageUid, frameNumber, dicominfo, urlParameters, deferred, studyUid);

        }

        return deferred;
    }

	function roughSizeOfObject( object ) 
	{
		var objectList = [];
		var recurse = function( value )
		{
			var bytes = 0;
			if ( typeof value === 'boolean' )
			{
				bytes = 4;
			}
			else if ( typeof value === 'string' )
			{
				bytes = value.length * 2;
			}
			else if ( typeof value === 'number' ) 
			{
				bytes = 8;
			}
			else if
			(
				typeof value === 'object'
				&& objectList.indexOf( value ) === -1
			)
			{
				objectList[ objectList.length ] = value;
				for(var i in value ) 
				{
					bytes+= 8; // an assumed existence overhead
					bytes+= recurse( value[i] )
				}
			}
			return bytes;
		}
		return recurse( object );
	}

    function readImage(imageUid, frameNumber, dicominfo, fileContent, compressDone) {

        var renderImage;
        if (compressDone) {
            renderImage = fileContent;
        } else {
            var reader = new DicomInputStreamReader();
            reader.readDICOMBytes(fileContent);
            var dicomBuffer = reader.getInputBuffer();
            var dicomReader = reader.getReader();
            renderImage = prepareImage(dicominfo, dicomBuffer, dicomReader);
        }

        var pixelBuffer = renderImage.pixelArray;
        var minMaxPixel = renderImage.minMaxPixel;
        var image = {
            imageUid: imageUid,
            frameNumber: frameNumber,
            dicominfo: dicominfo,
            imageData: pixelBuffer,
            canvas: null,
            sizeInBytes: (isCacheCompressedImageData ? pixelBuffer.length : dicominfo.getFrameSize()),
            canvasCtx: null,
            presentation:  new Presentation(),
            lastAppliedInvert: false,
            lastAppliedRGBMode:0,
            rows: dicominfo.getRows(),
            columns: dicominfo.getColumns(),
            minPixel: minMaxPixel.min,
            maxPixel: minMaxPixel.max,
            invert: (dicominfo.getPhotometricInterpretation() === "MONOCHROME1" ? true : false),
            isColorImage: dicominfo.isColor(),
            imageType: "image",
            isWLApplied: false,
            bitsAllocated: dicominfo.getBitsAllocated(),
            isCompressed: isCacheCompressedImageData,
            minMaxPixel: minMaxPixel,
            isRGBToolEnabled: true,
            lastAppliedWindowLevel: 1,
            is6000Overlay: false,
            lastAppliedSharpenLevel: 0,
            applySharpen: isShowSharpen
        };

        /*************************************************************************
        * Create the separate canvas for WL
        * Referred from 'cornerstoneDemo' to improve performance in IE
        * http://chafey.github.io/cornerstoneDemo/
        **************************************************************************/        
        image.wlCanvas = document.createElement('canvas');
        image.wlCanvas.width = image.columns;
        image.wlCanvas.height = image.rows;
        image.wlCanvasContext = image.wlCanvas.getContext('2d');
        image.wlCanvasContext.fillStyle = 'white';
        image.wlCanvasContext.fillRect(0,0, image.wlCanvas.width, image.wlCanvas.height);
        image.wlCanvasData = null;

        // Calculate the render size
        image.renderSizeInBytes = getRenderSize(image);
        image.sizeInBytes *= 8;

        // Update window level
        updateWindowLevel(image);

        // Update the 6000 overlay
        update6000Overlay(image, 0);

        return image;
    }

    function readImageJPEG(imageUid, frameNumber, dicominfo, imageObj, deferred) {

        var row = dicominfo.getRows();
        var column = dicominfo.getColumns();
        var windowCenter = dicominfo.getWindowCenter();
        var windowWidth = dicominfo.getWindowWidth();
        var reScaleScope = dicominfo.getRescaleSlope();
        var reScaleIntercept = dicominfo.getRescaleIntercept();        
        
        var minMaxPixel = {
                min: dicominfo.getMinPixelValue(),
				max: dicominfo.getMaxPixelValue()
            };
        var windowLevelLimits = getWindowLevelLimits(minMaxPixel, dicominfo);
        var isColorImage = dicominfo.isColor();

        var invert = false;
        if (dicominfo.getPhotometricInterpretation() === "MONOCHROME1") {
            invert = true;
        }

         var autoCalWinLvl = false;
        if (isNaN(windowCenter) || isNaN(windowWidth)) {
            if (isColorImage) {
                windowCenter = 128;
                windowWidth = 255;
            } else {
                autoCalWinLvl = true;
            }
        }else if(windowCenter < 0 || windowCenter > Math.pow(2, dicominfo.getBitsStored()-1)-2)
                 autoCalWinLvl = true;
        else if(windowWidth < 0 || windowWidth > Math.pow(2, dicominfo.getBitsStored()-1)-2)
            autoCalWinLvl = true;
        if(autoCalWinLvl)
        {
            /*var minMaxFromPixel = findMinMax(dicominfo, pixelBuffer);
            var windowlevel = calculateAutoWindowLevel(dicominfo, minMaxFromPixel);
            windowCenter = windowlevel.wc;
            windowWidth = windowlevel.ww;*/
            windowCenter = 128;
            windowWidth = 255;
        }

        var presentation = new Presentation();
        presentation.setWindowingdata(windowCenter, windowWidth);
        presentation.setWindowLevel(dicominfo, minMaxPixel, invert);
        presentation.setWindowLevelLimits(windowLevelLimits);
        
        var backgroudRenderer = document.createElement("canvas");
        var context = backgroudRenderer.getContext("2d");
        
        imageObj.onload = function () {
            imageObj.type = "application/jpeg";
            dicominfo.setRows(imageObj.height);
            dicominfo.setColumns(imageObj.width);
            var sizeInBytes = imageObj.height * imageObj.width;
            var image = {
                imageUid: imageUid,
                frameNumber: frameNumber,
                dicominfo: dicominfo,
                imageData: imageObj,
                canvas: null,
                sizeInBytes: sizeInBytes,
                canvasCtx: null,
                presentation: presentation,
                windowWidth: windowWidth,
                windowCenter: windowCenter,
                lastAppliedWindowWidth: windowWidth,
                lastAppliedwindowCenter: windowCenter,
                lastAppliedInvert: false,
                rows: imageObj.height,
                columns: imageObj.width,
                minPixel: minMaxPixel.min,
                maxPixel: minMaxPixel.max,
                invert: invert,
                isColorImage: isColorImage,
                imageType: "image",
                isWLApplied: false,
                isRGBToolEnabled: false,
                lastAppliedWindowLevel:1
            };
            deferred.resolve(image);
        }
    }
    
    function loader(imageUid, frameNumber, dicominfo, urlParameters, deferred,  studyUid) {
         var imageType  ="";
		if(dicominfo != undefined)
         imageType = dicominfo.imageInfo.imageType;
        if(imageType === IMAGETYPE_JPEG && dicominfo.imageInfo.numberOfFrames == 1){
            loadJPEG(imageUid, frameNumber, urlParameters,deferred,dicominfo);
		}
        else if (imageType == IMAGETYPE_RADECHO || imageType == IMAGETYPE_RAD || imageType == null || imageType == IMAGETYPE_JPEG) {
            if((dicominfo.imageInfo.numberOfFrames > 1) && ( dicominfo.imageInfo.modality === "US" || imageType == IMAGETYPE_JPEG) ) {
                loadJPEG(imageUid, frameNumber, urlParameters,deferred,dicominfo);
            }
            else
            {
				urlParameters = dicomViewer.getDicomFrameUrl(imageUid, frameNumber);
				var url = dicomViewer.url.getDicomImageURL(urlParameters);
                logger.info("Imageinfo Request URL : "+url);
                logger.startTime("Img Request " + imageUid + "_" + frameNumber);

                var w;
                var workerData = {
                    request: "Image",
                    url: url,
                    dicominfo: dicominfo,
                    isDecompressionRequired: !isCacheCompressedImageData 
                };
                if (typeof(Worker) !== "undefined") {
					
					if(numberOfWebWorkers<=10){

                        if (typeof(w) == "undefined") {
                            w = new Worker("js/dicom/imageCacheWorker.js?v=20171017171723");
                        }
						numberOfWebWorkers = numberOfWebWorkers+1;
                        w.postMessage(workerData);
                        w.onmessage = function(event) {							
							numberOfWebWorkers = numberOfWebWorkers-1;
                            var image = readImage(imageUid, frameNumber, dicominfo, event.data, true);
                            deferred.resolve(image);

                            w.terminate();
                            w = undefined;
                        };
					}

                } else {

                        $.ajax({
                            url: url,
                            beforeSend: function(xhr) {
                                xhr.overrideMimeType("text/plain; charset=x-user-defined");
                            }
                        })
                            .done(function(data) {
                                var image = readImage(imageUid, frameNumber, dicominfo, data, false);
                                deferred.resolve(image);

                            })
                            .fail(function(data) {

                                deferred.reject();
                            })
                            .error(function(xhr, status) {
                                var description = xhr.statusText + "\nFailed to read the image." + "\nImage UID: " + imageUid;
                                sendViewerStatusMessage(xhr.status.toString(), description);
                            });

                }
                logger.endTime("Img Request " + imageUid + "_" + frameNumber);
                $("#ecgPreference").prop("disabled", true);
            }
        } else if (imageType == IMAGETYPE_RADPDF) {
            loadPdf(imageUid, frameNumber, urlParameters);
        } else if (imageType == IMAGETYPE_RADECG) {
		    dicomViewer.loadEcg(urlParameters, "imageviewer1x1");
		 }
        else if (imageType == IMAGETYPE_RADSR || imageType == IMAGETYPE_CDA) {
            dicomViewer.loadSR(urlParameters,null,deferred, imageType);
		 }
    }
    function loadJPEG(imageUid, frameNumber, urlParameters,deferred,dicominfo) {
        urlParameters =  dicomViewer.getJpegFrameUrl(imageUid, frameNumber);
		var url = dicomViewer.url.getDicomImageURL(urlParameters);
        logger.info("Imageinfo Request URL : "+url);
        logger.startTime("Img Request " + imageUid + "_" + frameNumber);

        /*var w;
        var workerData = {
            request: "Image",
            url: url,
            dicominfo: dicominfo
        };
        if (typeof(Worker) !== "undefined") {

                if (typeof(w) == "undefined") {
                    w = new Worker("js/dicom/imageCacheWorker.js?v=20171017171723");
                }
                w.postMessage(workerData);
                w.onmessage = function(event) {
                    var image = readImage(imageUid, frameNumber, dicominfo, event.data, true);
                    deferred.resolve(image);

                    w.terminate();
                    w = undefined;
                };

        } else {*/
            var imageObj = new Image();
            imageObj.type = "application/jpeg";
            imageObj.src = url;
            readImageJPEG(imageUid, frameNumber, dicominfo, imageObj, deferred);
            //deferred.resolve(image);
                /*$.ajax({
                    url: url,
                    beforeSend: function(xhr) {
                        xhr.overrideMimeType("text/plain; charset=x-user-defined");
                    }
                })
                    .done(function(data) {                        
                        var image = readImageJPEG(imageUid, frameNumber, dicominfo, data, false);
                        deferred.resolve(image);

                    })
                    .fail(function(data) {

                        deferred.reject();
                    });*/

        //}
        logger.endTime("Img Request " + imageUid + "_" + frameNumber);
        $("#ecgPreference").prop("disabled", true);
    }
    function loadPdf(imageUid, frameNumber, urlParameters) {
        $("#ecgPreference").prop("disabled", true);
		urlParameters =  dicomViewer.getPdfFrameUrl(imageUid);
        var url = dicomViewer.url.getDicomImageURL(urlParameters);
        $("#imageviewer1x1").empty();
        var pdfDiv = "<div id='pdf' style='height:100%;width:100%'><iframe name='pdfviewer1x1' style='height:100%;width:100%' src=" + url + "/></div>";
        // var pdfRender = new PdfRender("imageviewer1x1");
        // pdfRender.PdfCanvas(url);
        $("#imageviewer1x1").append(pdfDiv);
        document.getElementsByName("pdfviewer1x1")[0].contentWindow.document.body.focus();
    }

    function prepareImage(dicominfo, dicomBuffer, dicomReader) {

        var minMax = {
            min: dicominfo.getMinPixelValue(),
            max: dicominfo.getMaxPixelValue()
        };

        var isCompressed = true;

        //if (dicominfo.getIsCompressed()) {
        if (isCompressed) {
            if(!isCacheCompressedImageData) {
                pixelBuffer = dicomBuffer;
            } else {
                // decompress image
                pixelBuffer = pako.inflate(dicomBuffer);

                // convert to 16 bit array if necessary
                var bitsAllocated = dicominfo.getBitsAllocated();
                if (bitsAllocated == 16) {

                    var arraySize8 = pixelBuffer.length;
                    var pixelBuffer16 = new Uint16Array(arraySize8 / 2);
                    var pixelIndex = 0;
                    for (var i = 0; i < arraySize8; i += 2) {
                        pixelBuffer16[pixelIndex++] = (pixelBuffer[i + 1] * 256) + pixelBuffer[i];
                    }
                    pixelBuffer = pixelBuffer16;
                }
            }
        } else {
            var bitsAllocated = dicominfo.getBitsAllocated();
            var bytesPerPixel = (bytesPerPixel == 8) ? 1 : 2;
            var pixelBuffer = new Array(dicomBuffer.length);
            var pixelIndex = 0;
            for (var i = 0; i < dicomBuffer.length; i += bytesPerPixel) {
                pixelBuffer[pixelIndex++] = dicomReader.readNumber(bytesPerPixel, i);
            }
        }

        var renderImage = {
            pixelArray: pixelBuffer,
            minMaxPixel: minMax
        };

        return renderImage;
    }

    function getWindowLevelLimits(minMaxPixel, dicominfo) {
        var aRescaleSlope = dicominfo.getRescaleSlope();
        var aRescaleIntercept = dicominfo.getRescaleIntercept();

        var minLevelValue = (minMaxPixel.min * aRescaleSlope) + aRescaleIntercept;
        var maxLevelValue = (minMaxPixel.max * aRescaleSlope) + aRescaleIntercept;
        var minWindowValue = 1; // As per the Standard
        var maxWindowValue = (maxLevelValue - minLevelValue) * 2.0;

        return {
            wwLimit: {
                min: minWindowValue,
                max: maxWindowValue
            },
            wcLimit: {
                min: minLevelValue,
                max: maxLevelValue
            }
        };
    }

    function findMinMax(dicominfo, pixelBuffer) {
        var min = 65536;
        var max = -65536;                
        for (var i = 0; i < pixelBuffer.length; i ++) {
             var pixel = pixelBuffer[i];                
            if(min > pixel) min = pixel;
            if(max < pixel) max = pixel;
        }
        var minMax = {
            min: min,
            max: max
        };       

        return minMax;
    }
    
    /*function calculateAutoWindowLevel(dicominfo, minMaxPixel) {
        var aRescaleSlope = dicominfo.getRescaleSlope();
        var aRescaleIntercept = dicominfo.getRescaleIntercept();
        if (aRescaleSlope === undefined) {
            aRescaleSlope = 1;            
        }
        if (aRescaleIntercept === undefined) {            
            aRescaleIntercept = 0;
        }
        var vMinPixel = minMaxPixel.min;
        var vMaxPixel = minMaxPixel.max;                    
        if(dicominfo.isSigned())
        {
            vMinPixel = 0 - minMaxPixel.min;
            vMaxPixel = 65536 - minMaxPixel.max; 
        }
                 
        var window = 0;        
        var level = 0;        
        window = ((vMaxPixel - vMinPixel) * aRescaleSlope);
        level = (vMinPixel * aRescaleSlope) + aRescaleIntercept + (window / 2.0);
        if(dicominfo.isSigned())
        {           
            window = window * 2;
            level = level /2;
        }

        return {
            ww: window,
            wc: level
        };
    }*/

    function calculateAutoWindowLevel(dicominfo, minMaxPixel) {
        var aRescaleSlope = dicominfo.getRescaleSlope();
        var aRescaleIntercept = dicominfo.getRescaleIntercept();
        if (aRescaleSlope === undefined) {
            aRescaleSlope = 1;            
        }
        if (aRescaleIntercept === undefined) {            
            aRescaleIntercept = 0;
        }
        var vMinPixel = minMaxPixel.min;
        var vMaxPixel = minMaxPixel.max;        
        if (dicominfo.getBitsAllocated() === 16 && Math.pow(2, dicominfo.getBitsAllocated()-1) < (vMaxPixel - vMinPixel)  ) {
            vMinPixel = 0 - minMaxPixel.min;
            vMaxPixel = 65536 - minMaxPixel.max;
        }
        else if(vMinPixel === 0 && vMaxPixel === Math.pow(2, dicominfo.getBitsAllocated()-1))
        {
            vMinPixel = 0;
            vMaxPixel = (1 / aRescaleSlope) - aRescaleIntercept;;
        }
        var itsMinLevelRange = (vMinPixel * aRescaleSlope) + aRescaleIntercept; // Minimum Level can be accepted for this image
        var itsMaxLevelRange = (vMaxPixel * aRescaleSlope) + aRescaleIntercept; // Maximum Level can be accepted for this image
        
        // Window level should be within itsMinLevelRange and itsMaxLevelRange
        var level = (itsMinLevelRange + itsMaxLevelRange) / 2; // Expected Window Level

        var theMinWindowRange = 1;  // As per the Standard. Minimum width can be accepted for this image
        var theMaxWindowRange = (itsMaxLevelRange - itsMinLevelRange) * 2.0; // Maximum width can be accepted for this image
        
        // Window width should be within theMinWindowRange and theMaxWindowRange
        var window = (theMinWindowRange + theMaxWindowRange) / 2; // Expected Window Level
        
        return {
            ww: window,
            wc: level
        };
        
    }   
    
    function changeNullToEmpty(value) {
        if (value == undefined || value == null) {
            return "";
        }
        return value;
    }

    /**
     * Calculate the render size
     * @param {Type} image - Specifies the image object
     */ 
    function getRenderSize(image) {
        try
        {
            if(image == undefined || image == null) {
                return 0;
            }

            if(!image.isCompressed) {
                return 0;
            }

            var isWLRequired = (image.dicominfo.getModality() === "US" ? false : true);
            var sizeInBytes = image.dicominfo.getFrameSize();
            var renderCanvasSize = sizeInBytes;
            var wlCanvasSize = (isWLRequired ? sizeInBytes : 0);
            var minMaxPixel = (isWLRequired ? (image.maxPixel - Math.min(image.minPixel, 0)) + 1 : 0);
            var renderSize = (sizeInBytes / 4);
            var totalRenderSize = 0;

            totalRenderSize += renderCanvasSize;
            totalRenderSize += wlCanvasSize;
            totalRenderSize += minMaxPixel;
            totalRenderSize += renderSize;

            return totalRenderSize;
        }
        catch(e)
        { }

        return 0;
    }

    /**
     * update the window level
     * @param {Type} image - Specifies the image
     */ 
    function updateWindowLevel(image) {
        try
        {
            /*
            *  Window / Level
            // windowWidth => Window
            // windowCenter => Level
            */

            var windowCenter = image.dicominfo.getWindowCenter();
            var windowWidth = image.dicominfo.getWindowWidth();
            var pixelBuffer = dicomViewer.imageCache.getRawData(image);
            var dicominfo = image.dicominfo;
            var minMaxPixel = image.minMaxPixel;
            var windowLevelLimits = getWindowLevelLimits(minMaxPixel, dicominfo);
            var invert = image.invert;

            var autoCalWinLvl = false;
            if (isNaN(windowCenter) || isNaN(windowWidth)) {
                if (image.isColor) {
                    windowCenter = 128;
                    windowWidth = 255;
                } else {
                    autoCalWinLvl = true;
                }
            } else if(windowCenter === 0 && windowWidth === 0){
                 autoCalWinLvl = true;
            }

            if(autoCalWinLvl) {
                var minMaxFromPixel = findMinMax(dicominfo, pixelBuffer);
                var windowlevel = calculateAutoWindowLevel(dicominfo, minMaxFromPixel);
                windowCenter = windowlevel.wc;
                windowWidth = windowlevel.ww;
            }

            image.windowWidth = windowWidth;
            image.windowCenter = windowCenter;
            image.lastAppliedWindowWidth = windowWidth;
            image.lastAppliedwindowCenter = windowCenter;
            image.presentation.setWindowingdata(windowCenter, windowWidth);
            image.presentation.setWindowLevel(dicominfo, minMaxPixel, invert);
            image.presentation.setWindowLevelLimits(windowLevelLimits);
        }
        catch(e)
        { }
    }

    /**
     * 
     * @param {Type} image - Specifies the image
     * @param {Type} overlayIndex - Specifies the overlay index
     */ 
    function update6000Overlay(image, overlayIndex) {
        try
        {
            var dicominfo = image.dicominfo;
            if(!dicominfo) {
                return;
            }

            var imageInfo = dicominfo.imageInfo;
            if(!imageInfo) {
                return;
            }

            var overlays = imageInfo.overlays;
            if(!overlays) {
                return;
            }

            if(overlayIndex < 0 || overlayIndex > overlays.length - 1) {
                return;
            }

            var overlay = overlays[overlayIndex];
            if(!overlay) {
                return;
            }

            if(!image.overlay6000) {
                image.overlay6000 = {};
            }

            // Check whether the 6000 overlay data is already processed 
            if(image.overlay6000.overlayData !== undefined) {
                return;
            }

            // 6000 Overlay canvas 
            image.overlay6000.column = overlay.columns;
            image.overlay6000.row = overlay.rows;
            image.overlay6000.description = overlay.description;
            image.overlay6000.label = overlay.label;
            image.overlay6000.overlayData = undefined;

            // Update the render size
            image.renderSizeInBytes += (overlay.columns * overlay.rows * (overlay.bitDepth / 8));

            // Process 6000 overlay image data
            var worker;
            var workerData = {
                request: "overlay6000",
                url: dicomViewer.url.get6000overlayUrl(image.imageUid, image.frameNumber, overlayIndex),
                bitsAllocated: overlay.bitDepth 
            };

            if (typeof(Worker) !== "undefined") {
                if(numberOfWebWorkers<=10) {
                    if (typeof(w) == "undefined") {
                        worker = new Worker("js/dicom/imageCacheWorker.js?v=20171017171723");
                    }

                    numberOfWebWorkers = numberOfWebWorkers+1;
                    worker.postMessage(workerData);
                    worker.onmessage = function(event) {
                        numberOfWebWorkers = numberOfWebWorkers-1;
                        worker.terminate();
                        worker = undefined;

                        // Hold the 6000 overlay pixel data
                        image.overlay6000.overlayData = event.data.overlayData;

                        // Refresh the 6000 overlay
                        refresh6000Overlay(image);
                    };
                }
            }
        }
        catch(e)
        {
            console.log(e);
        }
    }

    /**
     * Refresh the 6000 overlay
     * @param {Type} image - specifies the image 
     */ 
    function refresh6000Overlay(image) {
        try
        {
            var allViewports = dicomViewer.viewports.getAllViewports();
            if(allViewports === null || allViewports === undefined) {
                return undefined;
            }

            $.each(allViewports, function(key, value) {
                if(value.studyUid) {
                    $("#" + value.seriesLayoutId + " div").each(function () {
                        var imageLevelId = $(this).attr('id');
                        var imageRender = value.getImageRender(imageLevelId);
                        if (imageRender) {
                            if(imageRender.imageUid === image.imageUid && image.is6000Overlay) {
                                image.is6000Overlay = false;
                                imageRender.renderImage(false);
                            }
                        }
                    });
                }
            });
        }
        catch(e)
        { }
    }

    // module exports
    dicomViewer.loader = loader;
    dicomViewer.loadImage = loadImage;
    dicomViewer.loadAndCacheImage = loadAndCacheImage;
    dicomViewer.registerImageLoader = registerImageLoader;
    dicomViewer.registerUnknownImageLoader = registerUnknownImageLoader;
    dicomViewer.updateImage = updateImage;
    dicomViewer.isJpegEnabled = isJpegEnabled;
    dicomViewer.readImage = readImage;
    dicomViewer.readImageJPEG = readImageJPEG;
    dicomViewer.loadPdf = loadPdf;
    dicomViewer.loadImageFromImageLoader = loadImageFromImageLoader;

    return dicomViewer;
}(dicomViewer));/*
 * Mouse Tools Manager
 */

var dicomViewer = (function(dicomViewer){
	
	if(dicomViewer === undefined)
	{
		dicomViewer = {};
	}
	
	var mouseTools = {
		pan : new Pan(),
		zoom : new ZoomTool(),
		windowLevel : new WindowLevel(),
		lineMeasure: new LineMeasurement(),
		traceMeasure: new TraceMeasurement(),
		volumeMeasure: new VolumeMeasurement(),
		pointMeasure: new PointMeasurement(),
        mitralMeanGradientMeasure: new MitralMeanGradientMeasurement(),
        angleMeasure: new AngleMeasurementTool(),
        ellipseMeasure: new EllipseMeasurement(),
        rectangleMeasure: new RectangleMeasurement(),
        defaultTool: new DefaultTool(),
        windowLevelROI : new WindowLevelROI(),
        xRefLineSelectionTool: new XRefLineSelectionTool(),
        link: new LinkTool(),
        sharpen: new SharpenTool(),
        pen: new PenTool()
	};
	
    var activeTool = mouseTools.windowLevel;

    var previousTool = undefined;

    var previousCursor = "default";

    var toolName = "WindowLevel";

    function getActiveTool() {
        return activeTool;
    }

    function setActiveTool(tool) {
        if(tool === undefined) {
            throw "active tool is null/undefined";
        }
        activeTool = tool;
    }

    /**
     * Set the current image tool as backup(previous)
     * @param {Type} tool - current tool
     */
    function setPreviousTool(tool) {
        if(tool === undefined) {
            throw "previous tool is null/undefined";
        }
        previousTool = tool;
    }

    /**
     * Return the previously selected tool
     */
    function getPreviousTool() {
        return previousTool;
    }

    /**
     * Set the current cursor value as backup(previous)
     * @param {Type} cursor - current cursor
     */
    function setCursor(cursor) {
        previousCursor = cursor;
    }

    /**
     * Get the cursor value
     * @param {Type} active(1/undefined)
     * 1 -> return the current cursor value; undefined -> return the previous cursor value
     */
    function getToolCursor(active) {
        if(active) {
            return $("#viewport_View")[0].style.cursor;
        } else {
            return previousCursor;
        }
    }

	function getWindowTool()
	{
		toolName = TOOLNAME_WINDOWLEVEL;
		return mouseTools.windowLevel;
	}
	
    function getDefaultTool()
	{
		toolName = TOOLNAME_DEFAULTTOOL;
		return mouseTools.defaultTool;
	}
    
	function getPanTool()
	{
		toolName = TOOLNAME_PAN;
		return mouseTools.pan;
	}
	
	function getZoomTool()
	{
		toolName = TOOLNAME_ZOOM;
		return mouseTools.zoom;
	}
	
	function getLinkTool()
	{
		toolName = TOOLNAME_LINK;
		return mouseTools.link;
	}

	function get2DLengthMeasureTool(typeId,measurementSubtype)
	{
        if (typeId == 1) {
            $('#viewport_View').css('cursor','url(images/mitrallength.cur), auto');
        } else if (typeId == 2) {
            $('#viewport_View').css('cursor','url(images/aorticlength.cur), auto');
        } else if (typeId == 3) {
            $('#viewport_View').css('cursor','url(images/mitralthickness.cur), auto');
        } else if(typeId == 4){
            $('#viewport_View').css('cursor','url(images/annotateline.cur), auto');
        } else if(typeId == 5){
            $('#viewport_View').css('cursor','url(images/annotatearrow.cur), auto');
        } else {
            $('#viewport_View').css('cursor','url(images/measurelength.cur), auto');
        }
		toolName = "lineMeasurement";
        if(measurementSubtype != undefined && measurementSubtype != null){
            mouseTools.lineMeasure.measurementData.measurementSubType = measurementSubtype;
        }
		return mouseTools.lineMeasure;
	}
	
	function get2DLengthCalibrationTool()
	{
		$('#viewport_View').css('cursor','url(images/calibrate.cur), auto');
		toolName = "lineMeasurement";
		return mouseTools.lineMeasure;
	}
	
	function get2DPointMeasureTool(typeId,measurementSubtype) {
        if (typeId == 1) {
            $('#viewport_View').css('cursor','url(images/mitralvelocity.cur), auto');
        } else if (typeId == 2) {
            $('#viewport_View').css('cursor','url(images/aorticregurgitationvelocity.cur), auto');
        } else if (typeId == 3) {
            $('#viewport_View').css('cursor','url(images/aorticstenosisvelocity.cur), auto');
        } else {
            $('#viewport_View').css('cursor','url(images/probe.cur), auto');
        }
	    toolName = "pointMeasurement";
        if(measurementSubtype != undefined && measurementSubtype != null){
            mouseTools.pointMeasure.measurementData.measurementSubType = measurementSubtype;
        }
	    return mouseTools.pointMeasure;
	}
	function getTraceMeasureTool()
	{
        $('#viewport_View').css('cursor','url(images/trace.cur), auto');
		toolName = "traceMeasurement";
		return mouseTools.traceMeasure;
	}
	function getVolumeMeasureTool()
	{
        $('#viewport_View').css('cursor','url(images/volume.cur), auto');
		toolName = "volumeMeasurement";
		return mouseTools.volumeMeasure;
	}
    function getMitralMeanGradientMeasureTool(typeId,measurementSubtype)
	{
        if(typeId == 1) {
            $('#viewport_View').css('cursor','url(images/annotatefreehand.cur), auto');
        } else {
            $('#viewport_View').css('cursor','url(images/mitralgradient.cur), auto');
        }
		toolName = "mitralMeanGradientMeasurement";
        if(measurementSubtype != undefined && measurementSubtype != null){
            mouseTools.mitralMeanGradientMeasure.measurementData.measurementSubType = measurementSubtype;
        }
		return mouseTools.mitralMeanGradientMeasure;
	}
	function getAngleMeasureTool()
	{
        $('#viewport_View').css('cursor','url(images/angle.cur), auto');
		toolName = "angleMeasurement";
		return mouseTools.angleMeasure;
	}
    function getEllipseMeasureTool(typeId,measurementSubtype)
	{
        if(typeId == 1) {
            $('#viewport_View').css('cursor','url(images/annotateellipse.cur), auto');
        } else {
           $('#viewport_View').css('cursor','url(images/ellipse.cur), auto');
        }
		toolName = "ellipseMeasurement";
        if(measurementSubtype != undefined && measurementSubtype != null){
            mouseTools.ellipseMeasure.measurementData.measurementSubType = measurementSubtype;
        }
		return mouseTools.ellipseMeasure;
	}
    function getRectangleMeasureTool(typeId,measurementSubtype)
    {
        if(typeId == 1) {
            $('#viewport_View').css('cursor','url(images/annotaterectangle.cur), auto');
        } else if(typeId == 2){
            $('#viewport_View').css('cursor','url(images/annotatetext.cur), auto');
        } else {
            $('#viewport_View').css('cursor','url(images/rectangle.cur), auto');
        }
        toolName = "rectangleMeasurement";
        if(measurementSubtype != undefined && measurementSubtype != null){
            mouseTools.rectangleMeasure.measurementData.measurementSubType = measurementSubtype;
        }
        return mouseTools.rectangleMeasure;
    }
	function getToolName()
	{
		return toolName;
	}

	function setToolName(tool)
	{
		toolName = tool;
	}
	
    function getWindowToolROI() {
        $('#viewport_View').css('cursor','url(images/AutoWindowLevel.cur), auto');
        toolName = TOOLNAME_WINDOWLEVEL_ROI;
        return mouseTools.windowLevelROI;
    }

    function getXRefLineSelectionTool() {
        $('#viewport_View').css('cursor','url(images/XRefline.cur), auto');
        toolName = TOOLNAME_XREFLINESELECTIONTOOL;
        return mouseTools.xRefLineSelectionTool;
    }
    
    function getSharpenTool() {
        $('#viewport_View').css('cursor','url(images/sharpen.cur), auto');
        toolName = TOOLNAME_SHARPENTOOL;
        return mouseTools.sharpen;
    }

    /**
     * 
     * get the pentool cursor details
     */ 
    function getPenTool() {
        $('#viewport_View').css('cursor','url(images/pen.cur), auto');
        toolName = TOOLNAME_PEN;
        return mouseTools.pen;
    }

    dicomViewer.mouseTools = {
            getActiveTool : getActiveTool,
            setActiveTool : setActiveTool,
            getPreviousTool : getPreviousTool,
            setPreviousTool : setPreviousTool,
            getToolCursor : getToolCursor,
            setCursor : setCursor,
            getWindowTool : getWindowTool,
            getPanTool : getPanTool,
            getZoomTool : getZoomTool,
            get2DLengthMeasureTool: get2DLengthMeasureTool,
            get2DPointMeasureTool: get2DPointMeasureTool,
            getTraceMeasureTool : getTraceMeasureTool,
            getVolumeMeasureTool : getVolumeMeasureTool,
            getToolName : getToolName,
            getMitralMeanGradientMeasureTool: getMitralMeanGradientMeasureTool,
            getAngleMeasureTool: getAngleMeasureTool,
            get2DLengthCalibrationTool : get2DLengthCalibrationTool,
            getEllipseMeasureTool: getEllipseMeasureTool,
            getRectangleMeasureTool: getRectangleMeasureTool,
            getDefaultTool: getDefaultTool,
            getWindowToolROI : getWindowToolROI,
            getXRefLineSelectionTool: getXRefLineSelectionTool,
            getLinkTool : getLinkTool,
            setToolName : setToolName,
            getSharpenTool : getSharpenTool,
            getPenTool : getPenTool
    };

return dicomViewer;

}(dicomViewer));/**
 * 
 */
var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }

    var overlayConfig = null;

    var measurementsConfig = null;

    var itemIdCounter = 100;

function initOverlayConfig()
{
	var url = dicomViewer.url.getOverlayTextURL();	
	var req = new XMLHttpRequest();
	req.open('GET', url, false);
//	req.overrideMimeType('application/json');
	req.send(null);
	if (req.status != 200)throwException(_exception.FileLoadFailed);
	{
		overlayConfig = JSON.parse(req.responseText);
	}
}
    
function getOverLayValuesForCofig(config,imageinfo)
{
    var valueArray = [];
    
    for(var key in config)
    {
        switch(config[key])
        {
            case 'Patient_Name':
            valueArray[valueArray.length] = imageinfo.getPatientName();
            break;
                
            case 'Study_Date_Time':
            valueArray[valueArray.length] = imageinfo.getStudyDate() + ' ' + imageinfo.getStudyTime();
            break;
            
            case 'Accession_Number':
            valueArray[valueArray.length] = imageinfo.getAccessionNumber();
            break;
            
            case 'Manufacturer':
            valueArray[valueArray.length] = imageinfo.getManufacturer();
            break;
                
            case 'ImageNumber':
            valueArray[valueArray.length] = imageinfo.getInstanceNumber();
            break;
            
            case 'WCWW':
            valueArray[valueArray.length] = 'WCWW';
            break;
            
            case 'Scale':
            valueArray[valueArray.length] = 'Scale';
            break;

            case 'Content_Date_Time':
            if(imageinfo.getModality() == "ES") {
                valueArray[valueArray.length] = "Content Date Time: " + imageinfo.getContentDate() + ' @' + imageinfo.getContentTime();
            }
            break;
        }
    }
    return valueArray;
}

function getOverlayConfig()
{
	return overlayConfig;
}

function getMeasurementsConfig() {
    return measurementsConfig;
}

function createMeasurementMenuItem(item) {
    var li = $("<li />")
    li.append($("<input type=\"radio\" onclick=\"dicomViewer.tools.do2DMeasurement(" + item.type + ",'" + item.id + "','" + item.units + "')\" " +
              "id=\"measurement" + itemIdCounter + "\" " +
              "name=\"measurement\" value=\"" + itemIdCounter + "\" />"));
    li.append($("<label for=\"measurement" + itemIdCounter + "\">" + item.label + "</label>"));
    itemIdCounter++;
    return li;
}

function createMeasurementMenu(name) {
		var id = "context-"+ name.replace(" ","");
    var menu = $("<li class=\"dropdown-submenu\"><a href=\"#\" id = "+id+" onclick=\"\">" + name + "</a>" + 
               "<ul id=\"" + itemIdCounter + "\" class=\"dropdown-menu dropdown-menu-custom\" role=\"menu\" style=\"background-color: #999;\" ></ul></li>");
    itemIdCounter++;
    return menu;
}

function appendMeasurements(parent, data) {

    if (data.items != null) {
        var menu = createMeasurementMenu(data.label);
        var parentMenu = menu.find("ul");
        $.each(data.items, function (index, item) {
            appendMeasurements(parentMenu, item);
        })
      //  menu.appendTo(parent);
    } else {
        var item = createMeasurementMenuItem(data);
        item.appendTo(parent);
    }
}

//function initMeasurementsConfig() {
//    $(function () {
//        $.ajax({
//            url: dicomViewer.url.getMeasurementsURL(),
//            dataType: "json",
//            type: "get",
//            beforeSend: function (xhr, settings) {
//                //$("#Li2").find("ul").remove();
//            },
//            success: function (data, status, xhr) {
//                if (data) {
//                    if (data.length) {
//                        $.each(data, function (index, item) {
//                            appendMeasurements($("#contextDrawMeasurement"), item);
//                        })
//                    }
//                }
//            }
//        })
//    })
//}

function initMeasurementsConfig() {

    var measurements = getMeasurements();
    if ((measurements == undefined) || (measurements == null) || (measurements.length == 0))
        return;

    $.each(measurements, function (index, item) {
        appendMeasurements($("#contextMenu"), item);
    })
}

dicomViewer.overlay = {
    initOverlayConfig: initOverlayConfig,
    initMeasurementsConfig: initMeasurementsConfig,
    getOverlayConfig:getOverlayConfig,
    getOverLayValuesForCofig: getOverLayValuesForCofig,
    getMeasurementsConfig:getMeasurementsConfig,
}



return dicomViewer;
}(dicomViewer));/**
 * This module cache and handle the security token
 */

var dicomViewer = (function(dicomViewer) {

    "use strict";

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var securityToken = null;

    /**
     *@param token
     *set the security token from the url to securityToken
     */
    function setSecurityToken(token) {
        securityToken = token;
    }

    /**
     *Get the security token from the securityToken variable
     */
    function getSecurityToken() {
        return securityToken;
    }

    dicomViewer.security = {
        setSecurityToken: setSecurityToken,
        getSecurityToken: getSecurityToken
    }

    return dicomViewer;
}(dicomViewer));var dicomViewer = (function (dicomViewer) {

    "use strict";

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var studyDetailsHolder = {};
    var listOfStudyUid = [];
    var reOrderedStudyUidList = [];
    	
	/**
     *@param studyDeatils
     *set the study details to the studyDetailsHolder variable
     */
    function setStudyDetails(studyDeatils) {
        if (studyDeatils === undefined) {
            throw "StduyDeatils is undefined";
        }
        var studyUid = studyDeatils.studyUid;
		studyDetailsHolder[studyUid] = studyDeatils;
        listOfStudyUid[listOfStudyUid.length] = studyUid;
        addOrRemoveReOrderedStudyUid(studyUid, true);
    }

    /**
     *Get the study detail from the studyDetailsHolder variable
     */
    function getStudyDetails(studyUid) {
        return studyDetailsHolder[studyUid];
    }

    /**
     *Get the study id from the study detail
     */
    function getStudyId() {
        return studyDetailsHolder.studyId;
    }
	
	/**
     *Get the study id from the study detail
     */
    function getStudyUid() {
        return studyDetailsHolder.studyUid;
    }

    /**
     *@param seriesIndex
     *Get the series object based on the series index
     */
    function getSeries(studyUid, seriesIndex, imageIndex) {
        if (seriesIndex === undefined) {
            throw "Series Index is null/undefined";
        }

        if(studyDetailsHolder[studyUid] !== undefined) {
            if(imageIndex !== undefined && studyDetailsHolder[studyUid].modality == "General" && 
               (studyDetailsHolder[studyUid])[0].imageType == IMAGETYPE_JPEG && studyDetailsHolder[studyUid][seriesIndex].numberOfFrames > 1) {
                return (studyDetailsHolder[studyUid])[imageIndex];
            } else if(studyDetailsHolder[studyUid].series !== undefined) {
                if (studyDetailsHolder[studyUid].series.length <= seriesIndex) {
                    if (studyDetailsHolder[studyUid].modality == "US" ||
                        studyDetailsHolder[studyUid].modality == "ES" ||
                        studyDetailsHolder[studyUid].modality == "XC") {
                        return studyDetailsHolder[studyUid].series[0];
                    } else {
                        // TODO: Need to pass the valid series index
                        return undefined;
                    }
                } else {
                    return studyDetailsHolder[studyUid].series[seriesIndex];
                }
            } else {
                return studyDetailsHolder[studyUid][seriesIndex];
            }
        }

        return undefined;
    }

    /**
     *Get the series count from the study detail
     */
    function getSeriesCount(studyUid) {
        return getStudyDetails(studyUid).seriesCount;
    }

    /**
     *@param seriesIndex
     *get the image count based on the series index
     */
    function getImageCount(studyUid,seriesIndex) {
        var series;
        try {
            series = getSeries(studyUid,seriesIndex);
        } catch(e) {
            series = undefined;
            }
        if( series !== undefined)
            return series.imageCount;
        else
            return 0;
    }

    /**
     *@param seriesIndex
     *@param imageIndex
     *Get the image based on the series index and image index
     */
    function getImage(studyUid,seriesIndex, imageIndex) {

        if (imageIndex === undefined) {
            throw "Image Index is null/undefined"
        }
        if(getSeries(studyUid,seriesIndex) !== undefined)            
            if(getSeries(studyUid,seriesIndex).images !== undefined){
                return getSeries(studyUid,seriesIndex).images[imageIndex];
            }else{
                return getSeries(studyUid,seriesIndex, imageIndex);
            }
        else
            return undefined;
    }
    /**
     *@param seriesIndex
     *@param imageIndex
     *Get all images of the particular series
     */
    function getAllImages(studyUid, seriesIndex) {

        if (seriesIndex === undefined) {
            throw "Series Index is null/undefined"
        }

        return getSeries(studyUid, seriesIndex).images;
    }
	
	/*function getSerieIndex(studyUid, imageId)
    {
        var series = getSeriesCount(studyUid);
        for (var key in series.images)
        {
            if( series.images[key].imageId == imageId)
            {
                return key
            }
        }
        
        return -1;
    }
*/
	function getImageIndex(studyUid,seriesIndex, imageUid)
    {
        var series = getSeries(studyUid, seriesIndex);

         if(!series){
            return -1;
        }

        // Get the non dicom image index 
        if(isDicomStudy(studyUid) === false && series !== undefined && series !== null) {
            if(series.imageCount == 1) {
                return 0;
            }
        }

        for (var key in series.images)
        {
            if( series.images[key].imageUid == imageUid)
            {
                return key
            }
        }
        
        return -1;
    }
	
    /**
     *@param image
     *Get image id based on the image
     */
    function getImageId(image) {
        if (image === undefined) {
            throw "image is null/undefined"
        }

        return image.imageId;
    }

    /**
     *@param image
     *Get the frame count based on the image
     */
    function getImageFrameCount(image) {
        if (image === undefined) {
            throw "image is null/undefined";
        }
        if (image.numberOfFrames !== undefined) {
            if (image.numberOfFrames === 0) {
                image.numberOfFrames += 1;
            }
            return image.numberOfFrames;
        }

        // Checking image info already cached or not
        var header = dicomViewer.header.getDicomHeader(dicomViewer.Series.Image.getImageUid(image));
        if (header === undefined) {
            return undefined;
        }
        image.numberOfFrames = header.getNumberOfFrames();


        if (image.numberOfFrames === undefined) {
            image.numberOfFrames = 1;
        }

        return image.numberOfFrames;
    }

    /**
     *@param seriesIndex
     *Get the modality based on the series index
     */
    function getModality(studyUid,seriesIndex) {
        if (seriesIndex === undefined) {
            throw "seriesIndex is null/undefined"
        }
        var series = getSeries(studyUid,seriesIndex);
        if(series == undefined )
        {
            return "";
        }
        return series.modality;
    }

    function getSeriesDescription(studyUid, seriesIndex){
        if(studyUid === undefined) return "";
        var series = getSeries(studyUid,seriesIndex)
        if(series === undefined || series == null) {
            return "";
        }

        return series.description;
    }
    
    /**
     *@param image
     *get the instance number based on the image
     */
    function getInstanceNumber(image) {
        if (image === undefined) {
            throw "image is null/undefined"
        }
        if (image.instanceNumber !== undefined) {
            return image.instanceNumber;
        }
        // Checking image info already cached or not
        var header = dicomViewer.header.getDicomHeader(dicomViewer.Series.Image.getImageUid(image));
        if (header === undefined) {
            return undefined;
        }
        image.instanceNumber = header.getInstanceNumber();

        return image.instanceNumber;
    }
	
	  /**
     *@param image
     *Get image id based on the image
     */
    function getImageUid(image) {
        if (image === undefined) {
            throw "image is null/undefined"
        }

        return image.imageUid;
    }
    
    function getListOfStudyUid(isResize){
        if(reOrderedStudyUidList !== undefined && reOrderedStudyUidList !== null) {
            if(reOrderedStudyUidList.length > 0 && (reOrderedStudyUidList.length == listOfStudyUid.length || isResize)) {
                return reOrderedStudyUidList;
            }
        }

        return listOfStudyUid;
    }
    
    function removeStudyDetails(studyUid){
        delete studyDetailsHolder[studyUid];
        var listOfstudyLength = listOfStudyUid.length;
        for(var index = 0;listOfstudyLength>index;index++)
        {
            var studyUidInList = listOfStudyUid[index]
            if(studyUid === studyUidInList){
               listOfStudyUid.splice(index,1);
                addOrRemoveReOrderedStudyUid(studyUid, false);
                dicomViewer.imageCache.clearCache(studyUid);
            }
        }
    }
    
    function isImageAvilable(studyUid, selectedImageUid){
        if(studyUid !== undefined)
        {
            var seriesCount = getSeriesCount(studyUid)
            for(var index = 0; seriesCount>index;index++){
                var allImages = getAllImages(studyUid, index);
                for(var imageIndex in allImages)
                {
                    var image = allImages[imageIndex];
                    var imageUid = getImageUid(image);
                    if(selectedImageUid === imageUid)
                    {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Check whether the given study is dicom or not
     * @param {Type} studyUid - Specifies the Study Uid
     */ 
    function isDicomStudy(studyUid) {
        var isDicom = false;
        var studyDetails = getStudyDetails(studyUid);
        if(studyDetails !== undefined) {
            isDicom = studyDetails.isDicom;
        }

        return isDicom;
    }

    /**
     * Check whether the given series is dicom or not
     * @param {Type} studyUid - Specifies the Study Uid
     * @param {Type} seriesIndex - Specifies the series index
     */ 
   function isDicomSeries(studyUid, seriesIndex) {
        var isDicom = false;
        var series = getSeries(studyUid, seriesIndex);
        if(series !== undefined) {
            isDicom = series.isDicom;
        }

        return isDicom;
    }

    /**
     * Set the reorder studyUids
     * @param {Type} reOrderedStudyUids - Specifies the reorder studyUids
     * @param {Type} isClear - Flag to clear the list
     */ 
    function setReOrderedStudyUids(reOrderedStudyUids, isClear) {
        try
        {
            if(isClear) {
                reOrderedStudyUidList = [];
            } else {
                reOrderedStudyUidList = reOrderedStudyUids;
            }
        }
        catch(e)
        { }
    }

    /**
     * Add or remove the studyUid from the reorder list
     * It will call while adding study with an existing session or close the revewport 
     * @param {Type} studyUid - Specifies the studyUid
     * @param {Type} isAdd - Flag to add/remove the studyUid from array
     */ 
    function addOrRemoveReOrderedStudyUid(studyUid, isAdd) {
        try
        {
            var index = reOrderedStudyUidList.indexOf(studyUid);
            if(isAdd && reOrderedStudyUidList.length > 0 && index == -1) {
                reOrderedStudyUidList.push(studyUid);
            } else if(!isAdd && index > -1) {
                reOrderedStudyUidList.splice(index,1);
            }
        }
        catch(e)
        { }
    }

     /**
     * Reset the study details
     */ 
    function resetStudy() {
        reOrderedStudyUidList = [];
        listOfStudyUid = [];
    }

    /**
     * Get the image Urn
     * @param {Type} studyUid - Specifies the study Uid
     * @param {Type} seriesIndex - Specifies the series index
     * @param {Type} imageIndex - Specifies the image index
     */ 
    function getImageUrn(studyUid, seriesIndex, imageIndex) {
        var image = getImage(studyUid,seriesIndex, imageIndex);
        if(image) {
            return image.imageUrn;
        }

        return undefined;
    }

    dicomViewer.setStudyDetails = setStudyDetails;
    dicomViewer.getStudyDetails = getStudyDetails;
    dicomViewer.getListOfStudyUid = getListOfStudyUid;
    dicomViewer.removeStudyDetails = removeStudyDetails;
    dicomViewer.isImageAvilable = isImageAvilable;
    dicomViewer.isDicomStudy = isDicomStudy;
    dicomViewer.isDicomSeries = isDicomSeries;
    dicomViewer.setReOrderedStudyUids = setReOrderedStudyUids;
    dicomViewer.resetStudy = resetStudy;
    dicomViewer.Study = {
        getSeriesCount: getSeriesCount,
        getStudyId: getStudyId,
	    getStudyUid : getStudyUid
    };
    dicomViewer.Series = {
        getSeries: getSeries,
        getImageCount: getImageCount,
        getAllImages: getAllImages,
        Image: {
            getImageIndex : getImageIndex,
            getImage: getImage,
			getImageUid: getImageUid,
            getImageId: getImageId,
            getImageFrameCount: getImageFrameCount,
            getInstanceNumber: getInstanceNumber,
            getImageUrn : getImageUrn
        },
        getModality: getModality,
        getSeriesDescription:getSeriesDescription
    };
    
    return dicomViewer;
}(dicomViewer));/**
 * Thumbnail creator
 */
var dicomViewer = (function(dicomViewer) {

    "use strict";

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }
    var thumbnailProcessing = [];
    var thumbnails = {};
    var showCacheIndicatorOnThumbnail = false;
    /**
     *Create the thumbnail based on the image level or series level
     */
    function createThumbnail(studyUid) {
        createOrAppendThumbnail(studyUid, 0, true);
    }
    /**
     *@param image
     *@param modality
     *Based on the modality it ill return true(US,CR,ES,DX,XA) or false
     */
    function isImageThumbnail(image, checkOnModality) {
        if(image !== undefined && image !== null) {
            if(image.numberOfFrames !== undefined && image.numberOfFrames !== null) {
                if(image.numberOfFrames > 1) {
                    return true;
                } else {
                    if (image.modality === "US" ||
                        image.modality === "CR" ||
                        image.modality === "ES" ||
                        image.modality === "DX" ||
                        image.modality === "XA" ||
                        image.modality === "ECG" ||
                        image.modality === "XC" ||
                        image.modality === "OP" ||
                        image.modality === "SC") {
                        return true;
                    }
                }
            } else {
                if (image.modality === "US" ||
                    image.modality === "CR" ||
                    image.modality === "ES" ||
                    image.modality === "DX" ||
                    image.modality === "XA" ||
                    image.modality === "ECG" ||
                    image.modality === "XC" ||
                    image.modality === "OP" ||
                    image.modality === "SC") {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * Check whether the cine can run or not
     * @param {Type} image 
     */ 
    function canRunCine(image) {
        if(image !== undefined && image !== null) {
            if(image.numberOfFrames !== undefined && image.numberOfFrames !== null) {
                if(image.numberOfFrames > 1) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     *@param image
     *@param modality
     *Based on the modality it ill return true(US,CR,DR,DX,XA) or false
     */
    function isSeriesContainsMultiframe(studyUid,seriesIndex) {
        var numberOfImages = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
        for(var imageIndex = 0; imageIndex < numberOfImages; imageIndex++)
        {
            var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
            if(isImageThumbnail(image,false)) return true;
        }
        return false;
    }
    /**
     *@param seriesIndex
     *@param numberOfimages
     *@param imageThumbDiv
     *Using the seriesIndex, numberOfimages, imageThumbDiv create the image thumbnails
     */
    function createImageThumbail(studyUid, seriesIndex, numberOfimages, imageThumbDiv) {
        for (var i = 0; i < numberOfimages; i++) {
            var thumbnailId = 'imageviewer_' + dicomViewer.replaceDotValue(studyUid) + "_" + seriesIndex + '_thumb' + i
            var thumbnailString = '<div id="' + thumbnailId + '" style="clear:right; width:auto;background:black;margin-right: 5px; margin-bottom: 5px; " class="default-thumbnail-view col-xs-12" onclick="loadImage(event)"></div>';
            $("#thumb_" + imageThumbDiv).append(thumbnailString);
            var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, i);
            /*$("#" +imageThumbDiv).append(thumbnailString);*/
            var imageUid = dicomViewer.Series.Image.getImageUid(image);
            var thumb = new ThumbnailRenderer();
            thumb.createImageThumbnail(studyUid, imageUid, thumbnailId, seriesIndex, i + 1);
            thumb.setStudyUid(studyUid);
            addThumbnails(thumbnailId, thumb);

            if(thumbnailWidth == undefined ) {
                thumbnailWidth = document.getElementById(thumbnailId).offsetWidth;
            }
        }
    }
    /**
     *@param selectedSeriesIndex
     *Based on the thumbnail div id select the thumbnail(display green border to thumbnail)
     */
    function selectThumbnail(selectedSeriesIndex) {
        removeSelctedThumbnail();
        var seriesLayout = dicomViewer.getActiveSeriesLayout()
        var thumbnailId = "#imageviewer_" + dicomViewer.replaceDotValue(seriesLayout.studyUid) + "_" + selectedSeriesIndex + "_thumb";
        if (!$(thumbnailId).hasClass('selected-thumbnail-view')) {
            $(thumbnailId).removeClass(
                'default-thumbnail-view').addClass('selected-thumbnail-view');
            makeThumbnailVisible(thumbnailId);
        }
    }

    /**
     *@param alertThumbnailSelection
     *Based on the thumbnail div id disselect the thumbnail(display red border to thumbnail)
     */
    function alertThumbnailSelection(thumbnailId) {
        removeSelctedThumbnail();
        if (!$("#"+thumbnailId).hasClass('alert-thumbnail-view')) {
            $("#"+thumbnailId).removeClass(
            'default-thumbnail-view').addClass('alert-thumbnail-view');
        }
    }

    /**
     *@param thumbnailId
     *@param thumbnail
     *Uing the thumbnail div id as key storing the thumbnail render object as value in the thumbnails
     */
    function addThumbnails(thumbnailId, thumbnail) {
        if (thumbnailId === undefined) {
            throw "thumbnailId should not be null/undefined";
        }
        if (thumbnail === undefined) {
            throw "thumbnail should not be null/undefined";
        }
        thumbnails[thumbnailId] = thumbnail;
    }
    /**
     *@param selectedSeriesIndex
     *@param imageIndex
     *Based on the thumbnail div id select the thumbnail(display green border to thumbnail) for image level thumbnails
     */
    function selectImageThumbnail(selectedSeriesIndex, imageIndex) {        
        var sereiesLayout = dicomViewer.getActiveSeriesLayout();
        var studyUid = sereiesLayout.studyUid;
        removeSelctedThumbnail();
        var thumbnailId = "imageviewer_" + dicomViewer.replaceDotValue(studyUid) + "_" + (selectedSeriesIndex) + "_thumb";
        if (!$(thumbnailId).hasClass('selected-thumbnail-view')) {
            var element = document.getElementById(thumbnailId);
            if (element == null || element == undefined) {
                thumbnailId = "imageviewer_" + dicomViewer.replaceDotValue(studyUid) + "_" + (selectedSeriesIndex) + "_thumb" + (imageIndex);
            }

            //document.getElementById(thumbnailId).className = "selected-thumbnail-view"

            $("#" + thumbnailId).removeClass(
                'default-thumbnail-view').addClass('selected-thumbnail-view');

            makeThumbnailVisible(thumbnailId);
        }
    }
    /**
     *@param thumbnailId
     *Get the thumbnail render boject based on the thumnail id
     */
    function getThumbnail(thumbnailId) {
        if (thumbnailId === undefined) {
            throw "thumbnailId should not be null/undefined";
        }
        return thumbnails[thumbnailId];
    }
    
     /**    
     *Get the thumbnails render boject
     */
    function getAllThumbnails() {
        return thumbnails;
    }

    function removeSelctedThumbnail() {
        $(".selected-thumbnail-view").removeClass('selected-thumbnail-view')
            .addClass('default-thumbnail-view');
        $(".alert-thumbnail-view").removeClass('alert-thumbnail-view')
            .addClass('default-thumbnail-view');
    }

    /**
     * Calculate the currently selected thumbnail position whether the whole thumbnail is visible to the user.
     * Auto scroll the thumbnail if the thumbnail is not fully visible to the user.
     */
    function makeThumbnailVisible(elementId) {

        var element = document.getElementById(elementId);
        if (element === null) {
            logger.warn("Thumbnails are available for given Element Id: " + elementId);
            return;
        }

        // Get the scrollbar height and calculate the bottom
        var docViewTop = $(window).scrollTop();
        var docViewBottom = docViewTop + $(window).height();

        // Get the selected thumbnail and get height and calculate the bottom
        var elementTop = $(element).offset().top;
        var elementBottom = elementTop + $(element).height();

        // Check whether the selected thumbnail is aligned in fully visible area.
        var isFullyVisible = (docViewTop <= elementTop) && (docViewBottom >= elementBottom);

        // If the thumbnail is fully visible then we do not need to scroll the view. So simply return if it is true.
        if (isFullyVisible) {
            return;
        }

        // Get the align orientation. If the thumbnail is aligned near to top then the scroll will be fit with topside.
        // Otherwise will choose to align at bottom of the scrollbar.
        var isTopAlign = (docViewTop - elementTop) > (elementBottom - docViewBottom);
        element.scrollIntoView(isTopAlign);
    }

    function replaceDotValue(value) {
        return value.replace(/\./g, '');
    }

    /**
     * Replace all the special characters
     * @param {Type} value - Specifies the input
     */ 
    function replaceSpecialsValues(value) {
        return value.replace(/[^A-Za-z0-9]/g, '');
    }

    function resizeThumbnailPanel() {
        //To resize the thumbnail panel based the scrool panel
        var imageThumbnailViewElement = $("#imageThumbnail_View");
        //height of image thumbnail view
        var heightOfImageThumbnail = imageThumbnailViewElement.height();
        //first study level thumbnail 
        var studyThumbnailElement = imageThumbnailViewElement.children();
        var heightOfStudyThumbnails = 0;
        studyThumbnailElement.each(function() {
            var elementId = this.id;
            if (elementId != "" && elementId != undefined) {
                heightOfStudyThumbnails = heightOfStudyThumbnails + $("#" + elementId).outerHeight();
            }
        });

        if (heightOfStudyThumbnails < heightOfImageThumbnail) {
            myLayout = $('body').layout({
                west__minSize: (THUMBNAIL_PANEL_WIDTH - 10)
            });
            var widthOfThumbnailPanel = $("#img").outerWidth();
            myLayout.sizePane("west", THUMBNAIL_PANEL_WIDTH - 10);
            if (widthOfThumbnailPanel != (THUMBNAIL_PANEL_WIDTH - 10))
                reloadViewPort();
        } else {
            myLayout.sizePane("west", THUMBNAIL_PANEL_WIDTH);
        }

    }

    /**
     * set the viewport series index,frame index,image index to an array
     */ 
    function setViewportProperty() {
        thumbnailProcessing= [];
        var pushValues;
        var allViewports = dicomViewer.viewports.getAllViewports();
        $.each(allViewports, function(key, value) {
            if(value.studyUid !== undefined) {
                pushValues = value.seriesLayoutId + "|" + value.seriesIndex + "|" +
                             value.scrollData.imageIndex + "|" + value.scrollData.frameIndex + "|" + 
                             value.imageLayoutDimension;
                thumbnailProcessing.push(pushValues);
            }
        });
    }

    /**
     * return the current viewport properties
     * @param {Type} seriesLayoutId - specifies the viewport id
     */ 
    function getViewportProperty(seriesLayoutId) {
        if(thumbnailProcessing != null || thumbnailProcessing != undefined) {
            for(var i=0;i<thumbnailProcessing.length;i++) {
                if(thumbnailProcessing[i].split("|")[0] == seriesLayoutId) {
                    return thumbnailProcessing[i];
                }
            }
        }
        return null;
    }

    /**
     * Show or Hide the entire thumbnail panel on Double-Click(hiding)/Click(showing)
     */ 
    function closeThumbnailPanel() {
        isCineEnabled(true);
        var obj = {
            id: "studyViewer1x1"
        }
        var viewportElement = $('#viewport_View');
        viewportElement.width("100%");
        viewportElement.height("100%");

        var seriesLayoutId = undefined;
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if(seriesLayout !== undefined) {
            seriesLayoutId = seriesLayout.getSeriesLayoutId();
        }

        setViewportProperty();

        //Updating the Cine manager with the selected viewport study id on the basis of the Cine player state
        var splitedRowAndColumn = studyLayoutValue.split("x");
        var studyRow = splitedRowAndColumn[0];
        var studyColumn = splitedRowAndColumn[1];
        for (var i = 1; i <= studyRow; i++) {
            for (var j = 1; j <= studyColumn; j++) {
                var studyDiv = "studyViewer" + i + "x" + j;
                var rowCalValue = layoutMap[studyDiv];
                if (rowCalValue == undefined) {
                    rowCalValue = "1x1";
                }
                var rcArray = rowCalValue.split("x");
                dicomViewer.tools.chanageWhileDrag(rcArray[0], rcArray[1], studyDiv,true);
            }
        }
        
        isCineEnabled(false);

        // Maintain the previous selection
        if(seriesLayoutId !== undefined) {
            dicomViewer.changeSelection(seriesLayoutId);
        }
    }

    /**
     * Remove the thumbnail context's 
     */ 
    function removeThumbnailContext(studyUid) {
        try
        {
            var studyDetials = dicomViewer.getStudyDetails(studyUid);            
            if(studyDetials !== null && studyDetials !== undefined) {
                if(!studyDetials.isDicom) {
                    studyDetials.forEach(function(nonDicom) {
                        if(nonDicom !== null && nonDicom !== undefined){
                            removeContextId(nonDicom.contextId);
                        }
                     });
                } else {
                    removeContextId(studyDetials.contextId);
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Create or append the thumbanail
     * @param {Type} studyUid - Specifies the study Uid
     * @param {Type} seriesStartingIndex - Specifies the starting series index to create the thumbnails.
     * @param {Type} isNewThumbnailPanel - Specifies the flag to create or append the thumbnail panel.
     */ 
    function createOrAppendThumbnail(studyUid, seriesStartingIndex, isNewThumbnailPanel) {
        try
        {
            var studyThumbDivId = "study_thumb_" + replaceDotValue(studyUid);
            var studyThumbnailDiv = "<div id=" + studyThumbDivId + " style='border: 3px solid rgba(92, 93, 100, 0.59);background: rgba(152, 153, 158, 0.59);" + "overflow-x: hidden;overflow-y: hidden;'/><br id=break_" + replaceDotValue(studyUid) + ">";
            var studyDetials = dicomViewer.getStudyDetails(studyUid);
            var studyInfoDiv = "";
            var studyTime = "";
            if(studyDetials.dateTime !== null && studyDetials.dateTime !== undefined) {
                studyTime = studyDetials.dateTime.replace("T", "@")
            }

            if (!studyDetials.isDicom) {
                studyInfoDiv = "<table style='width:100%;'>" + "<tr>" + "<td>" + "<div title='" + studyDetials.procedure + "'  id='studyInfo_" + studyUid + "' style='color:white;padding-left:4px'>" + studyDetials.procedure + "<br>" + studyTime + "<br>" + "</div>" + "</td>" + "<td>" + "<span  title='close' style='padding-bottom: 8px;' onclick=dicomViewer.thumbnail.closeThumbnail('" + studyUid + "')><img src='images/close.png' style='width: 8px;'></img> </span>" + "</td>" + "</tr>" + "</table>"
            } else {
                studyInfoDiv = "<table style='width:100%;'>" + "<tr>" + "<td>" + "<div title='" + studyDetials.procedure + "' id='studyInfo_" + studyUid + "' style='color:white;padding-left:4px'>" + studyDetials.procedure + "<br>" + studyDetials.dicomStudyId + "<br>" + studyTime + "</div>" + "</td>" + "<td>" + "<span title='close' style='padding-bottom: 8px;' onclick=dicomViewer.thumbnail.closeThumbnail('" + studyUid + "')><img src='images/close.png' style='width: 8px;'></img> </span>" + "</td>" + "</tr>" + "</table>"
            }

            // Create the new thumbnail panel
            isNewThumbnailPanel = (isNewThumbnailPanel === undefined ? true : isNewThumbnailPanel);
            if(isNewThumbnailPanel) {
                $("#imageThumbnail_View").append(studyThumbnailDiv);
                $("#" + studyThumbDivId).append(studyInfoDiv);
                $("#" + studyThumbDivId).append("<div id=thumb_" + studyThumbDivId + " style='padding-top: 4px;padding-left: 4px;'/>");
            }

            // Create the thumbnails
            var numberOfSeries = dicomViewer.Study.getSeriesCount(studyUid);
            for (var seriesIndex = seriesStartingIndex; seriesIndex < numberOfSeries; seriesIndex++) {
                var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, 0);
                var imageUid = dicomViewer.Series.Image.getImageUid(image);

                // Generate the thumbnail id
                var thumbnailId = 'imageviewer_' + replaceDotValue(studyUid) + "_" + seriesIndex + '_thumb'
                var thumbnailString = '<div id="' + thumbnailId + '" style="clear:right; width:auto;background:black; margin-right: 5px; margin-bottom: 5px; " onclick="loadImage(event)" class="default-thumbnail-view col-xs-12"></div>';

                if (!isBlob(image.imageType)) {
                    var modality = dicomViewer.Series.getModality(studyUid, seriesIndex);
                    var numberOfImage = dicomViewer.Series.getImageCount(studyUid, seriesIndex)
                    var isImageThumbnails = isSeriesContainsMultiframe(studyUid, seriesIndex);
                    if (isImageThumbnails) {
                        createImageThumbail(studyUid, seriesIndex, numberOfImage, studyThumbDivId);
                    } else {
                        $("#thumb_" + studyThumbDivId).append(thumbnailString);
                        var thumb = new ThumbnailRenderer();
                        thumb.setStudyUid(studyUid);
                        thumb.createThumbnail(studyUid, imageUid, thumbnailId, seriesIndex);
                        addThumbnails(thumbnailId, thumb);
                    }
                } else {
                    $("#thumb_" + studyThumbDivId).append(thumbnailString);
                    var thumb = new ThumbnailRenderer();
                    thumb.setStudyUid(studyUid);
                    thumb.createThumbnail(studyUid, imageUid, thumbnailId, seriesIndex);
                    addThumbnails(thumbnailId, thumb);
                }
            }
        }
        catch(e)
        { }
    }

    //This function used to close the specific study level thumbnails
    function closeThumbnail(studyUid) {
        var numberOfStudies = dicomViewer.getListOfStudyUid().length;
        var repacedStudyUid = dicomViewer.replaceDotValue(studyUid);
        $("#study_thumb_" + repacedStudyUid).remove();
        $("#break_" + repacedStudyUid).remove();
        dicomViewer.viewports.deleteViewportsByThumbnail(repacedStudyUid);

            // Remove the context from the display context
            removeThumbnailContext(studyUid);

        dicomViewer.removeStudyDetails(studyUid);

        if (numberOfStudies == 1) {
            showOrClearSession(false);
        } else if(numberOfStudies > 1) {
            adjustLayout();
        }
    }

    function setShowCacheIndicatorOnThumbnail() {
        if(showCacheIndicatorOnThumbnail === true) showCacheIndicatorOnThumbnail = false;
        else showCacheIndicatorOnThumbnail = true;
    }
     function isShowCacheIndicatorOnThumbnail() {
        return showCacheIndicatorOnThumbnail;
    }
    dicomViewer.thumbnail = {
        createThumbnail: createThumbnail,
        selectThumbnail: selectThumbnail,
        alertThumbnailSelection: alertThumbnailSelection,
        selectImageThumbnail: selectImageThumbnail,
		removeSelctedThumbnail: removeSelctedThumbnail,
        getThumbnail: getThumbnail,
        getAllThumbnails : getAllThumbnails,
        isImageThumbnail: isImageThumbnail,
        makeThumbnailVisible: makeThumbnailVisible,
        closeThumbnail: closeThumbnail,
        closeThumbnailPanel: closeThumbnailPanel,
        setShowCacheIndicatorOnThumbnail : setShowCacheIndicatorOnThumbnail,
        isShowCacheIndicatorOnThumbnail : isShowCacheIndicatorOnThumbnail,
        isSeriesContainsMultiframe : isSeriesContainsMultiframe,
        removeThumbnailContext : removeThumbnailContext,
        createOrAppendThumbnail : createOrAppendThumbnail,
        getViewportProperty : getViewportProperty,
        setViewportProperty : setViewportProperty,
        canRunCine  : canRunCine
    };
    dicomViewer.resizeThumbnailPanel = resizeThumbnailPanel;
    dicomViewer.replaceDotValue = replaceDotValue;
    dicomViewer.replaceSpecialsValues = replaceSpecialsValues;

    return dicomViewer;
}(dicomViewer));var dicomViewer = (function(dicomViewer){
	
	if(dicomViewer === undefined)
	{
		dicomViewer = {};
	}
    var isFirstTimeImageLoad = true;
    var overlayVisibleStatus = false;
    var scoutLineVisibleStatus = true;
    var is6000Overlay = true;
    var annotationAndMeasurementVisibleStatus = true;
    var refreshCineManager = [];
    var refreshCineManagerFullScreen = [];
	
	var flagFor2dLengthCalibration = false;
    var isLengthCalibrating = false;
	
	function getFlagFor2dLengthCalibration(){
		return flagFor2dLengthCalibration;
	}
	
	function updateStudyLayoutSelection(value){
		
	}

    function updateWindowLevelSettings(presetIndex) {		
		presetIndex = parseInt(presetIndex);
		 $("#1").parent().css("background","");
		 $("#2").parent().css("background","");
		 $("#3").parent().css("background","");
		 $("#4").parent().css("background","");
		 $("#5").parent().css("background","");
		 $("#6").parent().css("background","");
		 $("#7").parent().css("background","");
		 $("#1_ww_wcContextMenu").css("background","");
		 $("#2_ww_wcContextMenu").css("background","");
		 $("#3_ww_wcContextMenu").css("background","");
		 $("#4_ww_wcContextMenu").css("background","");
		 $("#5_ww_wcContextMenu").css("background","");
		 $("#6_ww_wcContextMenu").css("background","");
		 $("#7_ww_wcContextMenu").css("background","");
		 
		 switch(presetIndex) {
            case 1:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #default").prop("checked", true);
            break;
            case 2:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #abdomen").prop("checked", true);
            break;
            case 3:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #lung").prop("checked", true);
            break;
            case 4:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #brain").prop("checked", true);
            break;
            case 5:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #bone").prop("checked", true);
            break;
            case 6:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #headneck").prop("checked", true);
            break;
			case 7:
				 $("#"+presetIndex).parent().css("background","#868696");
				 $("#"+presetIndex+"_ww_wcContextMenu").css("background","#868696");
				//$("#windowlevelsettings #headneck").prop("checked", true);
            break;
			
            default:
				 $("#1").parent().css("background","");
				 $("#2").parent().css("background","");
				 $("#3").parent().css("background","");
				 $("#4").parent().css("background","");
				 $("#5").parent().css("background","");
				 $("#6").parent().css("background","");
				 $("#7").parent().css("background","");
                /*$("#windowlevelsettings #headneck").prop("checked", false);
                $("#windowlevelsettings #bone").prop("checked", false);
                $("#windowlevelsettings #brain").prop("checked", false);
                $("#windowlevelsettings #lung").prop("checked", false);
                $("#windowlevelsettings #abdomen").prop("checked", false);
                $("#windowlevelsettings #default").prop("checked", false);*/
            break;
        }
		
	    var seriesLayout = dicomViewer.getActiveSeriesLayout();
        seriesLayout.preferenceInfo.setWindowLevelSettings(presetIndex);
    }
	
	function updateZoomLevelSettings(id) {		
		resetZoomTool();
		if(id !== -1)
		{
			$("#"+id+"ContextMenu").css("background","#868696");
			$("#"+id).parent().css("background","#868696");
		}
				 
		}
    

    function isOverlayVisible() {
        return overlayVisibleStatus; 
    }

     function isScoutLineVisible() {
        return scoutLineVisibleStatus; 
    }

	function changePreset( presetIndex )
	{
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
        updateWindowLevelSettings(presetIndex);
        $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
				var imageLayoutId = $(this).attr('id');
				var imageRender = seriesLayout.getImageRender(imageLayoutId);
				if(imageRender)
					imageRender.applyPreset(presetIndex);
			});
	}
	
	function invert()
	{
        isCopyAttribute = false;
        var cineRunning = false;
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if(dicomViewer.scroll.isCineRunning(seriesLayout.getSeriesLayoutId())) cineRunning = true;
        if(cineRunning) stopCineImage(undefined)
		$("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
			var imageLayoutId = $(this).attr('id');
            
			var imageRender = seriesLayout.getImageRender(imageLayoutId);
			if(imageRender){
                console.log(imageLayoutId);
				imageRender.invert();
            }
		});
        if(cineRunning)
        {
            dicomViewer.startCine();
            updatePlayIcon("play.png","stop.png");
        }
	}
	
	function rotate()
	{
        isCopyAttribute = false;
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if( !isEmbedPdfViewer && 
           (seriesLayout.imageType === IMAGETYPE_PDF || 
            seriesLayout.imageType === IMAGETYPE_TIFF || 
            seriesLayout.imageType === IMAGETYPE_RADPDF)) {
            dicomViewer.rotate();
            return;
        }

		$("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
			var imageLayoutId = $(this).attr('id');
			var imageRender = seriesLayout.getImageRender(imageLayoutId);
			if(imageRender)
				imageRender.rotate(90);
		});
	}
	
	function revert()
	{
		var seriesLayout = dicomViewer.getActiveSeriesLayout();

        if( !isEmbedPdfViewer && 
           (seriesLayout.imageType === IMAGETYPE_PDF || 
            seriesLayout.imageType === IMAGETYPE_TIFF || 
            seriesLayout.imageType === IMAGETYPE_RADPDF)) {
            dicomViewer.revert();
        } else if(seriesLayout.imageType == IMAGETYPE_RADECG){
            dicomViewer.Refresh();
        } else {
            //dicomViewer.setimageCanvasOfViewPort(seriesLayout.getSeriesLayoutId());
            seriesLayout.setFrameIndex(0);
            $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
                var imageLayoutId = $(this).attr('id');
                var imageRender = seriesLayout.getImageRender(imageLayoutId);
                if(imageRender !== undefined){
                    imageRender.revert(imageRender.getCurrentUIDs(), imageRender.getSeriesIndex());
                    imageRender.getPresentation().sharpen = 0;
                }
            });
            changePreset("1");
            setZoomLevel(1);
        }
        RevertRGBTool();
	}

    /**
     * Reverting the RGBTool
     */ 
    function RevertRGBTool()
    {
        var isColor = isColorImage();
        if(isColor === true) {
            rgbColor(0);
        }
    }

	function doOverLay() {
        overlayVisibleStatus = !overlayVisibleStatus;
        var allViewports = dicomViewer.viewports.getAllViewports();
        for (var key in allViewports) {
            var viewportTemp = allViewports[key];
            $("#" + viewportTemp.getSeriesLayoutId() + " div").each(function() {
                var imageLayoutId = $(this).attr('id');
                var imageRender = viewportTemp.getImageRender(imageLayoutId);
                if(imageRender) {
                    imageRender.showOrHideOverlay(overlayVisibleStatus);
                }
            });
        }
	}

    /**
     * Enable disable the scout line depends on the menu selection
     */ 
    function doScoutLine() {
        scoutLineVisibleStatus = !scoutLineVisibleStatus;
        var allViewports = dicomViewer.viewports.getAllViewports();
        var activeviewport = dicomViewer.getActiveSeriesLayout();
        var laststudyuid  = undefined;

        for (var key in allViewports) {
            var viewportTemp = allViewports[key];
            if(scoutLineVisibleStatus) {
                if (viewportTemp.studyUid !=undefined) {
                    if(laststudyuid != viewportTemp.studyUid) {
                        dicomViewer.setActiveSeriesLayout(viewportTemp);
                    }
                    laststudyuid = viewportTemp.studyUid; 
                }
            }

            $("#" + viewportTemp.getSeriesLayoutId() + " div").each(function() {
                var imageLayoutId = $(this).attr('id');
                var imageRender = viewportTemp.getImageRender(imageLayoutId);
                if(imageRender) {
                    imageRender.drawDicomImage();
                }
            });
        }
        dicomViewer.setActiveSeriesLayout(activeviewport);
    }

    function setOverlay(overlayVisible) {
        overlayVisibleStatus = overlayVisible;
    }
	
	function changeStudyLayout(row, column, isBackup,isResize)
	{
        if(layoutMap == undefined || layoutMap == null) {
            layoutMap = {};
        }
        setSelectedStudyLayout(row, column);
        if(isFullScreenEnabled) {
            var activeViewport = dicomViewer.getActiveSeriesLayout();
            dicomViewer.setStudyLayout(1,1, activeViewport.getStudyUid(), activeViewport.seriesIndex, true);
        }
        else {
            dicomViewer.setStudyLayout(row,column, undefined, undefined, isBackup,isResize);
        }
        dicomViewer.changeSelection("imageviewer_studyViewer1x1_1x1");
        activeSeriesPDFData = undefined;
        isPDFActiveSeries = false;
        var activeViewport = dicomViewer.getActiveSeriesLayout();

        if((isEmbedPdfViewer == false && activeViewport != null && activeViewport !== undefined) && 
           (activeViewport.imageType == IMAGETYPE_PDF || 
            activeViewport.imageType === IMAGETYPE_TIFF || 
            activeViewport.imageType == IMAGETYPE_RADPDF)) {
            dicomViewer.updatePaging(activeViewport.seriesLayoutId);
           }
	}
	
	function changeSeriesLayout( row , column , studyLayout)
	{
        isCineEnabled(true);
		studyDiv = studyLayout.id;
		layoutRow = row;
        layoutColumn = column;
		if(row === undefined || row === 0)
		{
			row = 1;
		}
		if(column === undefined || column === 0)
		{
			column = 1;
		}

        // If the user changes the series level layout when the fullscreen mode is ON we set it to OFF to handle the zoom, invert and other overlay properly for all the images.
        if(row > 1 || column > 1) {
            if(isFullScreenEnabled) {
                isFullScreenEnabled = false;
            }
        }
		var newSeriesLayout = dicomViewer.viewports.getViewport("imageviewer_"+studyDiv+"_1x1");
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var selectedLayoutId = seriesLayout.seriesLayoutId;
        var seriesLayoutMaxId = dicomViewer.viewports.getSeriesLayoutMaxId();
        if(seriesLayoutMaxId != undefined) {
            var rowColumnValue = seriesLayoutMaxId.split('_')[2];
        }
        var viewportNumber = 0;
        if(rowColumnValue != undefined) {
            viewportNumber = dicomViewer.viewports.getViewportNumber(parseInt(rowColumnValue.split('x')[0]), parseInt(rowColumnValue.split('x')[1]), selectedLayoutId.split('_')[2]);
        }
        var imageAndSeriesIndex = getOrSetReArrangedSeriesPositions(row, column);
        layoutMap[studyDiv] = row+"x"+column;
        if(seriesLayout.studyUid === newSeriesLayout.studyUid)
            dicomViewer.setSeriesLayout(seriesLayout.studyUid, row, column, imageAndSeriesIndex, null, studyDiv);
        else
            dicomViewer.setSeriesLayout(newSeriesLayout.studyUid, row, column, 0, null, studyDiv);
        isCineEnabled(false);

        dicomViewer.setReArrangedSeriesPositions(undefined);
        if(seriesLayout !== undefined && seriesLayout !== null) {
            var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(seriesLayout.studyUid, seriesLayout.seriesIndex);
            //If there is any duplicate viewport in the series level layout then updating the series layout on the basis of the vieport number 
            if(dicomViewer.viewports.isDuplicateViewport(isMultiFrame, isMultiFrame ? seriesLayout.scrollData.imageIndex : seriesLayout.seriesIndex)) {
                var viewport = dicomViewer.viewports.getSelectedViewport(studyDiv, row, column, viewportNumber);
                if(viewport != undefined || viewport != null) {
                    seriesLayout = viewport;
                }
            }
            dicomViewer.changeSelection(seriesLayout.seriesLayoutId);
        }
        changeIconSize();
    }
	
    function chanageWhileDrag( row , column, studyDiv,isThumbnailClick)
    {
        layoutRow = row;
        layoutColumn = column;
        if(row === undefined || row === 0)
        {
            row = 1;
        }

        var layoutId = "imageviewer_"+ studyDiv+ "_1x1" /*(row) + "x" + (column)*/;                
        var viewport = dicomViewer.viewports.getViewport(layoutId);

        if(column === undefined || column === 0)
        {
            column = 1;
        }

        /*if(row ==3 || column == 3)
        {
            layoutMap[studyDiv] = "cxs";
        }else{
          layoutMap[studyDiv] = row+"x"+column;
        }*/
        layoutMap[studyDiv] = row+"x"+column;
        var imagecanvasValue = dicomViewer.getimageCanvasOfViewPort(layoutId);
        var seriesIndex = 0;
        if(imagecanvasValue != undefined)
        {			
            seriesIndex = imagecanvasValue.seriesIndex;
        }
        if(layoutId === "imageviewer_studyViewer1x1_1x1" && isFullScreenEnabled === false)
        {
            seriesIndex = seriesIndexBackup;
        }
        if(isFullScreenEnabled) {
            dicomViewer.setSeriesLayout(viewport.studyUid, 1, 1, seriesIndex, null, studyDiv, false,undefined,isThumbnailClick);
        } else {
            dicomViewer.setSeriesLayout(viewport.studyUid, row, column, seriesIndex, null, studyDiv, false,undefined,isThumbnailClick);
        }
    }
	
    /**
     *Change the image layout by changing the no of images in the active viewport for the selected series
     *Possible image layouts - {1x1, 1x2, 2x1, 2x2}
     *@param {Integer} row - Total no of rows in image layout
     *@param {Integer} column - Total no of columns in image layout
     */
	function changeImageLayout(row, column, divId) {
        $("#playButton").removeClass("k-state-disabled"); //enable the playbutton if it is disabled
        nextslideindex = 0;
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
		seriesLayout.setImageLayoutDimension(row + "x" +column);
        var totalImageLevelLayout = row * column;
        var imageIndex = seriesLayout.getImageIndex();
        var frameIndex = seriesLayout.getFrameIndex();
        //For getting the total image count for the selected series of active study
        var imageSeries = dicomViewer.Series.getSeries(seriesLayout.studyUid, seriesLayout.seriesIndex);
        // Checking whether the image level layout changes to like 1 x 2, 2 x 1, 2 x 2
        if(totalImageLevelLayout > 1){
            var studyUid = seriesLayout.getStudyUid();
            var imageValue = dicomViewer.Series.Image.getImage(studyUid, seriesLayout.seriesIndex,imageIndex);
            if(imageValue != undefined){
                // Checking whether the respective image is multiframe or not
                var isMultiframe = dicomViewer.thumbnail.isImageThumbnail(imageValue);
                var imageAndFrameIndex = isMultiframe ? seriesLayout.getFrameIndex() : seriesLayout.getImageIndex();
                var totalImageCount = isMultiframe ? dicomViewer.Series.Image.getImageFrameCount(imageValue) : seriesLayout.getImageCount();

                // Following calculation to display an images or frames to selected image level layout based on thier availability 
                var difference = totalImageCount - imageAndFrameIndex;
                if((totalImageCount < 4 || totalImageCount === undefined) && 
                   (totalImageLevelLayout === 4 || totalImageLevelLayout > 4)) {
                    imageAndFrameIndex = 0;
                }
                else if((totalImageCount < 4 || totalImageCount === undefined &&
                         totalImageLevelLayout < 4) && imageAndFrameIndex > 0) {
                    imageAndFrameIndex--;
                }
                else if(imageAndFrameIndex + 1 === totalImageCount || difference < totalImageLevelLayout){
                    imageAndFrameIndex = imageAndFrameIndex - (totalImageLevelLayout - difference);
                }

                imageIndex = isMultiframe ? seriesLayout.getImageIndex() : imageAndFrameIndex;
                frameIndex = !isMultiframe ? seriesLayout.getFrameIndex() : imageAndFrameIndex;
                if(!isMultiframe) {
                    //Stop the cine and disable the play button when the image count for the active series is < 4 and the image layout is 2x2
                    if(imageSeries.imageCount < 4 && seriesLayout.imageLayoutDimension == "2x2")
                    {
                        dicomViewer.tools.stopCineImage();
                        updatePlayIcon("stop.png", "play.png", false,  "#playButton");
                        $("#playButton").addClass("k-state-disabled");
                    }
                }
            }
        }
        if(divId !== undefined) {
            dicomViewer.setImageLevelLayout(seriesLayout.studyUid, row, column, seriesLayout.getSeriesLayoutId(), seriesLayout,seriesLayout.getSeriesIndex(), imageIndex, frameIndex);
        }
        if(dicomViewer.scroll.isCineRunning(seriesLayout.getSeriesLayoutId())) {
            var modality = dicomViewer.Series.getModality(seriesLayout.getStudyUid(), seriesLayout.getSeriesIndex());
            showOrHideInCineRunning(modality, true);
            if(modality == "US")
            {
                UpdateToolbarIcon(true);
            }
      }
        EnableDisableNextSeriesImage(seriesLayout);
	}
	
	function showDicomHeader()
	{
		var returnString = "";
        var imageRender;
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
		var layoutId = seriesLayout.getSeriesLayoutId();
		$("#" + layoutId + " div").each(function(){
		var imageLevelId = $(this).attr('id');

		if(seriesLayout.imageType === IMAGETYPE_RADSR)
		{
			imageRender = seriesLayout.getImageRender("srReport")
			returnString = dicomViewer.header.getDicomHeaderValues(seriesLayout.studyUid,imageRender.imageUid);
		}
		else if(seriesLayout.imageType === IMAGETYPE_RADECG){
            imageRender = seriesLayout.getImageRender("ecgData")
			returnString = dicomViewer.header.getDicomHeaderValues(seriesLayout.studyUid,imageRender.imageUid);
        }else
        {
            imageRender = seriesLayout.getImageRender(imageLevelId);
        }
		if(imageRender != undefined)
		{
           
			var imagePromiseObj = imageRender.imagePromise;
             if(imagePromiseObj != undefined)
             {
                var dicomObjct;
                imagePromiseObj.then(function(image){
                    dicomObjct = image;
                    returnString = dicomViewer.header.getDicomHeaderValues(seriesLayout.studyUid,dicomObjct.imageUid);
                    var innerHTMLString = "<tr><th>Group</th><th>Element</th><th>Description</th><th>VR</th><th align='left'>Value</th></tr>";
                    for ( var i = 0; i < returnString.length; i++)
                    {
                        var tagString = returnString[i].tag.replace("(", "").replace(")", "").split(",");
                        if(tagString[0] === "0010" && tagString[1] === "0010"){
                            innerHTMLString += '<tr><td>' + tagString[0] + '</td><td>' + tagString[1] + '</td><td>'
                                + returnString[i].tagDescription + '</td><td>' + returnString[i].vrType
                                + '</td><td>' + returnString[i].tagValue.replace(/\^/gi, ' ') + '</td></tr>';
                        }else
                        {
                        innerHTMLString += '<tr><td>' + tagString[0] + '</td><td>' + tagString[1] + '</td><td>'
                                + returnString[i].tagDescription + '</td><td>' + returnString[i].vrType
                                + '</td><td>' + returnString[i].tagValue + '</td></tr>';
                        }
                    }
                    $("#dicomHeader").html(innerHTMLString);
                    $("#dicomHeaderAttributes").dialog('open');
                    dicomViewer.pauseCinePlay(1,true);
                    return false;
                });             
                
             }
             else
             {
                    returnString = dicomViewer.header.getDicomHeaderValues(seriesLayout.studyUid,imageRender.imageUid);
                     var innerHTMLString = "<tr><th>Group</th><th>Element</th><th>Description</th><th>VR</th><th align='left'>Value</th></tr>";
                        for ( var i = 0; i < returnString.length; i++)
                        {
                            var tagString = returnString[i].tag.replace("(", "").replace(")", "").split(",");
                            if(tagString[0] === "0010" && tagString[1] === "0010")
                            {
                            innerHTMLString += '<tr><td>' + tagString[0] + '</td><td>' + tagString[1] + '</td><td>'
                                + returnString[i].tagDescription + '</td><td>' + returnString[i].vrType
                                + '</td><td>' + returnString[i].tagValue.replace(/\^/gi, ' ') + '</td></tr>';
                            }else
                            {
                                innerHTMLString += '<tr><td>' + tagString[0] + '</td><td>' + tagString[1] + '</td><td>'
                                        + returnString[i].tagDescription + '</td><td>' + returnString[i].vrType
                                        + '</td><td>' + returnString[i].tagValue + '</td></tr>';
                            }
                        }
                        $("#dicomHeader").html(innerHTMLString);
                        $("#dicomHeaderAttributes").dialog('open');
                        dicomViewer.pauseCinePlay(1,true);
                        return false;
             }
		}   
		});
		
	}
    
    function showImageData() {
        var imageRender;
        var imageLevelId;
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if(seriesLayout.imageType === IMAGETYPE_VIDEO || seriesLayout.imageType === IMAGETYPE_AUDIO 
           || seriesLayout.imageType === IMAGETYPE_RADECG || seriesLayout.imageType === IMAGETYPE_RADSR ||
           seriesLayout.imageType === IMAGETYPE_CDA) {
            if(seriesLayout.imageType === IMAGETYPE_RADECG) {
                imageLevelId = "ecgData";
            }
            else if (seriesLayout.imageType === IMAGETYPE_RADSR || seriesLayout.imageType === IMAGETYPE_CDA) {
                imageLevelId = "srReport";
            }
            else {
                imageLevelId = seriesLayout.imageType;
            }
            imageRender = seriesLayout.getImageRender(imageLevelId);
            if(imageRender != undefined)
            {
                displayImageData(seriesLayout, imageRender.imageUid);
                return true;
            }
        }
        else {
            var layoutId = seriesLayout.getSeriesLayoutId();
            $("#" + layoutId + " div").each(function() {
                imageLevelId = $(this).attr('id');
                imageRender = (seriesLayout.getImageRender(imageLevelId) == undefined) ? 
                                seriesLayout.getImageRender(imageLevelId.split("_")[0]) : seriesLayout.getImageRender(imageLevelId);

                if(imageRender != undefined) {
                    var imagePromiseObj = imageRender.imagePromise;
                    if(imagePromiseObj != undefined) {
                        var dicomObjct;
                        imagePromiseObj.then(function(image) {
                            dicomObjct = image;
                            displayImageData(seriesLayout, dicomObjct.imageUid);
                            return false;
                        });
                     }
                    else {
                        displayImageData(seriesLayout, imageRender.imageUid);
                        return false;
                    }
                }
            });
        }
    }

    /**
     * Display the image data window.
     * @param {Type} seriesLayout - specifies the series layout
     * @param {Type} imageUid - specifies the image uid
     */ 
    function displayImageData(seriesLayout, imageUid)
    {
        if(imageUid == undefined) {
            return;
        }

        var def = dicomViewer.header.getMetadata(seriesLayout.studyUid,imageUid);
        def.done(function(metadata) {
            $("#imageMetadata").html(metadata);
        });
        $("#imagingData").dialog('open');
        dicomViewer.pauseCinePlay(1,true);
    }

    function ecgPreference()
    {
		$("#EcgPreference").dialog('open');
    }
	
    function cinePreference()
    {
        var element = document.getElementById("palyselection");
        element.value = dicomViewer.configuration.cine.getCinePlayerPlayBy();
        document.getElementById("framesToRepeat").value = dicomViewer.configuration.cine.getFramesToRepeat();
        document.getElementById("timesToRepeat").value = dicomViewer.configuration.cine.getTimesToRepeat();
        document.getElementById("idleTime").value = dicomViewer.configuration.cine.getIdleTime();                
		$("#cinePreferenceModal").dialog('open');
    }
    function measurementPreference()
    {
        $("#MeaaurementPreferenceModal").dialog('open');
    }
	function setDicomOverLayFalse(seriesLayout)
	{
        var layoutId = seriesLayout.getSeriesLayoutId();

		$("#" + layoutId + " div").each(function() {
			var imageLevelId = $(this).attr('id');
			var imageRender = seriesLayout.getImageRender(imageLevelId);
			if(imageRender) {
                imageRender.showOrHideOverlay(overlayVisibleStatus);
			}
		});
	}

	function doWindowLevel(e)
	{
		if(e != undefined && e.id == "7") {
			customWindowLevel(e.id);
		}
		else if(e == "7") {
            customWindowLevel(e);
        }
		else if(e != undefined && e.id != "winL")
		{
			if(e.id != undefined) {
                dicomViewer.tools.changePreset(e.id);
            } else {
                dicomViewer.tools.changePreset(e);
            }
		}
		else{
			applyWindowLevel();
		}
    }
    
    function doSharpen(e)
    {
        resetMenu();   
        $("#context-sharpen").css("background","#868696");
        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();
        $('#viewport_View').css('cursor','url(images/sharpen.cur), auto');
        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getSharpenTool());

        // refresh image so that US regions appear
        refreshImage();   
    }
	
    function applyWindowLevel()
    {
        resetMenu();
        $("#context-windowlevel").css("background","#868696");        
        $("#context-ww_wc").css("background","#868696");
        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();
        $('#viewport_View').css('cursor','url(images/brightness.cur), auto');
        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getWindowTool());

        // refresh image so that US regions appear
        refreshImage();
    }

	function doPan()
	{
		resetMenu();
		$("#context-pan").css("background","#868696");
		dicomViewer.measurement.setDataToDelete();
			var tool = dicomViewer.mouseTools.getActiveTool();
	 		tool.hanleDoubleClick();
         $('#viewport_View').css('cursor','url(images/pan.cur), auto');
		dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getPanTool());

	    // refresh image so that US regions appear
		refreshImage();
    }
	
	function doZoom(e)
	{
        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();

        resetMenu();

        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if((isEmbedPdfViewer == true) || (isEmbedPdfViewer == false && seriesLayout && seriesLayout.imageType !== IMAGETYPE_PDF &&  seriesLayout.imageType !== IMAGETYPE_TIFF &&
             seriesLayout.imageType !== IMAGETYPE_RADPDF && seriesLayout.imageType !== IMAGETYPE_RADECG)) {
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getZoomTool());
            $('#viewport_View').css('cursor','url(images/zoom.cur), auto');
        }

		if(e === "6_zoom" || (e.id != undefined && e.id === "6_zoom"))
		{
			var customZoomID = e;
			if(e.id != undefined)
				customZoomID = e.id;
			
            changeZoomCustom(customZoomID);
			var seriesLayout = dicomViewer.getActiveSeriesLayout();
            seriesLayout.preferenceInfo.setZoomLevelSettings(parseInt(customZoomID));
        } 
		else if(e.id != undefined && e.id !== "zoomButton")
		{
			var value = e.id.split("_")
			dicomViewer.tools.setZoomLevel(parseInt(value[0]));
			var seriesLayout = dicomViewer.getActiveSeriesLayout();
			seriesLayout.preferenceInfo.setZoomLevelSettings(e.id);
        }
        else if(e.id == "zoomButton")
        {
            resetZoomTool();
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            seriesLayout.preferenceInfo.setZoomLevelSettings(e.id);
        }
        refreshImage();
    }
	
	function do2DLengthMeasurement() {
	    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool());

	    // refresh image so that US regions appear
	    refreshImage();
	}
    
	function doAngleMeasurement() {
	    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getAngleMeasureTool());

	    // refresh image so that US regions appear
	    refreshImage();
	}
	function do2DPointMeasurement() {
	    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool());

	    // refresh image so that US regions appear
	    refreshImage();
	}
	
	function getTraceMeasureTool() {
	    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getTraceMeasureTool());

	    // refresh image so that US regions appear
	    refreshImage();
	}
      
	function getVolumeMeasureTool() {
	    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getVolumeMeasureTool());

	    // refresh image so that US regions appear
	    refreshImage();
	}
	
    function getMitralMeanGradientMeasureTool() {
	    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getMitralMeanGradientMeasureTool());

	    // refresh image so that US regions appear
	    refreshImage();
	}
	function menuSelection(type){
		if(type.id === "ecgPrefrence"){
			ecgPreference();
		}
        else if(type.id === "cinePreference"){
			cinePreference();
		}else if(type.id === "MeaaurementPreference"){
                measurementPreference();
        }/*else{
			//$("#colorpicker").show();
			 $("#colorpicker").trigger( "click" );
			//$("#colorpicker").hide();
		}*/
	}
	function changeStudyLayoutFromTool(type, isBackup,isResize)
	{
        if (isResize === undefined || isResize === true) {
            reOrderExistingStudyUids();
        }
        isCineEnabled(true);
		studyLayoutValue = type.id;
        isFullScreenEnabled = isBackup ? isBackup : false;
		var colAndRow = type.id.split("x");
		changeStudyLayout(colAndRow[0],colAndRow[1], isBackup,isResize);
	}
	/**
	*Reset the Context and toolbar menus
	**/
	function resetMenu(){
        isCopyAttribute = false;
		//context menus
		$("#context-pan").css("background","");
        $("#context-sharpen").css("background","");
        $("#context-windowlevel").css("background","");
        $("#context-ww_wc").css("background","");
 		$("#context-length").css("background","");
 		$("#context-2dPoint").css("background","");
 		$("#context-trace").css("background","");
 		$("#context-volume").css("background","");
		$("#context-length-calibration").css("background","");
        $("#context-angle").css("background","");
		$("#context-hounsfield").css("background","");
        $("#context-cacheIndicator").css("background","");
        $("#context-hounsfield-ellipse").css("background","");
        $("#context-hounsfield-rectangle").css("background","");
        $("#context-text").css("background","");
        $("#context-line").css("background","");
        $("#context-arrow").css("background","");
        $("#context-ellipse").css("background","");
        $("#context-rectangle").css("background","");
        $("#context-freehand").css("background","");
        $("#measurement104").css("background","");
        $("#measurement102").css("background","");
        $("#measurement106").css("background","");
        $("#measurement101").css("background","");
        $("#measurement103").css("background","");
        $("#measurement107").css("background","");
        $("#measurement108").css("background","");
		//Toolbar menus
		$("#0_measurement").css("background","");
		$("#1_measurement").css("background","");
		$("#2_measurement").css("background","");
		$("#3_measurement").css("background","");
		$("#6_measurement").css("background","");
		$("#7_measurement").css("background","");
        $("#14_measurement").css("background","");
        $("#8_text").css("background","");
		$("#9_line").css("background","");
		$("#10_arrow").css("background","");
		$("#11_ellipse").css("background","");
		$("#12_rectangle").css("background","");
		$("#13_freehand").css("background","");
        $("#angle_measurement").css("background","");
        $("#15_pen").css("background","");
        $("#context-pen").css("background","");
	}
	
    /**
    * Reset the Zoom Tool button background color for context and Toolbar menus
    */
    function resetZoomTool()
    {
        //Toolbar menus
        $("#0_zoom").parent().css("background","");
        $("#1_zoom").parent().css("background","");
        $("#2_zoom").parent().css("background","");
        $("#3_zoom").parent().css("background","");
        $("#4_zoom").parent().css("background","");
        $("#5_zoom").parent().css("background","");
        $("#6_zoom").parent().css("background","");
        //Context menus
        $("#0_zoomContextMenu").css("background","");
        $("#1_zoomContextMenu").css("background","");
        $("#2_zoomContextMenu").css("background","");
        $("#3_zoomContextMenu").css("background","");
        $("#6_zoomContextMenu").css("background","");
    }

    /**
    * Complete the incompleted previously draw shape while selecting any of the Measurement/Annotation tool
    */
    function completeShape() {
        var tool = dicomViewer.mouseTools.getActiveTool();
        var toolName = dicomViewer.mouseTools.getToolName();
        if(toolName === "mitralMeanGradientMeasurement" || toolName === "traceMeasurement" 
          || toolName === "angleMeasurement") {
            tool.hanleDoubleClick();
        }
    }

    function do2DMeasurement(type, id, units) {
        resetMenu();
        completeShape();
        if(type.id != undefined) {
            type = type.id.split("_")[0];
        } else if(type != 4) {
            dicomViewer.measurement.draw.setMeasurementType(type, id, units);
        }
        dicomViewer.mouseTools.setPreviousTool(dicomViewer.mouseTools.getActiveTool());
        dicomViewer.mouseTools.setCursor(dicomViewer.mouseTools.getToolCursor(1));
        if (type == 0) {
            isLengthCalibrating = false;
            if(isCaliberEnabled()){
                isLengthCalibrating = true;
                LineMeasurement.prototype.setMeasurementSubType("2DLength");
                setCalibrationActiveTool();
            } else{
                flagFor2dLengthCalibration = false;
                LineMeasurement.prototype.setMeasurementSubType();
                if(id == "mitralRegurgitationLength") {
                    $("#measurement102").css("background","#868696");
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(1));
                } else if (id == "aorticRegurgitationLength"){
                    $("#measurement106").css("background","#868696");
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(2));
                } else if (id == "mitralValveAnteriorLeafletThickness") {
                    $("#measurement101").css("background","#868696");
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(3));
                } else {
                    $("#context-length").css("background","#868696");
                    $("#0_measurement").css("background","#868696");
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(0,"2DLength"));
                    LineMeasurement.prototype.setMeasurementSubType("2DLength");
                }
            }
        }
        else if (type == 1){

            if(id == "mitralRegurgitationPeakVelocity") {
                $("#measurement103").css("background","#868696");
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(1));
            } else if (id == "aorticRegurgitationPeakVelocity"){
                $("#measurement107").css("background","#868696");
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(2));
            } else if (id == "aorticStenosisPeakVelocity") {
                $("#measurement108").css("background","#868696");
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(3));
            } else {
                $("#context-2dPoint").css("background","#868696");
                $("#1_measurement").css("background","#868696");
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DPointMeasureTool(0));
            }
		}
        else if (type == 2) {
			$("#context-trace").css("background","#868696");
			$("#2_measurement").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getTraceMeasureTool());
		}
		else if (type == 3) {
			$("#context-volume").css("background","#868696");
			$("#3_measurement").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getVolumeMeasureTool());
		}
        else if (type == "angle"){
			$("#context-angle").css("background","#868696");
			$("#angle_measurement").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getAngleMeasureTool());
		}
		else if (type == 6) {
            setLengthCalibrationFlag(false);
            setCalibrationActiveTool();
            LineMeasurement.prototype.setMeasurementSubType();
		}
		else if (type == 4) {
			var seriesLayout = dicomViewer.getActiveSeriesLayout();
            var imageRender = seriesLayout.imageRenders;
            for (var key in imageRender) {
                var render = imageRender[key];
				var frameIndex = render.anUIDs.split("*")[1];
				dicomViewer.measurement.removeAllMeasurements(render.imageUid, frameIndex, render);
                var tool = dicomViewer.mouseTools.getActiveTool();
                if(tool != undefined && tool != null){
                    SetMenuSelectionColor(tool.ToolType);
                }
            }
            dicomViewer.measurement.setDataToDelete();
		}
        else if (type == 5) {
			$("#measurement104").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getMitralMeanGradientMeasureTool(0,"mitral"));
            MitralMeanGradientMeasurement.prototype.setMeasurementSubType("mitral");
		}
        else if (type == 7) {
			$("#context-hounsfield-ellipse").css("background","#868696");
			$("#7_measurement").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getEllipseMeasureTool(0,"hounsfield"));
            EllipseMeasurement.prototype.setMeasurementSubType("hounsfield");
		} else if (type == 8) {
			$("#context-text").css("background","#868696");
			$("#8_text").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getRectangleMeasureTool(2,"text"));
            RectangleMeasurement.prototype.setMeasurementSubType("text");
		} else if (type == 9) {
            flagFor2dLengthCalibration = false;
			$("#context-line").css("background","#868696");
			$("#9_line").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(4,"2DLine"));
            LineMeasurement.prototype.setMeasurementSubType("2DLine");
		} else if (type == 10) {
            flagFor2dLengthCalibration = false;
			$("#context-arrow").css("background","#868696");
			$("#10_arrow").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthMeasureTool(5,"Arrow"));
            LineMeasurement.prototype.setMeasurementSubType("Arrow");
		} else if (type == 11) {
			$("#context-ellipse").css("background","#868696");
			$("#11_ellipse").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getEllipseMeasureTool(1,"ellipse"));
            EllipseMeasurement.prototype.setMeasurementSubType("ellipse");
		} else if (type == 12) {
			$("#context-rectangle").css("background","#868696");
			$("#12_rectangle").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getRectangleMeasureTool(1));
            RectangleMeasurement.prototype.setMeasurementSubType("rectangle");
		} else if (type == 13) {
			$("#context-freehand").css("background","#868696");
			$("#13_freehand").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getMitralMeanGradientMeasureTool(1,"freehand"));
            MitralMeanGradientMeasurement.prototype.setMeasurementSubType("freehand");
		}
        else if (type == 14) {
			$("#context-hounsfield-rectangle").css("background","#868696");
            $("#14_measurement").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getRectangleMeasureTool(0,"hounsfield"));
            RectangleMeasurement.prototype.setMeasurementSubType("hounsfield");
		}
        else if (type == 15) {
            $("#context-pen").css("background","#868696");
            $("#15_pen").css("background","#868696");
            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getPenTool());
            PenTool.prototype.setMeasurementSubType("pen");
        }
	    // refresh image so that US regions appear
	    refreshImage();
	}
	
	/**
	*Reset RGB toolbar menus
	**/
	function resetRGBMenu(){
		//context menus
		$("#0_rgbAllContextMenu").css("background","");
		$("#1_rgbRedContextMenu").css("background","");
		$("#2_rgbGreenContextMenu").css("background","");
		$("#3_rgbBlueContextMenu").css("background","");
		
		//Toolbar menus
		$("#0_rgbAll").css("background","");
		$("#1_rgbRed").css("background","");
		$("#2_rgbGreen").css("background","");
		$("#3_rgbBlue").css("background","");
		
		//Overflow menus
		$("#RGBButton_overflow").css("background","");
		$("#0_rgbAll_overflow").css("background","");
		$("#1_rgbRed_overflow").css("background","");
		$("#2_rgbGreen_overflow").css("background","");
		$("#3_rgbBlue_overflow").css("background","");
		
	}
	
	function rgbColor(e, isApplied){
        isCopyAttribute = false;
		var rgbColorId = "0";
		resetRGBMenu();
		if(e.id != undefined && e != undefined){
			rgbColorId = e.id.split("_")[0];		
		}else{
			rgbColorId = e;
		}
				
		if (rgbColorId == 1){
			$("#1_rgbRedContextMenu").css("background","#868696");
			$("#1_rgbRed").css("background","#868696");
		}
        else if (rgbColorId == 2){
			$("#2_rgbGreenContextMenu").css("background","#868696");
			$("#2_rgbGreen").css("background","#868696");
		}
		else if (rgbColorId == 3){
			$("#3_rgbBlueContextMenu").css("background","#868696");
			$("#3_rgbBlue").css("background","#868696");
		}
		else {
			$("#0_rgbAllContextMenu").css("background","#868696");
			$("#0_rgbAll").css("background","#868696");			
		}

        if(isApplied) {
            return;
        }
        		
		var seriesLayout = dicomViewer.getActiveSeriesLayout();
        $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function()
            {
                var imageLevelId = $(this).attr('id');
                var imageRender = seriesLayout.getImageRender(imageLevelId);
                if(imageRender)
                {			
                    	imageRender.applyRGB(parseInt(rgbColorId));
                }        
            });
		
	}
	
	function moveToPreviousImage()
	{
		//Move to previous frame/image 
		dicomViewer.scroll.moveToNextOrPreviousImage(false);
		var serieLayout = dicomViewer.getActiveSeriesLayout();
		var studyUid = serieLayout.getStudyUid();
		var firstImageFrame = $("#"+serieLayout.getSeriesLayoutId()+" div:first").attr("id");
		var imageRender = serieLayout.getImageRender(firstImageFrame);
		var currentImageIndex = null;
		var currentFrameIndex = null;
		if(imageRender != undefined)
		{
			var anUIDs = imageRender.anUIDs;
			var resultArray = anUIDs.split("*");
			currentFrameIndex = parseInt(resultArray[1]);
			currentImageIndex = imageRender.imageIndex;
		}
		serieLayout.setImageIndex(currentImageIndex);
		serieLayout.setFrameIndex(currentFrameIndex);
		dicomViewer.startCacheImages(studyUid);
        EnableDisableNextSeriesImage(serieLayout);
	}
	
	function moveToNextImage()
	{
		//Move to next from frame/image
		dicomViewer.scroll.moveToNextOrPreviousImage(true);
		var serieLayout = dicomViewer.getActiveSeriesLayout();
		var studyUid = serieLayout.getStudyUid();
		var firstImageFrame = $("#"+serieLayout.getSeriesLayoutId()+" div:first").attr("id");
		var imageRender = serieLayout.getImageRender(firstImageFrame);
		var currentImageIndex = null;
		var currentFrameIndex = null;
		if(imageRender != undefined)
		{
			var anUIDs = imageRender.anUIDs;
			var resultArray = anUIDs.split("*");
			currentFrameIndex = parseInt(resultArray[1]);
			currentImageIndex = imageRender.imageIndex;
		}
		serieLayout.setImageIndex(currentImageIndex);
		serieLayout.setFrameIndex(currentFrameIndex);
		dicomViewer.startCacheImages(studyUid);
        EnableDisableNextSeriesImage(serieLayout);
		
	}
	function runCineImage(direction)
	{
		//Run images in cine mode
		dicomViewer.scroll.runCineImage(direction);
	}
	function stopCineImage(direction)
	{
		//Stop images in cine mode
		dicomViewer.scroll.stopCineImage(direction);
	}
    
    function doHorizontalFilp()
    {
        isCopyAttribute = false;
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if( !isEmbedPdfViewer && 
           (seriesLayout.imageType === IMAGETYPE_PDF || 
            seriesLayout.imageType === IMAGETYPE_TIFF || 
            seriesLayout.imageType === IMAGETYPE_RADPDF)) {
            dicomViewer.flip(true);
            return;
        }

		$("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
			var imageLevelId = $(this).attr('id');
			var imageRender = seriesLayout.getImageRender(imageLevelId);
			if(imageRender)
			{
				imageRender.doHorizontalFlip();
			}
		});
    }
    
    function doVerticalFilp()
    {
		resetMenu();
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if( !isEmbedPdfViewer && 
           (seriesLayout.imageType === IMAGETYPE_PDF || 
            seriesLayout.imageType === IMAGETYPE_TIFF || 
            seriesLayout.imageType === IMAGETYPE_RADPDF)) {
            dicomViewer.flip(false);
            return;
        }

		$("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
			var imageLevelId = $(this).attr('id');
			var imageRender = seriesLayout.getImageRender(imageLevelId);
			if(imageRender)
			{
				imageRender.doVerticalFilp();
			}
		});
    }
    
    function setZoomLevel(level)
    {
        resetZoomTool();
        var id = level+"_zoom";
        if(id === "4_zoom" || id === "5_zoom") {
            //SR Zoom tool
            dicomViewer.zoomSR(id);  
        } else {
            $("#"+id+"ContextMenu").css("background","#868696");
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            if(seriesLayout.ecgZoomLevelSettings !== seriesLayout.preferenceInfo.zoomLevelSetting) {
                seriesLayout.ecgZoomLevelSettings = seriesLayout.preferenceInfo.zoomLevelSetting;
                if(level == 6) {
                    id = seriesLayout.ecgZoomLevelSettings;
                }
            }
            seriesLayout.preferenceInfo.setZoomLevelSettings(id);

            $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function(){
                var imageLevelId = $(this).attr('id');
                if( seriesLayout && (seriesLayout.imageType === IMAGETYPE_PDF || 
                                     seriesLayout.imageType === IMAGETYPE_TIFF ||
                                     seriesLayout.imageType === IMAGETYPE_RADPDF)) {
                    if (imageLevelId == undefined || imageLevelId.indexOf("imagePdfDiv") == -1) {
                        return true;
                    }
                    var zoomFactor;
                    if(isNaN(level)) {
                        zoomFactor = (parseFloat(level.split("-")[1]))/100;
                        level = 4;
                    }
                    dicomViewer.setPdfZoom(level,zoomFactor);
                } else {
                    if(seriesLayout.imageType === IMAGETYPE_RADECG)
                    {
                        imageLevelId = "ecgData";
                        var splitArray = seriesLayout.ecgZoomLevelSettings.toString().split("_");
                        if(splitArray[0] == 6 && splitArray.length > 1 && level == 6) {
                           level = splitArray[0] + "_" + splitArray[1];
                        }
                    }
                    else if(seriesLayout.imageType === IMAGETYPE_CDA || seriesLayout.imageType === IMAGETYPE_RADSR) {
                        //HTML files
                        dicomViewer.zoomSR(level);
                        return false;
                    }
                    var imageRender = seriesLayout.getImageRender(imageLevelId);
                    if(imageRender)
                    {
                        imageRender.setZoomLevel(level);
                        var customValue = 0; 
                        var zoomLevel = level;
                        if((level.toString()).indexOf("6_zoom") >=0 ) {
                            customValue = parseInt(level.split("-")[1]);
                            zoomLevel = customValue > 0 ? 6 : 2;
                        }

                        var ecgZoomProperty = {
                            level : zoomLevel,
                            customValue : customValue
                        };
                        seriesLayout.ecgZoomProperty = ecgZoomProperty;
                    }
                }
            });
        }
        $("#"+id).parent().css("background","#868696");
    }

    function refreshImage() {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function () {
            var imageLevelId = $(this).attr('id');
            var imageRender = seriesLayout.getImageRender(imageLevelId);
            if (imageRender) {
                imageRender.renderImage(false);
            }
        });
    }
	
   function moveSeries(incrementFlag)
    {
        var seriesLayout =  dicomViewer.getActiveSeriesLayout();
		var studyUid = seriesLayout.getStudyUid();
        var activeSeriesIndex = parseInt(seriesLayout.seriesIndex);
        var sereisLayoutId = seriesLayout.getSeriesLayoutId();
        dicomViewer.setimageCanvasOfViewPort(sereisLayoutId);
        var numberOfSeries = dicomViewer.Study.getSeriesCount(studyUid);
        var imageAndFrameIndex = dicomViewer.scroll.getCurrentImageAndFrameIndex(incrementFlag, seriesLayout);
        var imageIndex = imageAndFrameIndex[0];
        var frameIndex = imageAndFrameIndex[1];
        var imageCount = dicomViewer.Series.getImageCount(studyUid,activeSeriesIndex);
        var muliFrameImageIndex;
        var seriesIndex;

        var imageValue = dicomViewer.Series.Image.getImage(studyUid, activeSeriesIndex,imageIndex);
		var framecount =0;
        if(imageValue === undefined) return;
        framecount = dicomViewer.Series.Image.getImageFrameCount(imageValue);        
        var isImageThumbnails = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,activeSeriesIndex)
        var thumbnailId;
        if (incrementFlag)
        {
            if(isImageThumbnails)
            {
                muliFrameImageIndex = parseInt(imageIndex) + 1;
                    seriesIndex = activeSeriesIndex;
                if(muliFrameImageIndex >= imageCount){
                    muliFrameImageIndex = 0;            
                    seriesIndex = seriesIndex +1;
                    if(numberOfSeries === seriesIndex)
                        return;
                    imageCount = dicomViewer.Series.getImageCount(studyUid,seriesIndex);
                }                
            }else
            {
                muliFrameImageIndex = 0;
                seriesIndex = activeSeriesIndex + 1;
            }
            if(seriesIndex == numberOfSeries){
                return;
            }
        }
        else
        {
            if(isImageThumbnails)
            {
                /*if(imageIndex === 0)
                    return;*/
                muliFrameImageIndex = parseInt(imageIndex) - 1;
                seriesIndex = activeSeriesIndex;
                if(muliFrameImageIndex < 0){
                    seriesIndex = seriesIndex -1;
                    if(seriesIndex === -1)
                        return;
                    imageCount = dicomViewer.Series.getImageCount(studyUid,seriesIndex);
                    muliFrameImageIndex = imageCount -1; 

                }
            }
            else
            {
                muliFrameImageIndex = 0;
                var studyDetials = dicomViewer.getStudyDetails(studyUid);
                if(studyDetials) {
                    var isMultiframe = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, activeSeriesIndex - 1);
                    if(isMultiframe) {
                        var series = dicomViewer.Series.getSeries(studyUid, activeSeriesIndex - 1);
                        if(series) {
                            muliFrameImageIndex = (series.imageCount - 1) < 0 ? 0 : (series.imageCount - 1);
                        }
                    }
                }

                seriesIndex = activeSeriesIndex - 1;
            }
                       
            if(seriesIndex < 0 ) {
                return;
            }
        }
        seriesLayout.setSeriesIndex(seriesIndex);
        //seriesLayout.setImageIndex(imageIndex);
		imageValue = dicomViewer.Series.Image.getImage(studyUid, seriesIndex,muliFrameImageIndex);
		framecount =0;
        if(imageValue != undefined) framecount = dicomViewer.Series.Image.getImageFrameCount(imageValue);
        var studyDiv = getStudyLayoutId(seriesLayout.seriesLayoutId);
        var imageLayoutDisplayId = "imageDisplay"+studyDiv;
        //frame count is greater than one we displayin images based on the mulframe images in the same series
        if(dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex))
        {            		
            thumbnailId = "imageviewer_"+dicomViewer.replaceDotValue(studyUid)+"_"+(seriesIndex)+"_thumb"+(muliFrameImageIndex);
            if(seriesLayout.imageType !== IMAGETYPE_JPEG) {
                document.getElementById(imageLayoutDisplayId).style.display= 'block';
            }
        }
        else
        {            
            thumbnailId = "imageviewer_"+dicomViewer.replaceDotValue(studyUid)+"_"+(seriesIndex)+"_thumb";
            imageCount = dicomViewer.Series.getImageCount(studyUid,seriesIndex);
            if( imageCount > 1 && seriesLayout.imageType !== IMAGETYPE_JPEG)
                document.getElementById(imageLayoutDisplayId).style.display= 'block';
            else 
                document.getElementById(imageLayoutDisplayId).style.display='none';
        }
        displayImage(seriesLayout,seriesIndex,muliFrameImageIndex, true);
        dicomViewer.setStudyToolBarTools(seriesLayout);
        var modality = dicomViewer.Series.getModality(seriesLayout.studyUid, seriesLayout.seriesIndex);
        if(modality == "CT") {
            updateKendoArrowButton($("#winL_wrapper"), false);
            dicomViewer.updatePreset(seriesLayout);
        }
        var thumbnailRenderer = dicomViewer.thumbnail.getThumbnail(thumbnailId);    
        // If the thumbnail is available to renderer then return the method.
        if (thumbnailRenderer == undefined)
	    {
		    return;
	    }
        if(thumbnailRenderer.imageCountOfSeries==undefined)
            thumbnailRenderer.imageCountOfSeries = 1;
        //Display the thumbnail selection based on next or previous buttons
        dicomViewer.thumbnail.selectImageThumbnail(thumbnailRenderer.seriesIndex,muliFrameImageIndex);
		dicomViewer.scroll.stopCineImage( undefined );
		
        if(dicomViewer.Series.Image.getImageFrameCount(imageValue)>1) {
            dicomViewer.startCine();
            updatePlayIcon("play.png", "stop.png");
           } else {
               dicomViewer.scroll.stopCineImage(undefined);
               updatePlayIcon("stop.png", "play.png");
           }
        //changePlayDirection(e); // if Cine in active, this call will refresh play
        var imageLayout = seriesLayout.getImageLayoutDimension().split("x");
        dicomViewer.tools.changeImageLayout(parseInt(imageLayout[0]),parseInt(imageLayout[1]));
        
        //While manually moving to the next/previous series with the cine player, updating the toolbar buttons status
        var isCinePlay = dicomViewer.scroll.isCineRunning(seriesLayout.getSeriesLayoutId());
        if(!isCinePlay) {
            dicomViewer.enableOrDisableTools(modality, seriesLayout);
        }
        showOrHideInCineRunning(modality, isCinePlay);
        EnableDisableNextSeriesImage(seriesLayout);
    }

    
    function displayImage(seriesLayout,seriesIndex,imageIndex, isMoveSeries) {
        var studyUid = seriesLayout.getStudyUid();
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex,imageIndex);
        var imageUid = dicomViewer.Series.Image.getImageUid(image);
        var imagePromise = dicomViewer.imageCache.getImagePromise(imageUid+"_"+0);
        if(imagePromise === undefined) {
            // Restart the cache from DND image/series if unavailable in browser cache
            dicomViewer.stopCacheProgress();
            dicomViewer.setCacheDataToCache(studyUid,seriesIndex,imageIndex);
            dicomViewer.startCacheImages(studyUid);
            //To prevent cache start in the setImageLevelLayout method
            //of imageViewport.js
            cacheFlag = false;
        }
        seriesLayout.setSeriesIndex(parseInt(seriesIndex));
        seriesLayout.setImageIndex(imageIndex);
        seriesLayout.setFrameIndex(0);
        seriesLayout.setImageCount(dicomViewer.Series.getImageCount(studyUid, seriesIndex));

        var playerButtonImage = $("#playButton_wrapper img")[0].src;
        if( (dicomViewer.scroll.isToPlayStudy(seriesLayout.seriesLayoutId)) && playerButtonImage.indexOf("stop.png") > -1 ) {
            dicomViewer.scroll.loadimages(seriesLayout,parseInt(seriesIndex),imageIndex,0);
        } else {
            seriesLayout.removeAllImageRenders();
            var imageLayout = seriesLayout.getImageLayoutDimension().split("x");
            dicomViewer.setImageLevelLayout(studyUid, parseInt(imageLayout[0]), parseInt(imageLayout[1]), seriesLayout.seriesLayoutId,seriesLayout,seriesIndex, imageIndex,0, isMoveSeries);
       }
    }

    function firstTimeImageLoad() {
        if (isFirstTimeImageLoad) {
            isFirstTimeImageLoad = false;
            return true;
        } else {
            return false;
        }
    }
	
	function lengthCalibration() {
        $("#lengthCalibrationAlert").html('');
        document.getElementById("unit").selectedIndex = 0;
        document.getElementById("calibrateLength").value = "";
        document.getElementById("applyToAllImages").checked = false;
        $("#lengthCalibrationAlert").removeClass('alert-danger');
        $("#lengthCalibrationModal" ).dialog({ dialogClass: 'no-close' });
        $("#lengthCalibrationModal").dialog('open');
    }
	
    function showHangingProtocol() {
        LoadSettings();
        $("#hpModal").dialog('open');
    }
    
    function addHangingProtocol() {
        hpModalityDropdownEventHandlers();
        $("#addMoreHPModal").dialog('open');
    }  

    /**
     * Load the modality layouts
     * @param {Type} selectedModality - Selected modality
     */ 
    function loadModalityLayouts(selectedModality) {
        try
        {
            if(selectedModality === undefined || selectedModality == "") {
                return false;
            }

            var visibility = "hidden";
            if(selectedModality === "General") {
                visibility = "visible";
                document.getElementById("useEmbedPDFViewer").value = isEmbedPdfViewer? "true" : "false";
            }
            document.getElementById("useEmbedPDFViewer_Row").style.visibility = visibility;

            // Check whether the layout is present in the HP table list and update the layout in modality List.
            var isUpdated = false;
            $("#hpTableList").find('tr').each(function (i, el) {
                var tdData = $(this).find('td');
                if(tdData.length >= 4){
                    var modality = tdData.eq(0).text();
                    if(modality == selectedModality){
                        $("#layoutRows").val(tdData.eq(1).text());
                        $("#layoutColumns").val(tdData.eq(2).text());
                        $("#zoomModeValues").val(tdData.eq(3).text());
                        isUpdated = true;
                        return true;
                    }
                }
            });

            // Reset the defaults values if it the selected modality layout is not updated.
            if(!isUpdated){
                $("#layoutRows").val("1");
                $("#layoutColumns").val("1");
            }

            return false;
        }
        catch(e)
        { }

        return false;
    }

    /**
     * Modality event handlers
     */ 
    function hpModalityDropdownEventHandlers() {
        try
        {
            $("#modalityList").unbind('ready');
            $("#modalityList").unbind('change');
            $("#modalityList").change(function() {
                loadModalityLayouts(this.value);
            });
            $("#modalityList").ready(function() {
                loadModalityLayouts($("#modalityList option:selected").val());
            });
        }
        catch(e)
        { }
    }

    /**
     * Delete the selected row
     * @param {Type} tableRow - specifies the table row
     */ 
    function deleteHP(tableRow) {
        try
        {
            $(tableRow).closest('tr').remove();

            // Save the settings to server
            saveSettings();
        }
        catch(e)
        { }
    }

    /**
     * Delete the selected row
     * @param {Type} tableRow - specifies the table row
     */ 
    function editHP(tableRow) {
        try
        {
            if(tableRow.parentNode.parentNode.childNodes.length >= 4){
                var modality = tableRow.parentNode.parentNode.childNodes[0].innerText;
                var rows = tableRow.parentNode.parentNode.childNodes[1].innerText;
                var columns = tableRow.parentNode.parentNode.childNodes[2].innerText;
                var zoomMode = tableRow.parentNode.parentNode.childNodes[3].innerText;
                if(modality != ""){
                    $("#modalityList").val(modality);
                    $("#layoutRows").val(rows);
                    $("#layoutColumns").val(columns);
                    $("#zoomModeValues").val(zoomMode);
                    $("#modalityList").prop('disabled', true);
                }
            }

            addHangingProtocol();
        }
        catch(e)
        { }
    }

    /**
     * Get the hanging protocol as JSON
     */ 
    function getJSONSettings()
    {
        var jsonObj = [];
        $("#hpTableList").find('tr').each(function (i, el) {
            var tdData = $(this).find('td');
            if(tdData.length >= 4){
                var modality = tdData.eq(0).text();
                var rows = tdData.eq(1).text();
                var columns = tdData.eq(2).text();
                var zoomMode = tdData.eq(3).text();

                var item = {};
                item ["Modality"] = modality;
                item ["Rows"] = rows;
                item ["Columns"] = columns;
                item ["ZoomMode"] = zoomMode;

                if(modality === "General" && tdData.length >= 5) {
                    item ["isEmbedPDFViewer"] = isEmbedPdfViewer ? "true" : "false";
                }
                jsonObj.push(item);
            }
        });

        return JSON.stringify(jsonObj);
    }

    /**
    * Load the settings from server
    */ 
    function LoadSettings()
    {
        try
        {
            var th = "<tr><th>Modality</th><th>Rows</th><th>Columns</th><th>Zoom Mode</th><th align='left'>Action</th></tr>";
            var settingsUrl = dicomViewer.getSettingsUrl();
            $.ajax({
                url: settingsUrl,
                cache: false,
                beforeSend: function(xhr) {
                    xhr.overrideMimeType("text/plain; charset=x-user-defined");
                }
            })
            .done(function(data) {
                // Reset the table content 
                $("#hpTableList").empty();

                // Add the header
                $("#hpTableList").append(th);

                //var layoutArray = eval('(' + JSON.parse(data) + ')');
                var layoutArray = JSON.parse(data);
                if(layoutArray == null || layoutArray.length == 0){
                    return;
                }

                var tdAction = '"<td><img src="images/edit.png" height="16" size="16" alt="edit" onclick="dicomViewer.tools.editHP(this)"><img src="images/delete.png" height="16" size="16" alt="delete" onclick="dicomViewer.tools.deleteHP(this)"></td>;"'

                var tr;
                for (var i = 0; i < layoutArray.length; i++) {
                    tr = $('<tr/>');
                    tr.append("<td>" + layoutArray[i].Modality + "</td>");
                    tr.append("<td>" + layoutArray[i].Rows + "</td>");
                    tr.append("<td>" + layoutArray[i].Columns + "</td>");
                    tr.append("<td>" + layoutArray[i].ZoomMode + "</td>");
                    tr.append(tdAction);
                    $("#hpTableList").append(tr);
                }
            })
            .fail(function(data) {
                // Reset the table content 
                $("#hpTableList").empty();

                // Add the header
                $("#hpTableList").append(th);
            })
            .error(function(xhr, status) {
                var description = xhr.statusText + "\nFailed to load the settings from server";
                sendViewerStatusMessage(xhr.status.toString(), description);
            });
        }
        catch(e)
        {
        }
    }

    /**
     * Save the settings to server
     */ 
    function saveSettings(){
        try
        {
            var settingsUrl = dicomViewer.getSettingsUrl();
            var tableData = getJSONSettings();
            $.ajax({
                type: 'POST',
                url: settingsUrl,
                data: tableData,
                beforeSend: function(xhr) {
                    xhr.overrideMimeType("text/plain; charset=x-user-defined");
                }
            })
            .success(function(data) {
            })
            .fail(function(data) {
            })
            .error(function(xhr, status) {
                var description = xhr.statusText + "\nFailed to save the settings to server";
                sendViewerStatusMessage(xhr.status.toString(), description);
            });            
        }
        catch(e)
        {
        }
    }

	/**
     * Enable the HP controls while adding 
     */ 
    function enableHPControls(){
        try
        {
            if($("#modalityList").length > 0){
                $("#modalityList").prop('disabled', false);
                $("#modalityList").selectedIndex = 0;
                $("#layoutRows").selectedIndex = 0;
                $("#layoutColumns").selectedIndex = 0;
                $("#zoomModeValues").selectedIndex = 0;
            }
        }
        catch(e)
        { }
    }

    /**
     * Set the selected study layout
     * @param {Type} row - Specifies the rows
     * @param {Type} column - Specifies the columns
     * @param {Type} isWrapper - Specifies the overflow
     */ 
    function setSelectedStudyLayout(row, column, isWrapper) {
        try
        {
            // Remove selected table rows
            var applySelectedCell;
            for(var rows = 0 ;rows < 9; rows++ ) {
                applySelectedCell = $(".tableCell")[rows];
                $(applySelectedCell).removeClass("selectedCell");
            }

            // Apply selected table row and columns
            var cInc = 0;
            for(var rows = 0 ;rows < row; rows++ ) {
                for(var columns = 0 ;columns < column; columns++ ) {
                    applySelectedCell = $(".tableCell")[cInc+columns];
                    $(applySelectedCell).addClass("selectedCell");
                }
                cInc += 3;
            }
            // Display row and column text
            var studyId = row + " x " + column;
            $('#tableDimmensions').html(studyId);
        }
        catch(e)
        { }
    }

    /**
     * Reorder the exising study Uid to maintain the visibile study in the new study layout
     */ 
    function reOrderExistingStudyUids(isResize) {
        try
        {
            // Reset the existing reordered studyUids
            dicomViewer.setReOrderedStudyUids(undefined, true);

            var allViewports = dicomViewer.viewports.getAllViewports();
            if(allViewports === null || allViewports === undefined) {
                return;
            }

            var seriesLayouts = [];
            $.each(allViewports, function(key, value) {
                if(value.studyUid !== undefined || isResize) {
                    seriesLayouts.push(value.seriesLayoutId);
                }
            });

            // Sorting the series layout id
            var existinngStudyUids = [];
            if(seriesLayouts.length > 0) {
                seriesLayouts.sort();
                seriesLayouts.forEach(function(viewportId) {
                    var viewport = dicomViewer.viewports.getViewport(viewportId);
                    if(viewport != null && viewport != undefined) {
                        if(viewport.studyUid !== undefined || isResize) {
                            if(existinngStudyUids.indexOf(viewport.studyUid) === -1){
                                existinngStudyUids.push(viewport.studyUid);
                            }
                        }
                    } else if (isResize) {
                        if(existinngStudyUids.indexOf(viewport.studyUid) === -1){
                                existinngStudyUids.push(viewport.studyUid);
                        }
                    }
                });
            }

            if(existinngStudyUids.length == 0) {
                dicomViewer.setReOrderedStudyUids(undefined, true);
            }

            var studyUids = dicomViewer.getListOfStudyUid();
            if(studyUids !== undefined && studyUids !== null) {
                studyUids.forEach(function(studyUid) {
                    if(existinngStudyUids.indexOf(studyUid) == -1) {
                        existinngStudyUids.push(studyUid);
                    }
                });
            }

            dicomViewer.setReOrderedStudyUids(existinngStudyUids, false);
        }
        catch(e)
        { }
    }

    /**
     * Get or Set the rearranged series positions
     * @param {Type} row - Specifies the Row
     * @param {Type} column - Specifies the Column
     */ 
    function getOrSetReArrangedSeriesPositions(row, column, isDoubleClick) {
        try
        {
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            var seriesIndex = seriesLayout.getSeriesIndex();
            var imageIndex = seriesLayout.scrollData.imageIndex;
            var totalSeriesLevelLayout = row * column;
            var imageValue = dicomViewer.Series.Image.getImage(seriesLayout.studyUid,seriesIndex,0);
            var isMultiframe = dicomViewer.thumbnail.isImageThumbnail(imageValue);
            var imageAndSeriesIndex = isMultiframe ? imageIndex : seriesIndex;

            // Initialize the rearranged series position values
            var selectThumbnailImageIndex = seriesLayout.scrollData.imageIndex;
            var actualSeriesIndex = imageAndSeriesIndex;
            var multiFrameImageIndex = 0;

            if(totalSeriesLevelLayout > 1){
                if(imageAndSeriesIndex < totalSeriesLevelLayout) {
                    imageAndSeriesIndex = 0;
                }
                else if(totalSeriesLevelLayout < 4 && imageIndex > 0) {
                    imageAndSeriesIndex--;
                }
                else {
                    imageAndSeriesIndex++;
                    imageAndSeriesIndex = imageAndSeriesIndex - totalSeriesLevelLayout;
                }
            }

            if(isMultiframe == true) {
                multiFrameImageIndex = imageAndSeriesIndex;
            }

            // For mixed modality study, if one of the series is multiframe and while changing the series level layout by selecting other modality series, moving to the last image for the previous multiframe series
            if(seriesLayout.getSeriesIndex() > imageAndSeriesIndex) {
                //Checking if the previous series is multiframe or not
                var newImage = dicomViewer.Series.Image.getImage(seriesLayout.studyUid, imageAndSeriesIndex, 0);
                var isImageThumbnail = dicomViewer.thumbnail.isImageThumbnail(newImage);
                if(isImageThumbnail) {
                    //Moving to the last image for the multiframe series
                    multiFrameImageIndex = dicomViewer.Series.getSeries(seriesLayout.studyUid, imageAndSeriesIndex).imageCount - 1;
                    if(totalSeriesLevelLayout > 3) {
                        if(multiFrameImageIndex >= totalSeriesLevelLayout-1) {
                            multiFrameImageIndex++;
                            multiFrameImageIndex = multiFrameImageIndex - (totalSeriesLevelLayout-1);
                        }
                    }
                }
            }
            
            // Set the rearranged series positions
            dicomViewer.setReArrangedSeriesPositions (
            {
                multiFrameImageIndex : multiFrameImageIndex,
                actualSeriesIndex : actualSeriesIndex,
                selectThumbnailImageIndex : selectThumbnailImageIndex,
                isViewPortDoubleClicked : isDoubleClick
            });

            return (isMultiframe ? seriesIndex : imageAndSeriesIndex);
        }
        catch(e)
        { }

        return undefined;
    }
    
    /**
     * To Change the text of context menu item of study cache indicator
     *  
     */ 
    function cacheIndicator() {
        resetMenu();
        showStudyCacheIndicator = !showStudyCacheIndicator;
        showCacheIndicator();
        
        if(showStudyCacheIndicator) {
            $(".cacheindicator").text("Hide Cache Indicator");
        } else {
            $(".cacheindicator").text("Show Cache Indicator");
        }
    }

    /**
     * Need to check calibration values is present in the current image
     *  
     */ 
    function isCaliberEnabled(render){
        var studyUid;
        var seriesIndex;
        var imageIndex;
        var frameIndex;
        var imageUid;
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        if(render && seriesLayout) {
            studyUid = seriesLayout.getStudyUid();
            seriesIndex = render.seriesIndex
            imageIndex = render.imageIndex
            frameIndex = (render.anUIDs).split("*")[1];
            imageUid = render.imageUid;
        } else if(seriesLayout) {
            studyUid = seriesLayout.getStudyUid();
            seriesIndex = seriesLayout.seriesIndex
            imageIndex = seriesLayout.getImageIndex()
            frameIndex = seriesLayout.scrollData.frameIndex
            var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
            imageUid = dicomViewer.Series.Image.getImageUid(image);
        }

        if(studyUid != undefined && imageUid != undefined) {
            var calibratedValues = getUnitMeasurementMap(studyUid+"|"+seriesIndex+"|"+imageIndex+"|"+frameIndex);
            var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
            if(dicomHeader.imageInfo.measurement ){
                if(dicomHeader.imageInfo.measurement.pixelSpacing != null && dicomHeader.imageInfo.measurement.pixelSpacing != undefined){
                    if(dicomHeader.imageInfo.measurement.pixelSpacing.row <= 0 && calibratedValues == null){
                        return true;
                    }
                }
            } else if((calibratedValues == null) && (dicomHeader.imageInfo == undefined ||dicomHeader.imageInfo.measurement == undefined || 
                      dicomHeader.imageInfo.measurement == null)) {
                return true;
            }
        }
        return false;
    }

    /**
     * To set the calibration tool as activeTool
     *  
     */ 
    function setCalibrationActiveTool(){
        resetMenu();
        $("#context-length-calibration").css("background","#868696");
        $("#6_measurement").css("background","#868696");
        flagFor2dLengthCalibration = true;
        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.get2DLengthCalibrationTool());
    }

    /**
     * To get the length calibration flag
     *  
     */ 
    function getLengthCalibrationFlag(){
        return isLengthCalibrating;
    }

    /**
     * To set the length calibration flag
     *  
     */ 
    function setLengthCalibrationFlag(flag){
        isLengthCalibrating = flag;
    }
    
    function doDefault()
	{
        resetMenu();
        $('#viewport_View').css('cursor', 'default');
        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();

        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getDefaultTool());
        isCopyAttribute = false;
        // refresh image so that US regions appear
        refreshImage();
    }

    /**
     * To set the context menu and too bar measurement item selection
     *  
     */ 
    function SetMenuSelectionColor(toolName){
        var cursorObj = document.getElementById('viewport_View');
        var cursorName;
        if(cursorObj != undefined && cursorObj != null){
            cursorName = cursorObj.style.cursor;
        }
        if(toolName == "lineMeasurement"){
            if(cursorName.indexOf("images/calibrate.cur") >0){
                $("#context-length-calibration").css("background","#868696");
                $("#6_measurement").css("background","#868696");
            } else if(cursorName && cursorName.split("/")[1].split(".")[0] == "annotatearrow") {
                $("#context-arrow").css("background","#868696");
                $("#10_arrow").css("background","#868696");
            } else if(cursorName && cursorName.split("/")[1].split(".")[0] == "annotateline") {
                $("#context-line").css("background","#868696");
                $("#9_line").css("background","#868696");
            }else {
                $("#context-length").css("background","#868696");
                $("#0_measurement").css("background","#868696");
            }
        } else if(toolName == "pointMeasurement"){
            $("#context-2dPoint").css("background","#868696");
            $("#1_measurement").css("background","#868696");
        } else if(toolName == "traceMeasurement" || toolName == "mitralMeanGradientMeasurement"){
            if(cursorName && cursorName.split("/")[1].split(".")[0] == "annotatefreehand") {
                $("#context-freehand").css("background","#868696");
                $("#13_freehand").css("background","#868696");
            } else {
                $("#context-trace").css("background","#868696");
                $("#2_measurement").css("background","#868696");
            }
        } else if(toolName == "volumeMeasurement"){
            $("#context-volume").css("background","#868696");
            $("#3_measurement").css("background","#868696");
        } else if(toolName == "angleMeasurement"){
            $("#context-angle").css("background","#868696");
            $("#angle_measurement").css("background","#868696");
        } else if(toolName == "ellipseMeasurement") {
            if( cursorName && cursorName.split("/")[1].split(".")[0] == "annotateellipse") {
                $("#context-ellipse").css("background","#868696");
                $("#11_ellipse").css("background","#868696");
            } else {
                $("#context-hounsfield-ellipse").css("background","#868696");
                $("#7_measurement").css("background","#868696");
            }
        } else if(toolName == "rectangleMeasurement"){
            if( cursorName && cursorName.split("/")[1].split(".")[0] == "annotaterectangle") {
                $("#context-rectangle").css("background","#868696");
                $("#12_rectangle").css("background","#868696");
            } else if(cursorName && cursorName.split("/")[1].split(".")[0] == "annotatetext") {
                $("#context-text").css("background","#868696");
                $("#8_text").css("background","#868696");
            } else {
                $("#context-hounsfield-rectangle").css("background","#868696");
                $("#14_measurement").css("background","#868696");
            }
        }
    }

     /**
     * To set the auto window level
     *  
     */
    function doWindowLevelROI(e){
        isCopyAttribute = false;
        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();
        $('#viewport_View').css('cursor','url(images/AutoWindowLevel.cur), auto');
        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getWindowToolROI());

        // refresh image so that US regions appear
        refreshImage();
    }

    /**
     * 
     * Print
     */ 
    function doPrint(printOption) {
        doPrintOrExport(printOption, isSignatureEnabled(), false);
    }

    /**
     * Print
     * @param {Type} seriesLayout - Specifies the series layout
     * @param {Type} imageRender - Specifies the image renderer
     * @param {Type} isExport - Specifies theflag to export
     */ 
    function printOrExport(printOption, isExport) {
        try
        {
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            if(seriesLayout === undefined || seriesLayout === null) {
                return;
            }

            var isEcg = seriesLayout.imageType === IMAGETYPE_RADECG ? true : false;
            var imageRender = isEcg ? seriesLayout.getImageRender("ecgData") : 
            seriesLayout.getImageRender(getClickedViewportId()) ;

            var series = dicomViewer.Series.getSeries(seriesLayout.studyUid, seriesLayout.seriesIndex);
            if(series === null || series === undefined) {
                return;
            }

            var description = series.description;
            if(description === undefined || description === null) {
                description = "";
            }

            var imageDataUrl = undefined;
            var isHtml = false;
            var fontSize = 12.75;
            if(imageRender) {
                imageDataUrl = isEcg ? imageRender.PrepareECGPrint(printOption) : imageRender.preparePrint(printOption);
            } else {
                if($("#" + seriesLayout.seriesLayoutId)[0].isHtml) {
                    var htmlId = $("#" + seriesLayout.seriesLayoutId)[0].HtmlId;
                    imageDataUrl = document.getElementById(htmlId).innerHTML;
                    isHtml = true;
                    if(printOption == 1) {
                        fontSize = parseFloat($("#" + htmlId).css("font-size"));
                    }
                }
            }

            if(!imageDataUrl) {
                console.error("Failed to print the image or report.\nPrint content is empty.");
                return;
            }

            var printContent = '<!DOCTYPE html>';
            printContent += '<head><title>';
            printContent += description;
            printContent += '</title></head>';
            printContent += '<body>';
            if(isHtml) {
                if(isExport) {
                    exportHtml($("#" + seriesLayout.seriesLayoutId), printContent);
                    return;
                }

                printContent += "<div style=font-size:"+fontSize+"px>" + imageDataUrl + "</div>";
            } else if(isEcg) {
                var ecgDivId = document.getElementById("ecgDataDiv_" + seriesLayout.seriesLayoutId);
                if(isExport) {
                    exportEcg(ecgDivId, printContent, imageDataUrl, imageRender, printOption);
                    return;
                }

                if(printOption == 1) {
                    fontSize = fontSize * parseFloat(imageRender.tempEcgScale);
                }

                printContent += "<div style=font-size:" + fontSize + "px>" + ecgDivId.innerHTML + "</div>";
                printContent += '<img src="' + imageDataUrl + '">';
            } else {
                printContent += '<img src="' + imageDataUrl + '">';
            }

            printContent += '</body>';
            printContent += '</html>';

            var printDialog = window.open('','Print','');
            printDialog.document.open();
            printDialog.document.write(printContent);
            printDialog.document.close();

            if(isExport) {
                return;
            }

            window.setTimeout(function () {
                printDialog.focus();
                printDialog.print();
                printDialog.close();
            }, 200);
        }
        catch(e)
        { }
    }

    /**
     * To Change the text of context menu item for link tool
     *
     */
    function linkSeries() {
        resetMenu();

        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();

        dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getLinkTool());
        if (dicomViewer.link.isSeriesLinked()) {
            var img = document.getElementById('linkButton').children[0];
            img.src = 'images/link.png';
            updateToolTip($("#linkButton"), "Link");
            dicomViewer.link.unLinkSeries();
            $('#viewport_View').css('cursor', 'default');
        } else {
            $('#viewport_View').css('cursor','url(images/link.cur), auto');
            dicomViewer.link.linkSeries();
        }

        // refresh image so that US regions appear
        refreshImage();
    }

    function doXRefLineSelection() {
        try
        {
            dicomViewer.measurement.setDataToDelete();
            var tool = dicomViewer.mouseTools.getActiveTool();
            tool.hanleDoubleClick();

            dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getXRefLineSelectionTool());
            refreshImage();
        }
        catch(e)
        { }
    }

    /**
     *Display the copy attribute window 
     */ 
    function showCopyAttributesPreference() {
        copyAttributes = dicomViewer.configuration.cine.getCopyAttributes();
        document.getElementById("copyAttributes_WindowLevel").checked = copyAttributes.windowLevel;
        //document.getElementById("copyAttributes_Pan").checked = copyAttributes.pan;
        document.getElementById("copyAttributes_Scale").checked = copyAttributes.scale;
        document.getElementById("copyAttributes_Invert").checked = copyAttributes.invert;
        document.getElementById("copyAttributes_Orientation").checked = copyAttributes.orientation;
        $("#copyAttributesPreference").dialog('open');
        document.getElementById("copyAttributesPreference").style.height = "auto";
    }

    /**
     *Copy the presenation property 
     */ 
    function doCopyAttributes() {
        dicomViewer.measurement.setDataToDelete();
        var tool = dicomViewer.mouseTools.getActiveTool();
        tool.hanleDoubleClick();
        var activeSeries =  dicomViewer.getActiveSeriesLayout();

        if(activeSeries == undefined || activeSeries == null) {
            return;
        }

        var imageLayoutId =undefined;
        $("#" + activeSeries.getSeriesLayoutId() + " div").each(function(){
            imageLayoutId = $(this).attr('id');
        });

        if(imageLayoutId == undefined || imageLayoutId == null) {
            return;
        }

        if(activeSeries.imageLayoutDimension !== "1x1") {
            imageLayoutId = activeSeries.seriesLayoutId + "ImageLevel0x0";
        }

        copyAttributePresentaion = activeSeries.getImageRender(imageLayoutId);
        isCopyAttribute  = true;
        copyAttributeLayoutId = activeSeries.getSeriesLayoutId() + "-" + activeSeries.studyUid ;
        $('#viewport_View').css('cursor','url(images/copyAttribute.cur), auto'  );
    }

    /**
     * Show/Hide the annotations/measurements
     */ 
    function doShowHideAnnotationAndMeasurement() {
        try
        {
            annotationAndMeasurementVisibleStatus = !annotationAndMeasurementVisibleStatus
            annotationAndMeasurementVisibleStatus ? $("#4_measurement").show() : $("#4_measurement").hide() ;
            var menuInnerText = annotationAndMeasurementVisibleStatus ? "Hide Annotation / Measurement" : "Show Annotation / Measurement" ;
            document.getElementById("showHideAnnotaionAndMesurement").innerText = menuInnerText;
            document.getElementById("showHideAnnotaionAndMesurement_overflow").innerText = menuInnerText;
            var allViewports = dicomViewer.viewports.getAllViewports();

            for (var key in allViewports) {
                var viewportTemp = allViewports[key];
                $("#" + viewportTemp.getSeriesLayoutId() + " div").each(function() {
                    var imageLayoutId = $(this).attr('id');
                    var imageRender = viewportTemp.getImageRender(imageLayoutId);
                    if(imageRender) {
                        imageRender.drawDicomImage();
                    }
                });
            }
        }
        catch(e)
        { }
    }

    /**
     * set the show/hide measurement and annotation flag 
     */ 
    function isShowAnnotationandMeasurement(){
        return annotationAndMeasurementVisibleStatus;
    }

    /**
     * Save the measurement preferences
     * @param {Type} selectedElement - Specifies the element
     */ 
    function saveMeasurementPreference(mesurementStyle) {
        try
        {
            var style =
            {
                lineWidth : mesurementStyle.lineWidth,
                lineColor : mesurementStyle.lineColor,
                textColor : mesurementStyle.textColor,
                fontName : mesurementStyle.fontName,
                fontSize : mesurementStyle.fontSize,
                isBold : mesurementStyle.isBold,
                isItalic : mesurementStyle.isItalic,
            };

            $.ajax({
                type: 'POST',
                url: dicomViewer.getMeasurementPrefUrl(),
                data: JSON.stringify([style]),
                beforeSend: function(xhr) {
                    xhr.overrideMimeType("text/plain; charset=x-user-defined");
                }
            })
            .success(function(data) {
            })
            .fail(function(data) {
            })
            .error(function(xhr, status) {
                var description = xhr.statusText + "\nFailed to save the measurement preferences to server";
                sendViewerStatusMessage(xhr.status.toString(), description);
            });
        }
        catch(e)
        { }
    }

    /**
     * Get the 6000 overlay visibility flag
     */ 
    function is6000OverlayVisible() {
        return is6000Overlay; 
    }

    /**
     * Show/Hide the 6000 overlay
     */ 
    function doOverLay6000() {
        is6000Overlay = !is6000Overlay;
        var menuInnerText = (is6000Overlay ? "Hide" : "Show") + " Overlay 6000";
        document.getElementById("showHideOverlay6000").innerText = menuInnerText;
        document.getElementById("showHideOverlay6000_overflow").innerText = menuInnerText;   
        var allViewports = dicomViewer.viewports.getAllViewports();
        for (var key in allViewports) {
            var viewportTemp = allViewports[key];
            $("#" + viewportTemp.getSeriesLayoutId() + " div").each(function() {
                var imageLayoutId = $(this).attr('id');
                var imageRender = viewportTemp.getImageRender(imageLayoutId);
                if(imageRender) {
                    imageRender.renderImage(false);
                }
            });
        }
    }

    /**
     * Export the image or report
     * @param {Type} exportOption - Specifies the export option 
     */ 
    function doExport(exportOption) {
        doPrintOrExport(exportOption, isSignatureEnabled(), true);
    }

    /**
     * Do Print or Export image/Report 
     * @param {Type} option - Specifies the option
     * @param {Type} isVerified - Specifies the flag to verified
     * @param {Type} isExport - Specifies the flag to export
     */ 
    function doPrintOrExport(option, isVerified, isExport, printReason) {
        try
        {
            if(isVerified) {
                $("#printImageWindow").data("Option", option);
                $("#printImageWindow").data("IsExport", isExport);
                $('#printImageWindow').dialog('option', 'title', (isExport ? "Export" : "Print"));
                $("#printImageWindow").dialog("open");
            } else if(printReason){
                doVerifyAndExport(printReason, option, isExport);
            } else {
                printOrExport(option, isExport);
            }
        }
        catch(e)
        { }
    }

    /**
     * 
     * @param {Type} reason - Specifies the export reason
     * @param {Type} option - Spectifies the export option
     * @param {Type} isExport - Specify the flag to export
     */ 
    function doVerifyAndExport(reason, option, isExport) {
        try
        {
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            if(seriesLayout === undefined || seriesLayout === null) {
                return;
            }

            var seriesIndex = undefined;
            var imageIndex = undefined;
            if($("#" + seriesLayout.seriesLayoutId)[0].isHtml) {
                seriesIndex = seriesLayout.seriesIndex;
                imageIndex = 0;
            } else {
                var imageRender = seriesLayout.imageType === IMAGETYPE_RADECG ? seriesLayout.getImageRender("ecgData") : 
                seriesLayout.getImageRender(getClickedViewportId());
                if(imageRender === undefined || imageRender === null) {
                    return;
                }

                seriesIndex = imageRender.seriesIndex;
                imageIndex = imageRender.imageIndex;
            }

            var imageUrn = dicomViewer.Series.Image.getImageUrn(seriesLayout.studyUid, seriesIndex, imageIndex);
            if(!imageUrn) {
                console.error("Failed to get the image Urn");
                return;
            }

            dicomViewer.measurement.showAndHideSplashWindow("show", "Verifying print image access...","dicomViewer");
            $.ajax
            (
                {
                    type: 'GET',
                    url: dicomViewer.getLogExportUrl(),
                    data: {reason: reason, imageUrn: imageUrn}
                }
            )
            .success(function(data) {
                printOrExport(option, isExport);
            })
            .fail(function(data, textStatus, errorThrown) {
                dicomViewer.measurement.showAndHideSplashWindow("error", "Failed to verify the print image access");
            })
            .error(function(data, status) {
                dicomViewer.measurement.showAndHideSplashWindow("error", "Failed to verify the print image access");
            });
        }
        catch(e) {
            dicomViewer.measurement.showAndHideSplashWindow("error", "Failed to verify the print image access");
        }
    }

    /**
     * Export the Html elemtents using html to canvas method
     * @param {Type} divId - specifies the div id
     * @param {Type} printContent - specifies the print content
     */ 
    function exportHtml(divId, printContent) {
        try
        {
            html2canvas(divId, {
                onrendered: function(canvas) {
                    printContent += '<img src="' + canvas.toDataURL('image/jpeg', 1.0) + '">';
                    printContent += '</body>';
                    printContent += '</html>';
                    var printDialog = window.open('','Print','');
                    printDialog.document.open();
                    printDialog.document.write(printContent);
                    printDialog.document.close();
                }
            });
        }
        catch(e)
        { }
    }

    /**
     * Export the Ecg image using html to canvas method
     * @param {Type} ecgDivId - specifies the ecg div id
     * @param {Type} printContent - specifies the print content
     * @param {Type} imageDataUrl - specifies the image data Url
     * @param {Type} imageRender - specifies the image render object
     * @param {Type} printOption - specifies the print option
     */ 
    function exportEcg(ecgDivId, printContent, imageDataUrl, imageRender, printOption) {
        try
        {
            html2canvas(ecgDivId, {
                onrendered: function(canvas) {
                    var printCanvas = document.createElement("canvas");
                    var ecgDataId = $("#imageEcgCanvas" + imageRender.seriesLevelDivId);
                    var scaleValue = 1;
                    if(printOption == 1) {
                        scaleValue = parseFloat(imageRender.tempEcgScale);
                    }

                    var ecgDataWidth = imageRender.ecgData.width * scaleValue;
                    var ecgDataHeight = imageRender.ecgData.height * scaleValue;
                    printCanvas.width = ecgDivId.clientWidth  > ecgDataWidth ? ecgDivId.clientWidth : ecgDataWidth;
                    printCanvas.height = ecgDivId.clientHeight + ecgDataHeight;
                    var printContext = printCanvas.getContext('2d');
                    printContext.clearRect(0,0,printCanvas.width,printCanvas.height);
                    printContext.fillStyle = 'white';
                    printContext.fillRect(0, 0, printCanvas.width, printCanvas.height);
                    printContext.save();
                    var ecgDivObj = new Image();
                    var ecgDataObj = new Image();
                    ecgDivObj.src = canvas.toDataURL('image/jpeg', 1.0);
                    ecgDivObj.onload = function() {
                        printContext.drawImage(ecgDivObj, 0, 0);
                        ecgDataObj.src = imageDataUrl;
                        ecgDataObj.onload = function() {
                            printContext.drawImage(ecgDataObj, 0, ecgDivId.clientHeight);
                            printContext.restore();
                            printContent += '<img src="' + printCanvas.toDataURL('image/jpeg', 1.0) + '">';
                            printContent += '</body>';
                            printContent += '</html>';
                            var printDialog = window.open('','Print','');
                            printDialog.document.open();
                            printDialog.document.write(printContent);
                            printDialog.document.close();
                        }
                    };
                }
            });
        }
        catch(e)
        { }
    }

    /**
     * check the whether the calibration tool is enable or not.
     */ 
    function getCursorType() {
        try
        {
            var cursorObj = document.getElementById('viewport_View');
            var cursorName;
            if(cursorObj != undefined && cursorObj != null){
                cursorName = cursorObj.style.cursor;
            }

            if(cursorName != null && cursorName != undefined) {
                cursorName = ((cursorName = cursorName.split("/")[1]) == undefined) ? undefined : cursorName.split(".")[0];
            }

            return cursorName;
        }
        catch(e)
        { }
    }

	dicomViewer.tools = {
            firstTimeImageLoad : firstTimeImageLoad,
			doZoom : doZoom,
			doPan : doPan,
			do2DLengthMeasurement: do2DLengthMeasurement,
			do2DPointMeasurement: do2DPointMeasurement,
            doAngleMeasurement: doAngleMeasurement,
			do2DMeasurement: do2DMeasurement,
			doWindowLevel : doWindowLevel,
			rgbColor : rgbColor,
			setDicomOverLayFalse : setDicomOverLayFalse,
			showDicomHeader : showDicomHeader,
            showImageData : showImageData,
			changeImageLayout : changeImageLayout,
			changeSeriesLayout : changeSeriesLayout,
			changeStudyLayout : changeStudyLayout,
			doOverLay : doOverLay,
            doScoutLine : doScoutLine,
			revert : revert,
			rotate : rotate,
			invert : invert,
            doHorizontalFilp : doHorizontalFilp,
            doVerticalFilp : doVerticalFilp,
			changePreset : changePreset,
			moveToPreviousImage : moveToPreviousImage,
			moveToNextImage : moveToNextImage,
            runCineImage : runCineImage,
            stopCineImage : stopCineImage,
            moveSeries : moveSeries,
            setZoomLevel : setZoomLevel,
            updateWindowLevelSettings : updateWindowLevelSettings,
            ecgPreference : ecgPreference,
            cinePreference : cinePreference,
            isOverlayVisible : isOverlayVisible,
            isScoutLineVisible : isScoutLineVisible,
            setOverlay : setOverlay,
			menuSelection : menuSelection,
			chanageWhileDrag : chanageWhileDrag,
			changeStudyLayoutFromTool: changeStudyLayoutFromTool,
			updateZoomLevelSettings: updateZoomLevelSettings,
			getFlagFor2dLengthCalibration : getFlagFor2dLengthCalibration,
			lengthCalibration : lengthCalibration,
            showHangingProtocol : showHangingProtocol,
            addHangingProtocol : addHangingProtocol,
            deleteHP : deleteHP,
            editHP : editHP,
            saveSettings : saveSettings,
            enableHPControls : enableHPControls,
            setSelectedStudyLayout : setSelectedStudyLayout,
            reOrderExistingStudyUids: reOrderExistingStudyUids,
            getOrSetReArrangedSeriesPositions : getOrSetReArrangedSeriesPositions,
            applyWindowLevel : applyWindowLevel,
            cacheIndicator : cacheIndicator,
            rgbColor : rgbColor,
            resetRGBMenu : resetRGBMenu,
            isCaliberEnabled : isCaliberEnabled,
            setCalibrationActiveTool : setCalibrationActiveTool,
            getLengthCalibrationFlag : getLengthCalibrationFlag,
            setLengthCalibrationFlag : setLengthCalibrationFlag,
            doDefault : doDefault,
            SetMenuSelectionColor : SetMenuSelectionColor,
            doWindowLevelROI : doWindowLevelROI,
            doPrint : doPrint,
            linkSeries: linkSeries,
            doXRefLineSelection : doXRefLineSelection,
            showCopyAttributesPreference: showCopyAttributesPreference,
            doCopyAttributes: doCopyAttributes,
            doShowHideAnnotationAndMeasurement : doShowHideAnnotationAndMeasurement,
            isShowAnnotationandMeasurement : isShowAnnotationandMeasurement,
            saveMeasurementPreference : saveMeasurementPreference,
            doOverLay6000 : doOverLay6000,
            is6000OverlayVisible : is6000OverlayVisible,
            doPrintOrExport : doPrintOrExport,
            doExport : doExport,
            doSharpen : doSharpen,
            getCursorType : getCursorType
	};
	
	return dicomViewer;
	
}(dicomViewer));var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }
    
    //var baseURL = "http://rav-pentap-lt:9000/api/v1/";
    
    function getStudyDetailURL( urlParameters )
    {
    	if(urlParameters == undefined)
    	{
    		throw "Study URL: URL Parameters are empty/null";
    	}    	
    	return baseURL+"studies?"+$.param(urlParameters);    	
    }
    
    function getOverlayTextURL()
    {
    	return baseURL+"config?Parameter=TextOverlay";
    }
    
    function getMeasurementsURL() {
        return baseURL + "config?Parameter=measurements";
    }

    function getViewerVersionURL() {
        return baseViewerURL + "version";
    }

    function getDicomImageURL(urlParameters)
    {
    	if(urlParameters == undefined)
    	{
    		throw "Dicom Image URL: URL Parameters are empty/null";
    	}
    	return baseURL+"images?"+$.param(urlParameters);
    }
    
	function getDicomImageMetadataURL(urlParameters)
    {
    	if(urlParameters == undefined)
    	{
    		throw "Dicom Image URL: URL Parameters are empty/null";
    	}
    	return baseViewerURL+"metadata?"+$.param(urlParameters);
    }
	
    function getReferenceLineURL(urlParameters)
    {
    	if(urlParameters == undefined)
    	{
    		throw "Dicom Image URL: URL Parameters are empty/null";
    	}
    	return baseURL+"xreflines?"+$.param(urlParameters);
    }
    
    function getReleaseHistoryUrl()
    {    	
    	return baseViewerURL+"releasehistory";
    }
	
    function getMessageHistoryUrl()
    {    	
		return baseViewerURL+"events";
    }

    /**
     * Get the Remove Context Url
     * @param {Type} sessionId - Spectify the session id
     */ 
    function getRemoveContextUrl(sessionId)
    {
        var baseUrl = baseURL.split("/v");
        var url = baseUrl[0]+"/vix/session/"+sessionId+"/context";
        return url;
    }

    /**
     * PState Url (Presentation State)
     */ 
    function getPStateUrl(contextId) {
        var n = dicomViewer.getWindowLocationUrl().indexOf("&");
        var url = baseURL+"context/pstate?"+ "ContextId="+decodeURIComponent(contextId)+dicomViewer.getWindowLocationUrl().substring(n);
        return url;
    }

    /**
     * Get the 6000 overlay url
     * @param {Type} imageUid - Specifies the image uid
     * @param {Type} frameNumber - Specifies the image number
     * @param {Type} overlayIndex - Specifies the overlay index
     */ 
    function get6000overlayUrl(imageUid, frameNumber, overlayIndex) {
        var urlParameters =
        {
            Format : "Overlay",
            ImageUid : imageUid,
            FrameNumber : frameNumber,
            Transform : "Dicom",
            SecurityToken : dicomViewer.security.getSecurityToken(),
        };

        return baseURL+"images?"+$.param(urlParameters);
    }

    dicomViewer.url = {
    		getStudyDetailURL : getStudyDetailURL,
    		getOverlayTextURL: getOverlayTextURL,
    		getMeasurementsURL: getMeasurementsURL,
    		getDicomImageURL : getDicomImageURL,
    		getReferenceLineURL: getReferenceLineURL,
    		getViewerVersionURL: getViewerVersionURL,
            getReleaseHistoryUrl : getReleaseHistoryUrl,
			getMessageHistoryUrl : getMessageHistoryUrl,
			getDicomImageMetadataURL : getDicomImageMetadataURL,
            getRemoveContextUrl : getRemoveContextUrl,
            getPStateUrl : getPStateUrl,
            get6000overlayUrl : get6000overlayUrl
    };
    
    return dicomViewer;
}(dicomViewer));/**
 * New node file
 */

var dicomViewer = (function (dicomViewer) {

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var CINERUN = 0;
    var CINEPAUSE = 1;    
    var imageIndexNumber = 0;
	
    var studyLevelMap = [];

    var cineManager = {}; // Manage the cine opterations
	
    var previousStudyLayout = "";
    
    var previousSaveAndLoadToolLayout = "";

    var currentLayOutId = "";
    
    var fullScreenCineManager = {};
    var resizeCineManager = {};
    var repeatCineManager = {};
	
    var seriesLayoutMap = new Map();
    var columnSize = 1;

    var viewportHeaderWidth;

/*	var layoutFormate={"1x2":"1x1,1x2","2x1":"1x1,2x1","2x2":"1x1,1x2,2x1,2x2",
					   "cxs":"1x1,1x2,1x3,2x1,2x2,2x3,3x1,3x2,3x3"};*/

    var preferenceList = [ "gridtype", "gridcolor", "leadformat", "gain", "signalthickness"];

    //contain viewport div id as key and imageCanvas as value 
    var imageCanvasOfViewPorts = {};    
    var imageCanvasOfBackupViewPorts = {};    
    var allViewportsTemp = undefined;    
    var activeSeriesLayoutTemp = undefined;
    var currentSeriesLayoutIds = undefined;

    var viewHeight = 0;
    var activeSeriesLayout = null; //For mouse tools like ww/wc , pan and zoom

    var playStudy = false; // if it is true play whole study in cine, if false play single image set in cine
    var tempHeight = 0;
    var multiFrameImageIndex = 0;
    var selectThumbnailImageIndex = undefined;
    var actualSeriesIndex = 0;
    var isViewPortDoubleClicked = false;
    var previousImageUid = undefined;
    
    function createViewport(row, column,studyLayoutId,studyUid) {
        var imageLayoutMenu = null;
        var viewportString = '<table id=table'+studyLayoutId+' style="width:100%;height:100%;">';
        for (var i = 0; i < row; i++) {
            viewportString += '<tr style="height:' + (100 / row) + '%;">';
            var clear = "clear:both;";
            for (var int2 = 0; int2 < column; int2++) {
                viewportString += '<td style="width:' + (100 / column)+ '%;height:' + (100 / row)+ '%;padding-left:5px;">';
                viewportString += '<div id="imageviewer_'+studyLayoutId + "_"  + (i + 1) + 'x' + (int2 + 1) + '"style="width:100%;height:100%;float:left;background-color:black;' + clear + '"  class="disableSelection" tabindex="0">';
                clear = "";
                viewportString += '</td>';
            }
            viewportString += '</tr>';
        }
        viewportString += '</table>';
        if(studyLayoutId != undefined)
        {
            var studyLayoutElement = $("#"+studyLayoutId);
            studyLayoutElement.empty();
            var studyInformationdiv = "studyInfo"+studyLayoutId;
            var studyUidAndDateTime = "studyUidDateTime"+studyLayoutId;
            var seriesLayoutMenu = "menuSL"+studyLayoutId;
            var imageLayoutMenu = "menuIL"+studyLayoutId;
            var saveAnnotationsButton = "saveButton_"+studyLayoutId;
            var saveAnnotationsMenu = "saveMenuSL"+studyLayoutId;
            var loadAnnotationsButton = "loadButton_"+studyLayoutId;
            var loadAnnotationsMenu = "loadMenuIL"+studyLayoutId;
            var imageLayoutDisplayId = "imageDisplay"+studyLayoutId;
            var seriesLayoutDisplayId = "seriesDisplay"+studyLayoutId;
            var tableWidth = $("#viewportTable").width();
            viewportHeaderWidth = (tableWidth/columnSize )- 215;
            var imageLevelSelectionId = "imageLevelSelection_"+studyLayoutId;
            var seriesLevelSelectionId = "seriesLevelSelection_"+studyLayoutId;
            var tableid = "table_"+studyLayoutId;
            var viewportToolbarId = "saveAndLoad_"+studyLayoutId;
            var saveId = "save_"+studyLayoutId;
            var editAndSaveId = "editAndSave_"+studyLayoutId;
            if(viewportHeaderWidth<10) {
                viewportHeaderWidth =10;
            }

            var studyInformation = "<table id=table"+studyInformationdiv+" style='width:99%;cursor: default;/*background:rgba(152, 153, 158, 0.59);*/'>"
                                    +"<tr>"
                                    +"<td id="+tableid+" style ='width:"+viewportHeaderWidth+"px'>"
                                        +"<div id="+studyInformationdiv+" style='color: white;padding-left: 5px;width: "+viewportHeaderWidth+"px;white-space: nowrap;overflow: hidden;text-overflow: ellipsis'></div>"
                                        +"<div id="+studyUidAndDateTime+" style='color: white;padding-left: 5px;font-size:10px;width: "+viewportHeaderWidth+"px;white-space: nowrap;overflow: hidden;text-overflow: ellipsis'></div>"
                                    +"</td>"
                                        +"<td id="+viewportToolbarId+" align='left' style='display:none;background: transparent;width: 65px;height:32px'></td>"
                                    +"<td align='right' style='width: 62px;'>"
                                        +"<div id="+imageLayoutDisplayId+" style='display:none;'>"
                                            +"<ul id="+imageLayoutMenu+" style='width: 60px;background: transparent; border-color: transparent;'>"
                                                +"<li >"
                                                    +'<img src="images/imageLevel.png" id='+imageLevelSelectionId+'>'
                                                            +"<ul>"
                                                            +"<li onclick='dicomViewer.tools.changeImageLayout(1,1,"+studyLayoutId+")'><img src='images/1x1.png'></li>"
                                                            +"<li onclick='dicomViewer.tools.changeImageLayout(1,2,"+studyLayoutId+")'><img src='images/1x2.png'></li>"
                                                            +"<li onclick='dicomViewer.tools.changeImageLayout(2,1,"+studyLayoutId+")'><img src='images/2x1.png'></li>"
                                                            +"<li onclick='dicomViewer.tools.changeImageLayout(2,2,"+studyLayoutId+")'><img src='images/2x2.png'></li>"
                                                        +"</ul>"
                                                +"</li>"												
                                            +"</ul>"
                                        +"</div>"
                                    +"</td>"
                                    +"<td align='right' style='width: 62px;'>"
                                        +"<div id="+seriesLayoutDisplayId+" style='display:none;'>"
                                            +"<ul id='"+seriesLayoutMenu+"'style='width: 60px;background: transparent; border-color: transparent;'>"
                                                +"<li>"
                                                    +"<img src='images/2x2.png' id="+seriesLevelSelectionId+">"
                                                        +"<ul>"
            +"<li id = '"+seriesLayoutDisplayId+"_1x1' onclick='dicomViewer.tools.changeSeriesLayout(1,1,"+studyLayoutId+")'><img src='images/1x1.png'></li>"
            +"<li id = '"+seriesLayoutDisplayId+"_1x2' onclick='dicomViewer.tools.changeSeriesLayout(1,2,"+studyLayoutId+")'><img src='images/1x2.png'></li>"
            +"<li id = '"+seriesLayoutDisplayId+"_2x1' onclick='dicomViewer.tools.changeSeriesLayout(2,1,"+studyLayoutId+")'><img src='images/2x1.png'></li>"
            +"<li id = '"+seriesLayoutDisplayId+"_2x2' onclick='dicomViewer.tools.changeSeriesLayout(2,2,"+studyLayoutId+")'><img src='images/2x2.png'></li>"
            +"<li id = '"+seriesLayoutDisplayId+"_custom' onclick='changeCustom("+studyLayoutId+")'>Custom</li>"
                                                        +"</ul>"
                                                +"</li>"
                                            +"</ul>"
                                        +"</div>"
                                    +"</td>"


                                    /*+"<td align='right'>"
                                        +"<select style ='background: rgba(152, 153, 158, 0.59);border-color: rgba(152, 153, 158, 0.59);color: white;' onchange=changeImageLayout(this.value)>"
                                        +"<option value='1x1'>Image Level 1x1</option>"
                                        +"<option value='1x2'>Image Level 1x2</option>"
                                        +"<option value='2x1'>Image Level 2x1</option>"
                                        +"<option value='2x2'>Image Level 2x2</option>"
                                        +"</select>"
                                        +"&nbsp"									
                                        +"<select id='serieslv"+studyLayoutId+"' style ='background: rgba(152, 153, 158, 0.59);border-color: rgba(152, 153, 158, 0.59);color: white;'; onchange=ChangeSeriesLayout(this)>"
                                        +"<option value='1x1'>Series Level 1x1</option>"
                                        +"<option value='1x2'>Series Level 1x2</option>"
                                        +"<option value='2x1'>Series Level 2x1</option>"
                                        +"<option value='2x2'>Series Level 2x2</option>"
                                        +"<option value='cxs'>Custom</option>"
                                        +"</select>"
                                    +"</td>"*/
                                    +"<td align='right' style='width: 12px;'>"
                                        +"<span id='"+studyLayoutId+"_close' title='close' style='padding-right: 5px;visibility:hidden' onclick=closeStudy('"+studyLayoutId+"')><img src='images/close.png' style='width: 12px;'></span>"
                                    +"</td>"
                                    +"</tr>"
                                    +"</table>"

            studyLayoutElement.append(studyInformation);
            if(studyUid !== undefined){
                document.getElementById(imageLayoutDisplayId).style.display='block';
                document.getElementById(seriesLayoutDisplayId).style.display='block';
                 document.getElementById(viewportToolbarId).style.display='block';
            } else if(studyUid == undefined){
                document.getElementById(viewportToolbarId).style.display='none';
            }
            /*if(dicomViewer.isDicomStudy(studyUid) === false){
                document.getElementById(imageLayoutDisplayId).style.display= 'none';
                document.getElementById(seriesLayoutDisplayId).style.display= 'none';
            }*/
            $("#"+seriesLayoutMenu).kendoMenu();
            $("#"+imageLayoutMenu).kendoMenu();
            studyUid == undefined ? "" : ((studyUid == null) ? "" : createSaveAndLoadPStateGUI(viewportToolbarId,studyUid,studyLayoutId));

            updateToolTip($("#"+imageLayoutMenu), "Image Level Layout", "top");
            updateToolTip($("#"+seriesLayoutMenu), "Series Level Layout", "top");
            $(".k-item").css("border-color", "transparent");
            studyLayoutElement.append(viewportString);
            var heightOfStudyInfo = $("#table"+studyInformationdiv).outerHeight();
            var heightOfStudyLayout = studyLayoutElement.height();
            if(studyLayoutId === "studyViewer1x1"){
                tempHeight = heightOfStudyLayout;
            }else
            {
                heightOfStudyLayout = tempHeight;
                studyLayoutElement.height(tempHeight);
            }

            var width = document.getElementById(imageLevelSelectionId).clientWidth;
            var width2 = document.getElementById(seriesLevelSelectionId).clientWidth;

            if(width && width2 ) {
               if(width2>30)
                    setIconSize(width2-6); 
                else
                    setIconSize(width2); 
            }
            changeIconSize(studyLayoutId);

            /*if(studyLayoutValue === "1x1"){
                heightOfStudyInfo = $("#table"+studyInformationdiv).height()+2;
            }*/
                viewHeight = (heightOfStudyLayout-heightOfStudyInfo);
             /*  if(studyLayoutId === "studyViewer2x1")
                viewHeight = (heightOfStudyLayout-heightOfStudyInfo)-2;
            if(studyLayoutId === "studyViewer2x2")
                viewHeight = (heightOfStudyLayout-heightOfStudyInfo)-2;*/

            var evenRow = studyLayoutElement.parent().closest('tr').css('border-top-width');
            if(evenRow !== "0px"){
                viewHeight = (heightOfStudyLayout-heightOfStudyInfo)-2;
            }

            $("#table"+studyLayoutId).height(viewHeight-3/*(heightOfStudyLayout-heightOfStudyInfo)-3*/);
        }else{
                $("#viewport_View").html(viewportString);
        }
        var tableWidth =  studyLayoutElement.width();
        $("#table"+studyLayoutId).width(tableWidth-5);
        $("#menuIL"+studyLayoutId).children().addClass("k-state-disabled");
    }
	
    function createStudyViewport(row, column) {
        columnSize = column;
        studyLevelMap = new Array();
        $("#viewport_View").empty();
        var viewportString = '<table id="viewportTable" style="width:100%;height:100%;">';
        for (var i = 0; i < row; i++) {
            viewportString += '<tr style="height:' + (100 / row) + '%">';
            var clear = "clear:both;";
            for (var int2 = 0; int2 < column; int2++) {
                viewportString += '<td style="width:' + (100 / column)+ '%;height:' + (100 / row)+ '%;">';
                studyLevelMap.push('studyViewer' + (i + 1) + 'x' + (int2 + 1));
                viewportString += '<div id="studyViewer' + (i + 1) + 'x' + (int2 + 1) + '"style="width:100%;height:100%;float:left;' + clear + '"  class="disableSelection" tabindex="0"></div>';
                clear = "";
                viewportString += '</td>';
            }
            viewportString += '</tr>';
        }
        viewportString += '</table>';
        $("#viewport_View").html(viewportString);
        var tableWidth = $("#viewportTable").width();
        $("#viewportTable").height($("#viewport_View").height());
        $("#viewportTable tr:nth-child(even)").css("border-top","2px solid black");
        $("#viewportTable td:nth-child(even)").css("border-left","2px solid black");
        $("#viewportTable tr:nth-child(odd)").css("border-top","2px solid black");
        $("#viewportTable td:nth-child(odd)").css("border-left","2px solid black");
    }

    function loadStudyInNextViewport(studyUid, displaySettings) {
        var seriesIndex = 0;
        var studyUids = dicomViewer.getListOfStudyUid();
        var listOfStudy = studyUids.length - 1;
        if((studyUid !== undefined) && (listOfStudy <= 3) )
        {
            var array = studyLevelMap;
            var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex);
            if(!isMultiFrame && getimageCanvasOfViewPort("imageviewer_"+array[listOfStudy]+"_" + 1 + "x" + 1) != undefined){
                seriesIndex = getimageCanvasOfViewPort("imageviewer_"+array[listOfStudy]+"_" + 1 + "x" + 1).seriesIndex;
                imageIndexNumber = getimageCanvasOfViewPort("imageviewer_"+array[listOfStudy]+"_" + 1 + "x" + 1).imageIndex;
            }
            else
            {
                seriesIndex = 0;
            }

            // Apply the display settings
            var seriesLayoutRows = 1;
            var seriesLayoutColumns = 1;
            if(displaySettings !== undefined){
                seriesLayoutRows = parseInt(displaySettings.Rows);
                seriesLayoutColumns = parseInt(displaySettings.Columns);
            }

            setSeriesLayout(studyUid, seriesLayoutRows, seriesLayoutColumns, seriesIndex,
                            undefined ,array[listOfStudy],undefined, true);
        }
    }

    function refreshStudyLayout(){
        var seriesIndex = 0;
        var row = 1;
        var column = 1;
        var studyUids = dicomViewer.getListOfStudyUid();
        var array = studyUids.length;
        if(studyUids !== undefined)
        {
            if(array === 2) column = 2;
            if(array === 3) row = 2;

            createStudyViewport(row,column);
            for(var index = 0; index<array;index++)
            {
                var studyUid = studyUids[index];
                var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex);
                if(!isMultiFrame && getimageCanvasOfViewPort("imageviewer_"+array[index]+"_" + 1 + "x" + 1) != undefined){
                    seriesIndex = getimageCanvasOfViewPort("imageviewer_"+array[index]+"_" + 1 + "x" + 1).seriesIndex;
                    imageIndexNumber = getimageCanvasOfViewPort("imageviewer_"+array[index]+"_" + 1 + "x" + 1).imageIndex;
                }
                else
                {
                    seriesIndex = 0;
                }
                setSeriesLayout(studyUid, 1, 1, seriesIndex, undefined ,studyLevelMap[index],undefined);
            }
        }
    }

    function setStudyLayout(row, column, studyUid, seriesIndexValue, isBackup,isResize, displaySettings, isFullScreenResize){
        var seriesIndex = 0;
        if(seriesIndexValue != undefined)
        {
            seriesIndex = seriesIndexValue;
        }
        if (row === undefined || column === undefined) {
            row = 1;
            column = 1;
        }

        // Apply the HP layout
        var seriesLayoutRows = 1;
        var seriesLayoutColumns = 1;
        if(displaySettings !== undefined) {
            seriesLayoutRows = parseInt(displaySettings.Rows);
            seriesLayoutColumns = parseInt(displaySettings.Columns);
        }

        createStudyViewport(row,column);
        if(studyUid === undefined){
        var array = studyLevelMap;
        var studyUids = dicomViewer.getListOfStudyUid(isResize);
        for(var index = 0; index<array.length;index++)
        {
            var studyUid = studyUids[index];
            var seriesLayout = getOrUpdateSeriesLayout(studyUid, seriesLayoutRows, seriesLayoutColumns, false);

            var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex);
            if(!isMultiFrame && getimageCanvasOfViewPort("imageviewer_"+array[index]+"_" + 1 + "x" + 1) != undefined)
            {
                seriesIndex = getimageCanvasOfViewPort("imageviewer_"+array[index]+"_" + 1 + "x" + 1).seriesIndex;
                imageIndexNumber = getimageCanvasOfViewPort("imageviewer_"+array[index]+"_" + 1 + "x" + 1).imageIndex;
            }
            else
            {
                seriesIndex = 0;
            }
            setSeriesLayout(studyUid, seriesLayout.Rows, seriesLayout.Columns, seriesIndex, isBackup ,array[index],isResize, false);
            dicomViewer.addStudyToCacheMap(studyUid);
        }
        }
        else{
            setSeriesLayout(studyUid, seriesLayoutRows, seriesLayoutColumns, seriesIndex, isBackup, "studyViewer1x1",isResize, false, undefined, isFullScreenResize);
        }

        // Remove the duplicate view ports
        RemoveDuplicateViewports();
    }

    /**
     * Remove the duplicate view ports
     */ 
    function RemoveDuplicateViewports() {
        try
        {
            if(isFullScreenEnabled == true) {
                return;
            }

            var allViewports = dicomViewer.viewports.getAllViewports();
            if(allViewports === null || allViewports === undefined) {
                return;
            }

            // Parse the view ports
            $.each(allViewports, function(key, value) {
                if(value.studyUid !== undefined) {
                    // Remove the view port
                    var studyViewportId = getStudyLayoutId(value.seriesLayoutId);
                    if(studyLevelMap.indexOf(studyViewportId) == -1) {
                        dicomViewer.viewports.removeViewportsByStudyLayout(studyViewportId); 
                        dicomViewer.removeimageCanvasOfAllViewPorts(studyViewportId);
                    }
                }
            });
        }
        catch(e)
        { }
    }

    /**
    * Check whether the study is in full screen mode
    */ 
    function IsFullScreenMode()
    {
        var currentStudyLayout = studyLayoutValue.split("x");
        var rows = currentStudyLayout[0];
        var columns = currentStudyLayout[1];
        if((parseInt(rows) == 1 && parseInt(columns) == 1) || isFullScreenEnabled) {
            return true;
        }

        return false;
    }

    /**
     * Get or update the series layout for the study
     * @param {Type} studyUid - Study Uid
     * @param {Type} rows - Rows
     * @param {Type} columns - Columns
     * @param {Type} isUpdate - Update or Get flag
     */ 
    function getOrUpdateSeriesLayout(studyUid, rows, columns, isUpdate){
        // Maintain the default values
        var layout =
            {
                Rows: rows,
                Columns: columns
            };

        try
        {
            if(studyUid === undefined && !isUpdate){
                return layout;
            }

            // Remove the key
            if(isUpdate){
                if(seriesLayoutMap.has(studyUid)){
                    layout = seriesLayoutMap.get(studyUid);
                    layout.Rows = rows;
                    layout.Columns = columns;
                } else {
                    // Set the layout
                    if(studyUid != undefined){
                        seriesLayoutMap.set(studyUid, layout);
                    }
                }

                return layout;
            }

            // Get the layout
            layout = seriesLayoutMap.get(studyUid);
            if(layout === undefined){
                layout = {
                    Rows: rows,
                    Columns: columns
                };

                // Set the layout 
                seriesLayoutMap.set(studyUid, layout);
            }

            return layout;
        }
        catch(e)
        { }

        return layout;
    }

    /**
     * Cheking whether the given study is multi-modality or not.
     * @param {Type} studyUid - Study Uid
     * @param {Type} seriesIndex - new series index
     */
    function isMixedModality(studyUid, seriesIndex) {
        var activeSeriesIndex = dicomViewer.getActiveSeriesLayout().seriesIndex;
        if(activeSeriesIndex !== undefined) {
            var activeModality = dicomViewer.Series.getModality(studyUid, activeSeriesIndex);
            var newModality = dicomViewer.Series.getSeries(studyUid, seriesIndex).modality;
            if(activeModality !== newModality) {
                return true;
            }
        }
        return false;
    }

    /* Load the dicom images in viewports*/
    function setSeriesLayout(studyUid, row, column, seriesIndexValue,
                              isBackup, studyViewportId,isResize, isSeriesLayoutUpdationRequired,isThumbnailClick, isFullScreenResize) {
        if (row === undefined || column === undefined) {
            row = 1;
            column = 1;
        }
        var backupLayoutId = "";
        if(isResize === undefined || isResize === false)
        {
            if (isBackup === undefined || isBackup === null) {

                // Update the series layout
                if(isSeriesLayoutUpdationRequired == true){
                    getOrUpdateSeriesLayout(studyUid, row, column, false);
                }else if(isSeriesLayoutUpdationRequired === undefined){
                    getOrUpdateSeriesLayout(studyUid, row, column, true);
                }

                var viewports = dicomViewer.viewports.getAllViewports();
                for(var key in viewports){
                    if(dicomViewer.getimageCanvasOfViewPort(key) !== undefined)
                    {
                        var canvasTemp = Object.create(dicomViewer.getimageCanvasOfViewPort(key));
                        dicomViewer.setimageCanvasOfBackupViewPort(key,canvasTemp);
                    }
                }

                for (var key in cineManager)
                {
                    var studyLayoutId = key.split("_")[1];
                    if(studyViewportId == studyLayoutId){
                        resizeCineManager[key] = JSON.parse(JSON.stringify(cineManager[key]));
                        clearInterval(cineManager[key].timer);
                        delete cineManager[key];
                    }
                }
                dicomViewer.viewports.backupViewableViewportsBySeriesIndex(studyViewportId);
                dicomViewer.viewports.removeViewportsByStudyLayout(studyViewportId); 
                dicomViewer.removeimageCanvasOfAllViewPorts(studyViewportId);
                dicomViewer.removeCacheMapInStudy(studyUid);
                dicomViewer.viewports.addSeriesLayoutMaxId("imageviewer_"+studyViewportId+"_" + row + "x" + column);            
                dicomViewer.measurement.setMeasurementBroken(false);
            } 
            /*else if(isCineRunningOnAnyViewPort() === true)
            {            
                return;
            }*/
        } else if(dicomViewer.getActiveSeriesLayout() !== null && dicomViewer.getActiveSeriesLayout() !== undefined) {
            backupLayoutId = dicomViewer.getActiveSeriesLayout().getSeriesLayoutId();
        }
        
        createViewport(row, column, studyViewportId,studyUid);
        
        var seriesIndex = 0;
        if(seriesIndexValue != undefined)
        {
            seriesIndex = seriesIndexValue;
        }
        var imageIndex = 0;
        var frameIndex = 0;
        var imageLayout = "";        
        var layoutId = "";
        var duplicateSeriesIndex = 0;
        if(isResize === undefined || isResize === false)
        {
            if(studyUid !== undefined)
            {
                if(seriesIndexValue === undefined)
                {
                    if(dicomViewer.getActiveSeriesLayout() != undefined ){
                        seriesIndex = dicomViewer.getActiveSeriesLayout().getSeriesIndex();
                        imageIndex = dicomViewer.getActiveSeriesLayout().getImageIndex();
                    }
                    if(seriesIndex === undefined) seriesIndex = 0;
                    if(imageIndex === undefined) imageIndex = 0;
                }else
                {
                    seriesIndex = seriesIndexValue;
                    if(dicomViewer.getActiveSeriesLayout() === undefined || dicomViewer.getActiveSeriesLayout() === null)
                    {
                        imageIndex = 0;
                    }
                    else {
                        //While changing the series layout, if any mixed modality(multiframe should be there) then getting the image index from the global common variable
                        if(isMixedModality(studyUid, seriesIndex)) {
                            imageIndex = multiFrameImageIndex;
                        } else {
                            imageIndex = dicomViewer.getActiveSeriesLayout().getImageIndex();
                        }
                        if(imageIndex === undefined) imageIndex = 0;
                        if(studyUid !== undefined)
                        {
                            var imageValue = dicomViewer.Series.Image.getImage(studyUid,seriesIndex,imageIndex); 
                            if(!dicomViewer.thumbnail.isImageThumbnail(imageValue))
                            {
                                imageIndex = 0;
                            }
                        }
                    }            
                }
            }

            /* assign multiFrameImageIndex value to imageIndex to provide the
            starting point when changing the layout */
            if(actualSeriesIndex == imageIndex){
                imageIndex = multiFrameImageIndex;
            }

            currentSeriesLayoutIds = "imageviewer_"+studyViewportId+"_" + row + "x" + column;
            if (isBackup !== undefined && isBackup !== null && studyUid !== undefined)
            {
                layoutId = "imageviewer_"+ studyViewportId+ "_" + (1) + "x" + (1);
                if(isBackup === true && isFullScreenResize !== true)
                {
                    currentLayOutId = getActiveSeriesLayout().getSeriesLayoutId();
                    if(currentLayOutId !== layoutId)
                    {
                        viewport = dicomViewer.viewports.getViewport(layoutId).copy(); 
                        if(viewport !== undefined)
                        {
                            dicomViewer.viewports.removeViewport(layoutId)
                            dicomViewer.viewports.addBackupViewport(layoutId,viewport.copy());

                            viewport = dicomViewer.viewports.getViewport(currentLayOutId).copy();   
                            dicomViewer.viewports.removeViewport(currentLayOutId)
                            dicomViewer.viewports.addBackupViewport(currentLayOutId,viewport.copy());                        
                            //viewport.updateImageRendersTo(viewport.seriesLayoutId,layoutId);
                            viewport.seriesLayoutId = layoutId;
                            dicomViewer.viewports.addViewport(layoutId, viewport); 

                            var tmpCanvas = dicomViewer.getimageCanvasOfViewPort(layoutId);
                            if(tmpCanvas !== undefined)
                            {
                                var canvasTemp = Object.create(tmpCanvas);
                                dicomViewer.setimageCanvasOfBackupViewPort(layoutId,canvasTemp);
                                dicomViewer.removeimageCanvasOfViewPort(layoutId);
                            }
                            tmpCanvas = dicomViewer.getimageCanvasOfViewPort(currentLayOutId);
                            if(tmpCanvas !== undefined)
                            {
                                var canvasTemp = Object.create(tmpCanvas);
                                dicomViewer.setimageCanvasOfBackupViewPort(currentLayOutId,canvasTemp);
                                dicomViewer.setimageCanvasOfViewPort(layoutId,Object.create(canvasTemp));
                                dicomViewer.removeimageCanvasOfViewPort(currentLayOutId);
                            }

                            if(cineManager[layoutId] !== undefined)
                            {
                                fullScreenCineManager[layoutId] = JSON.parse(JSON.stringify(cineManager[layoutId])); 
                                 clearInterval(cineManager[layoutId].timer);
                                 delete cineManager[layoutId];
                            }
                            if(cineManager[currentLayOutId] !== undefined)
                            {
                                cineManager[layoutId] = JSON.parse(JSON.stringify(cineManager[currentLayOutId]));
                                clearInterval(cineManager[layoutId].timer);
                                delete cineManager[currentLayOutId];
                            }
                        }
                    }
                }else if(currentLayOutId !== layoutId && isFullScreenResize !== true)
                { 
                    var backupviewport = dicomViewer.viewports.getViewport(layoutId).copy();
                    if(backupviewport !== undefined && currentLayOutId !== "imageviewer_studyViewer1x1_1x1" && currentLayOutId !== "")
                    {
                        backupviewport.updateImageRendersTo(backupviewport.seriesLayoutId,currentLayOutId);
                        backupviewport.seriesLayoutId = currentLayOutId;
                        dicomViewer.viewports.addViewport(currentLayOutId, backupviewport.copy()); 
                        dicomViewer.viewports.removeBackupViewport(currentLayOutId);

                        backupviewport = dicomViewer.viewports.getBackupViewport(layoutId);
                        if(backupviewport !== undefined) {
                            dicomViewer.viewports.addViewport(layoutId, backupviewport.copy()); 
                            dicomViewer.viewports.removeBackupViewport(layoutId);
                        } else {
                            backupviewport = dicomViewer.viewports.getViewport(layoutId).copy();
                            dicomViewer.viewports.addViewport(layoutId, backupviewport.copy()); 
                            dicomViewer.viewports.removeBackupViewport(layoutId);
                        }
                        dicomViewer.viewports.addViewport(layoutId, backupviewport.copy()); 
                        dicomViewer.viewports.removeBackupViewport(layoutId);

                        var tmpCanvas = dicomViewer.getimageCanvasOfViewPort(layoutId);
                        if(tmpCanvas !== undefined)
                        {
                            var canvasTemp = Object.create(tmpCanvas);
                            dicomViewer.removeimageCanvasOfBackupViewPort(currentLayOutId);
                            dicomViewer.setimageCanvasOfViewPort(currentLayOutId,canvasTemp);
                        }
                        tmpCanvas = dicomViewer.getimageCanvasOfBackupViewPort(layoutId);
                        if(tmpCanvas !== undefined)
                        {
                            var canvasTemp = Object.create(tmpCanvas);
                            dicomViewer.removeimageCanvasOfBackupViewPort(layoutId);
                            dicomViewer.setimageCanvasOfViewPort(layoutId,canvasTemp);
                        }

                        if(cineManager[layoutId] !== undefined)
                        {
                            cineManager[currentLayOutId] = JSON.parse(JSON.stringify(cineManager[layoutId]));
                            if(studyLayoutValue !== "1x1" && currentLayOutId !== undefined && currentLayOutId !== ""){
                                if(cineManager[currentLayOutId] !== undefined){
                                     if(cineManager[currentLayOutId].playStudy !== undefined){
                                         repeatCineManager[currentLayOutId] = JSON.parse(JSON.stringify(cineManager[currentLayOutId]));
                                     }
                                }
                            }
                        }else
                        {
                            delete cineManager[currentLayOutId];
                        }
                        delete  cineManager[layoutId];

                        if(fullScreenCineManager[layoutId] !== undefined)
                        {
                            cineManager[layoutId] = JSON.parse(JSON.stringify(fullScreenCineManager[layoutId]));
                        }else
                        {
                            delete cineManager[layoutId];
                        }                
                        delete  fullScreenCineManager[currentLayOutId];
                        delete  fullScreenCineManager[layoutId];
                        backupLayoutId = currentLayOutId;
                        currentLayOutId = "";
                    }
                } else if(currentLayOutId == layoutId && isFullScreenResize !== true){
                    if(cineManager[layoutId] !== undefined)
                        {
                            cineManager[currentLayOutId] = JSON.parse(JSON.stringify(cineManager[layoutId]));
                            if(studyLayoutValue !== "1x1" && currentLayOutId !== undefined && currentLayOutId !== ""){
                                if(cineManager[currentLayOutId] !== undefined){
                                     if(cineManager[currentLayOutId].playStudy !== undefined){
                                         repeatCineManager[currentLayOutId] = JSON.parse(JSON.stringify(cineManager[currentLayOutId]));
                                     }
                                }
                            }
                        }
                }
            }
        }
        var viewportProperty = undefined;
        for (var i = 0; i < row; i++) {
            for (var int2 = 0; int2 < column; int2++) {
                layoutId = "imageviewer_"+ studyViewportId+ "_" + (i + 1) + "x" + (int2 + 1);
                var imageLayoutDimension  = undefined;
                if(isThumbnailClick) {
                    viewportProperty = dicomViewer.thumbnail.getViewportProperty(layoutId);
                    if(viewportProperty != null) {
                        seriesIndex = viewportProperty.split("|")[1];
                        imageIndex = viewportProperty.split("|")[2];
                        frameIndex = viewportProperty.split("|")[3];
                        imageLayoutDimension = viewportProperty.split("|")[4];
                    } else {
                        isThumbnailClick = false;
                    }
                }
                var imageValue = dicomViewer.Series.Image.getImage(studyUid,seriesIndex,imageIndex); 
                
                if(backupLayoutId === "") backupLayoutId = layoutId;
                 var viewport = dicomViewer.viewports.getViewport(layoutId);
                if(viewport !== undefined && viewport !== null){
                    if(viewport.studyUid === undefined && studyViewportId !== undefined){
                        var imageLayoutDisplayId = "imageDisplay" + studyViewportId;
                        document.getElementById(imageLayoutDisplayId).style.display='none';

                        var viewportToolbarId = "SaveAndLoad_"+ studyViewportId;
                        if(document.getElementById(viewportToolbarId) !== null && document.getElementById(viewportToolbarId) !== undefined) {
                           document.getElementById(viewportToolbarId).style.display='none';
                        }
                    }
                }

                 if (imageValue !== undefined && viewport === undefined || viewport === null)
                 {
                     var isImageThumbnail = dicomViewer.thumbnail.isImageThumbnail(imageValue);
                     if(isImageThumbnail){
                        viewport = dicomViewer.viewports.getBackupViewportBySeriesIndex(studyUid+"_"+imageIndex);
                         dicomViewer.viewports.removeBackupViewportBySeriesIndex(studyUid+"_"+imageIndex);
                     }
                     else{
                         viewport = dicomViewer.viewports.getBackupViewportBySeriesIndex(studyUid+"_"+seriesIndex);
                         dicomViewer.viewports.removeBackupViewportBySeriesIndex(studyUid+"_"+seriesIndex);
                     }
                     if (viewport !== undefined && viewport !== null){
                        if(dicomViewer.getimageCanvasOfBackupViewPort(viewport.seriesLayoutId) != undefined){
                            canvasTemp = Object.create(dicomViewer.getimageCanvasOfBackupViewPort(viewport.seriesLayoutId));
                            dicomViewer.removeimageCanvasOfBackupViewPort(viewport.seriesLayoutId);  
                            dicomViewer.setimageCanvasOfViewPort(layoutId,canvasTemp);
                        }
                         if(resizeCineManager[viewport.seriesLayoutId] !== undefined)
                            cineManager[layoutId] = JSON.parse(JSON.stringify(resizeCineManager[viewport.seriesLayoutId])); 
                         viewport.seriesLayoutId = layoutId;
                         dicomViewer.viewports.addViewport(viewport.seriesLayoutId, viewport);
                     }
                 }

                if(imageValue == undefined && (viewport == undefined || viewport == null) && studyUid != undefined) {
                    var layout = dicomViewer.viewports.getDuplicateViewportByIndex(duplicateSeriesIndex, layoutId.split('_')[1]);
                    if(layout != undefined && layout != null) {
                        seriesIndex = layout.getSeriesIndex();
                        imageIndex = layout.getImageIndex();
                        frameIndex = layout.getFrameIndex();
                        imageValue = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
                    }
                    duplicateSeriesIndex++;
                }

                 if (viewport === undefined || viewport === null)
                 {
                    viewport = new SeriesLevelLayout(layoutId);
                    viewport.setStudyUid(studyUid);
                    viewport.seriesLayoutId = layoutId;
                    if(imageValue !== undefined)
                    {
                        viewport.setSeriesIndex(seriesIndex);
                        viewport.setImageIndex(imageIndex);
                        viewport.setFrameIndex(frameIndex);
                    }
                    else
                    {
                        viewport.setSeriesIndex(undefined);
                        viewport.setImageIndex(undefined);
                        viewport.setFrameIndex(undefined);
                    }
                    var imageLayout = "1x1";
                    viewport.setImageLayoutDimension(imageLayout);
                    dicomViewer.viewports.addViewport(viewport.seriesLayoutId, viewport);  
                }
                 if(isThumbnailClick) {
                    viewport.imageLayoutDimension = imageLayoutDimension;
                 }
                imageLayout = viewport.getImageLayoutDimension().split("x");   
                // Initialize the ECG preference details.
                var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
                var preferenceInfo;
                if(activeSeriesLayout && activeSeriesLayout.preferenceInfo) {
                    preferenceInfo = activeSeriesLayout.preferenceInfo;
                } else {
                    preferenceInfo = new PreferenceInfo();
                    preferenceInfo.init();
                }

                viewport.setPreferenceInfo(preferenceInfo);
                ApplyDisplaySettings(studyUid, preferenceInfo, seriesIndex);
                 if(dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex) == true) {
                    setImageLevelLayout(studyUid, parseInt(imageLayout[0]), parseInt(imageLayout[1]), layoutId, viewport, viewport.seriesIndex, viewport.scrollData.imageIndex, viewport.scrollData.frameIndex, true);
                 }
                else {
                    setImageLevelLayout(studyUid, parseInt(imageLayout[0]), parseInt(imageLayout[1]), layoutId, viewport, viewport.seriesIndex, 0, viewport.scrollData.frameIndex, true);
                 }
                if(imageValue !== undefined)
                {
                    //dicomViewer.viewports.getAllViewports();
                    $("#" + layoutId).mousedown(selectViewport); 
                    $("#" + layoutId).mouseover(focusActiveLayout);
                    $("#" + layoutId).keydown(keyToMoveNextOrPreviousImage); 
                }
                $("#" + layoutId).bind('mousewheel DOMMouseScroll', scroll);
                $("#" + layoutId).on("dragover", allowDrop);
                $("#" + layoutId).on("drop", seriesDrop);
                $("#" + layoutId).click(selectViewport);
                if(studyUid !== undefined && imageValue !== undefined)
                {
                    seriesIndex = viewport.getSeriesIndex();
                    imageIndex = viewport.getImageIndex();
                    frameIndex = viewport.getFrameIndex();
                    if(studyUid !== undefined && seriesIndex !== undefined && imageIndex !== undefined) {
                       var imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
                        if( (dicomViewer.thumbnail.isImageThumbnail(imageValue) ||
                             dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex)) && imageCount >= 1 ) {
                           var frameCount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex));
                            viewport.progressbar.updateImagePosition(frameCount, frameIndex);
                            frameIndex = 0;
                            if(imageIndex < imageCount-1) {
                                imageIndex++;
                            } else {
                                //If it is the last image of the series then moving to the next series with first image
                                imageIndex = 0;
                                seriesIndex++;
                            }
                        } else {
                            viewport.progressbar.updateImagePosition(imageCount, imageIndex);  
                            imageIndex = 0;
                            frameIndex = 0;
                            seriesIndex++;
                        }
                    }

                    if(duplicateSeriesIndex > 0) {
                        seriesIndex = dicomViewer.Study.getSeriesCount(studyUid) + duplicateSeriesIndex;
                    }
                }
                                                           
            }
        }
        if(isBackup === undefined || isBackup === null)
        {
            dicomViewer.removeimageCanvasOfAllBackupViewPorts(studyViewportId);
            for (var key in resizeCineManager){
                var studyLayoutId = key.split("_")[1];
                if(studyViewportId == studyLayoutId){
                    delete resizeCineManager[key];
                }
            }
            dicomViewer.viewports.removeAllBackupViewportBySeriesIndex(studyViewportId);
        }
        if(isBackup === undefined || isBackup === null || isBackup === false)
        {            
            for(var layoutId in cineManager)
            {
                var studyLayoutId = layoutId.split("_")[1];
                if (cineManager[layoutId] !== undefined && studyViewportId == studyLayoutId) 
                {
                    if (cineManager[layoutId].timer == null)
                    {
                        updatePlayIcon("stop.png","play.png");
                    } else
                    {
                        var parentElement = $("#playBackward").parent().css("background","");
                        var parentElement = $("#playForward").parent().css("background","#868696");
                        $("#"+ layoutId).trigger("click"); 
                        updatePlayIcon("play.png","stop.png");
                        if(isCineEnabled())
                        {
                            var obj = {};
                            obj.id =  "playButton"
                            var seriesLayout = dicomViewer.viewports.getViewport(layoutId);
                            if(cineManager[layoutId].playStudy == true){
                                seriesLayout.seriesIndex = 0;
                                seriesLayout.scrollData.imageIndex = 0;
                            }

                            dicomViewer.setActiveSeriesLayout(seriesLayout);
                            updatePlayIcon("stop.png","play.png");
                            playCineImage(obj,undefined);
                        }
                    }
                }
            }
            $("#"+ backupLayoutId).trigger("click"); 
                           
        }else
        {
             
            if (cineManager[layoutId] !== undefined) 
            {
                if (cineManager[layoutId].timer == null)
                {
                    updatePlayIcon("stop.png","play.png");
                } else
                {
                    var parentElement = $("#playBackward").parent().css("background","");
                    var parentElement = $("#playForward").parent().css("background","#868696");
                    $("#"+ layoutId).trigger("click");
                    updatePlayIcon("play.png","stop.png");
                    if(isCineEnabled())
                    {
                        var obj = {};
                        obj.id =  "playButton"
                        playCineImage(obj);
                        playCineImage(obj);
                    }
                }
            }
            changeSelection(layoutId);
        }
    }

    function focusActiveLayout(event) {
        $("#" + getActiveSeriesLayout().seriesLayoutId).focus();
    }

    /**
     * To create the custom/embed pdf viewer
     * @param {Type} image - To specifies the image info
     * @param {Type} viewport - To specifies the viewport details
     * @param {Type} render - To specifies the image render
     * @param {Type} seriesLevelDiv - To specifies the series layout Div ID
     */ 
    function createPDFRender(image,viewport,renderer,seriesLevelDiv) {
        var urlParameters = dicomViewer.getPdfFrameUrl(image.imageUid);
        if(urlParameters.FrameNumber !== undefined) {
            urlParameters.FrameNumber = undefined;
        }
        var pdfData = isEmbedPdfViewer ? "pdf" : "pdfData";
        var url = dicomViewer.url.getDicomImageURL(urlParameters);
        viewport.addImageRender(pdfData, renderer);

        if(isEmbedPdfViewer) {
            var pdfUrl = "pdfviewer1x1";
            var pdfDiv = "<div id='pdf' style='height:100%;width:100%'><iframe id='pdfviewer1x1' name='pdfviewer1x1' style='height:100%;width:100%' src="+url+" onload='this.focus()'/></div>"
            $("#"+seriesLevelDiv).empty();
            $("#"+seriesLevelDiv).append(pdfDiv);
            $("#" + pdfUrl).bind('mousewheel DOMMouseScroll', scroll);
            $("#" + pdfUrl).mousedown(selectViewport); 
            $("#" + pdfUrl).mouseover(focusActiveLayout);
            $("#" + pdfUrl).keydown(keyToMoveNextOrPreviousImage); 

            $("#" + pdfUrl).on("dragover", allowDrop);
            $("#" + pdfUrl).on("drop", seriesDrop);
            $("#" + pdfUrl).click(selectViewport);
            bringToFrontPdf(seriesLevelDiv);
        } else {
            dicomViewer.createPDF(url, seriesLevelDiv);
        }
    }

    function setImageLevelLayout(studyUid, row, column, seriesLevelDiv, viewport, seriesIndex, imageIndex, frameIndex, isMoveSeries) {
        if(studyUid !== undefined && seriesIndex !== undefined && isMoveSeries == true){
            // set the row and column for series, when image count as 1
            var imageCount = 0;
            var frameCount = 0;
            imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
            frameCount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex));
            imageCount = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex) ? frameCount : imageCount;

            if(imageCount == 1) {
                row = 1; column = 1;
            }
        }

        $("#" + seriesLevelDiv).empty();
        var imageLevelName = seriesLevelDiv + "ImageLevel";
        var appendString = "<table style='width:100%;height:99%;'>";
        for (var i = 0; i < row; i++) {
            appendString += "<tr style='height:" + (100 / row) + "%;'>";
            for (var j = 0; j < column; j++) {
                var tableDataId = imageLevelName + i + "x" + j + "id";
                appendString += "<td id=" +tableDataId+ " style='width:" + ((100 / column)) + "%;height:" + ((100 / row)) + "%;'>";
                appendString = appendString + "<div id=" + imageLevelName + i + "x" + j + " style='height:98%;width:99%;'></div>";
                appendString += "</td>";
            }
            appendString += "</tr>";
        }
        appendString += "</table>";
        $("#" + seriesLevelDiv).html(appendString);
        $("#" + seriesLevelDiv).addClass('default-view');
        var defaultImageLayoutId = imageLevelName + "0x0";
        $("#"+defaultImageLayoutId+"id").removeClass('default-view');
        updateSpinnerLocation(seriesLevelDiv);
        var progressbar = new ViewportProgreeBar(seriesLevelDiv);
        dicomViewer.cacheIndicator.addCacheIndicator(progressbar);
        viewport.setProgressbar(progressbar);
        dicomViewer.progress.setSpinnerData(progressbar);
        if (studyUid === undefined) return;
        if(seriesIndex === undefined) return;
        var imageSeries = dicomViewer.Series.getSeries(studyUid,seriesIndex);
        //check the series is available based on series index if not available it ill return
        if (imageSeries == undefined) {
            return;
        }
        var spinner = dicomViewer.progress.createAndGetSpinner(seriesLevelDiv);
        dicomViewer.progress.putSpinner(seriesLevelDiv, spinner);
		
        //For storing the presentation values of the altered image(es)
        var updatedCanvasPresentation = undefined;
        var isPresentationUpdationRequired = true;
        if (row === 1 && column === 1) {
            var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
            var anUIDs = dicomViewer.Series.Image.getImageUid(image) + "*" + (frameIndex++)
            var defaultImageLayoutId = imageLevelName + "0x0";
            $("#"+defaultImageLayoutId+"id").removeClass('default-view');
            var renderer = undefined;
            renderer = viewport.getImageRender(viewport.seriesLayoutId+ "ImageLevel0x0");

            //checking the availabilty for the rendered image as well as its presentation values, if the rendered image is altered then only fetch and store its presentation values
            if((renderer != null || renderer != undefined) && renderer.presentationState != undefined){
                if(isPresentationUpdationRequired) {
                    updatedCanvasPresentation = renderer.presentationState;
                    updatedCanvasPresentation.zoom = renderer.scaleValue;
                    isPresentationUpdationRequired = false;
                }
            }
            renderer = new ImageRenderer(defaultImageLayoutId,seriesLevelDiv);
            renderer.init(anUIDs, seriesIndex, imageIndex);

            if(image.modality === "US")
                viewport.setImageType(IMAGETYPE_RADECHO);
            else
                viewport.setImageType(image.imageType);
            if(image.imageType == IMAGETYPE_RAD || image.imageType == IMAGETYPE_RADECHO || image.imageType === IMAGETYPE_JPEG)
            {
                viewport.addImageRender(defaultImageLayoutId, renderer);
                
            }
            var imageUid = dicomViewer.Series.Image.getImageUid(image);
            var header = dicomViewer.header.getDicomHeader(imageUid);
            var imagePromise = undefined;

            if (header) {
                var imageType = image.imageType;
                if (imageType == IMAGETYPE_RADECHO || imageType == IMAGETYPE_RAD || image.imageType === IMAGETYPE_JPEG) {
                    disableOrEnableDicomTools(false);

                    if(image.modality == "CT") {
                        updateKendoArrowButton($("#winL_wrapper"), false);
                    }
                    imagePromise = dicomViewer.imageCache.getImagePromise(imageUid +"_"+ (frameIndex - 1));
                    if (imagePromise === undefined) {
                        imagePromise = dicomViewer.loadAndCacheImage(studyUid, imageUid, frameIndex - 1, seriesIndex);
                    }
                    var imageCanvas = null;
                    imagePromise.then(function(image) {
                        imageCanvas = image;
                    });

                    //On first time when the viewer is rendering the image, updatedCanvasPresentation will be undefined
                    if(updatedCanvasPresentation != null && updatedCanvasPresentation != undefined) {
                        if(imageCanvas != null && imageCanvas != undefined) {
                            if(imageCanvas.presentation.presentationMode == "MAGNIFY") {
                                updatedCanvasPresentation.presentationMode = "MAGNIFY";
                            }

                            imageCanvas.presentation = updatedCanvasPresentation;
                        }
                    }
                    //get the imageCanvas value based on the viewport id
                    var imageCanvasValue = imageCanvasOfViewPorts[seriesLevelDiv];
                    /* selected thumbnail image shoud have imageCanvasValue
                    other images we are doing indefined for imageCanvasValue to avoid
                    the duplication in the view port*/
                    if(selectThumbnailImageIndex !== undefined && selectThumbnailImageIndex != imageIndex){
                        imageCanvasValue = undefined;
                    }
                    /*when the imageCanvasValue is undefines or already added imageCanvas is not equal to current imageaCanvas(identify using image id) we are adding the new imageCanvas to the object(view port div id as key and imageCanvas as value)*/
                    if (imageCanvasValue == undefined && imageCanvas !== null) {
                        /*Adding the new imageCanvas value to object based on viewport id as key*/
                        //imageCanvasOfViewPorts[seriesLevelDiv] = imageCanvas;
                        imageCanvas.seriesIndex = seriesIndex;
                        imageCanvas.imageIndex = imageIndex;
                        setimageCanvasOfViewPort(seriesLevelDiv, imageCanvas);
                        renderer.loadImageRenderer(imagePromise, imageCanvas, studyUid);
                        renderer.presentationState.windowLevel = imageCanvas.lastAppliedWindowLevel;
                    } else {
                        if(imageCanvasValue != undefined && imageCanvas != null){
                        /*imageCanvas is alreday avilable in same image of same viewport if image id present in the imageCanvasValue is not maching with the image we are updating the image promised based on selcted user image
                    when drag the image thumbnail we can maintain the current image of the series on viewport*/
                        if ( imageCanvasValue.imageUid != image.imageUid || imageCanvas.frameNumber != imageCanvasValue.frameNumber) {
                            var imagePromiseVal = dicomViewer.imageCache.getImagePromise(imageCanvasValue.imageUid +"_"+ (imageCanvasValue.frameNumber));
                            if (imagePromiseVal != undefined) {
                                imagePromise = imagePromiseVal;
                            }
                        }
                        if(imageCanvas.presentation) {
                            imageCanvasValue.presentation = imageCanvas.presentation;
                        }
                        renderer.loadImageRenderer(imagePromise, imageCanvasValue);
                        renderer.presentationState.windowLevel = imageCanvas.lastAppliedWindowLevel;
                        imageUid = imageCanvasValue.imageUid;
                        }
                    }
                } 
            }
            if(image.imageType == IMAGETYPE_RADECHO) {
                var imageCountFlag = false;
                var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex);
                if(isMultiFrame){
                    for (var i = 0; i < dicomViewer.Study.getSeriesCount(studyUid); i++){
                        for (var j = 0; j < dicomViewer.Series.getImageCount(studyUid, i); j++){
                          var image = dicomViewer.Series.Image.getImage(studyUid,i,j);
                          var multiFrameCount = dicomViewer.Series.Image.getImageFrameCount(image);
                          if(multiFrameCount > 1){
                             imageCountFlag = true;
                             break;
                          }
                        }
                    }
                } else{
                    for (var i = 0; i < dicomViewer.Study.getSeriesCount(studyUid); i++){
                        var imageCount = dicomViewer.Series.getImageCount(studyUid, i);
                        if(imageCount > 1){
                           imageCountFlag = true;
                           break;
                        }
                    }
                }
				
                enableOrDisableNavigationTools(imageCountFlag);
				
                disableOrEnableDicomTools(false);
                disableToolbarForUsImages(true);
            }else if (image.imageType == IMAGETYPE_RADPDF) {
                createPDFRender(image,viewport,renderer,seriesLevelDiv);
                } else if (image.imageType == IMAGETYPE_RADECG) {
                    viewport.addImageRender("ecgData", renderer);
                    var urlParameters = dicomViewer.getJpegFrameUrl(imageUid, 0);
                   dicomViewer.loadEcg(urlParameters,seriesLevelDiv);
                } else if (image.imageType === IMAGETYPE_RADSR || image.imageType === IMAGETYPE_CDA) {
                    viewport.addImageRender("srReport", renderer);
                    var urlParameters = dicomViewer.getImageInfoURl(imageUid);
                    imagePromise = dicomViewer.imageCache.getImagePromise(imageUid +"_"+ (frameIndex - 1));
                    if (imagePromise === undefined) {
                        imagePromise = dicomViewer.loadAndCacheImage(studyUid, imageUid, frameIndex - 1, seriesIndex);
                    }   
                    dicomViewer.loadSR(urlParameters, seriesLevelDiv, imagePromise, image.imageType);
                } else if (image.imageType === IMAGETYPE_JPEG) {
                    disableToolBarForNonDicom();
                } else if (isBlob(image.imageType)) {
                    if (image.imageType === IMAGETYPE_VIDEO) {
                        viewport.addImageRender(image.imageType, renderer);
                        var videoUrls = dicomViewer.getVideoUrls(image.imageUid);
                        for (i = 0; i < videoUrls.length; i++) {
                            videoUrls[i].url = dicomViewer.url.getDicomImageURL(videoUrls[i].urlParameters);
                        }
                        dicomViewer.loadVideoPlayer(videoUrls, seriesLevelDiv);
                    } else if (image.imageType === IMAGETYPE_AUDIO) {
                        viewport.addImageRender(image.imageType, renderer);
                        var audioURLObject = dicomViewer.getAudioUrl(image.imageUid);
                        var audioURL = dicomViewer.url.getDicomImageURL(audioURLObject);
                        dicomViewer.loadPlayer(audioURL, seriesLevelDiv, "mp3");
                    } else if (image.imageType === IMAGETYPE_PDF || image.imageType === IMAGETYPE_TIFF) {
                        createPDFRender(image,viewport,renderer,seriesLevelDiv);
                    } else { // unknown image
                        var height = $("#" + seriesLevelDiv).height();
                        var pdfDiv = "<div id='pdf' style='height:" + height + "px;line-height:" + height + "px;background:white' align='center'>Unknown Type</div>"
                        $("#" + seriesLevelDiv).empty();
                        $("#" + seriesLevelDiv).append(pdfDiv);
                    }
                }
            //else if(image.imageType === IMAGETYPE_BLOB){
            //    var fileName = image.fileName;
            //    var extension = "";
            //    if(fileName.indexOf("contentType=application/pdf") !== -1)
            //    {
            //        extension = "pdf"
            //    }
            //    else
            //    {
            //        var splitedName = fileName.split(".");
            //        extension = splitedName[splitedName.length-1];
            //    }                
                
            //    if(extension === "mp4" || extension === "avi")
            //    {
            //        var vedioURLObject = dicomViewer.getVideoUrl(image.imageUid);
            //        var videoURL = dicomViewer.url.getDicomImageURL(vedioURLObject);
            //        dicomViewer.loadPlayer(videoURL,seriesLevelDiv);
            //    }
            //    else if(extension === "mp3"){
            //        var audioURLObject = dicomViewer.getAudioUrl(image.imageUid);
            //        var audioURL = dicomViewer.url.getDicomImageURL(audioURLObject);
            //        dicomViewer.loadPlayer(audioURL,seriesLevelDiv, "mp3");
            //    }
            //    else if(extension === "pdf" || extension === "html" 
            //           || extension === "txt"){
            //        var urlParameters = dicomViewer.getBlobUrl(imageUid);
            //        var url = dicomViewer.url.getDicomImageURL(urlParameters);
            //        var pdfUrl = "pdfviewer1x1";
			//		var pdfDiv = "<div id='pdf' style='height:100%;width:100%;background:white'><iframe id='pdfviewer1x1' name='pdfviewer1x1' style='height:99%;width:99%' src="+url+"  onload='this.focus()'/></div>"
			//		$("#"+seriesLevelDiv).empty();
			//		$("#"+seriesLevelDiv).append(pdfDiv);
            //        $("#" + pdfUrl).click(selectViewport);
            //        }
            //    else{
            //        var height = $("#"+seriesLevelDiv).height();
            //        var pdfDiv = "<div id='pdf' style='height:"+height+"px;line-height:"+height+"px;background:white' align='center'>Invalid File</div>"
			//		$("#"+seriesLevelDiv).empty();
			//		$("#"+seriesLevelDiv).append(pdfDiv);
            //    }
            //}
            
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            var studyLayoutId = getStudyLayoutId(seriesLevelDiv);
            var studyInformationdiv = "studyInfo"+studyLayoutId;
            if(studyDetails.procedure === null || studyDetails.procedure === "" ||studyDetails.procedure.length ===0){
                $("#"+studyInformationdiv).html("&nbsp");
            }else{
                $("#"+studyInformationdiv).html(studyDetails.procedure);
                updateToolTip($("#"+studyInformationdiv), studyDetails.procedure, "top");
            }

            var studyTime = "";
            var studyId = "";
            if(studyDetails.dateTime !== null && studyDetails.dateTime !== undefined) {
                studyTime = studyDetails.dateTime.replace("T", "@");
            }
            
            if(studyDetails.dicomStudyId !== null && studyDetails.dicomStudyId !== undefined) {
                studyId = studyDetails.dicomStudyId;
            }

            if(studyTime !== "" || studyId !== "") {
                var studyDisplayText = (studyId !== "" ? studyId +", " + studyTime : studyTime);
                $("#studyUidDateTime"+studyLayoutId).html(studyDisplayText);
                updateToolTip($("#studyUidDateTime"+studyLayoutId), studyDisplayText, "top");
            }

            imageIndex = getImageIndexForImageUid(studyUid,seriesIndex, imageUid);
            progressbar.setSeriesInfo(studyUid, seriesIndex, imageIndex, frameIndex - 1);
            if (imageIndex == undefined)
                imageIndex = 0;            
            $("#"+defaultImageLayoutId+"id").removeClass('default-view');
        } else {
            for (var i = 0; i < row; i++) {
                for (var j = 0; j < column; j++) {
                    if (dicomViewer.Series.getSeries(studyUid, seriesIndex)) {
                        var imageLayoutId = imageLevelName + i + "x" + j;
                        var framecount = 0;
                        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
                        $("#"+imageLayoutId+"id").addClass('default-view');
                        if (!image) {
                            continue;
                        }
                        frameCount = dicomViewer.Series.Image.getImageFrameCount(image);
                        if (!(frameCount > frameIndex)) {
                            if(!dicomViewer.thumbnail.isImageThumbnail(image))
                            {
                                imageIndex++;
                            }
                            frameIndex = 0;
                            image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
                        }
                        if(image) {
                            var anUIDs = dicomViewer.Series.Image.getImageUid(image) + "*" + (frameIndex++)
                            var renderer = undefined;
                            renderer = viewport.getImageRender(viewport.seriesLayoutId+ "ImageLevel"+ i + "x" + j);
                            //checking the availabilty for the rendered image as well as its presentation values, if the rendered image is altered then only fetch and store its presentation values
                            if((renderer != null || renderer != undefined) && renderer.presentationState != undefined) {
                                if(isPresentationUpdationRequired) {
                                    updatedCanvasPresentation = renderer.presentationState;
                                    updatedCanvasPresentation.zoom = renderer.scaleValue;
                                    isPresentationUpdationRequired = false;
                                }
                            }
                            renderer = new ImageRenderer(imageLayoutId,seriesLevelDiv);
                            renderer.init(anUIDs, seriesIndex, imageIndex);
                            viewport.addImageRender(imageLevelName + i + "x" + j, renderer);

                            var imageUid = dicomViewer.Series.Image.getImageUid(image);
                            var header = dicomViewer.header.getDicomHeader(imageUid);
                            var imagePromise = undefined;
                            if(header) {
                                imagePromise = dicomViewer.imageCache.getImagePromise(imageUid +"_"+ (frameIndex - 1));
                                if (imagePromise === undefined) {
                                    imagePromise = dicomViewer.loadAndCacheImage(studyUid,imageUid, frameIndex - 1, seriesIndex);
                                }
                                var imageCanvasValue = null;
                                imagePromise.then(function(image) {
                                    imageCanvasValue = image;
                                });

                                //var imageCanvasValue = imageCanvasOfViewPorts[seriesLevelDiv];
                                
                                //On first time when the viewer is rendering the image, updatedCanvasPresentation will be undefined
                                if(updatedCanvasPresentation != null && updatedCanvasPresentation != undefined && imageCanvasValue != null) {
                                    if(imageCanvasValue.presentation.presentationMode == "MAGNIFY") {
                                        updatedCanvasPresentation.presentationMode = "MAGNIFY";
                                    }
                                    imageCanvasValue.lastAppliedWindowWidth = updatedCanvasPresentation.windowWidth;
                                    imageCanvasValue.lastAppliedwindowCenter = updatedCanvasPresentation.windowCenter;
                                    imageCanvasValue.presentation = updatedCanvasPresentation;
                                    imageCanvasValue.lastAppliedWindowLevel = updatedCanvasPresentation.windowLevel;
                                }

                                if(imageCanvasValue == null || imageCanvasValue == undefined || imageCanvasValue == ""){
                                    renderer.loadImageRenderer(imagePromise);
                                }
                                else{
                                    renderer.loadImageRenderer(imagePromise, imageCanvasValue);
                                }

                                if(isPresentationUpdationRequired &&
                                   updatedCanvasPresentation === undefined) {
                                    updatedCanvasPresentation = jQuery.extend(true, {}, renderer.presentationState);
                                    if(imageCanvasValue !== null && imageCanvasValue !== undefined) {
                                        updatedCanvasPresentation.zoom = imageCanvasValue.presentation.zoom;
                                    }
                                    isPresentationUpdationRequired = false;
                                }

                                if (column > 1 || row > 1) {
                                    dicomViewer.tools.setDicomOverLayFalse(viewport);
                                }
                            }

                            imageIndex = getImageIndexForImageUid(studyUid, seriesIndex, imageUid);
                            progressbar.setSeriesInfo(studyUid, seriesIndex, imageIndex, frameIndex - 1);
                            if (imageIndex == undefined)
                                imageIndex = 0;
                            //check the cacheFlag and start cache
                            //prevent the cache start twice while lodaing the image from loadStudy method
                            if (cacheFlag) {
                                dicomViewer.setCacheDataToCache(studyUid,seriesIndex, imageIndex);
                                dicomViewer.startCacheImages(studyUid);
                            } else {
                                cacheFlag = true;
                            }
                        }
                    }
                }
            }
        }
    }

    function getImageIndexForImageUid(studyUid,seriesIndex, imageUid) {
        var series = dicomViewer.Series.getSeries(studyUid,seriesIndex);
        for (var i = 0; i < dicomViewer.Series.getImageCount(studyUid,seriesIndex); i++) {
            if (imageUid === dicomViewer.Series.Image.getImage(studyUid,seriesIndex, i).imageUid) {
                return i;
            }
        }
    }

    function imageLoadFirst(studyUid,imageUid, seriesIndex, imageIndex) {
        var firstImageUid = dicomViewer.Series.Image.getImageUid(dicomViewer.Series.Image.getImage(studyUid,0, 0));
        if (imageUid === firstImageUid) {
            return;
        }
		
        var seriesLayout = dicomViewer.viewports.getViewport("imageviewer_studyViewer1x1_1x1");
        seriesLayout.setSeriesIndex(seriesIndex);
        seriesLayout.removeAllImageRenders();
        var studyDetails = dicomViewer.getStudyDetails(studyUid);
        seriesLayout.setImageCount(studyDetails.series[seriesIndex].imageCount);
        var imageLayout = seriesLayout.getImageLayoutDimension().split("x");
        setImageLevelLayout(studyUid, parseInt(imageLayout[0]), parseInt(imageLayout[1]), "imageviewer_studyViewer1x1_1x1", seriesLayout, seriesIndex, imageIndex, 0);
        seriesLayout.setImageIndex(imageIndex);
        seriesLayout.setFrameIndex(0);

        dicomViewer.stopCacheProgress();
        dicomViewer.setCacheDataToCache(studyUid,seriesIndex, imageIndex);
        dicomViewer.startCacheImages(studyUid);

        var viewportElementIds = dicomViewer.viewports.getViewportIds();
        for (var i = 0; i < viewportElementIds.length; i++) {
            $("#" + viewportElementIds[i]).removeClass('selected-view').addClass('default-view');
        }
        $("#" + seriesLayout.seriesLayoutId).trigger("click");

        updateThumbnailSelection(undefined, seriesIndex, imageIndex, studyUid);
    }

    /**
     * Selection the preference saved information to the ECG preference.
     */
    function updatePreferenceValues() {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var render ;
        $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function() {
            var imageLayoutId = $(this).attr('id');
            render = seriesLayout.getImageRender(imageLayoutId);
            return;
        });
        
        var windowAttr = seriesLayout.preferenceInfo.windowLevelSettings;
        if(render && render.presentationState){
            windowAttr = render.presentationState.windowLevel;
        }
        
        var zoomAttr = seriesLayout.preferenceInfo.zoomLevelSetting;
        if(render && render.presentationState) {
            zoomAttr = render.presentationState.zoomLevel+"_zoom";
        }
        
        // Update Window level settings preference information
        dicomViewer.tools.updateWindowLevelSettings(windowAttr);
        dicomViewer.tools.updateZoomLevelSettings(zoomAttr);
        if (seriesLayout.preferenceInfo === undefined || seriesLayout.preferenceInfo === null || 
            seriesLayout.preferenceInfo.preferenceData === undefined || seriesLayout.preferenceInfo.preferenceData === null)
        {
            return;
        }
        if(seriesLayout.imageType === IMAGETYPE_RADECG){
            resetContextMenuSelection();
            for(var preferenceId in preferenceList)
            {
                switch(preferenceList[preferenceId])
                {
                    case "gridtype":
                        if (seriesLayout.preferenceInfo.preferenceData.gridType !== undefined) {
                            $("#"+seriesLayout.preferenceInfo.preferenceData.gridType).parent().css("background","#868696");
                           // $("#gridtype #"+seriesLayout.preferenceInfo.preferenceData.gridType).prop("checked", true);
                        }
                    break;
                    case "gridcolor":
                        if (seriesLayout.preferenceInfo.preferenceData.gridColor !== undefined) {
                            $("#"+seriesLayout.preferenceInfo.preferenceData.gridColor).parent().css("background","#868696");
                            //$("#gridcolor #"+seriesLayout.preferenceInfo.preferenceData.gridColor).prop("checked", true);
                        }
                    break;
                    case "leadformat":
                        if (seriesLayout.preferenceInfo.preferenceData.leadFormat !== undefined) {
                            $("#"+seriesLayout.preferenceInfo.preferenceData.leadFormat).parent().css("background","#868696");
                            //$("#leadformat #"+seriesLayout.preferenceInfo.preferenceData.leadFormat).prop("checked", true);
                        }
                    break;
                    case "gain":
                        if (seriesLayout.preferenceInfo.preferenceData.gain !== undefined) {
                            $("#"+seriesLayout.preferenceInfo.preferenceData.gain).parent().css("background","#868696");
                            //$("#gain #"+seriesLayout.preferenceInfo.preferenceData.gain).prop("checked", true);
                        }
                    break;
                    case "signalthickness":
                        if (seriesLayout.preferenceInfo.preferenceData.signalThickness !== undefined) {
                            $("#"+seriesLayout.preferenceInfo.preferenceData.signalThickness).parent().css("background","#868696");
                            //$("#signalthickness #"+seriesLayout.preferenceInfo.preferenceData.signalThickness).prop("checked", true);
                        }
                    break;
                }
            }
        }
    }

    function resetContextMenuSelection() {
        $("#none").parent().css("background","");
        $("#onemm").parent().css("background","");
        $("#fivemm").parent().css("background","");

        $("#redGrid").parent().css("background","");
        $("#greenGrid").parent().css("background","");
        $("#blueGrid").parent().css("background","");
        $("#blackGrid").parent().css("background","");
        $("#greyGrid").parent().css("background","");

        $("#threebyfour").parent().css("background","");
        $("#threebyfourplusone").parent().css("background","");
        $("#threebyfourplusthree").parent().css("background","");
        $("#sixbytwo").parent().css("background","");
        $("#twelvebyone").parent().css("background","");
        $("#averagecomplex").parent().css("background","");

        $("#fivemmgain").parent().css("background","");
        $("#tenmmgain").parent().css("background","");
        $("#twentymmgain").parent().css("background","");
        $("#fourtymmgain").parent().css("background","");

        $("#onethickness").parent().css("background","");
        $("#twothickness").parent().css("background","");
        $("#threethickness").parent().css("background","");
    }

    /**
     * Enable or disable the navigation tools
     * @param {Type} imageCountFlag - Specifies the image count
     * @param {Type} seriesLayout - Specifies the active series layout
     */ 
    function enableOrDisableNavigationTools(imageCountFlag,seriesLayout) {
        var image = null;
        var studyDetails ;
        if(seriesLayout) {
          image = dicomViewer.Series.Image.getImage(seriesLayout.studyUid, seriesLayout.seriesIndex, seriesLayout.scrollData.imageIndex);
            studyDetails = dicomViewer.getStudyDetails(seriesLayout.studyUid);
        }
        if(imageCountFlag) {
            playerToolBarElement.hide();
            pdfToolBarElement.hide();
            tiffToolBarElement.hide();
            if(image && image.numberOfFrames >1 && image.imageType == IMAGETYPE_JPEG){
                tiffToolBarElement.show();
            } else{
                playerToolBarElement.show();
            }
        } else {
            playerToolBarElement.hide();
            pdfToolBarElement.hide();
            tiffToolBarElement.hide();
            if( (image && !isEmbedPdfViewer) && (image.imageType == IMAGETYPE_PDF || image.imageType == IMAGETYPE_RADPDF || image.imageType == IMAGETYPE_TIFF)) {
                pdfToolBarElement.show();
                dicomViewer.updatePaging(seriesLayout.serieslayoutId);
            } else if(image && image.imageType == IMAGETYPE_JPEG && studyDetails.seriesCount > 1){
                tiffToolBarElement.show();
            } else if(studyDetails && studyDetails.seriesCount > 1) {
                playerToolBarElement.show();
            }
            disableAllToolbarIcons();
        }
    }

    function selectViewport(event, studyUid) {
        if (event.type ==  "mousedown") {
            return;
        }

        var elementId = event.currentTarget.id;
        if(dicomViewer.measurement.isMeasurementBroken()) {
            dicomViewer.measurement.setMeasurementBroken(false);
            event.preventDefault();
        }

        /* Select the layout in the view port which is selected in the thumbnail only
        after changing the series level layout */
        var backserieslayoutid = dicomViewer.getActiveSeriesLayout();
        if(backserieslayoutid != undefined && actualSeriesIndex != 0) {
            elementId = backserieslayoutid.getSeriesLayoutId();
        }
        if (elementId === "") {
            return;
        }
        if(isViewPortDoubleClicked){
            elementId = event.currentTarget.id;
        }

        $("#" + elementId).focus();
        var studyDiv = getStudyLayoutId(elementId);        
        if(previousStudyLayout != "" || previousSaveAndLoadToolLayout != "") {
            $(previousStudyLayout).children().addClass("k-state-disabled");
            if(document.getElementById(previousSaveAndLoadToolLayout) !== null && 
               document.getElementById(previousSaveAndLoadToolLayout) !== undefined) {
               document.getElementById(previousSaveAndLoadToolLayout).style.display='none';
            }
        }
        previousSaveAndLoadToolLayout = "saveAndLoad_"+studyDiv;
        previousStudyLayout = "#menuIL"+studyDiv
        var seriesLayout = dicomViewer.viewports.getViewport(elementId);

        if(seriesLayout == undefined) {
            return;
        }
        if(seriesLayout.imageType === IMAGETYPE_RADECG || seriesLayout.imageType === IMAGETYPE_RADPDF
           || seriesLayout.imageType === IMAGETYPE_RADSR || seriesLayout.imageType === IMAGETYPE_CDA) {
            $("#menuIL"+studyDiv).children().addClass("k-state-disabled");
            if(document.getElementById(previousSaveAndLoadToolLayout) !== null && 
               document.getElementById(previousSaveAndLoadToolLayout) !== undefined) {
                document.getElementById(previousSaveAndLoadToolLayout).style.display='none';
            }
        } else {
            $("#menuIL"+studyDiv).children().removeClass("k-state-disabled");
            if(seriesLayout.imageType !== undefined) {
                if(document.getElementById(previousSaveAndLoadToolLayout) !== null && 
                   document.getElementById(previousSaveAndLoadToolLayout) !== undefined) {
                    document.getElementById(previousSaveAndLoadToolLayout).style.display='block';
                }
            }
        }

        // If the Viewport is already focused then no need to focus again.
        if ($("#" + elementId).hasClass('selected-view')) {
            if(isCineRunningOnAnyViewPort() === false) {
                var imageUid = seriesLayout.getDefaultRendererImageUid();
                if (imageUid != undefined && seriesIndex != undefined) {
                    var imageIndex = dicomViewer.Series.Image.getImageIndex(seriesIndex, imageUid)
                    dicomViewer.restartCache(seriesIndex, parseInt(imageIndex));
                }
            }

            if(seriesLayout.getSeriesIndex() !== undefined && seriesLayout.getSeriesIndex() !== null) {
                var imageValue = dicomViewer.Series.Image.getImage(seriesLayout.getStudyUid(),seriesLayout.getSeriesIndex(),0);
                var isImageThumbnails = dicomViewer.thumbnail.isImageThumbnail(imageValue);

                if(isImageThumbnails) {
                    var imageIndex = seriesLayout.scrollData.imageIndex;
                    // set the actual selected thumbnail image index value
                    if(selectThumbnailImageIndex !== undefined && selectThumbnailImageIndex != imageIndex) {
                        imageIndex = selectThumbnailImageIndex;
                    }
                    dicomViewer.thumbnail.selectImageThumbnail(seriesLayout.getSeriesIndex(), imageIndex);
                } else {
                    dicomViewer.thumbnail.selectThumbnail(seriesLayout.getSeriesIndex());
                }
            }

            //Need to enable or disable the toolbar options based on the image type.
            if(seriesLayout !== null && seriesLayout !== undefined){
                var selectedStudyUid = seriesLayout.getStudyUid();
                var selectedSeriesIndex = seriesLayout.getSeriesIndex();
                if(selectedStudyUid !== undefined && selectedSeriesIndex !== undefined){
                    var modality = dicomViewer.Series.getModality(selectedStudyUid, selectedSeriesIndex);
                    var isCinePlay = isCineRunning(seriesLayout.getSeriesLayoutId());
                    if(!isCinePlay) {
                        enableOrDisableTools(modality, seriesLayout);
                        if(event.which == 1 && dicomViewer.mouseTools.getToolName() == TOOLNAME_DEFAULTTOOL){
                            setDefaultCursorType(modality, seriesLayout);
                        }
                    }
                    else {
                        showOrHideInCineRunning(modality, isCinePlay);
                        changeToolbarIcon($("#overlayButton"), "overlay.png", "overlay.png", false);
                        changeToolbarIcon($("#dicomheaderButton_wrapper"), "header.png", "header.png", false);
                        if(modality !== 'US') {
                            UpdateToolbarIcon(false);
                        }
                    }
                }
            }

            EnableDisableReferenceLineMenu(seriesLayout);
            return;
        }        
        var seriesLayout = dicomViewer.viewports.getViewport(elementId);
        setActiveSeriesLayout(seriesLayout);
    
        if(seriesLayout !== null && seriesLayout !== undefined) {
            var tmpStudyUID = seriesLayout.getStudyUid();
            var tmpSeriesIndex = seriesLayout.getSeriesIndex();
            var tmpImageUID = seriesLayout.getDefaultRendererImageUid();
            if(tmpStudyUID !== null && tmpStudyUID !== undefined && tmpSeriesIndex !== undefined) {
                var imageCountFlag = false;
                var isImageAvailable =  dicomViewer.isImageAvilable(tmpStudyUID, tmpImageUID)
                var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(tmpStudyUID, tmpSeriesIndex);
                var multiFrameIncCount = 0;
                if(isMultiFrame) {
                    for (var i = 0; i < dicomViewer.Study.getSeriesCount(tmpStudyUID); i++) {
                        for (var j = 0; j < dicomViewer.Series.getImageCount(tmpStudyUID, i); j++) {
                          var image = dicomViewer.Series.Image.getImage(tmpStudyUID,i,j);
                          var multiFrameCount = dicomViewer.Series.Image.getImageFrameCount(image);
                            multiFrameCount == 1 ? ++multiFrameIncCount : "";
                            if(multiFrameCount > 1 || multiFrameIncCount > 1){
                                imageCountFlag = true;
                                break;
                            }
                        }
                    }
                } else if(isImageAvailable && !isMultiFrame) {
                    multiFrameIncCount = 0;
                    for (var i = 0; i < dicomViewer.Study.getSeriesCount(tmpStudyUID); i++) {
                        var imageCount = dicomViewer.Series.getImageCount(tmpStudyUID, i);
                        imageCount == 1 ? ++multiFrameIncCount : "";
                        if(imageCount > 1 || multiFrameIncCount > 1) {
                            imageCountFlag = true;
                            break;
                        }
                    }
                }
                enableOrDisableNavigationTools(imageCountFlag,seriesLayout);
            } else {
                enableOrDisableNavigationTools(0);
                disableAllToolbarIcons();
            }
        }
        updatePreferenceValues();
        $("#" + seriesLayout.getSeriesLayoutId() + " div").each(function() {
            var imageLevelId = $(this).attr('id');
            var imageRender = seriesLayout.getImageRender(imageLevelId);
            if(imageRender) {
                if(imageRender.imagePromise=== undefined) {
                    return;
                }
                imageRender.imagePromise.then(function(image) {
                    dicomViewer.showCineRate(image.dicominfo.cineRate);
                });
            }
            return false;
        });        
        if(cineManager[seriesLayout.seriesLayoutId] !== undefined) {
            if(cineManager[seriesLayout.seriesLayoutId].timer == null) {
                updatePlayIcon("stop.png", "play.png", undefined, undefined, cineManager[seriesLayout.seriesLayoutId].playStudy);
            } else {
                var parentElement = $("#playBackward").parent().css("background","");
                var parentElement = $("#playForward").parent().css("background","#868696");
                updatePlayIcon("play.png","stop.png",undefined,undefined,cineManager[seriesLayout.seriesLayoutId].playStudy);
            }
            if (cineManager[seriesLayout.seriesLayoutId].direction) {
                var parentElement = $("#playBackward").parent().css("background","");
                var parentElement = $("#playForward").parent().css("background","#868696");
            } else {
                var parentElement = $("#playForward").parent().css("background","");
                var parentElement = $("#playBackward").parent().css("background","#868696");
            }
            showCineRate(cineManager[seriesLayout.seriesLayoutId].cineRate);
            if(cineManager[seriesLayout.seriesLayoutId].playStudy) {
                var repeatButtonImage = document.getElementById("repeteOption").getElementsByTagName('img')[0];
                var repeteOption_overflow = $("#repeteOption_overflow");
                var imageSrc = repeatButtonImage.src;
                var repateOptionButton = $("#repeteOption");
                if (imageSrc.indexOf("repeat.png") > -1) {
                    repeatButtonImage.src = imageSrc.replace("repeat.png", "repeteActive.png");
                    updateToolTip(repateOptionButton, "Repeat Series");
                    updateImageOverflow(repeteOption_overflow, "images/repeat.png", "images/repeteActive.png", false);
                }
            } else {
                var repeatButtonImage = document.getElementById("repeteOption").getElementsByTagName('img')[0];
                var repeteOption_overflow = $("#repeteOption_overflow");
                var imageSrc = repeatButtonImage.src;
                var repateOptionButton = $("#repeteOption");
                if(imageSrc.indexOf("repeteActive.png") > -1) {
                    repeatButtonImage.src = imageSrc.replace("repeteActive.png", "repeat.png");
                    updateToolTip(repateOptionButton, "Repeat Study");
                    updateImageOverflow(repeteOption_overflow, "images/repeteActive.png", "images/repeat.png", true);
                }
            }
        } else {
            if (canPlayCine(seriesLayout.imageType)) {
                var playBy = dicomViewer.configuration.cine.getCinePlayerPlayBy();
                cineplayBy(playBy);
            }
        }
        var viewportElementIds = dicomViewer.viewports.getViewportIds();
        $(".selected-view").removeClass('selected-view').addClass('default-view');
        $("#" + elementId).removeClass('default-view').addClass('selected-view');
        var seriesIndex = seriesLayout.getSeriesIndex();
        if(studyUid === undefined)
            studyUid = seriesLayout.getStudyUid();
        if(studyUid === undefined) {
            dicomViewer.thumbnail.removeSelctedThumbnail();
            disableAllToolbarIcons();
            return;
        }
        if(seriesLayout.getSeriesIndex() === undefined) {
            setStudyToolBarTools(seriesLayout);
            return;
        }
        var modality = dicomViewer.Series.getModality(studyUid,seriesIndex);
        var imageValue = dicomViewer.Series.Image.getImage(studyUid,seriesIndex,0);
        var isImageThumbnails = dicomViewer.thumbnail.isImageThumbnail(imageValue);
        if(isImageThumbnails) {
            var imageIndex = seriesLayout.scrollData.imageIndex;
            // set the actual selected thumbnail image index value
            if(selectThumbnailImageIndex !== undefined && selectThumbnailImageIndex != imageIndex) {
                imageIndex = selectThumbnailImageIndex;
            }
            dicomViewer.thumbnail.selectImageThumbnail(seriesIndex, imageIndex);
        } else {
            dicomViewer.getActiveSeriesLayout().setStudyUid(studyUid);
            // set the actual selected thumbnail image index value
            if(actualSeriesIndex != 0) {
                seriesIndex = actualSeriesIndex;
            }
            dicomViewer.thumbnail.selectThumbnail(seriesIndex);
            seriesIndex = seriesLayout.getSeriesIndex();
        }
        if(isCineRunningOnAnyViewPort() == false) {
            var imageUid = seriesLayout.getDefaultRendererImageUid();
            if(imageUid != undefined) {
                var imageIndex = dicomViewer.Series.Image.getImageIndex(studyUid,seriesIndex,imageUid)
                dicomViewer.restartCache(studyUid, seriesIndex, parseInt(imageIndex));
            }
        }
        /*if(imageUid !== undefined)
        {
            var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);                
            if (dicomHeader !== undefined) {
                cineRate = dicomHeader.imageInfo.cineRate;
                if (cineRate === 0 && dicomHeader.imageInfo.numberOfFrames > 1){
                    if(myDropDown !== null)
                    {
                        if(cineManager[seriesLayout.seriesLayoutId] !== undefined && cineManager[seriesLayout.seriesLayoutId].speed !== undefined) 
                            myDropDown.value(cineManager[seriesLayout.seriesLayoutId].speed);
                        myDropDown.wrapper.show();   
                    }
                }else
                {
                    if(myDropDown !== null) myDropDown.wrapper.hide();   
                }
            }
        }*/

        //link
        dicomViewer.link.updateLinkMenu();

        if (dicomViewer.link.getLinkToolActive()) {
            if (event.which == 1 && !dicomViewer.link.isSeriesLinked()) {
                dicomViewer.link.linkSeries();
            }
        }

        if (dicomViewer.link.isSeriesLinked()) {
            var img = document.getElementById('linkButton').children[0];
            document.getElementById('linkButton_overflow').children[0].src = 'images/unlink.png';
            img.src = 'images/unlink.png';
            updateToolTip($("#linkButton"), "UnLink");
        } else {
            var img = document.getElementById('linkButton').children[0];
            document.getElementById('linkButton_overflow').children[0].src = 'images/link.png';
            img.src = 'images/link.png';
            updateToolTip($("#linkButton"), "Link");
        }

        if(copyAttributeLayoutId !== undefined && copyAttributeLayoutId.split("-")[1] == seriesLayout.studyUid &&
           copyAttributeLayoutId.split("-")[0] !== seriesLayout.getSeriesLayoutId() && isCopyAttribute == true && event.which == 1) {
            setSetCopyAttribute();
            isCopyAttribute = false;
            copyAttributeLayoutId = undefined;
        }

        dicomViewer.viewports.refreshViewports(seriesLayout);
        setStudyToolBarTools(seriesLayout);
        setDefaultCursorType(modality, seriesLayout);
        enableOrDisableTools(modality, seriesLayout);
        if(actualSeriesIndex != 0 && isImageThumbnails == false) {
            seriesIndex = actualSeriesIndex;
        }
        if(imageIndex == undefined) {
            imageIndex = seriesLayout.getImageIndex();
        }
        updateThumbnailSelection(undefined, seriesIndex, imageIndex,studyUid);
        if(isCineRunning(seriesLayout.getSeriesLayoutId())) {
           showOrHideInCineRunning(modality, true);
        }
        var imageUid = seriesLayout.getDefaultRendererImageUid();
        var imageIndex = dicomViewer.Series.Image.getImageIndex(studyUid,seriesIndex,imageUid)
        var image = dicomViewer.Series.Image.getImage(studyUid ,seriesIndex, imageIndex);

        if(image !== undefined && image !== null){
            if((dicomViewer.Series.Image.getImageFrameCount(image)>1) || dicomViewer.Series.getImageCount(seriesLayout.getStudyUid(), seriesLayout.getSeriesIndex()) > 1) {
                  if(isCineRunning(seriesLayout.getSeriesLayoutId())) {
                      dicomViewer.startCine();
                      updatePlayIcon("play.png","stop.png");
                  }
            } else {
                if (dicomViewer.isDicomStudy(seriesLayout.getStudyUid())) {
                    dicomViewer.scroll.stopCineImage(undefined);
                    updatePlayIcon("stop.png", "play.png");
                }
            }
        }

        document.getElementById(studyDiv + '_close').style.visibility = "visible";

        var imageLayout = seriesLayout.getImageLayoutDimension().split("x");
        dicomViewer.tools.changeImageLayout(parseInt(imageLayout[0]),parseInt(imageLayout[1]));
        EnableDisableReferenceLineMenu(seriesLayout);
        EnableDisableNextSeriesImage(seriesLayout);

    }

    /**
     * Copy the presentation property to copy
     */ 
    function setSetCopyAttribute()
    {
        var tempAttribute = dicomViewer.configuration.cine.getCopyAttributes();

        var activeseries = dicomViewer.getActiveSeriesLayout();
        $("#" + activeseries.getSeriesLayoutId() + " div").each(function() {
            var imageLayoutId = $(this).attr('id');
            var imageRender = activeseries.getImageRender(imageLayoutId);
            if(imageRender == undefined || imageRender == null) {
                return;
            }

            //Window level
            if(tempAttribute.windowLevel && activeseries.imageType !== IMAGETYPE_RADECHO) {
                imageRender.getPresentation().setWindowingdata(copyAttributePresentaion.presentationState.windowCenter, copyAttributePresentaion.presentationState.windowWidth);
                dicomViewer.tools.updateWindowLevelSettings(-1);
            }

            //Invert
            if(tempAttribute.invert && activeseries.imageType !== IMAGETYPE_RADECHO ) {
                imageRender.getPresentation().setInvertFlag(copyAttributePresentaion.presentationState.getInvertFlag());
            }

            //Orientation
            if(tempAttribute.orientation) {
                imageRender.presentationState.setOrientation(copyAttributePresentaion.presentationState.getOrientation());
            }
            imageRender.renderImage(false);
        });

        copyAttributePresentaion = undefined;
    }

    /**
     * Enable/Disable the cross reference line depends on the Image plane
     */ 
    function EnableDisableReferenceLineMenu(seriesLayout)
    {
        var studyuid = seriesLayout.getStudyUid();
        var studyDetials = dicomViewer.getStudyDetails(studyuid);
        if(studyDetials !== null && studyDetials !== undefined) {
            if(studyDetials.isXRefLineFound) {
                $("#scoutLine").show(); //cross reference line
                $("#scoutLine_overflow").show(); //cross reference line
                document.getElementById("context-link-crossRefLineSelector").style.display = "block"
                $("#context-link-menu").show();
            } else {
                $("#scoutLine").hide(); //cross reference line
                $("#scoutLine_overflow").hide(); //cross reference line
                document.getElementById("context-link-crossRefLineSelector").style.display = "none"
                $("#context-link-menu").hide();
            }
        }
    }

    function setStudyToolBarTools(seriesLayout)
    {
        var studyDiv = getStudyLayoutId(seriesLayout.seriesLayoutId);
        var imageLayoutDisplayId = "imageDisplay"+studyDiv;
        var seriesLayoutDisplayId = "seriesDisplay"+studyDiv;

        if(seriesLayout.getStudyUid() !== undefined && seriesLayout.getSeriesIndex() !== undefined && seriesLayout.getImageIndex() !== undefined)
        {
            var studyDetails = dicomViewer.getStudyDetails(seriesLayout.studyUid);
            if(studyDetails.isDicom == true) {
                $("#context-copyAttributes").show();
                $("#CopyAttributesPreference").show();
                $("#CopyAttributesPreference_overflow").show();
            }

            document.getElementById(seriesLayoutDisplayId).style.display= 'block';
            var imageCount = 0;
            if (seriesLayout.getImageIndex() != undefined)
            {
                imageCount = dicomViewer.Series.getImageCount(seriesLayout.getStudyUid(),seriesLayout.getSeriesIndex());
                var frameCount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(seriesLayout.getStudyUid(), seriesLayout.getSeriesIndex(), seriesLayout.getImageIndex()));
                imageCount = dicomViewer.thumbnail.isSeriesContainsMultiframe(seriesLayout.getStudyUid(), seriesLayout.getSeriesIndex()) ? frameCount : imageCount;
            }

            if( imageCount > 1 && seriesLayout.imageType !== IMAGETYPE_JPEG)
                document.getElementById(imageLayoutDisplayId).style.display= 'block';
            else 
                document.getElementById(imageLayoutDisplayId).style.display='none';
            changeIconSize();
        }
        else
        {
            document.getElementById(imageLayoutDisplayId).style.display= 'none';
            $("#CopyAttributesPreference").hide();
            $("#CopyAttributesPreference_overflow").hide();
        }
    }
    function isToolSupportByImageType(modality, imageType,seriesLayout)
    {
        var cursorType = dicomViewer.tools.getCursorType();
        if (imageType === IMAGETYPE_RADSR || imageType === IMAGETYPE_RADPDF || imageType === IMAGETYPE_RADECG || imageType === IMAGETYPE_CDA) {
            return false;
        }
        var toolName = dicomViewer.mouseTools.getToolName();
        var activeTool;
         activeTool = (activeTool = dicomViewer.mouseTools.getActiveTool().measurementData) ? activeTool.measurementSubType : undefined;

        if(toolName === "XRefLineSelectionTool"){
            var studyDetials = dicomViewer.getStudyDetails(seriesLayout.studyUid);
            if(studyDetials !== null && studyDetials !== undefined && studyDetials.isXRefLineFound) {
                dicomViewer.tools.doXRefLineSelection();
                return true;
            }
            return false;
        }

        if(imageType === IMAGETYPE_RADECHO || imageType === IMAGETYPE_JPEG)
        {
            if(toolName === TOOLNAME_PAN){
                $('#viewport_View').css('cursor','url(images/pan.cur), auto');
                var obj= {id:"pan"}
                dicomViewer.tools.doPan(obj)
                return true;
            }
            if(toolName === TOOLNAME_ZOOM){
             $('#viewport_View').css('cursor','url(images/zoom.cur), auto');
                var obj= {id:"zoomButton"}
                dicomViewer.tools.doZoom(seriesLayout.preferenceInfo.zoomLevelSetting);
                return true;
            } 
        }
        if(imageType === IMAGETYPE_RAD)
        {
            if(toolName === TOOLNAME_WINDOWLEVEL){
                $('#viewport_View').css('cursor','url(images/brightness.cur), auto');
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getWindowTool());
                return true;
            }
            if(toolName === TOOLNAME_WINDOWLEVEL_ROI){
                $('#viewport_View').css('cursor','url(images/AutoWindowLevel.cur), auto');
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getWindowToolROI());
                return true;
            }
            if(toolName === TOOLNAME_ZOOM){
                $('#viewport_View').css('cursor','url(images/zoom.cur), auto');
                var obj= {id:"zoomButton"}
                dicomViewer.tools.doZoom(seriesLayout.preferenceInfo.zoomLevelSetting);
                return true;
            }
            if(toolName === TOOLNAME_PAN){
                $('#viewport_View').css('cursor','url(images/pan.cur), auto');
                var obj= {id:"pan"}
                dicomViewer.tools.doPan(obj)
                return true;
            }
            if(toolName === TOOLNAME_LINK){
                if(dicomViewer.link.getLinkToolActive()){
                    $('#viewport_View').css('cursor','url(images/link.cur), auto');
                    dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getLinkTool());
                } else {
                    $('#viewport_View').css('cursor', 'default');
                }
                return true;
            }
        }
        if(toolName === "lineMeasurement"){
            if((cursorType != "default" && cursorType == "annotatearrow") || (cursorType=="default" && activeTool=="Arrow")) {
                var obj= {id:"10_arrow"}
                dicomViewer.tools.do2DMeasurement(obj);
            } else if((cursorType != "default" && cursorType == "annotateline") || 
                      (cursorType=="default" && activeTool=="2DLine") || (imageType === IMAGETYPE_JPEG)) {
                var obj= {id:"9_line"}
                dicomViewer.tools.do2DMeasurement(obj);
            } else if(cursorType != "default" && cursorType == "mitrallength" && modality == "US") {
                dicomViewer.tools.do2DMeasurement(0,"mitralRegurgitationLength","cm");
            } else if(cursorType != "default" && cursorType == "aorticlength" && modality == "US") {
                dicomViewer.tools.do2DMeasurement(0,"aorticRegurgitationLength","cm");
            } else if(cursorType != "default" && cursorType == "mitralthickness" && modality == "US") {
                dicomViewer.tools.do2DMeasurement(0,"mitralValveAnteriorLeafletThickness","mm");
            } else {
                $('#viewport_View').css('cursor','url(images/measuremnet.png), auto');
                var obj= {id:"0_measurement"}
                dicomViewer.tools.do2DMeasurement(obj)
            }
            return true;
        }
        if(toolName === "pointMeasurement"){
            if(cursorType != "default" && cursorType == "mitralvelocity" && modality == "US") {
                dicomViewer.tools.do2DMeasurement(1,"mitralRegurgitationPeakVelocity","m/s");
            } else if(cursorType != "default" && cursorType == "aorticregurgitationvelocity" && modality == "US") {
                dicomViewer.tools.do2DMeasurement(1,"aorticRegurgitationPeakVelocity","m/s");
            } else if(cursorType != "default" && cursorType == "aorticstenosisvelocity" && modality == "US") {
                var obj= {type:1}
                dicomViewer.tools.do2DMeasurement(1,"aorticStenosisPeakVelocity","m/s");
            } else {
                $('#viewport_View').css('cursor','url(images/measuremnet.png), auto');
                var obj= {id:"1_measurement"}
                dicomViewer.tools.do2DMeasurement(obj);
            }
            return true;
        }
        if(modality === "US" && toolName === "traceMeasurement"){
            $('#viewport_View').css('cursor','url(images/measuremnet.png), auto');
            var obj= {id:"2_measurement"}
            dicomViewer.tools.do2DMeasurement(obj)
            return true;
        }
        if(toolName === "mitralMeanGradientMeasurement"){
            if((cursorType != "default" && cursorType == "annotatefreehand") || (cursorType=="default" && activeTool == "freehand")) {
               var obj= {id:"13_freehand"}
                dicomViewer.tools.do2DMeasurement(obj)
                return true;
            } else if(cursorType != "default" && cursorType == "mitralgradient" && modality == "US"){
                dicomViewer.tools.do2DMeasurement(5,"mitralStenosisMeanGradient","mmHg");
                return true;
            }
        }
        if(toolName === "angleMeasurement"){
            $('#viewport_View').css('cursor','url(images/measuremnet.png), auto');
            var obj= {id:"angle_measurement"}
            dicomViewer.tools.do2DMeasurement(obj)
            return true;
        }

        if(toolName == "rectangleMeasurement"){
            if((cursorType != "default" && cursorType == "annotaterectangle") || (cursorType=="default" && activeTool == "rectangle")) {
                var obj= {id:"12_rectangle"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            } else if((cursorType != "default" && cursorType == "annotatetext") || (cursorType=="default" && activeTool == "text")) {
                var obj= {id:"8_text"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            } else if(modality === "CT") {
                var obj= {id:"14_measurement"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            } else {
                var obj= {id:"12_rectangle"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            }
        }

		if(toolName === "ellipseMeasurement"){
            if((cursorType != "default" && cursorType == "annotateellipse") || (cursorType=="default" && activeTool == "ellipse")) {
                var obj= {id:"11_ellipse"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            }
            else if(modality === "CT") {
                var obj= {id:"7_measurement"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            } else {
                var obj= {id:"11_ellipse"}
                dicomViewer.tools.do2DMeasurement(obj);
                return true;
            }
        }
        if(toolName === "pen") {
            var obj= {id:"15_pen"};
            dicomViewer.tools.do2DMeasurement(obj);
            return true;
        }
        return false;
    }
    function setDefaultCursorType(modality, seriesLayout){
        if(modality == undefined && seriesLayout.imageType !== IMAGETYPE_JPEG) {
            $('#viewport_View').css('cursor', 'default');
        }
        else if(!isToolSupportByImageType(modality, seriesLayout.imageType, seriesLayout))
        {
            if((modality == "US") || (seriesLayout.imageType === IMAGETYPE_JPEG) || (seriesLayout.imageType === IMAGETYPE_RADECHO)) {
                $('#viewport_View').css('cursor','url(images/pan.cur), auto');
                var obj= {id:"pan"}
                dicomViewer.tools.doPan(obj)
            } else if (isBlob(seriesLayout.imageType) || seriesLayout.imageType === IMAGETYPE_RADSR || seriesLayout.imageType === IMAGETYPE_CDA) {
                $('#viewport_View').css('cursor', 'default');
            } else if(seriesLayout.imageType === IMAGETYPE_RAD){
                $('#viewport_View').css('cursor','url(images/brightness.cur), auto');
                dicomViewer.mouseTools.setActiveTool(dicomViewer.mouseTools.getWindowTool());
            }
        }
    }
    
    function enableOrDisableTools(modality, seriesLayout) {
        if(modality == "ECG" || seriesLayout.imageType === IMAGETYPE_RADECG || seriesLayout.imageType === IMAGETYPE_RADPDF) {
            enableOrDisableNavigationTools(0,seriesLayout)
            $("#ecgPreference").prop("disabled",false);
            $("#ecgPreference").css("background-color","");
            disableOrEnableDicomTools(true);
			enableOrDisableToolsForECG();
            if(seriesLayout.imageType ===IMAGETYPE_RADPDF) {
                disbaleToolForECGPDF();
                var element = document.getElementsByName("pdfviewer1x1");
                if(element !== null) {
                    var window = element[0];
                    if(window !== undefined) {
                        window.contentWindow.document.body.focus();
                    }
                }
            }
            //enableToolsForNonDicom();
        } else if(modality === "CT"){
            disableOrEnableToolbarForCTImages();	
        } else if(modality == "US") {
            var imageCountFlag = false;
            var studyUID = seriesLayout.getStudyUid();
            var seriesIndex = seriesLayout.getSeriesIndex();
            var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUID, seriesIndex);
            if(isMultiFrame){
                    for (var i = 0; i < dicomViewer.Study.getSeriesCount(studyUID); i++){
                        for (var j = 0; j < dicomViewer.Series.getImageCount(studyUID, i); j++){
                          var image = dicomViewer.Series.Image.getImage(studyUID,i,j);
                          var multiFrameCount = dicomViewer.Series.Image.getImageFrameCount(image);
                          if(multiFrameCount > 1){
                             imageCountFlag = true;
                              break;
                          }
                        }
                    }
            } else{
                for (var i = 0; i < dicomViewer.Study.getSeriesCount(studyUID); i++){
                    var imageCount = dicomViewer.Series.getImageCount(studyUID, i);
                    if(imageCount > 1){
                       imageCountFlag = true;
                       break;	
                    }
                }
            }
			
            enableOrDisableNavigationTools(imageCountFlag,seriesLayout);
            disableToolbarForUsImages(true);
        } else if (modality === "SR" || modality === "CDA" || seriesLayout.imageType === IMAGETYPE_RADSR || seriesLayout.imageType === IMAGETYPE_CDA) {
            enableOrDisableNavigationTools(0,seriesLayout);
            disableOrEnableSRTools();
        } else if( seriesLayout.imageType === IMAGETYPE_JPEG){ 
            disableToolBarForNonDicom();
        } else if(isBlob(seriesLayout.imageType)){
            disableToolForBlob(true);
        } else if(seriesLayout.imageType === IMAGETYPE_RAD){  
            $("#ecgPreference").prop("disabled",true);
            $("#ecgPreference").css("background-color","black");
            disableOrEnableDicomTools(false);
        }
        if((!isEmbedPdfViewer && seriesLayout) && (seriesLayout.imageType == IMAGETYPE_PDF || seriesLayout.imageType == IMAGETYPE_RADPDF || seriesLayout.imageType == IMAGETYPE_TIFF)) {
            $("#zoomButton_wrapper").removeClass("k-state-disabled");
            $("#flipVButton").removeClass("k-state-disabled");
            $("#flipHButton").removeClass("k-state-disabled");
            $("#rotateButton").removeClass("k-state-disabled");
            $("#refreshButton").removeClass("k-state-disabled");
            $("#zoomButton_overflow").show();
            $("#zoomButton_overflow").addClass("k-state-disabled");
            $("#flipVButton_overflow").show();
            $("#flipHButton_overflow").show();
            $("#rotateButton_overflow").show();
            $("#refreshButton_overflow").show();
        }
    }
    
    function allowDrop(event) {        
        var viewportObject = dicomViewer.viewports.getViewport(event.currentTarget.id);
        if(viewportObject !== undefined && viewportObject.getStudyUid() != undefined && viewportObject.getStudyUid() != dragThumbnailStudyUid){
            return;
        }
        event.preventDefault();
    }

    function seriesDrop(event) { 
        dicomViewer.measurement.setMeasurementBroken(false);   
        var dragThumimageUid = event.originalEvent.dataTransfer.getData("text");
        var thumbnailRenderer = dicomViewer.thumbnail.getThumbnail($('#' + dragThumimageUid).parent().attr('id'));
        var studyUid = thumbnailRenderer.getStudyUid();
        var currentSeriesLayoutId = event.currentTarget.id;
        var checkViewport = dicomViewer.viewports.checkVewportAvailable(currentSeriesLayoutId, studyUid);
        var isUpdateViewportHeight = false;
        if( (dicomViewer.viewports.getViewport(currentSeriesLayoutId)).studyUid == undefined) {
            isUpdateViewportHeight = true;
        }

        if(!checkViewport)
        {
            return;
        }
        dragThumbnailStudyUid = undefined;	
        event.preventDefault();

        // Change the viewport selection if the current and target viewports are mismatching 
        var activeViewportStudyId = dicomViewer.getActiveSeriesLayout().getStudyUid();
        if(activeViewportStudyId !== undefined && activeViewportStudyId !== null) {
            if(activeViewportStudyId !== studyUid) {
                changeSelection(currentSeriesLayoutId);
            }
        }

        var seriesId = event.target.id;
        if (event.target.previousSibling)
        {
            var parentElemet = $('#' + event.target.previousSibling.id).parent()
            if(parentElemet[0]=== undefined)
            {
                seriesId = event.currentTarget.id;
            }
            else
            {
                seriesId = getParentElement($('#' + event.target.previousSibling.id), 'div');
            }
        }
        var studyUid = thumbnailRenderer.getStudyUid();
        var seriesLayout = dicomViewer.viewports.getViewport(seriesId);

        if (!seriesLayout)
        {
            var parentElemet = $('#' + seriesId).parent();
            if(parentElemet[0]=== undefined)
            {
                seriesId = event.currentTarget.id;
            }else{
                seriesId = getParentElement($('#' + seriesId), 'div');
            }
            seriesLayout = dicomViewer.viewports.getViewport(seriesId);
        }
        if(seriesLayout === undefined)
        {

           seriesId = dicomViewer.getActiveSeriesLayout().getSeriesLayoutId();
            seriesLayout = dicomViewer.viewports.getViewport(seriesId);
        }
        seriesLayout.setStudyUid(studyUid);
        seriesLayout.isDragAndDrop = true;
        /*When we drag and drop the image removing the value*/
        imageCanvasOfViewPorts[seriesLayout.seriesLayoutId] = undefined;
        var seriesNo = thumbnailRenderer.seriesIndex;
        var imageNumber = thumbnailRenderer.imageCountOfSeries;
        //Check the number is available while drag and drop the  thumbnail
        //Number is undefined while drag and drop the series thumbnail
        if (imageNumber == undefined) {
            imageNumber = 0;
            imageIndexNumber = 0;
        } else {
            //number is available while drag and drop the image level thumbnail
            imageNumber = imageNumber - 1;
            imageIndexNumber = imageNumber;
        }
        var image = dicomViewer.Series.Image.getImage(studyUid ,seriesNo, imageNumber);
        if(image !== undefined)
        {
            //dicomViewer.viewports.getAllViewports();            
            //$("#" + currentSeriesLayoutId).bind('mousewheel DOMMouseScroll', scroll);
            $("#" + currentSeriesLayoutId).mousedown(selectViewport); 
            $("#" + currentSeriesLayoutId).mouseover(focusActiveLayout);
            //$("#" + currentSeriesLayoutId).keydown(keyToMoveNextOrPreviousImage); 
        }
        var imageUid = dicomViewer.Series.Image.getImageUid(image);
        var imagePromise = dicomViewer.imageCache.getImagePromise(imageUid +"_"+ 0);
        if (imagePromise === undefined) {
            // Restart the cache from DND image/series if unavailable in browser cache
            dicomViewer.stopCacheProgress();
            dicomViewer.setCacheDataToCache(studyUid,seriesNo, imageNumber);
            dicomViewer.startCacheImages(studyUid);
            //To prevent cache start in the setImageLevelLayout method
            //of imageViewport.js
            cacheFlag = false;
        }

        var isSameSeries = false;
        var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesLayout.seriesIndex);
        if(!isMultiFrame) {
            if(seriesLayout.seriesIndex == parseInt(seriesNo)) {
                isSameSeries = true;
            } else {
                dicomViewer.viewports.removeDuplicateViewportsBySeriesIndex(seriesLayout.seriesLayoutId.split('_')[0] + "_" + seriesLayout.seriesLayoutId.split('_')[1] + "_" + seriesLayout.seriesIndex);
            }
        } else {
            if(seriesLayout.scrollData.imageIndex == parseInt(imageNumber)) {
                isSameSeries = true;
            } else {
                dicomViewer.viewports.removeDuplicateViewportsBySeriesIndex(seriesLayout.seriesLayoutId.split('_')[0] + "_" + seriesLayout.seriesLayoutId.split('_')[1] + "_" + seriesLayout.scrollData.imageIndex);
            }
        }

        seriesLayout.setSeriesIndex(parseInt(seriesNo));
        seriesLayout.setImageIndex(parseInt(imageIndexNumber));
        seriesLayout.setFrameIndex(0);
        seriesLayout.removeAllImageRenders();

        //Update the view port height if viewport is empty
        if (isUpdateViewportHeight) {
            var image = dicomViewer.Series.Image.getImage(seriesLayout.studyUid, seriesLayout.seriesIndex, seriesLayout.scrollData.imageIndex);
            viewportHeight(currentSeriesLayoutId,image.imageType);
            var viewportId = currentSeriesLayoutId.split("_")[1];
            createSaveAndLoadPStateGUI("saveAndLoad_"+viewportId, seriesLayout.studyUid, viewportId);
        }

        seriesLayout.setImageCount(dicomViewer.Series.getImageCount(studyUid, seriesNo));
        var imageLayout = seriesLayout.getImageLayoutDimension().split("x");
        setImageLevelLayout(studyUid, parseInt(imageLayout[0]), parseInt(imageLayout[1]), seriesId, seriesLayout, seriesNo, imageNumber, 0, true);
        if(dicomViewer.viewports.isDuplicateViewport(isMultiFrame, isMultiFrame ? imageNumber : seriesNo) && !isSameSeries) {
            dicomViewer.viewports.addDuplicateViewportsBySeriesIndex(seriesLayout.seriesLayoutId.split('_')[0] + "_" + seriesLayout.seriesLayoutId.split('_')[1] + "_" + (isMultiFrame ? imageNumber : seriesNo), seriesLayout);
        }

        var viewportElementIds = dicomViewer.viewports.getViewportIds();
        for (var i = 0; i < viewportElementIds.length; i++) {
            $("#" + viewportElementIds[i]).removeClass('selected-view').addClass('default-view');
        }
        $("#" + seriesId).trigger("click",[studyUid]);
        changeIconSize();
        dicomViewer.scroll.stopCineImage(undefined);
        changePlayDirection(); // function has implemented in viewer.cshtml
        /*if(imageUid !== undefined)
        {
            var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);                
            if (dicomHeader !== undefined) {
                cineRate = dicomHeader.imageInfo.cineRate;
                if (cineRate === 0 && dicomHeader.imageInfo.numberOfFrames > 1){
                    if(myDropDown !== null)
                    {
                        if(cineManager[seriesLayout.seriesLayoutId] !== undefined && cineManager[seriesLayout.seriesLayoutId].speed !== undefined) 
                            myDropDown.value(cineManager[seriesLayout.seriesLayoutId].speed);
                        myDropDown.wrapper.show();   
                    }
                }else
                {
                   if(myDropDown !== null) myDropDown.wrapper.hide();   
                }
            }
        }*/
        var modality = dicomViewer.Series.getModality(studyUid, seriesNo);
        if((dicomViewer.Series.Image.getImageFrameCount(image)>1) && (modality === "US" || modality === "XA")){
             dicomViewer.startCine();
            updatePlayIcon("play.png", "stop.png");
           }else{
              dicomViewer.scroll.stopCineImage(undefined);
              updatePlayIcon("stop.png", "play.png");
       }

        //Toggling the state of the Next and Previous Image/Series Button on mouse wheel click
        EnableDisableNextSeriesImage(seriesLayout);
        updatePreset(seriesLayout);
    }

     /**
     * change the preset for WL and Zoom
     * @param {Type} seriesLayout - it specifies the active series
     */ 
    function updatePreset(seriesLayout) {
        var layoutId = seriesLayout.seriesLayoutId+"ImageLevel0x0";
        var render = seriesLayout.imageRenders[layoutId];
        if(render !=undefined && render != null &&
           render.presentationState != undefined && 
           render.presentationState != null) {
            dicomViewer.tools.setZoomLevel((render.presentationState).zoomLevel);
            render.applyPan();

            var preset = (render.presentationState).windowLevel;
            dicomViewer.tools.updateWindowLevelSettings(preset);
        }
        else if(seriesLayout && seriesLayout.imageType === IMAGETYPE_RADECG)
        {
            var preferenceInfo = seriesLayout.preferenceInfo;
            var zoomsettings = preferenceInfo.zoomLevelSetting;
            zoomsettings = zoomsettings ? zoomsettings.split("_")[0] : 2 ;
            dicomViewer.tools.setZoomLevel(parseInt(zoomsettings));
        }
    }

    function loadImageFromThumbnail(seriesNo, imageNumber) {
        dicomViewer.measurement.setMeasurementBroken(false); 
		var seriesLayout = getActiveSeriesLayout();
		var studyUid = seriesLayout.getStudyUid();
        imageCanvasOfViewPorts[seriesLayout.seriesLayoutId] = undefined;
        if (imageNumber === undefined) {
            imageNumber = 0;
            imageIndexNumber = 0;
        } else {
            //number is available while drag and drop the image level thumbnail
            imageNumber = imageNumber - 1;
            imageIndexNumber = imageNumber;
        }
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesNo, imageNumber)
        var imageUid = dicomViewer.Series.Image.getImageUid(image);
        var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesLayout.seriesIndex);
        var isSameSeries = false;
        if(!isMultiFrame) {
            if(seriesLayout.seriesIndex == parseInt(seriesNo)) {
                isSameSeries = true;
            } else {
                dicomViewer.viewports.removeDuplicateViewportsBySeriesIndex(seriesLayout.seriesLayoutId.split('_')[0] + "_" + seriesLayout.seriesLayoutId.split('_')[1] + "_" + seriesLayout.seriesIndex);
            }
        } else {
            if(seriesLayout.scrollData.imageIndex == parseInt(imageNumber)) {
                isSameSeries = true;
            } else {
                dicomViewer.viewports.removeDuplicateViewportsBySeriesIndex(seriesLayout.seriesLayoutId.split('_')[0] + "_" + seriesLayout.seriesLayoutId.split('_')[1] + "_" + seriesLayout.scrollData.imageIndex);
            }
        }

        seriesLayout.setSeriesIndex(parseInt(seriesNo));
        seriesLayout.setImageIndex(parseInt(imageIndexNumber));
        seriesLayout.setFrameIndex(0);
        seriesLayout.removeAllImageRenders();
        seriesLayout.setImageCount(dicomViewer.Series.getImageCount(studyUid, seriesNo));
        var imageLayout = seriesLayout.getImageLayoutDimension().split("x");
        setImageLevelLayout(seriesLayout.studyUid, parseInt(imageLayout[0]), parseInt(imageLayout[1]), seriesLayout.seriesLayoutId, seriesLayout, seriesNo, imageNumber, 0, true);
        updatePreset(seriesLayout);
        if(dicomViewer.viewports.isDuplicateViewport(isMultiFrame, isMultiFrame ? imageNumber : seriesNo) && !isSameSeries) {
            dicomViewer.viewports.addDuplicateViewportsBySeriesIndex(seriesLayout.seriesLayoutId.split('_')[0] + "_" + seriesLayout.seriesLayoutId.split('_')[1] + "_" + (isMultiFrame ? imageNumber : seriesNo), seriesLayout);
        }
	 
        var viewportElementIds = dicomViewer.viewports.getViewportIds();
        for (var i = 0; i < viewportElementIds.length; i++) {
            $("#" + viewportElementIds[i]).removeClass('selected-view').addClass('default-view');
        }
        $("#" + seriesLayout.seriesLayoutId).trigger("click",[studyUid]);
        if(image !== undefined)
        {
            //dicomViewer.viewports.getAllViewports();            
            $("#" + seriesLayout.seriesLayoutId).mousedown(selectViewport); 
            $("#" + seriesLayout.seriesLayoutId).mouseover(focusActiveLayout);
           // $("#" + seriesLayout.seriesLayoutId).keydown(keyToMoveNextOrPreviousImage); 
        }
        dicomViewer.scroll.stopCineImage(undefined);
        changePlayDirection();
        var imagePromise = dicomViewer.imageCache.getImagePromise(imageUid +"_"+ 0);
        if(image.imageType !== IMAGETYPE_JPEG && !isBlob(image.imageType)){
        if (imagePromise === undefined) {
            // Restart the cache from DND image/series if unavailable in browser cache
            dicomViewer.stopCacheProgress();
            dicomViewer.setCacheDataToCache(studyUid,seriesNo, imageNumber);
            dicomViewer.startCacheImages(studyUid);
            //To prevent cache start in the setImageLevelLayout method
            //of imageViewport.js
            cacheFlag = false;
        }
        }
    }

    function getParentElement(child, parentTag) {
        var parent = child.parent();
        if (parent[0].tagName === parentTag.toUpperCase()) {
            return parent.attr('id');
        } else {
            return getParentElement(parent, parentTag);
        }
    }

    function setActiveSeriesLayout(seriesLayout) {
        if (seriesLayout === undefined) {
            throw "Active series layout should not be null/undefined";
        }
        activeSeriesLayout = seriesLayout;
    }

    function getActiveSeriesLayout() {
        return activeSeriesLayout;
    }

    function keyToMoveNextOrPreviousImage(event) {
        if (event.keyCode === 40) //down key
        {
            setTimeout(function() {
                moveToNextOrPreviousImage(true);
            }, 0);
        } else if (event.keyCode === 38) //Up Key
        {
            setTimeout(function() {
                moveToNextOrPreviousImage(false);
            }, 0);
        }
    }

    /**
     * check whether the image has the multiframe or not
     * @param {Type} image - it specifies the image properties
     */ 
    function canMoveSeries(image){
        if(!dicomViewer.thumbnail.canRunCine(image)) {
            return(image.modality == "US") ? true : false;
        } else {
            return true;
        }
    }

    /**
     * If the measurement is not completed then it will complete that measurement
     * @param {Type} evt - scroll event
     */ 
    function completeMeasurement(evt) {
        var toolName = dicomViewer.mouseTools.getToolName();
        if(toolName === "pointMeasurement" || toolName === "lineMeasurement" || toolName === "angleMeasurement" || 
           toolName === 'traceMeasurement' || toolName === 'volumeMeasurement' || toolName === 'ellipseMeasurement'|| 
           toolName === 'rectangleMeasurement' || toolName === 'mitralMeanGradientMeasurement') {
            tool = dicomViewer.mouseTools.getActiveTool();
            tool.hanleMouseOut(evt);
        }
    }

    function scroll(event) {
        dicomViewer.stopCacheProgress();
        completeMeasurement(event);
        var serieLayout = dicomViewer.getActiveSeriesLayout();
        if(serieLayout !== undefined && serieLayout !== null) {
            if((isToPlayStudy(serieLayout.getSeriesLayoutId()) && (isCineRunning(serieLayout.getSeriesLayoutId())))) {
                return;
            }
        }
        var studyUid = serieLayout.getStudyUid();
        var render = undefined;
        if (serieLayout.imageType === IMAGETYPE_RADSR || serieLayout.imageType === IMAGETYPE_CDA) {
            render = serieLayout.imageRenders["srReport"];
        } else {
            render = serieLayout.imageRenders[serieLayout.seriesLayoutId +"ImageLevel0x0"];
        }
        var scrollDown = event.originalEvent.wheelDelta < 0 || event.originalEvent.detail > 0;
        var playerButtomImage = document.getElementById("playButton_wrapper").getElementsByTagName('img')[0].src;
        if(serieLayout.imageType === IMAGETYPE_TIFF || serieLayout.imageType === IMAGETYPE_PDF ||serieLayout.imageType === IMAGETYPE_RADPDF || 
           serieLayout.imageType === IMAGETYPE_RADSR || serieLayout.imageType === IMAGETYPE_CDA  ||
           serieLayout.imageType === IMAGETYPE_RADECG||serieLayout.imageType === IMAGETYPE_RADPDF ||
            serieLayout.seriesIndex === undefined || render.imageIndex === undefined )
        {
            return;
        }
        var image = dicomViewer.Series.Image.getImage(studyUid, serieLayout.seriesIndex, render.imageIndex);        
        
       /* if (dicomViewer.mouseTools.getToolName() === 'Zoom') {
            return;
             //When zoom function in active disabling scroll image feature Zoom feature is based on mouse wheel event
        }*/
        var scrollDown = event.originalEvent.wheelDelta < 0 || event.originalEvent.detail > 0;
        var playerButtomImage = document.getElementById("playButton_wrapper").getElementsByTagName('img')[0].src;
        var isImageThumbnails = dicomViewer.thumbnail.isImageThumbnail(image,false);        
        if((canMoveSeries(image)) && ((isImageThumbnails && (isCineRunning(serieLayout.seriesLayoutId) || (image.numberOfFrames === 1) )) || (dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,serieLayout.seriesIndex) && image.numberOfFrames === 1)))
        {
            dicomViewer.tools.moveSeries(scrollDown);
        }
        else
        {
            moveToNextOrPreviousImage(scrollDown);
        }
		
        var firstImageFrame = $("#"+serieLayout.getSeriesLayoutId()+" div:first").attr("id");
        var imageRender = serieLayout.getImageRender(firstImageFrame);
        var currentImageIndex = null;
        var currentFrameIndex = null;
        if(imageRender != undefined)
        {
            var anUIDs = imageRender.anUIDs;
            var resultArray = anUIDs.split("*");
            currentFrameIndex = parseInt(resultArray[1]);
            currentImageIndex = imageRender.imageIndex;
        }
        serieLayout.setImageIndex(currentImageIndex);
        serieLayout.setFrameIndex(currentFrameIndex);
        dicomViewer.startCacheImages(studyUid);
        EnableDisableNextSeriesImage(serieLayout);
    }

    function getCurrentImageAndFrameIndex(moveToNext, seriesLayout)
    {
        // Frame Index must be calculate using the visibility of the ImageLevel viewports.
        var lastImageFrame;
        if (moveToNext) {
            lastImageFrame = $("#"+seriesLayout.getSeriesLayoutId()+" div:last").attr("id");
        } else {
            lastImageFrame = $("#"+seriesLayout.getSeriesLayoutId()+" div:first").attr("id");
        }
		
		/*var index = lastImageFrame.indexOf("butnDiv");
		if(index > -1){
			var splitedValue = lastImageFrame.split("butnDiv");
			lastImageFrame = splitedValue[0];
		}
*/
        var imageRender = seriesLayout.getImageRender(lastImageFrame);
        
        var imageIndex = null;
        if(imageRender != undefined)
        {
            var anUIDs = imageRender.anUIDs;
            var resultArray = anUIDs.split("*");
            var frameIndex = parseInt(resultArray[1]);

            //imageIndex = seriesLayout.getImageIndex();
            imageIndex = imageRender.imageIndex;
        }
        if (imageIndex === null || imageIndex === undefined || imageIndex === -1)
        {
            imageIndex = seriesLayout.getImageIndex();
        }
        return [imageIndex, frameIndex];
    }

    /**
     * - Move the Next or Previous Image. Boolean argument will decide whether it is move Next or Previous image. 
     */
    function moveToNextOrPreviousImage(moveToNext, linkedSeriesLayout, navigatePos, useStartPosition) {
        endMeasurement();
        var seriesLayout = undefined;
        if(linkedSeriesLayout !== undefined) {
            seriesLayout = linkedSeriesLayout;
        } else {
            seriesLayout = getActiveSeriesLayout();
        }

        var studyUid = seriesLayout.studyUid;
        var seriesIndex = seriesLayout.getSeriesIndex();
        var imageLayoutCount = seriesLayout.getImageLayoutCount();
        var numberOfImages = dicomViewer.Series.getImageCount(studyUid, seriesIndex);

        var imageAndFrameIndex = getCurrentImageAndFrameIndex(moveToNext, seriesLayout);
        var imageIndex = imageAndFrameIndex[0];
        var frameIndex = imageAndFrameIndex[1];
        
        var frameCount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex));
        if (frameCount === undefined) {
            return;
        }

        var isSeriesHasMultiframe = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex);

        var imagePos = 0;
        if (navigatePos === undefined) {
            imagePos = 1;
        } else {
            if (navigatePos.xDiff !== undefined) {
                var perImageWidth = Math.round($("#" + seriesLayout.getSeriesLayoutId()).width() / (isSeriesHasMultiframe ? frameCount : numberOfImages));
                if (navigatePos.xDiff >= perImageWidth) {
                    imagePos = Math.round(navigatePos.xDiff / perImageWidth);
                }
            } else if (navigatePos.yDiff !== undefined) {
                var perImageHeight = Math.round($("#" + seriesLayout.getSeriesLayoutId()).height() / (isSeriesHasMultiframe ? frameCount : numberOfImages));
                if (navigatePos.yDiff >= perImageHeight) {
                    imagePos = Math.round(navigatePos.yDiff / perImageHeight);
                }
            }
        }

        var lastDivId = $("#"+seriesLayout.getSeriesLayoutId()+" div:last").attr("id");
        var firstDivId = $("#"+seriesLayout.getSeriesLayoutId()+" div:first").attr("id");
        if (moveToNext) {
            if(isSeriesHasMultiframe)
            {
                var imageRenders = seriesLayout.imageRenders;
                var firstFrameIndex = -1;
                var lastFrameIndex = 0;                
                if(imageRenders !== undefined)
                {
                    var imageRender = imageRenders[firstDivId];
                    if(imageRender !== undefined)
                        firstFrameIndex = parseInt(imageRender.anUIDs.split("*")[1]);
                    imageRender = imageRenders[lastDivId]; 
                    if(imageRender !== undefined)
                        lastFrameIndex = parseInt(imageRender.anUIDs.split("*")[1]);
                    if(frameCount === lastFrameIndex+1){
                        return;
                    }else
                    {
                        if (useStartPosition) {
                            firstFrameIndex = navigatePos.frameIndex;
                        }
                        frameIndex = firstFrameIndex+imagePos;
                    }
                }
            }else
            {
                var imageRenders = seriesLayout.imageRenders;
                var lastImageIndex = 0;
                if(imageRenders !== undefined)
                {
                    var imageRender = imageRenders[firstDivId];
                    if(imageRender === undefined)
                        imageIndex = -1;
                    else
                        imageIndex = imageRender.imageIndex;
                    imageRender = imageRenders[lastDivId];
                    if(imageRender === undefined)
                        lastImageIndex = -1;
                    else 
                        lastImageIndex = imageRender.imageIndex;

                    if(numberOfImages === lastImageIndex+1)
                    {
                        return;
                    }else
                    {
                        if (useStartPosition) {
                            imageIndex = navigatePos.imageIndex;
                        }
                        imageIndex = imageIndex+imagePos;
                    }
                }
            }
            
        } else
        {            
            if(isSeriesHasMultiframe)
            {            
                var imageRenders = seriesLayout.imageRenders;
                if(imageRenders !== undefined)
                {
                    var firstFrameIndex = 1;
                    var imageRender = imageRenders[firstDivId];
                    if(imageRender !== undefined)
                        firstFrameIndex = parseInt(imageRender.anUIDs.split("*")[1]);
                    if(firstFrameIndex <= 0)
                    {
                        return;
                    }else
                    {            
                        if (useStartPosition) {
                            firstFrameIndex = navigatePos.frameIndex;
                        }
                        frameIndex = firstFrameIndex-imagePos;
                    }
                }
             }else
             {             
                var imageRenders = seriesLayout.imageRenders;
                if(imageRenders !== undefined)
                {
                    var imageRender = imageRenders[firstDivId];
                    if(imageRender !== undefined)
                        imageIndex = imageRender.imageIndex;                    
                    if(imageIndex <= 0)
                    {
                        return;
                    }else{
                        if (useStartPosition) {
                            imageIndex = navigatePos.imageIndex;
                        }
                        imageIndex = imageIndex-imagePos;
                    }
                }

             }
        }

        loadimages(seriesLayout, seriesIndex, imageIndex, frameIndex);

        // Perform the link operation
        if(linkedSeriesLayout === undefined) {
            dicomViewer.link.doLink(seriesLayout, moveToNext);
        }
        
        //Move to next frame/image
        seriesLayout.setImageIndex(imageIndex);
        seriesLayout.setFrameIndex(frameIndex);
        dicomViewer.startCacheImages(studyUid);
        
        //Enable or disable the Next/Previous series, and Next/Previous image and repeat series
        EnableDisableNextSeriesImage(seriesLayout);
    }

    function pauseCinePlay(runStatus, isAllLayout) {
        if(isAllLayout === true)
        {
            for(var key in cineManager)
            {
                if (cineManager[key] !== undefined)             
                    cineManager[key].status = runStatus;        
            }
        }else
        {
            cineManager[getActiveSeriesLayout().seriesLayoutId].status = runStatus; 
        }
        var layoutId = getActiveSeriesLayout().seriesLayoutId;        
        if(cineManager[layoutId] !== undefined && cineManager[layoutId].status === CINEPAUSE)
            showCineRate(0);
        if(isCineRunning(layoutId))
        {
           if(runStatus === CINEPAUSE)
               updatePlayIcon("stop.png","play.png");
            else
                updatePlayIcon("play.png","stop.png");
        }
    }
    
    function stopCineImage(direction, linkedSeriesLayout) {
        var activeSeriesLayout = undefined;
        if(linkedSeriesLayout !== undefined) {
            activeSeriesLayout = linkedSeriesLayout;
        } else {
            activeSeriesLayout = getActiveSeriesLayout();
        }

        // Perform the link operation
        if(linkedSeriesLayout === undefined) {
            dicomViewer.link.doLink(activeSeriesLayout, false, direction, false);
        }

        var layoutId = activeSeriesLayout.seriesLayoutId;
        var studyUid = activeSeriesLayout.getStudyUid();
        var modality = dicomViewer.Series.getModality(studyUid,activeSeriesLayout.seriesIndex);  
        if (modality === "US" || modality === "XA"){
            $('#viewport_View').css('cursor','url(images/pan.cur), auto');
            var obj= {id:"pan"}
            dicomViewer.tools.doPan(obj)
        }
        if (cineManager[activeSeriesLayout.seriesLayoutId] !== undefined) {
            clearInterval(cineManager[activeSeriesLayout.seriesLayoutId].timer);
            cineManager[activeSeriesLayout.seriesLayoutId].timer = null;
            showOrHideInCineRunning(modality, false);
        }
        showCineRate(0);
		myDropDown.wrapper.hide();
        $("#" + layoutId).focus();

        var firstImageFrame = $("#"+activeSeriesLayout.getSeriesLayoutId()+" div:first").attr("id");
        var imageRender = activeSeriesLayout.getImageRender(firstImageFrame);
        var currentImageIndex = null;
        var currentFrameIndex = null;
        if(imageRender != undefined)
        {
            var anUIDs = imageRender.anUIDs;
            var resultArray = anUIDs.split("*");
            currentFrameIndex = parseInt(resultArray[1]);
            currentImageIndex = imageRender.imageIndex;
        } else {
            currentImageIndex = activeSeriesLayout.getImageIndex();
            currentFrameIndex = activeSeriesLayout.getFrameIndex();
        }

        activeSeriesLayout.setImageIndex(currentImageIndex);
        activeSeriesLayout.setFrameIndex(currentFrameIndex);
    }

    function isCineRunning(seriesLayoutId) {
        if (cineManager[seriesLayoutId] !== undefined) {
            if (cineManager[seriesLayoutId].timer) {
                return true;
            }
        }
        return false;
    }
	
	function startCine()
	{
        var activeSeriesLayout = getActiveSeriesLayout();
		var seriesLayoutId = activeSeriesLayout.getSeriesLayoutId();
        var studyUid = activeSeriesLayout.getStudyUid();
        var modality = dicomViewer.Series.getModality(studyUid,activeSeriesLayout.seriesIndex);
         var direction = true;
        if(cineManager[seriesLayoutId] != undefined) 
            direction = cineManager[seriesLayoutId].direction;  
		if(activeSeriesLayout.imageType ===IMAGETYPE_RADECHO || modality === "XA")
		{
		  if(!isCineRunning(seriesLayoutId)){
			  runCineImage(direction);
              //showOrHideInCineRunning(modality, false);
           }  
		}
		else{
            runCineImage(direction);
            showOrHideInCineRunning(modality, true);
        }		
	}

    /**
     * Play/Stop the Cine on mouse wheel click
     */
    function toggleCineRunning() {
        endMeasurement();
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var seriesLayoutId = seriesLayout.getSeriesLayoutId();
        var studyUid = seriesLayout.getStudyUid();
        var seriesIndex = seriesLayout.getSeriesIndex();
        var imageIndex = seriesLayout.getImageIndex();
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
        var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid, seriesIndex);
        if(isMultiFrame === true) {
            imageCount = dicomViewer.Series.Image.getImageFrameCount(image);
        } else {
            imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
        }
        if((imageCount <= 1 && !dicomViewer.scroll.isToPlayStudy(seriesLayout.seriesLayoutId)) || imageCount <= 4) {
            return;
        }
        var direction = true;
        if(cineManager[seriesLayoutId] != undefined && cineManager[seriesLayoutId].direction != undefined) 
            direction = cineManager[seriesLayoutId].direction;
        if(isCineRunning(seriesLayoutId)) {
            stopCineImage(direction);
            updatePlayIcon("stop.png","play.png");
        } else {
            runCineImage(direction);
            updatePlayIcon("play.png","stop.png");
        }
        //Toggling the state of the Next and Previous Image/Series Button on mouse wheel click
        EnableDisableNextSeriesImage(seriesLayout);
    }
    
    function isCineRunningOnAnyViewPort() {
        for (var key in cineManager)
        {
            if (cineManager[key] !== undefined) {
                if (cineManager[key].timer) {
                    return true;
                }
            }
        }
        return false;
    }
    
    function showCineRate(cineRate) {
        var rate = "0";
        if (cineRate !== undefined) {
            rate = cineRate;
        }
        if(isNaN(rate)) 
            rate = 0;
        document.getElementById("cineRateDisplay").style.visibility = "hidden";
        document.getElementById("cineRateDisplay").innerHTML = Math.round(rate/1000) + " FPS";
    }

    function onCineSpeedChange() {
        var seriesLayout = getActiveSeriesLayout();
        if(cineManager[seriesLayout.seriesLayoutId] === undefined)
        {
            cineManager[seriesLayout.seriesLayoutId] = {};
        }
        cineManager[seriesLayout.seriesLayoutId].speed = $("#cineSpeedButton").val();        
    };
    
    function runCineImage(direction, linkedSeriesLayout) {
        var seriesLayout = undefined;
        if(linkedSeriesLayout !== undefined) {
            seriesLayout = linkedSeriesLayout;
        } else {
            seriesLayout = getActiveSeriesLayout();
        }

        if(seriesLayout && seriesLayout.imageType == IMAGETYPE_JPEG) {
            return;
        }

        var perviousMilliSec;
        var frameRatePerSec;
        var tempmilliSec;
        var tempdiff = 0;
        var frameCountForFPS = 0;
        var imageLayoutCount = seriesLayout.getImageLayoutCount();
        var seriesIndex = seriesLayout.getSeriesIndex();
        //var imageAndFrameIndex = getCurrentImageAndFrameIndex(direction, seriesLayout);
        var imageIndex = seriesLayout.getImageIndex();//imageAndFrameIndex[0];
		var frameIndex = seriesLayout.getFrameIndex();//imageAndFrameIndex[1];
		var studyUid = seriesLayout.studyUid;
        var modality = dicomViewer.Series.getModality(studyUid,seriesLayout.seriesIndex);
        if (modality === "US" || modality === "XA"){
            $('#viewport_View').css('cursor', 'default');
        }
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
        var frameCount = dicomViewer.Series.Image.getImageFrameCount(image);
        var imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
        var seriesCount = dicomViewer.Study.getSeriesCount(studyUid);
        var isMultiFrame = dicomViewer.thumbnail.isImageThumbnail(image);
        if (cineManager[seriesLayout.seriesLayoutId] === undefined) {
            cineManager[seriesLayout.seriesLayoutId] = {};
        }
        cineManager[seriesLayout.seriesLayoutId].direction = direction;
        cineManager[seriesLayout.seriesLayoutId].status = CINERUN;
        clearInterval(cineManager[seriesLayout.seriesLayoutId].timer); // clear interval
        
        var imageUid = dicomViewer.Series.Image.getImageUid(image);
        var dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
		var cineRate = $("#cineSpeedButton").val();
        var cineRepeatForImage = 1;
		var expectedCineRate;       
        var isSeriesHasMultiframe =  dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex);
        if (dicomHeader !== undefined) {
            cineRate = dicomHeader.imageInfo.cineRate;
            if (cineRate === 0 && dicomHeader.imageInfo.numberOfFrames > 1){
                cineRate = $("#cineSpeedButton").val();
                if(myDropDown !== null){    
                    if(cineManager[seriesLayout.seriesLayoutId] !== undefined && cineManager[seriesLayout.seriesLayoutId].speed !== undefined) 
                        myDropDown.value(cineManager[seriesLayout.seriesLayoutId].speed);
                    myDropDown.wrapper.show();   
                }
            }else{
                if(myDropDown !== null) myDropDown.wrapper.hide();
            }            
        }else
        {
            if(cineManager[seriesLayout.seriesLayoutId].speed === undefined) 
                cineRate = $("#cineSpeedButton").val();
            else 
                cineRate = cineManager[seriesLayout.seriesLayoutId].speed;
        }
        
		expectedCineRate = cineRate;
        cineRate = 1000 / cineRate;
        cineManager[seriesLayout.seriesLayoutId].cineRate = cineRate;
        cineManager[seriesLayout.seriesLayoutId].nextImageStart = true;
        seriesLayout.setSeriesIndex(seriesIndex);
        seriesLayout.setImageIndex(imageIndex);
        seriesLayout.setStudyUid(studyUid);
        showOrHideInCineRunning(modality, true);
        
        // Perform the link operation
        if(linkedSeriesLayout === undefined) {
            dicomViewer.link.doLink(seriesLayout, false, direction, true);
        }

        var moveSeries = false;
        var cineFunc = function(seriesLayout) {
            var startTime = new Date().getTime();
            if(cineManager[seriesLayout.seriesLayoutId] !== undefined && cineManager[seriesLayout.seriesLayoutId].timer !== null && cineManager[seriesLayout.seriesLayoutId].nextImageStart == true && cineManager[seriesLayout.seriesLayoutId].status === CINERUN)
            {
                cineManager[seriesLayout.seriesLayoutId].nextImageStart = false;
                var isToPlayStudyEnabled = isToPlayStudy(getActiveSeriesLayout().seriesLayoutId);
                if (frameCount === undefined) {
                    return;
                } else
                {   
                    image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
                    frameCount = dicomViewer.Series.Image.getImageFrameCount(image);
                    imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
                    isMultiFrame = dicomViewer.thumbnail.isImageThumbnail(image);
                    if(frameCount > 1) isMultiFrame = true;
                    /*if (((isMultiFrame === true && frameCount == 1) || (isMultiFrame === false && imageCount == 1)) || !isToPlayStudyEnabled && isSeriesHasMultiframe && frameCount == 1)
                    {
                        toggleCineRunning();
                        return;
                    }*/
                    
                    var isLoaded = loadimages(seriesLayout, seriesIndex, imageIndex, frameIndex,isToPlayStudyEnabled);
                    if(!isLoaded)
                    {
                        cineManager[seriesLayout.seriesLayoutId].nextImageStart = true;
                        return;
                    }
                    if(seriesLayout.getSeriesLayoutId() === dicomViewer.getActiveSeriesLayout().getSeriesLayoutId())
                    {
                        seriesLayout.setSeriesIndex(seriesIndex);
                        seriesLayout.setImageIndex(imageIndex);
                        seriesLayout.setStudyUid(studyUid);
                        if(!isNonDicomStudy(image.modality)) {
                            updateThumbnailSelection(image, seriesIndex, imageIndex, studyUid, moveSeries);
                        }
                        moveSeries = false;
                    }
                    if(!isToPlayStudyEnabled && isSeriesHasMultiframe && frameCount == 1)
                    {
                        toggleCineRunning();
                        return;
                    }
                    
                    dicomHeader = dicomViewer.header.getDicomHeader(imageUid);
                    cineRate = 50;
                    if (dicomHeader !== undefined) {
                        cineRate = dicomHeader.imageInfo.cineRate;
                        if (cineRate === 0){
                            if(cineManager[seriesLayout.seriesLayoutId].speed === undefined) cineRate = $("#cineSpeedButton").val();
                            else cineRate = cineManager[seriesLayout.seriesLayoutId].speed;
                        }
                    }else
                    {
                        if(cineManager[seriesLayout.seriesLayoutId].speed === undefined) cineRate = $("#cineSpeedButton").val();
                            else cineRate = cineManager[seriesLayout.seriesLayoutId].speed;
                    }
                    expectedCineRate = cineRate;
                    cineRate = 1000 / cineRate;
                    cineManager[seriesLayout.seriesLayoutId].cineRate = cineRate;                
                }
            
                if(isSeriesHasMultiframe && frameCount === 1 || !isSeriesHasMultiframe && imageCount === 1) {
                    if(isToPlayStudyEnabled)
                    {                    
                        cineRate = (dicomViewer.configuration.cine.getIdleTime()) * 1000;
                        //cineRate = cineRate / dicomViewer.configuration.cine.getTimesToRepeat();
                        cineManager[seriesLayout.seriesLayoutId].cineRate = cineRate;
                    }
                    else
                    {
                        return;
                    }
                }
                if (direction) {
                    if ((isMultiFrame && frameIndex < (frameCount - 1)) || (!isMultiFrame && imageIndex < (imageCount - 1))) {
                        if(isMultiFrame) {
                            frameIndex++;
                        } else {
                            imageIndex++;
                        }
                    } else {
                        var imageOrFrameCount = isMultiFrame ? frameCount : imageCount;
                        if (imageOrFrameCount <= 1 || (imageOrFrameCount > 1 && isToPlayStudyEnabled)) {
                            if(cineRepeatForImage < dicomViewer.configuration.cine.getTimesToRepeat() &&
                               imageOrFrameCount <= dicomViewer.configuration.cine.getFramesToRepeat() && imageOrFrameCount > 1)
                             {
                                cineRepeatForImage ++;
                             }
                             else
                             {
                                cineRepeatForImage = 1;
                                imageIndex++;
                                if(dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex)) {
                                    moveSeries = true;
                                }
                                image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);                            
                             }
                        }
                        var imagelayout = seriesLayout.imageLayoutDimension.split("x");
                        if(imagelayout.length == 2) {
                            if(imagelayout[0] == "2" && imagelayout[1] == "2") {
                                if (imageIndex == imageCount - 3) {
                                    imageIndex = imageCount;
                                }
                            } else if(imagelayout[0] != "1" || imagelayout[1] != "1") {
                                if (imageIndex == imageCount - 1) {
                                    imageIndex = imageCount;
                                }
                            }
                        }
                        if(!isMultiFrame && imageIndex == (imageCount - 1) && imageOrFrameCount > 1){
                            imageIndex = 0;
                        }
                        if (imageIndex >= imageCount) {
                            imageIndex = 0;
                            if (isToPlayStudyEnabled) {
                                seriesIndex++;
                                moveSeries = true;
                                if (seriesIndex >= seriesCount) seriesIndex = 0;
                                imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
                                image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
                                imageUid = dicomViewer.Series.Image.getImageUid(image);  
                                isSeriesHasMultiframe =  dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex);
                            }
                        }
                        frameIndex = 0;
                        //seriesLayout.setSeriesIndex(seriesIndex);
                        //seriesLayout.setImageIndex(imageIndex);
                        frameCount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex));
                    }
                } else {
                    if ((isMultiFrame && frameIndex > 0) ||  (!isMultiFrame && imageIndex > 0))  {
                        if(isMultiFrame) {
                            frameIndex--;
                            seriesLayout.getProgressbar().updateImagePosition(frameCount, frameIndex);
                        } else {
                            imageIndex--;
                        }
                    } else {
                        var imageOrFrameCount = isMultiFrame ? frameCount : imageCount;
                        if (imageOrFrameCount <= 1 || (imageOrFrameCount > 1 && isToPlayStudyEnabled)) {
                            if(cineRepeatForImage < dicomViewer.configuration.cine.getTimesToRepeat() && 
                           imageOrFrameCount <= dicomViewer.configuration.cine.getFramesToRepeat() && imageOrFrameCount > 1) {
                                cineRepeatForImage ++;
                            } else {
                                cineRepeatForImage = 1;
                                imageIndex--;
                            if(dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex)) {
                                moveSeries = true;
                            }
                            image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);                            
                         }
                        }
                        if(!isMultiFrame && imageIndex == 0 && imageOrFrameCount > 1){
                            imageIndex = imageCount - 1;
                        }
                        if (imageIndex < 0) {
                            if (isToPlayStudyEnabled) {
                                seriesIndex--;
                                moveSeries = true;
                                if (seriesIndex < 0) seriesIndex = seriesCount - 1;
                                imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
                                imageIndex = imageCount - 1;
                                image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
                                imageUid = dicomViewer.Series.Image.getImageUid(image);     
                                isSeriesHasMultiframe =  dicomViewer.thumbnail.isSeriesContainsMultiframe(studyUid,seriesIndex);
                            }
                            // Image count should calculate for new Series Index images.
                            imageIndex = imageCount - 1;
                        }
                        //seriesLayout.setSeriesIndex(seriesIndex);
                        //seriesLayout.setImageIndex(imageIndex);
                        frameCount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex));
                        frameIndex = frameCount - 1;
                    }
                }
                //Displaying Cine Rate for multiframe images
                if(seriesLayout.seriesLayoutId == getActiveSeriesLayout().seriesLayoutId)
                {                    
                    if (isMultiFrame && isSeriesHasMultiframe) {
                        if (frameIndex == 1) {
                            tempdiff = 0;
                            frameCountForFPS = 0;
                            if (perviousMilliSec == undefined) {
                                perviousMilliSec = new Date().getTime();
                            }
                        } else {
                            //Stop the cine and play again will go inside if 
                            if (perviousMilliSec == undefined) {
                                    perviousMilliSec = new Date().getTime();
                                    frameCountForFPS = 0;
                              } else {
                                frameCountForFPS ++;
                                var currentTime = new Date().getTime();
                                tempmilliSec = currentTime - perviousMilliSec;
                                tempdiff = tempdiff + tempmilliSec;                                 
                            }
                        }
                        if (frameIndex != 0) 
                            frameRatePerSec = Math.round((frameCountForFPS * 1000) / tempdiff);
                        else
                            frameRatePerSec = 1;                                    
                                
                        if(frameRatePerSec != undefined)
                        {
                            document.getElementById("cineRateDisplay").style.visibility = "visible";
                            if(isNaN(frameRatePerSec)) frameRatePerSec = 0;
                            document.getElementById("cineRateDisplay").innerText = Math.round(frameRatePerSec) + "/ "+Math.round(expectedCineRate) +" FPS";
                        }
                        perviousMilliSec = new Date().getTime();
                        
                    }
                    else{
                        if (imageIndex == 1) {
                            tempdiff = 0;
                            frameCountForFPS = 0;
                            if (perviousMilliSec == undefined) {
                                perviousMilliSec = new Date().getTime();
                            }
                        } else {
                            //Stop the cine and play again will go inside if 
                            if (perviousMilliSec == undefined) {
                                    perviousMilliSec = new Date().getTime();
                                    frameCountForFPS = 0;
                              } else {
                                frameCountForFPS ++;
                                var currentTime = new Date().getTime();
                                tempmilliSec = currentTime - perviousMilliSec;
                                tempdiff = tempdiff + tempmilliSec;                                 
                            }
                        }
                        if (imageIndex != 0) 
                            frameRatePerSec = Math.round((frameCountForFPS * 1000) / tempdiff);
                        else
                            frameRatePerSec = 1;                                    
                                
                        if(frameRatePerSec != undefined)
                        {
                            document.getElementById("cineRateDisplay").style.visibility = "visible";
                            if(isNaN(frameRatePerSec)) frameRatePerSec = 0;
                            document.getElementById("cineRateDisplay").innerText = Math.round(frameRatePerSec) + "/ "+Math.round(expectedCineRate) +" FPS";
                        }
                        perviousMilliSec = new Date().getTime();
                    }
                }
                
                if (seriesLayout.getProgressbar().seriesIndex != seriesIndex || seriesLayout.getProgressbar().imageIndex != imageIndex)
                    seriesLayout.getProgressbar().setSeriesInfo(studyUid, seriesIndex, imageIndex, 0);

                if(cineManager[seriesLayout.seriesLayoutId].timer != null || cineManager[seriesLayout.seriesLayoutId].timer != undefined) {
                    clearInterval(cineManager[seriesLayout.seriesLayoutId].timer); // clear interval 
                    var timeDiff = new Date().getTime() - startTime;
                     cineRate = cineRate - timeDiff;
                    if(cineRate <= 0 || (image && isNonDicomStudy(image.modality)) ) cineRate = 1;
                    cineManager[seriesLayout.seriesLayoutId].timer = setInterval(cineFunc, cineRate, seriesLayout); //50
                }
            }
        }

        cineManager[seriesLayout.seriesLayoutId].timer = setInterval(cineFunc, cineRate,seriesLayout); //50
    }

    function getImageIndex(seriesIndex, imageIndex, frameIndex) {
        while (frameIndex > 0) {
            var count = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(seriesIndex, imageIndex++));
            if (count === undefined) {
                return count;
            }
            frameIndex -= count;
        }
        return imageIndex - 1;
    }

    function getImageIndexOfFrame(studyUid, seriesIndex, imageIndex, nextFramesCount) {
        while (nextFramesCount > 0) {
            nextFramesCount -= dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, --imageIndex));
        }
        return imageIndex; //Adding one for extra deduce in while loop
    }

    function getNextDownScrollCount(seriesIndex, imageIndex, frameIndex) {
        while (frameIndex < 0) {
            frameIndex += dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(seriesIndex, --imageIndex));
        }
        return imageIndex;
    }

    function getScrollDownFrameCount(studyUid, seriesIndex, imageIndex) {
        var count = 0;
        for (var i = --imageIndex; i >= 0; i--) {
            count += dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, i));
        }
        return count;
    }

    function getNextUpScrollCount(studyUid, seriesIndex, imageIndex) {
        var count = 0;
        for (var i = imageIndex; i < dicomViewer.Series.getImageCount(studyUid, seriesIndex); i++) {
            var framecount = dicomViewer.Series.Image.getImageFrameCount(dicomViewer.Series.Image.getImage(studyUid, seriesIndex, i));
            if (framecount === undefined) {
                return count;
            }
            count += framecount;
        }
        return count;
    }

    function loadImagesInViewport(seriesLayout, seriesIndex, imageIndex, frameIndex,isToPlayStudyEnabled,imageLevelLayoutIndex){
        
        var studyUid = seriesLayout.getStudyUid();
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
        if(image === undefined)
            return;
        var frameCount = dicomViewer.Series.Image.getImageFrameCount(image);

        if (frameIndex >= frameCount) {
            logger.debug("FrameIndex is greater than FrameCount. So consider as Non Multiframe images.");
            if(frameCount <= 1 || isToPlayStudyEnabled === undefined || isToPlayStudyEnabled)
            {
                imageIndex++;
                var imageCount = dicomViewer.Series.getImageCount(studyUid, seriesIndex);
                if(imageIndex >= imageCount) imageIndex = 0;
            }
            frameIndex = 0;

            if (frameCount > 1) {
                seriesLayout.getProgressbar().setSeriesInfo(studyUid, seriesIndex, imageIndex, 0);
                dicomViewer.stopCacheProgress();
                dicomViewer.setCacheDataToCache(studyUid,seriesIndex, imageIndex);
                logger.debug("Stop the cache and try to start the cache images for new ImageIndex: "+imageIndex);
                dicomViewer.startCacheImages(studyUid);
            }
        }

        var imageLevelId = $("#" + seriesLayout.getSeriesLayoutId() + " div")[imageLevelLayoutIndex].id;
        var imageRender = seriesLayout.getImageRender(imageLevelId);
        /*if(imageRender === undefined)
        {
            if(cineManager[seriesLayout.seriesLayoutId] != undefined) 
                        cineManager[seriesLayout.seriesLayoutId].nextImageStart = true;
        }*/
        imageIndex = Math.min(imageIndex, dicomViewer.Series.getImageCount(studyUid,seriesIndex)-1);
        imageIndex = Math.max(0, imageIndex);
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
        if (image != undefined && imageRender !== undefined) {
            var imageUid = dicomViewer.Series.Image.getImageUid(image);                
            var loadImageDeferred = dicomViewer.loadAndCacheImage(studyUid,imageUid,frameIndex, seriesIndex);
            loadImageDeferred.done(function(imageCanvas) {
                var deferred = $.Deferred();
                deferred.resolve(imageCanvas);
                var anUIDs =  imageCanvas.imageUid+ "*" + imageCanvas.frameNumber;
                var newImageIndex =  parseInt( dicomViewer.Series.Image.getImageIndex(studyUid,seriesIndex, imageCanvas.imageUid));
                //For 2x2 and 1x2/2x1 image level layout Series less than 4 images and series less than 2 images respectively, should not duplicate the images in that viewport and the remaining vieport should be empty
                if(dicomViewer.Series.getImageCount(studyUid,seriesIndex) < 4 && previousImageUid == imageCanvas.imageUid && seriesLayout.imageLayoutDimension == "2x2") {
                    clearImageCanvas(imageRender);
                } else if(dicomViewer.Series.getImageCount(studyUid,seriesIndex) < 2 && previousImageUid == imageCanvas.imageUid && (seriesLayout.imageLayoutDimension == "1x2" || seriesLayout.imageLayoutDimension == "2x1")) {
                          clearImageCanvas(imageRender);
                } else 
//                    if(!(dicomViewer.Series.getImageCount(studyUid,seriesIndex)-1==newImageIndex))
                {
                    imageRender.refresh(deferred,anUIDs, false, newImageIndex, seriesIndex, isToPlayStudyEnabled);
                }
                previousImageUid = imageCanvas.imageUid;
                updateActiveProgressbar(seriesLayout, newImageIndex, imageCanvas.frameNumber);
                imageLevelLayoutIndex++;                   
                 if($("#" + seriesLayout.getSeriesLayoutId() + " div").length === imageLevelLayoutIndex)
                 {
                     seriesLayout.setSeriesIndex(seriesIndex);
                    //seriesLayout.setImageIndex(newImageIndex);
                    //seriesLayout.setFrameIndex(imageCanvas.frameNumber);
                    if(cineManager[seriesLayout.seriesLayoutId] != undefined) 
                        cineManager[seriesLayout.seriesLayoutId].nextImageStart = true;   
                 }
                // Need to increase the frameIndex or imageIndex based on modality type.
                if($("#" + seriesLayout.getSeriesLayoutId() + " div").length > 0)
                {
                    if (dicomViewer.thumbnail.isImageThumbnail(image))
                    {
                        frameIndex++;
                        logger.debug("Increased the FrameIndex to: "+frameIndex);
                    }
                    else if ((dicomViewer.Series.getImageCount(studyUid, seriesIndex) - 1) != imageIndex)
                    {
                        imageIndex++;
                        logger.debug("Increased the ImageIndex to: "+imageIndex);
                    }
                }
                 if($("#" + seriesLayout.getSeriesLayoutId() + " div").length > imageLevelLayoutIndex) {
//                      if(!(dicomViewer.Series.getImageCount(studyUid,seriesIndex)-1==newImageIndex)) {
                          loadImagesInViewport(seriesLayout, seriesIndex, imageIndex, frameIndex,isToPlayStudyEnabled,imageLevelLayoutIndex);
//                      }
                     
                 }
                    

            });

            loadImageDeferred.fail(function(){
                logger.info("Image loaded failed for "+imageIndex);
                imageLevelLayoutIndex++;
                if($("#" + seriesLayout.getSeriesLayoutId() + " div").length > imageLevelLayoutIndex)
                    loadImagesInViewport(seriesLayout, seriesIndex, imageIndex, frameIndex,isToPlayStudyEnabled,imageLevelLayoutIndex);
                if($("#" + seriesLayout.getSeriesLayoutId() + " div").length === imageLevelLayoutIndex)
                 {
                    seriesLayout.setSeriesIndex(seriesIndex);
                    seriesLayout.setImageIndex(newImageIndex);
                    seriesLayout.setFrameIndex(imageCanvas.frameNumber);
                    if(cineManager[seriesLayout.seriesLayoutId] != undefined) 
                        cineManager[seriesLayout.seriesLayoutId].nextImageStart = true;   
                 }
            });
        }
    }

    /**
     * Clearing the canvas as well as overlay and making it empty
     */
    function clearImageCanvas(imageRender) {
        try {
            var canvas = imageRender.renderWidget;
            var context = canvas.getContext("2d");
            context.save();
            context.setTransform(1, 0, 0, 1, 0, 0);
            // clear the canvas
            context.fillStyle = 'black';
            context.clearRect(0, 0, canvas.width, canvas.height);
            context.restore();

            //clear the overlay
            imageRender.showOrHideOverlay(false);
        } catch(e) {}
    }

    /**
     * Load images is used to load the image using imageIndex and FrameIndex.
     * This method will loop the Series Layout id and load the images.
     */
    function loadimages(seriesLayout, seriesIndex, imageIndex, frameIndex,isToPlayStudyEnabled) {
        var isToPlayStudyEnabled = isToPlayStudy(seriesLayout.seriesLayoutId);
        var imageLayout = $("#" + seriesLayout.getSeriesLayoutId() + " div")[0];
        if(imageLayout === undefined) {
            return false;
        }

        var imageLevelId = imageLayout.id;
        if(imageLevelId === "") return false;
        
        var viewportCount = $("#" + seriesLayout.getSeriesLayoutId() + " div").length;
        var isMultiFrame = dicomViewer.thumbnail.isSeriesContainsMultiframe(seriesLayout.studyUid, seriesIndex);
        if(viewportCount > 0) {
            if(!isMultiFrame) {
                var imageCount = dicomViewer.Series.getImageCount(seriesLayout.studyUid, seriesIndex);
                if(((imageIndex + viewportCount) >= imageCount) && imageCount > viewportCount) {
                    //Updating the image index so that the last image will not copy to other previous viewports in image level layout
                    imageIndex = imageCount - viewportCount;
                }
            }
            loadImagesInViewport(seriesLayout, seriesIndex, imageIndex, frameIndex,isToPlayStudyEnabled,0);
        }
        return true;
    }

    /**
     * Update the thumbnail selection.
     */
    function updateThumbnailSelection(image, activeSeriesIndex, activeImageIndex, studyUid, moveSeries)
    {
        var selectThumbnailId = false;
        if(image == undefined || moveSeries) {
            selectThumbnailId = true;
        }

        if (activeSeriesIndex === undefined || activeSeriesIndex === null)
        {
            logger.warn("Series Index value is becoming as null or undefined while updating thumbnail selection");
            return;
        }

        if (activeImageIndex === undefined || activeImageIndex === null)
        {
            logger.warn("Image Index value is becoming as null or undefined while updating thumbnail selection");
            return;
        }
        
        if (image === undefined || image === null)
        {
            image = dicomViewer.Series.Image.getImage(studyUid, activeSeriesIndex, activeImageIndex);
        }
        var frameCount = 0;
        if(image != undefined)
        {
        	frameCount = dicomViewer.Series.Image.getImageFrameCount(image);
        }
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
         if (frameCount > 1)
         {
            if(seriesLayout.getSeriesIndex() !== activeSeriesIndex || seriesLayout.getImageIndex() !== activeImageIndex)
            {
                logger.warn("Image Index value is becoming as null or undefined while updating thumbnail selection");
                return;
            }
         }else
         {
             if(seriesLayout.getSeriesIndex() !== activeSeriesIndex)
            {
                logger.warn("Image Index value is becoming as null or undefined while updating thumbnail selection");
                return;
            }
         }
        var thumbnailId;
        if (frameCount > 1 /*|| (seriesIndex == tempseriesIndex && tempseriesIndex != 0)*/ ) {
            thumbnailId = "imageviewer_"+dicomViewer.replaceDotValue(studyUid)+"_"+ (activeSeriesIndex) + "_thumb" + (activeImageIndex);
        } else {
            thumbnailId = "imageviewer_"+dicomViewer.replaceDotValue(studyUid)+"_"+ (activeSeriesIndex) + "_thumb";
            var element = document.getElementById(thumbnailId);
            if (element == null || element == undefined) {
                thumbnailId = "imageviewer_"+dicomViewer.replaceDotValue(studyUid)+"_" + (activeSeriesIndex) + "_thumb" + (activeImageIndex);
            }
        }

        if (!$("#" + thumbnailId).hasClass('selected-thumbnail-view')) {
            $('.selected-thumbnail-view').removeClass('selected-thumbnail-view').addClass('default-thumbnail-view');
            $("#" + thumbnailId).removeClass("default-thumbnail-view").addClass('selected-thumbnail-view');

            logger.debug(thumbnailId + " is selected for highlighting the selection");
        }

        if(selectThumbnailId && thumbnailId !== undefined) {
            dicomViewer.thumbnail.makeThumbnailVisible(thumbnailId);
        }
    }

    /**
     * Update the progress bar for the active image. The updateImagePosition method will be called the the updateImagePosition and updateCachePosition.
     */
    function updateActiveProgressbar(seriesLayout, imageIndex, frameIndex)
    {
        var seriesIndex = seriesLayout.getSeriesIndex();
		var studyUid = seriesLayout.getStudyUid();
        var image = dicomViewer.Series.Image.getImage(studyUid, seriesIndex, imageIndex);
         if (image === undefined) {
            return;
        }
        var frameCount = dicomViewer.Series.Image.getImageFrameCount(image);
        if (frameCount === undefined) {
            return;
        }
        if (frameCount > 1) {
            seriesLayout.getProgressbar().updateImagePosition(frameCount, frameIndex);
        } else {
            seriesLayout.getProgressbar().updateImagePosition(dicomViewer.Series.getImageCount(studyUid, seriesIndex), imageIndex);
        }
    }

    /**
     * Setting the Cine play mode as well as the direction of the cine play
     * @param {Type} studyPlayBy - Cine play mode type (Stack/Study)
     */
    function setCinePlayBy(studyPlayBy) {
        var seriesLayout = getActiveSeriesLayout();
        if (cineManager[seriesLayout.seriesLayoutId] === undefined) {
            cineManager[seriesLayout.seriesLayoutId] = {};
        }
        
        var direction = getPlayerDirection();
        setCineDirection(direction);

        if(studyPlayBy === "Study") {
            cineManager[seriesLayout.seriesLayoutId].playStudy = true;
            dicomViewer.configuration.cine.setCinePlayerPlayBy("Study");
        } else {
            cineManager[seriesLayout.seriesLayoutId].playStudy = false;
            dicomViewer.configuration.cine.setCinePlayerPlayBy("Stack");
        }
    }
    
    function isToPlayStudy(layoutId) {
        if (cineManager[layoutId] === undefined || cineManager[layoutId].playStudy === undefined) {
            return false;
        }
        return cineManager[layoutId].playStudy;
    }

    function setCineDirection(direction) {
        var seriesLayout = getActiveSeriesLayout();
        if (cineManager[seriesLayout.seriesLayoutId] === undefined) {
            cineManager[seriesLayout.seriesLayoutId] = {};
        }
        cineManager[seriesLayout.seriesLayoutId].direction = direction;
    }

    function removeCineManager(serieslayoutId) {        
        if (cineManager[serieslayoutId] !== undefined) {
            clearInterval(cineManager[serieslayoutId].timer);
            delete cineManager[serieslayoutId];
        }       
    }
    
    function getimageCanvasOfViewPort(seriesLayout) {
        return imageCanvasOfViewPorts[seriesLayout];
    }

    function removeimageCanvasOfViewPort(seriesLayout) {
        imageCanvasOfViewPorts[seriesLayout] = undefined;
    }
    
    function removeimageCanvasOfAllViewPorts(studyLayoutId) {        
        for(var key in imageCanvasOfViewPorts){
			var index =  key.indexOf(studyLayoutId);
			if(index >= 0){
			
				delete imageCanvasOfViewPorts[key];
				}
			}
    }
    
    function removeimageCanvasOfAllBackupViewPorts(studyLayoutId) {        
        for(var key in imageCanvasOfBackupViewPorts){
			var index =  key.indexOf(studyLayoutId);
			if(index >= 0){
			
				delete imageCanvasOfBackupViewPorts[key];
				}
			}
    }
    
    function setimageCanvasOfViewPort(layoutId, imageCanvas) {
        if(imageCanvas === undefined) delete imageCanvasOfViewPorts[layoutId];
        else imageCanvasOfViewPorts[layoutId] = imageCanvas;
    }

    function removeimageCanvasOfViewPort(layoutId) {
        delete imageCanvasOfViewPorts[layoutId];
    }
    
    function getimageCanvasOfBackupViewPort(seriesLayout) {
        return imageCanvasOfBackupViewPorts[seriesLayout];
    }

    function setimageCanvasOfBackupViewPort(layoutId, imageCanvas) {
        imageCanvasOfBackupViewPorts[layoutId] = imageCanvas;
    }
    
    function removeimageCanvasOfBackupViewPort(layoutId) {
        delete imageCanvasOfBackupViewPorts[layoutId];
    }
    
    function getCurrentSeriesLayoutIds() {
        return currentSeriesLayoutIds;
    }

    function convertDicomDateToDisplayFormat(value) {
        var dicomDate = dicomViewer.changeNullToEmpty(value);
        var displayDate = "";
        if (dicomDate !== "" && dicomDate.length === 8) {
            displayDate = dicomDate.substring(0,4) + "-" + dicomDate.substring(4, 6) + "-" + dicomDate.substring(6,8);
        }

        return displayDate;
    }
	function changeSelection(layoutId)
	{
		var obj={currentTarget:{id:layoutId}}
		selectViewport(obj);
	}

    /**
    * Apply the preference info zoom level setting from display settings.
    * @param {Type} studyUid - Study Uid
    * @param {Type} preferenceInfo - Preference Info object
    * @param {Type} seriesIndex - series Index
    */
    function ApplyDisplaySettings(studyUid, preferenceInfo, seriesIndex) {
        try
        {
            // Apply the display settings
            var displaySettings = undefined;
            var series = dicomViewer.Series.getSeries(studyUid, seriesIndex);
            if(series !== undefined && series.displaySettings !== undefined) {
                displaySettings = series.displaySettings;
            }

            //Apply the zoom level settings
            preferenceInfo.zoomLevelSetting = (displaySettings === undefined ? preferenceInfo.zoomLevelSetting : displaySettings.ZoomMode);
        }
        catch(e)
        { }
    }

    /**
     * Set the rearranged series positions while changing the series layout
     * @param {Type} positions 
     */ 
    function setReArrangedSeriesPositions(positions) {
        try
        {
            multiFrameImageIndex = 0;
            actualSeriesIndex = 0;
            selectThumbnailImageIndex = undefined;
            isViewPortDoubleClicked = false;
            if(positions !== undefined) {
                multiFrameImageIndex = positions.multiFrameImageIndex;
                actualSeriesIndex = positions.actualSeriesIndex;
                selectThumbnailImageIndex = positions.selectThumbnailImageIndex;
                isViewPortDoubleClicked = positions.isViewPortDoubleClicked;
            }
        }
        catch(e)
        { }
    }
    
    /**
     * Remove the study from study level layout map
     * @param {Type} studyUid
     */ 
    function RemoveStudyLevelLayout(studyUid){
        if(studyUid != undefined){
            if(seriesLayoutMap.has(studyUid)){
                seriesLayoutMap.set(studyUid, undefined);
            }
        }
    }
    
    /**
     * Play the repeat cine manager
     */ 
    function playRepeatCineManager(){
        var allViewports =  dicomViewer.viewports.getAllViewports();
        if(allViewports === null || allViewports === undefined) {
            return;
        }

        $.each(allViewports, function(key, value) {
            if(value.studyUid != undefined && value.seriesIndex != undefined ) {
                for (var x in repeatCineManager) {
                    if(x == value.seriesLayoutId) {
                        var obj ={};
                        obj.id = "playButton";
                        dicomViewer.setActiveSeriesLayout(value);
                        updatePlayIcon("stop.png","play.png");
                        if(repeatCineManager[x].playStudy && repeatCineManager[x].timer != null){
                            playCineImage(obj,undefined);
                            setCinePlayBy("Study");
                        } else if(repeatCineManager[x].playStudy && repeatCineManager[x].timer == null){
                            setCinePlayBy("Study");
                        } else if(!repeatCineManager[x].playStudy && repeatCineManager[x].timer != null){
                            playCineImage(obj,undefined);
                            setCinePlayBy("Stack");
                        } else if(!repeatCineManager[x].playStudy && repeatCineManager[x].timer == null){
                            setCinePlayBy("Stack");
                        }
                    }
                }
            }
        });

        for (var x in repeatCineManager) {
            delete repeatCineManager[x];
        }
    }

    /**
     * save the presentation
     * @param {Type} e - click event properties
     * @param {Type} viewportId - specifies the viewport Id
     */ 
    function savePState(e, viewportId) {
        ConfirmDialog('Do you want to save this presentation', "save", e, viewportId);
    }

    /**
     * load the prensentaion
     * @param {Type} e - click event properties
     */ 
    function loadPState(e) {
        loadPStateConfirm(e);
    }

    /**
     * Create the presentation current User PState Menu
     * @param {Type} studyUid - Specifies the study Uid
     * @param {Type} studyLayoutId - Specifies the study layout Id
     */ 
    function getUserPStateMenu(studyUid, studyLayoutId) {
        try
        {
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === null ||
               studyDetails.PStates === undefined || studyDetails.PStates === null) {
                return "";
            }

            if(studyDetails.PStates.All.length == 0) {
                return "";
            }

            var menuIncrementer = 0;
            var currentUserPStateSeperatorId = studyUid+"_CUPState";
            var content = '<li class="k-separator" id="'+currentUserPStateSeperatorId+'"></li>';
            studyDetails.PStates.All.forEach(function(pState) {
                if(!pState.isOtherUser) {
                    pState.menuId = menuIncrementer;
                    var input = "loadPSSubmenu_"+studyLayoutId+"_"+pState.id+"_"+studyUid;
                    var id ="loadPSSubmenu_"+studyLayoutId+"_"+(menuIncrementer++);
                    content += '<li id="'+id+'"><a href="#" onclick=dicomViewer.loadPState("'+input+'")>'+pState.name+'</a></li>'
                }
            });

            var isOtherUserFound = studyDetails.PStates.All.filter(function(o) { return o.isOtherUser === true; })[0];
            if(!isOtherUserFound) {
                return content;
            }

            var isLoginUserFound = studyDetails.PStates.All.filter(function(o) { return !o.isOtherUser === true; })[0];
            var otherUserPStateSeperatorId = studyUid+"_OUPState";

            if(isLoginUserFound) {
                content += '<li class="k-separator" id="'+otherUserPStateSeperatorId+'">';
            }

            content += '<li>Other User<ul>';
            studyDetails.PStates.All.forEach(function(pState) {
                if(pState.isOtherUser) {
                    pState.menuId = menuIncrementer;
                    var input = "loadPSSubmenu_"+studyLayoutId+"_"+pState.id+"_"+studyUid;
                    var id ="loadPSSubmenu_"+studyLayoutId+"_"+(menuIncrementer++);
                    content += '<li id="'+id+'"><a href="#" onclick=dicomViewer.loadPState("'+input+'")>'+pState.name+'</a></li>'
                }
            });
            content +='</ul></li>'

            return content;
        }
        catch(e)
        { }

        return "";
    }

    /**
     * update the load button when save the presentaion
     * @param {Type} studyUid - It specifies the selected viewport study id
     */ 
    function updatePState(studyUid) {
        try
        {
            var viewportToolbarId = (dicomViewer.getActiveSeriesLayout().seriesLayoutId).split("_")[1];
            var viewportToolbar = "saveAndLoad_"+viewportToolbarId;
            createSaveAndLoadPStateGUI(viewportToolbar,studyUid,viewportToolbarId);
        }
        catch(e)
        { }
    }

    /**
     * Create the kendo save and load button GUI
     * @param {Type} viewportToolbarId - It specifies the viewport id
     * @param {Type} studyUid - It specifies the selected viewport study id
     * @param {Type} studyLayoutId - It specifies the viewport layout id 
     */ 
    function createSaveAndLoadPStateGUI(viewportToolbarId, studyUid, studyLayoutId) {
        try
        {
            document.getElementById(viewportToolbarId).innerHTML = "";
            var userPStateMenuContent = getUserPStateMenu(studyUid, studyLayoutId);
            var saveId = "savePState_"+studyUid;
            var editId = "editPState_"+studyUid;
            var newId = "newPState_"+studyUid;
            var deleteId = "deletePState_"+studyUid;
            var saveAndLoadMenu = "saveAndLoadPStateMenu_"+studyLayoutId;

            var content = '<html><body><ul id="'+saveAndLoadMenu+'" style="display:block;background: transparent">'
            +'<li><img src =images/loadPState.png ><ul>'
            +'<li id="'+dicomViewer.replaceDotValue(saveId)+'"><a href="#" onclick=dicomViewer.savePState("'+saveId+'","'+studyLayoutId+'")>Save</a></li>'
            +'<li id="'+dicomViewer.replaceDotValue(editId)+'"><a href="#" onclick=dicomViewer.editPState("'+editId+'")>Edit</a></li>'
            +'<li id ="'+dicomViewer.replaceDotValue(newId)+'"><a href="#" onclick=dicomViewer.newPState("'+newId+'")>New</a>'
            +'<li id="'+dicomViewer.replaceDotValue(deleteId)+'"><a href="#" onclick=dicomViewer.deletePState("'+deleteId+'")>Delete</a></li>'
            +'</li>'+userPStateMenuContent+'</body></html>'

            $("#"+viewportToolbarId).html(content);

            $("#"+saveAndLoadMenu).kendoMenu({
                animation: { open:{ effects: "fadeIn" } }
            });
            selectPState(studyUid, studyLayoutId);
        }
        catch(e)
        { }
    }

    /**
     * Select the PState
     * @param {Type} studyUid - Specifies the study Uid
     * @param {Type} studyUid - Specifies the study layout id
     */ 
    function selectPState(studyUid, studyLayoutId) {
        try
        {
            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            if(studyDetails.PStates === undefined || studyDetails.PStates === null) {
                enableOrDisablePStatesMenu(studyDetails, studyLayoutId);
                return;
            }

            var selectedPStateId = 0;
            var menuIncrementer=0;
            var menuId = "#loadPSSubmenu_"+studyLayoutId+"_";
            studyDetails.PStates.All.forEach(function(pState) {
                if(pState.id === studyDetails.PStates.Active.id) {
                    selectedPStateId = pState.menuId;
                }

                $(menuId+menuIncrementer++).css("background-color", "#363636");
            });

            if(studyDetails.PStates.Active.isEmpty !== true) {
                $(menuId + selectedPStateId).css("background","#868696");
            }

            var activePStateName = studyDetails.PStates.Active.name;
            var isDirty = studyDetails.PStates.Active.isDirty;
            if(studyDetails.PStates.Active.isNew) {
                isDirty = false;
            }

            var innerHtml = ($(menuId + selectedPStateId)[0].innerHTML).replace("*","");
            var updatedText = isDirty ? activePStateName+"<font color='red' size=4>*</font>" : "<font color='white'>"+activePStateName+"</font>";
            innerHtml = innerHtml.replace(studyDetails.PStates.Active.name,updatedText);
            $(menuId + selectedPStateId)[0].innerHTML = innerHtml;

            // Enable/ Disable the PState menu items
            enableOrDisablePStatesMenu(studyDetails, studyLayoutId);
        }
        catch(e)
        { }
    }

    /**
     * editPState the PState
     * @param {Type} studyUid - Specifies the study Uid
     * @param {Type} studyUid - Specifies the study layout id
     */ 
    function editPState(e) {
        try
        {
            dicomViewer.measurement.editPState(e);
        }
        catch(e)
        { }
    }

    /**
     * newPState the PState
     * @param {Type} e - click event properties
     */ 
    function newPState(e) {
        dicomViewer.measurement.newPState(e);
    }

    /**
     * deletePState the PState
     * @param {Type} e - click event properties
     */ 
    function deletePState(e) {
        deletePStateConfirm(e);
    }

    /**
     * Enable or disable the PState menu and its click events
     * @param {Type} studyDetails - Specifies the study details
     * @param {Type} studyLayoutId - Specifies the study layout id
     */ 
    function enableOrDisablePStatesMenu(studyDetails, studyLayoutId) {
        try
        {
            if(studyDetails == undefined || studyDetails == null) {
                return;
            }

            var studyUid = studyDetails.studyUid;
            var disableAllExceptSave = undefined;
            var disableEditNew = undefined;
            var isEditable = undefined;
            var enableAllExceptSave = undefined;
            var disableAll = undefined;
            var isEmptyActivePState = undefined;

            if(studyDetails.PStates == undefined || studyDetails.PStates == null) {
                disableAll = true;
            } else if(studyDetails.PStates.Active.isEditable == false) {
                disableAllExceptSave = false;
                disableEditNew = false;
                isEditable = false;
            } else if(studyDetails.PStates.Active.isNew == true) {
                disableAllExceptSave = false;
                disableEditNew = true;
            } else if(studyDetails.PStates.Active.isDirty == false) {
                enableAllExceptSave = true;
            } else if(studyDetails.PStates.Active.isEmpty == true) {
                isEmptyActivePState = true;
            }

            document.getElementById("saveAndLoadPStateMenu_" + studyLayoutId).style.display = disableAll ? "none" : "block";
            var saveId = "#savePState_"+dicomViewer.replaceDotValue(studyUid);
            var editId = "#editPState_"+dicomViewer.replaceDotValue(studyUid);
            var newId = "#newPState_"+dicomViewer.replaceDotValue(studyUid);
            var deleteId = "#deletePState_"+dicomViewer.replaceDotValue(studyUid);

            $(saveId).removeClass("k-state-disabled");
            $(editId).removeClass("k-state-disabled");
            $(newId).removeClass("k-state-disabled");
            $(deleteId).removeClass("k-state-disabled");

            $(saveId)[0].style.pointerEvents = 'auto';
            $(newId)[0].style.pointerEvents = 'auto';
            $(editId)[0].style.pointerEvents = 'auto';
            $(deleteId)[0].style.pointerEvents = 'auto';

            if(disableAllExceptSave == true) {
                $(newId).addClass("k-state-disabled");
                $(editId).addClass("k-state-disabled");
                $(deleteId).addClass("k-state-disabled");

                $(newId)[0].style.pointerEvents = 'none';
                $(editId)[0].style.pointerEvents = 'none';
                $(deleteId)[0].style.pointerEvents = 'none';
            } else if(disableEditNew == true) {
                $(newId).addClass("k-state-disabled");
                $(editId).addClass("k-state-disabled");

                $(newId)[0].style.pointerEvents = 'none';
                $(editId)[0].style.pointerEvents = 'none'

                if(studyDetails.PStates.Active.isDirty !== true) {
                    $(saveId).addClass("k-state-disabled");
                    $(saveId)[0].style.pointerEvents = 'none';
                }
            } else if(isEditable == false) {
                $(editId).addClass("k-state-disabled");
                $(saveId).addClass("k-state-disabled");
                $(deleteId).addClass("k-state-disabled");

                $(editId)[0].style.pointerEvents = 'none';
                $(saveId)[0].style.pointerEvents = 'none';
                $(deleteId)[0].style.pointerEvents = 'none';
            } else if(enableAllExceptSave == true) {
                $(saveId).addClass("k-state-disabled");
                $(saveId)[0].style.pointerEvents = 'none';
            } else if(disableAll === true || isEmptyActivePState === true) {
                $(newId).addClass("k-state-disabled");
                $(editId).addClass("k-state-disabled");
                $(deleteId).addClass("k-state-disabled");
                $(saveId).addClass("k-state-disabled");

                $(newId)[0].style.pointerEvents = 'none';
                $(editId)[0].style.pointerEvents = 'none';
                $(deleteId)[0].style.pointerEvents = 'none';
                $(saveId)[0].style.pointerEvents = 'none';
            }

            var toolTipText = (disableAll == true ? "" : "Save/Load presentation state");
            updateToolTip($("#saveAndLoad_"+studyLayoutId), toolTipText, "top");
        }
        catch(e)
        { }
    }
    
    /**
     * Confirmation dialog for presentation state
     * @param {Type} message - Specifies the confirmation message
     * @param {Type} state - Specifies the presentation state
     * @param {Type} e - Specifies the event arguments
     * @param {Type} viewportId - Specifies the viewport Id
     * @param {Type} studyDetails - Specifies the study details
     */ 
    function ConfirmDialog(message, state, e, viewportId, studyDetails) {
        try
        {
            $('<div></div>').appendTo('body')
            .html('<div><h6>'+message+'?</h6></div>')
            .dialog({
                modal: true, title: 'HTML5 Viewer', zIndex: 10000, autoOpen: true,
                width: 'auto', resizable: false,
                buttons: {
                    "Yes": function() {
                        $(this).dialog('close');
                        selectPresentationState(state, e, viewportId, studyDetails);
                    },
                    "No":  function() {
                        $(this).dialog('close');
                        if(state == "save&load"){
                            selectPresentationState("load", e);
                        }
                    },
                },
                close: function (event, ui) {
                    $(this).remove();
                }
            });
        }
        catch(e)
        { }
    };
    
    /**
     * Select the presentation state
     * @param {Type} state - Specifies the presentation state
     * @param {Type} e - Specifies the event arguments
     * @param {Type} viewportId - Specifies the viewport Id
     * @param {Type} studyDetails - Specifies the study details
     */ 
    function selectPresentationState(state, e, viewportId, studyDetails){
        try
        {
            switch(state){
                case "save":
                    dicomViewer.measurement.savePState(
                    {
                        studyUid: e.split("_")[1],
                        isPrivate: false,
                        isEditable: true,
                        isNew: false,
                        viewportId: viewportId
                    });
                    break;
                case "load":
                    dicomViewer.measurement.loadPState(e.split("_")[3], e);
                    break;
                case "delete":
                    dicomViewer.measurement.deletePState(e);
                    break;
                case "untitledDelete":
                    dicomViewer.measurement.saveOrDeleteUnSavedPState(studyDetails, false);
                    break;
                case "save&load":
                     dicomViewer.measurement.savePState(
                    {
                        studyUid: e.split("_")[3],
                        isPrivate: false,
                        isEditable: true,
                        isNew: false,
                        viewportId: viewportId
                    });
                    dicomViewer.measurement.loadPState(e.split("_")[3], e);
                    break;
            }
        }
        catch(e)
        { }
    }

     /**
     * delete the PState based on the presentation
     * @param {Type} e - Specifies the event arguments
     */ 
    function deletePStateConfirm(e){
        try
        {
            var studyUid = e.split("_")[1];
            if(studyUid === undefined || studyUid === null) {
                // Invalid parameters
                return;
            }

            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            if(studyDetails.PStates == undefined || studyDetails.PStates == null) {
                // Invalid presentation state 
                return;
            }

            if(studyDetails.PStates.Active.isNew == true) {
                ConfirmDialog("Do you want to discard the untitled presentation state", "untitledDelete", e, undefined, studyDetails);
                return;
            }

            ConfirmDialog("Do you want to delete the current presentation state", "delete", e);
        }
        catch(e)
        { }
    }

    /**
     * load the PState based on the presentation state
     * @param {Type} e - Specifies the event arguments
     */ 
    var disabePStateConfirmMessage = true;
    function loadPStateConfirm(e){
        try
        {
            var studyUid = e.split("_")[3];
            if(studyUid === undefined || studyUid === null) {
                // Invalid parameters
                return;
            }

            var studyDetails = dicomViewer.getStudyDetails(studyUid);
            if(studyDetails === undefined || studyDetails === undefined) {
                // Invalid study details
                return;
            }

            if(studyDetails.PStates == undefined || studyDetails.PStates == null) {
                // Invalid presentation state 
                return;
            }

            if(studyDetails.PStates.Active.isDirty == true) {
                ConfirmDialog("Current presentation is edited.<br>Do you want to save the current presentation and load the selected one", "save&load", e, e.split("_")[1]);
                return;
            } else {
                if(disabePStateConfirmMessage) {
                    dicomViewer.measurement.loadPState(e.split("_")[3], e, undefined, false);
                } else {
                    ConfirmDialog('Do you want to load this presentation', "load", e);
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * end the unfinished measurement
     */ 
    function endMeasurement () {
        try
        {
            if(dicomViewer.measurement.isEditMeasurement()) {
                var tool = dicomViewer.mouseTools.getActiveTool();
                var event = {};
                event.type = "dblclick" ;
                event.which = 1;
                tool.hanleDoubleClick(event);
            }
        }
        catch(e)
        { }
    }

    /**
     * check the study is dicom or non dicom
     */ 
    function isNonDicomStudy (modality) {
        try
        {
            if(modality == "" || modality == undefined ||
               modality == null || modality == "ECG" || 
               modality == "SR" || modality == "CDA" || 
               modality == "General") {
                return true;
            }
            return false;
        }
        catch(e)
        { }
    }

    dicomViewer.convertDicomDateToDisplayFormat = convertDicomDateToDisplayFormat;
    dicomViewer.getCurrentSeriesLayoutIds = getCurrentSeriesLayoutIds;
    dicomViewer.setImageLevelLayout = setImageLevelLayout;
	dicomViewer.imageLoadFirst = imageLoadFirst;
    dicomViewer.setSeriesLayout = setSeriesLayout;
	dicomViewer.setStudyLayout = setStudyLayout;
    dicomViewer.refreshStudyLayout = refreshStudyLayout;
	dicomViewer.createStudyViewport = createStudyViewport;
	dicomViewer.loadStudyInNextViewport = loadStudyInNextViewport;
    dicomViewer.getActiveSeriesLayout = getActiveSeriesLayout;
    dicomViewer.setActiveSeriesLayout = setActiveSeriesLayout;
    dicomViewer.showCineRate = showCineRate;
    dicomViewer.pauseCinePlay = pauseCinePlay;
	dicomViewer.setStudyToolBarTools = setStudyToolBarTools;
    dicomViewer.scroll = {
        moveToNextOrPreviousImage : moveToNextOrPreviousImage,
        getCurrentImageAndFrameIndex : getCurrentImageAndFrameIndex,
        runCineImage : runCineImage,
        stopCineImage : stopCineImage,        
        setCineDirection : setCineDirection,
        loadimages : loadimages,
        isCineRunning : isCineRunning,
		toggleCineRunning : toggleCineRunning,
        isToPlayStudy : isToPlayStudy,
        setCinePlayBy : setCinePlayBy
    };
    dicomViewer.getimageCanvasOfViewPort = getimageCanvasOfViewPort;
    dicomViewer.getimageCanvasOfBackupViewPort = getimageCanvasOfBackupViewPort;
    dicomViewer.setimageCanvasOfBackupViewPort = setimageCanvasOfBackupViewPort;
    dicomViewer.removeimageCanvasOfAllViewPorts = removeimageCanvasOfAllViewPorts;
    dicomViewer.setimageCanvasOfViewPort = setimageCanvasOfViewPort;
    dicomViewer.removeimageCanvasOfViewPort = removeimageCanvasOfViewPort;
    dicomViewer.removeimageCanvasOfBackupViewPort = removeimageCanvasOfBackupViewPort;
    dicomViewer.loadImageFromThumbnail = loadImageFromThumbnail;
    dicomViewer.getImageIndexForImageUid = getImageIndexForImageUid;
	dicomViewer.startCine = startCine;
    dicomViewer.onCineSpeedChange = onCineSpeedChange;
	dicomViewer.changeSelection = changeSelection;
    dicomViewer.removeCineManager = removeCineManager;
    dicomViewer.removeimageCanvasOfAllBackupViewPorts = removeimageCanvasOfAllBackupViewPorts;
    dicomViewer.IsFullScreenMode = IsFullScreenMode;
    dicomViewer.setReArrangedSeriesPositions = setReArrangedSeriesPositions;
    dicomViewer.setDefaultCursorType = setDefaultCursorType;
    dicomViewer.RemoveStudyLevelLayout = RemoveStudyLevelLayout;
    dicomViewer.playRepeatCineManager = playRepeatCineManager;
    dicomViewer.savePState = savePState;
    dicomViewer.loadPState = loadPState;
    dicomViewer.updatePState = updatePState;
    dicomViewer.deletePState = deletePState;
    dicomViewer.editPState = editPState;
    dicomViewer.newPState = newPState;
    dicomViewer.createSaveAndLoadPStateGUI = createSaveAndLoadPStateGUI;
    dicomViewer.enableOrDisablePStatesMenu = enableOrDisablePStatesMenu;
    dicomViewer.EnableDisableReferenceLineMenu = EnableDisableReferenceLineMenu;
    dicomViewer.updatePreset = updatePreset;
    dicomViewer.loadimages = loadimages;
    dicomViewer.getOrUpdateSeriesLayout = getOrUpdateSeriesLayout;
    dicomViewer.enableOrDisableTools = enableOrDisableTools;

    return dicomViewer;
}(dicomViewer));/**
 * New node file
 */
var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }
    
    var viewports={};
	
	var viewportIds = [];

    var seriesLayoutMaxId;
    
    var backupviewports={};
    
    var backupViewportsBySeriesIndex={};

    var duplicateViewportsBySeriesIndex = {};

    function addBackupViewport(viewportId,viewport) {
    	backupviewports[viewportId] = viewport;		
    }
    function removeBackupViewport(viewportId) {        
        delete backupviewports[viewportId];    			
    }    
    function getBackupViewport( viewportId )
    {    	
    	return backupviewports[viewportId];
    }   
    
    function addBackupViewportBySeriesIndex(viewportId,viewport) {
    	backupViewportsBySeriesIndex[viewportId] = viewport;		
    }
    function removeBackupViewportBySeriesIndex(viewportId) {        
        delete backupViewportsBySeriesIndex[viewportId];    			
    }
    function removeAllBackupViewportBySeriesIndex(studyLayoutId) {
        for(var key in backupViewportsBySeriesIndex){
            var serieslayout = backupViewportsBySeriesIndex[key];
            var index =  serieslayout.seriesLayoutId.indexOf(studyLayoutId);
			if(index >= 0)
            {
                delete backupViewportsBySeriesIndex[key];  
            }
        }          			
    }
    function getBackupViewportBySeriesIndex( viewportId )
    {    	
    	return backupViewportsBySeriesIndex[viewportId];
    }
    

    function getViewport( viewportId )
    {
    	if(viewportId === undefined)
    	{
    		throw "viewportId should not be null or undefined";
    	}
    	return viewports[viewportId];
    }
    
    function removeViewport( viewportId )
    {
    	if(viewportId === undefined)
    	{
    		throw "viewportId should not be null or undefined";
    	}
        delete viewports[viewportId];
    }
    
    function addViewport(viewportId,viewport)
    {
    	if(viewportId === undefined )
    	{
    		throw "viewportId Or viewportInfo should not be null Or undefined";
    	}
        if(viewport === undefined)
        {
            delete viewports[viewportId];
            return ;
        }
        delete viewports[viewportId];
    	viewports[viewportId] = viewport;
		viewportIds.push(viewportId);
    }

    function getAllViewportsId() {
        return viewportIds;
    }
	
	function removeAllViewports()
    {
       viewports={};	
	   viewportIds = [];
    }

	function getViewportIds()
	{
		var unique=viewportIds.filter(function(itm,i,viewportIds){
			return i==viewportIds.indexOf(itm);
		});
		
		return unique;
	}
    
    function getAllViewports()
    {
        return viewports;
    }
    
    function refreshViewports( source)
    {
        if(source === undefined)
        {
            return
        }
		var parentDiv = source.seriesLayoutId;
		if(parentDiv === undefined)
		{
			parentDiv = source.parentElement;
		}
		var studyDiv = getStudyLayoutId(parentDiv);
       for (var key in viewports)
       {
		   var indexOfStudyDiv = key.indexOf(studyDiv);
		   if(indexOfStudyDiv > -1)
		   {
			   var obj = viewports[key];
               //if(source.seriesLayoutId != obj.seriesLayoutId){
                   obj.refreshViewports(source);
               //}
		   }
       }
    }

    function addSeriesLayoutMaxId(seriesLayoutId) {
        seriesLayoutMaxId = seriesLayoutId;
    }

    function getSeriesLayoutMaxId() {
        return seriesLayoutMaxId;
    }
	function removeViewportsByStudyLayout(studyLayoutId){
		
		for(var key in viewports){
			var index =  key.indexOf(studyLayoutId);
			if(index >= 0){
			
				delete viewports[key];
				}
			}
	}
    function backupViewableViewportsBySeriesIndex(studyLayoutId){
		
		for(var key in viewports)
        {
            var index =  key.indexOf(studyLayoutId);
			if(index >= 0)
            {
                var viewport = viewports[key];
                if(viewport.getSeriesIndex() !== undefined)
                {
                    var imageValue = dicomViewer.Series.Image.getImage(viewport.getStudyUid(),viewport.getSeriesIndex(),viewport.getImageIndex()); 
                    if(imageValue !== undefined)
                    {
                        if(dicomViewer.thumbnail.isImageThumbnail(imageValue))
                            addBackupViewportBySeriesIndex(viewport.getStudyUid()+"_"+viewport.getImageIndex(),viewport);
                        else
                            addBackupViewportBySeriesIndex(viewport.getStudyUid()+"_"+viewport.getSeriesIndex(),viewport);
                    }
                }
            }
		}
	}
    
    function deleteAndCreateNewViewport(studyLayoutId){
        for(var key in viewports)
        {
			var index =  key.indexOf(studyLayoutId);
			if(index >= 0)
            {
                dicomViewer.removeCacheMapInStudy(viewports[key].studyUid);
                var newLayout = new SeriesLevelLayout(key);
                newLayout.imageLayoutDimension = "1x1";
                var preferenceInfo = new PreferenceInfo();
                preferenceInfo.init();
                newLayout.setPreferenceInfo(preferenceInfo);
                viewports[key] = newLayout;
                dicomViewer.setimageCanvasOfViewPort(key,undefined);
                dicomViewer.removeCineManager(key);
                newLayout.removeAllImageRenders();
                newLayout.setSeriesIndex(undefined);
                newLayout.setImageIndex(undefined);
                newLayout.setFrameIndex(undefined);
                dicomViewer.changeSelection(key);
            }
        }
    }

    function deleteViewportsByThumbnail(studyUid){
        var tempStudyLayoutId = "";
        for(var key in viewports){
		    var viewport = viewports[key];
            var viewportStudyUid = viewport.getStudyUid();
            if(viewportStudyUid != undefined)
            viewportStudyUid = dicomViewer.replaceDotValue(viewportStudyUid);
            if(studyUid === viewportStudyUid){
                 var newLayout = new SeriesLevelLayout(key);
                newLayout.imageLayoutDimension = "1x1";
                var preferenceInfo = new PreferenceInfo();
                preferenceInfo.init();
                newLayout.setPreferenceInfo(preferenceInfo);
                viewports[key] = newLayout;
                dicomViewer.setimageCanvasOfViewPort(key,undefined);
				
                var studyLayoutDivId = getStudyLayoutId(key);
                if(studyLayoutDivId != tempStudyLayoutId)
                {
                    tempStudyLayoutId = studyLayoutDivId;
                    dicomViewer.setSeriesLayout(undefined, 1, 1, 0, null, tempStudyLayoutId);    
                }
                
            }
              //  dicomViewer.setimageCanvasOfViewPort(key,undefined);
				}
			//}
    }
    /**
    *return true if the image is available in any of the viewport else false
    **/
    function isImageVisible(seriesIndex, imageIndex) {
        for (var viewportId in viewports) {
            var viewportObj = getViewport(viewportId);
            var viewportSeriesIndex = viewportObj.seriesIndex;
            var viewportImageIndex = viewportObj.scrollData.imageIndex;
            if(imageIndex === undefined)
            {
                if (seriesIndex === viewportSeriesIndex) {
                    return true;
                }
            }
            else
            {
                if (seriesIndex === viewportSeriesIndex && imageIndex === viewportImageIndex) {
                    return true;
                }
            }
        }
        return false;
    }
	
    /**
    *return viewport if the image is in view 
    **/
    function getViewportByImageIndex(studyUid,seriesIndex,imageIndex){
        for(var key in viewports)
        {
            if(viewports[key].getStudyUid() === studyUid && viewports[key].getSeriesIndex() === seriesIndex && viewports[key].getImageIndex() === imageIndex)
            {
                if(isImageVisible(viewports[key].getSeriesIndex(), viewports[key].getImageIndex()))
                {
                    return viewports[key];
                }
            }
        }
        return undefined;
    }
    
    /**
    *return true if the image is available in any of the viewport else false
    **/
    function checkVewportAvailable(seriesLayoutID, studyUid){
        var currentViewportIDS = [];
        var check = false;
        var currentStudyUid = studyUid;
        var currentStudyLayoutId = getStudyLayoutId(seriesLayoutID);
        var allviewportIDs = dicomViewer.viewports.getViewportIds();
        var viewPortCount = 0;
        var allstudyVewport = dicomViewer.viewports.getAllViewports();
        var indexCount =0;
        for(var indexl = 0; indexl < allviewportIDs.length; indexl++){
           var vewport = dicomViewer.viewports.getViewport(allviewportIDs[indexl]);
            if(vewport !== undefined){   
                currentViewportIDS[indexCount] = allviewportIDs[indexl];
                indexCount++;
            }
        }
        for(var index =0; index < currentViewportIDS.length; index++){
        var sVewport = dicomViewer.viewports.getViewport(currentViewportIDS[index])
        var viewportStudyUid = sVewport.studyUid;
        var vewportId = getStudyLayoutId(currentViewportIDS[index]);
            if(vewportId == currentStudyLayoutId && currentStudyUid == viewportStudyUid){
                check = true;
            }
            if(viewportStudyUid == undefined || viewportStudyUid != currentStudyUid){
                viewPortCount++; 
            }
            if(viewPortCount === currentViewportIDS.length){
                check = true;
            }
        }
        return check;
    }

    /**
     * Get the view port by index
     * @param {Type} index - specifies the index value 
     * @param {Type} studyId - specifies the study Layout Id
     */ 
    function getDuplicateViewportByIndex(viewportIndex, studyLayoutId) {
        try
        {
            if(duplicateViewportsBySeriesIndex != undefined && duplicateViewportsBySeriesIndex != null) {
                var index = Object.keys(duplicateViewportsBySeriesIndex)[viewportIndex];
                if(index.split("_")[1] == studyLayoutId) {
                    return duplicateViewportsBySeriesIndex[index];
                }
            }

            return undefined;
        }
        catch(e)
        { }

        return undefined;
    }

    /**
     * Add the duplicate view ports based on the viewport Id
     * @param {Type} viewportId - Specifies the viewport Id
     * @param {Type} viewport - Specifies the viewport object
     */ 
    function addDuplicateViewportsBySeriesIndex(viewportId, viewport) {
        try
        {
            for(var index = 0; index <= Object.keys(duplicateViewportsBySeriesIndex).length; index++) {
                if(duplicateViewportsBySeriesIndex[viewportId + "_" + index] == undefined) {
                    duplicateViewportsBySeriesIndex[viewportId + "_" + index] = viewport;
                    break;
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Remove the view port object based on the viewport Id
     * @param {Type} viewportId - Specifies the viewport Id
     */ 
    function removeDuplicateViewportsBySeriesIndex(viewportId) {
        try
        {
            for(var index = Object.keys(duplicateViewportsBySeriesIndex).length; index >= 0; index--) {
                if(duplicateViewportsBySeriesIndex[viewportId + "_" + index] != undefined) {
                    delete duplicateViewportsBySeriesIndex[viewportId + "_" + index];
                    break;
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Remove the duplicate view ports based on the study layout
     * @param {Type} studyLayoutId - specifies the study layout value
     */ 
    function removeDuplicateViewportsByStudyLayout(studyLayoutId) {
        try
        {
            for(var key in duplicateViewportsBySeriesIndex){
                var index =  key.indexOf(studyLayoutId);
                if(index >= 0){
                    delete duplicateViewportsBySeriesIndex[key];
                }
            }
        }
        catch(e)
        { }
    }

    /**
     * Check whether the view port is already avialable or not
     * @param {Type} isMultiFrame - specifies the muliframe flag
     * @param {Type} index - specifies the series/image index
     */ 
    function isDuplicateViewport(isMultiFrame, index) {
        try
        {
            var count = 0;
            for(var key in viewports) {
                var viewport = viewports[key];
                if(isMultiFrame) {
                    if(viewport.scrollData.imageIndex == index) {
                        count ++;
                    }
                } else {
                    if(viewport.seriesIndex == index) {
                        count ++;
                    }
                }
            }

            if(count > 1) {
                return true;
            }

            return false;
        }
        catch(e)
        { }

        return false;
    }

    /**
     * Get the selected view port based on the layout Id
     * @param {Type} studyDiv - specifies the study DivId
     * @param {Type} rowMax - specifies the row max value
     * @param {Type} columnMax - specifies the column max value
     * @param {Type} layoutNumber - specifies the layout number
     */ 
    function getSelectedViewport(studyDiv, rowMax, columnMax, layoutNumber) {
        try
        {
            var viewportNumber = 1;
            for(var row = 1; row <= rowMax; row++) {
                for(var column = 1; column <= columnMax; column++) {
                    var viewport = viewports["imageviewer_" + studyDiv + "_" + row + "x" + column];
                    if(viewport != undefined && viewport != null) {
                        if(viewportNumber == layoutNumber) {
                            return viewport;
                        }
                    }
                    viewportNumber++;
                }
            }
            
            return undefined;
        }
        catch(e)
        { }
        
        return undefined;
    }

    /**
     * Get the view port order number based on the view port list
     * @param {Type} rowMax  - specifies the row value
     * @param {Type} columnMax - specifies the column value
     * @param {Type} layoutId - specifies the layout Id
     */ 
    function getViewportNumber(rowMax, columnMax, layoutId) {
        try
        {
          var viewportNumber = 1;
          for(var row = 1; row <= rowMax; row++) {
              for(var column = 1; column <= columnMax; column++) {
                  if((row + "x" + column) == layoutId) {
                      return viewportNumber;
                  }
                  viewportNumber ++;
              }
          }
            
          return 0;
        }
        catch(e)
        { }
    }

    dicomViewer.viewports={
        getAllViewportsId : getAllViewportsId,        
        addBackupViewport : addBackupViewport,
        getViewport : getViewport,
        addViewport : addViewport,
        removeViewport : removeViewport,
        getViewportIds : getViewportIds,
        getAllViewports : getAllViewports,
        refreshViewports : refreshViewports,
        addSeriesLayoutMaxId : addSeriesLayoutMaxId,
        getSeriesLayoutMaxId : getSeriesLayoutMaxId,
		removeAllViewports : removeAllViewports,
		removeViewportsByStudyLayout:removeViewportsByStudyLayout,
        deleteAndCreateNewViewport:deleteAndCreateNewViewport,
        deleteViewportsByThumbnail:deleteViewportsByThumbnail,
        isImageVisible: isImageVisible,
        checkVewportAvailable : checkVewportAvailable,
        getViewportByImageIndex : getViewportByImageIndex,        
        getBackupViewport : getBackupViewport,
        removeBackupViewport : removeBackupViewport,
        addBackupViewportBySeriesIndex : addBackupViewportBySeriesIndex,
        removeBackupViewportBySeriesIndex : removeBackupViewportBySeriesIndex,
        removeAllBackupViewportBySeriesIndex : removeAllBackupViewportBySeriesIndex,
        getBackupViewportBySeriesIndex : getBackupViewportBySeriesIndex,
        backupViewableViewportsBySeriesIndex : backupViewableViewportsBySeriesIndex,
        getDuplicateViewportByIndex : getDuplicateViewportByIndex,
        addDuplicateViewportsBySeriesIndex : addDuplicateViewportsBySeriesIndex,
        removeDuplicateViewportsBySeriesIndex : removeDuplicateViewportsBySeriesIndex,
        removeDuplicateViewportsByStudyLayout : removeDuplicateViewportsByStudyLayout,
        isDuplicateViewport : isDuplicateViewport,
        getSelectedViewport : getSelectedViewport,
        getViewportNumber : getViewportNumber
    };
    
    
    return dicomViewer;
}(dicomViewer));var dicomViewer = (function(dicomViewer) {

    "use strict";

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var cacheIndicators = {};
    /**
     *@param indicator
     *get the indictor object from the argument and save indicator inside the
     *cacheIndicators object
     *cacheIndicators object contains key as viewport Id and value as indicator
     */
    function addCacheIndicator(indicator) {
        if (indicator === undefined) {
            throw "addCacheIndicator : indicator is undefined";
        }
        cacheIndicators[indicator.parentElementId] = indicator
    }

    /**
     *@param seriesIndex
     *Iterate the cacheIndicators object based on the argument(seriesIndex)
     *and the series index present in the indicator return the indicator object
     */
    function getCacheIndicator(seriesIndex, imageIndex) {
            var key;
            var progressbar;
            //Key is viewport div id
            for (key in cacheIndicators) {
                if (cacheIndicators.hasOwnProperty(key)) {
                    var indicator = cacheIndicators[key];
                    if (indicator.seriesIndex == seriesIndex  && indicator.imageIndex == imageIndex) {
                        
                        return indicator;
                    }
                    else
                    {
                        if (indicator.seriesIndex == seriesIndex )
                        {
                            progressbar = indicator;
                        }
                    }
                }
            }
            return progressbar;
        }
        /**
         *This trigger is used to update the progress bar based on the caching
         *using the current caching index and total count we are calculating
         *the percentage and updating in the progress bar using progress.drawImageCacheIndicator()
         */
    $(document).on("update", function(e, totalCount, currentIndex, progress) {
        var percentageVal = (currentIndex / totalCount) * 100;
        progress.cachedPercentage = percentageVal;
        var position = progress.imageIndicator.width * (percentageVal / 100);
        progress.cachedIndicationPoint = position;
        progress.drawImageCacheIndicator();
    });

    dicomViewer.cacheIndicator = {
        addCacheIndicator: addCacheIndicator,
        getCacheIndicator: getCacheIndicator,
    };

    return dicomViewer;
}(dicomViewer));var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }
	
    var  isRefLineEnabled = true;
    
    function updateXRefLine(imageRenderer,actualDC, presentation)
    {
        //Gets the active viewport
        var layout = dicomViewer.getActiveSeriesLayout();
        var isScoutLineVisible = dicomViewer.tools.isScoutLineVisible();
        //Get all image renderer 
        var imageRenders = layout.getAllImageRenders();
         var sourceImageUid = undefined;
         for (var iKey in imageRenders)
         {         
            var activeLayoutId = layout.getSeriesLayoutId();
            if (imageRenders[iKey].parentElement.indexOf(activeLayoutId) != -1) {
                sourceImageUid =  imageRenders[iKey].getImageUid();
                break;
            }
         }        
        //var sourceImageUid = getImageUid(layout.getSeriesIndex(),layout.getImageIndex());
        var targetImageUid = imageRenderer.getImageUid();
        var refLine = dicomViewer.xRefLine.getRefLine(sourceImageUid,targetImageUid);
        if(refLine === undefined)
        {
            return;
        }
        else if (isScoutLineVisible)
        {
            var start =  dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates({x:refLine.x1,y:refLine.y1},imageRenderer);
            var end = dicomViewer.measurement.draw.getCanvasCoordinatesForImageCoordinates({x:refLine.x2,y:refLine.y2},imageRenderer);
            var scale = presentation.getZoom();
            actualDC.beginPath();
		    actualDC.strokeStyle = 'white';
		    actualDC.lineWidth = 2 / imageRenderer.scaleValue;
            actualDC.moveTo(start.x,start.y) ;
            actualDC.lineTo(end.x, end.y);
            actualDC.setLineDash([]);
            actualDC.closePath();
            actualDC.stroke();
        }
    }
   
	dicomViewer.refLine = {				
        updateXRefLine: updateXRefLine
	};
	
	  
    return dicomViewer;
}(dicomViewer));var dicomViewer = (function (dicomViewer) {

    "use strict";

    if(dicomViewer === undefined) {
        dicomViewer = {};
    }

    var xRefLineStore = {};
	var refLineWorker;
	var useWorkerQueue = true;

    //Enable/disable the xref jason call 
    var isXrefJasonCallRequired = false;
	function initRefLines()
	{
        setTimeout(function(){initRefLinesByRecursive(0)}, 1000);
    }
    
    /**
     *@param studyData
     *set the study details to parse the xref lines 
     */
    function renderXRefLines(studyData)
    {
        //Check whether the jason call is required 
        if(isXrefJasonCallRequired === true)
        {
            initRefLines();
        } else if(useWorkerQueue) {
            createXRefWorkerQueue(studyData);
        } else {
            calculateXRefLines(studyData);
        }
    }

    function calculateXRefLines(nStudyData) {
        var imagesArray = [];
        var count = nStudyData.seriesCount;
        var currentTime = new Date().getTime();
        for (var index = 0; index < count; index++) {
            var sourceImage = dicomViewer.Series.getAllImages(nStudyData.studyUid, index);
            imagesArray = imagesArray.concat(sourceImage);
        }
		
		var workerData = {
			request: "RefLine",
			imagesArray: imagesArray
		};
		if (typeof(Worker) !== "undefined") {

					if (typeof(refLineWorker) == "undefined") {
						refLineWorker = new Worker("js/dicom/imageCacheWorker.js?v=20171017171723");
					}
					numberOfWebWorkers = numberOfWebWorkers+1;
					refLineWorker.postMessage(workerData);
					refLineWorker.onmessage = function(event) {
						var text = event.data;   
						addRefLinesViewerCode(text.sourceImageUid, text.targetImageUid, text.value);
                        refLineWorker.terminate();
                        refLineWorker = undefined;
					};
			}
			else
			{
				for (var sourceImageIndex = 0; sourceImageIndex < imagesArray.length; sourceImageIndex++) {
					var sourceImage = imagesArray[sourceImageIndex];

					for (var targetImageIndex = 0; targetImageIndex < imagesArray.length; targetImageIndex++) {
						var targetImage = imagesArray[targetImageIndex];
						if (sourceImage.imageUid === targetImage.imageUid) {
							continue;
						}

						var value = dicomViewer.xRefLineViewer.calculateProjectSlice(sourceImage.imagePlane, targetImage.imagePlane);
						addRefLinesViewerCode(sourceImage.imageUid, targetImage.imageUid, value);
					}
				}
			}
        var cTime = new Date().getTime();
        //console.log("Viewer side implementation: "+(cTime - currentTime)+" milliseconds");
    }

	function initRefLinesByRecursive(recursionNumber)
	{
        var currentTime = new Date().getTime();
        var urlParameters = {
			StudyUid : dicomViewer.Study.getStudyUidd() ,
			//Broker : dicomViewer.broker.getBroker(),
			SecurityToken : dicomViewer.security.getSecurityToken(),
			RequestId: new Date().getTime()
		};
        var url = dicomViewer.url.getReferenceLineURL(urlParameters);
		logger.info("Refernce Line URL : "+url);
        logger.startTime("RefLine_"+recursionNumber)
        $.ajax({
		    url : url, 
		    type: 'GET',
            dataType: "json",
		    async : true,
            crossDomain: true,
		    success : function(data){
				logger.endTime("RefLine_"+recursionNumber)
                for(var i=0;i<data.length;i++)
                {
                    var xRefSet = data[i];
                    var sourceImageUid = xRefSet.src;
                    var targetRefLines = xRefSet.lines;
                    for(var j=0;j<targetRefLines.length;j++)
                    {
                        addRefLines(sourceImageUid ,targetRefLines[j]);
                    }
                }
                var cTime = new Date().getTime();
                //console.log("Server side implementation: "+(cTime - currentTime)+" milliseconds");
            },
            error : function(xhr, status){
                if(recursionNumber < 10)
                {
                    recursionNumber++;
                    
                    initRefLinesByRecursive(recursionNumber);
                }
		    }
		});
	}

	function addRefLines(sourceImageUid ,refLineObject)
	{
        xRefLineStore[getRefLineKey(sourceImageUid , refLineObject.tgt)] = refLineObject;
	}

	function addRefLinesViewerCode(sourceImageUid, targetImageUid, value)
	{
        xRefLineStore[getRefLineKey(sourceImageUid , targetImageUid)] = value;
	}

    function getRefLine(sourceImageUid , targetImageUid)
    {
         return xRefLineStore[getRefLineKey(sourceImageUid , targetImageUid)];
    }

    function getRefLineKey(sourceImageUid , targetImageUid)
	{
		return sourceImageUid + "x" + targetImageUid;
	}

    function getSourceImageUid(x , y) {
        var minDistance = undefined;
        var imageUids = undefined;
        $.each(xRefLineStore, function(key, value) {
            if(value !== undefined) {
                var distance = Math.sqrt((x - value.x1) * (x - value.x1 ) + (y - value.y1) * (y - value.y1));
                if(minDistance === undefined) {
                    minDistance = distance;
                    imageUids = key;
                } else {
                    distance = Math.min(minDistance, distance);
                    if(Math.round(distance) !== Math.round(minDistance)) {
                        minDistance = distance;
                        imageUids = key;
                    }
                }
            }
        });

        return imageUids;
    }

    /**
     * create xRef worker queue
     * @param {Type} study 
     */ 
    function createXRefWorkerQueue(study) {
        try
        {
            if(study === undefined || study === null) {
                return;
            }

            var images = [];
            for (var index = 0; index < study.seriesCount; index++) {
                images = images.concat(dicomViewer.Series.getAllImages(study.studyUid, index));
            }

            if(study.isXRefLineFound !== true) {
                return;
            }

            var xRefWorkerQueue = new WorkerQueue(2000);
            var jobIdIncrementer = 1;
            images.forEach(function(image) {
                var workerJob =
                {
                    sourceImage : image,
                    targetImages : images,
                    type : "xRef",
                    id : jobIdIncrementer,
                    workerQueue : xRefWorkerQueue,
                    isProcessing : false
                };

                var xRefWorkerThread = new WorkerThread(workerJob);
                xRefWorkerQueue.push(function() { return xRefWorkerThread.processJob() });
                jobIdIncrementer++;
            });
        }
        catch(e)
        { }
    }

	dicomViewer.xRefLine = {
		initRefLines : initRefLines,
		getRefLine : getRefLine,
        renderXRefLines : renderXRefLines,
        getSourceImageUid : getSourceImageUid,
        addRefLinesViewerCode : addRefLinesViewerCode
	};

    return dicomViewer;
}(dicomViewer));/**
* Use to draw Vertical and horizontal caliper in ECG images
**/
var dicomViewer = (function (dicomViewer) {
    "use strict";

    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var isHorizontalCaliper = false;
    var isHorizontalLeftHandler = false;
    var isHorizontalRightHandler = false;
    var isHorizontalMove = true;
    var mousePreviousPosition = {x: 0, y: 0};

    var isVerticalCaliperStart = false;
    var isVerticalCaliperEnd = false;
    var isVerticalMove = true;
	var showCaliper = {};
    var showCaliperStatus = {};

    var isCaliperEnable = false;
	
	//horizontal caliper measuremnts unit
    var ms = undefined;
    var bpm = undefined;
	
	//vertical caliper measuremnts unit
    var uv = undefined;
    var mm = undefined;

    // Static values used for caliper calculation
    var mm_Per_Inch = 25.4;
    var Inch_Per_mm = 1.0 / mm_Per_Inch;
    var _mm_Per_GridLine = 5.0;
	
	//values saved in horizontal caliper based on the imageid(key)
	var horizontalCaliperValues = {};
	
	//values saved in vertical caliper based on the imageid(key)
	var verticalCaliperValues = {};

    /**
    * Get the Mouse position
    */
    function getMousePos(canvas, evt) {
        var rect = canvas.getBoundingClientRect();
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var imgRender = activeSeriesLayout.getImageRender("ecgData");
        var scaleValue =  imgRender.tempEcgScale;//getScaleValue();
        return {
            x: (evt.clientX - rect.left) / scaleValue,
            y: (evt.clientY - rect.top) / scaleValue
        };
    }

    /**
    * Draw the caliper on first click on the ECG image.
    */
    function initEcgCaliper() {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
		var horizontalValues = getHorizontalCaliper(imageId);
		//check if the caliper value is already aviable for the particular image or not
		//If the value is not avilble horizontalValues is undefined
		 if (horizontalValues === undefined) {
            var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
            var context = canvas.getContext('2d');

            canvas.addEventListener('mousedown', function (evt) {
				horizontalValues = getHorizontalCaliper(imageId);
				if (horizontalValues === undefined) {
                    drawVerticalCanvas(evt);
                    drawHorizontalCanvas(evt);
                }
            }, false);

            canvas.addEventListener('mouseup', function (evt) {
                if (activeSeriesLayout.isCaliperEnable) {
                    activeSeriesLayout.setCaliperEnable(false);

                    // Save the preference 
                    var imageRender = activeSeriesLayout.getImageRender("ecgData");
                    if(imageRender !== undefined) {
                        imageRender.applyOrRevertDisplaySettings(undefined, undefined, undefined, true);
                    }
                }
            }, false);

            $("#imageEcgCanvas" + activeSeriesLayout.getSeriesLayoutId()).mousemove(clickAndMove);
			//display caliper 
			setShowCaliper(imageId, true);
            setCaliperStatus(activeSeriesLayout.getSeriesLayoutId(), "visible"); 
        }
    }

    var clickAndMove = function (evt) {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
		if(!isShowcaliper(imageId)){
			return;
		}
        var horizontalCaliper = getHorizontalCaliper(imageId);
        var verticalCaliper = getVerticalCaliper(imageId);
		var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        var imageData = activeSeriesLayout.getEcgCanvas();
        var mousePosition = getMousePos(canvas, evt);

        if (horizontalCaliper === undefined || verticalCaliper === undefined) {
            return;
        }
		if (activeSeriesLayout.isCaliperEnable) {
			return;
         }
        
        if (evt.which == 1 && evt.buttons == 1) {
            if (isHorizontalCaliper) {
                if (isHorizontalLeftHandler) {
                    horizontalCaliper["centerLineStartX"] = mousePosition.x;
                    horizontalCaliper["centerLineEndX"] = horizontalCaliper["lastLineStartX"];

                    horizontalCaliper["firstLineStartX"] = mousePosition.x;
                    horizontalCaliper["firstLineEndX"] = mousePosition.x;

                    clearCurrentImage(context);
                    drawHorizontalCaliper(context, horizontalCaliper);
                    drawVerticalCaliper(context, verticalCaliper);
                } else if (isHorizontalRightHandler) {
                    horizontalCaliper["centerLineStartX"] = horizontalCaliper["firstLineStartX"];
                    horizontalCaliper["centerLineEndX"] = mousePosition.x;

                    horizontalCaliper["lastLineStartX"] = mousePosition.x;
                    horizontalCaliper["lastLineEndX"] = mousePosition.x;

                    clearCurrentImage(context);
                    drawHorizontalCaliper(context, horizontalCaliper);
                    drawVerticalCaliper(context, verticalCaliper);
                } else if (isHorizontalMove) {
                    var deltaPointX = mousePosition.x - mousePreviousPosition.x;
                    var deltaPointY = mousePosition.y - mousePreviousPosition.y;

                    horizontalCaliper["centerLineStartX"] = horizontalCaliper["centerLineStartX"] + deltaPointX;
                    horizontalCaliper["centerLineEndX"] = horizontalCaliper["centerLineEndX"] + deltaPointX;

                    horizontalCaliper["firstLineStartX"] = horizontalCaliper["firstLineStartX"] + deltaPointX;
                    horizontalCaliper["firstLineEndX"] = horizontalCaliper["firstLineEndX"] + deltaPointX;

                    horizontalCaliper["lastLineStartX"] = horizontalCaliper["lastLineStartX"] + deltaPointX;
                    horizontalCaliper["lastLineEndX"] = horizontalCaliper["lastLineEndX"] + deltaPointX;

                    horizontalCaliper["centerLineStartY"] = horizontalCaliper["centerLineStartY"]  + deltaPointY;
                    horizontalCaliper["centerLineEndY"] = horizontalCaliper["centerLineEndY"] + deltaPointY;

                    horizontalCaliper["firstLineStartY"] = horizontalCaliper["firstLineStartY"] + deltaPointY;
                    horizontalCaliper["firstLineEndY"] = horizontalCaliper["firstLineEndY"] + deltaPointY;

                    horizontalCaliper["lastLineStartY"] = horizontalCaliper["lastLineStartY"] + deltaPointY;
                    horizontalCaliper["lastLineEndY"] = horizontalCaliper["lastLineEndY"] + deltaPointY;

                    clearCurrentImage(context);
                    drawHorizontalCaliper(context, horizontalCaliper);
                    drawVerticalCaliper(context, verticalCaliper);
                }
            } else if (isVerticalCaliperStart) {
                var mouseX = mousePosition.x;
                var mouseY = mousePosition.y;

                verticalCaliper["firstLineStartX"] = verticalCaliper["firstLineStartX"];
                verticalCaliper["firstLineStartY"] = mouseY;
                verticalCaliper["firstLineEndX"] = verticalCaliper["firstLineEndX"];
                verticalCaliper["firstLineEndY"] = mouseY;

                var secondYVertical = mouseY;

                verticalCaliper["centerLineStartY"] = secondYVertical;

                clearCurrentImage(context);
                drawVerticalCaliper(context, verticalCaliper);
                drawHorizontalCaliper(context, horizontalCaliper);
            } else if (isVerticalCaliperEnd) {
                var mouseX = mousePosition.x;
                var mouseY = mousePosition.y;

                verticalCaliper["centerLineEndY"] = mouseY;

                verticalCaliper["lastLineStartY"] = mouseY;
                verticalCaliper["lastLineEndY"] = mouseY;

                clearCurrentImage(context);
                drawVerticalCaliper(context, verticalCaliper);
                drawHorizontalCaliper(context, horizontalCaliper);
            } else if (isVerticalMove) {
                var deltaPointX = mousePosition.x - mousePreviousPosition.x;
                var deltaPointY = mousePosition.y - mousePreviousPosition.y;
                verticalCaliper["centerLineStartX"] = verticalCaliper["centerLineStartX"] + deltaPointX;
                verticalCaliper["centerLineEndX"] = verticalCaliper["centerLineEndX"] + deltaPointX;

                verticalCaliper["firstLineStartX"] = verticalCaliper["firstLineStartX"] + deltaPointX;
                verticalCaliper["firstLineEndX"] = verticalCaliper["firstLineEndX"] + deltaPointX;

                verticalCaliper["lastLineStartX"] = verticalCaliper["lastLineStartX"] + deltaPointX;
                verticalCaliper["lastLineEndX"] = verticalCaliper["lastLineEndX"] + deltaPointX;

                verticalCaliper["centerLineStartY"] = verticalCaliper["centerLineStartY"] + deltaPointY;
                verticalCaliper["centerLineEndY"] = verticalCaliper["centerLineEndY"] + deltaPointY;

                verticalCaliper["firstLineStartY"] = verticalCaliper["firstLineStartY"] + deltaPointY;
                verticalCaliper["firstLineEndY"] = verticalCaliper["firstLineEndY"] + deltaPointY;

                verticalCaliper["lastLineStartY"] = verticalCaliper["lastLineStartY"] + deltaPointY;
                verticalCaliper["lastLineEndY"] = verticalCaliper["lastLineEndY"] + deltaPointY;
            }
            clearCurrentImage(context);
            drawVerticalCaliper(context, verticalCaliper);
            drawHorizontalCaliper(context, horizontalCaliper);
        } else {
            isClickandMoveHorizontal(evt);
            if (!isHorizontalCaliper) {
                isClickandMoveVertical(evt);
            } else if (mouseInMidLine(evt) && !isHorizontalCaliper) {
                $('#viewport_View').css('cursor', 'move');
            } else if ((!isHorizontalCaliper)) {
                $('#viewport_View').css('cursor', 'default');
            }
        }

        mousePreviousPosition.x = mousePosition.x;
        mousePreviousPosition.y = mousePosition.y;
    };

    function mouseInMidLine(evt) {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
        var horizontalCaliper = getHorizontalCaliper(imageId);
        var verticalCaliper = getVerticalCaliper(imageId);

        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        var mousePos = getMousePos(canvas, evt);
        var mouseX = mousePos.x;
        var mouseY = mousePos.y;
        if (calulateNearPoint(mouseY, horizontalCaliper["centerLineStartY"]) && (mouseX > horizontalCaliper["centerLineStartX"]) && (mouseX < horizontalCaliper["centerLineEndX"])) {
            return true;
        } else {
            return false;
        }
    }

   function drawHorizontalCanvas(evt) {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var horizontalCaliper = {};
        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        var mousePos = getMousePos(canvas, evt);
		
		mousePos.x = mousePos.x-60;
		mousePos.y = mousePos.y-30;
		
        var scaleValue = getScaleValue();

        horizontalCaliper["centerLineStartX"] = mousePos.x - (50/scaleValue);
        horizontalCaliper["centerLineStartY"] = mousePos.y;
        horizontalCaliper["centerLineEndX"] = mousePos.x + (50/scaleValue);
        horizontalCaliper["centerLineEndY"] = mousePos.y;

        horizontalCaliper["firstLineStartX"] = mousePos.x - (50/scaleValue);
        horizontalCaliper["firstLineStartY"] = mousePos.y - (12/scaleValue);
        horizontalCaliper["firstLineEndX"] = mousePos.x - (50/scaleValue);
        horizontalCaliper["firstLineEndY"] = mousePos.y + (70/scaleValue);

        horizontalCaliper["lastLineStartX"] = mousePos.x + (50/scaleValue);
        horizontalCaliper["lastLineStartY"] = mousePos.y - (12/scaleValue);
        horizontalCaliper["lastLineEndX"] = mousePos.x + (50/scaleValue);
        horizontalCaliper["lastLineEndY"] = mousePos.y + (70/scaleValue);

        drawHorizontalCaliper(context, horizontalCaliper);
    }

    function drawVerticalCanvas(evt) {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var verticalCaliper = {};

        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        var mousePos = getMousePos(canvas, evt);

        var scaleValue = getScaleValue();
        verticalCaliper["firstLineStartX"] = mousePos.x + (9/scaleValue);
        verticalCaliper["firstLineStartY"] = mousePos.y - (40/scaleValue);
        verticalCaliper["firstLineEndX"] = mousePos.x + (90/scaleValue);
        verticalCaliper["firstLineEndY"] = mousePos.y - (40/scaleValue);

        verticalCaliper["centerLineStartX"] = mousePos.x + (80/scaleValue);
        verticalCaliper["centerLineStartY"] = mousePos.y - (40/scaleValue);
        verticalCaliper["centerLineEndX"] = mousePos.x + (80/scaleValue);
        verticalCaliper["centerLineEndY"] = mousePos.y + (40/scaleValue);

        verticalCaliper["lastLineStartX"] = mousePos.x + (9/scaleValue);
        verticalCaliper["lastLineStartY"] = mousePos.y + (40/scaleValue);
        verticalCaliper["lastLineEndX"] = mousePos.x + (90/scaleValue);
        verticalCaliper["lastLineEndY"] = mousePos.y + (40/scaleValue);

        drawVerticalCaliper(context, verticalCaliper);
    }
	
    function isClickandMoveHorizontal(evt) {
        isHorizontalCaliper = false;
        isHorizontalLeftHandler = false;
        isHorizontalRightHandler = false;
        isHorizontalMove = false;
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout)
        var horizontalCaliper = getHorizontalCaliper(imageId);
        var verticalCaliper = getVerticalCaliper(imageId);

        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        var mousePos = getMousePos(canvas, evt);
        var mouseX = mousePos.x;
        var mouseY = mousePos.y;
        if (calulateNearPoint(horizontalCaliper["firstLineStartX"], mouseX) && (horizontalCaliper["firstLineStartY"] <= mouseY && horizontalCaliper["firstLineEndY"] >= mouseY)) {
            $('#viewport_View').css('cursor', 'e-resize');
            isHorizontalCaliper = true;
            isHorizontalLeftHandler = true;
        } else if (calulateNearPoint(horizontalCaliper["lastLineStartX"], mouseX) && (horizontalCaliper["lastLineStartY"] <= mouseY && horizontalCaliper["lastLineEndY"] >= mouseY)) {
            $('#viewport_View').css('cursor', 'e-resize');
            isHorizontalCaliper = true;
            isHorizontalRightHandler = true;
        } else if (calulateNearPoint(mouseY, horizontalCaliper["centerLineStartY"]) && ((mouseX >= horizontalCaliper["centerLineStartX"]) && (mouseX <= horizontalCaliper["centerLineEndX"]) || (mouseX <= horizontalCaliper["centerLineStartX"]) && (mouseX >= horizontalCaliper["centerLineEndX"]))){ 
            $('#viewport_View').css('cursor', 'move');
            isHorizontalMove = true;
            isHorizontalCaliper = true;
        }
    }

    function isClickandMoveVertical(evt) {
		var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
		
        var verticalCaliper = getVerticalCaliper(imageId);

        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        var mousePos = getMousePos(canvas, evt);
        var mousePosX = mousePos.x;
        var mousePosY = mousePos.y;

        if (calulateNearPoint(mousePosY, verticalCaliper["firstLineStartY"]) && (mousePosX > verticalCaliper["firstLineStartX"]) && (mousePosX < verticalCaliper["firstLineEndX"])) {
            $('#viewport_View').css('cursor', 's-resize');
            isVerticalCaliperStart = true;
            isVerticalCaliperEnd = false;
            isVerticalMove = false;
        } else if (calulateNearPoint(mousePosY, verticalCaliper["lastLineStartY"]) && (mousePosX > verticalCaliper["lastLineStartX"]) && (mousePosX < verticalCaliper["lastLineEndX"])) {
            $('#viewport_View').css('cursor', 's-resize');
            isVerticalCaliperStart = false;
            isVerticalCaliperEnd = true;
            isVerticalMove = false;
        } else if (calulateNearPoint(mousePosX, verticalCaliper["centerLineStartX"]) && ((mousePosY > verticalCaliper["centerLineStartY"]) && (mousePosY < verticalCaliper["centerLineEndY"]) || (mousePosY < verticalCaliper["centerLineStartY"]) && (mousePosY > verticalCaliper["centerLineEndY"]))) {
            $('#viewport_View').css('cursor', 'move');
            isVerticalCaliperStart = false;
            isVerticalCaliperEnd = false;
            isVerticalMove = true;
        } else {
            isVerticalCaliperStart = false;
            isVerticalCaliperEnd = false;
            isVerticalMove = false;
            $('#viewport_View').css('cursor', 'default');
        }
    }

    function drawCaliper() {
        initEcgCaliper();
    }

    function calulateNearPoint(firstValue, secondValue) {
        var result;
        if (firstValue >= secondValue) {
            result = firstValue - secondValue;
        } else if (secondValue > firstValue) {
            result = secondValue - firstValue;
        }

        if (result <= 5) {
            return true;
        }
        return false;
    }

	/**
	*@param verticalCaliper
	*return the length of the vertical caliper
	*/
    function getLengthOfVerticalCaliper(verticalCaliper) {
        var dx = Math.abs(verticalCaliper["centerLineStartX"] - verticalCaliper["centerLineEndX"]);
        var dy = Math.abs(verticalCaliper["centerLineStartY"] - verticalCaliper["centerLineEndY"]);

        var lengthInCM = getDistance(dx, dy);
        logger.info("Length : " + lengthInCM);
        return lengthInCM;
    }
	
	/**
	*@param horizontalCaliper
	*return the length of the horizontal caliper
	*/
    function getLengthOfHorizontalCaliper(horizontalCaliper) {
        var dx = Math.abs(horizontalCaliper["centerLineStartX"] - horizontalCaliper["centerLineEndX"]);
        var dy = Math.abs(horizontalCaliper["centerLineStartY"] - horizontalCaliper["centerLineEndY"]);

        var lengthInCM = getDistance(dx, dy);
        logger.info("Length : " + lengthInCM);
        return lengthInCM;
    }

    /**
     * Get the distance between two points in pixel.
     */
    function getDistance(firstPoint, secondPoint)
    {
        var x1MinusX2Square = Math.pow(firstPoint, 2.0);
        var y1MinusY2Square = Math.pow(secondPoint, 2.0);

        return Math.sqrt(x1MinusX2Square + y1MinusY2Square);
    }

    function getGain(gain) {
        switch (gain) {
            case 0:
                return 5.0;
            case 1:
                return 10.0;
            case 2:
                return 20.0;
            case 3:
                return 40.0;
            default:
                return 10.0;
        }
    }

    function overlayElement(lengthOfLine, isVertical) {
        var preferenceInfo = dicomViewer.getActiveSeriesLayout().preferenceInfo;
        var aScaleFactor = 1;

        var aGain = getGain(preferenceInfo.selectedEcgFormat.Gain);
        var aPtsDistance = lengthOfLine;
        var aDotsPerInchX = aScaleFactor * 100;
        var aDotsPerInchY = aScaleFactor * 100;
        var aGridCellWidth = Math.round((aDotsPerInchX * Inch_Per_mm) * _mm_Per_GridLine);
        var aGridCellHeight = Math.round((aDotsPerInchY * Inch_Per_mm) * _mm_Per_GridLine);
        var aTotalMillimeters = (aPtsDistance / aGridCellWidth) * _mm_Per_GridLine;
        var grid200PercentCellWidth = 40; // Initialize the cell grid size for 200%

        if (isVertical) {
            var aStandardGain = 10.0;
            var aMillimeterPeruV = 100.0;
            var aAverageGain = (aStandardGain / aGain);
            var aMilliMeter = (aAverageGain * aTotalMillimeters);

            if (aMilliMeter == 0) {
                aMilliMeter = 0.1;
            }

            var aTotaluV = (aMilliMeter * aMillimeterPeruV);
            mm = aMilliMeter;
            uv = Math.round(aTotaluV);
            logger.info("Vertical " + aTotaluV);
        } else {
            var aTotalMilliSecond = aTotalMillimeters * grid200PercentCellWidth;
            if (aTotalMilliSecond == 0) {
                aTotalMilliSecond = 1;
            }
            var aBeatsPerMinute = 60000;
            var aTotalBreatsPerMinute = aBeatsPerMinute / aTotalMilliSecond;

            bpm = Math.round(aTotalBreatsPerMinute);
            ms = Math.round(aTotalMilliSecond);
        }
    }

    function horizonatlMeasurementText(context) {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
        var horizontalCaliper = getHorizontalCaliper(imageId);

        context.font = '12pt Calibri';
        context.textAlign = 'center';
        context.textAlign = 'center';

        if (activeSeriesLayout.preferenceInfo.preferenceData.gridColor === 'greyGrid') {
            context.fillStyle = 'white';
        } else {
            context.fillStyle = 'blue';
        }

        /*
        *Identify the middle point of stright straight line
        * MidPoint = (x+x1)/2,(y+y1)/2
        */
        var middlePointOfXaxis = (horizontalCaliper["centerLineStartX"] + horizontalCaliper["centerLineEndX"]) / 2;
        var middlePointOfYaxis = (horizontalCaliper["centerLineStartY"] + horizontalCaliper["centerLineEndY"]) / 2;

        context.fillText(ms + ' ms', middlePointOfXaxis - 5, middlePointOfYaxis - 30);
        context.fillText(bpm + ' BPM', middlePointOfXaxis - 5, middlePointOfYaxis - 10);
    }

    function verticalMeasurementText(context) {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
		var imageId = activeSeriesLayout.getImageRender("ecgData").getImageUid();
        var verticalCaliper = getVerticalCaliper(imageId);/*activeSeriesLayout.verticalCaliper;*/

        context.font = '12pt Calibri';
        context.textAlign = 'left';
        
		if (activeSeriesLayout.preferenceInfo.preferenceData.gridColor === 'greyGrid') {
            context.fillStyle = 'white';
        } else {
            context.fillStyle = 'blue';
        }

        /*
        *Identify the middle point of stright straight line
        * MidPoint = (x+x1)/2,(y+y1)/2
        */
        var middlePointOfXaxis = (verticalCaliper["centerLineStartX"] + verticalCaliper["centerLineEndX"]) / 2;
        var middlePointOfYaxis = (verticalCaliper["centerLineStartY"] + verticalCaliper["centerLineEndY"]) / 2;
		
		context.fillText(mm.toFixed(2) + ' mm', middlePointOfXaxis + 10, middlePointOfYaxis);
        context.fillText(uv + ' uv', middlePointOfXaxis + 10, middlePointOfYaxis + 20);
        
    }

    function drawHorizontalCaliper(context, horizontalCaliper) {
        context.moveTo(horizontalCaliper["centerLineStartX"], horizontalCaliper["centerLineStartY"]);
        context.lineTo(horizontalCaliper["centerLineEndX"], horizontalCaliper["centerLineEndY"]);

        context.moveTo(horizontalCaliper["firstLineStartX"], horizontalCaliper["firstLineStartY"]);
        context.lineTo(horizontalCaliper["firstLineEndX"], horizontalCaliper["firstLineEndY"]);

        context.moveTo(horizontalCaliper["lastLineStartX"], horizontalCaliper["lastLineStartY"]);
        context.lineTo(horizontalCaliper["lastLineEndX"], horizontalCaliper["lastLineEndY"]);

        if (dicomViewer.getActiveSeriesLayout().preferenceInfo.preferenceData.gridColor === 'greyGrid') {
            context.strokeStyle = 'white';
        } else {
            context.strokeStyle = 'blue';
        }

        context.stroke();
		
		var imageId = getImageIdFromSeriesLayout(dicomViewer.getActiveSeriesLayout());
		setHorizontalCaliper(imageId,horizontalCaliper);

        var length = getLengthOfHorizontalCaliper(horizontalCaliper);
        overlayElement(length, false);
        horizonatlMeasurementText(context);
    }

    function drawVerticalCaliper(context, verticalCaliper) {
        context.moveTo(verticalCaliper["firstLineStartX"], verticalCaliper["firstLineStartY"]);
        context.lineTo(verticalCaliper["firstLineEndX"], verticalCaliper["firstLineEndY"]);

        context.moveTo(verticalCaliper["centerLineStartX"], verticalCaliper["centerLineStartY"]);
        context.lineTo(verticalCaliper["centerLineEndX"], verticalCaliper["centerLineEndY"]);

        context.moveTo(verticalCaliper["lastLineStartX"], verticalCaliper["lastLineStartY"]);
        context.lineTo(verticalCaliper["lastLineEndX"], verticalCaliper["lastLineEndY"]);

        if (dicomViewer.getActiveSeriesLayout().preferenceInfo.preferenceData.gridColor === 'greyGrid') {
            context.strokeStyle = 'white';
        } else {
            context.strokeStyle = 'blue';
        }
        context.stroke();
		
		var imageId = getImageIdFromSeriesLayout(dicomViewer.getActiveSeriesLayout());
		setVerticalCaliper(imageId,verticalCaliper);
	
        var length = getLengthOfVerticalCaliper(verticalCaliper);
        overlayElement(length, true);
        verticalMeasurementText(context);
    }

    function redrawBothCaliper(activeSeriesLayout) {
        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');		
		var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
		if(dicomViewer.isShowcaliper(imageId)){
            clearCurrentImage(context);
        	drawHorizontalCaliper(context, getHorizontalCaliper(imageId));
        	drawVerticalCaliper(context, getVerticalCaliper(imageId));
            setCaliperStatus(activeSeriesLayout.getSeriesLayoutId(), "visible");
		}
        $("#imageEcgCanvas" + activeSeriesLayout.getSeriesLayoutId()).mousemove(clickAndMove);
    }

    function clearCurrentImage(context) {
        context.clearRect(0, 0, context.canvas.width, context.canvas.height);
        var imageData = dicomViewer.getActiveSeriesLayout().getEcgCanvas();
        context.putImageData(imageData, 0, 0);
        context.beginPath();
    }
	
	/**
	*@param seriesLayout
	* retun the image id from the series layout
	*/
	function getImageIdFromSeriesLayout(seriesLayout){
		if(seriesLayout === null || seriesLayout === undefined){
			throw "seriesLayout cannot be null or undefined"
		}
		return seriesLayout.getImageRender("ecgData").getImageUid();
	}

    function getScaleValue() {
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
        
        var imageRenderer = activeSeriesLayout.getImageRender("ecgData");

        var scaleValue = imageRenderer.getZoomLevel();
        if (scaleValue === undefined || scaleValue === null || scaleValue === Infinity) {
            scaleValue = 1;
        }
        return scaleValue;
    }
    
	function hideCaliper(){
		var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
		//hide caliper
		setShowCaliper(imageId,false);
		var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
		clearCurrentImage(context);
        setCaliperStatus(activeSeriesLayout.getSeriesLayoutId(), "invisible");
        $('#viewport_View').css('cursor', 'default');
	}
    
	function displayCaliper(){
		var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var imageId = getImageIdFromSeriesLayout(activeSeriesLayout);
		//display caliper
		setShowCaliper(imageId,true);
		var canvas = document.getElementById('imageEcgCanvas' + activeSeriesLayout.getSeriesLayoutId());
        var context = canvas.getContext('2d');
		clearCurrentImage(context);
		drawHorizontalCaliper(context, getHorizontalCaliper(imageId));
        drawVerticalCaliper(context, getVerticalCaliper(imageId));
        setCaliperStatus(activeSeriesLayout.getSeriesLayoutId(), "visible");
	}
    
	/**
	*@param imageId
	*@param value
	* save the horizontal caliper values to draw in the ecg canvas based on the image Id
	*/
	function setHorizontalCaliper(imageId, values){		
		horizontalCaliperValues[imageId] = values;
	}
	
	/**
	*@param imageId
	*@param value
	* save the vertical caliper values to draw in the ecg canvas based on the image Id
	*/
	function setVerticalCaliper(imageId, values){
		
		verticalCaliperValues[imageId] = values;
	}
	
	/**
	*@param imageId
	* Retrive the horizontal caliper values based on the imageId
	*/
	function getHorizontalCaliper(imageId){
		
		return horizontalCaliperValues[imageId];
	}
	
	/**
	*@param imageId
	*Retrive the Vertical caliper values based on the imageId
	*/
	function getVerticalCaliper(imageId){
		
		return verticalCaliperValues[imageId];
	}
    
	function setShowCaliper(imageId, flag){
		showCaliper[imageId] = flag;
	}
	
	function isShowcaliper(imageId){
		return showCaliper[imageId];
	}

    function setCaliperStatus(layoutID, status)
    {
      showCaliperStatus[layoutID] = status;
    }

    function getCaliperStatus(layoutID){
      return showCaliperStatus[layoutID];
    }

    function removeAllCaliperStatus(){
        for(var key in showCaliperStatus){
             delete showCaliperStatus[key];  
        } 
    }

    /**
    * Revert the applied horizontal and vertical caliper values
    */
    function RevertCaliper(){
        var imageId = getImageIdFromSeriesLayout(dicomViewer.getActiveSeriesLayout());
        var activeSeriesLayout = dicomViewer.getActiveSeriesLayout();
        var imgRenderer = activeSeriesLayout.getImageRender("ecgData");
        if(imgRenderer !== undefined){
            setHorizontalCaliper(imageId, undefined);
            setVerticalCaliper(imageId, undefined);
            setShowCaliper(imageId, false);
            setCaliperStatus(activeSeriesLayout.seriesLayoutId, undefined);
        }
    }

    /**
     * Print the horizontal/vertical caliper
     * @param {Type} context - specifies the print context
     * @param {Type} imageUid - specifies the image Uid
     */ 
    function printCaliper(context, imageUid) {
        try
        {
            var horizontalCaliper = getHorizontalCaliper(imageUid);
            var verticalCaliper = getVerticalCaliper(imageUid);
            if(horizontalCaliper && verticalCaliper) {
                drawHorizontalCaliper(context, horizontalCaliper);
                drawVerticalCaliper(context, verticalCaliper);
            }
        }
        catch(e)
        { }
    }

    dicomViewer.drawCaliper = drawCaliper;
    dicomViewer.redrawBothCaliper = redrawBothCaliper;
	dicomViewer.getHorizontalCaliper = getHorizontalCaliper;
	dicomViewer.isShowcaliper = isShowcaliper;
	dicomViewer.hideCaliper = hideCaliper;
	dicomViewer.displayCaliper = displayCaliper;
    dicomViewer.removeAllCaliperStatus = removeAllCaliperStatus;
    dicomViewer.getCaliperStatus = getCaliperStatus;
    dicomViewer.RevertCaliper = RevertCaliper;
    dicomViewer.printCaliper = printCaliper;
    return dicomViewer;
} (dicomViewer));var dicomViewer = (function(dicomViewer)
{
    if(dicomViewer === undefined)
	{
		dicomViewer = {};
	}
    var cinePlayerPlayBy = "Stack";
    var framesToRepeat = 1;
    var timesToRepeat = 1;
    var idleTime = 1;

    var copyAttributes = {
        windowLevel: true,
        pan: true,
        scale: true,
        invert: true,
        orientation: true
    }

    function getCinePlayerPlayBy()
    {
        return cinePlayerPlayBy;
    }
    function setCinePlayerPlayBy(tmpCinePlayerPlayBy)
    {
        cinePlayerPlayBy = tmpCinePlayerPlayBy;
    }
    
    function getFramesToRepeat()
    {
        return framesToRepeat;
    }
    function setFramesToRepeat(tmpFramesToRepeat)
    {
        framesToRepeat = parseInt(tmpFramesToRepeat);
    }
    
    function getTimesToRepeat()
    {
        return timesToRepeat;
    }
    function setTimesToRepeat(tmpTimesToRepeat)
    {
        timesToRepeat = parseInt(tmpTimesToRepeat);
    }
    function getIdleTime()
    {
        return idleTime;
    }
    function setIdleTime(tmpIdleTime)
    {
        idleTime = parseInt(tmpIdleTime);
    }

    function getCopyAttributes()
    {
        return copyAttributes;
    }

    function setCopyAttributes(tmpCopyAttributes)
    {
        copyAttributes = tmpCopyAttributes;
    }
    
    dicomViewer.configuration = {
        cine : {
            getCinePlayerPlayBy: getCinePlayerPlayBy,
            setCinePlayerPlayBy : setCinePlayerPlayBy,
            getFramesToRepeat: getFramesToRepeat,
            setFramesToRepeat : setFramesToRepeat,
            getTimesToRepeat: getTimesToRepeat,
            setTimesToRepeat : setTimesToRepeat,
            getIdleTime: getIdleTime,
            setIdleTime : setIdleTime,
            getCopyAttributes: getCopyAttributes,
            setCopyAttributes : setCopyAttributes
        }
        };
    
    
    
return dicomViewer;
	
}(dicomViewer));/**
 * This module deals with linking series within a study
 */

var dicomViewer = (function(dicomViewer) {
    if (dicomViewer === undefined) {
        dicomViewer = {};
    }

    var linkGroup = [];
    var activeStudyUid = null;
    var activeViewportId = null;
    var isLinkToolActive = false;

    function linkSeries() {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var studyUid = seriesLayout.getStudyUid();

        if (isLinkToolActive) {
            if (activeStudyUid == studyUid && activeViewportId !== seriesLayout.getSeriesLayoutId()) {
                var seriesGroup = [];
                var isStudyExists = false;
                $.each(linkGroup, function(key, value) {
                    if (value.studyUid == activeStudyUid) {
                        seriesGroup = linkGroup[key].linkedSeries;
                        isStudyExists = true;
                        return false;
                    }
                });
                seriesGroup.push
                (
                    {
                        sourceViewportId: activeViewportId,
                        targetViewportId: seriesLayout.getSeriesLayoutId()
                    }
                );

                if (!isStudyExists) {
                    linkGroup.push({studyUid: activeStudyUid, linkedSeries: seriesGroup});
                }
                
                isLinkToolActive = false;
            } else {
                resetActiveLinkData();
            }
        } else {
            setActiveLinkData(seriesLayout);
        }
    }

    function unLinkSeries(seriesId) {
        var seriesLayout = dicomViewer.getActiveSeriesLayout();
        var studyUid = seriesLayout.getStudyUid();

        var isLinked = false;
        var arrIndex = null;

        $.each(linkGroup, function(key, value) {
            if (value.studyUid == studyUid) {
                $.each(value.linkedSeries, function(key, value_) {
                    if (value_.sourceViewportId === seriesLayout.getSeriesLayoutId() || 
                        value_.targetViewportId === seriesLayout.getSeriesLayoutId()) {
                        isLinked = true;
                    }

                    if (isLinked) {
                        arrIndex = key;
                        return false;
                    }
                });

                if(isLinked) {
                    value.linkedSeries.splice(arrIndex, 1);
                    return true;
                }
            }
        });
    }

    function isLinkEnabled() {
        try
        {
            var seriesLayout = dicomViewer.getActiveSeriesLayout();
            if(seriesLayout === undefined || seriesLayout === null || seriesLayout.seriesIndex === undefined) {
                return false;
            }

            var studyUid = seriesLayout.getStudyUid();
            var studyDetials = dicomViewer.getStudyDetails(studyUid);
            var numberOfSeries = dicomViewer.Study.getSeriesCount(studyUid);
            var isCheck = false;

            // Show or hide the link menu
            if(dicomViewer.Study.getSeriesCount(seriesLayout.getStudyUid()) > 1) {
                isCheck = true;
            } else {
                var numberOfImages = dicomViewer.Series.getImageCount(seriesLayout.getStudyUid(), 0);
                if(numberOfImages > 1 && dicomViewer.thumbnail.isSeriesContainsMultiframe(seriesLayout.getStudyUid(), 0)) {
                    isCheck = true;
                } else {
                    false;
                }
            }

            dicomViewer.EnableDisableReferenceLineMenu(seriesLayout);
            if(studyDetials !== null && studyDetials !== undefined) {
                if(seriesLayout.imageType === IMAGETYPE_RADECG||seriesLayout.imageType === IMAGETYPE_RADPDF || isCheck == false) {
                        return false;
                }
                if(studyDetials.isDicom) {
                    return true;
                }
            }
        }
        catch(e)
        { }

        return false;
    }

    function updateLinkMenu() {
        var cursor = document.getElementById('viewport_View').style.cursor;
        if (cursor != 'url("images/link.cur"), auto' && cursor != 'url(images/link.cur), auto') {
            resetActiveLinkData();
        }
       
        $("#linkButton_overflow").css("background-color", "#363636");

        if(isLinkEnabled()) {
            $(".linkSeries").show();
            $("#linkButton").removeClass("k-state-disabled");
            $("#linkButton_overflow").show();
            $(".linkSeries").text(isSeriesLinked() ? "UnLink Viewport" : "Link Viewport");
            $("#context-link").show();
            $("#context-link-menu").show();
        } else {
            $(".linkSeries").hide();
            $("#linkButton").addClass("k-state-disabled");
            $("#linkButton_overflow").hide();
            $("#context-link").hide();
            $("#context-link-menu").hide();
        }
    }

    function setActiveLinkData(seriesLayout) {
        activeStudyUid = seriesLayout.getStudyUid();
        activeViewportId = seriesLayout.getSeriesLayoutId();
        isLinkToolActive = true;
    }

    function getLinkToolActive() {
        return isLinkToolActive;
    }

    function isSeriesLinked(sourceViewport) {
        var seriesLayout = undefined;
        if(sourceViewport !== undefined) {
            seriesLayout = sourceViewport;
        } else {
            seriesLayout = dicomViewer.getActiveSeriesLayout();
        }

        var studyUid = seriesLayout.getStudyUid();
        var isLinked = false;

        $.each(linkGroup, function(key, value) {
            if (value.studyUid == studyUid) {
                value.linkedSeries.some(function(seriesGroup) {
                    if (seriesGroup.sourceViewportId === seriesLayout.getSeriesLayoutId() || 
                       seriesGroup.targetViewportId === seriesLayout.getSeriesLayoutId()) {
                        isLinked = true;
                    }

                    if (isLinked) {
                        return true;
                    }
                });
            }
        });

        return isLinked;
    }

    function resetActiveLinkData() {
        activeStudyUid = null;
        activeViewportId = null;
        isLinkToolActive = false;
    }

    /**
     * Perform the link operation
     * @param {Type} sourceViewport - Specifies the source view port
     * @param {Type} moveToNext - Flag to navigate forward or backward
     */ 
    function doLink(sourceViewport, moveToNext, direction, cineMode) {
        try
        {
            if(sourceViewport === undefined || sourceViewport === null) {
                return;
            }

            if (isSeriesLinked(sourceViewport) !== true) {
                return;
            }

            var targetViewportId = undefined;
            $.each(linkGroup, function(key, value) {
                if (value.studyUid === sourceViewport.getStudyUid()) {
                    value.linkedSeries.some(function(seriesGroup) {
                        if (seriesGroup.sourceViewportId === sourceViewport.getSeriesLayoutId()) {
                            targetViewportId = seriesGroup.targetViewportId;
                        } else if(seriesGroup.targetViewportId === sourceViewport.getSeriesLayoutId()) {
                            targetViewportId = seriesGroup.sourceViewportId;
                        }

                        if (targetViewportId !== undefined) {
                            return true;
                        }
                    });
                }
            });

            var viewport = dicomViewer.viewports.getViewport(targetViewportId);
            if(viewport === undefined || viewport === null) {
                return;
            }

            if (cineMode != undefined) {
                if (cineMode) {
                    dicomViewer.scroll.runCineImage(direction, viewport);
                } else {
                    dicomViewer.scroll.stopCineImage(direction, viewport);
                }
            } else {
                dicomViewer.scroll.moveToNextOrPreviousImage(moveToNext, viewport);
            }
        }
        catch(e)
        { }
    }

    dicomViewer.link = {
        linkSeries: linkSeries,
        unLinkSeries: unLinkSeries,
        updateLinkMenu: updateLinkMenu,
        getLinkToolActive: getLinkToolActive,
        isSeriesLinked: isSeriesLinked,
        resetActiveLinkData: resetActiveLinkData,
        doLink: doLink
    }

    return dicomViewer;
}(dicomViewer));


