IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageTags')
BEGIN
	DROP TABLE [dbo].[ImageTags];
	PRINT 'ImageTags table dropped.'
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageGroupTags')
BEGIN
	DROP TABLE [dbo].[ImageGroupTags];
	PRINT 'ImageGroupTags table dropped.'
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageTagMaps')
BEGIN
	DROP TABLE [dbo].[ImageTagMaps];
	PRINT 'ImageTagMaps table dropped.'
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageGroupTagMaps')
BEGIN
	DROP TABLE [dbo].[ImageGroupTagMaps];
	PRINT 'ImageGroupTagMaps table dropped.'
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'Tags')
BEGIN
	CREATE TABLE [dbo].[Tags] (
		[Id]                INT            IDENTITY (1, 1) NOT NULL,
		[Name]				NVARCHAR (MAX) NOT NULL
		CONSTRAINT [PK_dbo.Tags] PRIMARY KEY CLUSTERED ([Id] ASC)
	);
	PRINT 'Tags table created.'
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'TagMaps')
BEGIN
	CREATE TABLE [dbo].[TagMaps] (
		[Id]		INT            IDENTITY (1, 1) NOT NULL,
		[RefUid]    NVARCHAR (40)  NOT NULL,
		[TagId]     INT            NOT NULL,
		CONSTRAINT [PK_dbo.TagMaps] PRIMARY KEY CLUSTERED ([Id] ASC)
	);
	PRINT 'TagMap table created.'
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes  
	WHERE name='TagMap_Index' AND object_id = OBJECT_ID('[dbo].[TagMaps]'))
BEGIN
	CREATE UNIQUE NONCLUSTERED INDEX TagMap_Index
		ON [dbo].[TagMaps]([TagId] ASC, [RefUid] ASC);
	PRINT 'Index TagMap_Index created on ImageTagMaps table.'
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'__MigrationHistory')
BEGIN
	DROP TABLE [dbo].[__MigrationHistory];
	PRINT '__MigrationHistory table dropped.'
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageFiles')
BEGIN
	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'IsTagged') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD IsTagged BIT NULL;
		PRINT 'IsTagged column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'RefImageUid') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD RefImageUid NVARCHAR (40) NULL;
		PRINT 'RefImageUid column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'IsDeleted') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD IsDeleted BIT NULL;
		PRINT 'IsDeleted column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'DicomDirXml') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD DicomDirXml NVARCHAR(MAX) NULL;
		PRINT 'DicomDirXml column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'DicomXml') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD DicomXml NVARCHAR(MAX) NULL;
		PRINT 'DicomXml column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'BlobType') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD BlobType INT NULL;
		PRINT 'BlobType column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'Description') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD Description NVARCHAR(MAX) NULL;
		PRINT 'Description column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'AlternatePath') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD AlternatePath NVARCHAR(MAX) NULL;
		PRINT 'AlternatePath column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'ExternalImageId') 
	BEGIN
		ALTER TABLE [dbo].[ImageFiles] ADD ExternalImageId NVARCHAR(MAX) NULL;
		PRINT 'ExternalImageId column added to ImageFiles table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageFiles' AND 
				COLUMN_NAME = N'SopInstanceUid') 
	BEGIN
		ALTER TABLE [dbo].ImageFiles ADD SopInstanceUid NVARCHAR(100) NULL;
		PRINT 'SopInstanceUid column added to ImageFiles table.'
	END

END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageParts')
BEGIN
	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageParts' AND 
				COLUMN_NAME = N'OverlayIndex') 
	BEGIN
		ALTER TABLE [dbo].ImageParts ADD OverlayIndex INT NULL;
		PRINT 'OverlayIndex column added to ImageParts table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageParts' AND 
				COLUMN_NAME = N'GroupUid') 
	BEGIN
		ALTER TABLE [dbo].ImageParts ADD GroupUid NVARCHAR (40) NULL;
		PRINT 'GroupUid column added to ImageParts table.'
	END
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'ImageGroups')
BEGIN
	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageGroups' AND 
				COLUMN_NAME = N'Name') 
	BEGIN
		ALTER TABLE [dbo].[ImageGroups] ADD Name NVARCHAR (MAX) NULL;
		PRINT 'Name column added to ImageGroups table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageGroups' AND 
				COLUMN_NAME = N'IsTagged') 
	BEGIN
		ALTER TABLE [dbo].[ImageGroups] ADD IsTagged BIT NULL;
		PRINT 'IsTagged column added to ImageGroups table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'ImageGroups' AND 
				COLUMN_NAME = N'IsDeleted') 
	BEGIN
		ALTER TABLE [dbo].[ImageGroups] ADD IsDeleted BIT NULL;
		PRINT 'IsDeleted column added to ImageGroups table.'
	END
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'StudyRecords')
BEGIN

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'StudyRecords' AND 
				COLUMN_NAME = N'DicomDirXml') 
	BEGIN
		ALTER TABLE [dbo].StudyRecords ADD DicomDirXml NVARCHAR(MAX) NULL;
		PRINT 'DicomDirXml column added to StudyRecords table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'StudyRecords' AND 
				COLUMN_NAME = N'PatientId') 
	BEGIN
		ALTER TABLE [dbo].StudyRecords ADD PatientId NVARCHAR(100) NULL;
		PRINT 'PatientId column added to StudyRecords table.'
	END

	IF EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'StudyRecords' AND 
				COLUMN_NAME = N'StudyId') 
	BEGIN
		EXEC sp_rename 'dbo.StudyRecords.StudyId', 'DicomStudyId', 'COLUMN';  
		PRINT 'StudyId column changed to DicomStudyId table.'
	END
END
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'SeriesRecords')
BEGIN
	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'SeriesRecords' AND 
				COLUMN_NAME = N'DicomDirXml') 
	BEGIN
		ALTER TABLE [dbo].SeriesRecords ADD DicomDirXml NVARCHAR(MAX) NULL;
		PRINT 'DicomDirXml column added to SeriesRecords table.'
	END

	IF NOT EXISTS(SELECT * FROM  INFORMATION_SCHEMA.COLUMNS
          WHERE	TABLE_SCHEMA = N'dbo' AND TABLE_NAME = N'SeriesRecords' AND 
				COLUMN_NAME = N'StudyInstanceUid') 
	BEGIN
		ALTER TABLE [dbo].SeriesRecords ADD StudyInstanceUid NVARCHAR(100) NULL;
		PRINT 'StudyInstanceUid column added to SeriesRecords table.'
	END

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'DictionaryRecords')
BEGIN
	CREATE TABLE [dbo].[DictionaryRecords] (
		[Id]               INT            IDENTITY (1, 1) NOT NULL,
		[ParentId]         INT  NULL,
		[Name]       NVARCHAR (MAX) NULL,
		[Value]      NVARCHAR (MAX) NULL
		CONSTRAINT [PK_dbo.DictionaryRecords] PRIMARY KEY CLUSTERED ([Id] ASC)
	);
	PRINT 'DictionaryRecords table created.'
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'StudyParentRecords')
BEGIN
	CREATE TABLE [dbo].[StudyParentRecords] (
		[Id]               INT            IDENTITY (1, 1) NOT NULL,
		[GroupUid]         NVARCHAR (40)  NOT NULL,
		[StudyParentId]        NVARCHAR (100) NULL,
		[StudyParentXml]       NVARCHAR (MAX) NULL,
		[DicomDirXml]      NVARCHAR (MAX) NULL
		CONSTRAINT [PK_dbo.StudyParentRecords] PRIMARY KEY CLUSTERED ([Id] ASC)
	);
	PRINT 'StudyParentRecords table created.'
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'DisplayContexts')
BEGIN
	CREATE TABLE [dbo].[DisplayContexts] (
		[Id]               INT            IDENTITY (1, 1) NOT NULL,
		[GroupUid]         NVARCHAR (40)  NOT NULL,
		[ContextId]        NVARCHAR (150) NOT NULL,
		[Name]			   NVARCHAR (MAX) NULL,
		[Data]			   NVARCHAR (MAX) NULL,
		[ImageCount]       INT            NOT NULL,
		[IsDeleted]		   BIT			  NULL,
		[IsTagged]		   BIT			  NULL,
		CONSTRAINT [PK_dbo.DisplayContexts] PRIMARY KEY CLUSTERED ([Id] ASC)
	);
	PRINT '[DisplayContexts] table created.'
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes  
	WHERE name='DisplayContext_Index' AND object_id = OBJECT_ID('[dbo].[DisplayContexts]'))
BEGIN
	CREATE UNIQUE NONCLUSTERED INDEX DisplayContext_Index
		ON [dbo].[DisplayContexts]([GroupUid] ASC, [ContextId] ASC);
	PRINT 'Index DisplayContext_Index created on DisplayContexts table.'
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES   
    WHERE TABLE_SCHEMA = N'dbo'  AND TABLE_NAME = N'EventLogRecords')
BEGIN
	CREATE TABLE [dbo].[EventLogRecords] (
		[Id]                INT            IDENTITY (1, 1) NOT NULL,
		[StartTime]			DATETIME NULL,
		[EndTime]			DATETIME NULL,
		[TransactionUid]	NVARCHAR (MAX) NULL,
		[ContextType]		INT NULL,
		[Context]			NVARCHAR (MAX) NULL,
		[MessageType]		INT NULL,
		[Message]			NVARCHAR (MAX) NULL,
		CONSTRAINT [PK_dbo.EventLogRecords] PRIMARY KEY CLUSTERED ([Id] ASC)
	);
	PRINT 'EventLogRecords table created.'
END
GO

IF EXISTS (SELECT * FROM sys.indexes  
	WHERE name='ImagePart_ImageUid_Frame_Type_Transform' AND object_id = OBJECT_ID('[dbo].[ImageParts]'))
BEGIN
	DROP INDEX ImagePart_ImageUid_Frame_Type_Transform ON [dbo].[ImageParts];
	PRINT 'Index ImagePart_ImageUid_Frame_Type_Transform dropped on ImageParts table.'
END
GO


