/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Nov 29, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.query;

import gov.va.med.imaging.GUID;
import gov.va.med.imaging.core.FacadeRouterUtility;
import gov.va.med.imaging.exchange.business.TransactionContextLogEntrySnapshot;
import gov.va.med.imaging.ihe.XCAWebAppRouter;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContextHttpHeaders;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author vhaiswwerfej
 *
 */
public class RespondingGatewayServletFilter
implements Filter
{
	private final static Logger logger = LogManager.getLogger(RespondingGatewayServletFilter.class);

	@Override
	public void destroy()
	{
		
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) 
	throws IOException, ServletException
	{
		if(request instanceof HttpServletRequest)
		{
			HttpServletRequest httpRequest = (HttpServletRequest)request;
			// if the request was just for the WSDL (as BHIE does), then don't record this as a transaction
			// looking at the query string is kludgey, but works
			if((httpRequest.getQueryString() != null) && (httpRequest.getQueryString().toLowerCase().endsWith("wsdl")))
			{
				chain.doFilter(request, response);
			}
			else
			{
				Long startTime = System.currentTimeMillis();
				// The principal should be accessible in the request and would be accessible if we knew this was
				// an HTTP request.
				TransactionContext transactionContext = TransactionContextFactory.get();
				transactionContext.setStartTime(startTime);			
				
				// Record the hostname.
				transactionContext.setMachineName (getMachineName());
				transactionContext.setOriginatingAddress(httpRequest.getRemoteAddr() + ":" + httpRequest.getRemotePort());
				
				// Set transaction context properties that might be provided (supposed to be based on ICD)
				if(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderFullName) != null)
					transactionContext.setFullName(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderFullName));
				if(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderSiteName) != null)
					transactionContext.setSiteName(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderSiteName));
				if(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderSiteNumber) != null)
					transactionContext.setSiteNumber(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderSiteNumber));
				if(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderSSN) != null)
					transactionContext.setSsn(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderSSN));
				if(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderTransactionId) != null)
					transactionContext.setTransactionId(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderTransactionId));
				if(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderPurposeOfUse) != null)
					transactionContext.setPurposeOfUse(httpRequest.getHeader(TransactionContextHttpHeaders.httpHeaderPurposeOfUse));
				
				if(transactionContext.getTransactionId() == null)
				{
					String guid = (new GUID()).toLongString();
					logger.info("Transaction ID not provided in request, generating new one '" + guid + "'.");
					transactionContext.setTransactionId(guid);
				}				
				try
				{
					chain.doFilter(request, response);
				}
				catch(Exception ex)
				{
					// JMW 7/8/08 - we want to catch the exception so we can put
					// it into the transaction context (if there is no previous message).
					if((transactionContext.getErrorMessage() == null) ||
						(transactionContext.getErrorMessage().length() <= 0))
					{
						// CPT 8/14/08 - handle "exception_cause_message == null" case (e.g. NullPointerException)
						String msg=null;
						try {
							msg = ex.getCause().getMessage();
							}
						catch (Exception e) {
							msg = "Undelegated Exception";
						}
						logger.info("Caught exception [" + msg + "] in SecurityFilter and putting into transaction context");
						transactionContext.setErrorMessage(msg);
						transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
					}
					if(ex.getClass() == IOException.class)
					{
						throw (IOException)ex;
					}
					else 
					{
						throw new ServletException(ex);
					}
				}
				finally
				{
					//write the current thread's TransactionContext to the Transaction Log
					logger.info("Writing entry to transaction log for transaction '" + transactionContext.getTransactionId() + "'");
					
					try 
					{
						XCAWebAppRouter router = FacadeRouterUtility
								.getFacadeRouter(XCAWebAppRouter.class);
						router.postTransactionLogEntryImmediate(new TransactionContextLogEntrySnapshot(transactionContext));
					} catch (Exception xAny) 
					{
						logger.error("postTransactionLogEntryImmediate Failed: "
								+ xAny.getMessage());
						// don't throw the exception so the client doesn't see it, this transaction will just be dropped
						//throw new ServletException(xAny);
					}

					// Clear the security context so that the thread has no remaining
					// references and has no
					// established security context when it is reused.
					// Once the transaction context is cleared, called to it will do
					// nothing but log a warning (and return null)
					transactionContext.clear();
				}
			}
		}
		else
		{
			chain.doFilter(request, response);
		}
	}
	
	private static String machineName = null;
	private static synchronized String getMachineName()
	{
		if (machineName == null)
		{
			// Determine the hostname for logging.
			// The init method never seems to get called. Spring vs. Container
			// loading?
			try
			{
				machineName = java.net.InetAddress.getLocalHost().getHostName();
				if (machineName == null)
					machineName = java.net.InetAddress.getLocalHost().getHostAddress();
				// if ("localhost".equalsIgnoreCase (machineName) ||
				// "127.0.0.1".equals (machineName)) machineName = null;
			}
			catch (java.net.UnknownHostException uhx)
			{
				machineName = "<unknown>";
			}
		}
		
		return machineName;
	}	

	@Override
	public void init(FilterConfig config) 
	throws ServletException
	{
		
	}

}
