/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Aug 6, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswbeckec
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.query;

import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.GlobalArtifactIdentifierFactory;
import gov.va.med.RoutingToken;
import gov.va.med.RoutingTokenImpl;
import gov.va.med.exceptions.GlobalArtifactIdentifierFormatException;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.DocumentURN;
import gov.va.med.imaging.channels.ByteStreamPump;
import gov.va.med.imaging.channels.AbstractBytePump.TRANSFER_TYPE;
import gov.va.med.imaging.core.FacadeRouterUtility;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNotFoundException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.PatientNotFoundException;
import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResult;
import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.ImageAccessLogEvent.ImageAccessLogEventType;
import gov.va.med.imaging.exchange.business.DocumentFilter;
import gov.va.med.imaging.exchange.business.documents.DocumentRetrieveResult;
import gov.va.med.imaging.exchange.business.documents.DocumentSetResult;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.ihe.EbXMLRsUUID;
import gov.va.med.imaging.ihe.XCATranslatorAdb;
import gov.va.med.imaging.ihe.XCATranslatorXmlBeans;
import gov.va.med.imaging.ihe.XCAWebAppRouter;
import gov.va.med.imaging.ihe.exceptions.ParameterFormatException;
import gov.va.med.imaging.ihe.exceptions.TranslationException;
import gov.va.med.imaging.ihe.request.CrossGatewayQueryRequest;
import gov.va.med.imaging.ihe.request.CrossGatewayRetrieveRequest;
import gov.va.med.imaging.ihe.xds.ErrorCode;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal.AuthenticationCredentialsType;
import gov.va.med.imaging.transactioncontext.ClientPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.activation.DataHandler;

import org.apache.axis2.databinding.types.URI.MalformedURIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


/**
 * @author vhaiswbeckec
 * 
 */
public class RespondingGateway
implements gov.va.med.imaging.ihe.xca.xmlbeans.RespondingGateway_ServiceSkeletonInterface,
	gov.va.med.imaging.ihe.xca.adb.RespondingGatewayRetrieve_ServiceSkeletonInterface
{
	private static org.oasis.ebxml.regrep.rim.adb.ReferenceURI responseStatusSuccess;
	private static org.oasis.ebxml.regrep.rim.adb.ReferenceURI responseStatusFailure;
	private static org.oasis.ebxml.regrep.rim.adb.ReferenceURI responseStatusPartialSuccess;
	
	private final static String webAppName = "XCARespondingGatewayWebApp";

	static
	{
		responseStatusSuccess = new org.oasis.ebxml.regrep.rim.adb.ReferenceURI();
		responseStatusFailure = new org.oasis.ebxml.regrep.rim.adb.ReferenceURI();
		responseStatusPartialSuccess = new org.oasis.ebxml.regrep.rim.adb.ReferenceURI();

		try
		{
			responseStatusSuccess.setReferenceURI(new org.apache.axis2.databinding.types.URI(EbXMLRsUUID.RESPONSE_STATUS_SUCCESS.getUrnAsString()));
			responseStatusFailure.setReferenceURI(new org.apache.axis2.databinding.types.URI(EbXMLRsUUID.RESPONSE_STATUS_FAILURE.getUrnAsString()));
			responseStatusPartialSuccess.setReferenceURI(new org.apache.axis2.databinding.types.URI(EbXMLRsUUID.RESPONSE_STATUS_PARTIALSUCCESS.getUrnAsString()));
		}
		catch (MalformedURIException x)
		{
			LogManager.getLogger(RespondingGateway.class).error("Error initializing response status URI values.", x); //$NON-NLS-1$
			x.printStackTrace();
		}
	}
	
	/**
	 * 
	 * @return
	 */
	public static XCAWebAppRouter getRouter() 
	{
		XCAWebAppRouter router = null;
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		try
		{
			router = FacadeRouterUtility.getFacadeRouter(XCAWebAppRouter.class);
			LogManager.getLogger(RespondingGateway.class).info("Acquired reference to router of class '" + router.getClass().getSimpleName() + "'."); //$NON-NLS-1$ //$NON-NLS-2$
		} 
		catch (Exception x)
		{
			String msg = "Error getting FederationRouter instance.  Application deployment is probably incorrect.";			  //$NON-NLS-1$
			TransactionContextFactory.get().setErrorMessage(msg + "\n" + x.getMessage()); //$NON-NLS-1$
			LogManager.getLogger(RespondingGateway.class).error(msg, x);
			transactionContext.setExceptionClassName(x.getClass().getSimpleName());
			transactionContext.setResponseCode("503"); //$NON-NLS-1$
		}
		return router;
	}	

	/**
	 * 
	 */
	Logger logger = LogManager.getLogger(RespondingGateway.class);

	/**
	 * By default, filtering by class code is turned off because it won't work
	 * very well with the document class code translation mapping.
	 * Flip this switch and we will try to filter by document class code. 
	 */
	private boolean enableDocumentClassCodeFilter = false;
	public boolean isEnableDocumentClassCodeFilter(){return enableDocumentClassCodeFilter;}
	public void setEnableDocumentClassCodeFilter(boolean enableDocumentClassCodeFilter){ this.enableDocumentClassCodeFilter = enableDocumentClassCodeFilter;}
	
	/**
	 * 
	 * @param adhocQueryRequest
	 * @return
	 */
	@Override
	public org.oasis.ebxml.regrep.query.xmlbeans.AdhocQueryResponseDocument respondingGateway_CrossGatewayQuery(
			org.oasis.ebxml.regrep.query.xmlbeans.AdhocQueryRequestDocument adhocQueryRequest)
	{
    	TransactionContext transactionContext = TransactionContextFactory.get();
		
		XCAWebAppRouter router = getRouter();
		logger.info("Obtained reference to router of type '" + router.getClass().getSimpleName() + "'."); //$NON-NLS-1$ //$NON-NLS-2$
		
		org.oasis.ebxml.regrep.query.xmlbeans.AdhocQueryResponseDocument response = 
			org.oasis.ebxml.regrep.query.xmlbeans.AdhocQueryResponseDocument.Factory.newInstance();
		
		try
		{
			CrossGatewayQueryRequest request = XCATranslatorXmlBeans.translate(adhocQueryRequest);
			logger.info("Translated AdhocQueryRequest instance to '" + request.getClass().getSimpleName() + "' instance."); //$NON-NLS-1$ //$NON-NLS-2$
			
			//if( WellKnownOID.HAIMS_DOCUMENT.isApplicable(request.getHomeCommunityId().toString()) )
			//	transactionContext.setHaims1Client(Boolean.TRUE);
			//else
			//	transactionContext.setHaims1Client(Boolean.FALSE);
				
			DocumentFilter documentFilter = isEnableDocumentClassCodeFilter() ? 
				new DocumentFilter(request.getPatientId(), request.getCreationTimeFrom(), request.getCreationTimeTo(), request.getClassCode()) :
				new DocumentFilter(request.getPatientId(), request.getCreationTimeFrom(), request.getCreationTimeTo());
			
			// set the sites that are excluded as a configuration parameter 
			documentFilter.setExcludeSiteNumbers(getExcludedSites());
			transactionContext.setPatientID(documentFilter.getPatientId());
			transactionContext.setRequestType(webAppName + " Query");
			transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(documentFilter.getCreationTimeFrom(), documentFilter.getCreationTimeTo()));

			// we should have a configuration for the OID that we are representing
			RoutingToken routingToken = RoutingTokenImpl.createVADocumentSite(RoutingToken.ROUTING_WILDCARD);
			
			logger.info("Calling router.getDocumentSetList(" + documentFilter.toString() + ");"); //$NON-NLS-1$ //$NON-NLS-2$
			DocumentSetResult documentSetResult = router.getDocumentSetResultForPatient(routingToken, documentFilter);
			//TODO: check for null documentSetResult - really shouldn't happen but just in case
			//TODO: check for partial result and for errors and add them to the response, make translator use DocumentSetResult
			if(documentSetResult == null)
				throw new MethodException("documentSetResult is null, no response getting results is '" + documentFilter.getPatientId() + "'.");
			
			logger.info("Got " + (documentSetResult == null ? "null" : Integer.toString(documentSetResult.getArtifactSize())) + "' DocumentSet instances."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			response.setAdhocQueryResponse( XCATranslatorXmlBeans.translate(documentSetResult) );
			transactionContext.setEntriesReturned(documentSetResult == null ? 0 : documentSetResult.getArtifactSize());
			logger.info("Translated DocumentSet instances into '" + response.getClass().getSimpleName() + "' instance."); //$NON-NLS-1$ //$NON-NLS-2$			
		}
		catch(PatientNotFoundException pnfX)
		{
			logger.error("PatientNotFoundException, " + pnfX.getMessage());
			addQueryResponseError(response, "Cannot find patient", ErrorCode.UNKNOWN_PATIENT_ID);		
		}
		catch (MethodException x)
		{
			logger.error(x);
			addQueryResponseError(response, x.getMessage(), ErrorCode.REGISTRY_ERROR);
		}
		catch (ConnectionException x)
		{
			logger.error(x);
			addQueryResponseError(response, x.getMessage(), ErrorCode.REGISTRY_ERROR);
		}
		catch (TranslationException x)
		{
			logger.error(x);
			addQueryResponseError(response, x.getMessage(), ErrorCode.REGISTRY_ERROR);
		}
		catch (ParameterFormatException x)
		{
			logger.error(x);
			addQueryResponseError(response, x.getMessage(), ErrorCode.REGISTRY_ERROR);
		}
		catch (RoutingTokenFormatException x)
		{
			logger.error(x);
			addQueryResponseError(response, x.getMessage(), ErrorCode.REGISTRY_ERROR);
		}
		transactionContext.addDebugInformation("Returning XCA response with status [" + (response == null ? "null response" : (response.getAdhocQueryResponse() == null ? "null AdhocQueryResponse" : response.getAdhocQueryResponse().getStatus())) + "]");
		return response;
	}
	
	private void addQueryResponseError(org.oasis.ebxml.regrep.query.xmlbeans.AdhocQueryResponseDocument response, 
			String errorDescription, ErrorCode errorCode)
	{
		org.oasis.ebxml.regrep.query.xmlbeans.AdhocQueryResponseDocument.AdhocQueryResponse queryResponse =
			response.addNewAdhocQueryResponse();
		queryResponse.setStatus(EbXMLRsUUID.RESPONSE_STATUS_FAILURE.getUrnAsString());
		
		org.oasis.ebxml.regrep.rs.xmlbeans.RegistryErrorDocument.RegistryError registryError =
			queryResponse.addNewRegistryErrorList().addNewRegistryError();
		registryError.setErrorCode(errorCode.getOpcode());
		registryError.setCodeContext(errorDescription);	
	}

	/**
	 * The XML Beans version of the Cross-Gateway Retrieve
	 * NOTE: this version cannot generate MTOM responses.
	 * 
	 * 
	 * @see gov.va.med.imaging.ihe.xca.xmlbeans.RespondingGateway_ServiceSkeletonInterface#respondingGateway_CrossGatewayRetrieve(org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetRequestDocument)
	 */
	@Override
	public org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetResponseDocument respondingGateway_CrossGatewayRetrieve(
		org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetRequestDocument retrieveDocumentSetRequest)
	{

    	CrossGatewayRetrieveRequest[] requestedDocuments = XCATranslatorXmlBeans.translate(retrieveDocumentSetRequest);
    	
		XCAWebAppRouter router = getRouter();
		logger.info("Obtained reference to router of type '" + router.getClass().getSimpleName() + "'."); //$NON-NLS-1$ //$NON-NLS-2$
		
		org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetResponseDocument response = 
			org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetResponseDocument.Factory.newInstance();
		org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetResponseType responseType = 
			response.addNewRetrieveDocumentSetResponse();
		for(CrossGatewayRetrieveRequest requestedDocument : requestedDocuments)
		{
			try
			{
				DocumentURN documentUrn = GlobalArtifactIdentifierFactory.create(
					requestedDocument.getHomeCommunityId(), 
					requestedDocument.getRepositoryUniqueId(), 
					requestedDocument.getDocumentUniqueId(), 
					DocumentURN.class);
				DocumentRetrieveResult documentRetrieveResult = router.getDocument(documentUrn);
				
				org.ihe.iti.xdsb.xmlbeans.RetrieveDocumentSetResponseType.DocumentResponse documentResponse = 
					responseType.addNewDocumentResponse();
				documentResponse.setHomeCommunityId(documentUrn.getHomeCommunityId());
				documentResponse.setRepositoryUniqueId(documentUrn.getRepositoryUniqueId());
				documentResponse.setDocumentUniqueId(documentUrn.getDocumentId());
				documentResponse.setMimeType(documentRetrieveResult.getVistaImageType().getDefaultMimeType());
				
				ByteArrayOutputStream outBufferStream = new ByteArrayOutputStream(1024*1024);
				ByteStreamPump pump = ByteStreamPump.getByteStreamPump(TRANSFER_TYPE.NetworkToByteArray);
				pump.xfer(documentRetrieveResult.getDocumentStream(), outBufferStream);
				
				documentResponse.setDocument(outBufferStream.toByteArray());
			}
			catch (GlobalArtifactIdentifierFormatException x)
			{
				logger.error("Error building document URN from '" + 
					requestedDocument.getHomeCommunityId() + "-" + 
					requestedDocument.getRepositoryUniqueId() + "-" +
					requestedDocument.getDocumentUniqueId(), x);
			}
			catch (MethodException x)
			{
				logger.error("Method exception getting document '" + 
					requestedDocument.getHomeCommunityId() + "-" + 
					requestedDocument.getRepositoryUniqueId() + "-" +
					requestedDocument.getDocumentUniqueId(), x);
			}
			catch (ConnectionException x)
			{
				logger.error("Connection exception getting document '" + 
					requestedDocument.getHomeCommunityId() + "-" + 
					requestedDocument.getRepositoryUniqueId() + "-" +
					requestedDocument.getDocumentUniqueId(), x);
			}
			catch (IllegalArgumentException x)
			{
				logger.error("Error reading document '" + 
					requestedDocument.getHomeCommunityId() + "-" + 
					requestedDocument.getRepositoryUniqueId() + "-" +
					requestedDocument.getDocumentUniqueId(), x);
			}
			catch (IOException x)
			{
				logger.error("Error reading document '" + 
					requestedDocument.getHomeCommunityId() + "-" + 
					requestedDocument.getRepositoryUniqueId() + "-" +
					requestedDocument.getDocumentUniqueId(), x);
			}
		}		
		
		return response;
	}

	/**
	 * The ADB version of the Cross-Gateway Retrieve.  This is is method to
	 * use when doing a retrieve, the XMLBeans version does not build MTOM
	 * responses.
	 * 
	 * @param retrieveDocumentSetRequest
	 * @return
	 */
	public org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponse respondingGateway_CrossGatewayRetrieve(
			org.ihe.iti.xdsb.adb.RetrieveDocumentSetRequest retrieveDocumentSetRequest)
	{		
    	TransactionContext transactionContext = TransactionContextFactory.get();    	
		transactionContext.setRequestType(webAppName + " Retrieve");
		XCAWebAppRouter router = getRouter();
		XCATranslatorAdb translator;
		//String communityId = Configuration.getString("Translator.local-community-id", null);
		translator = new XCATranslatorAdb();
		CrossGatewayRetrieveRequest[] requests = translator.translate(retrieveDocumentSetRequest);

		org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponse response = 
			new org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponse();
		org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponseType documentSetResponse = 
			new org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponseType();
		org.oasis.ebxml.regrep.rs.adb.RegistryErrorList_type0 registryErrorList = null;

		org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponseTypeSequence_type0 documentResponses = 
			null;

		// for the first request 
		//   if succeeds then set the responseStatus to SUCCESS
		//   if fails then set the responseStatus to FAILURE
		// for succeeding requests
		//   if succeeds and responseStatus is FAILURE then responseStatus is PARTIAL_SUCCESS
		//   if fails and responseStatus is SUCCESS then responseStatus is PARTIAL_SUCCESS
		//   else responseStatus is unchanged
		org.oasis.ebxml.regrep.rim.adb.ReferenceURI responseStatus = null;
		for (CrossGatewayRetrieveRequest request : requests)
		{
			try
			{
				GlobalArtifactIdentifier globalArtifactId = GlobalArtifactIdentifierFactory.create(
					request.getHomeCommunityId(), 
					request.getRepositoryUniqueId(), 
					request.getDocumentUniqueId()
				);
				org.ihe.iti.xdsb.adb.DocumentResponse_type0 documentResponse = new org.ihe.iti.xdsb.adb.DocumentResponse_type0();
				if(globalArtifactId instanceof DocumentURN)
				{
					DocumentURN documentUrn = (DocumentURN)globalArtifactId;
					transactionContext.setUrn(documentUrn.toString());
					transactionContext.setPatientID(documentUrn.getPatientId());
					
					logger.info("Retreiving document [" + documentUrn.toString() + "].");
					DocumentRetrieveResult documentRetrieveResult = router.getDocument(documentUrn);
					boolean successful = (documentRetrieveResult != null && documentRetrieveResult.isSuccessful() ? true : false);
					logger.info("Document [" + documentUrn.toString() + "] was " + 
						(successful ? "successful." : " not successful.") );
					if(documentRetrieveResult == null) 
						logger.error("Exception occurred retreiving document [" + documentUrn.toString() + "].");
					else if(! documentRetrieveResult.isSuccessful())
						logger.error("Exception occurred retreiving document [" + documentUrn.toString() + "].", documentRetrieveResult.getException());
					
					if(successful)
						logDocumentAccess(router, documentUrn);
					
					//LongName mimeType = getMimeType(documentRetrieveResult);
										
					DocumentRetrieveDataSource ds = new DocumentRetrieveDataSource(documentRetrieveResult);
					org.oasis.ebxml.regrep.rim.adb.LongName mimeType = new org.oasis.ebxml.regrep.rim.adb.LongName();				
					mimeType.setLongName(ds.getContentType());
								
					DataHandler dh = new DataHandler(ds);
	
					documentResponse.setDocument(dh);
					documentResponse.setHomeCommunityId(translator.createLongName(documentUrn.getHomeCommunityId()));
					documentResponse.setRepositoryUniqueId(translator.createLongName(documentUrn.getRepositoryUniqueId()));
					documentResponse.setDocumentUniqueId(translator.createLongName(documentUrn.getDocumentUniqueId()));
	
					documentResponse.setMimeType(mimeType);
				}
				else
				{
					String msg = "Home community ID '" + request.getHomeCommunityId() + 
						"', Repository unique ID '" + request.getRepositoryUniqueId() + 
						"' and Document ID '" + request.getDocumentUniqueId() +
						"' do not specify a VA document, request failed.";

					logger.error(msg);
					if(responseStatus == null)
						responseStatus = responseStatusFailure;
					else if(responseStatusSuccess.equals(responseStatus))
						responseStatus = responseStatusPartialSuccess;
				}
				if(documentResponses == null)
					documentResponses = new org.ihe.iti.xdsb.adb.RetrieveDocumentSetResponseTypeSequence_type0();
				documentResponses.addDocumentResponse(documentResponse);
				
				if(responseStatus == null)
					responseStatus = responseStatusSuccess;
				else if(responseStatusFailure.equals(responseStatus))
					responseStatus = responseStatusPartialSuccess;
			}
			catch(ImageNotFoundException infX)
			{
				String msg = "Cannot find VA document specified by Home community ID '" + request.getHomeCommunityId() + 
						"', Repository unique ID '" + request.getRepositoryUniqueId() + 
						"' and Document ID '" + request.getDocumentUniqueId();
				logger.error("ImageNotFoundException, " + msg, infX);
				if(responseStatus == null)
					responseStatus = responseStatusFailure;
				else if(responseStatusSuccess.equals(responseStatus))
					responseStatus = responseStatusPartialSuccess;
				if(registryErrorList == null)
				{
					registryErrorList = new org.oasis.ebxml.regrep.rs.adb.RegistryErrorList_type0();
				}
				registryErrorList.addRegistryError(createRegistryError(msg, 
						ErrorCode.MISSING_DOCUMENT, request.getRepositoryUniqueId()));			
			}
			catch (MethodException mX)
			{
				String msg = "Exception finding VA document specified by Home community ID '" + request.getHomeCommunityId() + 
					"', Repository unique ID '" + request.getRepositoryUniqueId() + 
					"' and Document ID '" + request.getDocumentUniqueId();
				logger.error("MethodException, " + msg, mX);
				if(responseStatus == null)
					responseStatus = responseStatusFailure;
				else if(responseStatusSuccess.equals(responseStatus))
					responseStatus = responseStatusPartialSuccess;
				if(registryErrorList == null)
				{
					registryErrorList = new org.oasis.ebxml.regrep.rs.adb.RegistryErrorList_type0();
				}
				registryErrorList.addRegistryError(createRegistryError(msg, 
						ErrorCode.REPOSITORY_ERROR, request.getRepositoryUniqueId()));			
			}
			catch (ConnectionException cX)
			{
				String msg = "Exception finding VA document specified by Home community ID '" + request.getHomeCommunityId() + 
					"', Repository unique ID '" + request.getRepositoryUniqueId() + 
					"' and Document ID '" + request.getDocumentUniqueId();
				logger.error("ConnectionException, " + msg, cX);
				if(responseStatus == null)
					responseStatus = responseStatusFailure;
				else if(responseStatusSuccess.equals(responseStatus))
					responseStatus = responseStatusPartialSuccess;
				if(registryErrorList == null)
				{
					registryErrorList = new org.oasis.ebxml.regrep.rs.adb.RegistryErrorList_type0();
				}
				registryErrorList.addRegistryError(createRegistryError(msg, 
						ErrorCode.REPOSITORY_ERROR, request.getRepositoryUniqueId()));	
			}
			catch (GlobalArtifactIdentifierFormatException x)
			{
				String msg = "The identifiers '" + 
					request.getHomeCommunityId() + ":" + request.getRepositoryUniqueId() + ":" + request.getDocumentUniqueId() +
					"' could not be used to form a valid VA document URN."; 
				logger.error("GlobalArtifactIdentifierFormatException, " + msg, x);
				if(responseStatus == null)
					responseStatus = responseStatusFailure;
				else if(responseStatusSuccess.equals(responseStatus))
					responseStatus = responseStatusPartialSuccess;
				if(registryErrorList == null)
				{
					registryErrorList = new org.oasis.ebxml.regrep.rs.adb.RegistryErrorList_type0();
				}
				registryErrorList.addRegistryError(createRegistryError(msg, 
						ErrorCode.REPOSITORY_ERROR, request.getRepositoryUniqueId()));	
			}
		}
		documentSetResponse.setRetrieveDocumentSetResponseTypeSequence_type0(documentResponses);

		org.oasis.ebxml.regrep.rs.adb.RegistryResponseType responseType = 
			new org.oasis.ebxml.regrep.rs.adb.RegistryResponseType();
		responseType.setStatus(responseStatus);
		if(registryErrorList != null)
			responseType.setRegistryErrorList(registryErrorList);

		documentSetResponse.setRegistryResponse(responseType);
		response.setRetrieveDocumentSetResponse(documentSetResponse);
		
		return response;    	
	}	
	
	/**
	 * Create a RegistryError from contents of an exception
	 * @param exceptionMessage The message to send, should not necessarily use details of Exception.getMessage() since that might expose internals of the VIX
	 * @param errorCode
	 * @param location
	 * @return
	 */
	private org.oasis.ebxml.regrep.rs.adb.RegistryError_type0 createRegistryError(String exceptionMessage, ErrorCode errorCode,
			String location)
	{
		org.oasis.ebxml.regrep.rs.adb.RegistryError_type0 error = 
			new org.oasis.ebxml.regrep.rs.adb.RegistryError_type0();
		error.setLocation(location);
		error.setErrorCode(errorCode.getOpcode());
		error.setCodeContext(exceptionMessage);
		error.setString(exceptionMessage);
		return error;
	}
	
	private void logDocumentAccess(XCAWebAppRouter router, DocumentURN documentUrn)
	{
		try
		{
			router.postDocumentAccessEventRetryable(createLogEvent(documentUrn));
		}
		catch(Exception x)
		{
			logger.warn("Exception logging access to image '" + documentUrn.toString() + "', " + x);
		}
	}
	
	private ImageAccessLogEvent createLogEvent(DocumentURN documentUrn)
	{
		ImageAccessLogEvent logEvent = new ImageAccessLogEvent(documentUrn.getDocumentId(), "",
				documentUrn.getPatientId(),
				documentUrn.getOriginatingSiteId(), System.currentTimeMillis(), "", "",
				ImageAccessLogEventType.IMAGE_ACCESS, false, ExchangeUtil.getDodSiteNumber());
		return logEvent;
	}

	/**
	 * 
	 * @author vhaiswbeckec
	 *
	 */
	class DocumentResultListener 
	implements AsynchronousCommandResultListener<DocumentRetrieveResult>
	{
		DocumentResultListener()
		{

		}

		@Override
		public void commandComplete(AsynchronousCommandResult<DocumentRetrieveResult> result)
		{
			if (result.getResult() instanceof DocumentRetrieveResult)
			{
				//DocumentRetrieveResult retrieveResult = result.getResult();
			}
			else
			{
				logger.error("Received an asynchronous result of type '" + result.getResult() == null ? "<null>" : result.getResult().getClass().getName() + "' but was expecting a result of type '" + DocumentRetrieveResult.class.getName() + "'.");
			}
		}
	};
	
	
	/**
	 * Get the list of sites that are NOT included in the results
	 * regardless of whether there are results there.
	 * 
	 * @return
	 */
	private List<String> getExcludedSites()
	{
		List<String> excludedSites = new ArrayList<String>();
		
		//String developmentExcludedSites = DevelopmentConfiguration.getString("RespondingGateway.ExcludedSites");
		String productionExcludedSites = Configuration.getString("RespondingGateway.ExcludedSites", null);
		
		//excludedSites.addAll(parseCommaSeperatedList(developmentExcludedSites));
		excludedSites.addAll(parseCommaSeperatedList(productionExcludedSites));
		
		return excludedSites;
	}

	/**
	 * Parse a comma seperated String into a list of String
	 * 
	 * @param sites
	 * @return
	 */
	private List<String> parseCommaSeperatedList(String sites)
	{
		if(sites == null)
			return new ArrayList<String>(0);
		
		List<String> siteList = new ArrayList<String>();
		String[] siteArray = sites.split(",");
		for(String site : siteArray)
			siteList.add(site.trim());
		
		return siteList;
	}

	/**
	 * 
	 * @param in
	 * @return
	 */
	public byte[] inputStreamToBytes(InputStream in)
	{

		ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
		try
		{
			byte[] buffer = new byte[1024];
			int len;

			while ((len = in.read(buffer)) >= 0)
				out.write(buffer, 0, len);

			in.close();
			out.close();
		}
		catch (IOException ioe)
		{
			logger.error("Exception converting InputStream to ByteArray", ioe); //$NON-NLS-1$
			ioe.printStackTrace();
		}
		return out.toByteArray();
	}
	
	/**
	 * For development use, rather than require a certificate for authentication, stuff a development
	 * account into the transaction context.
	 * 
	 * @return
	 * @deprecated This method should no longer be used, all these properties should be set properly by the realm
	 */
	private static void setDevelopmentSecurityContext()
	{
		if( DevelopmentConfiguration.getBoolean("RespondingGateway.allowDevelopmentSecurityContext").booleanValue() )
		{
			// JMW HACK - need to have context values so Router can use them
			List<String> roles = new ArrayList<String>();
			ClientPrincipal principal = new ClientPrincipal(
					DevelopmentConfiguration.getString("RespondingGateway.DevelopmentSiteNumber"), true, AuthenticationCredentialsType.Password,  //$NON-NLS-1$
					DevelopmentConfiguration.getString("RespondingGateway.DevelopmentAccessCode"), DevelopmentConfiguration.getString("RespondingGateway.DevelopmentVerifyCode"),  //$NON-NLS-1$ //$NON-NLS-2$
					DevelopmentConfiguration.getString("RespondingGateway.DevelopmentDuz"), DevelopmentConfiguration.getString("RespondingGateway.DevelopmentUserName"), "843924956", DevelopmentConfiguration.getString("RespondingGateway.DevelopmentUserSite"), DevelopmentConfiguration.getString("RespondingGateway.DevelopmentSiteName"),  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
					roles, 
					new HashMap<String, Object>()
			);
			TransactionContextFactory.createClientTransactionContext(principal);
			
			TransactionContext transactionContext = TransactionContextFactory.get();
			transactionContext.setDuz(DevelopmentConfiguration.getString("RespondingGateway.DevelopmentDuz")); //$NON-NLS-1$
			transactionContext.setFullName(DevelopmentConfiguration.getString("RespondingGateway.DevelopmentUserName")); //$NON-NLS-1$
			transactionContext.setSsn(DevelopmentConfiguration.getString("RespondingGateway.DevelopmentSSN")); //$NON-NLS-1$
			transactionContext.setSiteName(DevelopmentConfiguration.getString("RespondingGateway.DevelopmentSiteName")); //$NON-NLS-1$
			
			// JMW HACK
			// need local site number - used by command to get treating facility list
			transactionContext.setSiteNumber(DevelopmentConfiguration.getString("RespondingGateway.DevelopmentSiteNumber")); //$NON-NLS-1$
		}
		return;
	} 
	

}
