/**
 * 
 */
package gov.va.med.imaging.ihe.xca.query;

import gov.va.med.URNFactory;
import gov.va.med.imaging.exceptions.URNFormatException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author vhaiswbeckec
 *
 */
public class Configuration
{
	private static final String BUNDLE_NAME = "gov.va.med.imaging.ihe.xca.configuration"; //$NON-NLS-1$
	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
	private static final Logger logger = LogManager.getLogger(Configuration.class);

	private Configuration()
	{
	}

	public static String getString(String key, String defaultValue)
	{
		try
		{
			return RESOURCE_BUNDLE.getString(key);
		}
		catch (MissingResourceException e)
		{
			logger.warn("Missing configuration key '" + key + "', using default value " + defaultValue);
			return defaultValue;
		}
	}
	
	/**
	 * 
	 * @param key
	 * @param defaultValue
	 * @return
	 */
	public static int getInt(String key, int defaultValue)
	{
		try
		{
			return Integer.parseInt( RESOURCE_BUNDLE.getString(key) );
		}
		catch (MissingResourceException mrX)
		{
			logger.warn("Missing configuration key '" + key + "', using default value " + defaultValue);
			return defaultValue;
		}
		catch (NumberFormatException nfX)
		{
			logger.warn("Invalid format configuration key '" + key + "', using default value " + defaultValue);
			return defaultValue;
		}
	}
	
	/**
	 * 
	 * @param key
	 * @param defaultValue
	 * @return
	 */
	public static float getFloat(String key, float defaultValue)
	{
		try
		{
			return Float.parseFloat( RESOURCE_BUNDLE.getString(key) );
		}
		catch (MissingResourceException mrX)
		{
			logger.warn("Missing configuration key '" + key + "', using default value " + defaultValue);
			return defaultValue;
		}
		catch (NumberFormatException nfX)
		{
			logger.warn("Invalid format configuration key '" + key + "', using default value " + defaultValue);
			return defaultValue;
		}
	}
}
