/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 7, 2008
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ihe.xca.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.ihe.xca.datasource.configuration.XCADataSourceConfiguration;
import gov.va.med.imaging.proxy.ssl.AuthSSLProtocolSocketFactory;
import gov.va.med.net.TLSUtility;

/**
 * Common utilities for all Xca data sources
 * 
 * @author       WERFEJ
 *
 */
public class XCAProxyUtilities 
{	
	private final static Logger logger = LogManager.getLogger(XCAProxyUtilities.class);
	
	/**
	 * Configure the Xca certificate protocol to use certificates to communicate with remote server
	 * @param XcaConfiguration The configuration for the Xca data source
	 */
	public static void configureXcaCertificate(XCADataSourceConfiguration xcaConfiguration)
	{
		try
		{			
			logger.info("Configuring XCA Certificate...");
		    URL keystoreUrl = new URL(xcaConfiguration.getKeystoreUrl());	// the keystore containing the key to send as the client
		    URL truststoreUrl = new URL(xcaConfiguration.getTruststoreUrl());	// the keystore containing the trusted certificates, to validate the server cert against
		    		    		   
		    ProtocolSocketFactory socketFactory = 
		        new AuthSSLProtocolSocketFactory(keystoreUrl, 
		        		xcaConfiguration.getKeystorePassword(), truststoreUrl, 
		        		xcaConfiguration.getTruststorePassword());
		    Protocol httpsProtocol = new Protocol(xcaConfiguration.getTLSProtocol(), socketFactory, xcaConfiguration.getTLSPort());	
	
		    Protocol.registerProtocol(xcaConfiguration.getTLSProtocol(), httpsProtocol);
		    LogManager.getLogger(XCAProxyUtilities.class).info("XCA HTTPS protocol handler successfully registered.");
		    ( new TLSUtility(System.out) ).dumpSSLProperties();
		} 
		catch (MalformedURLException e)
		{
		    LogManager.getLogger(XCAProxyUtilities.class).error(
			    "Error configuring HTTPS client within XCA proxy. \n" +
			    "Keystore and/or truststore are unavailable. \n" +
			    "XCA functionality will not be available.");
		}
	}
}
