/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 5, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author vhaiswbeckec
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.io;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.TransferSyntaxUid;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRException;
import gov.va.med.imaging.dicom.exceptions.InvalidVRModeException;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

import junit.framework.TestCase;

/**
 * @author vhaiswbeckec
 *
 */
public class TestDataSetReader 
extends AbstractDataSetReadTest
{
	/**
	 * Test method for {@link gov.va.med.imaging.dicom.io.DataSetReader#readDataSet()}.
	 * @throws DicomFormatException 
	 * @throws InvalidVRException 
	 * @throws InvalidVRModeException 
	 * @throws IOException 
	 * @throws UnsupportedOperationException 
	 */
	public final void testReadRootDataSet() 
	throws UnsupportedOperationException, IOException, InvalidVRModeException, InvalidVRException, DicomFormatException
	{
		DataElementFactory dataElementFactory = 
			DataElementFactory.getDataElementFactory(TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN);
		DataInputStream inStream = new DataInputStream( 
			this.getClass().getClassLoader().getResourceAsStream("elements/SequenceTagDelimited_ItemsDelimited.del") );
		DataElementLimitedInputStream dataElementInputStream = new DataElementLimitedInputStream(inStream, TransferSyntaxUid.RAW_EXPLICIT_VR_LITTLEENDIAN);
		DataSetReader reader = new DataSetReader(dataElementInputStream, dataElementFactory);
		DataSet dataSet = reader.readDataSet();
		
		DataElement dataElement = dataSet.get(0x0008, 0x1140);
		assertNotNull(dataElement);
	}

}
