/**
 * Date Created: Apr 25, 2017
 * Developer: vhaisltjahjb
 */
package gov.va.med.imaging.viewer.rest.translator;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.exchange.business.ImageAccessReason;
import gov.va.med.imaging.viewer.ViewerImagingContext;
import gov.va.med.imaging.viewer.business.DeleteImageUrn;
import gov.va.med.imaging.viewer.business.DeleteImageUrnResult;
import gov.va.med.imaging.viewer.business.DeleteReasonsType;
import gov.va.med.imaging.viewer.business.FlagSensitiveImageUrn;
import gov.va.med.imaging.viewer.business.FlagSensitiveImageUrnResult;
import gov.va.med.imaging.viewer.business.LogAccessImageUrn;
import gov.va.med.imaging.viewer.business.LogAccessImageUrnResult;
import gov.va.med.imaging.viewer.business.PrintReasonsType;
import gov.va.med.imaging.viewer.rest.types.DeleteImageUrnResultType;
import gov.va.med.imaging.viewer.rest.types.DeleteImageUrnResultsType;
import gov.va.med.imaging.viewer.rest.types.DeleteImageUrnType;
import gov.va.med.imaging.viewer.rest.types.DeleteImageUrnsType;
import gov.va.med.imaging.viewer.rest.types.FlagSensitiveImageUrnResultType;
import gov.va.med.imaging.viewer.rest.types.FlagSensitiveImageUrnResultsType;
import gov.va.med.imaging.viewer.rest.types.FlagSensitiveImageUrnType;
import gov.va.med.imaging.viewer.rest.types.FlagSensitiveImageUrnsType;
import gov.va.med.imaging.viewer.rest.types.LogAccessImageUrnResultType;
import gov.va.med.imaging.viewer.rest.types.LogAccessImageUrnResultsType;
import gov.va.med.imaging.viewer.rest.types.LogAccessImageUrnType;
import gov.va.med.imaging.viewer.rest.types.LogAccessImageUrnsType;
import gov.va.med.imaging.viewer.rest.types.UserInfoType;
import gov.va.med.imaging.viewer.rest.types.UserSecurityKeyType;
import gov.va.med.imaging.viewer.rest.types.UserSecurityKeysType;


/**
 * @author vhaisltjahjb
 *
 */
public class ViewerImagingRestTranslator
{
	private final static Logger logger = LogManager.getLogger(ViewerImagingContext.class);
	
	public static List<DeleteImageUrn> translateImageUrns(DeleteImageUrnsType imageUrns) 
	{
		if(imageUrns == null)
			return null;
		
		String defaultReason = imageUrns.getDefaultDeleteReason();
				
		List<DeleteImageUrn> result = new ArrayList<DeleteImageUrn>();
		
		for(DeleteImageUrnType item : imageUrns.getDeleteImageUrns())
		{
			if ((item.getReason() == null) || item.getReason().isEmpty())
			{
				if (defaultReason != null)
				{
					item.setReason(defaultReason);
				}
			}
			if ((item.getDeleteGroup() == null) || item.getDeleteGroup().isEmpty())
			{
				item.setDeleteGroup("false");
			}
			result.add(translateDeleteImageUrn(item));
		}
		return result;
	}

	private static DeleteImageUrn translateDeleteImageUrn(
			DeleteImageUrnType item) {
		return new DeleteImageUrn(
				item.getValue(),
				(item.getDeleteGroup().equals("true") ? true : false),
				item.getReason());
	}

	public static DeleteImageUrnResultsType translateDeleteImageUrnResults(List<DeleteImageUrnResult> deleteImageUrns)
	{
		if(deleteImageUrns == null)
			return null;
		
		DeleteImageUrnResultType[] result = new DeleteImageUrnResultType[deleteImageUrns.size()];
		for(int i = 0; i < deleteImageUrns.size(); i++)
		{
			result[i] = translate(deleteImageUrns.get(i));			
		}
		return new DeleteImageUrnResultsType(result);
		
	}
	
	public static DeleteImageUrnResultType translate(DeleteImageUrnResult deleteImageUrnResult)
	{
		return new DeleteImageUrnResultType(
				deleteImageUrnResult.getValue(),
				deleteImageUrnResult.getResult().equals("1")?"SUCCESS":"ERROR",
				deleteImageUrnResult.getResult().equals("1")?"":deleteImageUrnResult.getMsg()
				);
	}

	public static DeleteReasonsType translateDeleteReasons(
			List<ImageAccessReason> routerResult) {
		
		String[] deleteReasons = new String[routerResult.size()];
		int idx = 0;
		for(ImageAccessReason delReason : routerResult)
		{
			deleteReasons[idx] = delReason.getDescription();
			idx++;
		}
		
		return new DeleteReasonsType(deleteReasons);
	}

	public static PrintReasonsType translatePrintReasons(
			List<ImageAccessReason> routerResult) 
	{
	
		String[] printReasons = new String[routerResult.size()];
		int idx = 0;
		for(ImageAccessReason prtReason : routerResult)
		{
			printReasons[idx] = prtReason.getDescription();
			idx++;
		}
		
		return new PrintReasonsType(printReasons);
	}
	
	public static List<FlagSensitiveImageUrn> translateImageUrns(FlagSensitiveImageUrnsType imageUrns) 
	{
		if(imageUrns == null)
			return null;
		
		String defaultSensitive = imageUrns.getDefaultSensitive();
		
		List<FlagSensitiveImageUrn> result = new ArrayList<FlagSensitiveImageUrn>();
		
		for(FlagSensitiveImageUrnType item : imageUrns.getFlagSensitiveImageUrns())
		{
			if ((item.getSensitive() == null) || item.getSensitive().isEmpty())
			{
				if (defaultSensitive != null)
				{
					item.setSensitive(defaultSensitive);
				}
			}
			
			result.add(translateFlagSensitiveImageUrn(item));
		}
		return result;
	}

	private static FlagSensitiveImageUrn translateFlagSensitiveImageUrn(
			FlagSensitiveImageUrnType item) {
		return new FlagSensitiveImageUrn(
				item.getImageUrn(),
				(item.getSensitive().equals("true") ? true : false));
	}


	public static FlagSensitiveImageUrnResultsType translateFlagSensitiveImageUrnResults(List<FlagSensitiveImageUrnResult> imageUrns)
	{
		if(imageUrns == null)
			return null;
		
		FlagSensitiveImageUrnResultType[] result = new FlagSensitiveImageUrnResultType[imageUrns.size()];
		for(int i = 0; i < imageUrns.size(); i++)
		{
			result[i] = translate(imageUrns.get(i));			
		}
		return new FlagSensitiveImageUrnResultsType(result);
	}
	
	public static FlagSensitiveImageUrnResultType translate(FlagSensitiveImageUrnResult imageUrnResult)
	{
		return new FlagSensitiveImageUrnResultType(
				imageUrnResult.getImageUrn(),
				imageUrnResult.getResult().equals("1")?"SUCCESS":"ERROR",
				imageUrnResult.getResult().equals("1")?"":imageUrnResult.getMsg()
				);
	}

	public static UserInfoType translateUserInfo(List<String> routerResult) 
	{
		if(routerResult == null)
			return null;
		
		String[] securityKeys = new String[routerResult.size()-1];
		for(int i = 0; i < routerResult.size()-1; i++)
		{
			logger.debug("key: " + routerResult.get(i));
			securityKeys[i] = routerResult.get(i);			
		}
		
		String userInfo = routerResult.get(routerResult.size() - 1);
		logger.debug("userInfo: " + userInfo);
		String[] user = userInfo.split("\\^");
		String userName = user[0];
		String userInitials = user[1];
		
		return new UserInfoType(userName, userInitials, new UserSecurityKeysType(securityKeys));
	}

	public static List<LogAccessImageUrn> translateImageUrns(LogAccessImageUrnsType imageUrns) 
	{
		if(imageUrns == null)
			return null;
		
		String defaultAccessReason = imageUrns.getDefaultLogAccessReason();
		
		List<LogAccessImageUrn> result = new ArrayList<LogAccessImageUrn>();
		
		for(LogAccessImageUrnType item : imageUrns.getLogAccessImageUrns())
		{
			if ((item.getReason() == null) || item.getReason().isEmpty())
			{
				if (defaultAccessReason != null)
				{
					item.setReason(defaultAccessReason);
				}
			}
			
			result.add(translateLogAccessImageUrn(item));
		}
		return result;
	}

	private static LogAccessImageUrn translateLogAccessImageUrn(
			LogAccessImageUrnType item) {
		return new LogAccessImageUrn(
				item.getValue(),
				item.getReason());
	}

	public static LogAccessImageUrnResultsType translateLogAccessImageUrnResults(
			List<LogAccessImageUrnResult> imageUrns)
	{
		if(imageUrns == null)
			return null;
		
		LogAccessImageUrnResultType[] result = new LogAccessImageUrnResultType[imageUrns.size()];
		for(int i = 0; i < imageUrns.size(); i++)
		{
			result[i] = translate(imageUrns.get(i));			
		}
		return new LogAccessImageUrnResultsType(result);
	}
	
	public static LogAccessImageUrnResultType translate(LogAccessImageUrnResult imageUrnResult)
	{
		return new LogAccessImageUrnResultType(
				imageUrnResult.getImageUrn(),
				imageUrnResult.getResult().equals("1")?"SUCCESS":"ERROR",
				imageUrnResult.getResult().equals("1")?"":imageUrnResult.getMsg()
				);
	}

}
