/**
 * 
 * Date Created: Apr 26, 2017
 * Developer: vhaisltjahjb
 */
package gov.va.med.imaging.viewer.datasource;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.URNFactory;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.url.vista.StringUtils;
import gov.va.med.imaging.viewer.business.DeleteImageUrnResult;
import gov.va.med.imaging.viewer.business.FlagSensitiveImageUrnResult;
import gov.va.med.imaging.viewer.business.LogAccessImageUrnResult;

/**
 * @author vhaisltjahjb
 *
 */
public class ViewerImagingTranslator
{
	private final static Logger logger = LogManager.getLogger(ViewerImagingTranslator.class);
	
	public static List<DeleteImageUrnResult> translateDeleteImagesResult(
			String deleteImagesResult, 
			Map<String, String> imageUrnMap)
	{
		List<DeleteImageUrnResult> rows = new ArrayList<DeleteImageUrnResult>();
		
		String [] lines = StringUtils.Split(deleteImagesResult, StringUtils.NEW_LINE);
		
		for(int i = 0; i < lines.length; i++)
		{
			DeleteImageUrnResult deleteResult = new DeleteImageUrnResult(
					imageUrnMap.get(StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 1)),
					StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 2),
					StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 3)
					);
			rows.add(deleteResult);
		}
		
		return rows;
		
	}
	
	public static String getImageIen(String imageUrn)
	{
		ImageURN urn;
		try {
			urn = URNFactory.create(imageUrn, ImageURN.class);
			if ((urn.getImageId() == null) || (urn.getImageId().isEmpty()))
			{
				return imageUrn;
			}
			else
			{
				return urn.getImageId();
			}
		} catch (URNFormatException e) {
			return imageUrn;
		}
	}
	
	public static List<FlagSensitiveImageUrnResult> translateFlagSensitiveImagesResult(
			String flagSensitiveImagesResult, 
			Map<String, String> imageUrnMap)
	{
		List<FlagSensitiveImageUrnResult> rows = new ArrayList<FlagSensitiveImageUrnResult>();
		
		String [] lines = StringUtils.Split(flagSensitiveImagesResult, StringUtils.NEW_LINE);
		
		for(int i = 0; i < lines.length; i++)
		{
			FlagSensitiveImageUrnResult flagResult = new FlagSensitiveImageUrnResult(
					imageUrnMap.get(StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 1)),
					StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 2),
					StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 3)
					);
			rows.add(flagResult);
		}
		
		return rows;
		
	}

	public static List<LogAccessImageUrnResult> translateLogAccessImagesResult(
			String logAccessImagesResult, 
			Map<String, String> imageUrnMap)
	{
		List<LogAccessImageUrnResult> rows = new ArrayList<LogAccessImageUrnResult>();
		
		String [] lines = StringUtils.Split(logAccessImagesResult, StringUtils.NEW_LINE);
		
		for(int i = 0; i < lines.length; i++)
		{
			LogAccessImageUrnResult logAccessResult = new LogAccessImageUrnResult(
					imageUrnMap.get(StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 1)),
					StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 2),
					StringUtils.MagPiece(lines[i].trim(), StringUtils.CARET, 3)
					);
			rows.add(logAccessResult);
		}
		
		return rows;
		
	}
	
	public static List<DeleteImageUrnResult> mergeDeleteImagesErrorResult(
			List<DeleteImageUrnResult> deletedList, List<String> p34ImageUrns)
	{
		if (deletedList == null)
		{
			deletedList = new ArrayList<DeleteImageUrnResult>();
		}
		
		for (String p34ImageUrn: p34ImageUrns)
		{
			DeleteImageUrnResult deleteResult = new DeleteImageUrnResult(
				p34ImageUrn,
				"ERROR",
				"Deleting this URN type has not been implemented");
			deletedList.add(deleteResult);
		}

		return deletedList;
		
	}

	public static List<LogAccessImageUrnResult> mergeLogAccessErrorResult(
			List<LogAccessImageUrnResult> logAccessList, List<String> p34ImageUrns)
	{
		if (logAccessList == null)
		{
			logAccessList = new ArrayList<LogAccessImageUrnResult>();
		}

		for (String p34ImageUrn: p34ImageUrns)
		{
		
			LogAccessImageUrnResult logAccessResult = new LogAccessImageUrnResult(
				p34ImageUrn,
				"ERROR",
				"Logging Access of this URN type has not been implemented");
			logAccessList.add(logAccessResult);
		}
		
		return logAccessList;
		
	}
	
	public static List<FlagSensitiveImageUrnResult> mergeFlagSensitiveErrorResult(
			List<FlagSensitiveImageUrnResult> flagSensitiveList, List<String> p34ImageUrns)
	{
		if (flagSensitiveList == null)
		{
			flagSensitiveList = new ArrayList<FlagSensitiveImageUrnResult>();
		}

		for (String p34ImageUrn: p34ImageUrns)
		{
			FlagSensitiveImageUrnResult flagResult = new FlagSensitiveImageUrnResult(
				p34ImageUrn,
				"ERROR",
				"Marking this URN type as sensitive has not been implemented");
			flagSensitiveList.add(flagResult);
		}
		
		return flagSensitiveList;
		
	}
	
}
