/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 27, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.roi.web;

import gov.va.med.imaging.core.router.PeriodicCommandList;
import gov.va.med.imaging.facade.configuration.EncryptedConfigurationPropertyString;
import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;
import gov.va.med.imaging.roi.commands.periodic.DeleteOldCompletedROIWorkItemsCommandImpl;
import gov.va.med.imaging.roi.commands.periodic.PeriodicROICommandStarter;
import gov.va.med.imaging.roi.commands.periodic.ProcessROIPeriodicRequestsCommandImpl;
import gov.va.med.imaging.roi.commands.periodic.configuration.ROIPeriodicCommandConfiguration;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class UpdateROIConfigurationServlet
extends HttpServlet
{
	private static final long serialVersionUID = 355115428647804392L;
	private final static Logger logger = LogManager.getLogger(UpdateROIConfigurationServlet.class);

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		try
		{
			String accessCode = request.getParameter("accessCode");
			String verifyCode = request.getParameter("verifyCode");
			
			String periodicProcessingEnabled = request.getParameter("periodicProcessingEnabled");
			String completedItemPurgeProcessingEnabled = request.getParameter("completedItemPurgeProcessingEnabled");
			String expiredCompletedItemsAfterDays = request.getParameter("expiredCompletedItemsAfterDays");
			String processDisclosuresImmediately = request.getParameter("processDisclosuresImmediately");
			String processingWorkItemWaitTime = request.getParameter("processingWorkItemWaitTime");
			
			
			ROIPeriodicCommandConfiguration configuration = ROIPeriodicCommandConfiguration.getROIPeriodicCommandConfiguration();
			configuration.setAccessCode(new EncryptedConfigurationPropertyString(accessCode));
			configuration.setVerifyCode(new EncryptedConfigurationPropertyString(verifyCode));			
			configuration.setPeriodicROIProcessingEnabled("TRUE".equalsIgnoreCase(periodicProcessingEnabled));
			configuration.setProcessWorkItemImmediately("TRUE".equalsIgnoreCase(processDisclosuresImmediately));
			configuration.setExpireCompletedItemsEnabled("TRUE".equalsIgnoreCase(completedItemPurgeProcessingEnabled));
			
			int val = parseStringInt(expiredCompletedItemsAfterDays);
			if(val > 0)
				configuration.setExpireCompletedItemsAfterDays(val);
			else
				logger.warn("Cannot set Expire Completed Items After Days to value '" + expiredCompletedItemsAfterDays + "'.");
			
			val = parseStringInt(processingWorkItemWaitTime);
			if(val > 0)
				configuration.setProcessingWorkItemWaitTime(val);
			else
				logger.warn("Cannot set Processing Work Item Wait time to value '" + processingWorkItemWaitTime + "'.");
			
			
			logger.info("Updating ROIPeriodicCommandConfiguration with new access and verify codes");
			configuration.storeConfiguration();
			FacadeConfigurationFactory.getConfigurationFactory().clearConfiguration(ROIPeriodicCommandConfiguration.class);
			
			// no matter what terminate the two commands, need to restart them with the new credentials if they are re-enabled.
			PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessROIPeriodicRequestsCommandImpl.class);
			PeriodicCommandList.get().terminateScheduledPeriodicCommand(DeleteOldCompletedROIWorkItemsCommandImpl.class);
						
			PeriodicROICommandStarter.startROIPeriodicCommands();
			
			response.sendRedirect("ConfigureROI.jsp?result=Successfully updated ROI Configuration");
		}
		catch(Exception ex)
		{
			logger.error("Error updating ROIPeriodicCommandConfiguration, " + ex.getMessage(), ex);
			response.sendRedirect("ConfigureROI.jsp?error=Error updating ROI Configuration");
		}
	}
	
	private int parseStringInt(String stringValue)
	{
		try
		{
			int val = Integer.parseInt(stringValue);
			if(val <= 0)
				val = -1;
			return val;
		}
		catch(NumberFormatException nfX)
		{
			return -1;
		}
	}

}
