package p34.uid;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;

public class CheckUIDTests extends BaseTest
{
	private static Logger logger = LogManager.getLogger(CheckUIDTests.class);

	// ----------------------------------------- Tests on existing data --------------------------
//	
//	public void testNoDuplicateUIDs1() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_ACC_NewStudyAndSeriesAndImageUIDs();
//		doUIDTestCase("1", info, false);
//	}
//
//	
//	public void testNoDuplicateUIDs2() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_ACC_NewSeriesAndImageUIDs();
//		doUIDTestCase("2", info, false);
//	}
//
//	
//	public void testNoDuplicateUIDs3() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_ACC_NewImageUID();
//		doUIDTestCase("3", info, false);
//	}
//
//
//	
//	public void testDuplicateStudyUID() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_REJ_DuplicateStudyUID();
//		doUIDTestCase("4", info, false);
//	}
//	
//	
//	public void testDuplicateSeriesUID() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_REJ_DuplicateSeriesUID();
//		doUIDTestCase("5", info, false);
//	}
//
//	
//	public void testDuplicateImageUID1() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_REJ_DuplicateImageUIDInsideStudy();
//		doUIDTestCase("6", info, false);
//	}
//
//	
//	public void testDuplicateImageUID2() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_REJ_DuplicateImageUIDOutsideStudy();
//		doUIDTestCase("7", info, false);
//	}
//	
//	
//	public void testDuplicateAllUIDs() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316__REJ_MatchingEverything();
//		doUIDTestCase("8", info, false);
//	}
//	
//	
//	public void testWrongDFN() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_REJ_WrongDFN();
//
//		UIDCheckResults stdRes = new UIDCheckResults("Study UID check 9",
//				UIDCheckDataSource.checkStudyUID(connection, info),
//				info.getStudyInstanceUID());
//		assertTrue(stdRes.isFatalError()); // shouldn't it say what error it is (wrong DFN)
//	}
//	
//	
//	public void testWrongCase() throws Exception
//	{
//		// Replace these with the actual test values...
//		UIDCheckInfo info = HISDataObjects.UIDCheckForCase316_REJ_WrongCase();
//
//		UIDCheckResults stdRes = new UIDCheckResults("Study UID check 10",
//				UIDCheckDataSource.checkStudyUID(connection, info),
//				info.getStudyInstanceUID());
//		assertTrue(stdRes.isFatalError()); // shouldn't it say what error it is (wrong Acc#)
//	}

		// -------------------------------- 27 test cases for new Patients ---------------------------
	@Test
	public void testCaseP1O1_AllNew() throws Exception {				// #01
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_AllNew();
		doUIDTestCase("01", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_exiStd_newSer_newSOP() throws Exception {	// #02
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_newSer_newSOP();
		doUIDTestCase("02", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_exiStd_exiSer_newSOP() throws Exception {	// #03
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_exiSer_newSOP();
		doUIDTestCase("03", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_exiStd_exiSer_exiSOP() throws Exception {	// #04
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_exiSer_exiSOP();
		doUIDTestCase("04", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_dupStd_newSer_newSOP() throws Exception {	// #05
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_newSer_newSOP();
		doUIDTestCase("05", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_exiStd_dupSer_newSOP() throws Exception {	// #06
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_dupSer_newSOP();
		doUIDTestCase("06", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_exiStd_exiSer_dupSOP() throws Exception {	// #07
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_exiSer_dupSOP();
		doUIDTestCase("07", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_dupStd_dupSer_newSOP() throws Exception {	// #08
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_dupSer_newSOP();
		doUIDTestCase("08", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_dupStd_dupSer_dupSOP() throws Exception {	// #09
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_dupSer_dupSOP();
		doUIDTestCase("09", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_dupStd_exiSer_newSOP() throws Exception {	// #10
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_exiSer_newSOP();
		doUIDTestCase("10", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_dupStd_exiSer_exiSOP() throws Exception {	// #11
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_exiSer_exiSOP();
		doUIDTestCase("11", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_dupStd_dupSer_exiSOP() throws Exception {	// #12
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_dupSer_exiSOP();
		doUIDTestCase("12", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_dupStd_exiSer_dupSOP() throws Exception {	// #13
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_exiSer_dupSOP();
		doUIDTestCase("13", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_dupStd_newSer_exiSOP() throws Exception {	// #14
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_newSer_exiSOP();
		doUIDTestCase("14", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_dupStd_newSer_dupSOP() throws Exception {	// #15
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_dupStd_newSer_dupSOP();
		doUIDTestCase("15", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_exiStd_dupSer_exiSOP() throws Exception {	// #16
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_dupSer_exiSOP();
		doUIDTestCase("16", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_exiStd_dupSer_dupSOP() throws Exception {	// #17
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_dupSer_dupSOP();
		doUIDTestCase("17", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_exiStd_newSer_dupSOP() throws Exception {	// #18
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_newSer_dupSOP();
		doUIDTestCase("18", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_exiStd_newSer_exiSOP() throws Exception {	// #19
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_newSer_exiSOP();
		doUIDTestCase("19", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_newStd_newSer_exiSOP() throws Exception {	// #20
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_newSer_exiSOP();
		doUIDTestCase("20", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_newStd_newSer_dupSOP() throws Exception {	// #21
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_newSer_dupSOP();
		doUIDTestCase("21", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_newStd_exiSer_newSOP() throws Exception {	// #22
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_exiSer_newSOP();
		doUIDTestCase("22", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_newStd_exiSer_exiSOP() throws Exception {	// #23
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_exiSer_exiSOP();
		doUIDTestCase("23", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_newStd_exiSer_dupSOP() throws Exception {	// #24
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_exiSer_dupSOP();
		doUIDTestCase("24", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_newStd_dupSer_newSOP() throws Exception {	// #25
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_dupSer_newSOP();
		doUIDTestCase("25", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_newStd_dupSer_exiSOP() throws Exception {	// #26
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_dupSer_exiSOP();
		doUIDTestCase("26", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_newStd_dupSer_dupSOP() throws Exception {	// #27
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_newStd_dupSer_dupSOP();
		doUIDTestCase("27", info, false, false, true);
	}
	
	@Test
	public void testCaseP1O1_exiStd_exiSer_illSOP() throws Exception {	// #28
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_exiSer_illSOP();
		doUIDTestCase("28", info, false, false, true);
	}
	@Test
	public void testCaseP1O1_exiStd_illSer_newSOP() throws Exception {	// #29
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_exiStd_illSer_newSOP();
		doUIDTestCase("29", info, false, true, false);
	}
	@Test
	public void testCaseP1O1_illStd_newSer_newSOP() throws Exception {	// #30
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_illStd_newSer_newSOP();
		doUIDTestCase("30", info, true, false, false);
	}
	@Test
	public void testCaseP1O1_illStd_illSer_illSOP() throws Exception {	// #31
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_illStd_illSer_illSOP();
		doUIDTestCase("31", info, false, true, true);
	}
	@Test
	public void testCaseP1O1_illStd_illSer_maxSOP() throws Exception {	// #32
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_illStd_illSer_maxSOP();
		doUIDTestCase("32", info, false, false, false);
	}
	@Test
	public void testCaseP1O1_illStd_illSer_illSOP2() throws Exception {	// #33
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_illStd_illSer_illSOP2();
		doUIDTestCase("33", info, true, true, true);
	}
	@Test
	public void testCaseP1O1_illStd_illSer_illSOP23() throws Exception { // #34
		UIDCheckInfo info = HISDataObjects.UIDCheckForCaseP1O1_illStd_illSer_illSOP3();
		doUIDTestCase("34", info, true, true, false);
	}

	private static Boolean repeatRun=true; // turn this on when 2nd, .. run applies

	//------ uniform UID test routine 2 (no remembering and decent exit!) ---------------------
	private void doUIDTestCase(String caseText, UIDCheckInfo info, boolean stdLogged, boolean serLogged, boolean rerunLogged) throws Exception
	{
		UIDCheckResults stdRes = new UIDCheckResults("Study UID check " + caseText,
				UIDCheckDataSource.checkStudyUID(connection, info),
				info.getStudyInstanceUID());
		if (stdLogged && repeatRun)
			assertTrue(stdRes.getRpcReturn().startsWith("1"));
		else
			assertTrue(stdRes.getRpcReturn().startsWith(info.getStudyResult()));
		if (repeatRun) {
			if (stdRes.isDuplicateUID() || stdRes.isIllegalUID()) {
				if (!info.getNewStudyIUID().isEmpty()) // expected Study UID is not empty string
					assertTrue(stdRes.getNewUID().equals(info.getNewStudyIUID()));
			}
		}
		UIDCheckResults serRes = new UIDCheckResults("Series UID check " + caseText,
				UIDCheckDataSource.checkSerUID(connection, info),
				info.getSeriesInstanceUID());
		if (serLogged && repeatRun)
			assertTrue(serRes.getRpcReturn().startsWith("1"));
		else
			assertTrue(serRes.getRpcReturn().startsWith(info.getSeriesResult()));
		if (repeatRun) {
			if (serRes.isDuplicateUID() || serRes.isIllegalUID()) {
				if (!info.getNewSeriesIUID().isEmpty()) // expected Series UID is not empty string
					assertTrue(serRes.getNewUID().equals(info.getNewSeriesIUID()));
			}
		}
		UIDCheckResults sopRes = new UIDCheckResults("SOP UID check " + caseText,
				UIDCheckDataSource.checkSOPUID(connection, info),
				info.getSOPInstanceUID());
		if (rerunLogged && repeatRun)
			assertTrue(sopRes.getRpcReturn().startsWith("2"));
		else
			assertTrue(sopRes.getRpcReturn().startsWith(info.getSopIResult()));
		if (repeatRun) {
			if (sopRes.isDuplicateUID() || sopRes.isIllegalUID()) {
				if (!info.getNewsopIUID().isEmpty()) // expected SOP Instance UID is not empty string
					assertTrue(sopRes.getNewUID().equals(info.getNewsopIUID()));
			}
		}
	}
	//------------------------- uniform UID test routine #1 ---------------------------------
//	private void doUIDTestCase(String caseText, UIDCheckInfo info) throws Exception
//	{
//		UIDCheckResults stdRes = new UIDCheckResults("Study UID check " + caseText,
//				UIDCheckDataSource.checkStudyUID(connection, info),
//				info.getStudyInstanceUID());
//		assertTrue(stdRes.getRpcReturn().equals(info.getStudyResult()));
//		if (stdRes.isDuplicateUID() || stdRes.isIllegalUID()) { 
//			// **** use new Study UID *****
//			info.setStudyInstanceUID(stdRes.getNewUID());
//		} else if (stdRes.isFatalError())
//			return; // graceful quit
//		UIDCheckResults serRes = new UIDCheckResults("Series UID check " + caseText,
//				UIDCheckDataSource.checkSerUID(connection, info),
//				info.getSeriesInstanceUID());
//		assertTrue(serRes.getRpcReturn().equals(info.getSeriesResult()));
//		if (serRes.isDuplicateUID() || serRes.isIllegalUID()) { 
//			// **** use new Series UID *****
//			info.setSeriesInstanceUID(serRes.getNewUID());
//		}  else if (serRes.isFatalError())
//			return; // graceful quit
//		UIDCheckResults sopRes = new UIDCheckResults("SOP UID check " + caseText,
//				UIDCheckDataSource.checkSOPUID(connection, info),
//				info.getSOPInstanceUID());
//		assertTrue(sopRes.getRpcReturn().equals(info.getSopIResult()));
//	}
}
