/**
 * Created on Sep 22, 2009
 */
package p34.lookup;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;
import p34.uid.CheckUIDTests;
import p34.uid.HISDataObjects;
import p34.uid.PatientStudyInfo;
import p34.uid.UIDCheckDataSource;

/**
 *
 *
 *
 * @author vhaiswpeterb
 *
 */
public class CheckLookupTests extends BaseTest {

	private static Logger logger = LogManager.getLogger(CheckUIDTests.class);

//	/*
//	@Test
//	public void testPatientLookup() throws Exception
//	{
//		//	test one patient at a time
//		//								   DFN         NAME						SSN			BDate	  Sex  ICN
//		PatientInfo p1 =  new PatientInfo("1011", "PATIENT^ONEZEROONEONE", "000-00-1011", "19450610", "M", "");
//		String[] resList = UIDCheckDataSource.patientLookup(connection, p1);
//		dumpResultLines("Patient Lookup", resList);
//
//		// PatientInfo p1 =  new PatientInfo("1011", "PATIENT,ONEZEROONEONE", "000-00-1011", "19450610", "M", "");
//		// String[] resList = UIDCheckDataSource.patientLookup(connection, p1);
//		// dumpResultLines("Patient Lookup", resList);
//	}
//	
//	@Test
//	public void testStudyLookup() throws Exception
//	{
//		//	test one study at a time
//		//							   ACC#         ImgSrv
//		StudyInfo s1 =  new StudyInfo("021104-2374", "RAD");
//		String[] resList = UIDCheckDataSource.studyLookup(connection, s1);
//		dumpResultLines("Study Lookup", resList);
//
////		StudyInfo s1 =  new StudyInfo("021104-2374", "RAD");
////		String[] resList = UIDCheckDataSource.studyLookup(connection, s1);
////		dumpResultLines("Study Lookup", resList);
//		
//	}
//*/
	
	@Test
	public void testPatientStudyCombinedLookup() throws Exception
	{
		//	test one patient at a time
		//
		PatientStudyInfo ps1 =  HISDataObjects.PatientStudyForCase310();
		String[] resList1 = UIDCheckDataSource.patientStudyLookup(connection, ps1);
		dumpResultLines("Patient Study Lookup", resList1);

//		PatientStudyInfo ps2 =  HISDataObjects.PatientStudyForCase310();
//		ps2.setPDFN("");
//		ps2.setPICN("");
//		String[] resList2 = UIDCheckDataSource.patientStudyLookup(connection, ps2);
//		dumpResultLines("Patient Study Lookup", resList2);
	}

	@Test
	public void testBadCaseNumber() throws Exception
	{
		//	test one patient at a time
		//
		PatientStudyInfo ps1 =  HISDataObjects.badCaseNumber();
		String[] resList1 = UIDCheckDataSource.patientStudyLookup(connection, ps1);
		dumpResultLines("Patient Study Lookup", resList1);

	}
	@Test
	public void testBadPID() throws Exception
	{
		//	test one patient at a time
		//
		PatientStudyInfo ps1 =  HISDataObjects.badPID();
		String[] resList1 = UIDCheckDataSource.patientStudyLookup(connection, ps1);
		dumpResultLines("Patient Study Lookup", resList1);

	}

	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
	
	
	
	
}
