package p34.dicomconfig;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;
import p34.dicomconfig.*;

public class DicomConfigurationTests extends BaseTest
{
	private static Logger logger = LogManager.getLogger(DicomConfigurationTests.class);
	private static String dgwHostname = "vhaiswimgdg02"; // vhaiswimgdg01, "" returns all, except for DGWConfig

	@Test
	public void testGetDgwInstrumentList() throws Exception
	{
		String[] instList = DicomConfigDataSource.getDgwInstrumentList(connection, dgwHostname); // "" returns all

		dumpResultLines("Get Instrument info", instList);
	}
	
	@Test
	public void testGetDgwModalityList() throws Exception
	{
		String[] modList = DicomConfigDataSource.getDgwModalityList(connection,  dgwHostname); // "" returns all

		dumpResultLines("Get Modality info", modList);
	}
	
	@Test
	public void testGetDGWConfig() throws Exception
	{
		String[] modList = DicomConfigDataSource.getDGWConfig(connection, dgwHostname); // always needs a hostname

		dumpResultLines("Get DGW Config", modList);
	}
	
//	@Test
//	public void testGetSourceAESecurityMatrix() throws Exception
//	{
//		String[] modList = DicomConfigDataSource.getSourceAESecurityMatrix(connection);
//
//		dumpResultLines("Get DICOM Source AE Security Matrix", modList);
//	}
	
	@Test
	public void testCheckAETitle() throws Exception
	{
		String[] actionTable = DicomConfigDataSource.getCheckAETitle(connection, "CPT_SCU", "660");

		dumpResultLines("Check AE Title", actionTable);
	}

	@Test
	public void testGetAESecMxEntry() throws Exception
	{
		String[] actionTable = DicomConfigDataSource.getAESecMxEntry(connection, "CPT-SCU", "660");

		dumpResultLines("Get AE Entry", actionTable);
	}

	@Test
	public void testFindAESecMxEntry() throws Exception
	{
		String[] actionTable = DicomConfigDataSource.findAESecMxEntry(connection, "C-MOVE", "SCU", "660");

		dumpResultLines("Get AE Entry Loc", actionTable);
	}
	@Test
	public void testGetDgwUIDActiontable() throws Exception
	{
		String[] actionTable = DicomConfigDataSource.getDgwUIDActionTable(connection);

		dumpResultLines("UID Action Table for Storage", actionTable);
	}

    public static void main(String[] args) {
        if (args.length != 1)
        {
            printUsage(dgwHostname);
            //return;
            
        } else
        	dgwHostname = args[0];
        System.out.println("Hostname = '" + dgwHostname + "'");
        
        try {
        	DicomConfigurationTests dCTest= new DicomConfigurationTests();
        	dCTest.setUp();
        	dCTest.testGetDgwInstrumentList();
        	dCTest.testGetDgwModalityList();
        	dCTest.testGetDGWConfig();
        	dCTest.testCheckAETitle();
//        	dCTest.testGetSourceAESecurityMatrix();
        	dCTest.testGetDgwUIDActiontable();
        } catch (Exception e) {
        	// do nothing
        	logger.error("DICOM Config dump exception caught. ", e);
			//logger.info("DICOM Config dump exception caught. ");
        }
    }

    private static void printUsage(String host) {
        System.out.println("This program requires one argument:");
        System.out.println("  * The HDIG Hostname; '" + host + "' is substituted!");
     }

    //------------------------- dump util --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
}
