package p34.database;

import gov.va.med.imaging.rpc.impl.IConnection;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;
import p34.Utils;
import p34.DB.StorageMethodsDataSource;

/**
 * Created on Oct 09, 2009
 * 
 * @author vhaiswtittoc
 *
 */

public class StorageMethodTests extends BaseTest {
	
	private static String PatID_1="Patient=1";
	private static String PatID_2="Patient=2";

	private static String GroupID_1="GroupID=11";
	private static String GroupID_2="GroupID=12";
	private static String GroupID_3="GroupID=23";

	private static String ImgID_1="ImageID=111";
	private static String ImgID_2="ImageID=112";
	private static String ImgID_3="ImageID=123";
	private static String ImgID_4="ImageID=123";
	
	private static String StudyUID_1="StudyUID=1.2.840.113754.1.4.671.6939684.8882.1.31506.11";
	private static String StudyUID_2="StudyUID=1.2.840.113754.1.4.671.6939684.8882.1.31506.12";
	private static String StudyUID_3="StudyUID=1.2.840.113754.1.4.671.6939684.8882.1.31506.23";

	private static String SeriesUID1="SeriesUID=1.2.840.113754.1.4.671.6939684.8882.2.31506.111";
	private static String SeriesUID2="SeriesUID=1.2.840.113754.1.4.671.6939684.8882.2.31506.112";
	private static String SeriesUID3="SeriesUID=1.2.840.113754.1.4.671.6939684.8882.2.31506.123";
	private static String SeriesUID4="SeriesUID=1.2.840.113754.1.4.671.6939684.8882.2.31506.234";
	private static String SeriesUID5="SeriesUID=1.2.840.113754.1.4.671.6939684.8882.2.31506.235";
	private static String SeriesUID6="SeriesUID=1.2.840.113754.1.4.671.6939684.8882.2.31506.236";

	private static String SopIUID_1="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.1111";
	private static String SopIUID_2="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.1112";
	private static String SopIUID_3="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.1123";
	private static String SopIUID_4="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.1124";
	private static String SopIUID_5="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.1235";
	private static String SopIUID_6="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.1236";
	private static String SopIUID_7="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.2347";
	private static String SopIUID_8="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.2358";
	private static String SopIUID_9="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.2359";
	private static String SopIUID_10="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.23610";
	private static String SopIUID_11="SopIUID=1.2.840.113754.1.4.671.6939684.8882.3.31506.23611"; // for delete test

	// valid key trees:
	//   level   1   2    3    4
	//        PAT1 GR1 IMG1/2
	//        PAT1 GR2 IMG3
	//        PAT2 GR3 IMG4
	//        PAT1 ST1 SER1 SOP1/2
	//        PAT1 ST1 SER2 SOP3/4
	//        PAT1 ST2 SER3 SOP5/6
	//        PAT2 ST3 SER4 SOP7
	//        PAT2 ST3 SER5 SOP8/9
	//        PAT2 ST3 SER6 SOP10
	
	private static Logger logger = LogManager.getLogger(DBMethodTests.class);
		
	// ======================= initial KeyList tests ========================
//	private void addKeylist(String kl) throws Exception
//	{
//		String[] resList = StorageMethodsDataSource.addKeyList(connection, kl);
//		dumpResultLines("Add keyList", resList);
//	}
//	private void findKeylists(String kl) throws Exception
//	{
//		logger.info("Find KeyLists input: " + kl);
//		String[] resList = StorageMethodsDataSource.findKeyLists(connection, kl);
//		dumpResultLines("Find KeyLists", resList);
//	}
//	private void deleteKeyLists() throws Exception
//	{
//		logger.info("Delete Keylists... ");
//		String[] resList = StorageMethodsDataSource.deleteKeyLists(connection);
//		dumpResultLines("Delete keyLists", resList);
//	}
//	'at'Test
//	public void testDeleteKeyLists() throws Exception
//	// empty KeyList table
//	{
//		deleteKeyLists();
//	}
//
//	'at'Test
//	public void testKeyList_Take1() throws Exception
//	// add keylist choices
//	{
//		addKeylist(PatID_1 + "|" + GroupID_1 + "|" + ImgID_1);							// IEN=1
//		addKeylist(PatID_1 + "|" + GroupID_1 + "|" + ImgID_2);							// IEN=2
//		addKeylist(PatID_1 + "|" + GroupID_2 + "|" + ImgID_3);							// IEN=3
//		addKeylist(PatID_2 + "|" + GroupID_3 + "|" + ImgID_4);							// IEN=4
//		addKeylist(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_1);	// IEN=5
//		addKeylist(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_2);	// IEN=6
//		addKeylist(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID2 + "|" + SopIUID_3);	// IEN=7
//		addKeylist(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID2 + "|" + SopIUID_4);	// IEN=8
//		addKeylist(PatID_1 + "|" + StudyUID_2 + "|" + SeriesUID3 + "|" + SopIUID_5);	// IEN=9
//		addKeylist(PatID_1 + "|" + StudyUID_2 + "|" + SeriesUID3 + "|" + SopIUID_6);	// IEN=10
//		addKeylist(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID4 + "|" + SopIUID_7);	// IEN=11
//		addKeylist(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID5 + "|" + SopIUID_8);	// IEN=12
//		addKeylist(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID5 + "|" + SopIUID_9);	// IEN=13
//		addKeylist(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID6 + "|" + SopIUID_10);	// IEN=14
//	}
//
//	'at'Test
//	public void testFindKeyLists_Take1() throws Exception
//	// add keylist choices
//	{
//		findKeylists(PatID_1 + "|" + GroupID_1 + "|" + ImgID_1); 					  //  1 = IEN 1
//		findKeylists(PatID_1 + "|" + GroupID_1); 									  //  2 = IEN 1,2
//		findKeylists(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_1);//  1 = IEN 5
//		findKeylists(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1);				  //  2 = IEN 5,6
//		findKeylists(PatID_1 + "|" + StudyUID_1);									  //  4 = IEN 5,6,7,8
//		findKeylists(PatID_1);														  //  9 = IEN 1,2,3,5,6,7,8,9,10
//		findKeylists(PatID_2);														  //  5 = IEN 4,11,12,13.14
//	}

	// ====================================================================
	private void emptyStorageDBTest() throws Exception
	// empty KeyList table
	{
		logger.info("Empty Storage DB... ");
		String[] resList = StorageMethodsDataSource.VaporizeStorage(connection, true);
		dumpResultLines("Empty Storage DB", resList);
	}
	// ====================================================================
	private void cleanStorageDBTest() throws Exception
	// empty KeyList table
	{
		logger.info("Clean Only Perishable Storage DB... ");
		String[] resList = StorageMethodsDataSource.VaporizeStorage(connection, false);
		dumpResultLines("Clean Only Perishable Storage DB", resList);
	}

	// =============================== 1 RetPol ====================================
	private void createRetPolTest(String archDurYrs, String archDurTriggers, Integer minArchCopies,
			Integer minOffsiteCopies, String dispName, String businessKey, String activeFlag) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createRetPol(connection, 
				archDurYrs, archDurTriggers, minArchCopies, minOffsiteCopies, dispName, businessKey, activeFlag);
		dumpResultLines("Create RetPol", resList);
	}
	private void getAllRetPolsTest() throws Exception
	{
		String[] resList = StorageMethodsDataSource.getAllRetPols(connection);
		dumpResultLines("Get All RetPols", resList);
	}

	// =============================== 2 ArtiDesc ==================================
	private void createADTest(Integer retPolFK, String artiType, String artiFormat,	String fileExt, Boolean isActive) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createAD(connection, retPolFK, artiType, artiFormat, fileExt, isActive);
		dumpResultLines("Create ArtifactDescriptor", resList);
	}
	private void setADRetPolTest(Integer adPK, Integer retPolFK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.setADRetPol(connection, adPK, retPolFK);
		dumpResultLines("Set AD RetPol", resList);
	}
	private void getAllADsTest() throws Exception
	{
		String[] resList = StorageMethodsDataSource.getAllADs(connection);
		dumpResultLines("Get All Artifact Descriptors", resList);
	}
	
	// =============================== 3 ArtiKeyList ==============================
	private void createAKLTest(String keyList) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createAKL(connection, keyList);
		dumpResultLines("Create Artifact KeyList", resList);
	}
	private void getAKLTest(Integer klPK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getAKL(connection, klPK);
		dumpResultLines("Get Artifact KeyList", resList);
	}
	private void deleteAKLTest(Integer klPK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.deleteAKL(connection, klPK);
		dumpResultLines("Delete Artifact KeyList", resList);
	}

	// =============================== 4 Artifact =================================
	private void createArtifactTest(String aToken, Integer adFK, Integer ifFK, String kList, Integer byteSize,
			  String crc, String createdBy, String creDT) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createArtifact(connection, aToken, adFK, ifFK, kList, byteSize, crc, createdBy, creDT);
		dumpResultLines("Create Artifact", resList);
	}
	private void updateArtifactTest(Integer aPK, Integer byteSize, String crc) throws Exception
	{
		String[] resList = StorageMethodsDataSource.updateArtifact(connection, aPK, byteSize, crc);
		dumpResultLines("Update Artifact", resList);
	}
	private void getArtifactTest(String aToken) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getArtifact(connection, aToken);
		dumpResultLines("Get Artifact", resList);
	}
	private void getArtifactAndInstancesTest(String aToken) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getArtifactAndInstances(connection, aToken);
		dumpResultLines("Get Artifact And Instances", resList);
	}
	private void getFullArtifactGraphTest(String aToken) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getFullArtifactGraph(connection, aToken);
		dumpResultLines("Get Full Artifact Graph", resList);
	}
	private void getArtifactAndInstancesByKeyListTest(String[] keyList) throws Exception
	{
		String[] resList = StorageMethodsDataSource.GetArtifactAndInstancesByKeyList(connection, keyList);
		dumpResultLines("Get Artifact And Instances By KeyList", resList);
	}
	private void getArtifactAndInstancesByPKTest(Integer aPK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.GetArtifactAndInstancesByPK(connection, aPK);
		dumpResultLines("Get Artifact And Instances By PK", resList);
	}

	// =============================== 5 Artifact RetPol ============================
	private void createARetPolTest(Integer aPK, Integer retpolPK,
								   /* Boolean isActive, */ Boolean isSatisfied, String SatisfiedDT) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createARetPol(connection, aPK, retpolPK, /* false, "" */ "20110923.175934");
		dumpResultLines("Create Artifact RetPol", resList);
	}
	private void updateARetPolTest(Integer arpPK, Boolean isActive, Boolean isSatisfied) throws Exception
	{
		String[] resList = StorageMethodsDataSource.updateARetPol(connection, arpPK, false /* "" */);
		dumpResultLines("Update Artifact RetPol", resList);
	}

	// =============================== 6 Place retired, existing table SiteParams now ==========
	//    siteParams is 1:1 to INSTITUTION file, but owned by Imaging, has more fields, like 
	//		CWL (Current Write Location)
	//		CWL is a pointer to the NETWORK LOCATION table entry (CWL can change frequently!)
	//		CWL can be acquired either by INSTITUTION (#4) IEN or by the same and the Station Number (field 99 in INSTITUTION file (#4) 
	private void getCWLTest(Integer institutionFK, String stationNumber) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getCWL(connection, institutionFK, stationNumber);
		dumpResultLines("Get CWL", resList);
	}		
	private void getJBWLTest(Integer institutionFK, String stationNumber) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getJBWL(connection, institutionFK, stationNumber);
		dumpResultLines("Get JB WL", resList);
	}		
	private void getNetLocDetailsTest(Integer netLocPK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.getNetLocDetails(connection, netLocPK);
		dumpResultLines("Get NetLoc Details", resList);
	}		
	// =============================== 7 Provider ===================================
	private void createProviderTest(Integer placeFK, String provType, Boolean isArchive, Boolean isPrimaryStorage) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createProvider(connection, placeFK, provType, isArchive, isPrimaryStorage);
		dumpResultLines("Create Provider", resList);
	}
	private void updateProviderTest(Integer pPK, Integer placeFK, // String provType, 
									Boolean isArchive, Boolean isPrimaryStorage,
									Boolean isActive, Boolean isWriteable) throws Exception
	{
		String[] resList = StorageMethodsDataSource.updateProvider(connection, pPK, placeFK,
				isArchive, isPrimaryStorage, isActive, isWriteable);
		dumpResultLines("Update Provider", resList);
	}
	private void getAllProvidersTest() throws Exception
	{
		String[] resList = StorageMethodsDataSource.getAllProviders(connection);
		dumpResultLines("Get All Providers", resList);
	}

	// =============================== 8 Artifact Instance ==========================
	private void createArtifactInstanceTest(Integer aFK, Integer pFK, Integer diskVolumePK, String filePath, String fileRef, String url) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createArtifactInstance(connection, aFK, pFK, diskVolumePK, filePath, fileRef, url);
		dumpResultLines("Create Artifact Instance", resList);
	}
	private void updateLastAccessDateTimeTest(Integer aiPK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.updateLastAccessDateTime(connection, aiPK);
		dumpResultLines("Update AI Last Access DateTime", resList);
	}
	
//	private void updateURLTest(Integer aiPK, String url) throws Exception
//	{
//		String[] resList = StorageMethodsDataSource.updateURL(connection, aiPK, url);
//		dumpResultLines("Update URL", resList);
//	}
	// =============================== 9 RetPolFF ===================================
	private void createRetPolFulfillmentTest(Integer arpFK, Integer aiFK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createRetPolFulfillment(connection, arpFK, aiFK);
		dumpResultLines("Create RetPol Fulfillment", resList);
	}
	
	// =============================== 10 RPPMap ====================================
	private void createRetPolProvMapTest(Integer rpFK, Integer pFK, Integer sourcePlaceFK,
				 Boolean isSynchronous, Boolean isOffsite) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createRetPolProvMap(connection, rpFK, pFK, sourcePlaceFK, isSynchronous, isOffsite);
		dumpResultLines("Create RetPol Provider Map", resList);
	}
	private void getAllRPPMapsTest() throws Exception
	{
		String[] resList = StorageMethodsDataSource.getAllRPPMaps(connection);
		dumpResultLines("Get All RetPol Provider Maps", resList);
	}
	private void updateRetPolProvMapTest(Integer rppmPK, Boolean isSynchronous, Boolean isOffsite) throws Exception
	{
		String[] resList = StorageMethodsDataSource.updateRetPolProvMap(connection, rppmPK, isSynchronous, isOffsite);
		dumpResultLines("Update RetPol Provider Map", resList);
	}
	private void deleteRetPolProvMapTest(Integer rppmPK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.deleteRetPolProvMap(connection, rppmPK);
		dumpResultLines("Delete RetPol Provider Map", resList);
	}
	
	// =============================== 11 ProvAvailty ===============================
	private void createProvAvailTest(Integer pFK, Integer srcPlacePK, String startTime, String endTime) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createProvAvail(connection, pFK, srcPlacePK, startTime, endTime);
		dumpResultLines("Create ProvAvails", resList);
	}
	private void getAllProvAvailsTest() throws Exception
	{
		String[] resList = StorageMethodsDataSource.getAllProvAvails(connection);
		dumpResultLines("Get All ProvAvails", resList);
	}
	private void updateProvAvailTest(Integer paFK, String startTime, String endTime) throws Exception
	{
		String[] resList = StorageMethodsDataSource.updateProvAvail(connection, paFK, startTime, endTime);
		dumpResultLines("Update ProvAvail", resList);
	}
	private void deleteProvAvailTest(Integer paFK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.deleteProvAvail(connection, paFK);
		dumpResultLines("Delete ProvAvail", resList);
	}
	
	// =============================== 12 Transfer Stats ============================
	private void createTransferStatsTest(Integer pFK, Integer endPointPlaceFK,
			 String startDateTime, Integer duraInMs, Integer sizeInBytes) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createTransferStats(connection, pFK, endPointPlaceFK,
				 														startDateTime, duraInMs, sizeInBytes);
		dumpResultLines("Create Transfer Statistics", resList);
	}
	
	// =============================== 13 Storage TA ================================
	private void createStorageTATest(Integer aFK, Integer pFK,
			 String status, String taType, String uName, String message) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createStorageTA(connection, aFK, pFK, status, taType, uName, message);
		dumpResultLines("Create Storage Transaction", resList);
	}
	
	// =============================== 14 Queue =====================================
	private void createQueueTest(String qName, String qType, Boolean isActive) throws Exception
	{
		String[] resList = StorageMethodsDataSource.createQueue(connection, qName, qType, isActive);
		dumpResultLines("Create Queue", resList);
	}

	// =============================== 15 Queue Msg =================================
	private void enQueueQMsgTest(Integer qFK, String message, String qMPri, String enQDT,
			  String minDeliveryDT, String expDT) throws Exception
	{
		String[] resList = StorageMethodsDataSource.enQueueQMessage(connection, qFK, message, qMPri, enQDT, minDeliveryDT, expDT);
		dumpResultLines("Create Queue Message", resList);
	}
	private void deQueueQMsgTest(Integer qFK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.deQueueQMessage(connection, qFK);
		dumpResultLines("Dequeue Queue Message", resList);
	}
	private void peekQMsgTest(Integer qFK) throws Exception
	{
		String[] resList = StorageMethodsDataSource.peekQMessage(connection, qFK);
		dumpResultLines("Peek Queue Message", resList);
	}

	// ==============================================================================
	@Test
	public void testCreateStorageDB() throws Exception
	{
		// 0
		cleanStorageDBTest(); // kills only variable data
//		// 1
//		// testCreateRetPol(Strings archDurYrs, archDurTrigs, Integers minArchCopies, minOffsiteCps, Strings dispName, businessKey)
//		createRetPolTest("75", "DD",  1, 0, "MedInfo 75", ""); // PK = 1
//		createRetPolTest("25", "LAD", 1, 0, "Medical Information Retention Policy 25", ""); // PK = 2
//		// 2
//		// testCreateAD(Integer retPolFK, String artiType, String artiFormat, String fileExt, Boolean isActive
//		createADTest(1, "MedicalImage", "DICOM", "dcm", true); 					// PK = 1
//		createADTest(1, "MedicalImageAbstract", "JPEG", "jpg", true); 			// PK = 2
//		createADTest(1, "MedicalImageTextFile", "DCM TEXT FILE", "txt", true); 	// PK = 3
//		// setADRetPolTest(Integer adPK, Integer retPolFK)
//		setADRetPolTest(1, 1);
//		setADRetPolTest(2, 2);
//		setADRetPolTest(3, 1);
//		// 3
//		// testCreateAKL(String keyList)
//		createAKLTest(PatID_1 + "|" + GroupID_1 + "|" + ImgID_1);						// PK = 1
//		createAKLTest(PatID_1 + "|" + GroupID_1 + "|" + ImgID_2);						// PK = 2
//		createAKLTest(PatID_1 + "|" + GroupID_2 + "|" + ImgID_3);						// PK = 3
//		createAKLTest(PatID_2 + "|" + GroupID_3 + "|" + ImgID_4);						// PK = 4
//		createAKLTest(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_1); // PK = 5
//		createAKLTest(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_2); // PK = 6
//		createAKLTest(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID2 + "|" + SopIUID_3); // PK = 7
//		createAKLTest(PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID2 + "|" + SopIUID_4); // PK = 8
//		createAKLTest(PatID_1 + "|" + StudyUID_2 + "|" + SeriesUID3 + "|" + SopIUID_5); // PK = 9
//		createAKLTest(PatID_1 + "|" + StudyUID_2 + "|" + SeriesUID3 + "|" + SopIUID_6); // PK = 10
//		createAKLTest(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID4 + "|" + SopIUID_7); // PK = 11
//		createAKLTest(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID5 + "|" + SopIUID_8); // PK = 12
//		createAKLTest(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID5 + "|" + SopIUID_9); // PK = 13
//		createAKLTest(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID6 + "|" + SopIUID_10); // PK = 14
//		createAKLTest(PatID_2 + "|" + StudyUID_3 + "|" + SeriesUID6 + "|" + SopIUID_11); // PK = 15
//		getAKLTest(15);
//		deleteAKLTest(15);
//		getAKLTest(15);
//		// 6
//		// testCWLTest(Integer institutionFK)
//		getCWLTest(589, null); // "Kansas City" in INSTITUTION (#4) file
//		getCWLTest(677, null); // "Topeka"
//		getCWLTest(null, "660AA"); // "Salt Lake DOM"
//		getJBWLTest(589, null); // "Kansas City" in INSTITUTION (#4) file
//		getJBWLTest(677, null); // "Topeka"
//		getJBWLTest(null, "660AA"); // "Salt Lake DOM"
//		// getNetLocDetailsTest(Integer netLocFK)
//		getNetLocDetailsTest(66); // "Kansas City" RAID?
//		getNetLocDetailsTest(2); // "Salt Lake DOM" RAID
//		// 7
//		// testCreateProvider(Integer placeFK, String provType, Boolean isArchive, Boolean isPrimaryStorage)
//		createProviderTest(1, "RAID", false, true); // KC RAID (cwl1) -- PK 1
//		createProviderTest(1, "JukeBox", true, true); // KC JB (cwl2) -- PK 2 
//		createProviderTest(2, "RAID", true, true); // Topeka RAID (cwl3) -- PK 3
//		// updateProviderTest(Integer pPK, Integer placeFK, Boolean isArchive, Boolean isPrimaryStorage, Boolean isActive, Boolean isWriteable)
//		updateProviderTest(1, 1, false, true, true, true);
//		updateProviderTest(2, 1, true, false, true, true);
//		updateProviderTest(3, 1, false, true, true, true);
//		// 10
//		// testCreateRetPolProvMap(Integer rpFK, Integer pFK, Integer sourcePlaceFK, Boolean isSynchronous, Boolean isOffsite)
//		createRetPolProvMapTest(2, 1, 1, false, false); // rp2p1cwl1 -- PK 1
//		createRetPolProvMapTest(2, 3, 2, false, true);  // rp2p3cwl2 -- PK 2
//		createRetPolProvMapTest(1, 2, 1, false, false); // rp2p2cwl1 -- PK 3
//		createRetPolProvMapTest(1, 2, 2, true, false);  // rp2p3cwl2 -- PK 4
//		createRetPolProvMapTest(1, 2, 1, true, true);   // rp2p3cwl1 -- PK 5 for delet test 
//		// updateRetPolProvMapTest(Integer rppmPK, Boolean isSynchronous, Boolean isOffsite)
//		updateRetPolProvMapTest(1, true, false);
//		updateRetPolProvMapTest(3, true, false);
//		updateRetPolProvMapTest(4, false, true);
//		// deleteRetPolProvMapTest(Integer rppmPK)
//		deleteRetPolProvMapTest(5);
//		// 11
//		// testCreateProvAvail(Integer pFK, Integer srcPlacePK, String startTime, String endTime)
//		createProvAvailTest(2, 1, "19000101.180000", "19000101.070000"); // PK 1
//		createProvAvailTest(3, 2, "19000101.180000", "19000101.070000"); // PK 2
//		// updateProvAvailTest(Integer paFK, String startTime, String endTime)
//		updateProvAvailTest(1, "19000101.193000", "19000101.063000");
//		// deleteProvAvailTest(Integer paFK)
//		deleteProvAvailTest(2);
//		// 14
//		// createQueueTest(String qName, String qType, Boolean isActive)
//		createQueueTest("Async Storage Request Queue", "ASynch", true); // PK 1
//		createQueueTest("Test QUEUE", "ASynch", false);   // PK 2
		
		// get tests
		getAllRetPolsTest(); 	// 1
		getAllADsTest(); 		// 2
		getAllProvidersTest(); 	// 7
		getAllRPPMapsTest(); 	// 10
		getAllProvAvailsTest(); // 11
	}
	
	@Test
	public void testStorageDB() throws Exception
	{
//		// 4
//		// testCreateArtifact(String aToken, Integer adFK, Integer ifFK, String kList, Integer byteSize, String crc, String createdBy);
//		createArtifactTest("MYTOKEN00001", 1, 1, PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_1, 0, "", "Master MS", "20110902.155934"); // DCM, KL5 -- PK 1
//		createArtifactTest("MYTOKEN00002", 3, 2, PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_1, 0, "", "Master MS", "20110902.155935");  // TXT, KL5 -- PK 2
//		createArtifactTest("MYTOKEN00003", 2, 3, PatID_1 + "|" + StudyUID_1 + "|" + SeriesUID1 + "|" + SopIUID_1, 37, "42FD205673", "Master MS", "20110902.155936");  // JPG, KL5 -- PK 3
//		createArtifactTest("MYTOKEN00004", 2, 4, PatID_1 + "|" + GroupID_1 + "|" + ImgID_1, null, null, "Joe Capture", "20110902.155900");  // JPG, KL1 -- PK 4
//		// updateArtifactTest(Integer aPK, Integer byteSize, String crc) 
//		updateArtifactTest(1, 6734987, "2DCF4200001"); 
//		updateArtifactTest(2, 4728, "2D67800002"); 
//		updateArtifactTest(3, 3728, "42FD200003"); 
//		updateArtifactTest(4, 6286, "573F100003"); 
//		// 5 
//		// testCreateARetPol(String aPK, String retpolPK, Boolean isSatisfied, String SatisfiedDT);
//		createARetPolTest(1, 1, false, ""); // a1rp1 unsatisfied  -- PK 1
//		createARetPolTest(1, 2, false, ""); // a1rp2 unsatisfied  -- PK 2
//		createARetPolTest(2, 1, false, ""); // a2rp1 unsatisfied  -- PK 3
//		createARetPolTest(2, 2, false, ""); // a2rp2 unsatisfied  -- PK 4
//		createARetPolTest(3, 1, false, ""); // a3rp1 unsatisfied  -- PK 5
//		createARetPolTest(3, 2, false, ""); // a3rp2 unsatisfied  -- PK 6
//		createARetPolTest(4, 2, false, ""); // a4rp2 unsatisfied  -- PK 7
//		// updateARetPolTest(Integer arpPK, Boolean isActive, Boolean isSatisfied)
//		updateARetPolTest(1, true, true);
//		updateARetPolTest(5, false, true);
//		updateARetPolTest(7, true, false);
//		// 8
//		// testCreateArtifactInstance(Integer aFK, Integer pFK, String url);
//		createArtifactInstanceTest(1, 1, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/imageout.dcm"); // a1p1 -- PK 1
//		createArtifactInstanceTest(1, 2, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/imageout.dcm"); // a1p2 -- PK 2
//		createArtifactInstanceTest(2, 1, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a2p1 -- PK 3
//		createArtifactInstanceTest(2, 2, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a2p2 -- PK 4
//		createArtifactInstanceTest(3, 1, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a3p1 -- PK 5
//		createArtifactInstanceTest(3, 2, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a3p2 -- PK 6
//		createArtifactInstanceTest(4, 3, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/DoDTN.jpg"); // a4p3 -- PK 7
//		createArtifactInstanceTest(4, 2, "http://vhaiswimmclu4/user1$/CsabaT/ImageCache/DoDTN.jpg"); // a4p32 -- PK 8
//		// updateLastAccessDateTimeTest(Integer aiPK)
//		updateLastAccessDateTimeTest(1);
//		//sleep(1000);
//		updateLastAccessDateTimeTest(2);
//		// updateURLTest (Integer aiPK, String url)
////		updateURLTest(1, "1|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/imageout.dcm"); // a1p1 -- PK 1
////		updateURLTest(2, "2|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/imageout.dcm"); // a1p2 -- PK 2
////		updateURLTest(3, "3|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a2p1 -- PK 3
////		updateURLTest(4, "4|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a2p2 -- PK 4
////		updateURLTest(5, "5|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a3p1 -- PK 5
////		updateURLTest(6, "6|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/junk.txt"); // a3p2 -- PK 6
////		updateURLTest(7, "7|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/DoDTN.jpg"); // a4p3 -- PK 7
////		updateURLTest(8, "8|http://vhaiswimmclu4/user1$/CsabaT/ImageCache/DoDTN.jpg"); // a4p32 -- PK 8
//		// 9
//		// testCreateRetPolFulfillment(Integer arpFK, Integer aiFK);
//		createRetPolFulfillmentTest(1, 1); // arp1ai1 -- PK 1
//		createRetPolFulfillmentTest(1, 2); // arp1ai2 -- PK 2
//		createRetPolFulfillmentTest(2, 1); // arp2ai1 -- PK 3
//		createRetPolFulfillmentTest(2, 2); // arp2ai2 -- PK 4
//		createRetPolFulfillmentTest(3, 3); // arp3ai3 -- PK 5
//		createRetPolFulfillmentTest(3, 4); // arp3ai4 -- PK 6
//		createRetPolFulfillmentTest(4, 3); // arp4ai3 -- PK 7
//		createRetPolFulfillmentTest(4, 4); // arp4ai4 -- PK 8
//		createRetPolFulfillmentTest(5, 5); // arp5ai5 -- PK 9
//		createRetPolFulfillmentTest(5, 6); // arp5ai6 -- PK 10
//		createRetPolFulfillmentTest(6, 5); // arp6ai5 -- PK 11
//		createRetPolFulfillmentTest(6, 6); // arp6ai6 -- PK 12
//		createRetPolFulfillmentTest(7, 7); // arp7ai7 -- PK 13
//		createRetPolFulfillmentTest(7, 8); // arp7ai8 -- PK 14
//		// 12
//		// createTransferStatsTest(Integer pFK, Integer endPointPlaceFK, String startDateTime, Integer duraInMs, Integer sizeInBytes)
//		createTransferStatsTest(2, 2, "20100329.202345", 12340, 54654); // KC JB to Topeka (RAID)
//		createTransferStatsTest(2, 1, "20100329.202345", 16340, 54654); // Topeka to KC (RAID)
//		// 13
//		// createStorageTATest(Integer aFK, Integer pFK, String status, String taType, String uName, String message)
//		createStorageTATest(1, 1, "S", "W", "Storage SCP", "Storing DCM BLOB from Store SCP message ...");
//		createStorageTATest(2, 1, "S", "W", "Storage SCP", "Storing TXT BLOB from Store SCP message ...");
//		createStorageTATest(3, 1, "S", "W", "Storage SCP", "Storing JPEG BLOB from Store SCP message ...");
//		// 15
//		// enQueueQMsgTest(Integer qFK, String message, String qMPri, String enQDT, String minDeliveryDT, String expDT)
//		enQueueQMsgTest(1, "#1 Supposed to be a long message for an item to be transferred...",
//				"1", "20100402.220517", "20100417.235959", "20100501.000000"); // PK1 to Q#1
//		enQueueQMsgTest(1, "#2 Supposed to be a long message for an item to be transferred...",
//				"1", "20100402.220613", "20100419.235959", "20100503.000000"); // PK2 to Q#1
//		enQueueQMsgTest(2, "#3 Supposed to be another long message for another item to be transferred...",
//						"High", "20100402.220948", "20100421.235959", "20100505.000000"); // PK3 to Q#2
//		// peekQMsgTest(Integer qFK)
//		peekQMsgTest(1);
//		// deQueueQMsgTest(Integer qFK)
//		deQueueQMsgTest(1);
//		deQueueQMsgTest(3); // supposed to fail
//		
//		// more of 4
//		// getArtifactTest(String aToken),  getArtifactAndInstancesTest(String aToken), 
//		// getFullArtifactGraphTest(String aToken)    getArtifactAndInstancesByKeyListTest(Integer keyList),
//		// getArtifactAndInstancesByPKTest(Integer aPK)
//		// junk data
//		getArtifactTest("My 2 Cents");
//		getArtifactAndInstancesTest("My 2 Cents");
//		getFullArtifactGraphTest("My 2 Cents");
//		getArtifactAndInstancesByPKTest(10);
//		String[] kLPs={"abc", "def", "ghi"};
//		getArtifactAndInstancesByKeyListTest(kLPs);
//		//real data
//		getArtifactTest("MYTOKEN00003");
//		getArtifactAndInstancesTest("MYTOKEN00002");
//		getFullArtifactGraphTest("MYTOKEN00001");
//		getArtifactAndInstancesByPKTest(4);
//		kLPs= new String[]{PatID_1, StudyUID_1, SeriesUID1, SopIUID_1};
//		getArtifactAndInstancesByKeyListTest(kLPs); // 1 = IEN 5
//		kLPs= new String[]{PatID_1, StudyUID_1, SeriesUID1};
//		getArtifactAndInstancesByKeyListTest(kLPs); // 2 = IEN 5,6
//		kLPs= new String[]{PatID_1, StudyUID_1};
//		getArtifactAndInstancesByKeyListTest(kLPs); // 4 = IEN 5,6,7,8

	}
	// ============================================================================

//	@Test
//	public void testCreateARetPol() throws Exception
//	{
//		String[] resList = StorageMethodsDataSource.createARetPol(connection, "1", "2", true, "3100313.154759");
//		dumpResultLines("Create ARetPol", resList);
//	}
//
//	@Test
//	public void testCreateProvAvail() throws Exception
//	{
//		String[] resList = StorageMethodsDataSource.createProvAvail(connection, "3", "4", "20100313.194039", "20100313.154759");
//		dumpResultLines("Create ProvAvailty", resList);
//	}
//
//	@Test
//	public void testGetAllProvAvails() throws Exception
//	{
//		String[] resList = StorageMethodsDataSource.getAllProvAvails(connection);
//		dumpResultLines("Get All ProvAvails ", resList);
//	}

	
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);
		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
}
