package p34.database;

import gov.va.med.imaging.rpc.impl.StringUtils;
import gov.va.med.imaging.url.vista.VistaQuery;
import gov.va.med.imaging.url.vista.enums.VistaConnectionType;

import java.util.HashMap;
import java.util.Random;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.Assert;
import p34.test.BaseTest;

public class QueueMethodTests extends BaseTest {

	private final static String DELIMITER = "^";
	private final static String LINEBREAK_STUB = "|/|";
	private final static int M_WP_Field_Length=240;
	
	private final static String RPC_CREATE_QUEUE = "MAGVA CREATE QUEUE";
	private final static String RPC_ENQUEUE_Q_MSG = "MAGVA ENQUEUE Q MSG";
	private final static String RPC_DEQUEUE_Q_MSG = "MAGVA DEQUEUE Q MSG";
	private final static String RPC_PEEK_Q_MSG = "MAGVA PEEK Q MSG";
	private final static String RPC_GET_ALL_Q = "MAGVA GET ALL QUEUES";
	private final static String RPC_KILL_ALL = "MAGVA STORAGE KILL ALL";

	private final static String Q_PK = "PK";
	private final static String Q_NAME = "NAME";
	private final static String Q_TYPE = "QUEUE TYPE";
	private final static String Q_IS_ACTIVE = "ACTIVE";
	private final static String Q_NUM_RETRIES = "NUM RETRIES";
	private final static String Q_MSG_EXPIRATION = "EXPIRATION DATE/TIME";
	private final static String Q_MSG_MIN_DELIVERY = "EARLIEST DELIVERY DATE/TIME";
	private final static String Q_MSG_PRIORITY = "PRIORITY";
	private final static String Q_MSG_QUEUEFK = "QUEUE";
	private final static String Q_MSG_ENQUEUED_DATIME = "ENQUEUED DATE/TIME";
	
	private static String longMessage = "";
	private final static String testMessage = "<This is a 24 ch tstMsg>";

	private static Logger logger = LogManager.getLogger(DBMethodTests.class);

//	private int bytes=91100; //3 digits 91K=93184 - & 93298 ok & 92K=94208 & 93184 bumps
//	private int bytes=92928; //4 digits 92927 ok & 92928 bumps
	private int bytes=1024 * 1024; // 1 MB
	private int testQueueId;
	
	public static char[] seedText(char[] text, String seed, int firstPos, int lastPos)
	// puts seed string content at regular interval into input text array between first and last position;
	// returns text array
	{
	    for (int i = firstPos; i < (lastPos-seed.length()); i=i+M_WP_Field_Length/2)
	    {
	    	for (int j=0; j < seed.length(); j++) {
	    		text[i+j]= seed.charAt(j);
	    	}
	    }
	    return text;
	}

	public static String generateSeededString(Random rng, String characters, String seed, int length)
	// genrates an output string of length cahracters randomly filling it with characters of "characters" string, 
	// then places seed patterns into the string before returns it
	{
	    char[] text = new char[length];
	    for (int i = 0; i < length; i++)
	    {
	        text[i] = characters.charAt(rng.nextInt(characters.length()));
	    }
	    
	    return new String(seedText(text, LINEBREAK_STUB, LINEBREAK_STUB.length(), (length - LINEBREAK_STUB.length())));
	}
	
//	public QueueMethodTests(){
//		for (int i=0; i < (4*1366); i++){ // 41, 1366 is over 32k
//			longMessage += testMessage;
//		}
//	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
//		KillAll();
		String returnValue = createQueue("Test Queue1", "M", true); // For Q MSG size tests  
		String[] parts = StringUtils.Split(returnValue, DELIMITER); // create Mail Q once and use idStr below (while these 2 lines are commented)
//		String idStr="10";
		Random rng1= new Random();
		longMessage=generateSeededString(rng1, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",  LINEBREAK_STUB, bytes);
		testQueueId = Integer.parseInt(parts[2]); // idStr);
		String resultMessage = enqueue(longMessage);
//		enqueue(testMessage);
		logger.info("Enqueue Result:" + resultMessage);
	}

	@Override
	protected void tearDown() throws Exception {
		//KillAll();
		super.tearDown();
	}

	private void KillAll() throws Exception {
		VistaQuery vm = new VistaQuery(RPC_KILL_ALL);
		connection.call(vm.buildMessage(VistaConnectionType.oldStyle));
	}

	private String createQueue(String name, String type, boolean isActive)
			throws Exception {
		VistaQuery vm = new VistaQuery(RPC_CREATE_QUEUE);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put(Q_NAME, name);
		hm.put(Q_TYPE, type);
		hm.put(Q_IS_ACTIVE, isActive ? "1" : "0");
		hm.put(Q_NUM_RETRIES, "4");
		vm.addParameter(VistaQuery.ARRAY, hm);
		return connection.call(vm
				.buildMessage(VistaConnectionType.oldStyle));
	}

	private String enqueue(String message) throws Exception {
		VistaQuery vm = new VistaQuery(RPC_ENQUEUE_Q_MSG);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put(Q_MSG_QUEUEFK, Integer.toString(testQueueId));
		//hm.put(Q_MSG_EXPIRATION, "20110402.220517");
		//hm.put(Q_MSG_MIN_DELIVERY, "20100402.220517");
		hm.put(Q_MSG_PRIORITY, "50");
		String lineId;
		String[] messageParts = breakString(message, M_WP_Field_Length);
		logger.info(RPC_ENQUEUE_Q_MSG + " input (" + message.length() + " bytes:" + message);
		for (int i = 0; i < messageParts.length; i++) {
			lineId = String.format("MAGMSG%05d", i + 1);
			hm.put(lineId, messageParts[i]);
		}
		vm.addParameter(VistaQuery.ARRAY, hm);
		return connection.call(vm.buildMessage(VistaConnectionType.oldStyle));
	}

	public static String[] breakString(String input, int partLength) {
		int numParts = input.length() / partLength;
		if (input.length() % partLength > 0)
			numParts++;
		String[] parts = new String[numParts];
		int startIndex, endIndex;
		for (int i = 0; i < numParts; i++) {
			startIndex = i * partLength;
			endIndex = startIndex + partLength;
			if (endIndex > input.length()){
				endIndex = input.length();
			}
			parts[i] = input.substring(i * partLength, endIndex);
		}

		return parts;
	}
// remove comments from next 4 tests for general Q tests !!!
//	@Test
//	public void testCreateQueue() throws Exception {
//		logger.info("Starting " + RPC_CREATE_QUEUE);
//		String returnValue = createQueue("Queue", "S", true);
//		logger.info(RPC_CREATE_QUEUE + " Results: " + returnValue);
//		Assert.assertTrue(returnValue.startsWith("0"));
//	}
//
//	@Test
//	public void testGetAllQueues() throws Exception {
//		logger.info("Starting " + RPC_GET_ALL_Q);
//		VistaQuery vm = new VistaQuery(RPC_GET_ALL_Q);
//		String returnValue = connection.call(vm
//				.buildMessage(VistaConnectionType.oldStyle));
//		logger.info(RPC_GET_ALL_Q + " Results: " + returnValue);
//		Assert.assertTrue(returnValue.startsWith("0"));
//	}
//
//	@Test
//	public void testEnqueue() throws Exception {
//		logger.info("Starting " + RPC_ENQUEUE_Q_MSG);
//		String returnValue = enqueue(testMessage);
//		logger.info(RPC_ENQUEUE_Q_MSG + " Results: " + returnValue);
//		Assert.assertTrue(returnValue.startsWith("0"));
//	}
//
//	@Test
//	public void testPeek() throws Exception {
//		logger.info("Starting " + RPC_PEEK_Q_MSG);
//		VistaQuery vm = new VistaQuery(RPC_PEEK_Q_MSG);
//		HashMap<String, String> hm = new HashMap<String, String>();
//		hm.put(Q_MSG_QUEUEFK, Integer.toString(testQueueId));
//		vm.addParameter(VistaQuery.ARRAY, hm);
//		String returnValue = connection.call(vm
//				.buildMessage(VistaConnectionType.oldStyle));
//		logger.info(RPC_PEEK_Q_MSG + " Results: " + returnValue);
//		Assert.assertTrue(returnValue.startsWith("0"));
//	}

	@Test
	public void testDequeue() throws Exception {
		logger.info("Starting " + RPC_DEQUEUE_Q_MSG);
		VistaQuery vm = new VistaQuery(RPC_DEQUEUE_Q_MSG);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put(Q_MSG_QUEUEFK, Integer.toString(testQueueId));
		vm.addParameter(VistaQuery.ARRAY, hm);
		String returnValue = connection.call(vm
				.buildMessage(VistaConnectionType.oldStyle));
		logger.info(RPC_DEQUEUE_Q_MSG + " Results: " + ((returnValue.length()>1024)? (returnValue.substring(0, 1024) + "..."): returnValue));
		String[] parts = StringUtils.Split(returnValue, DELIMITER);
		if (parts[0].startsWith("0") && (returnValue.length()>90)) { //(parts[2].length()>1)) {
			String output = parts[2].substring(parts[2].indexOf("MESSAGE=") + 9);
			output = output.substring(0, output.indexOf("\""));
			output = output.replaceAll(System.getProperty("line.separator"), "");
// in real code -->	output = output.replaceAll(LINEBREAK_STUB, System.getProperty("line.separator"));
//			logger.info(output);
//			parts[2] = output.replaceAll("\r\n", "");
			logger.info("(total bytes:" + output.length() + " bytes)");
			Assert.assertTrue(output.equals(longMessage));
		} else
			logger.info("Dequeue Status = " + parts[0]);
		Assert.assertTrue(returnValue.startsWith("0"));
	}
	
	
}
