package p34.database;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;
import p34.Utils;
import p34.DB.DBMethodsDataSource;
import p34.DB.InstanceFileN;
import p34.DB.PatientRef;
import p34.DB.ProcedureRef;
import p34.DB.Study;
import p34.DB.Series;
import p34.DB.SOPInstance;
import p34.DB.InstanceFile;
import gov.va.med.imaging.rpc.impl.IConnection;
import gov.va.med.imaging.url.vista.StringUtils;
import gov.va.med.imaging.url.vista.VistaQuery;
import gov.va.med.imaging.url.vista.enums.VistaConnectionType;

import java.util.HashMap;
import java.util.Random;

/**
 * Created on Sep 22, 2011
 * 
 * @author vhaiswtittoc
 *
 */

public class DDLookupTests extends BaseTest {
	
	private static Logger logger = LogManager.getLogger(DBUtilTests.class);
	private static int maxOutLines = 23; // number of outpup lines to print at a time

	private final static String RPC_FILEMAN_FIELD_LIST = "MAG FILEMAN FIELD LIST"; // generic FM Lister
	private final static String RPC_FILEMAN_FIELD_ATTS = "MAG FILEMAN FIELD ATTS"; // generic FM ATTS of a field	
	private final static String RPC_SEARCH_BY_ATTR = "MAGV SEARCH BY ATTRIBUTE"; // generic Query RPC
	
	private final static String FILENUM = "2005.61"; // PROC REF file -- M file in scope of test
	private final static Boolean NUMERIC_FIELD_ORDER = true; // A - alpha; N - numeric
	private final static String FIELDNUM = ".01"; // field number in file
	
	private final static String SEARCH_KEY1 = ".99"; // "PATIENT REFERENCE"; // search key #1 name
	private final static String SEARCH_VALUE1 = "1"; // search value #1
	private final static String SEARCH_KEY2 = ".01"; // "ACCESSION NUMBER"; // search key #2 name
	private final static String SEARCH_VALUE2 = "120310-330"; // search value #1

	private final static String input_separator = "`";
	private final static String output_separator = "\r\n";


	public static String[] getFieldList(IConnection connection,
			String fileNum, boolean numericOrder) throws Exception
	{
		VistaQuery vm = new VistaQuery(RPC_FILEMAN_FIELD_LIST);
		vm.addParameter(VistaQuery.LITERAL, fileNum);
		vm.addParameter(VistaQuery.LITERAL, numericOrder?"N":"A"); // A or N
		
		String returnValue = connection.call(vm.buildMessage(VistaConnectionType.oldStyle));
		return translateStringedResults(returnValue, output_separator);
	}
	

	public static String[] getFieldAtts(IConnection connection,
			String fileNum, String fieldNum) throws Exception
	{
		VistaQuery vm = new VistaQuery(RPC_FILEMAN_FIELD_ATTS);
		vm.addParameter(VistaQuery.LITERAL, fileNum);
		vm.addParameter(VistaQuery.LITERAL, fieldNum); 
		
		String returnValue = connection.call(vm.buildMessage(VistaConnectionType.oldStyle));
		return translateStringedResults(returnValue, output_separator);
	}

	public static String[] searchByAttr(IConnection connection, String fileNum, 
			String fieldN1, String fieldV1,
			String fieldN2, String fieldV2) throws Exception
	{
		VistaQuery vm = new VistaQuery(RPC_SEARCH_BY_ATTR);
		vm.addParameter(VistaQuery.LITERAL, fileNum);
		HashMap <String, String> hm = new HashMap <String, String>();
		hm.put("1", fieldN1 + input_separator + fieldV1);
		hm.put("2", fieldN2 + input_separator + fieldV2);
		vm.addParameter(VistaQuery.LIST, hm);
		
		String returnValue = connection.call(vm.buildMessage(VistaConnectionType.oldStyle));
		return translateStringedResults(returnValue, output_separator);
	}	

	// ===============================================================
	@Test
	public void testDumpDB() throws Exception
	{
		String[] resList = getFieldList(connection, 
				FILENUM,                  // the table (M file number)
				NUMERIC_FIELD_ORDER);     // true if "N"
		dumpResultLines("FileMan File#" + FILENUM + " Field List", resList);

	    resList = getFieldAtts(connection, 
				FILENUM,       // the table (M file number)
				FIELDNUM);     //
		dumpResultLines("FileMan File#" + FILENUM + " Field#" + FIELDNUM + " Atts", resList);

		resList = searchByAttr(connection, 
				FILENUM,                  // the table (M file number)
				SEARCH_KEY1, SEARCH_VALUE1,		// parent field and value
				SEARCH_KEY2, SEARCH_VALUE2);    // indexed field and value
		dumpResultLines("Search By Attribute", resList);
	}

	
	private static String[] translateStringedResults(String returnValue, String ResultSeparator)
	{
		String[] items = StringUtils.Split(returnValue, ResultSeparator); // StringUtils.TICK;(|) BACKTICK (`)???
		
		// trim whitespace, including CR and/or LF characters
		if(items != null)
		{
			for(int index=0; index<items.length; ++index)
			{
				items[index] = items[index].trim();
			}
		}		
		return items;
	}
	
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);
		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
		if (i==1)
			logger.info("               *** N O T H I N G *** ");
	}

}