package p34.database;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;
import p34.Utils;
import p34.DB.DBMethodsDataSource;
import p34.DB.InstanceFileN;
import p34.DB.PatientRef;
import p34.DB.ProcedureRef;
import p34.DB.Study;
import p34.DB.Series;
import p34.DB.SOPInstance;
import p34.DB.InstanceFile;
import gov.va.med.imaging.rpc.impl.IConnection;
import gov.va.med.imaging.url.vista.StringUtils;

import java.util.Random;

/**
 * Created on Oct 09, 2009
 * 
 * @author vhaiswtittoc
 *
 */

public class DBUtilTests extends BaseTest {
	
	private static Logger logger = LogManager.getLogger(DBUtilTests.class);
	private static int maxSOPLines = 5; // number of SOP lines to print for each series

	private String getArtiToken(String sopPK) throws Exception
	{
		String ifiPK="-1";
		String ifi2PK="-1";
//		String token=" | IFI ";
		String token="\n                     IFI ";
		// print original DCM entry
		String[] findResList = DBMethodsDataSource.findOriginalInstanceFile(connection, sopPK);
		if (findResList[0].startsWith("0") && (!findResList[2].startsWith("0"))) {
			ifiPK = findResList[2];
			token += ifiPK;
			String[] ifiResList = DBMethodsDataSource.getInstanceFile(connection, sopPK, ifiPK, false);
			if (ifiResList[0].startsWith("0")) {
				for (int j=1; j<(ifiResList.length-1); j++) {
					if (ifiResList[j].startsWith(DBMethodsDataSource.IFI_ARTIFACT_TOKEN))
						token += " -- token=" + ifiResList[j].substring(DBMethodsDataSource.IFI_ARTIFACT_TOKEN.length()+1);
				}
			}
			// print Icon entry if present
			findResList = DBMethodsDataSource.traverseInstanceFile(connection, sopPK, "NEXT", ifiPK);
			if (findResList[0].startsWith("0") && (!findResList[2].startsWith("0")) && (!findResList[2].equals(ifiPK))) {
				ifi2PK = findResList[2];
				token += "  " + ifi2PK;
				ifiResList = DBMethodsDataSource.getInstanceFile(connection, sopPK, ifi2PK, false);
				if (ifiResList[0].startsWith("0")) {
					for (int j=1; j<(ifiResList.length-1); j++) {
						if (ifiResList[j].startsWith(DBMethodsDataSource.IFI_ARTIFACT_TOKEN))
							token += " -- token=" + ifiResList[j].substring(DBMethodsDataSource.IFI_ARTIFACT_TOKEN.length()+1);
					}
				}
			}
				
		}
		return token;
	}
	private void dumpSOPIFILELines(String serPK) throws Exception
	{
		String sopPK="-1";
		//find first Series
		String sopInfo;
		String separe="";
		// find first Study
		String[] sopRList = DBMethodsDataSource.traverseSOPInstance(connection, serPK, "FIRST", "");
		int numLines=0;
		while ((numLines<maxSOPLines) && (sopRList[0].startsWith("0")) && !(sopRList[2].equals("0"))) {
			sopPK=sopRList[2];
			if (numLines==0)
				sopInfo = "                SOP ";
			else 
				sopInfo = "                 SOP ";
			String[] sopResList = DBMethodsDataSource.getSOPInstance(connection, serPK, sopPK, false);
			if (sopResList[0].startsWith("0")) {
				sopInfo += ((sopPK.length()<2)?" ":"") + sopPK + " -- ";
				// loop for and fill in SOP params
				for (int j=1; j<(sopResList.length-1); j++) {
					if (sopInfo.endsWith(" -- "))
						separe="";
					else
						separe="; ";
					if (sopResList[j].startsWith(DBMethodsDataSource.SOP_INSTANCE_UID))
						sopInfo +=separe + "sopIUID=" +  sopResList[j].substring(DBMethodsDataSource.SOP_INSTANCE_UID.length()+1);
					else if (sopResList[j].startsWith(DBMethodsDataSource.SOP_ORIG_INST_UID))
						sopInfo +=separe + "origIUID=" +  sopResList[j].substring(DBMethodsDataSource.SOP_ORIG_INST_UID.length()+1);
//					else if (sopResList[j].startsWith(DBMethodsDataSource.SER_MODALITY))
//						sopInfo +=separe + "mty=" +  sopResList[j].substring(DBMethodsDataSource.SER_MODALITY.length()+1);							
//					else if (sopResList[j].startsWith(DBMethodsDataSource.SER_NUM_OF_SOPIS))
//						sopInfo +=separe + "#imgs=" +  sopResList[j].substring(DBMethodsDataSource.SER_NUM_OF_SOPIS.length()+1);	
				}
			}
			sopInfo += getArtiToken(sopPK);
			System.out.println(sopInfo);
			numLines++;

			// loop if other Series exist
			sopRList = DBMethodsDataSource.traverseSOPInstance(connection, serPK, "NEXT", sopPK);
			if ((numLines>=maxSOPLines) && (sopRList[0].startsWith("0")) && !(sopRList[2].equals("0"))) 
				System.out.println("                 SOP ...");
	
		}
	}
	private void dumpSeriesGraph(String StudyPK) throws Exception
	{
		String serPK="-1";
		//find first Series
		String serInfo;
		String separe="";
		// find first Study
		String[] stdRList = DBMethodsDataSource.traverseSeries(connection, StudyPK, "FIRST", "");
		while ((stdRList[0].startsWith("0")) && !(stdRList[2].equals("0"))) {
			serPK=stdRList[2];
			serInfo = "            SER ";
			String[] serResList = DBMethodsDataSource.getSeries(connection, StudyPK, serPK, false);
			if (serResList[0].startsWith("0")) {
				serInfo += ((serPK.length()<2)?" ":"") + serPK + " -- ";
				// loop for and fill in Series params
				for (int j=1; j<(serResList.length-1); j++) {
					if (serInfo.endsWith(" -- "))
						separe="";
					else
						separe="; ";
					if (serResList[j].startsWith(DBMethodsDataSource.SER_INSTANCE_UID))
						serInfo +=separe + "serIUID=" +  serResList[j].substring(DBMethodsDataSource.SER_INSTANCE_UID.length()+1);
					else if (serResList[j].startsWith(DBMethodsDataSource.SER_ORIG_INST_UID))
						serInfo +=separe + "origIUID=" +  serResList[j].substring(DBMethodsDataSource.SER_ORIG_INST_UID.length()+1);
					else if (serResList[j].startsWith(DBMethodsDataSource.SER_MODALITY))
						serInfo +=separe + "mty=" +  serResList[j].substring(DBMethodsDataSource.SER_MODALITY.length()+1);							
					else if (serResList[j].startsWith(DBMethodsDataSource.SER_NUM_OF_SOPIS))
						serInfo +=separe + "#imgs=" +  serResList[j].substring(DBMethodsDataSource.SER_NUM_OF_SOPIS.length()+1);	
				}
			}
			logger.info(serInfo);
			dumpSOPIFILELines(serPK);

			// loop if other Series exist
			stdRList = DBMethodsDataSource.traverseSeries(connection, StudyPK, "NEXT", serPK);
		}
	}
	private void dumpStudyGraph(String paRefPK, String procRefPK) throws Exception
	{
		String studyPK="-1";
		String studyInfo;
		String separe="";
		// find first Study
		String[] stdRList = DBMethodsDataSource.traverseStudy(connection, procRefPK, "FIRST", "");
		while ((stdRList[0].startsWith("0")) && !(stdRList[2].equals("0"))) {
			studyPK=stdRList[2];
			studyInfo = "        STD ";
			String[] stdResList = DBMethodsDataSource.getStudy(connection, procRefPK, studyPK, false);
			if (stdResList[0].startsWith("0")) {
				studyInfo += ((studyPK.length()<2)?" ":"") + studyPK + " -- ";
				// loop for and fill in Study params
				for (int j=1; j<(stdResList.length-1); j++) {
					if (studyInfo.endsWith(" -- "))
						separe="";
					else
						separe="; ";
					if (stdResList[j].startsWith(DBMethodsDataSource.STD_INSTANCE_UID))
						studyInfo +=separe + "stdIUID=" +  stdResList[j].substring(DBMethodsDataSource.STD_INSTANCE_UID.length()+1);
					else if (stdResList[j].startsWith(DBMethodsDataSource.STD_ORIG_INST_UID))
						studyInfo +=separe + "origIUID=" +  stdResList[j].substring(DBMethodsDataSource.STD_ORIG_INST_UID.length()+1);
//					else if (stdResList[j].startsWith(DBMethodsDataSource.STD_MODALITIES))
//						studyInfo +=separe + "mods=" +  stdResList[j].substring(DBMethodsDataSource.STD_MODALITIES.length()+1);							
					else if (stdResList[j].startsWith(DBMethodsDataSource.STD_NUM_OF_SOPIS))
						studyInfo +=separe + "#imgs=" +  stdResList[j].substring(DBMethodsDataSource.STD_NUM_OF_SOPIS.length()+1);	
				}
			}
			logger.info(studyInfo);
		
			dumpSeriesGraph(studyPK);
			
			// loop if other studies exist
			stdRList = DBMethodsDataSource.traverseStudy(connection, procRefPK, "NEXT", studyPK);
		}
	}
	
	private void dumpProceduresGraph(String paRefPK) throws Exception
	{
		String procRefPK="-1";
		String accNum;

		// find first Proc
		String[] procRList = DBMethodsDataSource.traverseProcRef(connection, paRefPK, "FIRST", "");
		while (procRList[0].startsWith("0") && !(procRList[2].equals("0"))) {
			procRefPK=procRList[2];
			String[] procResList = DBMethodsDataSource.getAccessionNumber(connection, paRefPK, procRefPK, false);
			accNum=procResList[0].startsWith("0")?procResList[1]:"";
			logger.info("    PROC " + ((procRefPK.length()<2)?" ":"") + procRefPK + " -- acc#=" + accNum);
		
			dumpStudyGraph(paRefPK, procRefPK);
			
			// loop if other procs exist
			procRList = DBMethodsDataSource.traverseProcRef(connection, paRefPK, "NEXT", procRefPK);
		}
	}
	
	public String getPatData(String paRefPK) throws Exception
	{
		String patData="";

		String[] refList = DBMethodsDataSource.getPatientAttributes(connection, paRefPK);
		
		if (refList[0].startsWith("0")) {
			for (int i=1; i<(refList.length-2); i++) {
				if (refList[i].startsWith(DBMethodsDataSource.PAR_ID_VALUE)) {
					patData +="dfn=" +  refList[i].substring(DBMethodsDataSource.PAR_ID_VALUE.length()+1);
					String[] infoList = DBMethodsDataSource.getPatientInfo(connection, paRefPK);
					if (infoList[0].startsWith("0")) {
						for (int j=1; j<(infoList.length-1); j++) {
							if (infoList[j].startsWith(DBMethodsDataSource.PAT_NAME))
								patData +="; name=" +  infoList[j].substring(DBMethodsDataSource.PAT_NAME.length()+1);
							else if (infoList[j].startsWith(DBMethodsDataSource.PAT_SSN))
								patData +="; ssn=" +  infoList[j].substring(DBMethodsDataSource.PAT_SSN.length()+1);
							else if (infoList[j].startsWith(DBMethodsDataSource.PAR_AOF))
								patData ="aof=" +  infoList[j].substring(DBMethodsDataSource.PAR_AOF.length()+1) + "; " + patData;
							else if (infoList[j].startsWith(DBMethodsDataSource.PAT_DOB))
								patData +="; dob=" +  infoList[j].substring(DBMethodsDataSource.PAT_DOB.length()+1);							
							else if (infoList[j].startsWith(DBMethodsDataSource.PAT_SEX))
								patData +="; sex=" +  infoList[j].substring(DBMethodsDataSource.PAT_SEX.length()+1);							
						}
					}
				} else if (refList[i].startsWith(DBMethodsDataSource.PAR_AOF)) {
					patData ="aof=" +  refList[i].substring(DBMethodsDataSource.PAR_AOF.length()+1) + "; " + patData;;
				}
			}		
		}
		if (patData.isEmpty())
			patData="???";

		return patData;
	}
		
	private void dumpPatientsGraph(String paRefPKList) throws Exception
	{
		String[] paRefPKs = translateStringedResults(paRefPKList, StringUtils.COMMA);

		for (String patRefPK : paRefPKs)
		{
			String[] resList = DBMethodsDataSource.getPatientAttributes(connection, patRefPK);
			String patAtts = getPatData(patRefPK);
			logger.info("PAT " + ((patRefPK.length()<2)?" ":"") + patRefPK + " -- " + patAtts);
			dumpProceduresGraph(patRefPK);
		}
	}
    public static void main(String[] args) {
        if (args.length > 0)
        { 
        	Integer i=-1;
        	try {
        		i = Integer.valueOf(args[0]);
        	} catch (Exception e) {
               	logger.info("Illegal SOP lines parameter: " + args[0]);
        	}
        	if (i >= 0)
        		maxSOPLines = i;
        }
        try {
        	DBUtilTests dBUTest= new DBUtilTests();
        	dBUTest.setUp();
        	dBUTest.testDumpDB();
        } catch (Exception e) {
        	// do nothing
        	logger.error("DB Graph dump exception caught. ", e);
        	//logger.info("DB Graph dump exception caught. ");
        }
    }
	
	// ===============================================================
	@Test
	public void testDumpDB() throws Exception
	{
		String[] resList = DBMethodsDataSource.FileCounts(connection);
		dumpResultLines("P34 DB File Counts", resList);

		logger.info(" ===============================================================");
		String[] firstLine = translateStringedResults(resList[0], "`");
		if (!firstLine[1].equals("0")) { // db has patients
			logger.info(" Patient - Procedure - Study - Series - SOP | IFI  Graph:");
			logger.info(" ---------------------------------------------------------------");
			dumpPatientsGraph(firstLine[2]);
		} else
			logger.info("Empty DB!");
	}

	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);
		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
		if (i==1)
			logger.info("               *** N O T H I N G *** ");
	}

	private static String[] translateStringedResults(String returnValue, String ResultSeparator)
	{
		String[] items = StringUtils.Split(returnValue, ResultSeparator); // StringUtils.TICK;(|) BACKTICK (`)???
		
		// trim whitespace, including CR and/or LF characters
		if(items != null)
		{
			for(int index=0; index<items.length; ++index)
			{
				items[index] = items[index].trim();
			}
		}		
		return items;
	}

}
