package p34.database;

import gov.va.med.imaging.url.vista.VistaQuery;
import gov.va.med.imaging.url.vista.enums.VistaConnectionType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.DB.StorageMethodsDataSource;
import p34.test.BaseTest;

public class AsyncStorageRequestTestDataGenerator extends BaseTest {
	private final static String DELIMITER = "`";

	private final static String RPC_CREATE_QUEUE = "MAGVA CREATE QUEUE";
	private final static String RPC_ENQUEUE_Q_MSG = "MAGVA ENQUEUE Q MSG";
	private final static String RPC_DEQUEUE_Q_MSG = "MAGVA DEQUEUE Q MSG";
	private final static String RPC_PEEK_Q_MSG = "MAGVA PEEK Q MSG";
	private final static String RPC_GET_ALL_Q = "MAGVA GET ALL QUEUES";
	private final static String RPC_KILL_ALL = "MAGVA STORAGE KILL ALL";
	private final static String RPC_CREATE_AI = "MAGVA CREATE AINSTANCE";
	private final static String RPC_GET_ALL_SITE_PARAM_IDS = "MAGVA GET ALL SITE PARAM IDS";

	private final static String Q_PK = "PK";
	private final static String Q_NAME = "NAME";
	private final static String Q_TYPE = "QUEUE TYPE";
	private final static String Q_IS_ACTIVE = "ACTIVE";
	private final static String Q_NUM_RETRIES = "NUM RETRIES";
	private final static String Q_RETRY_DELAY_IN_SEC_ = "RETRY DELAY IN SECONDS";
	private final static String Q_TRIGGER_DELAY_IN_SEC_ = "TRIGGER DELAY IN SECONDS";
	private final static String Q_MSG_EXPIRATION = "EXPIRATION DATETIME";
	private final static String Q_MSG_MIN_DELIVERY = "MIN DELIVERY DATETIME";
	private final static String Q_MSG_PRIORITY = "PRIORITY";
	private final static String Q_MSG_PLACE_FK = "MESSAGE GROUP ID";
	private final static String Q_MSG_QUEUEFK = "QUEUE";
	private final static String Q_MSG_ENQUEUED_DATIME = "ENQUEUED DATETIME";
	private final static String ASYNC_STORAGE_REQUEST_QUEUE_NAME = "Async Storage Request Queue";
	private final static String ASYNC_ICON_QUEUE_NAME = "ASYNC_ICON_QUEUE";
	private final static String ASYNC_STORAGE_REQUEST_ERROR_QUEUE_NAME = "Async Storage Request Error Queue";
	private final static String EMAIL_QUEUE_NAME = "E-Mail Queue";
	private final static String AI_PROVIDER_FK = "STORAGE PROVIDER";
	private final static String AI_ARTIFACT_FK = "ARTIFACT";
	private final static String AI_URL = "MAGURL";
	private static Logger logger = Logger
			.getLogger(AsyncStorageRequestTestDataGenerator.class);

	private int asyncStorageRequestQueueId;
	private int asyncStorageRequestErrorQueueId;
	private int iconQueueId;
	private int emailQueueId;
	private int retentionPolicyId;
	private int artifactDescriptorId;
	private List<Integer> placeIds = new ArrayList<Integer>();
	// private List<Integer> raidProviderIds = new ArrayList<Integer>();
	private Map<Integer, Integer> placeRaidProviderMap = new HashMap<Integer, Integer>();

	public AsyncStorageRequestTestDataGenerator() {

	}

	private int configureSite(int retentionPolicyId, int placeId)
			throws Exception {
		int raidProviderId = getOrCreateProvider("RAID", placeId);
		int archiveProviderId = getOrCreateProvider("JUKEBOX", placeId);
		int raidRetentionPolicyMapId = getOrCreateRetentionPolicyProviderMap(
				retentionPolicyId, raidProviderId, true, placeId);
		int archiveRetentionPolicyMapId = getOrCreateRetentionPolicyProviderMap(
				retentionPolicyId, archiveProviderId, false, placeId);
		int archiveAvailabilityId = getOrCreateProviderAvailability(
				archiveProviderId, placeId, "20000101.0000", "20000101.2400");
		return raidProviderId;
	}

	private int createArtifact(String token, int artifactDescriptorId, int instanceFileFK,
			String keyList, int byteSize, String crc, String createdBy, String creDT)
			throws Exception {
		String[] results = StorageMethodsDataSource.createArtifact(connection,
				token, artifactDescriptorId, instanceFileFK, keyList, byteSize, crc, createdBy, creDT);
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createArtifactDescriptors(int retPolFK) throws Exception {
		String[] results = StorageMethodsDataSource.createAD(connection,
				retPolFK, "MedicalImage", "DICOM", "dcm", true);
		String[] lineParts = results[0].split(DELIMITER);
		if (lineParts[0].equals("0")) {
			results = StorageMethodsDataSource.createAD(connection, retPolFK,
					"MedicalImageAbstract", "JPEG", "jpg", true);
			// String[] lineParts2 = results[0].split(DELIMITER);
		}
		return Integer.parseInt(lineParts[2]);
	}

	private int createArtifactInstance(int artifactId, int providerId)
			throws Exception {
		String url = "2|P112Test\\TestArtifact.dcm";
		VistaQuery vm = new VistaQuery(RPC_CREATE_AI);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put(AI_ARTIFACT_FK, Integer.toString(artifactId));
		hm.put(AI_PROVIDER_FK, Integer.toString(providerId));
		hm.put(AI_URL + "001", url);
		vm.addParameter(VistaQuery.ARRAY, hm);
		String returnValue = connection.call(vm
				.buildMessage(VistaConnectionType.oldStyle)); // .newStyle
		String[] results = returnValue.split("\r\n");
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createArtifactRetentionPolicy(int artifactId,
			int retentionPolicyId) throws Exception {
		String[] results = StorageMethodsDataSource.createARetPol(connection,
				artifactId, retentionPolicyId, /* false, "" */ "20110923.175934");
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createProvider(String type, int placeId) throws Exception {
		boolean isPrimary = type.equals("RAID");
		boolean isArchive = !type.equals("RAID");
		String[] results = StorageMethodsDataSource.createProvider(connection,
				placeId, type, isArchive, isPrimary);
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createProviderAvailability(int providerId, int placeId,
			String startTime, String endTime) throws Exception {
		String[] results = StorageMethodsDataSource.createProvAvail(connection,
				providerId, placeId, startTime, endTime);
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createQueue(String queueName, String queueType,
			String numRetries, String RetryDelayInSec, String triggerDelayInSec) throws Exception {
		VistaQuery vm = new VistaQuery(RPC_CREATE_QUEUE);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put(Q_NAME, queueName);
		hm.put(Q_TYPE, queueType); // "STORAGE_REQUEST");
		hm.put(Q_IS_ACTIVE, "1");
		hm.put(Q_NUM_RETRIES, numRetries);
		hm.put(Q_RETRY_DELAY_IN_SEC_, RetryDelayInSec);
		hm.put(Q_TRIGGER_DELAY_IN_SEC_, triggerDelayInSec);
		vm.addParameter(VistaQuery.ARRAY, hm);
		String result = connection.call(vm
				.buildMessage(VistaConnectionType.oldStyle));
		String[] resultParts = result.split(DELIMITER);
		return Integer.parseInt(resultParts[2]);
	}

	private String createRequest(String token) {
		StringBuilder builder = new StringBuilder();
		builder
				.append("<gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest>\r\n");
		builder.append("<artifactToken>");
		builder.append(token);
		builder.append("</artifactToken>\r\n");
		builder.append("<numAttempts>0</numAttempts>\r\n");
		builder
				.append("</gov.va.med.imaging.exchange.business.storage.AsyncStorageRequest>\r\n");
		return builder.toString();
	}

	private int createRetentionPolicy() throws Exception {
		String[] results = StorageMethodsDataSource.createRetPol(connection,
				"75", "DD", 1, 0, "Medical Information Retention Policy 75",
				"MedInfo", "1");
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createRetentionPolicyFulfillment(int artifactInstanceId,
			int artifactRetentionPolicyId) throws Exception {
		String[] results = StorageMethodsDataSource.createRetPolFulfillment(
				connection, artifactRetentionPolicyId, artifactInstanceId);
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private int createRetentionPolicyProviderMap(int retentionPolicyId,
			int providerId, boolean isSynchronous, int placeId)
			throws Exception {
		String[] results = StorageMethodsDataSource.createRetPolProvMap(
				connection, retentionPolicyId, providerId, placeId,
				isSynchronous, false);
		String[] lineParts = results[0].split(DELIMITER);
		return Integer.parseInt(lineParts[2]);
	}

	private void createTestArtifact(int raidProviderId,
			int artifactDescriptorId, int instanceFileFK, int retentionPolicyId, int queueId,
			int placeId) throws Exception {
		double r = Math.random();
		String token = Double.toString(r);
		int artifactId = createArtifact(token, artifactDescriptorId, instanceFileFK, "Test",
				20, "ASDFSA", "Rob", "20110902.035934");
		int artifactRetentionPolicyId = createArtifactRetentionPolicy(
				artifactId, retentionPolicyId);
		int artifactInstanceId = createArtifactInstance(artifactId,
				raidProviderId);
		int retPolFulfillmentId = createRetentionPolicyFulfillment(
				artifactInstanceId, artifactRetentionPolicyId);

		// enqueue artifact
		String message = createRequest(token);
		logger.info(artifactId);
		logger.info(message);
		enqueue(queueId, message, placeId);
	}

	private String enqueue(int queueId, String message, int placeId)
			throws Exception {
		VistaQuery vm = new VistaQuery(RPC_ENQUEUE_Q_MSG);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put(Q_MSG_QUEUEFK, Integer.toString(queueId));
		hm.put(Q_MSG_PRIORITY, "50");
		hm.put(Q_MSG_PLACE_FK, Integer.toString(placeId));

		String lineId;
		String[] messageParts = QueueMethodTests.breakString(message, 240);
		for (int i = 0; i < messageParts.length; i++) {
			lineId = String.format("MAGMSG%03d", i + 1);
			hm.put(lineId, messageParts[i]);
		}
		vm.addParameter(VistaQuery.ARRAY, hm);
		return connection.call(vm.buildMessage(VistaConnectionType.oldStyle));
	}

	private int findIdOfRowContaining(String[] rows, String content) {
		for (int i = 1; i < rows.length; i++) {
			if (rows[i].contains(content)) {
				String[] lineParts = rows[i].split(DELIMITER);
				return Integer.parseInt(lineParts[0]);
			}
		}
		return 0;
	}

	private ArrayList<String> findRowsContaining(String[] rows, String content) {
		ArrayList<String> containingRows = new ArrayList<String>();
		for (int i = 0; i < rows.length; i++) {
			if (rows[i].contains(content)) {
				containingRows.add(rows[i]);
			}
		}
		return containingRows;
	}

	private String[] getAllQueues() throws Exception {
		VistaQuery vm = new VistaQuery(RPC_GET_ALL_Q);
		String results = connection.call(vm
				.buildMessage(VistaConnectionType.oldStyle));
		return results.split("\r\n");
	}

	private List<Integer> getAllSiteParamIds() throws Exception {
		ArrayList<Integer> siteParamIds = new ArrayList<Integer>();
		VistaQuery vm = new VistaQuery(RPC_GET_ALL_SITE_PARAM_IDS);
		String returnValue = connection.call(vm
				.buildMessage(VistaConnectionType.oldStyle));
		String[] rows = returnValue.split("\\r\\n");
		String[] lineParts;
		for (int i = 2; i < rows.length; i++) {
			lineParts = rows[i].split(DELIMITER);
			siteParamIds.add(Integer.parseInt(lineParts[0]));
		}
		return siteParamIds;
	}

	private int getArtifactDescriptorId() throws Exception {
		String[] results = StorageMethodsDataSource.getAllADs(connection);
		return findIdOfRowContaining(results, "MedicalImage");
	}

	private int getOrCreateArtifactDescriptors(int retPolFK) throws Exception {
		int id = getArtifactDescriptorId();
		if (id == 0)
			id = createArtifactDescriptors(retPolFK);
		return id;
	}

	private int getOrCreateProvider(String type, int placeId) throws Exception {
		int id = getProviderId(type, placeId);
		if (id == 0)
			id = createProvider(type, placeId);
		return id;
	}

	private int getOrCreateProviderAvailability(int providerId, int placeId,
			String startTime, String endTime) throws Exception {
		int id = getProviderAvailabilityId(providerId, placeId);
		if (id == 0)
			id = createProviderAvailability(providerId, placeId, startTime,
					endTime);
		return id;
	}

	private int getOrCreateQueue(String queueName, String queueType,
			String numRetries, String RetryDelayInSec, String triggerDelayInSec) throws Exception {
		int queueId = getQueueId(queueName);
		if (queueId == 0)
			queueId = createQueue(queueName, queueType, numRetries, RetryDelayInSec, triggerDelayInSec);
		return queueId;
	}

	private int getOrCreateRetentionPolicy() throws Exception {
		int id = getRetentionPolicyId();
		if (id == 0)
			id = createRetentionPolicy();
		return id;
	}

	private int getOrCreateRetentionPolicyProviderMap(int retentionPolicyId,
			int providerId, boolean isSynchronous, int placeId)
			throws Exception {
		int id = getRetentionPolicyProviderMapId(retentionPolicyId, providerId);
		if (id == 0)
			id = createRetentionPolicyProviderMap(retentionPolicyId,
					providerId, isSynchronous, placeId);
		return id;
	}

	private int getProviderAvailabilityId(int providerId, int placeId)
			throws Exception {
		String[] results = StorageMethodsDataSource
				.getAllProvAvails(connection);
		String[] lineParts = results[0].split(DELIMITER);
		int id = 0;
		if (lineParts[0].equals("0") && Integer.parseInt(lineParts[2]) > 0) {
			for (int i = 2; i < results.length; i++) {
				lineParts = results[i].split(DELIMITER);
				if (Integer.parseInt(lineParts[1]) == providerId
						&& Integer.parseInt(lineParts[2]) == placeId) {
					id = Integer.parseInt(lineParts[0]);
					break;
				}
			}
		}
		return id;
	}

	private int getProviderId(String type, int placeId) throws Exception {
		String[] results = StorageMethodsDataSource.getAllProviders(connection);
		List<String> typeRows = this.findRowsContaining(results, type);
		String[] lineParts;
		int rowPlaceId;
		for (String row : typeRows) {
			lineParts = row.split(DELIMITER);
			if (Integer.parseInt(lineParts[1]) == placeId) {
				return Integer.parseInt(lineParts[0]);
			}
		}
		return 0;
	}

	private int getQueueId(String queueName) throws Exception {
		String[] queues = getAllQueues();
		return findIdOfRowContaining(queues, queueName);
	}

	private int getRetentionPolicyId() throws Exception {
		String[] rpResults = StorageMethodsDataSource.getAllRetPols(connection);
		return findIdOfRowContaining(rpResults, "MedInfo");
	}

	private int getRetentionPolicyProviderMapId(int retentionPolicyId,
			int providerId) throws Exception {
		String[] results = StorageMethodsDataSource.getAllRPPMaps(connection);
		String[] lineParts;
		int id = 0;
		int rpId;
		int pId;
		for (int i = 2; i < results.length; i++) {
			lineParts = results[i].split(DELIMITER);
			rpId = Integer.parseInt(lineParts[1]);
			pId = Integer.parseInt(lineParts[2]);
			if (rpId == retentionPolicyId && pId == providerId) {
				id = Integer.parseInt(lineParts[0]);
				break;
			}
		}
		return id;
	}

	private void configureQueues() throws Exception {
		asyncStorageRequestQueueId = getOrCreateQueue(ASYNC_STORAGE_REQUEST_QUEUE_NAME, "S", "5", "1200", "1200");
		asyncStorageRequestErrorQueueId = getOrCreateQueue(ASYNC_STORAGE_REQUEST_ERROR_QUEUE_NAME, "E", "5", "1200", "1200");
		iconQueueId = getOrCreateQueue(ASYNC_ICON_QUEUE_NAME, "I", "3", "30", "30");
		emailQueueId = getOrCreateQueue(EMAIL_QUEUE_NAME, "M", "5", "1200", "1200"); // temporarily here for queue creation!
	}

	private void configureVistaWideStorageSettings() throws Exception {
		retentionPolicyId = getOrCreateRetentionPolicy();
		artifactDescriptorId = getOrCreateArtifactDescriptors(retentionPolicyId);
	}

	@Test
	public void testGenerateTestData() throws Exception {
		// set up configuration
		StorageMethodsDataSource.VaporizeStorage(connection, true); // kills everything!
//		placeIds = getAllSiteParamIds();
//		configureVistaWideStorageSettings();
//		configureQueues();
//
//		for (Integer placeId : placeIds) {
//			placeRaidProviderMap.put(placeId, configureSite(retentionPolicyId,
//					placeId));
//		}
//
//		for (Integer placeId : placeIds) {
//			createTestArtifact(placeRaidProviderMap.get(placeId),
//					artifactDescriptorId, 1, retentionPolicyId,
//					asyncStorageRequestQueueId, placeId);
//		}
	}
}
