package p34.correct;

import java.util.HashMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import p34.test.BaseTest;


public class DicomCorrectRLATEMultiImageTests extends BaseTest {

	private static Logger logger = LogManager.getLogger(DicomCorrectRLATEMultiImageTests.class);	

	public void testCreateCorrectRLATE1() throws Exception{
		try{
			HashMap<String, String> map1 =  CorrectDataObjects.CorrectRADOrderMultiImage1();
			String[] result1 = DicomCorrectDataSource.addToDicomCorrect(connection, map1);
			dumpResultLines("DICOM Correct Create Result1_1", result1);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}

		try{
			HashMap<String, String> map2 =  CorrectDataObjects.CorrectRADOrderMultiImage2();
			String[] result2 = DicomCorrectDataSource.addToDicomCorrect(connection, map2);
			dumpResultLines("DICOM Correct Create Result1_2", result2);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}

		try{
			HashMap<String, String> map3 =  CorrectDataObjects.CorrectRADOrderMultiImage3();
			String[] result3 = DicomCorrectDataSource.addToDicomCorrect(connection, map3);
			dumpResultLines("DICOM Correct Create Result1_3", result3);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}


	
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
	
}
