package p34.correct;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import p34.test.BaseTest;


public class DicomCorrectGetTests extends BaseTest{

	private static Logger logger = LogManager.getLogger(DicomCorrectGetTests.class);	
	
	public void testGetCorrect1() throws Exception{
		
		try{
			String[] result1 = DicomCorrectDataSource.getFromDicomCorrect(connection);
			dumpResultLines("DICOM Correct Get Result1", result1);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
	
}
