package p34.correct;

import java.util.HashMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import p34.test.BaseTest;


public class DicomCorrectDeleteTests extends BaseTest{

	private static Logger logger = LogManager.getLogger(DicomCorrectDeleteTests.class);	
	
	
	public void testDeleteCorrect1() throws Exception{
		try{
			HashMap<String, String> map1 =  CorrectDataObjects.CorrectRADOrder1SingleImage();
			logger.info("Prior: "+map1.toString());
			String[] result1 = DicomCorrectDataSource.addToDicomCorrect(connection, map1);
			dumpResultLines("DICOM Correct Setup", result1);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
		
		try{
			String path = "C:\\DICOMImage\\BP00001.dcm";
			String[] result2 = DicomCorrectDataSource.deleteFromDicomCorrect(connection, path);
			dumpResultLines("DICOM Correct Delete Result1", result2);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	public void testDeleteCorrect2() throws Exception{
		try{
			HashMap<String, String> map1 =  CorrectDataObjects.CorrectRADOrder2SingleImage();
			logger.info("Prior: "+map1.toString());
			String[] result1 = DicomCorrectDataSource.addToDicomCorrect(connection, map1);
			dumpResultLines("DICOM Correct Setup", result1);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
		
		try{
			String path = "C:\\DICOMImage\\BP00002.dcm";
			String[] result2 = DicomCorrectDataSource.deleteFromDicomCorrect(connection, path);
			dumpResultLines("DICOM Correct Delete Result2", result2);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	public void testDeleteCorrect3() throws Exception{
		try{
			HashMap<String, String> map1 =  CorrectDataObjects.CorrectRADOrder3SingleImage();
			logger.info("Prior: "+map1.toString());
			String[] result1 = DicomCorrectDataSource.addToDicomCorrect(connection, map1);
			dumpResultLines("DICOM Correct Setup", result1);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
		
		try{
			String path = "C:\\DICOMImage\\BP00003.dcm";
			String[] result2 = DicomCorrectDataSource.deleteFromDicomCorrect(connection, path);
			dumpResultLines("DICOM Correct Delete Result3", result2);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
	
	
}
