package p34.correct;

import java.util.HashMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import p34.test.BaseTest;


public class DicomCorrectCONSingleImageTests extends BaseTest{

	private static Logger logger = LogManager.getLogger(DicomCorrectCONSingleImageTests.class);	

	public void testCreateRADCorrect1() throws Exception{
		try{
			HashMap<String, String> map1 =  CorrectDataObjects.CorrectCONOrder1SingleImage();
			logger.info("Prior: "+map1.toString());
			String[] result1 = DicomCorrectDataSource.addToDicomCorrect(connection, map1);
			dumpResultLines("DICOM Correct Create Result1", result1);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	public void testCreateRADCorrect2() throws Exception{
		try{
			HashMap<String, String> map2 =  CorrectDataObjects.CorrectCONOrder2SingleImage();
			logger.info("Prior: "+map2.toString());
			String[] result2 = DicomCorrectDataSource.addToDicomCorrect(connection, map2);
			dumpResultLines("DICOM Correct Create Result2", result2);
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}
		
	public void testCreateRADCorrect3() throws Exception{
		try{
			HashMap<String, String> map3 =  CorrectDataObjects.CorrectCONOrder3SingleImage();
			logger.info("Prior: "+map3.toString());
			String[] result3 = DicomCorrectDataSource.addToDicomCorrect(connection, map3);
			dumpResultLines("DICOM Correct Create Result3", result3);
		}catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}			
	}
	
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
	
}
