package p116.audit;

import gov.va.med.imaging.exchange.business.AuditEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import p34.test.BaseTest;

public class AuditEventTests extends BaseTest {

	private static Logger logger = LogManager.getLogger(AuditEventTests.class);	

	
	public void testAddEvent1() throws Exception{
		try{
			logger.info("Logging Startup");
			AuditEvent event =  AuditDataObjects.SystemStartup1();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	
	public void testAddEvent2() throws Exception{
		try{
			logger.info("Logging Shutdown");
			AuditEvent event =  AuditDataObjects.SystemShutdown1();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	public void testAddEvent3() throws Exception{
		try{
			logger.info("Logging Startup");
			AuditEvent event =  AuditDataObjects.SystemStartup2();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	public void testAddEvent4() throws Exception{
		try{
			logger.info("Logging Shutdown");
			AuditEvent event =  AuditDataObjects.SystemShutdown1();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}
	
	
	public void testAddEvent5() throws Exception{
		try{
			logger.info("Logging Query");
			AuditEvent event =  AuditDataObjects.QueryEvent1();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	
	public void testAddEvent6() throws Exception{
		try{
			logger.info("Logging Query");
			AuditEvent event =  AuditDataObjects.QueryEvent2();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}


	public void testAddEvent7() throws Exception{
		try{
			logger.info("Logging Retrieve");
			AuditEvent event =  AuditDataObjects.RetrieveEvent1();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}

	
	public void testAddEvent8() throws Exception{
		try{
			logger.info("Logging Retrieve");
			AuditEvent event =  AuditDataObjects.RetrieveEvent2();
			String[] result1 = AuditDataSource.addEvent(connection, event);
			dumpResultLines("Audit Event Result", result1);
			if(!result1[0].equals("0")){
				fail();
			}
		}
		catch(Exception X){
			logger.error(X.getMessage());
			fail();
		}
	}


	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}

}
