package P79.SC;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

import p34.test.BaseTest;
import p34.Utils;
import P79.scommit.StorageCommitElement;
import P79.scommit.StorageCommitWorkItem;
import P79.scommit.StoreCommitDataSource;
import gov.va.med.imaging.rpc.impl.IConnection;
import gov.va.med.imaging.url.vista.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * Created on April 30, 2012
 * 
 * @author vhaiswtittoc
 *
 */

public class SCMethodTests extends BaseTest {
	
	private static int uIDs=13;
	private static String[] sopIUIDs={"1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.1",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.22",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.333",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.4444",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.555",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.66",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.7",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.88",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.999",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.1111",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.121",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.13",
									  "1.2.840.113754.1.4.671.6939684.8882.1.31506.21790.123456789.0"};

//									  123456789.123456789.123456789.123456789.123456789.123456789.1234

	private static String[] sopCUIDs={"1.2.840.10008.5.1.4.1.1.1", 		// CR
									  "1.2.840.10008.5.1.4.1.1.2", 		// CT
									  "1.2.840.10008.5.1.4.1.1.4", 		// MR
									  "1.2.840.10008.5.1.4.1.1.20",		// NM
									  "1.2.840.10008.5.1.4.1.1.128", 	// PET
									  "1.2.840.10008.5.1.4.1.1.481.1",	// RT
									  "1.2.840.10008.5.1.4.1.1.6.1",	// US
									  "1.2.840.10008.5.1.4.1.1.12.1",	// XA
									  "1.2.840.10008.5.1.4.1.1.12.2",	// RF
									  "1.2.840.10008.5.1.4.1.1.2.1",	// ECT
									  "1.2.840.10008.5.1.4.1.1.4.1",	// ECT
									  "1.2.840.10008.5.1.4.1.1.88.22",	// ESR
									  "1.2.840.10008.5.1.4.1.1.12.1.1",	// EXA
									  "1.2.840.10008.5.1.4.1.1.88.11"}; // basic Text SR

	
	private static Logger logger = LogManager.getLogger(SCMethodTests.class);
		
	// -------------------------------------------------------------
	private String submitNewSCWI(StorageCommitWorkItem scWI) throws Exception
		{
		String curSCWIID="-1";

		String[] scWILines = StoreCommitDataSource.submitSCWI(connection, scWI);
		dumpResultLines("Submit New SC WI", scWILines);
		if ((scWILines != null) && (scWILines[0].startsWith("0"))) {
			curSCWIID=scWILines[1]; // line 3 is ID
		} else
			curSCWIID="-1";
		return curSCWIID;
	}

	private void submitTest(Integer ctr, boolean doProcess) throws Exception
	{
		StorageCommitWorkItem scWI = new StorageCommitWorkItem();

		scWI.setApplicationName("AESecMx1");
		scWI.setTransactionUID("1.2.840.123456789.0.12345.1." + ctr.toString());
//		scWI.setStatus("RECEIVED");
		scWI.setResponseTimeStamp(System.currentTimeMillis()+ 24*3600*1000);
		scWI.setHostName("vhaiswimgdg02");
		scWI.setRetriesLeft(3);
		scWI.setDoProcess(doProcess);
		List<StorageCommitElement> sCElems = new ArrayList<StorageCommitElement>();

		for (int i=0; i<uIDs; i++) {
			StorageCommitElement scElem= new StorageCommitElement();
			scElem.setSopClassUid(sopCUIDs[i]);
			scElem.setSOPInstanceUID(sopIUIDs[i]);
			sCElems.add(scElem);
		}
		scWI.setElements(sCElems);
		String scWIID=submitNewSCWI (scWI);
		if (scWIID.equals("-1"))
			logger.info("ERROR adding new SC Work Item."); 
	}
	// -------------------------------------------------------------
	private String[] listTest(String hostName) throws Exception
	{
	String[] scWIIDs=null;

	String[] scWILines = StoreCommitDataSource.listSCWIs(connection, hostName);
	dumpResultLines("List SC WIs", scWILines);
	if ((scWILines != null) && (scWILines[0].startsWith("0")))
		scWIIDs=scWILines;
	return scWIIDs;
	}

	// -------------------------------------------------------------
	private boolean processOrGetTest(String scWIID, boolean process) throws Exception
	{
	boolean status=false;

	String[] scWILines = StoreCommitDataSource.processOrGetSCWI(connection, scWIID, process);
	dumpResultLines("Process Or Get SC WI", scWILines);
	if ((scWILines != null) && (scWILines[0].startsWith("0")))
		status=true;

	return status;
	}

	// -------------------------------------------------------------
	private boolean deleteTest(String scWIID) throws Exception
	{
	boolean status=false;

	String[] scWILines = StoreCommitDataSource.deleteSCWI(connection, scWIID);
	dumpResultLines("Delete SC WI", scWILines);
	if ((scWILines != null) && (scWILines[0].startsWith("0")))
		status=true;

	return status;
	}

	// -------------------------------------------------------------
	private boolean updateTest(String scWIID, String status) throws Exception
	{
	boolean success=false;

	String[] scWILines = StoreCommitDataSource.updateSCWIStatus(connection, scWIID, status);
	dumpResultLines("Update SC WI", scWILines);
	if ((scWILines != null) && (scWILines[0].startsWith("0")))
		success=true;

	return success;
	}

	// -----------------------------------------------
 
	// ===============================================================

	private void testSCWIs(int numWIs, Boolean eraseDB) throws Exception
	// test happy path with read backs of data written + empty DB?
	{
//		for (int j=1; j<=numWIs; j++) {
//			submitTest(j, false);
//		}
//		// test duplicate TA UID
//		submitTest(numWIs, false);
//		submitTest(3, false);
	
		// list SC WIs;
		String[] updateInfo = listTest("vhaiswimgdg02");

		if ((updateInfo != null) && (updateInfo[0].startsWith("0") && (updateInfo.length>1))) {
			// test update status
//			for (int j=1; j<=numWIs; j++) {
//				String status="FAILURE";
//				if (j==1) status="SUCCESS SENT";
//				else if (j==2) status="FAILURE SENT";
//				else if (j==3) status="SENDING RESPONSE FAILED";
//				String[] itemInfo= StringUtils.Split(updateInfo[j], StringUtils.STICK);
//				updateTest(itemInfo[0], status);
//			} 
		
			// test process or get
			for (int i=1; i<updateInfo.length; i++) {
				String[] itemInfo= StringUtils.Split(updateInfo[i], StringUtils.STICK);
				processOrGetTest(itemInfo[0], true);
			}
			if (eraseDB) {
				// delete SC WIs
				for (int i=1; i<updateInfo.length; i++) {
					String[] itemInfo= StringUtils.Split(updateInfo[i], StringUtils.STICK);
					deleteTest(itemInfo[0]);
				}
			}	
		}
//		deleteTest("88");	
//		deleteTest("96");	
	}

	@Test
	public void testWIs_Take1() throws Exception
	// test happy path with read backs of data written + empty DB
	{
		testSCWIs(3, false);
	}
	//------------------------- dump result utility --------------------------------------
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);
		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
		if (i==1)
			logger.info("               *** N O T H I N G *** ");
	}
}
