package p34.uid;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.url.vista.StringUtils;

public class UIDCheckResults
{
	private String rpcReturnCode;
	private String originalUID;
	private String newUID;
	private static Logger logger = LogManager.getLogger(CheckUIDTests.class);
	
	private void dumpResultLines(String resType, String[] resList)
	{
		// Write out the items
		String infoText = resType + " RPC returned:";
		logger.info(infoText);

		int i=1;
		for (String rL : resList)
		{
			logger.info(i++ + ": " + rL);
		}
	}
	public UIDCheckResults(String infoTxt, String[] returnMessage, String originalUID)
	{
		super();
		dumpResultLines(infoTxt, returnMessage);
		this.rpcReturnCode = returnMessage[0];
		this.originalUID = originalUID;
		if (isDuplicateUID()|| isIllegalUID()) {
			this.newUID = returnMessage[2];
		} else
			this.newUID = "";
	}
	
	public String getRpcReturn() {
		return rpcReturnCode;
	}
	public void setRpcReturn(String rpcRetCode) {
		this.rpcReturnCode = rpcRetCode;
	}
	public String getOriginalUID()
	{
		return originalUID;
	}
	public String getNewUID()
	{
		return newUID;
	}

	public boolean isResend() // applies for SOP level only
	{
		return rpcReturnCode.startsWith("2");
	}
	public boolean isDuplicateUID()
	{
		return rpcReturnCode.startsWith("1");
	}
	public boolean isOK(){
		return rpcReturnCode.startsWith("0");
	}
	public boolean isFatalError(){
		return rpcReturnCode.startsWith("-1");
	}
	public boolean isIllegalUID(){
		return rpcReturnCode.startsWith("-2");
	}
}

