package p34.imageNotification;

import p34.TestConfig;
import p34.dicomconfig.DicomConfigurationTests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.Charset;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageNotificationUtility
{
	private static Logger logger = LogManager.getLogger(DicomConfigurationTests.class);

	public static String notify(String request) throws IOException
	{
		String response = "";
		
		Socket socket = new Socket(TestConfig.getImageNotificationServer(), TestConfig.getImageNotificationPort());
		socket.setSoTimeout(10000);
		//BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charset.forName("US-ASCII")));
		PrintWriter out = new PrintWriter(socket.getOutputStream());
		BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			
		// Write out the message to the server
		logger.info("Request: " + request);
		out.println(request);
		out.flush();
		
		// Read the response lines from the server, and assemble them into a response
		String responseLine = "";
		while((responseLine = in.readLine()) != null)
		{
			response += responseLine + "\n";
		}

		// Close the streams and socket
		out.close();
		in.close();
		socket.close();
			
		logger.info("Response: " + response);
		return response;
		
	}
}
