/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 25, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.dicom.rdsr;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.dicom.rdsr.CTDose;
import gov.va.med.imaging.exchange.business.dicom.rdsr.Dose;
import gov.va.med.imaging.exchange.business.dicom.rdsr.FluoroDose;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class GetDoseDataServlet
extends HttpServlet
{
	private static final long serialVersionUID = -1850976585167762873L;
	private final static Logger logger = LogManager.getLogger(GetDoseDataServlet.class);

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
	{
		try
		{
			StringBuffer output = new StringBuffer();
			
			// Start the page
			output.append("<html>\n");
			output.append("<head><link rel='stylesheet' type='text/css' href='../includes/styles.css' /></head>\n");
			output.append("  <body>\n");
			output.append("  	<h1>P137 Radiology API Test Page</h1>\n");
			output.append("  	<form method='POST' action='GetDoseData'>\n");
			output.append("	  	<table>\n");
			output.append("	  		<tr>\n");
			output.append("	  			<th>Patient ID (DFN)</th>\n");
			output.append("	  			<td><input type='text' name='patientDfn'/></td>\n");
			output.append("	  		</tr>\n");
			output.append("	  		<tr>\n");
			output.append("	  			<th>Accession Number</th>\n");
			output.append("	  			<td><input type='text' name='accessionNumber'/></td>\n");
			output.append("	  		</tr>\n");
			output.append("	  	</table>\n");
			output.append("	  	<br />\n");
			output.append("	  	<input type='submit' name='search' value='Get Dose Data' />\n");
			output.append("	</form>\n");
			output.append("  </body>\n");
			PrintWriter out = response.getWriter();
			out.write(output.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		String dfn = request.getParameter("patientDfn");
		String accessionNumber = request.getParameter("accessionNumber");
		try
		{
			RDSRRouter router = RDSRContext.getRouter();
			List<Dose> doseList = router.getRadiationDoseDetails(dfn, accessionNumber);
			
			List<CTDose> ctDoseDetails = new ArrayList<CTDose>();
			List<FluoroDose> fluoroDoseDetails = new ArrayList<FluoroDose>();
			
			for (Dose dose : doseList)
			{
				if (dose instanceof CTDose)
				{
					ctDoseDetails.add((CTDose)dose);
				}
				else if (dose instanceof FluoroDose)
				{
					fluoroDoseDetails.add((FluoroDose)dose);
				}
			}
			
			String html = getResultsHtml(dfn, accessionNumber, ctDoseDetails, fluoroDoseDetails);

			PrintWriter out = response.getWriter();
			out.write(html);
		}
		catch (MethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (ConnectionException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private String getResultsHtml(String dfn, String accessionNumber, List<CTDose> ctDoseDetails, List<FluoroDose> fluoroDoseDetails)
	{
		StringBuffer output = new StringBuffer();
		
		// Start the page
		output.append("<html>\n");
		output.append("<head><link rel='stylesheet' type='text/css' href='../includes/styles.css' /></head>\n");
		output.append("<body>\n");
		
		// Add the title
		output.append("<h1>P137 Radiology API Test Page</h1>\n");
		
		output.append("  	<form method='POST' action='GetDoseData'>\n");
		output.append("	  	<table>\n");
		output.append("	  		<tr>\n");
		output.append("	  			<th>Patient ID (DFN)</th>\n");
		output.append("	  			<td><input type='text' name='patientDfn' value='" + dfn + "'/></td>\n");
		output.append("	  		</tr>\n");
		output.append("	  		<tr>\n");
		output.append("	  			<th>Accession Number</th>\n");
		output.append("	  			<td><input type='text' name='accessionNumber' value='" + accessionNumber + "'/></td>\n");
		output.append("	  		</tr>\n");
		output.append("	  	</table>\n");

		// Add the button to search again
		output.append("	  	<br />\n");
		output.append("	  	<input type='submit' name='search' value='Get Dose Data' />\n");
		output.append("	</form>\n");
		
		// Add the CT Dose results
		output.append("<h3>CT Dose Information</h3>\n");
		if (ctDoseDetails.size() == 0)
		{
			output.append("<font color='red'>&nbsp;&nbsp;<i>No CT Dose information found</i></font></br>\n");
		}
		else
		{
			output.append("<table>\n");
			output.append("<tr>\n");
			output.append("<th>Mean CTDIvol</th>\n");
			output.append("<th>DLP</th>\n");
			output.append("<th>Target Region</th>\n");
			output.append("<th>Phantom Type</th>\n");
			output.append("<th>Irradiation Event UID</th>\n");
			output.append("</tr>\n");
			
			for (CTDose dose : ctDoseDetails)
			{
				output.append("<tr>\n");
				output.append("<td>" + dose.getMeanCTDIvol() + "</td>\n");
				output.append("<td>" + dose.getDlp() + "</td>\n");
				output.append("<td>" + dose.getAnatomicTargetRegion() + "</td>\n");
				output.append("<td>" + dose.getPhantomType() + "</td>\n");
				output.append("<td>" + dose.getIrradiationEventUid() + "</td>\n");
				output.append("</tr>\n");
			}
			output.append("</table>\n");
		}
		
		// Add the Fluoro Dose results
		output.append("<h3>Fluoro Dose Information</h3>\n");
		if (fluoroDoseDetails.size() == 0)
		{
			output.append("<font color='red'>&nbsp;&nbsp;<i>No Fluoro Dose information found</i></font></br>\n");
		}
		else
		{
			output.append("<table>\n");
			output.append("<tr>\n");
			output.append("<th>Dose (RP) Total</th>\n");
			output.append("<th>Dose Area Product Total</th>\n");
			output.append("<th>Fluoro Time Total</th>\n");
			output.append("<th>Fluoro Dose (RP) Total</th>\n");
			output.append("<th>Fluoro Dose Area Product total</th>\n");
			output.append("<th>Cine Dose (RP) Total</th>\n");
			output.append("<th>Cine Dose Area Product Total</th>\n");
			output.append("<th>Cine Time</th>\n");
			output.append("</tr>\n");
			
			for (FluoroDose dose : fluoroDoseDetails)
			{
				output.append("<tr>\n");
				output.append("<td>" + dose.getDoseRpTotal() + "</td>\n");
				output.append("<td>" + dose.getDoseAreaProductTotal() + "</td>\n");
				output.append("<td>" + dose.getFluoroTimeTotal() + "</td>\n");
				output.append("<td>" + dose.getFluoroDoseRpTotal() + "</td>\n");
				output.append("<td>" + dose.getFluoroDoseAreaProductTotal() + "</td>\n");
				output.append("<td>" + dose.getCineDoseRpTotal() + "</td>\n");
				output.append("<td>" + dose.getCineDoseAreaProductTotal() + "</td>\n");
				output.append("<td>" + dose.getCineTime() + "</td>\n");
				output.append("</tr>\n");
			}
			output.append("</table>\n");
		}

		// End the page
		output.append("</body\n>");
		output.append("</html\n>");
		
		return output.toString();
	}

}
