/**
 * 
 */
package gov.va.med.imaging.musedatasource.v1;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.musedatasource.AbstractMusePatientArtifactDataSourceService;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.muse.MuseConnection;
import gov.va.med.imaging.url.muse.exceptions.MuseConnectionException;

import java.io.IOException;

import org.apache.log4j.Logger;

/**
 * @author William Peterson
 *
 */
public class MusePatientArtifactDataSourceServiceV1 
extends AbstractMusePatientArtifactDataSourceService{

	public final static String MUSE_REQUIRED_VERSION = "8.0";
	private final static String DATASOURCE_VERSION = "1";
	//WFP-This is not correct.
	public final static String SUPPORTED_PROTOCOL = "vftp";

	private final MuseConnection museConnection;
	

	/**
	 * @param resolvedArtifactSource
	 * @param protocol
	 */
	public MusePatientArtifactDataSourceServiceV1(ResolvedArtifactSource resolvedArtifactSource, String protocol) {
		super(resolvedArtifactSource, protocol);
		
		museConnection = new MuseConnection(getMetadataUrl());
	}

	@Override
	public String getDataSourceVersion() {
		return DATASOURCE_VERSION;
	}

	@Override
	protected String getRequiredMuseVersion() {
		return MUSE_REQUIRED_VERSION;
	}

	@Override
	public ArtifactResults getPatientArtifacts(RoutingToken globalRoutingToken,
			PatientIdentifier patientIdentifier, StudyFilter studyFilter,
			StudyLoadLevel studyLoadLevel, boolean includeImages,
			boolean includeDocuments) throws MethodException,
			ConnectionException {
		
		getLogger().info("getPatientArtifacts for patient (" + patientIdentifier + 
				"), StudyLoadLevel (" + studyLoadLevel + "), TransactionContext (" + 				
				TransactionContextFactory.get().getDisplayIdentity() + ").");
		if(patientIdentifier.getPatientIdentifierType().isLocal())
			throw new MethodException("Cannot use local patient identifier to retrieve remote patient information");
		String patientIcn = patientIdentifier.getValue();
		try 
		{
			museConnection.connect();			
		}
		catch(IOException ioX) 
		{
			getLogger().error("Error getting patient artifacts", ioX);
			throw new MuseConnectionException(ioX);
		}					
		if(studyFilter != null)
		{
			if(studyFilter.isStudyIenSpecified())
			{
				getLogger().info("Filtering study by study Id [" + studyFilter.getStudyId() + "]");
			}
		}
		ArtifactResults result = getProxy().getPatientArtifacts(patientIcn, studyFilter, globalRoutingToken, 
				studyLoadLevel, includeImages, includeDocuments);
		getLogger().info("getPatientArtifacts got [" + (result == null ? "0" : result.getArtifactSize()) + "] artifacts from site [" + getSite().getSiteNumber() + "]");			
		return result;
	}
	
	

}
